/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.relatorio.Gerador;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.impressao.termica.ImpressaoTermica;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public class ImprimirIdentificacaoTubo {
    public static void imprimir(Integer filial, Integer filialRequisicao, Integer codigoEstante, Integer codigoRequisicao, Integer codigoRecipienteFilho, Integer codigoSetor, Integer codigoGeladeira, String codigoPrateleira, Date dataHoraAdicaoSoroteca, Date dataVencimentoSoroteca) throws SQLException {
        int i;
        boolean agruparMultiguia;
        Statement st = Conexao.getStatement();
        boolean bl = agruparMultiguia = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), String.valueOf(filialRequisicao), String.valueOf(codigoRequisicao));
        if (st == null) {
            return;
        }
        String codigoTubo = Funcoes.preencheZero(filialRequisicao, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(codigoRequisicao, ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(codigoRecipienteFilho, ParametrosGerais.getDigitosTuboTubo());
        String codigosMultiguia = "";
        if (agruparMultiguia) {
            Integer[] aux = RecepcaoUtil.verificaMultiGuias(String.valueOf(filialRequisicao), String.valueOf(codigoRequisicao), true);
            for (i = 0; i < aux.length; ++i) {
                codigosMultiguia = codigosMultiguia + aux[i];
                if (i >= aux.length - 1) continue;
                codigosMultiguia = codigosMultiguia + ", ";
            }
        } else {
            codigosMultiguia = codigosMultiguia + codigoRequisicao;
        }
        StringBuffer buf = new StringBuffer("");
        buf.append(" select '").append(codigoTubo).append("' as codigoTubo ");
        buf.append("       ,array_to_string(array_agg(a.exa_codigo), ',') as codigosExames ");
        buf.append("       ,").append(codigoRequisicao).append(" as codigoRequisicao ");
        buf.append("       ,con.con_codigo as codigoConvenio ");
        buf.append("       ,exr.mco_codigo as codigoMaterial ");
        buf.append("       ,mco.mco_descricao as descricaoMaterial ");
        buf.append("       ,mco.mco_abreviatura as abreviaturaMaterial ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_razaosocial as razaoSocialPaciente ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,a.rec_codigo as codigoRecipientePai ");
        buf.append("       ,a.rec_kodigo as codigoRecipienteFilho ");
        buf.append("       ,recP.rec_descricao as descricaoRecipientePai ");
        buf.append("       ,recF.rec_descricao as descricaoRecipienteFilho ");
        buf.append("       ,recP.unm_codigo as unidadeRecipientePai ");
        buf.append("       ,recF.unm_codigo as unidadeRecipienteFilho ");
        buf.append("       ,cast('").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataHoraAdicaoSoroteca)).append("' as timestamp) as dataHoraAdicaoSoroteca ");
        buf.append("       ,cast('").append(Funcoes.formataData("yyyy-MM-dd", dataVencimentoSoroteca)).append("' as date) as dataVencimentoSoroteca ");
        buf.append("       ,set.set_codigo as codigoSetor ");
        buf.append("       ,set.set_descricao as descricaoSetor ");
        buf.append("       ,set.set_sigla as siglaSetor ");
        buf.append("       ,con.con_razao as razaoSocialConvenio ");
        buf.append("       ,con.con_fantasia as fantasiaConvenio ");
        buf.append("       ,gel.gel_codigo as codigoGeladeira ");
        buf.append("       ,gel.gel_descricao as descricaoGeladeira ");
        buf.append("       ,gel.set_codigo as codigoSetorGeladeira ");
        buf.append("       ,'").append(codigoPrateleira).append("' as codigoPrateleira ");
        buf.append("       ,ett.ett_codigo as codigoEstante ");
        buf.append("       ,ett.ett_linhas as linhasEstante ");
        buf.append("       ,ett.ett_colunas as colunasEstante ");
        buf.append("       ,ett.ett_identificador as identificadorEstante ");
        buf.append("       ,current_timestamp as dataHoraAtual ");
        buf.append("       , ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append("   from examerequisicaorecipiente a ");
        buf.append("   cross join estantes ett ");
        buf.append("   cross join geladeiras gel ");
        buf.append("   cross join setores set ");
        buf.append("   join requisicao req on a.fil_codigo = req.fil_codigo and a.req_codigo = req.req_codigo ");
        buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("   join examerequisicao exr on a.fil_codigo = exr.fil_codigo and a.req_codigo = exr.req_codigo and a.exa_codigo = exr.exa_codigo and a.mco_codigo = exr.mco_codigo ");
        if (ParametrosGerais.isOcultarApenasFaturamento()) {
            buf.append(" and exr.exr_situacao <> 'A' ");
        }
        buf.append("   join materialcoleta mco on exr.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo ");
        buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join recipientes recP on a.fil_codigo = recP.fil_codigo and a.rec_codigo = recP.rec_codigo ");
        buf.append("   join recipientes recF on a.fil_codigo = recF.fil_codigo and a.rec_kodigo = recF.rec_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        buf.append("  where a.fil_codigo = ").append(filialRequisicao);
        buf.append("    and a.req_codigo IN (").append(codigosMultiguia).append(") ");
        buf.append("    and a.rec_kodigo = ").append(codigoRecipienteFilho);
        buf.append("    and set.fil_codigo = ").append(filialRequisicao);
        buf.append("    and set.set_codigo = ").append(codigoSetor);
        buf.append("    and ett.fil_codigo = ").append(filial);
        buf.append("    and ett.ett_codigo = ").append(codigoEstante);
        buf.append("    and gel.fil_codigo = ").append(filial);
        buf.append("    and gel.gel_codigo = ").append(codigoGeladeira);
        buf.append("  group by a.fil_codigo ");
        buf.append("          ,con.con_codigo ");
        buf.append("          ,exr.mco_codigo ");
        buf.append("          ,mco.mco_descricao ");
        buf.append("          ,mco.mco_abreviatura ");
        buf.append("          ,pac.pac_nome ");
        buf.append("          ,pac.pac_razaosocial ");
        buf.append("          ,pac.pac_cpf ");
        buf.append("          ,a.rec_codigo ");
        buf.append("          ,recP.rec_descricao ");
        buf.append("          ,recP.unm_codigo ");
        buf.append("          ,a.rec_kodigo ");
        buf.append("          ,recF.rec_descricao ");
        buf.append("          ,recF.unm_codigo ");
        buf.append("          ,set.set_codigo ");
        buf.append("          ,set.set_descricao ");
        buf.append("          ,set.set_sigla ");
        buf.append("          ,con.con_razao ");
        buf.append("          ,con.con_fantasia ");
        buf.append("          ,gel.gel_codigo ");
        buf.append("          ,gel.gel_descricao ");
        buf.append("          ,gel.set_codigo ");
        buf.append("          ,ett.ett_codigo ");
        buf.append("          ,ett.ett_linhas ");
        buf.append("          ,ett.ett_colunas ");
        buf.append("          ,ett.ett_identificador ");
        buf.append(" , ");
        for (i = 0; i < Constantes.CAMPOS_FILIAL.length; ++i) {
            buf.append(Constantes.CAMPOS_FILIAL[i]);
            if (i >= Constantes.CAMPOS_FILIAL.length - 1) continue;
            buf.append(" , ");
        }
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        ModeloGridTable modeloDados = new ModeloGridTable(Impressao.CAMPOS_IDENTIFICACAO_TUBO);
        if (rs.next()) {
            modeloDados.addLine(new Object[Impressao.CAMPOS_IDENTIFICACAO_TUBO.length]);
            for (int i2 = 0; i2 < Impressao.CAMPOS_IDENTIFICACAO_TUBO.length; ++i2) {
                modeloDados.setValueAt(rs.getObject(Impressao.CAMPOS_IDENTIFICACAO_TUBO[i2]), modeloDados.getRowCount() - 1, i2);
            }
            String codigoLayout = String.valueOf(ParametrosGerais.getLayCodigo());
            buf.delete(0, buf.length());
            buf.append(" select lay_etiquetatubosoroteca ");
            buf.append("       ,lay_tipoetiquetatubosoroteca ");
            buf.append("   from layout ");
            buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("    and lay_codigo = ").append(codigoLayout);
            ResultSet rsLayout = Conexao.executeQuery(st, buf.toString());
            if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("lay_etiquetatubosoroteca"))) {
                String tipo = rsLayout.getString("lay_tipoetiquetatubosoroteca");
                if (tipo.equalsIgnoreCase("C")) {
                    Gerador gerador = new Gerador(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                    gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraIdentificacaoTuboSoroteca")));
                    gerador.executar(rsLayout.getString("lay_etiquetatubosoroteca"), modeloDados);
                } else if (tipo.equalsIgnoreCase("T")) {
                    ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraIdentificacaoTuboSoroteca")), false);
                    termica.setDados(modeloDados);
                    termica.imprimir(rsLayout.getString("lay_etiquetatubosoroteca"));
                }
            } else {
                Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
            }
            rsLayout.close();
        }
        rs.close();
        st.close();
    }
}

