/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.relatorio.Gerador;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ImprimirIdentificacaoEstante {
    private static int digitosEstanteFilial = 2;
    private static int digitosEstanteGeladeira = 3;
    private static int digitosEstanteCodigo = 3;

    public static int getDigitosEstanteFilial() {
        return digitosEstanteFilial;
    }

    public static int getDigitosEstanteGeladeira() {
        return digitosEstanteGeladeira;
    }

    public static int getDigitosEstanteCodigo() {
        return digitosEstanteCodigo;
    }

    public static void imprimir(String filial, String estante) throws SQLException {
        Statement st = Conexao.getStatement();
        if (st == null) {
            return;
        }
        StringBuffer buf = new StringBuffer("");
        buf.append("select ");
        buf.append(" a.ett_codigo as codigoEstante, ");
        buf.append(" a.ett_linhas as linhasEstante, ");
        buf.append(" a.ett_colunas as colunasEstante, ");
        buf.append(" a.ett_identificador as identificadorEstante, ");
        buf.append(" a.ett_pacote as pacoteEstante, ");
        buf.append(" a.ett_reutilizar as reutilizarEstante, ");
        buf.append(" a.ett_datadescarte as dataDescarteEstante, ");
        buf.append(" gel.gel_codigo as codigoGeladeira, ");
        buf.append(" gel.gel_descricao as descricaoGeladeira, ");
        buf.append(" gel.set_codigo as codigoSetorGeladeira, ");
        buf.append(" gel.usr_codigo as codigoUsuarioCriacaoGeladeira, ");
        buf.append(" gel.gel_inativa as inativaGeladeira, ");
        buf.append(" gpa.gpa_codigo as codigoPrateleira, ");
        buf.append(" '' as identificacaoEstante, ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append(" from estantes a ");
        buf.append(" join geladeirasprateleiras gpa on a.fil_codigo = gpa.fil_codigo and a.gel_codigo = gpa.gel_codigo and a.gpa_codigo = gpa.gpa_codigo ");
        buf.append(" join geladeiras gel on gpa.fil_codigo = gel.fil_codigo and gpa.gel_codigo = gel.gel_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        buf.append(" where a.fil_codigo = ").append(filial);
        buf.append("   and a.ett_codigo = ").append(estante);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        ModeloGridTable modeloDados = new ModeloGridTable(Impressao.CAMPOS_IDENTIFICACAO_ESTANTE);
        if (rs.next()) {
            modeloDados.addLine(new Object[Impressao.CAMPOS_IDENTIFICACAO_ESTANTE.length]);
            for (int i = 0; i < Impressao.CAMPOS_IDENTIFICACAO_ESTANTE.length; ++i) {
                if (DBUtil.campoNull(rs.getString(Impressao.CAMPOS_IDENTIFICACAO_ESTANTE[i]))) {
                    modeloDados.setValueAt("", modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (Impressao.CAMPOS_IDENTIFICACAO_ESTANTE[i].equals("pacoteEstante")) {
                    modeloDados.setValueAt(rs.getBoolean(Impressao.CAMPOS_IDENTIFICACAO_ESTANTE[i]) ? "Sim" : "N\u00e3o", modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (Impressao.CAMPOS_IDENTIFICACAO_ESTANTE[i].equals("reutilizarEstante")) {
                    modeloDados.setValueAt(rs.getBoolean(Impressao.CAMPOS_IDENTIFICACAO_ESTANTE[i]) ? "Sim" : "N\u00e3o", modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (Impressao.CAMPOS_IDENTIFICACAO_ESTANTE[i].equals("identificacaoEstante")) {
                    int digFilial = ImprimirIdentificacaoEstante.getDigitosEstanteFilial();
                    int digGeladeira = ImprimirIdentificacaoEstante.getDigitosEstanteGeladeira();
                    int digCodigo = ImprimirIdentificacaoEstante.getDigitosEstanteCodigo();
                    String auxFilial = rs.getString("codigoFilial");
                    String auxGeladeira = rs.getString("codigoGeladeira");
                    String auxEstante = rs.getString("codigoEstante");
                    auxFilial = StringUtil.preencheString(auxFilial, digFilial, '0', 1);
                    auxGeladeira = StringUtil.preencheString(auxGeladeira, digGeladeira, '0', 1);
                    auxEstante = StringUtil.preencheString(auxEstante, digCodigo, '0', 1);
                    modeloDados.setValueAt(auxFilial + auxGeladeira + auxEstante, modeloDados.getRowCount() - 1, i);
                    continue;
                }
                modeloDados.setValueAt(rs.getObject(Impressao.CAMPOS_IDENTIFICACAO_ESTANTE[i]), modeloDados.getRowCount() - 1, i);
            }
            String codigoLayout = String.valueOf(ParametrosGerais.getLayCodigo());
            buf.delete(0, buf.length());
            buf.append(" select lay_etiquetasoroteca, lay_tipoetiquetasoroteca from layout ");
            buf.append("  where fil_codigo = ").append(filial);
            buf.append("    and lay_codigo = ").append(codigoLayout);
            ResultSet rsLayout = Conexao.executeQuery(st, buf.toString());
            if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("lay_etiquetasoroteca"))) {
                String tipo = rsLayout.getString("lay_tipoetiquetasoroteca");
                if (tipo.equalsIgnoreCase("C")) {
                    Gerador gerador = new Gerador(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                    gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraIdentificacaoEstante")));
                    gerador.executar(rsLayout.getString("lay_etiquetasoroteca"), modeloDados);
                } else if (tipo.equalsIgnoreCase("T")) {
                    ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraIdentificacaoEstante")), false);
                    termica.setDados(modeloDados);
                    termica.imprimir(rsLayout.getString("lay_etiquetasoroteca"));
                }
            } else {
                Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
            }
            rsLayout.close();
        }
        rs.close();
        st.close();
    }
}

