/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import jalis.comum.CBOS;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.TabelaANS;
import jalis.comum.Tipos;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.util.faturamento.LinhasTabela;
import jalis.laboratorio.util.faturamento.eletronico.Tiss;
import jalis.laboratorio.util.faturamento.eletronico.tiss.VersaoTiss;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoGuia;
import jalis.laboratorio.util.impressao.TelaGuias;
import jalis.relatorio.Gerador;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Window;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.postgresql.util.PGInterval;

public class ImprimirGuia {
    private static final String[] ADICIONAIS_GUIA = new String[]{"descricaoExame", "ambExame", "chExame", "valorExame", "valorMateriaisExame", "descricaoMaterial", "abreviaturaMaterial", "valorCH", "autorizacaoExame", "custoCBHPMExame", "ucoCBHPMExame", "valorPorteCBHPMExame", "porteCBHPMExame", "porteCBHPMExame", "valorExameConvenio", "guiaExameRequisicao", "codigoExamePrincipal", "descricaoExamePrincipal", "descricaoMaterialPrincipal", "abreviaturaMaterialPrincipal", "ambExamePrincipal", "chExamePrincipal", "valorExamePrincipal", "valorExameConvenioPrincipal", "dataAutorizacaoExame", "validadeAutorizacaoExame", "valorMateriaisExamePrincipal", "custoCBHPMExamePrincipal", "ucoCBHPMExamePrincipal", "valorPorteCBHPMExamePrincipal", "porteCBHPMExamePrincipal", "porteCBHPMExamePrincipal", "qtdeExame", "valorUnitarioExame", "dataGuiaExameRequisicao", "validadeGuiaExameRequisicao", "novaValidadeGuiaExameRequisicao", "chExameOriginal", "chExamePrincipalOriginal", "valorCHOriginal", "valorExameConvenioFatura"};
    private static final int QTDE_CAMPOS_GUIA = ADICIONAIS_GUIA.length;

    public static void imprimir(Window owner, String filial, String requisicao, boolean imprimirTodas, int tipoGuia) throws SQLException {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        Statement st3 = Conexao.getStatement();
        Statement stTemp = Conexao.getStatement();
        ImprimirGuia guia = new ImprimirGuia();
        guia.imprimir(false, owner, filial, requisicao, imprimirTodas, tipoGuia, st, st2, st3, stTemp, ParametrosGerais.getOrdenarSetor(), ParametrosGerais.getOrdemComprovante(), ParametrosGerais.getPrecoMetodologia(), ParametrosGerais.getQtdeExamesCC(), ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
        Conexao.fecharStatement(st, st2, st3, stTemp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetornoImpressaoGuia imprimir(boolean isColetaWeb, Window owner, String filial, String requisicao, boolean imprimirTodas, int tipoGuia, Statement st, Statement st2, Statement st3, Statement stTemp, boolean ordenarSetor, String ordemComprovante, boolean precoMetodologia, int qtdeExamesCC, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws SQLException {
        if (st == null || st3 == null || st2 == null) {
            return null;
        }
        RetornoImpressaoGuia retorno = new RetornoImpressaoGuia();
        ResultSet rsGuia = null;
        ResultSet rsGuiaDistinct = null;
        ResultSet rsQtde = null;
        try {
            StringBuilder buf = new StringBuilder("");
            buf.append(" select case when gp.fil_codigo is not null then gp.exg_guia else exr.exr_guia end as codigoGuia ");
            buf.append("       ,COALESCE(con.con_agrupaambguia, false) as agrupaAmb ");
            buf.append("       ,COALESCE(con.con_fatfmaterial, false) as faturarFaltante ");
            buf.append("       ,COALESCE(con.con_imprimirfaltamaterialguia, false) as imprimirExameFaltaMaterial ");
            buf.append("   from examerequisicao exr ");
            buf.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
            buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
            buf.append("   left join examerequisicaoguiaagrupada gp on exr.fil_codigo = gp.fil_codigo and exr.req_codigo = gp.req_codigo and exr.exa_codigo = gp.exa_codigo and exr.mco_codigo = gp.mco_codigo ");
            buf.append("  where exr.fil_codigo = ").append(filial);
            buf.append("    and exr.req_codigo = ").append(requisicao);
            buf.append("    and (exr.exr_naofaturar = false or exr.exr_naofaturar is null) ");
            buf.append("\t\tAND exr.exr_datacortesia is null ");
            buf.append("\t\tAND exr.exr_excluido = false ");
            buf.append("  order by exr.exr_ordem ");
            buf.append("       ,1 ");
            buf.append("       ,exr.exa_codigo ");
            rsGuia = st.executeQuery(buf.toString());
            buf.setLength(0);
            buf.append(" select distinct case when gp.fil_codigo is not null then gp.exg_guia else exr.exr_guia end as codigoGuia ");
            buf.append("       ,COALESCE(con.con_agrupaambguia, false) as agrupaAmb ");
            buf.append("       ,COALESCE(con.con_fatfmaterial, false) as faturarFaltante ");
            buf.append("       ,COALESCE(con.con_imprimirfaltamaterialguia, false) as imprimirExameFaltaMaterial ");
            buf.append("   from examerequisicao exr ");
            buf.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
            buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
            buf.append("   left join examerequisicaoguiaagrupada gp on exr.fil_codigo = gp.fil_codigo and exr.req_codigo = gp.req_codigo and exr.exa_codigo = gp.exa_codigo and exr.mco_codigo = gp.mco_codigo ");
            buf.append("  where exr.fil_codigo = ").append(filial);
            buf.append("    and exr.req_codigo = ").append(requisicao);
            buf.append("    and (exr.exr_naofaturar = false or exr.exr_naofaturar is null) ");
            buf.append("    and exr.exr_datacortesia is null ");
            buf.append("    and exr.exr_excluido = false ");
            buf.append("  order by 1 ");
            rsGuiaDistinct = st2.executeQuery(buf.toString());
            buf.setLength(0);
            buf.append(" select COUNT(DISTINCT case when gp.fil_codigo is not null then gp.exg_guia else exr.exr_guia end) as qtdeGuia ");
            buf.append("   from examerequisicao exr ");
            buf.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
            buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
            buf.append("   left join examerequisicaoguiaagrupada gp on exr.fil_codigo = gp.fil_codigo and exr.req_codigo = gp.req_codigo and exr.exa_codigo = gp.exa_codigo and exr.mco_codigo = gp.mco_codigo ");
            buf.append("  where exr.fil_codigo = ").append(filial);
            buf.append("    and exr.req_codigo = ").append(requisicao);
            buf.append("    and (exr.exr_naofaturar = false or exr.exr_naofaturar is null) ");
            buf.append("    and exr.exr_datacortesia is null ");
            buf.append("    and exr.exr_excluido = false ");
            rsQtde = st3.executeQuery(buf.toString());
            if (DBUtil.qtdeRegistros(rsGuia) > 0) {
                int qtde = 0;
                if (rsQtde.next()) {
                    qtde = rsQtde.getInt("qtdeGuia");
                }
                if (qtde == 1) {
                    if (rsGuia.next()) {
                        byte[] byteArray = ImprimirGuia.imprimir(filial, requisicao, isColetaWeb, rsGuia.getString("codigoGuia"), rsGuia.getBoolean("agrupaAmb"), rsGuia.getBoolean("imprimirExameFaltaMaterial"), tipoGuia, ImprimirGuia.getConfiguracaoTiss(filial, requisicao, st), ordenarSetor, ordemComprovante, precoMetodologia, qtdeExamesCC, stTemp, casasPrecoExame, arredondamentoPrecoExame);
                        retorno.setByteArray(byteArray);
                        retorno.setSelecionarGuia(false);
                    }
                } else if (imprimirTodas) {
                    while (rsGuiaDistinct.next()) {
                        byte[] byteArray = ImprimirGuia.imprimir(filial, requisicao, isColetaWeb, rsGuiaDistinct.getString("codigoGuia"), rsGuiaDistinct.getBoolean("agrupaAmb"), rsGuiaDistinct.getBoolean("imprimirExameFaltaMaterial"), tipoGuia, ImprimirGuia.getConfiguracaoTiss(filial, requisicao, st), ordenarSetor, ordemComprovante, precoMetodologia, qtdeExamesCC, stTemp, casasPrecoExame, arredondamentoPrecoExame);
                        retorno.setByteArray(byteArray);
                        retorno.setSelecionarGuia(false);
                    }
                } else if (!isColetaWeb) {
                    TelaGuias tela = TelaGuias.novaInstancia(owner);
                    if (tela != null && rsGuia.next()) {
                        tela.setDadosRequisicao(filial, requisicao, rsGuia.getBoolean("agrupaAmb"), rsGuia.getBoolean("faturarFaltante"), rsGuia.getBoolean("imprimirExameFaltaMaterial"), tipoGuia);
                        do {
                            tela.adicionaGuia(rsGuia.getString("codigoGuia"));
                        } while (rsGuia.next());
                        tela.setVisible(true);
                    }
                } else {
                    retorno.setSelecionarGuia(true);
                }
            }
        }
        finally {
            if (rsGuia != null) {
                rsGuia.close();
            }
            if (rsGuiaDistinct != null) {
                rsGuiaDistinct.close();
            }
            if (rsQtde != null) {
                rsQtde.close();
            }
        }
        return retorno;
    }

    public static void imprimir(String filial, String requisicao, int codigoConvenio, int tipoGuia) throws SQLException {
        Statement st = Conexao.getStatement();
        if (st == null) {
            return;
        }
        StringBuilder buf = new StringBuilder("");
        buf.append("select ").append(tipoGuia == 1 ? "con_modeloguiasolicitado" : "con_guia").append(" as modelo");
        buf.append("   from convenios ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and con_codigo = ").append(codigoConvenio);
        ResultSet rsLayout = Conexao.executeQuery(st, buf.toString());
        if (!rsLayout.next() || Funcoes.textoVazio(rsLayout.getString("modelo")) || Gerador.vazio(rsLayout.getString("modelo"))) {
            return;
        }
        buf.delete(0, buf.length());
        buf.append(" select distinct case when gp.fil_codigo is not null then gp.exg_guia else exr.exr_guia end as codigoGuia ");
        buf.append("       ,COALESCE(con.con_agrupaambguia, false) as agrupaAmb ");
        buf.append("       ,COALESCE(con.con_fatfmaterial, false) as faturarFaltante ");
        buf.append("       ,COALESCE(con.con_imprimirfaltamaterialguia, false) as  imprimirExameFaltaMaterial");
        buf.append("   from examerequisicao exr ");
        buf.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("   left join examerequisicaoguiaagrupada gp on exr.fil_codigo = gp.fil_codigo and exr.req_codigo = gp.req_codigo and exr.exa_codigo = gp.exa_codigo and exr.mco_codigo = gp.mco_codigo ");
        buf.append("  where exr.fil_codigo = ").append(filial);
        buf.append("    and exr.req_codigo = ").append(requisicao);
        buf.append("\t\tAND exr.exr_datacortesia is null ");
        ResultSet rsGuia = Conexao.executeQuery(st, buf);
        while (rsGuia.next()) {
            ImprimirGuia.imprimir(filial, requisicao, rsGuia.getString("codigoGuia"), rsGuia.getBoolean("agrupaAmb"), rsGuia.getBoolean("imprimirExameFaltaMaterial"), tipoGuia, ImprimirGuia.getConfiguracaoTiss(filial, requisicao), ParametrosGerais.getOrdenarSetor(), ParametrosGerais.getOrdemComprovante(), ParametrosGerais.getPrecoMetodologia(), ParametrosGerais.getQtdeExamesCC(), ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
        }
    }

    public static void imprimir(String filial, String requisicao, String guia, boolean agrupaAmbGuia, boolean imprimirExameMatFaltante, int tipoGuia, Registro configTiss, boolean ordenarSetor, String ordemComprovante, boolean precoMetodologia, int qtdeExamesCC, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws SQLException {
        Statement st = Conexao.getStatement();
        ImprimirGuia.imprimir(filial, requisicao, false, guia, agrupaAmbGuia, imprimirExameMatFaltante, tipoGuia, configTiss, ordenarSetor, ordemComprovante, precoMetodologia, qtdeExamesCC, st, casasPrecoExame, arredondamentoPrecoExame);
        Conexao.fecharStatement(st);
    }

    public static byte[] imprimir(String filial, String requisicao, boolean isColetaWeb, String guia, boolean agrupaAmbGuia, boolean imprimirExameMatFaltante, int tipoGuia, Registro configTiss, boolean ordenarSetor, String ordemComprovante, boolean precoMetodologia, int qtdeExamesCC, Statement st, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws SQLException {
        String sql = ImprimirGuia.getSql(filial, requisicao, guia, agrupaAmbGuia, imprimirExameMatFaltante, ordenarSetor, ordemComprovante, precoMetodologia, casasPrecoExame, arredondamentoPrecoExame);
        HashMap<String, Object> hash = Impressao.buscaDadosLancamentoRequisicao(filial, requisicao, st);
        int qtdeColunas = ImprimirGuia.buscaQtdeColunasGuia(filial, requisicao, st, qtdeExamesCC);
        ModeloGridTable modeloDados = new ModeloGridTable(ImprimirGuia.adicionaColunasGuia(Impressao.CAMPOS_GUIA, qtdeColunas));
        String[] codigoValidade = ImprimirGuia.getCodigoValidadeExameList(filial, requisicao, st);
        String validadeGuiaExameList = codigoValidade[0];
        String autorizacaoGuiaExameList = codigoValidade[1];
        ResultSet rs = st.executeQuery(sql);
        int qtdeExames = DBUtil.qtdeRegistros(rs);
        if (rs.next()) {
            String versaoTiss;
            int ultimaPosicao = Impressao.CAMPOS_GUIA.length;
            int contador = 1;
            String codigoConvenio = rs.getString("codigoConvenio");
            String string = versaoTiss = configTiss != null && configTiss.possuiCampo("versaoTiss") ? configTiss.getValor("versaoTiss").toString() : "";
            if (qtdeColunas <= 1) {
                do {
                    ultimaPosicao = Impressao.CAMPOS_GUIA.length;
                    modeloDados.addLine(new Object[modeloDados.getColumnCount()]);
                    if (!hash.isEmpty()) {
                        Set<String> set = hash.keySet();
                        for (String s : set) {
                            Iterator<String> value = hash.get(s);
                            int pos = modeloDados.findColumn(s);
                            if (pos <= -1) continue;
                            modeloDados.setValueAt(value, modeloDados.getRowCount() - 1, pos);
                        }
                    }
                    for (int i = 0; i < Impressao.CAMPOS_GUIA.length; ++i) {
                        String aux;
                        String cbo;
                        if (DBUtil.campoNull(rs.getString(Impressao.CAMPOS_GUIA[i]))) {
                            modeloDados.setValueAt("", modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equals("tipoLogradouroMedico") || Impressao.CAMPOS_GUIA[i].equals("tipoLogradouroEnderecoConvenio") || Impressao.CAMPOS_GUIA[i].equals("tipoLogradouroPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoLogradouroDescricao(rs.getString(Impressao.CAMPOS_GUIA[i])), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equals("sexoPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoSexo(rs.getString(Impressao.CAMPOS_GUIA[i])), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equals("corPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoCor(rs.getString(Impressao.CAMPOS_GUIA[i])), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equalsIgnoreCase("estadoCivilPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoEstadoCivil(rs.getString(Impressao.CAMPOS_GUIA[i])), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equalsIgnoreCase("tipoUltimoPagamentoRequisicao")) {
                            modeloDados.setValueAt(Tipos.tipoPagamento(rs.getString("tipoUltimoPagamentoRequisicao")), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equalsIgnoreCase("autorizacaoGuiaRequisicao")) {
                            modeloDados.setValueAt(!Funcoes.textoVazio(rs.getString("autorizacaoExame")) ? rs.getString("autorizacaoExame") : "", modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equalsIgnoreCase("descricaoTabelaANSTabelaPreco")) {
                            modeloDados.setValueAt(!DBUtil.campoNull(rs.getString("codigoTabelaANSTabelaPreco")) ? TabelaANS.TiposTabela.getTipo((String)rs.getString((String)"codigoTabelaANSTabelaPreco")).codigo : "", modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equalsIgnoreCase("descricaoCBOMedico")) {
                            cbo = rs.getString("codigoCBOMedico");
                            if (Funcoes.textoVazio(cbo)) continue;
                            aux = StringUtil.getValor(cbo, "cbo");
                            if (ImprimirGuia.isVersaoTissAcima3000(configTiss)) {
                                cbo = Tiss.pegaCodigoCBOTiss(configTiss.getValor("versaoTiss").toString(), aux, VersaoTiss.getVersaoPorDescricao(versaoTiss));
                            }
                            if (Funcoes.textoVazio(aux)) continue;
                            aux = StringUtil.getValor(aux, "descricao");
                            modeloDados.setValueAt(aux, modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equalsIgnoreCase("codigoCBOMedico")) {
                            cbo = rs.getString("codigoCBOMedico");
                            if (Funcoes.textoVazio(cbo) || Funcoes.textoVazio(aux = StringUtil.getValor(cbo, "cbo"))) continue;
                            aux = StringUtil.getValor(aux, "codigo");
                            if (ImprimirGuia.isVersaoTissAcima3000(configTiss)) {
                                aux = Tiss.pegaCodigoCBOTiss(configTiss.getValor("versaoTiss").toString(), aux, VersaoTiss.getVersaoPorDescricao(versaoTiss));
                            }
                            modeloDados.setValueAt(aux, modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equalsIgnoreCase("qtdeExames")) {
                            modeloDados.setValueAt(qtdeExames, modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (configTiss != null && configTiss.possuiCampo(Impressao.CAMPOS_GUIA[i])) {
                            modeloDados.setValueAt(configTiss.getValor(Impressao.CAMPOS_GUIA[i]), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equals("idadeRequisicaoPaciente")) {
                            modeloDados.setValueAt(Funcoes.getIntervaloParaString((PGInterval)rs.getObject(Impressao.CAMPOS_GUIA[i]), null), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        modeloDados.setValueAt(rs.getObject(Impressao.CAMPOS_GUIA[i]), modeloDados.getRowCount() - 1, i);
                    }
                    for (int j = 0; j < QTDE_CAMPOS_GUIA; ++j) {
                        modeloDados.setValueAt(rs.getObject(ADICIONAIS_GUIA[j]), modeloDados.getRowCount() - 1, ultimaPosicao++);
                    }
                } while (rs.next());
            } else {
                boolean fimTabela = false;
                while (!fimTabela) {
                    contador = 1;
                    ultimaPosicao = Impressao.CAMPOS_GUIA.length;
                    modeloDados.addLine(new Object[modeloDados.getColumnCount()]);
                    int ultimaLinha = modeloDados.getRowCount() - 1;
                    if (!hash.isEmpty()) {
                        Set<String> set = hash.keySet();
                        for (String s : set) {
                            Object value = hash.get(s);
                            int pos = modeloDados.findColumn(s);
                            if (pos <= -1) continue;
                            modeloDados.setValueAt(value, ultimaLinha, pos);
                        }
                    }
                    for (int i = 0; i < Impressao.CAMPOS_GUIA.length; ++i) {
                        String aux;
                        String cbo;
                        if (DBUtil.campoNull(rs.getString(Impressao.CAMPOS_GUIA[i]))) {
                            modeloDados.setValueAt("", ultimaLinha, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equals("tipoLogradouroMedico") || Impressao.CAMPOS_GUIA[i].equals("tipoLogradouroEnderecoConvenio") || Impressao.CAMPOS_GUIA[i].equals("tipoLogradouroPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoLogradouroDescricao(rs.getString(Impressao.CAMPOS_GUIA[i])), ultimaLinha, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equals("sexoPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoSexo(rs.getString(Impressao.CAMPOS_GUIA[i])), ultimaLinha, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equals("corPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoCor(rs.getString(Impressao.CAMPOS_GUIA[i])), ultimaLinha, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equalsIgnoreCase("estadoCivilPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoEstadoCivil(rs.getString(Impressao.CAMPOS_GUIA[i])), ultimaLinha, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equalsIgnoreCase("tipoUltimoPagamentoRequisicao")) {
                            modeloDados.setValueAt(Tipos.tipoPagamento(rs.getString("tipoUltimoPagamentoRequisicao")), ultimaLinha, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equalsIgnoreCase("qtdeExames")) {
                            modeloDados.setValueAt(qtdeExames, ultimaLinha, i);
                            continue;
                        }
                        if (configTiss != null && configTiss.possuiCampo(Impressao.CAMPOS_GUIA[i])) {
                            modeloDados.setValueAt(configTiss.getValor(Impressao.CAMPOS_GUIA[i]), ultimaLinha, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equalsIgnoreCase("descricaoCBOMedico")) {
                            cbo = rs.getString("codigoCBOMedico");
                            if (Funcoes.textoVazio(cbo) || Funcoes.textoVazio(aux = StringUtil.getValor(cbo, "cbo"))) continue;
                            aux = StringUtil.getValor(aux, "descricao");
                            modeloDados.setValueAt(aux, modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equalsIgnoreCase("codigoCBOMedico")) {
                            cbo = rs.getString("codigoCBOMedico");
                            if (Funcoes.textoVazio(cbo) || Funcoes.textoVazio(aux = StringUtil.getValor(cbo, "cbo"))) continue;
                            aux = StringUtil.getValor(aux, "codigo");
                            if (ImprimirGuia.isVersaoTissAcima3000(configTiss)) {
                                aux = Tiss.pegaCodigoCBOTiss(configTiss.getValor("versaoTiss").toString(), aux, VersaoTiss.getVersaoPorDescricao(versaoTiss));
                            }
                            modeloDados.setValueAt(aux, modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_GUIA[i].equals("idadeRequisicaoPaciente")) {
                            modeloDados.setValueAt(Funcoes.getIntervaloParaString((PGInterval)rs.getObject(Impressao.CAMPOS_GUIA[i]), null), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        modeloDados.setValueAt(rs.getObject(Impressao.CAMPOS_GUIA[i]), ultimaLinha, i);
                    }
                    while (contador <= qtdeColunas) {
                        for (int j = 0; j < QTDE_CAMPOS_GUIA; ++j) {
                            modeloDados.setValueAt(fimTabela ? "" : rs.getObject(ADICIONAIS_GUIA[j]), ultimaLinha, ultimaPosicao++);
                        }
                        fimTabela = !rs.next();
                        ++contador;
                    }
                }
            }
            int colunaAutorizacaoGuiaRequisicao = modeloDados.findColumn("autorizacaoGuiaRequisicao");
            int colunaValidadeGuiaRequisicao = modeloDados.findColumn("validadeAutorizacaoRequisicao");
            for (int linha = 0; linha < modeloDados.getRowCount(); ++linha) {
                modeloDados.setValueAt(autorizacaoGuiaExameList, linha, colunaAutorizacaoGuiaRequisicao);
                modeloDados.setValueAt(validadeGuiaExameList, linha, colunaValidadeGuiaRequisicao);
            }
            Gerador gerador = new Gerador(casasPrecoExame, arredondamentoPrecoExame);
            if (!isColetaWeb) {
                gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraGuia")));
            }
            StringBuilder buf = new StringBuilder();
            buf.delete(0, buf.length());
            buf.append("select ").append(tipoGuia == 1 ? "con_modeloguiasolicitado" : "con_guia").append(" as modelo ");
            buf.append(" from convenios ");
            buf.append(" where fil_codigo = ").append(filial);
            buf.append(" and con_codigo = ").append(codigoConvenio);
            ResultSet rsLayout = st.executeQuery(buf.toString());
            if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("modelo")) && !Gerador.vazio(rsLayout.getString("modelo"))) {
                String modelo = rsLayout.getString("modelo");
                gerador.executar(modelo, modeloDados, null, false, true, isColetaWeb);
                if (isColetaWeb) {
                    return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), modelo);
                }
            } else {
                Funcoes.mensagem(null, "Modelo de guia n\u00e3o localizado ou n\u00e3o definido", 1);
            }
            rsLayout.close();
        }
        rs.close();
        return new byte[0];
    }

    private static String getSql(String filial, String requisicao, String guia, boolean agrupaAmbGuia, boolean imprimirExameMatFaltante, boolean ordenarSetor, String ordemComprovante, boolean precoMetodologia, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select a.req_codigo as codigoRequisicao ");
        buf.append("       ,a.req_data as dataRequisicao ");
        buf.append("       ,a.req_responsavel as responsavelPacienteRequisicao");
        buf.append("       ,a.req_cpfresponsavel as cpfResponsavelPacienteRequisicao ");
        buf.append("       ,COALESCE(a.req_incapacitado,FALSE) as incapacitadoPacienteRequisicao");
        buf.append("       ,j.pac_responsavel as responsavelPaciente");
        buf.append("       ,j.pac_cpfresponsavel as cpfResponsavelPaciente");
        buf.append("       ,COALESCE(j.pac_incapacitado, FALSE) as incapacitadoPaciente");
        buf.append("       ,a.req_dtfatura as dataFaturaRequisicao ");
        buf.append("       ,a.req_urgente as urgenteRequisicao ");
        buf.append("       ,a.req_dataentregaprev as dataEntregaRequisicao ");
        buf.append("       ,a.req_dclinicos as dadosClinicosRequisicao ");
        buf.append("       ,a.req_obs as obsRequisicao ");
        buf.append("       ,a.req_totpago as totalPagoRequisicao ");
        buf.append("       ,a.req_horaentregaprev as horaEntregaRequisicao ");
        buf.append("       ,a.req_total as totalRequisicao ");
        buf.append("       ,a.req_horafatura as horaFaturaRequisicao ");
        buf.append("       ,a.req_hora as horaRequisicao ");
        buf.append("       ,a.req_gestante as gestanteRequisicao ");
        buf.append("       ,a.req_dum as dumRequisicao ");
        buf.append("       ,a.req_idade as idadeRequisicao ");
        buf.append("       ,a.req_anomes as anoMesRequisicao ");
        buf.append("       ,a.req_matricula as matriculaRequisicao ");
        buf.append("       ,a.req_avisarpaciente as avisarPacienteRequisicao ");
        buf.append("       ,a.req_senhaweb as senhaWebRequisicao ");
        buf.append("       ,a.req_titular as titularRequisicao ");
        buf.append("       ,a.req_peso as pesoRequisicao ");
        buf.append("       ,a.req_altura as alturaRequisicao ");
        buf.append("       ,a.req_desconto as descontoRequisicao ");
        buf.append("       ,a.req_vlrdesconto as valorDescontoRequisicao ");
        buf.append("       ,a.req_notacaixa as notaCaixaRequisicao ");
        buf.append("       ,a.req_vlrexames as valorExamesRequisicao ");
        buf.append("       ,a.req_vlrmateriais as valorMateriaisRequisicao ");
        buf.append("       ,a.req_guia as guiaRequisicao ");
        buf.append("       ,a.req_validadeguia as novaValidadeGuiaRequisicao ");
        buf.append("       ,coalesce(a.req_dataguia, a.req_validadeguia) as validadeGuiaRequisicao ");
        buf.append("       ,a.req_dataguia as dataGuiaRequisicao ");
        buf.append("       ,a.req_acrescimo as acrescimoRequisicao ");
        buf.append("       ,a.req_vlracrescimo as valorAcrescimoRequisicao ");
        buf.append("       ,a.req_tipoultpagamento as tipoUltimoPagamentoRequisicao ");
        buf.append("       ,a.req_validadecarteira as validadeCarteiraMatriculaRequisicao ");
        buf.append("       ,a.req_nomeplano as nomePlanoRequisicao ");
        buf.append("       ,a.req_guiaprincipal as guiaPrincipalRequisicao ");
        buf.append("       ,a.sit_codigo as codigoSituacao ");
        buf.append("       ,a.usr_codigo as codigoUsuario ");
        buf.append("       ,a.req_prontuario as prontuarioRequisicao ");
        buf.append("       ,a.usr_codabertura as codigoUsuarioAbertura ");
        buf.append("       ,a.des_codigo as codigoDestino ");
        buf.append("       ,a.col_codigo as codigoColeta ");
        buf.append("       ,a.fil_codigo as codigoFilial ");
        buf.append("       ,a.req_cartaosus as cartaoSUSRequisicao ");
        buf.append("       ,a.req_neonato as neonatoRequisicao ");
        buf.append("       ,k.cid_codigo as codigoCidadeConvenio ");
        buf.append("       ,k.cid_nome as descricaoCidadeConvenio ");
        buf.append("       ,k.cid_uf as estadoCidadeConvenio ");
        buf.append("       ,l.cid_codigo as codigoCidadeMedico ");
        buf.append("       ,l.cid_nome as descricaoCidadeMedico ");
        buf.append("       ,l.cid_uf as estadoCidadeMedico ");
        buf.append("       ,m.cid_codigo as codigoCidadeDestino ");
        buf.append("       ,m.cid_nome as descricaoCidadeDestino ");
        buf.append("       ,m.cid_uf as estadoCidadeDestino ");
        buf.append("       ,n.cid_codigo as codigoCidadeColeta ");
        buf.append("       ,n.cid_nome as descricaoCidadeColeta ");
        buf.append("       ,n.cid_uf as estadoCidadeColeta ");
        buf.append("       ,o.cid_codigo as codigoCidadePaciente ");
        buf.append("       ,o.cid_nome as descricaoCidadePaciente ");
        buf.append("       ,o.cid_uf as estadoCidadePaciente ");
        buf.append("       ,p.bai_codigo as codigoBairroConvenio ");
        buf.append("       ,p.bai_descricao as descricaoBairroConvenio ");
        buf.append("       ,q.bai_codigo as codigoBairroMedico ");
        buf.append("       ,q.bai_descricao as descricaoBairroMedico ");
        buf.append("       ,r.bai_codigo as codigoBairroDestino ");
        buf.append("       ,r.bai_descricao as descricaoBairroDestino ");
        buf.append("       ,s.bai_codigo as codigoBairroColeta ");
        buf.append("       ,s.bai_descricao as descricaoBairroColeta ");
        buf.append("       ,t.bai_codigo as codigoBairroPaciente ");
        buf.append("       ,t.bai_descricao as descricaoBairroPaciente ");
        buf.append("       ,des.des_descricao as descricaoDestino ");
        buf.append("       ,des.des_endereco as enderecoDestino ");
        buf.append("       ,des.des_complemento as complementoDestino ");
        buf.append("       ,des.des_cep as cepDestino ");
        buf.append("       ,des.des_fone as foneDestino ");
        buf.append("       ,col.col_descricao as descricaoColeta ");
        buf.append("       ,col.col_endereco as enderecoColeta ");
        buf.append("       ,col.col_complemento as complementoColeta ");
        buf.append("       ,col.col_cep as cepColeta ");
        buf.append("       ,col.col_fone as foneColeta ");
        buf.append("       ,med.med_conselho as conselhoMedico ");
        buf.append("       ,med.med_crm as crmMedico ");
        buf.append("       ,med.med_uf as estadoCrmMedico ");
        buf.append("       ,med.med_nome as nomeMedico ");
        buf.append("       ,med.med_abrev as tratamentoMedico ");
        buf.append("       ,med.med_endereco as enderecoMedico ");
        buf.append("       ,med.med_tipologradouroendereco as tipoLogradouroMedico ");
        buf.append("       ,med.med_numeroendereco as numeroEnderecoMedico ");
        buf.append("       ,med.med_complemento as complementoMedico ");
        buf.append("       ,med.med_cep as cepMedico ");
        buf.append("       ,med.med_fone as foneMedico ");
        buf.append("       ,med.med_celular as celularMedico ");
        buf.append("       ,med.med_fax as faxMedico ");
        buf.append("       ,med.med_email as emailMedico ");
        buf.append("       ,med.med_site as siteMedico ");
        buf.append("       ,med.med_cpf as cpfMedico ");
        buf.append("       ,con.con_codigo as codigoConvenio ");
        buf.append("       ,con.con_fantasia as fantasiaConvenio ");
        buf.append("       ,con.con_razao as razaoSocialConvenio ");
        buf.append("       ,con.con_tipologradouroendereco as tipoLogradouroEnderecoConvenio ");
        buf.append("       ,con.con_numeroendereco as numeroEnderecoConvenio ");
        buf.append("       ,con.con_endereco as enderecoConvenio ");
        buf.append("       ,con.con_complemento as complementoConvenio ");
        buf.append("       ,con.con_cep as cepConvenio ");
        buf.append("       ,con.con_fone as foneConvenio ");
        buf.append("       ,con.con_email1 as email1Convenio ");
        buf.append("       ,con.con_email2 as email2Convenio ");
        buf.append("       ,con.con_site as siteConvenio ");
        buf.append("       ,con.con_cnpjcpf as cnpjConvenio ");
        buf.append("       ,tpe.tpe_codigo as codigoTabelaPreco ");
        buf.append("       ,tpe.tpe_descricao as descricaoTabelaPreco ");
        buf.append("       ,tpe.tpe_moeda as moedaTabelaPreco ");
        buf.append("       ,tpe.tpe_tabelaans as codigoTabelaANSTabelaPreco ");
        buf.append("       ,tpe.tpe_tabelaans as descricaoTabelaANSTabelaPreco ");
        buf.append("       ,tpe.tpe_valorch as valorCHTabelaPreco ");
        buf.append("       ,j.pac_codigo as codigoPaciente ");
        buf.append("       ,j.pac_nome as nomePaciente ");
        buf.append("       ,j.pac_sexo as sexoPaciente ");
        buf.append("       ,j.pac_datanasc as dataNascimentoPaciente ");
        buf.append("       ,j.pac_grpsangue as grupoSanguineoPaciente ");
        buf.append("       ,j.pac_fatorrh as fatorRHPaciente ");
        buf.append("       ,j.pac_fatordu as fatorDUPaciente ");
        buf.append("       ,j.pac_cor as corPaciente ");
        buf.append("       ,j.pac_profissao as profissaoPaciente ");
        buf.append("       ,j.pac_rg as rgPaciente ");
        buf.append("       ,j.pac_cpf as cpfPaciente ");
        buf.append("       ,j.pac_estcivil as estadoCivilPaciente ");
        buf.append("       ,j.pac_dum as dumPaciente ");
        buf.append("       ,j.pac_fone as fonePaciente ");
        buf.append("       ,j.pac_celular as celularPaciente ");
        buf.append("       ,j.pac_fax as faxPaciente ");
        buf.append("       ,j.pac_fonecomercial as foneComercialPaciente ");
        buf.append("       ,j.pac_tipologradouroendereco as tipoLogradouroPaciente ");
        buf.append("       ,j.pac_endereco as enderecoPaciente ");
        buf.append("       ,j.pac_numeroendereco as numeroEnderecoPaciente ");
        buf.append("       ,j.pac_complemento as complementoPaciente ");
        buf.append("       ,j.pac_cep as cepPaciente ");
        buf.append("       ,j.pac_email as emailPaciente ");
        buf.append("       ,j.pac_fonecontato as foneContatoPaciente ");
        buf.append("       ,j.pac_nomecontato as contatoPaciente ");
        buf.append("       ,j.pac_validadecarteira as validadeCarteiraPaciente ");
        buf.append("       ,j.pac_nomeplano as nomePlanoPaciente ");
        buf.append("       ,j.pac_codigoapoiado as codigoApoiadoPaciente ");
        buf.append("       ,j.pac_cartaosus as cartaoSUSPaciente ");
        buf.append("       ,j.pac_nomesocial as nomeSocialPaciente ");
        buf.append("       ,j.pac_whatsapp as whatsAppPaciente ");
        buf.append("       ,us.uns_codigo as codigoUnidadeSaude ");
        buf.append("       ,us.uns_descricao as descricaoUnidadeSaude ");
        buf.append("       ,us.uns_endereco as enderecoUnidadeSaude ");
        buf.append("       ,us.uns_complemento as complementoUnidadeSaude ");
        buf.append("       ,us.uns_cep as cepUnidadeSaude ");
        buf.append("       ,us.uns_fone as foneUnidadeSaude ");
        buf.append("       ,cidadeus.cid_codigo as codigoCidadeUnidadeSaude ");
        buf.append("       ,cidadeus.cid_nome as descricaoCidadeUnidadeSaude ");
        buf.append("       ,cidadeus.cid_uf as estadoCidadeUnidadeSaude ");
        buf.append("       ,bairrous.bai_codigo as codigoBairroUnidadeSaude ");
        buf.append("       ,bairrous.bai_descricao as descricaoBairroUnidadeSaude ");
        buf.append("       ,'' as autorizacaoGuiaRequisicao ");
        buf.append("       ,'' as validadeAutorizacaoRequisicao ");
        buf.append("       ,0 as qtdeExames ");
        if (precoMetodologia) {
            buf.append("       ,case when exa.fil_codigo is not null then COALESCE(NULLIF(TRIM(dtm.dtm_codamb), ''), TRIM(dtp.dtp_codamb)) else COALESCE(NULLIF(TRIM(dtm2.dtm_codamb), ''), TRIM(dtp2.dtp_codamb)) end as ambExame ");
        } else {
            buf.append("       ,case when exa.fil_codigo is not null then trim(dtp.dtp_codamb) else trim(dtp2.dtp_codamb) end as ambExame ");
        }
        buf.append("       ,medt.mec_codigooperadora as codigoOperadoraMedico ");
        buf.append("         , med.med_cbo as codigoCBOMedico, med.med_cbo as descricaoCBOMedico ");
        if (agrupaAmbGuia) {
            buf.append("       ,array_to_string(array_agg(distinct exr.exr_codautorizacao), ', ') as autorizacaoExame ");
            buf.append("       ,array_to_string(array_agg(distinct to_char(exr.exr_dataautorizacao, 'DD/MM/YYYY')), ', ') as dataAutorizacaoExame ");
            buf.append("       ,array_to_string(array_agg(distinct to_char(exr.exr_datavalidadeautorizacao, 'DD/MM/YYYY')), ', ') as validadeAutorizacaoExame ");
            buf.append("       ,AVG(exr.exr_vlrch) as valorCHOriginal ");
            buf.append("       ,AVG(calculachconvenio(a.fil_codigo, a.con_codigo, a.req_codigo, exr.exa_codigo, exr.mco_codigo)) as valorCH ");
            buf.append("       ,array_to_string(array_agg(case when exa.fil_codigo is not null then exa.exa_descricao else w.exa_descricao end), ', ') as descricaoExame ");
            buf.append("       ,count(1) as qtdeExame ");
            buf.append("       ,array_to_string(array_agg(distinct case when exa.fil_codigo is not null then mco.mco_descricao else v.mco_descricao end), ', ') as descricaoMaterial ");
            buf.append("       ,array_to_string(array_agg(distinct case when exa.fil_codigo is not null then mco.mco_abreviatura else v.mco_abreviatura end), ', ') as abreviaturaMaterial ");
            buf.append("       ,AVG(case when exa.fil_codigo is not null then calculaprecototalexamerequisicao(exr.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, exa.exa_codigo), COALESCE(exg.mco_codfilho, exr.mco_codigo), false, COALESCE(con.con_percpgto, 0) = 0, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ");
            buf.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false").append(", COALESCE(exr.met_codigo, elm.met_codigo, emc.met_codigo) ").append(") else calculaprecototalexamerequisicao(exr.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, w.exa_codigo), COALESCE(exg.mco_codfilho, exr.mco_codigo), false, COALESCE(con.con_percpgto, 0) = 0, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ");
            buf.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false");
            buf.append(", COALESCE(exr.met_codigo, elm.met_codigo, emc.met_codigo) ").append(") end) as valorUnitarioExame ");
            buf.append(" , SUM(case when exa.fil_codigo is not null then calculaprecototalexamerequisicao(exr.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, exa.exa_codigo), COALESCE(exg.mco_codfilho, exr.mco_codigo), false, true, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ");
            buf.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false").append(", COALESCE(exr.met_codigo, elm.met_codigo, emc.met_codigo) ").append(") else calculaprecototalexamerequisicao(exr.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, w.exa_codigo), COALESCE(exg.mco_codfilho, exr.mco_codigo), false, true, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ");
            buf.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false");
            buf.append(", COALESCE(exr.met_codigo, elm.met_codigo, emc.met_codigo) ").append(") end) as valorExameConvenioFatura ");
            if (precoMetodologia) {
                buf.append("       ,SUM(case when exa.fil_codigo is not null then COALESCE(dtm.dtm_valor, dtp.dtp_valor) else exr.exr_valorcusto end) as custoCBHPMExame ");
                buf.append("       ,SUM(case when exa.fil_codigo is not null then COALESCE(dtm.dtm_valor, dtp.dtp_valor) else exr.exr_vlrchexame end) as chExameOriginal ");
                buf.append("       ,array_to_string(array_agg(distinct COALESCE(dtm4.dtm_codamb, dtp4.dtp_codamb)), ', ') as ambExamePrincipal ");
            } else {
                buf.append("       ,SUM(case when exa.fil_codigo is not null then dtp.dtp_valor else exr.exr_vlrchexame end) as chExameOriginal ");
                buf.append("       ,SUM(case when exa.fil_codigo is not null then dtp.dtp_valor else exr.exr_valorcusto end) as custoCBHPMExame ");
                buf.append("       ,array_to_string(array_agg(distinct dtp4.dtp_codamb), ', ') as ambExamePrincipal ");
            }
            buf.append("       ,SUM(calculachexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, exr.exa_codigo, exr.mco_codigo)) as chExame ");
            buf.append("       ,SUM(case when exa.fil_codigo is not null then calculaprecototalexamerequisicao(exr.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, exa.exa_codigo), COALESCE(exg.mco_codfilho, exr.mco_codigo), false, COALESCE(con.con_percpgto, 0) = 0, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ");
            buf.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false").append(", COALESCE(exr.met_codigo, elm.met_codigo, emc.met_codigo) ").append(") else calculaprecototalexamerequisicao(exr.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, w.exa_codigo), COALESCE(exg.mco_codfilho, exr.mco_codigo), false, COALESCE(con.con_percpgto, 0) = 0, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ");
            buf.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false").append(", COALESCE(exr.met_codigo, elm.met_codigo, emc.met_codigo) ").append(") end) as valorExame ");
            buf.append("       ,array_to_string(array_agg(distinct case when exa.fil_codigo is not null then exg.exg_guia else exr.exr_guia end), ', ') as guiaExameRequisicao ");
            buf.append("       ,array_to_string(array_agg(distinct case when exa.fil_codigo is not null then to_char(exg.exg_validadeguia, 'DD/MM/YYYY') else to_char(exr.exr_validadeguia, 'DD/MM/YYYY') end), ', ') as novaValidadeGuiaExameRequisicao ");
            buf.append("       ,array_to_string(array_agg(distinct case when exa.fil_codigo is not null then to_char(exg.exg_dataguia, 'DD/MM/YYYY') else to_char(exr.exr_dataguia, 'DD/MM/YYYY') end), ', ') as validadeGuiaExameRequisicao ");
            buf.append("       ,array_to_string(array_agg(distinct case when exa.fil_codigo is not null then to_char(exg.exg_dataguia, 'DD/MM/YYYY') else to_char(exr.exr_dataguia, 'DD/MM/YYYY') end), ', ') as dataGuiaExameRequisicao ");
            buf.append("       ,SUM(case when exa.fil_codigo is not null then calculaprecototalexamerequisicao(exr.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, exa.exa_codigo), COALESCE(exg.mco_codfilho, exr.mco_codigo), false, COALESCE(con.con_percpgto, 0) = 0, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ");
            buf.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false").append(", COALESCE(exr.met_codigo, elm.met_codigo, emc.met_codigo) ").append(") else calculaprecototalexamerequisicao(exr.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, w.exa_codigo), COALESCE(exg.mco_codfilho, exr.mco_codigo), false, COALESCE(con.con_percpgto, 0) = 0, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ");
            buf.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false").append(", COALESCE(exr.met_codigo, elm.met_codigo, emc.met_codigo) ").append(") end) as valorExameConvenio ");
            buf.append("       ,SUM(exr.exr_vlrmaterial) as valorMateriaisExame ");
            buf.append("       ,SUM(case when exa.fil_codigo is not null then tpe.tpe_uco else exr.exr_valoruco end) as ucoCBHPMExame ");
            buf.append("       ,SUM(case when exa.fil_codigo is not null then tpp.tpp_valor else exr.exr_valorporte end) as valorPorteCBHPMExame ");
            buf.append("       ,array_to_string(array_agg(distinct case when exa.fil_codigo is not null then tpp.tpp_porte else exr.exr_porte end), ', ') as porteCBHPMExame ");
            buf.append("       ,SUM(exr.exr_vlrmaterial) as valorMateriaisExame ");
            buf.append("       ,array_to_string(array_agg(distinct exr.exa_codigo), ', ') as codigoExamePrincipal ");
            buf.append("       ,array_to_string(array_agg(distinct w.exa_descricao), ', ') as descricaoExamePrincipal ");
            buf.append("       ,array_to_string(array_agg(distinct v.mco_descricao), ', ') as descricaoMaterialPrincipal ");
            buf.append("       ,array_to_string(array_agg(distinct v.mco_abreviatura), ', ') as abreviaturaMaterialPrincipal ");
            buf.append("       ,SUM(exr.exr_vlrchexame) as chExamePrincipalOriginal ");
            buf.append("       ,SUM(calculachexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, exr.exa_codigo, exr.mco_codigo)) as chExamePrincipal ");
            buf.append("       ,SUM(exr.exr_vlrexame) as valorExamePrincipal ");
            buf.append("       ,SUM(exr.exr_vlrexame) as valorExameConvenioPrincipal ");
            buf.append("       ,SUM(exr.exr_vlrmaterial) as valorMateriaisExamePrincipal ");
            buf.append("       ,SUM(exr.exr_valorcusto) as custoCBHPMExamePrincipal ");
            buf.append("       ,SUM(exr.exr_valoruco) as ucoCBHPMExamePrincipal ");
            buf.append("       ,SUM(exr.exr_valorporte) as valorPorteCBHPMExamePrincipal ");
            buf.append("       ,array_to_string(array_agg(distinct exr.exr_porte), ', ') as porteCBHPMExamePrincipal ");
            buf.append("       ,array_to_string(array_agg(distinct COALESCE(emg1.grp_codigo, emg2.grp_codigo)), ', ') as gruposExame ");
            buf.append("       ,array_to_string(array_agg(distinct c10.c10_codigo), ', ') as codigosCID10 ");
            buf.append("       ,array_to_string(array_agg(distinct c10.c10_descricao), ', ') as descricoesCID10 ");
            buf.append("       ,MIN(exr.exr_ordem) as ordemExame ");
            if (ordemComprovante.equals("P")) {
                buf.append("       ,MIN(u.emc_pagina) as emc_pagina ");
            }
        } else {
            buf.append("       ,exr.exr_codautorizacao as autorizacaoExame ");
            buf.append("       ,to_char(exr.exr_dataautorizacao, 'DD/MM/YYYY') as dataAutorizacaoExame ");
            buf.append("       ,to_char(exr.exr_datavalidadeautorizacao, 'DD/MM/YYYY') as validadeAutorizacaoExame ");
            buf.append("       ,exr.exr_vlrch as valorCHOriginal ");
            buf.append("       ,calculachconvenio(a.fil_codigo, a.con_codigo, a.req_codigo, exr.exa_codigo, exr.mco_codigo) as valorCH ");
            buf.append("       ,case when exa.fil_codigo is not null then exa.exa_descricao else w.exa_descricao end as descricaoExame ");
            buf.append("       ,1 as qtdeExame ");
            buf.append("       ,case when exa.fil_codigo is not null then mco.mco_descricao else v.mco_descricao end as descricaoMaterial ");
            buf.append("       ,case when exa.fil_codigo is not null then mco.mco_abreviatura else v.mco_abreviatura end as abreviaturaMaterial ");
            buf.append("       ,case when exa.fil_codigo is not null then calculaprecototalexamerequisicao(exr.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, exr.exa_codigo), COALESCE(exg.mco_codfilho, exr.mco_codigo), false, COALESCE(con.con_percpgto, 0) = 0, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ");
            buf.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false").append(", COALESCE(exr.met_codigo, elm.met_codigo, emc.met_codigo) ").append(") else calculaprecototalexamerequisicao(exr.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, w.exa_codigo), COALESCE(exg.mco_codfilho, v.mco_codigo), false, COALESCE(con.con_percpgto, 0) = 0, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ");
            buf.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false").append(", COALESCE(exr.met_codigo, elm.met_codigo, emc.met_codigo) ").append(") end as valorUnitarioExame ");
            buf.append(" ,case when exa.fil_codigo is not null then calculaprecototalexamerequisicao(exr.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, exr.exa_codigo), COALESCE(exg.mco_codfilho, exr.mco_codigo), false, true, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ");
            buf.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false").append(", COALESCE(exr.met_codigo, elm.met_codigo, emc.met_codigo) ").append(") else calculaprecototalexamerequisicao(exr.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, w.exa_codigo), COALESCE(exg.mco_codfilho, v.mco_codigo), false, true, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ");
            buf.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false").append(", COALESCE(exr.met_codigo, elm.met_codigo, emc.met_codigo) ").append(") end as valorExameConvenioFatura ");
            if (precoMetodologia) {
                buf.append("       ,case when exa.fil_codigo is not null then COALESCE(dtm.dtm_valor, dtp.dtp_valor) else exr.exr_vlrchexame end as chExameOriginal ");
                buf.append("       ,case when exa.fil_codigo is not null then COALESCE(dtm.dtm_valor, dtp.dtp_valor) else exr.exr_valorcusto end as custoCBHPMExame ");
                buf.append("       ,COALESCE(NULLIF(TRIM(dtm4.dtm_codamb), ''), dtp4.dtp_codamb) as ambExamePrincipal ");
            } else {
                buf.append("       ,case when exa.fil_codigo is not null then dtp.dtp_valor else exr.exr_vlrchexame end as chExameOriginal ");
                buf.append("       ,case when exa.fil_codigo is not null then dtp.dtp_valor else exr.exr_valorcusto end as custoCBHPMExame ");
                buf.append("       ,dtp4.dtp_codamb as ambExamePrincipal ");
            }
            buf.append("       ,calculachexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, exr.exa_codigo, exr.mco_codigo) as chExame ");
            buf.append("       ,case when exa.fil_codigo is not null then calculaprecototalexamerequisicao(exr.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, exr.exa_codigo), COALESCE(exg.mco_codfilho, exr.mco_codigo), false, COALESCE(con.con_percpgto, 0) = 0, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ");
            buf.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false").append(", COALESCE(exr.met_codigo, elm.met_codigo, emc.met_codigo) ").append(") else calculaprecototalexamerequisicao(exr.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, w.exa_codigo), COALESCE(exg.mco_codfilho, v.mco_codigo), false, COALESCE(con.con_percpgto, 0) = 0, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ");
            buf.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false").append(", COALESCE(exr.met_codigo, elm.met_codigo, emc.met_codigo) ").append(") end as valorExame ");
            buf.append("       ,case when exa.fil_codigo is not null then to_char(exg.exg_dataguia, 'DD/MM/YYYY') else to_char(exr.exr_dataguia, 'DD/MM/YYYY') end as dataGuiaExameRequisicao ");
            buf.append("       ,case when exa.fil_codigo is not null then to_char(exg.exg_validadeguia, 'DD/MM/YYYY') else to_char(exr.exr_validadeguia, 'DD/MM/YYYY') end as novaValidadeGuiaExameRequisicao ");
            buf.append("       ,case when exa.fil_codigo is not null then to_char(exg.exg_dataguia, 'DD/MM/YYYY') else to_char(exr.exr_dataguia, 'DD/MM/YYYY') end as validadeGuiaExameRequisicao ");
            buf.append("       ,case when exa.fil_codigo is not null then exg.exg_guia else exr.exr_guia end as guiaExameRequisicao ");
            buf.append("       ,case when exa.fil_codigo is not null then calculaprecototalexamerequisicao(exr.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, exr.exa_codigo), COALESCE(exg.mco_codfilho, exr.mco_codigo), false, COALESCE(con.con_percpgto, 0) = 0, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ");
            buf.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false").append(", COALESCE(exr.met_codigo, elm.met_codigo, emc.met_codigo) ").append(") else calculaprecototalexamerequisicao(exr.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, w.exa_codigo), COALESCE(exg.mco_codfilho, v.mco_codigo), false, COALESCE(con.con_percpgto, 0) = 0, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ");
            buf.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false").append(", COALESCE(exr.met_codigo, elm.met_codigo, emc.met_codigo) ").append(") end as valorExameConvenio ");
            buf.append("       ,exr.exr_vlrmaterial as valorMateriaisExame ");
            buf.append("       ,case when exa.fil_codigo is not null then tpe.tpe_uco else exr.exr_valoruco end as ucoCBHPMExame ");
            buf.append("       ,case when exa.fil_codigo is not null then tpp.tpp_valor else exr.exr_valorporte end as valorPorteCBHPMExame ");
            buf.append("       ,case when exa.fil_codigo is not null then tpp.tpp_porte else exr.exr_porte end as porteCBHPMExame ");
            buf.append("       ,exr.exr_vlrmaterial as valorMateriaisExame ");
            buf.append("       ,exr.exa_codigo as codigoExamePrincipal ");
            buf.append("       ,w.exa_descricao as descricaoExamePrincipal ");
            buf.append("       ,v.mco_descricao as descricaoMaterialPrincipal ");
            buf.append("       ,v.mco_abreviatura as abreviaturaMaterialPrincipal ");
            buf.append("       ,exr.exr_vlrchexame as chExamePrincipalOriginal ");
            buf.append("       ,calculachexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, exr.exa_codigo, exr.mco_codigo) as chExamePrincipal ");
            buf.append("       ,exr.exr_vlrexame as valorExamePrincipal ");
            buf.append("       ,exr.exr_vlrexame as valorExameConvenioPrincipal ");
            buf.append("       ,exr.exr_vlrmaterial as valorMateriaisExamePrincipal ");
            buf.append("       ,exr.exr_valorcusto as custoCBHPMExamePrincipal ");
            buf.append("       ,exr.exr_valoruco as ucoCBHPMExamePrincipal ");
            buf.append("       ,exr.exr_valorporte as valorPorteCBHPMExamePrincipal ");
            buf.append("       ,exr.exr_porte as porteCBHPMExamePrincipal ");
            buf.append("       ,array_to_string(array_agg(distinct COALESCE(emg1.grp_codigo, emg2.grp_codigo)), ', ') as gruposExame ");
            buf.append("       ,c10.c10_codigo as codigosCID10 ");
            buf.append("       ,c10.c10_descricao as descricoesCID10 ");
            buf.append("       ,exr.exr_ordem as ordemExame ");
            if (ordemComprovante.equals("P")) {
                buf.append("       ,u.emc_pagina ");
            }
        }
        buf.append("\t\t     , '' as codigoPrestadorNaOperadora, '' as registroANS, '' as convenioRegistroANS ");
        buf.append("         ,'' as nomeExecutante, '' as conselhoExecutante, '' as ufExecutante, '' as codigoExecutante ");
        buf.append("         ,'' as codigoCBOSPadraoTiss, '' as cartaoSUSPadraoTiss, '' as indicadorAcidenteTiss ");
        buf.append("       , filial.fil_cnes as cnesFilial, ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append(", a.req_procedencia as procedenciaRequisicao ");
        buf.append(", age(a.req_data, j.pac_datanasc) as idadeRequisicaoPaciente ");
        buf.append(", a.req_periodogestacional as periodoGestacionalRequisicao ");
        buf.append("       from requisicao a ");
        buf.append("       join examerequisicao exr on a.fil_codigo = exr.fil_codigo and a.req_codigo = exr.req_codigo ");
        buf.append("       join convenios con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
        buf.append("       left join examerequisicaoguiaagrupada exg on exr.fil_codigo = exg.fil_codigo and exr.req_codigo = exg.req_codigo and exr.exa_codigo = exg.exa_codigo and exr.mco_codigo = exg.mco_codigo ");
        buf.append("       left join exames exa on exg.fil_codigo = exa.fil_codigo and exg.exa_codfilho = exa.exa_codigo ");
        buf.append("       left join materialcoleta mco on exg.fil_codigo = mco.fil_codigo and exg.mco_codfilho = mco.mco_codigo ");
        buf.append("       left join examematcoleta emc on exg.fil_codigo = emc.fil_codigo and exg.exa_codfilho = emc.exa_codigo and exg.mco_codfilho = emc.mco_codigo ");
        buf.append("       left join examelayoutmetodo elm on exg.fil_codigo = elm.fil_codigo and exg.exa_codfilho = elm.exa_codigo and exg.mco_codfilho = elm.mco_codigo and con.lay_codigo = elm.lay_codigo and exr.met_codigo = elm.met_codigo ");
        if (precoMetodologia) {
            buf.append("     left join detalhetabelaprecometodologia dtm on exg.fil_codigo = dtm.fil_codigo and exg.exa_codfilho = dtm.exa_codigo and exg.mco_codfilho = dtm.mco_codigo and con.tpe_codigo = dtm.tpe_codigo and exr.met_codigo = dtm.met_codigo ");
        }
        buf.append("     left join detalhetabelapreco dtp on exg.fil_codigo = dtp.fil_codigo and exg.exa_codfilho = dtp.exa_codigo and exg.mco_codfilho = dtp.mco_codigo and con.tpe_codigo = dtp.tpe_codigo ");
        buf.append("       left join tabelaprecoexamesporte tpp on dtp.fil_codigo = tpp.fil_codigo and dtp.tpe_codigo = tpp.tpe_codigo and dtp.tpp_porte = tpp.tpp_porte ");
        buf.append("       left join tabelaprecoexames tpe on con.fil_codigo = tpe.fil_codigo and con.tpe_codigo = tpe.tpe_codigo ");
        buf.append("       left join medico med on a.fil_codigo = med.fil_codigo and a.med_conselho = med.med_conselho and upper(a.med_crm) = upper(med.med_crm) and a.med_uf = med.med_uf ");
        buf.append("       left join medicoconveniotiss medt on a.fil_codigo = medt.fil_codigo and a.med_conselho = medt.med_conselho and a.med_crm = medt.med_crm and a.med_uf = medt.med_uf and a.con_codigo = medt.con_codigo ");
        buf.append("       left join destino des on a.fil_codigo = des.fil_codigo and upper(a.des_codigo) = upper(des.des_codigo) ");
        buf.append("       left join coletas col on a.fil_codigo = col.fil_codigo and upper(a.col_codigo) = upper(col.col_codigo) ");
        buf.append("       left join paciente j on a.fil_codigo = j.fil_codigo and a.pac_codigo = j.pac_codigo ");
        buf.append("       left join cidades k on con.fil_codigo = k.fil_codigo and con.cid_codigo = k.cid_codigo ");
        buf.append("       left join cidades l on med.fil_codigo = l.fil_codigo and med.cid_codigo = l.cid_codigo ");
        buf.append("       left join cidades m on des.fil_codigo = m.fil_codigo and des.cid_codigo = m.cid_codigo ");
        buf.append("       left join cidades n on col.fil_codigo = n.fil_codigo and col.cid_codigo = n.cid_codigo ");
        buf.append("       left join cidades o on j.fil_codigo = o.fil_codigo and j.cid_codigo = o.cid_codigo ");
        buf.append("       left join bairro p on con.fil_codigo = p.fil_codigo and con.bai_codigo = p.bai_codigo ");
        buf.append("       left join bairro q on med.fil_codigo = q.fil_codigo and med.bai_codigo = q.bai_codigo ");
        buf.append("       left join bairro r on des.fil_codigo = r.fil_codigo and des.bai_codigo = r.bai_codigo ");
        buf.append("       left join bairro s on col.fil_codigo = s.fil_codigo and col.bai_codigo = s.bai_codigo ");
        buf.append("       left join bairro t on j.fil_codigo = t.fil_codigo and j.bai_codigo = t.bai_codigo ");
        buf.append("       left join examematcoleta u on exr.fil_codigo = u.fil_codigo and upper(exr.exa_codigo) = upper(u.exa_codigo) and exr.mco_codigo = u.mco_codigo ");
        buf.append("       left join materialcoleta v on u.fil_codigo = v.fil_codigo and u.mco_codigo = v.mco_codigo ");
        buf.append("       left join exames w on exr.fil_codigo = w.fil_codigo and upper(exr.exa_codigo) = upper(w.exa_codigo) ");
        buf.append("       left join unidadesaude us on a.fil_codigo = us.fil_codigo and a.uns_codigo = us.uns_codigo ");
        buf.append("       left join cidades cidadeus on us.fil_codigo = cidadeus.fil_codigo and us.cid_codigo = cidadeus.cid_codigo ");
        buf.append("       left join bairro bairrous on us.fil_codigo = bairrous.fil_codigo and us.bai_codigo = bairrous.bai_codigo ");
        if (precoMetodologia) {
            buf.append("     left join detalhetabelaprecometodologia dtm2 on con.fil_codigo = dtm2.fil_codigo and con.tpe_codigo = dtm2.tpe_codigo and upper(exr.exa_codigo) = upper(dtm2.exa_codigo) and exr.mco_codigo = dtm2.mco_codigo and exr.met_codigo = dtm2.met_codigo ");
        }
        buf.append("     left join detalhetabelapreco dtp2 on con.fil_codigo = dtp2.fil_codigo and con.tpe_codigo = dtp2.tpe_codigo and upper(exr.exa_codigo) = upper(dtp2.exa_codigo) and exr.mco_codigo = dtp2.mco_codigo ");
        buf.append("       left join examematgrupo emg1 on a.fil_codigo = emg1.fil_codigo and exr.exa_codigo = emg1.exa_codigo and exr.mco_codigo = emg1.mco_codigo ");
        buf.append("       left join examematgrupo emg2 on a.fil_codigo = emg2.fil_codigo and exg.exa_codigo = emg2.exa_codigo and exg.mco_codigo = emg2.mco_codigo ");
        buf.append("       left join (select rc10.fil_codigo, rc10.req_codigo, rc10.c10_codigo, cid10.c10_descricao from requisicaocid10 rc10 left join cid10 on rc10.c10_codigo = cid10.c10_codigo where rc10.fil_codigo = " + filial + " and rc10.req_codigo = " + requisicao + " limit 1) c10 on a.fil_codigo = c10.fil_codigo and a.req_codigo = c10.req_codigo ");
        if (precoMetodologia) {
            buf.append("       left join detalhetabelaprecometodologia dtm4 on con.fil_codigo = dtm4.fil_codigo and con.tpe_codigo = dtm4.tpe_codigo and upper(w.exa_codigo) = upper(dtm4.exa_codigo) and v.mco_codigo = dtm4.mco_codigo  and exr.met_codigo = dtm4.met_codigo ");
        }
        buf.append("       left join detalhetabelapreco dtp4 on con.fil_codigo = dtp4.fil_codigo and con.tpe_codigo = dtp4.tpe_codigo and upper(w.exa_codigo) = upper(dtp4.exa_codigo) and v.mco_codigo = dtp4.mco_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        if (ordenarSetor) {
            buf.append("       left join examesetor exmsetor on w.fil_codigo = exmsetor.fil_codigo and w.exa_codigo = exmsetor.exa_codigo and exmsetor.ese_default = true ");
        }
        buf.append(" where a.fil_codigo = ").append(filial);
        buf.append("   and a.req_codigo = ").append(requisicao);
        buf.append("   and (a.req_excluida = false or (a.req_excluida = true and a.req_origemagendamento = true)) ");
        buf.append("   and exr.exr_excluido = false ");
        buf.append("   and (exr.exr_naofaturar = false or exr.exr_naofaturar is null) ");
        buf.append("   and exr.exr_datacortesia is null ");
        if (!imprimirExameMatFaltante) {
            buf.append(" and (exr.exr_situacao <> '").append("F").append("' or coalesce(con.con_imprimirfaltamaterialguia, false) ) ");
        }
        if (guia != null && !Funcoes.textoVazio(guia)) {
            buf.append(" and CASE WHEN exg.exg_guia IS NOT NULL THEN exg.exg_guia = '").append(guia).append("' ELSE (exr.exr_guia = '").append(guia).append("' or exg.exg_guia = '").append(guia).append("') END ");
        } else {
            buf.append(" and (NULLIF(exg.exg_guia, '') IS NULL and NULLIF(exr.exr_guia, '') IS NULL) ");
        }
        buf.append(" group by exa.fil_codigo ");
        if (precoMetodologia) {
            buf.append("         ,trim(dtm.dtm_codamb) ");
            buf.append("         ,trim(dtm2.dtm_codamb) ");
        }
        if (!agrupaAmbGuia) {
            buf.append("         ,exr.met_codigo ");
        }
        buf.append("         ,elm.met_codigo ");
        buf.append("         ,emc.met_codigo ");
        buf.append("         ,trim(dtp.dtp_codamb) ");
        buf.append("         ,trim(dtp2.dtp_codamb) ");
        buf.append("         ,medt.mec_codigooperadora ");
        buf.append("         ,a.req_codigo ");
        buf.append("         ,a.req_data ");
        buf.append("         ,a.req_dtfatura ");
        buf.append("         ,a.req_urgente ");
        buf.append("         ,a.req_dataentregaprev ");
        buf.append("         ,a.req_dclinicos ");
        buf.append("         ,a.req_obs ");
        buf.append("         ,a.req_totpago ");
        buf.append("         ,a.req_horaentregaprev ");
        buf.append("         ,a.req_total ");
        buf.append("         ,a.req_horafatura ");
        buf.append("         ,a.req_hora ");
        buf.append("         ,a.req_gestante ");
        buf.append("         ,a.req_dum ");
        buf.append("         ,a.req_idade ");
        buf.append("         ,a.req_anomes ");
        buf.append("         ,a.req_matricula ");
        buf.append("         ,a.req_avisarpaciente ");
        buf.append("         ,a.req_senhaweb ");
        buf.append("         ,a.req_titular ");
        buf.append("         ,a.req_peso ");
        buf.append("         ,a.req_altura ");
        buf.append("         ,a.req_desconto ");
        buf.append("         ,a.req_vlrdesconto ");
        buf.append("         ,a.req_notacaixa ");
        buf.append("         ,a.req_vlrexames ");
        buf.append("         ,a.req_vlrmateriais ");
        buf.append("         ,a.req_guia ");
        buf.append("         ,a.req_validadeguia ");
        buf.append("         ,a.req_dataguia ");
        buf.append("         ,a.req_acrescimo ");
        buf.append("         ,a.req_vlracrescimo ");
        buf.append("         ,a.req_tipoultpagamento ");
        buf.append("         ,a.req_validadecarteira ");
        buf.append("         ,a.req_nomeplano ");
        buf.append("         ,a.req_guiaprincipal ");
        buf.append("         ,a.sit_codigo ");
        buf.append("         ,a.usr_codigo ");
        buf.append("         ,a.req_prontuario ");
        buf.append("         ,a.req_cartaosus ");
        buf.append("         ,a.usr_codabertura ");
        buf.append("         ,a.des_codigo ");
        buf.append("         ,a.col_codigo ");
        buf.append("         ,a.fil_codigo ");
        buf.append("         ,a.req_cpfresponsavel");
        buf.append("         ,a.req_incapacitado");
        buf.append("         ,k.cid_codigo ");
        buf.append("         ,k.cid_nome ");
        buf.append("         ,k.cid_uf ");
        buf.append("         ,l.cid_codigo ");
        buf.append("         ,l.cid_nome ");
        buf.append("         ,l.cid_uf ");
        buf.append("         ,m.cid_codigo ");
        buf.append("         ,m.cid_nome ");
        buf.append("         ,m.cid_uf ");
        buf.append("         ,n.cid_codigo ");
        buf.append("         ,n.cid_nome ");
        buf.append("         ,n.cid_uf ");
        buf.append("         ,o.cid_codigo ");
        buf.append("         ,o.cid_nome ");
        buf.append("         ,o.cid_uf ");
        buf.append("         ,p.bai_codigo ");
        buf.append("         ,p.bai_descricao ");
        buf.append("         ,q.bai_codigo ");
        buf.append("         ,q.bai_descricao ");
        buf.append("         ,r.bai_codigo ");
        buf.append("         ,r.bai_descricao ");
        buf.append("         ,s.bai_codigo ");
        buf.append("         ,s.bai_descricao ");
        buf.append("         ,t.bai_codigo ");
        buf.append("         ,t.bai_descricao ");
        buf.append("         ,des.des_descricao ");
        buf.append("         ,des.des_endereco ");
        buf.append("         ,des.des_complemento ");
        buf.append("         ,des.des_cep ");
        buf.append("         ,des.des_fone ");
        buf.append("         ,col.col_descricao ");
        buf.append("         ,col.col_endereco ");
        buf.append("         ,col.col_complemento ");
        buf.append("         ,col.col_cep ");
        buf.append("         ,col.col_fone ");
        buf.append("         ,med.med_conselho ");
        buf.append("         ,med.med_crm ");
        buf.append("         ,med.med_uf ");
        buf.append("         ,med.med_nome ");
        buf.append("         ,med.med_abrev ");
        buf.append("         ,med.med_endereco ");
        buf.append("         ,med.med_numeroendereco ");
        buf.append("         ,med.med_tipologradouroendereco ");
        buf.append("         ,med.med_complemento ");
        buf.append("         ,med.med_cep ");
        buf.append("         ,med.med_fone ");
        buf.append("         ,med.med_celular ");
        buf.append("         ,med.med_fax ");
        buf.append("         ,med.med_email ");
        buf.append("         ,med.med_site ");
        buf.append("         ,med.med_cpf ");
        buf.append("         ,con.con_codigo ");
        buf.append("         ,con.con_fantasia ");
        buf.append("         ,con.con_razao ");
        buf.append("         ,con.con_endereco ");
        buf.append("         ,con.con_numeroendereco ");
        buf.append("         ,con.con_tipologradouroendereco ");
        buf.append("         ,con.con_complemento ");
        buf.append("         ,con.con_cep ");
        buf.append("         ,con.con_fone ");
        buf.append("         ,con.con_email1 ");
        buf.append("         ,con.con_email2 ");
        buf.append("         ,con.con_site ");
        buf.append("         ,con.con_cnpjcpf ");
        buf.append("         ,tpe.tpe_codigo ");
        buf.append("         ,tpe.tpe_descricao ");
        buf.append("         ,tpe.tpe_moeda ");
        buf.append("         ,tpe.tpe_tabelaans ");
        buf.append("         ,tpe.tpe_valorch ");
        buf.append("         ,j.pac_codigo ");
        buf.append("         ,j.pac_nome ");
        buf.append("         ,j.pac_sexo ");
        buf.append("         ,j.pac_datanasc ");
        buf.append("         ,j.pac_grpsangue ");
        buf.append("         ,j.pac_fatorrh ");
        buf.append("         ,j.pac_fatordu ");
        buf.append("         ,j.pac_cor ");
        buf.append("         ,j.pac_profissao ");
        buf.append("         ,j.pac_rg ");
        buf.append("         ,j.pac_cpf ");
        buf.append("         ,j.pac_estcivil ");
        buf.append("         ,j.pac_dum ");
        buf.append("         ,j.pac_fone ");
        buf.append("         ,j.pac_celular ");
        buf.append("         ,j.pac_fax ");
        buf.append("         ,j.pac_fonecomercial ");
        buf.append("         ,j.pac_endereco ");
        buf.append("         ,j.pac_numeroendereco ");
        buf.append("         ,j.pac_tipologradouroendereco ");
        buf.append("         ,j.pac_complemento ");
        buf.append("         ,j.pac_cep ");
        buf.append("         ,j.pac_email ");
        buf.append("         ,j.pac_fonecontato ");
        buf.append("         ,j.pac_nomecontato ");
        buf.append("         ,j.pac_validadecarteira ");
        buf.append("         ,j.pac_nomeplano ");
        buf.append("         ,j.pac_codigoapoiado ");
        buf.append("         ,j.pac_cartaosus ");
        buf.append("         ,j.pac_nomesocial ");
        buf.append("         ,j.pac_whatsapp ");
        buf.append("         ,us.uns_codigo ");
        buf.append("         ,us.uns_descricao ");
        buf.append("         ,us.uns_endereco ");
        buf.append("         ,us.uns_complemento ");
        buf.append("         ,us.uns_cep ");
        buf.append("         ,us.uns_fone ");
        buf.append("         ,cidadeus.cid_codigo ");
        buf.append("         ,cidadeus.cid_nome ");
        buf.append("         ,cidadeus.cid_uf ");
        buf.append("         ,bairrous.bai_codigo ");
        buf.append("         ,bairrous.bai_descricao ");
        buf.append("         ,med.med_cbo ");
        buf.append("         ,a.req_neonato ");
        buf.append("         ,a.req_procedencia ");
        buf.append("         ,a.req_responsavel");
        buf.append("         ,j.pac_responsavel ");
        buf.append("         ,j.pac_cpfresponsavel ");
        buf.append("         ,j.pac_incapacitado");
        buf.append("         ,idadeRequisicaoPaciente");
        if (!agrupaAmbGuia) {
            buf.append("         ,exr.exr_codautorizacao ");
            buf.append("         ,exr.exr_dataautorizacao ");
            buf.append("         ,exr.exr_datavalidadeautorizacao ");
            buf.append("         ,exr.exr_vlrch ");
            buf.append("         ,a.con_codigo ");
            buf.append("         ,exr.exa_codigo ");
            buf.append("         ,exr.mco_codigo ");
            buf.append("         ,exa.exa_descricao ");
            buf.append("         ,w.exa_descricao ");
            buf.append("         ,mco.mco_descricao ");
            buf.append("         ,v.mco_descricao ");
            buf.append("         ,mco.mco_abreviatura ");
            buf.append("         ,v.mco_abreviatura ");
            buf.append("         ,exr.fil_codigo ");
            buf.append("         ,exg.exa_codfilho ");
            buf.append("         ,exg.mco_codfilho ");
            buf.append("         ,con.con_percpgto ");
            buf.append("         ,w.exa_codigo ");
            buf.append("         ,v.mco_codigo ");
            buf.append("         ,exr.exr_vlrchexame ");
            buf.append("         ,exr.exr_valorporte ");
            buf.append("         ,exr.exr_valorcusto ");
            buf.append("         ,exr.exr_valoruco ");
            buf.append("         ,exr.exr_vlrbalcaoconvenio ");
            buf.append("         ,exr.exr_datafatura ");
            buf.append("         ,exr.usr_codfatura ");
            buf.append("         ,exr.exr_vlrmaterial ");
            buf.append("         ,con.con_precosdiferenciados ");
            buf.append("         ,con.con_reajuste ");
            buf.append("         ,con.con_cobrmaterial ");
            buf.append("         ,con.con_percpgtomaterial ");
            buf.append("         ,con.con_tpcalcfatu ");
            buf.append("         ,con.con_tpcalcch ");
            buf.append("         ,con.con_perguntarpercbalcao ");
            buf.append("         ,con.con_acrescimo ");
            buf.append("         ,con.con_bonus ");
            buf.append("         ,con.tpe_codigo ");
            buf.append("         ,con.con_acrescimoporte ");
            buf.append("         ,con.con_acrescimouco ");
            buf.append("         ,con.con_descontoporte ");
            buf.append("         ,con.con_descontouco ");
            buf.append("         ,con.con_valorch ");
            buf.append("         ,exg.exg_dataguia ");
            buf.append("         ,exr.exr_dataguia ");
            buf.append("         ,exg.exg_validadeguia ");
            buf.append("         ,exr.exr_validadeguia ");
            buf.append("         ,exg.exg_guia ");
            buf.append("         ,exr.exr_guia  ");
            buf.append("         ,tpe.tpe_uco ");
            buf.append("         ,exr.exr_valoruco ");
            buf.append("         ,tpp.tpp_valor ");
            buf.append("         ,exr.exr_valorporte ");
            buf.append("         ,tpp.tpp_porte ");
            buf.append("         ,exr.exr_porte ");
            buf.append("         ,exr.exr_vlrexame ");
            buf.append("         ,c10.c10_codigo ");
            buf.append("         ,c10.c10_descricao ");
            buf.append("         ,exr.exr_ordem ");
            if (precoMetodologia) {
                buf.append("         ,dtm.dtm_valor ");
                buf.append("         ,dtm4.dtm_codamb ");
            }
            buf.append("         ,dtp.dtp_valor ");
            buf.append("         ,dtp4.dtp_codamb ");
        }
        if (!agrupaAmbGuia && ordemComprovante.equals("P")) {
            buf.append("         ,u.emc_pagina ");
        }
        if (ordenarSetor) {
            buf.append(" ,exmsetor.set_codigo ");
        }
        buf.append(" , filial.fil_cnes, ");
        buf.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
        buf.append(", a.req_periodogestacional ");
        buf.append(" order by ");
        if (ordemComprovante.equals("A")) {
            buf.append(" ordemExame ");
        } else {
            if (ordenarSetor) {
                buf.append(" exmsetor.set_codigo, ");
            }
            if (ordemComprovante.equals("C")) {
                if (agrupaAmbGuia) {
                    buf.append(" array_to_string(array_agg(case when exa.fil_codigo is not null then exg.exa_codfilho else exr.exa_codigo end), ', ') ");
                } else {
                    buf.append(" case when exa.fil_codigo is not null then exg.exa_codfilho else exr.exa_codigo end ");
                }
            } else if (ordemComprovante.equals("P")) {
                buf.append(" emc_pagina, ordemExame ");
            }
        }
        return buf.toString();
    }

    private static boolean isVersaoTissAcima3000(Registro configTiss) {
        if (configTiss != null && configTiss.possuiCampo("versaoTiss")) {
            VersaoTiss versao = VersaoTiss.getVersaoPorDescricao(configTiss.getString("versaoTiss"));
            return versao.isVersaoMaior(VersaoTiss.V_3_01_00);
        }
        return false;
    }

    public static Registro getDadosRequisicao(String filial, String requisicao) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        Object configTiss = null;
        buf.setLength(0);
        buf.append(" select b.med_cbo as xmlCBOMedico, c.con_codigo, c.con_razao from requisicao a ");
        buf.append(" left join medico  b on a.fil_codigo = b.fil_codigo  and a.med_crm = b.med_crm and a.med_uf = b.med_uf and a.med_conselho = b.med_conselho ");
        buf.append(" left join convenios  c on a.fil_codigo = c.fil_codigo  and a.con_codigo = c.con_codigo  ");
        buf.append(" where a.fil_codigo = ").append(filial).append(" and req_codigo = ").append(requisicao);
        ResultSet rsMedico = Conexao.executeQuery(st, buf);
        if (rsMedico.next()) {
            String cbo = Funcoes.textoVazio(rsMedico.getString("xmlCBOMedico")) ? "" : rsMedico.getString("xmlCBOMedico");
            String aux = StringUtil.getValor(cbo, "cbo");
            Registro registro = new Registro(rsMedico);
            registro.setValor("codigoCBOMedico", aux != null ? aux : "");
            return registro;
        }
        return null;
    }

    public static Registro getConfiguracaoTiss(String filial, String requisicao) throws SQLException {
        return ImprimirGuia.getConfiguracaoTiss(filial, requisicao, Conexao.getStatement());
    }

    public static Registro getConfiguracaoTiss(String filial, String requisicao, Statement st) throws SQLException {
        String xml;
        StringBuilder buf = new StringBuilder();
        Registro configTiss = null;
        buf.setLength(0);
        buf.append("select b.con_faturaeletronica from requisicao a ");
        buf.append(" left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
        buf.append(" where a.fil_codigo = ").append(filial);
        buf.append(" and a.req_codigo = ").append(requisicao);
        ResultSet rsTiss = st.executeQuery(buf.toString());
        if (rsTiss.next() && !DBUtil.campoNull(rsTiss.getString("con_faturaeletronica")) && !Funcoes.textoVazio(rsTiss.getString("con_faturaeletronica")) && StringUtil.getValor(xml = rsTiss.getString("con_faturaeletronica"), "protocolo").equals(Tiss.getNomeProtocolo())) {
            configTiss = new Registro();
            configTiss.setValor("codigoPrestadorNaOperadora", StringUtil.getValor(xml, "codigoPrestadorNaOperadora"));
            configTiss.setValor("registroANS", StringUtil.getValor(xml, "registroANS"));
            configTiss.setValor("convenioRegistroANS", StringUtil.getValor(xml, "convenioRegistroANS"));
            configTiss.setValor("nomeExecutante", StringUtil.getValor(xml, "nomeExecutante"));
            configTiss.setValor("conselhoExecutante", StringUtil.getValor(xml, "conselhoExecutante"));
            configTiss.setValor("ufExecutante", StringUtil.getValor(xml, "ufExecutante"));
            configTiss.setValor("codigoExecutante", StringUtil.getValor(xml, "codigoExecutante"));
            configTiss.setValor("cartaoSUSPadraoTiss", StringUtil.getValor(xml, "cartaoSUS"));
            configTiss.setValor("indicadorAcidenteTiss", Tiss.getCodigoIndicadorAcidente(StringUtil.getValor(xml, "indicadorAcidente")));
            configTiss.setValor("versaoTiss", StringUtil.getValor(xml, "versaoArquivo"));
            if (CBOS.getDescCBO(StringUtil.getValor(xml, "cbosPadrao")) != null) {
                configTiss.setValor("codigoCBOSPadraoTiss", CBOS.getDescCBO((String)StringUtil.getValor((String)xml, (String)"cbosPadrao")).codigo);
            } else {
                configTiss.setValor("codigoCBOSPadraoTiss", "");
            }
        }
        return configTiss;
    }

    private static String[] getCodigoValidadeExameList(String filial, String requisicao, Statement statement) throws SQLException {
        StringBuilder sql = new StringBuilder();
        HashSet<String> codAutorizacaoList = new HashSet<String>();
        HashSet<String> dataValidadeAutorizazaoList = new HashSet<String>();
        sql.append("select distinct NULLIF(TRIM(exr_codautorizacao), '') as exr_codautorizacao, NULLIF(TRIM(cast(exr_datavalidadeautorizacao as varchar)), '') as exr_datavalidadeautorizacao ");
        sql.append("  from examerequisicao where fil_codigo = ").append(filial);
        sql.append("   and exr_excluido = false ");
        sql.append("   and ").append(" req_codigo = ").append(requisicao);
        sql.append("   and exr_datacortesia is null ");
        sql.append(" order by exr_datavalidadeautorizacao ");
        ResultSet rs = statement.executeQuery(sql.toString());
        if (rs.next()) {
            do {
                if (rs.getString("exr_codautorizacao") != null) {
                    codAutorizacaoList.add(rs.getString("exr_codautorizacao") != null ? rs.getString("exr_codautorizacao") : "");
                }
                if (rs.getDate("exr_datavalidadeautorizacao") == null) continue;
                dataValidadeAutorizazaoList.add(rs.getDate("exr_datavalidadeautorizacao") != null ? Funcoes.formataData(rs.getDate("exr_datavalidadeautorizacao")) : "");
            } while (rs.next());
        }
        rs.close();
        String dataValidadeAutorizazao = ((Object)dataValidadeAutorizazaoList).toString().replace("[", "").replace("]", "");
        String codigoAutorizacao = ((Object)codAutorizacaoList).toString().replace("[", "").replace("]", "");
        return new String[]{dataValidadeAutorizazao, codigoAutorizacao};
    }

    public static String[] adicionaColunasGuia(String[] campos, int qtdeColunas) {
        String[] novo = new String[campos.length + QTDE_CAMPOS_GUIA * (qtdeColunas == 0 ? 1 : qtdeColunas)];
        for (int i = 0; i < campos.length; ++i) {
            novo[i] = campos[i];
        }
        int ultimaPosicao = campos.length;
        if (qtdeColunas <= 1) {
            for (int i = 0; i < QTDE_CAMPOS_GUIA; ++i) {
                novo[ultimaPosicao++] = ADICIONAIS_GUIA[i];
            }
        } else {
            for (int contador = 1; contador <= qtdeColunas; ++contador) {
                for (int i = 0; i < QTDE_CAMPOS_GUIA; ++i) {
                    novo[ultimaPosicao++] = ADICIONAIS_GUIA[i] + String.valueOf(contador);
                }
            }
        }
        return novo;
    }

    private static int buscaQtdeColunasGuia(String filial, String requisicao, Statement st, int qtdeExamesCC) throws SQLException {
        StringBuilder buf = new StringBuilder("select b.con_qtdecolunas from requisicao a ");
        buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
        buf.append("where a.fil_codigo = ").append(filial);
        buf.append(" and a.req_codigo = ").append(requisicao);
        ResultSet rs = st.executeQuery(buf.toString());
        int retorno = qtdeExamesCC;
        if (rs.next() && !DBUtil.campoNull(rs.getString("con_qtdecolunas"))) {
            retorno = rs.getInt("con_qtdecolunas");
        }
        return retorno;
    }

    public static String validaCbo(String codigoCBOMedico, String versaoTiss, String codigoCBOSPadraoTiss, String filial, String requisicao, String codigoConvenio) {
        if (Tiss.verificaVersaoTiss3(versaoTiss) && Tiss.validaCboValidoVersao3000(versaoTiss, codigoCBOMedico)) {
            return String.format("CBOS do m\u00e9dico ou conv\u00eanio configurado n\u00e3o \u00e9 v\u00e1lido para a vers\u00e3o do Tiss:\nFilial: %s\nRequisi\u00e7\u00e3o: %s\nConv\u00eanio: %s\nTiss: %s\nDados CBOS do m\u00e9dico:%s\nCBOS do conv\u00eanio: %s\n ", filial, requisicao, codigoConvenio, versaoTiss, codigoCBOMedico, codigoCBOSPadraoTiss);
        }
        return "";
    }

    public static void validarImprimirGuias(int tipoGuia, LinhasTabela linhas, List<String> errosGeracao, boolean imprimir, FrmPadrao form) {
        for (int i = 0; i < linhas.getRowCount(); ++i) {
            if (!(linhas.getValueAt(i, 1) instanceof DadosFaturamento)) continue;
            ImprimirGuia.validarImprimirGuia(tipoGuia, linhas, errosGeracao, imprimir, form, i);
        }
    }

    public static void validarImprimirGuia(int tipoGuia, LinhasTabela linhas, List<String> errosGeracao, boolean imprimir, FrmPadrao form, int row) {
        int codigoRequisicao = ((DadosFaturamento)linhas.getValueAt(row, 1)).getRequisicao();
        String codigoFilial = String.valueOf(((DadosFaturamento)linhas.getValueAt(row, 1)).getCodigoFilial());
        try {
            if (!imprimir) {
                String configInvalida;
                Registro configTiss = ImprimirGuia.getConfiguracaoTiss(codigoFilial, String.valueOf(codigoRequisicao));
                Registro dadosRequisicao = ImprimirGuia.getDadosRequisicao(codigoFilial, String.valueOf(codigoRequisicao));
                boolean isVersao3 = false;
                String cbosTiss = "";
                if (null != configTiss) {
                    boolean bl;
                    isVersao3 = Tiss.verificaVersaoTiss3(configTiss.getValor("versaoTiss").toString());
                    String versaoTiss = configTiss != null && configTiss.possuiCampo("versaoTiss") ? configTiss.getValor("versaoTiss").toString() : "";
                    cbosTiss = Tiss.getCodigoCBO(dadosRequisicao.getValor("codigoCBOMedico").toString(), configTiss.getValor("codigoCBOSPadraoTiss").toString(), VersaoTiss.getVersaoPorDescricao(versaoTiss));
                    boolean bl2 = bl = dadosRequisicao.getValor("codigoCBOMedico").toString().equals("9999.99") || dadosRequisicao.getValor("codigoCBOMedico").toString().equals("0000.00") || configTiss.getValor("codigoCBOSPadraoTiss").toString().equals("9999.99") || configTiss.getValor("codigoCBOSPadraoTiss").toString().equals("0000.00");
                }
                if (isVersao3 && cbosTiss == null && !Funcoes.textoVazio(configInvalida = ImprimirGuia.validaCbo(dadosRequisicao.getValor("codigoCBOMedico").toString(), configTiss.getValor("versaoTiss").toString(), configTiss.getValor("codigoCBOSPadraoTiss").toString(), codigoFilial, String.valueOf(codigoRequisicao), dadosRequisicao.getString("codigoConvenio").toString()))) {
                    errosGeracao.add(configInvalida);
                }
            } else {
                Impressao.imprimirGuia(form.getTopLevelAncestor(), codigoFilial, String.valueOf(codigoRequisicao), true, tipoGuia);
            }
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(form, ex.getMessage(), ex.getStackTrace(), "FaturaExames (526)");
        }
    }
}

