/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import jalis.apoio.servidorws.parametroset.ParametroSet;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configurador.DialogoConfigurador;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.impressao.ImpressaoException;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Etiqueta;
import jalis.laboratorio.util.impressao.ExameAdicionado;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ArrayListAgrupadorDados;
import jalis.laboratorio.util.impressao.exame.DadosGrupoExame;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ListaExameMaterial;
import jalis.laboratorio.util.impressao.exame.externo.ImpressaoExameLabExternoService;
import jalis.laboratorio.util.impressao.exame.externo.ImpressaoVO;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.impressao.sql.ValorIn;
import jalis.laboratorio.util.interfaceamento.ExportarInterface;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.relatorio.Gerador;
import jalis.service.recepcao.ExameRequisicaoService;
import jalis.service.triagem.LoteExternoExameRequisicaoService;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.print.PrintService;

public class ImprimirEtiquetasColetaTriagem {
    public static final int TIPO_COLETA = 1;
    public static final int TIPO_TRIAGEM = 2;
    public static final int TIPO_COLETA_SELECIONADA = 3;
    public static final int TIPO_TRIAGEM_SELECIONADA = 4;
    private static String codigoConvenio;
    private static String codigoDestino;

    public static void imprimir(String filial, String requisicao, boolean reimprimir, String usuario, int tipo) throws Exception {
        ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, null, null, reimprimir, usuario, tipo, true);
    }

    public static boolean imprimir(String filial, String requisicao, String usuario, int tipo) throws Exception {
        return ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, null, null, true, usuario, tipo, true);
    }

    private static ModeloGridTable geraModeloDados(boolean isColetaWeb, String filial, String requisicao, String[] exames, int[] materiais, boolean reimprimir, String[] campos, String situacaoAdicional, Statement st1, Statement st2, Statement st3, String usuario, int tipoEtiqueta, boolean atualizarCodigoApoiado, ListaExameMaterial<ExameMaterial> listaExamesHPDirectNaoImprimir, List<ParametroSet> listExames, boolean agruparGuiasInterface, String parametroImprimirEtqTriagemSemMaterial, boolean parametroImprimirEtqColetaSemMaterial, boolean parametroImprimirEtqColetaSelecionadaSemMaterial, boolean agruparEtiquetaPorQtde, String tipoExportacaoInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario) throws SQLException {
        return ImprimirEtiquetasColetaTriagem.geraModeloDados(isColetaWeb, filial, requisicao, exames, materiais, reimprimir, campos, situacaoAdicional, st1, st2, st3, usuario, tipoEtiqueta, atualizarCodigoApoiado, listaExamesHPDirectNaoImprimir, listExames, false, agruparGuiasInterface, parametroImprimirEtqTriagemSemMaterial, parametroImprimirEtqColetaSemMaterial, parametroImprimirEtqColetaSelecionadaSemMaterial, agruparEtiquetaPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario);
    }

    private static ModeloGridTable geraModeloDados(boolean isColetaWeb, String filial, String requisicao, String[] exames, int[] materiais, boolean reimprimir, String[] campos, String situacaoAdicional, Statement st1, Statement st2, Statement st3, String usuario, int tipoEtiqueta, boolean atualizarCodigoApoiado, ListaExameMaterial<ExameMaterial> listaExamesHPDirectNaoImprimir, List<ParametroSet> listExames, boolean isEnviarEtiquetaComoApoio, boolean agruparGuiasInterface, String parametroImprimirEtqTriagemSemMaterial, boolean parametroImprimirEtqColetaSemMaterial, boolean parametroImprimirEtqColetaSelecionadaSemMaterial, boolean agruparEtiquetaPorQtde, String tipoExportacaoInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario) throws SQLException {
        List<Etiqueta> listaEtiquetas = null;
        listaEtiquetas = ImprimirEtiquetasColetaTriagem.criaEtiqueta(isColetaWeb, filial, requisicao, exames, materiais, reimprimir, situacaoAdicional, st1, st2, st3, usuario, tipoEtiqueta, atualizarCodigoApoiado, listaExamesHPDirectNaoImprimir, listExames, isEnviarEtiquetaComoApoio, "", agruparGuiasInterface, parametroImprimirEtqTriagemSemMaterial, parametroImprimirEtqColetaSemMaterial, parametroImprimirEtqColetaSelecionadaSemMaterial, agruparEtiquetaPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario);
        ModeloGridTable modeloDados = new ModeloGridTable(campos);
        if (listaEtiquetas != null && !listaEtiquetas.isEmpty()) {
            int ultimaPosicao = 0;
            int linha = 0;
            for (int i = 0; i < listaEtiquetas.size(); ++i) {
                ultimaPosicao = 0;
                Etiqueta c = listaEtiquetas.get(i);
                modeloDados.addLine(new Object[campos.length]);
                linha = modeloDados.getRowCount() - 1;
                Map<String, Object> respostasRequisicao = null;
                for (int j = 0; j < campos.length; ++j) {
                    if (campos[j].equalsIgnoreCase("quantidadeEtiquetas")) {
                        modeloDados.setValueAt(listaEtiquetas.size(), linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("tipoRecebimentoProdutoRequisicao")) {
                        modeloDados.setValueAt(Tipos.tipoRecebimentoProduto(c.tipoRecebimentoProdutoRequisicao), linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("exameParaRecoleta")) {
                        modeloDados.setValueAt(ImprimirEtiquetasColetaTriagem.getExamesParaRecoleta(st2, filial, requisicao, c.exameParaRecoleta), linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("dadosClinicosRequisicao")) {
                        String dadosClinicos = StringUtil.removeCaractere(c.dadosClinicosRequisicao, '\"');
                        modeloDados.setValueAt(dadosClinicos.trim(), linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("guiaRequisicao")) {
                        String guiaRequisicao = c.guiaRequisicao == null ? "" : c.guiaRequisicao;
                        modeloDados.setValueAt(guiaRequisicao.trim(), linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("codigoUsuarioAbertura")) {
                        modeloDados.setValueAt(c.codigoUsuarioAbertura, linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("nomeUsuarioAbertura")) {
                        modeloDados.setValueAt(c.nomeUsuarioAbertura, linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("caracteristicasSanitariasProdutoRequisicao")) {
                        String caracteristicasSanitariasProdutoRequisicao = c.caracteristicasSanitariasProdutoRequisicao == null ? "" : c.caracteristicasSanitariasProdutoRequisicao;
                        modeloDados.setValueAt(caracteristicasSanitariasProdutoRequisicao.trim(), linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("perguntasRequisicao") && null != c.perguntasRequisicao && !Funcoes.textoVazio(c.perguntasRequisicao)) {
                        respostasRequisicao = Resultado.getCamposResultado(c.perguntasRequisicao);
                        modeloDados.setValueAt(c.caracteristicasSanitariasProdutoRequisicao, linha, ultimaPosicao++);
                        continue;
                    }
                    if (respostasRequisicao != null && !respostasRequisicao.isEmpty() && respostasRequisicao.containsKey(campos[j].toLowerCase())) {
                        int line = linha;
                        respostasRequisicao.entrySet().forEach(k -> {
                            int pos = ArraysUtil.indice((Object[])campos, (String)k.getKey());
                            if (pos > -1) {
                                modeloDados.setValueAt(k.getValue(), line, pos);
                            }
                        });
                        continue;
                    }
                    modeloDados.setValueAt(c.getValue(campos[j]), linha, ultimaPosicao++);
                }
            }
        }
        return modeloDados;
    }

    public static boolean getExamesParaRecoleta(Statement st, String filial, String requisicao, ArrayList<ExameAdicionado> exames) throws SQLException {
        if (exames == null || exames.size() == 0) {
            return false;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select count(req_codigo) from examerequisicaosituacoes ");
        buf.append("where fil_codigo = ").append(filial);
        buf.append("  and req_codigo = ").append(requisicao);
        buf.append("  and (");
        for (int i = 0; i < exames.size(); ++i) {
            buf.append("(exa_codigo = '").append(StringUtil.textoDB(exames.get((int)i).codigoExame)).append("' ");
            buf.append(" and mco_codigo = ").append(exames.get((int)i).codigoMaterial);
            buf.append(")");
            if (exames.size() <= 1 || i >= exames.size() - 1) continue;
            buf.append(" or ");
        }
        buf.append(") and ers_situacao = '").append("R").append("'");
        ResultSet rs = st.executeQuery(buf.toString());
        return rs.next() && rs.getInt(1) > 0;
    }

    public static void imprimir(String filial, String requisicao, String[] exames, int[] materiais, boolean reimprimir, String usuario, int tipoEtiqueta) throws Exception {
        ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, exames, materiais, reimprimir, usuario, tipoEtiqueta, true);
    }

    public static boolean imprimir(String filial, String codigoRequisicao, String[] exames, int[] materiais, boolean reimprimir, String usuario, int tipoEtiqueta, boolean mostrarMensagem) throws Exception {
        return ImprimirEtiquetasColetaTriagem.imprimir(filial, codigoRequisicao, exames, materiais, reimprimir, usuario, tipoEtiqueta, mostrarMensagem, true, false);
    }

    public static boolean imprimir(String filial, String codigoRequisicao, String[] exames, int[] materiais, boolean reimprimir, String usuario, int tipoEtiqueta, boolean mostrarMensagem, boolean impressaoAutomaticaColetaSelecionada, boolean isAgendamento) throws Exception {
        return ImprimirEtiquetasColetaTriagem.imprimir(filial, codigoRequisicao, exames, materiais, reimprimir, usuario, tipoEtiqueta, mostrarMensagem, true, impressaoAutomaticaColetaSelecionada, isAgendamento);
    }

    public static boolean imprimir(String filial, String codigoRequisicao, String[] exames, int[] materiais, boolean reimprimir, String usuario, int tipoEtiqueta, boolean mostrarMensagem, boolean naoEnviaParaImpressora, boolean impressaoAutomaticaColetaSelecionada, boolean isAgendamento) throws Exception {
        ImpressorasLabExterno impressoras = new ImpressorasLabExterno();
        impressoras.setImpressoraAlvaro(ParametrosLocais.getParametro("impressoraWebServiceAlvaro"));
        impressoras.setImpressoraDiagnosticosBrasil(ParametrosLocais.getParametro("impressoraWebServiceDb"));
        impressoras.setImpressoraIndLab("");
        impressoras.setImpressoraJalisWS(ParametrosLocais.getParametro("impressoraJalisWs"));
        impressoras.setImpressoraMercolab(ParametrosLocais.getParametro("impressoraWebServiceMercolab"));
        impressoras.setImpressoraPardini(ParametrosLocais.getParametro("impressoraWebServiceHp"));
        impressoras.setImpressoraRedeWS(ParametrosLocais.getParametro("impressoraWebServiceRede"));
        impressoras.setImpressoraSoftLab(ParametrosLocais.getParametro("impressoraWebServiceSoftLab"));
        impressoras.setImpressoraShift(ParametrosLocais.getParametro("impressoraWebServiceShift"));
        impressoras.setImpressoraMaricondi(ParametrosLocais.getParametro("impressoraWebServiceMaricondi"));
        impressoras.setImpressoraSaoMarcos(ParametrosLocais.getParametro("impressoraWebServiceSm"));
        impressoras.setImpressoraEtqTriagem(ParametrosLocais.getParametro("impressoraEtqTriagem"));
        impressoras.setImpressoraEtqColeta(ParametrosLocais.getParametro("impressoraEtqColeta"));
        impressoras.setImpressoraRelatorio(ParametrosLocais.getParametro("impressoraRelatorio"));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        Statement st3 = Conexao.getStatement();
        Statement st4 = Conexao.getStatement();
        ImprimirEtiquetasColetaTriagem etiqueta = new ImprimirEtiquetasColetaTriagem();
        RetornoImpressaoEtiquetas retorno = etiqueta.imprimir(false, filial, codigoRequisicao, exames, materiais, reimprimir, usuario, tipoEtiqueta, mostrarMensagem, naoEnviaParaImpressora, impressaoAutomaticaColetaSelecionada, isAgendamento, ParametrosLocais.getParametro("impressoraEtqColeta"), ParametrosLocais.getParametro("impressoraEtqTriagem"), ParametrosGerais.getAgruparInterface(), ParametrosGerais.isAgruparGuiasInterface(), st, st2, st3, st4, Variaveis.filialPadrao, ParametrosLocais.getParametro("imprimirEtiquetaTriagemSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSelecionadaSemMaterial"), ParametrosGerais.isAgruparEtiquetaPorQtde(), ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboTubo(), ParametrosGerais.getTipoExportacaoInterface(), ParametrosGerais.getLayCodigo(), ParametrosLocais.getParametro("tamanhoNomeImpressoras"), Funcoes.getNomeImpressorasLocais(), ParametrosLocais.getParametro("cabecalhoEtiqueta") == null ? "" : ParametrosLocais.getParametro("cabecalhoEtiqueta"), ParametrosGerais.getExportarInterface(), ParametrosGerais.getTuboPrimario(), ParametrosGerais.isUtilizarCapacidadeTuboPrimario(), impressoras, ParametrosGerais.getTipoIntegracao(), ParametrosGerais.getTipoEtiquetaSoroteca(), () -> {
            try {
                Conexao.arquivaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, () -> {
            try {
                Conexao.anulaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, new HashMap<String, List<InfoComplementar>>(), ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
        Conexao.fecharStatement(st, st2, st3, st4);
        return retorno.isImprimiu();
    }

    public RetornoImpressaoEtiquetas imprimir(boolean isColetaWeb, String filial, String codigoRequisicao, String[] exames, int[] materiais, boolean reimprimir, String usuario, int tipoEtiqueta, boolean mostrarMensagem, boolean naoEnviaParaImpressora, boolean impressaoAutomaticaColetaSelecionada, boolean isAgendamento, String impressoraEtqColeta, String impressoraEtqTriagem, int agruparInterface, boolean agruparGuiasInterface, Statement st, Statement st2, Statement st3, Statement st4, String filialPadrao, String parametroImprimirEtqTriagemSemMaterial, boolean parametroImprimirEtqColetaSemMaterial, boolean parametroImprimirEtqColetaSelecionadaSemMaterial, boolean agruparEtiquetaPorQtde, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, String tipoExportacaoInterface, int layoutPadrao, String tamanhoNomeImpressora, String[] impressorasLocais, String cabecalhoEtiquetaEstacao, int exportarInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws Exception {
        if (arquivar == null || anular == null) {
            return null;
        }
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        boolean bloqueiaEtiquetaJalis = false;
        String requisicao = StringUtil.removeZerosEsquerda(codigoRequisicao);
        String impressora = ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta) ? impressoraEtqColeta : impressoraEtqTriagem;
        ListaExameMaterial<ExameMaterial> listaExamesNaoImprimir = new ListaExameMaterial<ExameMaterial>();
        int auxEtiqueta = agruparInterface;
        if (auxEtiqueta == 0 && ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta) || auxEtiqueta == 1 && (tipoEtiqueta == 2 || tipoEtiqueta == 4)) {
            auxEtiqueta = tipoEtiqueta;
        }
        if (auxEtiqueta == tipoEtiqueta) {
            List<ExameRequisicaoVO> exameRequisicoes = ImprimirEtiquetasColetaTriagem.buscarExameRequisicoes(filial, codigoRequisicao, exames, materiais, st, agruparGuiasInterface, filialPadrao, isColetaWeb);
            Integer requisicaoPrincipal = Integer.valueOf(codigoRequisicao);
            ImpressaoVO dados = new ImpressaoVO(requisicaoPrincipal, exameRequisicoes, impressora, tipoEtiqueta, isAgendamento, reimprimir);
            retorno = ImprimirEtiquetasColetaTriagem.imprimirEtiquetasLaboratorioExterno(isColetaWeb, dados, filialPadrao, st, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface, st2, st3, st4, usuario, parametroImprimirEtqTriagemSemMaterial, parametroImprimirEtqColetaSemMaterial, parametroImprimirEtqColetaSelecionadaSemMaterial, agruparEtiquetaPorQtde, tipoExportacaoInterface, tuboPrimario, utilizarCapacidadeTuboPrimario, impressoras, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar, casasPrecoExame, arredondamentoPrecoExame);
            listaExamesNaoImprimir = retorno.getExamesMaterial();
            ImprimirEtiquetasColetaTriagem.atualizaEtiquetaExameApoio(isColetaWeb, filial, usuario, tipoEtiqueta, requisicao, listaExamesNaoImprimir, st, agruparGuiasInterface, arquivar);
        }
        String[] camposEtiqueta = tipoEtiqueta == 2 || tipoEtiqueta == 4 ? Impressao.CAMPOS_ETQ_TRIAGEM : Impressao.CAMPOS_ETQ_COLETA;
        try {
            String perguntas = ImprimirEtiquetasColetaTriagem.getPerguntasFilial(filialPadrao, st);
            if (!Funcoes.textoVazio(perguntas)) {
                String[] camposPergunta = DialogoConfigurador.getCamposResultado(perguntas);
                camposEtiqueta = ArraysUtil.concatenar(camposEtiqueta, camposPergunta);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, "N\u00e3o foi possivel interpretar as perguntas da filial", e.getStackTrace());
        }
        ModeloGridTable modeloDados = ImprimirEtiquetasColetaTriagem.geraModeloDados(isColetaWeb, filial, requisicao, exames, materiais, reimprimir, camposEtiqueta, "R", st, st2, st3, usuario, tipoEtiqueta, true, listaExamesNaoImprimir, null, agruparGuiasInterface, parametroImprimirEtqTriagemSemMaterial, parametroImprimirEtqColetaSemMaterial, parametroImprimirEtqColetaSelecionadaSemMaterial, agruparEtiquetaPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario);
        String layEtq = ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta) ? "lay_etqcol" : "lay_etqtri";
        String layTipo = ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta) ? "lay_tipoetqcol" : "lay_tipoetqtri";
        return ImprimirEtiquetasColetaTriagem.imprimirEtiquetasJalis(isColetaWeb, filial, tipoEtiqueta, mostrarMensagem, naoEnviaParaImpressora, bloqueiaEtiquetaJalis, requisicao, impressora, listaExamesNaoImprimir, modeloDados, layEtq, layTipo, st, st2, layoutPadrao, tamanhoNomeImpressora, impressorasLocais, cabecalhoEtiquetaEstacao, agruparGuiasInterface, exportarInterface, tipoExportacaoInterface, agruparInterface, retorno, arquivar, anular, casasPrecoExame, arredondamentoPrecoExame);
    }

    private static List<ExameRequisicaoVO> removerExames(List<ExameRequisicaoVO> exameRequisicoes, ListaExameMaterial<ExameMaterial> listaExamesNaoImprimir) {
        ArrayList<ExameRequisicaoVO> resultado = new ArrayList<ExameRequisicaoVO>();
        for (ExameRequisicaoVO exameReq : exameRequisicoes) {
            for (ExameMaterial exaMaterial : listaExamesNaoImprimir) {
                if (exameReq.getExame().getCodigo().equalsIgnoreCase(exaMaterial.getCodigoExame()) || exameReq.getMaterial().getCodigo() == exaMaterial.getCodigoMaterial()) continue;
                resultado.add(exameReq);
            }
        }
        return resultado;
    }

    private static RetornoImpressaoEtiquetas imprimirEtiquetasLaboratorioExterno(boolean isColetaWeb, ImpressaoVO dados, String filialPadrao, Statement st, boolean agruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws SQLException {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        try {
            ImpressaoExameLabExternoService impressao = new ImpressaoExameLabExternoService(filialPadrao, st);
            retorno = impressao.imprimir(isColetaWeb, dados, agruparGuiasInterface, st, filialPadrao, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, tuboPrimario, utilizarCapacidadeTuboPrimario, impressoras, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar, casasPrecoExame, arredondamentoPrecoExame);
        }
        catch (ImpressaoException e) {
            throw new SQLException(e);
        }
        retorno.setExamesMaterial(ImprimirEtiquetasColetaTriagem.criarListaExameMaterial(retorno.getExamesRequisicao()));
        return retorno;
    }

    private static List<ExameRequisicaoVO> buscarExameRequisicoes(String filial, String codigoRequisicao, String[] exames, int[] materiais, Statement st, boolean agruparInterface, String filialPadrao, boolean isColetaWeb) throws SQLException {
        List<ExameRequisicaoVO> examesRequisicao;
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        Integer[] req = new Integer[]{Integer.valueOf(codigoRequisicao)};
        Object[] multiguias = agruparInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filial, req) ? RecepcaoUtil.verificaMultiGuias(st, filial, codigoRequisicao, true) : req;
        chaves.put("fil_codigo", filial);
        if (multiguias.length > 0) {
            chaves.put("req_codigo", ValorIn.criar(multiguias));
        } else {
            chaves.put("req_codigo", codigoRequisicao);
        }
        if (exames != null && exames.length > 0) {
            chaves.put("exa_codigo", ValorIn.criar(exames));
        }
        if (materiais != null && materiais.length > 0) {
            chaves.put("mco_codigo", ValorIn.criar(materiais));
        }
        try {
            examesRequisicao = new ExameRequisicaoService().getVOsIn(chaves, st, filialPadrao, isColetaWeb);
        }
        catch (ThreadDaoException e) {
            throw new SQLException("N\u00e3o foi poss\u00edvel buscar Exames Requisicoes\n" + e.getMessage(), e);
        }
        return examesRequisicao;
    }

    private static ListaExameMaterial<ExameMaterial> criarListaExameMaterial(List<ExameRequisicaoVO> impressos) {
        ListaExameMaterial<ExameMaterial> resultado = new ListaExameMaterial<ExameMaterial>();
        for (ExameRequisicaoVO impresso : impressos) {
            resultado.add(new ExameMaterial(impresso.getExame().getCodigo(), impresso.getMaterial().getCodigo()));
        }
        return resultado;
    }

    private static String getPerguntasFilial(String filialPadrao, Statement st) throws Exception {
        String retorno = "";
        try {
            StringBuilder buf = new StringBuilder("select fil_perguntas from filiais_postocoleta where fil_codigo = ");
            buf.append(filialPadrao);
            ResultSet rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                retorno = rs.getString("fil_perguntas");
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, "N\u00e3o foi possivel interpretar as perguntas da filial", ex.getStackTrace());
        }
        return retorno;
    }

    private static void atualizaEtiquetaExameApoio(boolean isColetaWeb, String filial, String usuario, int tipoEtiqueta, String requisicao, ListaExameMaterial<ExameMaterial> listaExamesApoio, Statement st, boolean agruparGuiasInterface, Callable<Boolean> arquivar) throws Exception {
        String guias = requisicao;
        boolean agruparMultiguia = false;
        Integer[] multiguia = null;
        try {
            multiguia = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificiar multiguia no carregamento de lote.\n" + e1.getMessage(), e1.getStackTrace());
        }
        guias = StringUtil.implode(Arrays.asList(multiguia), ",");
        if (listaExamesApoio != null && !listaExamesApoio.isEmpty()) {
            StringBuilder bui = new StringBuilder();
            for (ExameMaterial exameMaterial : listaExamesApoio) {
                ValorIn exa = ValorIn.criar(new String[]{exameMaterial.getCodigoExame()});
                agruparMultiguia = ImprimirEtiquetasColetaTriagem.isAgruparMultiguia(filial, guias, exa.toString(), String.valueOf(exameMaterial.getCodigoMaterial()), exameMaterial.getCodigoLabExterno(), agruparGuiasInterface, st);
                bui.setLength(0);
                if (tipoEtiqueta == 2) {
                    bui.append("update examerequisicao set exr_dataetqtriagem = current_timestamp, usr_codetqtriagem = '").append(StringUtil.textoDB(usuario)).append("' ");
                } else {
                    bui.append("update examerequisicao set exr_dataetqcoleta = current_timestamp, usr_codetqcoleta = '").append(StringUtil.textoDB(usuario)).append("' ");
                }
                bui.append(" where fil_codigo = ").append(filial);
                bui.append("   and exa_codigo = '").append(exameMaterial.getCodigoExame()).append("' ");
                bui.append("   and mco_codigo =  ").append(exameMaterial.getCodigoMaterial());
                bui.append("   and req_codigo in (").append(agruparMultiguia ? guias : requisicao).append(") ");
                if (isColetaWeb) {
                    st.executeUpdate(bui.toString());
                } else {
                    Conexao.executeUpdate(filial, st, bui.toString());
                }
                arquivar.call();
            }
        }
    }

    private static boolean imprimirAmostrasAlvaro(String[] exames, boolean naoEnviaParaImpressora, boolean bloqueiaEtiquetaJalis, List<Registro> amostras, boolean isColetaWeb) {
        block0: for (Registro amostra : amostras) {
            String etq = (String)amostra.getValor("layout");
            Set examesList = (Set)amostra.getValor("examesRequisicaoAlvaro");
            ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraEtqColeta")), isColetaWeb);
            if (exames == null || exames != null && exames.length == 0) {
                if (naoEnviaParaImpressora) {
                    termica.imprimirDireto(etq);
                }
                bloqueiaEtiquetaJalis = true;
                continue;
            }
            if (exames == null || exames.length <= 0) continue;
            for (String exa : exames) {
                boolean imprimiu = false;
                for (ExameAlvaro exaAlvaro : examesList) {
                    if (!exaAlvaro.getExameJalis().equals(exa)) continue;
                    if (naoEnviaParaImpressora) {
                        termica.imprimirDireto(etq);
                    }
                    imprimiu = true;
                    bloqueiaEtiquetaJalis = true;
                    break;
                }
                if (!imprimiu) continue;
                bloqueiaEtiquetaJalis = true;
                continue block0;
            }
        }
        return bloqueiaEtiquetaJalis;
    }

    private static RetornoImpressaoEtiquetas imprimirEtiquetasJalis(boolean isColetaWeb, String filial, int tipoEtiqueta, boolean mostrarMensagem, boolean naoEnviaParaImpressora, boolean bloqueiaEtiquetaJalis, String requisicao, String impressora, ListaExameMaterial<ExameMaterial> listaExamesHPDirect, ModeloGridTable modeloDados, String layEtq, String layTipo, Statement st, Statement st2, int layoutPadrao, String tamanhoNomeImpressora, String[] impressorasLocais, String cabecalhoEtiquetaEstacao, boolean agruparGuiasInterface, int exportarInterface, String tipoExportarInterface, int agruparInterface, RetornoImpressaoEtiquetas retorno, Callable<Boolean> arquivar, Callable<Boolean> anular, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws SQLException {
        ArrayList<byte[]> etiquetasJalis = new ArrayList<byte[]>();
        if (modeloDados.getRowCount() > 0) {
            String codigoLayout = ExameUtil.getCodigoLayout(filial, codigoConvenio, codigoDestino, st, layoutPadrao);
            StringBuilder buf = new StringBuilder("");
            buf.delete(0, buf.length());
            buf.append("select ").append(layEtq).append(", ").append(layTipo).append(" from layout where fil_codigo = ");
            buf.append(filial);
            buf.append(" and lay_codigo = ");
            buf.append(codigoLayout);
            ResultSet rsLayout = st.executeQuery(buf.toString());
            if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString(layEtq))) {
                String tipo = rsLayout.getString(layTipo);
                if (tipo.equalsIgnoreCase("C") && !bloqueiaEtiquetaJalis) {
                    Gerador gerador = new Gerador(casasPrecoExame, arredondamentoPrecoExame);
                    gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(impressora, tamanhoNomeImpressora, impressorasLocais));
                    if (naoEnviaParaImpressora && !isColetaWeb) {
                        gerador.executar(rsLayout.getString(layEtq), modeloDados);
                    }
                    if (isColetaWeb) {
                        etiquetasJalis.add(Impressao.gerarPdfRelatorio(gerador.getRelatorio(), rsLayout.getString(layEtq)));
                    }
                } else if (tipo.equalsIgnoreCase("T") && !bloqueiaEtiquetaJalis) {
                    ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressora, tamanhoNomeImpressora, impressorasLocais), isColetaWeb);
                    termica.setDados(modeloDados);
                    String layout = rsLayout.getString(layEtq);
                    if (tipoEtiqueta == 2 || tipoEtiqueta == 1 || tipoEtiqueta == 4 || tipoEtiqueta == 3) {
                        String cabecalhoLayout = StringUtil.getValor(layout, "cabecalho");
                        String cabecalhoEtiquetaEstacaoLayout = StringUtil.getValor(cabecalhoEtiquetaEstacao, "cabecalho");
                        if (Funcoes.textoVazio(cabecalhoEtiquetaEstacaoLayout) && !Funcoes.textoVazio(cabecalhoLayout)) {
                            cabecalhoEtiquetaEstacao = cabecalhoLayout;
                        }
                        String layoutEtiqueta = StringUtil.getValor(layout, "etiqueta");
                        String layoutSumario = StringUtil.getValor(layout, "sumario");
                        XMLStringBuilder xml = new XMLStringBuilder();
                        xml.abrir("documento");
                        String cab = StringUtil.getValor(cabecalhoEtiquetaEstacao, "cabecalho");
                        if (!Funcoes.textoVazio(cab)) {
                            xml.escrever("cabecalho", StringUtil.getValor(cabecalhoEtiquetaEstacao, "cabecalho"));
                        } else if (!Funcoes.textoVazio(cabecalhoEtiquetaEstacao)) {
                            xml.escrever("cabecalho", cabecalhoEtiquetaEstacao);
                        }
                        xml.escrever("etiqueta", layoutEtiqueta);
                        xml.escrever("sumario", layoutSumario);
                        try {
                            xml.fechar("documento");
                        }
                        catch (XMLStringBuilderException e) {
                            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel imprimir a etiqueta.\n" + e.getMessage(), e.getStackTrace());
                            retorno.setImprimiu(false);
                        }
                        layout = xml.getXML();
                    }
                    etiquetasJalis.add(termica.imprimir(layout, st, isColetaWeb, arquivar, anular));
                }
                ImprimirEtiquetasColetaTriagem.geraDadosExamesInterface(isColetaWeb, filial, tipoEtiqueta, requisicao, agruparGuiasInterface, st, st2, exportarInterface, agruparInterface, tipoExportarInterface);
            } else {
                if (!isColetaWeb) {
                    Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
                }
                rsLayout.close();
                retorno.setImprimiu(false);
            }
            rsLayout.close();
        } else {
            if (mostrarMensagem && (listaExamesHPDirect == null || listaExamesHPDirect != null && listaExamesHPDirect.isEmpty()) && !bloqueiaEtiquetaJalis) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Sem dados para imprimir.\nVerifique as situa\u00e7\u00f5es dos exames da requisi\u00e7\u00e3o.", 2);
            }
            retorno.setImprimiu(false);
        }
        etiquetasJalis.addAll(retorno.getEtiquetasJalis());
        retorno.setEtiquetasJalis(etiquetasJalis);
        retorno.setImprimiu(true);
        return retorno;
    }

    private static void geraDadosExamesInterface(boolean isColetaWeb, String filial, int tipoEtiqueta, String requisicao, boolean agruparGuiasInterface, Statement st, Statement st2, int exportarInterface, int agruparInterface, String tipoExportarInterface) throws SQLException {
        boolean agruparMultiguias;
        String[] guias = null;
        boolean bl = agruparMultiguias = agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filial, requisicao);
        if (agruparMultiguias) {
            Integer[] tmp = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, false, false);
            tmp = tmp == null || tmp.length == 0 ? new Integer[]{Integer.parseInt(requisicao)} : ArraysUtil.concatenar(new Integer[]{Integer.parseInt(requisicao)}, tmp);
            guias = new String[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                guias[i] = String.valueOf(tmp[i]);
            }
        } else {
            guias = new String[]{requisicao};
        }
        for (String req : guias) {
            if (ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta) && exportarInterface == 1) {
                ExportarInterface.criaInterface(isColetaWeb, filial, req, "etiquetacoleta", st, st2, false, tipoExportarInterface, agruparInterface);
                continue;
            }
            if (tipoEtiqueta != 2 && tipoEtiqueta != 4 || exportarInterface != 2) continue;
            ExportarInterface.criaInterface(isColetaWeb, filial, req, "etiquetatriagem", st, st2, false, tipoExportarInterface, agruparInterface);
        }
    }

    private static void verificaExamesJaEnviados(List<ExameMaterial> examesImpressos, ArrayList<Registro> listaExamesLotes, ArrayList<Integer> listaLotesImpressos, boolean imprimir) {
        if (listaExamesLotes != null && !listaExamesLotes.isEmpty()) {
            String imp = ParametrosLocais.getParametro("impressoraWebServiceHp");
            PrintService service = Funcoes.localizarImpressora(imp);
            ArrayList<String> etiquetas = new ArrayList<String>();
            for (int i = 0; i < listaExamesLotes.size(); ++i) {
                String[] recipientes;
                if (listaLotesImpressos.contains(listaExamesLotes.get(i).getInt("lex_codigo"))) {
                    ExameMaterial mat = new ExameMaterial(listaExamesLotes.get(i).getString("exa_codigo"), listaExamesLotes.get(i).getInt("mco_codigo"), null, null, null, null, null, null, null, 0, 0, null, null, null, null, null, null, null);
                    if (examesImpressos.contains(mat)) continue;
                    examesImpressos.add(mat);
                    continue;
                }
                listaLotesImpressos.add(listaExamesLotes.get(i).getInt("lex_codigo"));
                for (String recipiente : recipientes = StringUtil.getValores(listaExamesLotes.get(i).getString("LEQ_RETORNO_WS"), "Recipiente")) {
                    ExameMaterial mat;
                    String etiqueta = StringUtil.getValor(recipiente, "EtqCodBar");
                    if (!etiquetas.contains(etiqueta)) {
                        etiquetas.add(etiqueta);
                    }
                    if (examesImpressos.contains(mat = new ExameMaterial(listaExamesLotes.get(i).getString("exa_codigo"), listaExamesLotes.get(i).getInt("mco_codigo"), null, null, null, null, null, null, null, 0, 0, null, null, null, null, null, null, null))) continue;
                    examesImpressos.add(mat);
                }
            }
            if (imprimir) {
                StringBuilder etiq = new StringBuilder();
                for (String etq : etiquetas) {
                    etiq.append(etq).append("\n");
                }
                ImpressaoTermica.imprimirDireto(service, etiq.toString(), false);
            }
        }
    }

    private static void imprimirEtiquetasExistentesAlvaro(String filial, String codigoRequisicao, String[] exames, int[] materiais, ListaExameMaterial<ExameMaterial> listaExamesNaoImprimir, String impressora, boolean isColetaWeb, boolean agruparGuiasInterface, Statement st, Statement st2, int agruparInterface) {
        ArrayList<Registro> listaExamesLotesAlvaro = UtilExportadores.verificaExamesComLote(filial, codigoRequisicao, exames, materiais, agruparInterface, st);
        List<Object> listaRegistro = new ArrayList();
        if (listaExamesLotesAlvaro != null && !listaExamesLotesAlvaro.isEmpty()) {
            try {
                listaRegistro = new LoteExternoExameRequisicaoService().requisicaoEnviadaParaAlvaro(codigoRequisicao, filial, true, st, st2, agruparGuiasInterface);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar laborat\u00f3rio externo para a requisi\u00e7\u00e3o.", e.getStackTrace());
                return;
            }
        }
        for (Registro registro : listaRegistro) {
            if (registro == null || registro.getValor("amostras") == null) continue;
            List amostras = (List)registro.getValor("amostras");
            block3: for (Registro amostra : amostras) {
                boolean bloqueiaEtiquetaJalis;
                String etq = (String)amostra.getValor("layout");
                Set examesList = (Set)amostra.getValor("examesRequisicaoAlvaro");
                ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressora), isColetaWeb);
                if (exames == null || exames != null && exames.length == 0) {
                    termica.imprimirDireto(etq);
                    bloqueiaEtiquetaJalis = true;
                    continue;
                }
                if (exames == null || exames.length <= 0) continue;
                for (String exa : exames) {
                    boolean imprimiu = false;
                    for (ExameAlvaro exaAlvaro : examesList) {
                        if (!exaAlvaro.getExameJalis().equals(exa)) continue;
                        termica.imprimirDireto(etq);
                        imprimiu = true;
                        bloqueiaEtiquetaJalis = true;
                        ExameMaterial exameImpresso = new ExameMaterial(exaAlvaro.getExameJalis(), Integer.parseInt(exaAlvaro.getMaterialJalis()));
                        if (!listaExamesNaoImprimir.isEmpty()) {
                            for (ExameMaterial exaMat : listaExamesNaoImprimir) {
                                if (exameImpresso.getCodigoExame().equalsIgnoreCase(exaMat.getCodigoExame()) && exameImpresso.getCodigoMaterial() == exaMat.getCodigoMaterial()) continue;
                                listaExamesNaoImprimir.add(exameImpresso);
                            }
                            break;
                        }
                        listaExamesNaoImprimir.add(exameImpresso);
                        break;
                    }
                    if (!imprimiu) continue;
                    bloqueiaEtiquetaJalis = true;
                    continue block3;
                }
            }
        }
    }

    private static Registro convertExameMaterialToRegistro(ListaExameMaterial<ExameMaterial> listaExamesHPDirect, String filial, String codigoRequisicao) {
        if (listaExamesHPDirect == null || listaExamesHPDirect.isEmpty() || Funcoes.textoVazio(filial) || Funcoes.textoVazio(codigoRequisicao)) {
            return null;
        }
        Registro reg = new Registro();
        reg.setValor("fil_codigo", filial);
        reg.setValor("req_codigo", Integer.parseInt(codigoRequisicao));
        reg.setValor("pac_codigo", listaExamesHPDirect.getCodigoPaciente());
        reg.setValor("pac_nome", listaExamesHPDirect.getNomePaciente());
        reg.setValor("pac_sexo", listaExamesHPDirect.getSexoPaciente());
        reg.setValor("pac_dum", listaExamesHPDirect.getDumPaciente());
        reg.setValor("req_data", listaExamesHPDirect.getDataColeta());
        reg.setValor("req_hora", listaExamesHPDirect.getHoraColeta());
        reg.setValor("req_peso", listaExamesHPDirect.getPesoPaciente());
        reg.setValor("req_altura", listaExamesHPDirect.getAlturaPaciente());
        reg.setValor("req_idade", listaExamesHPDirect.getIdadePaciente());
        reg.setValor("req_obs", listaExamesHPDirect.getObservacaoRequisicao());
        reg.setValor("pac_datanasc", listaExamesHPDirect.getDataNascimentoPaciente());
        reg.setValor("con_codigo", listaExamesHPDirect.getCodigoConvenio());
        reg.setValor("lae_codigo", ((ExameMaterial)listaExamesHPDirect.get(0)).getCodigoLaboratorioExterno());
        reg.setValor("examesHermesPardini", listaExamesHPDirect);
        ArrayList<Registro> listaExames = new ArrayList<Registro>();
        for (ExameMaterial exame : listaExamesHPDirect) {
            Registro regExames = new Registro();
            regExames.setValor("exa_codigo", exame.getCodigoExame());
            regExames.setValor("mco_codigo", (int)exame.getCodigoMaterial());
            regExames.setValor("ele_xmllabexterno", exame.getXMLExamePardini());
            regExames.setValor("exa_descricao", exame.getDescricaoExame());
            regExames.setValor("mco_descricao", exame.getDescricaoMaterial());
            regExames.setValor("codigoProtocolo", exame.getCodigoProtocolo());
            regExames.setValor("tipoImpressao", exame.getTipoImpressao());
            regExames.setValor("etiquetaArmazenada", exame.getEtiquetaArmazenada());
            regExames.setValor("lae_codigo", exame.getCodigoLaboratorioExterno());
            regExames.setValor("qtdeEtiquetas", exame.getQtdeEtiquetas());
            regExames.setValor("rec_kodigo", exame.getRecipiente());
            regExames.setValor("exr_datamaterial", exame.getDataMaterial());
            regExames.setValor("exr_codigoapoiado", exame.getCodigoApoiado());
            regExames.setValor("exr_volumediurese", exame.getVolumeDiurese());
            regExames.setValor("exr_tempodiurese", exame.getTempoDiurese());
            regExames.setValor("codigoLabExterno", exame.getCodigoLabExterno());
            regExames.setValor("exr_descricaomaterial", exame.getMaterialInformado());
            listaExames.add(regExames);
        }
        reg.setValor("listaexames", listaExames);
        return reg;
    }

    private static void imprimirEtiquetasHPDirect(String codigoFilial, String codigoRequisicao, ListaExameMaterial<ExameMaterial> listaExamesHPDirect, String impressora, int tipoEtiqueta, boolean isColetaWeb, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws SQLException {
        ArrayList<DadosGrupoExame> listaDadosGrupoExame = ImprimirEtiquetasColetaTriagem.getDadosGrupoExamesHPDirect(codigoFilial, codigoRequisicao, listaExamesHPDirect, tipoEtiqueta);
        for (DadosGrupoExame dadosGrupoExame : listaDadosGrupoExame) {
            if (dadosGrupoExame.getTipoImpressao().equalsIgnoreCase("C")) {
                Gerador gerador = new Gerador(casasPrecoExame, arredondamentoPrecoExame);
                gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(impressora));
                gerador.setCopias(dadosGrupoExame.getQtdeEtiquetas());
                gerador.executar(dadosGrupoExame.getLayoutEtiqueta(), dadosGrupoExame.getModelo());
                continue;
            }
            if (!dadosGrupoExame.getTipoImpressao().equalsIgnoreCase("T")) continue;
            ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressora), isColetaWeb);
            termica.setDados(dadosGrupoExame.getModelo());
            for (int i = 0; i < dadosGrupoExame.getQtdeEtiquetas(); ++i) {
                termica.imprimir(dadosGrupoExame.getLayoutEtiqueta());
            }
        }
    }

    private static ArrayList<DadosGrupoExame> getDadosGrupoExamesHPDirect(String codigoFilial, String codigoRequisicao, ListaExameMaterial<ExameMaterial> listaExamesHPDirect, int tipoEtiqueta) throws SQLException {
        HashMap<String, ArrayList> mapaExamesGrupo = new HashMap<String, ArrayList>();
        for (ExameMaterial exameMaterial : listaExamesHPDirect) {
            ArrayList aux;
            String grupo = Funcoes.textoVazio(exameMaterial.getEtiquetaArmazenada()) ? exameMaterial.getGrupo() : exameMaterial.getEtiquetaArmazenada();
            String grupoAux = grupo + "_" + exameMaterial.getCodigoLaboratorioExterno();
            if (mapaExamesGrupo.containsKey(grupoAux)) {
                aux = (ArrayList)mapaExamesGrupo.get(grupoAux);
                aux.add(exameMaterial);
                continue;
            }
            aux = new ArrayList();
            aux.add(exameMaterial);
            mapaExamesGrupo.put(grupoAux, aux);
        }
        ArrayList<DadosGrupoExame> listaDadosGrupoExame = new ArrayList<DadosGrupoExame>();
        for (String grupoAux : mapaExamesGrupo.keySet()) {
            String etiquetaHPDirect;
            ExameMaterial exameMaterialAux;
            ArrayList examesGrupo;
            Object[] linha;
            ModeloGridTable modelo;
            block30: {
                block29: {
                    modelo = new ModeloGridTable(Impressao.CAMPOS_ETIQUETA_HP_DIRECT);
                    linha = new Object[Impressao.CAMPOS_ETIQUETA_HP_DIRECT.length];
                    examesGrupo = (ArrayList)mapaExamesGrupo.get(grupoAux);
                    exameMaterialAux = (ExameMaterial)examesGrupo.get(0);
                    etiquetaHPDirect = null;
                    if (Funcoes.textoVazio(exameMaterialAux.getEtiquetaArmazenada())) break block29;
                    etiquetaHPDirect = exameMaterialAux.getEtiquetaArmazenada();
                    break block30;
                }
                Statement st = Conexao.getStatement();
                String sequencial = null;
                try {
                    sequencial = DBUtil.getSequencia(st, "labexterno_" + codigoFilial + "_" + exameMaterialAux.getCodigoLaboratorioExterno());
                }
                catch (SQLException e) {
                    try {
                        throw new SQLException("N\u00e3o foi poss\u00edvel obter o sequencial da etiqueta HP Direct. Filial = " + codigoFilial + ", lab. externo = " + exameMaterialAux.getCodigoLaboratorioExterno() + ".\n" + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                }
                Conexao.fecharStatement(st);
                etiquetaHPDirect = "9" + Funcoes.preencheZero(exameMaterialAux.getCodigoProtocolo(), 5) + Funcoes.preencheZero(sequencial, 6);
            }
            ArrayListAgrupadorDados<String> codigosExamesHPardini = new ArrayListAgrupadorDados<String>();
            ArrayListAgrupadorDados<String> codigosExames = new ArrayListAgrupadorDados<String>();
            ArrayListAgrupadorDados<Integer> codigosMateriais = new ArrayListAgrupadorDados<Integer>();
            ArrayListAgrupadorDados<String> codigosRecipientes = new ArrayListAgrupadorDados<String>();
            ArrayListAgrupadorDados<String> descricoesExames = new ArrayListAgrupadorDados<String>();
            ArrayListAgrupadorDados<String> descricoesMateriais = new ArrayListAgrupadorDados<String>();
            ArrayListAgrupadorDados<String> descricoesRecipientes = new ArrayListAgrupadorDados<String>();
            for (ExameMaterial aux : examesGrupo) {
                Object[] auxInt;
                codigosExamesHPardini.add(aux.getCodigoExamePardini());
                codigosExames.add(aux.getCodigoExame());
                codigosMateriais.add(aux.getCodigoMaterial());
                descricoesExames.add(aux.getDescricaoExame());
                descricoesMateriais.add(aux.getDescricaoMaterial());
                Array auxR = aux.getRecipiente();
                for (Object a : auxInt = (Object[])auxR.getArray()) {
                    codigosRecipientes.add(a.toString());
                    descricoesRecipientes.add(ImprimirEtiquetasColetaTriagem.getDescricaoRecipiente(codigoFilial, a.toString()));
                }
            }
            for (int i = 0; i < Impressao.CAMPOS_ETIQUETA_HP_DIRECT.length; ++i) {
                String campo = Impressao.CAMPOS_ETIQUETA_HP_DIRECT[i];
                if (campo.equalsIgnoreCase("codigoFilial")) {
                    linha[i] = codigoFilial;
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoRequisicao")) {
                    linha[i] = codigoRequisicao;
                    continue;
                }
                if (campo.equalsIgnoreCase("nomePaciente")) {
                    linha[i] = listaExamesHPDirect.getNomePaciente();
                    continue;
                }
                if (campo.equalsIgnoreCase("pedidoHPardini")) {
                    linha[i] = etiquetaHPDirect;
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoConveniadoHPardini")) {
                    linha[i] = exameMaterialAux.getCodigoProtocolo();
                    continue;
                }
                if (campo.equalsIgnoreCase("pedidoConveniado")) {
                    linha[i] = codigoRequisicao;
                    continue;
                }
                if (campo.equalsIgnoreCase("materialBiologico")) {
                    linha[i] = exameMaterialAux.getMaterialBiologico();
                    continue;
                }
                if (campo.equalsIgnoreCase("conservante")) {
                    linha[i] = exameMaterialAux.getConservante();
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoExameHPardini")) {
                    linha[i] = codigosExamesHPardini.toString();
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoEtiquetaHPardini")) {
                    linha[i] = etiquetaHPDirect;
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoExame")) {
                    linha[i] = codigosExames.toString();
                    continue;
                }
                if (campo.equalsIgnoreCase("descricaoExame")) {
                    linha[i] = descricoesExames.toString();
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoMaterial")) {
                    linha[i] = codigosMateriais.toString();
                    continue;
                }
                if (campo.equalsIgnoreCase("descricaoMaterial")) {
                    linha[i] = descricoesMateriais.toString();
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoConvenio")) {
                    linha[i] = listaExamesHPDirect.getCodigoConvenio();
                    continue;
                }
                if (campo.equalsIgnoreCase("fantasiaConvenio")) {
                    linha[i] = listaExamesHPDirect.getFantasiaConvenio();
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoPaciente")) {
                    linha[i] = listaExamesHPDirect.getCodigoPaciente();
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoRecipiente")) {
                    linha[i] = codigosRecipientes.toString();
                    continue;
                }
                if (!campo.equalsIgnoreCase("descricaoRecipiente")) continue;
                linha[i] = descricoesRecipientes.toString();
            }
            modelo.addLine(linha);
            DadosGrupoExame dadosGrupoExame = new DadosGrupoExame(exameMaterialAux.getGrupo());
            dadosGrupoExame.setModelo(modelo);
            dadosGrupoExame.setLayoutEtiqueta(exameMaterialAux.getXMLLayout());
            dadosGrupoExame.setTipoImpressao(exameMaterialAux.getTipoImpressao());
            int qtdeEtiquetas = 1;
            for (ExameMaterial aux : examesGrupo) {
                if (qtdeEtiquetas >= aux.getQtdeEtiquetas()) continue;
                qtdeEtiquetas = aux.getQtdeEtiquetas();
            }
            dadosGrupoExame.setQtdeEtiquetas(qtdeEtiquetas);
            listaDadosGrupoExame.add(dadosGrupoExame);
            ImprimirEtiquetasColetaTriagem.gravaEtiquetaHPDirectExameRequisicao(codigoFilial, codigoRequisicao, examesGrupo, etiquetaHPDirect, tipoEtiqueta);
        }
        return listaDadosGrupoExame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDescricaoRecipiente(String filial, String recipiente) {
        String retorno;
        Statement st;
        block4: {
            st = Conexao.getStatement();
            retorno = "";
            try {
                ResultSet rs = Conexao.executeQuery(st, "select rec_descricao from recipientes where fil_codigo = " + filial + " and rec_codigo = " + recipiente);
                if (!rs.next()) break block4;
                retorno = rs.getString(1);
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel buscar os recipientes para o tubo do HP Direct", e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getQtdeEtiquetas(String filial, String exame, String material, String recipiente, int tipoEtiqueta) {
        int retorno;
        Statement st;
        block6: {
            st = Conexao.getStatement();
            retorno = 1;
            try {
                StringBuilder sql = new StringBuilder("select ");
                if (ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta)) {
                    sql.append("rco_qtde from recipcoleta ");
                } else {
                    sql.append("rtr_qtde from reciptriagem ");
                }
                sql.append(" where fil_codigo = ").append(filial);
                sql.append("   and exa_codigo = '").append(StringUtil.textoDB(exame)).append("' ");
                sql.append("   and mco_codigo = ").append(material);
                sql.append("   and rec_codigo = ").append(recipiente);
                ResultSet rs = Conexao.executeQuery(st, sql.toString());
                if (!rs.next()) break block6;
                retorno = rs.getInt(1);
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel buscar a quantidade dos recipientes para o tubo do HP Direct", e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private static void gravarHistoricoImpressao(Statement st, String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial, String tipoEtiqueta, String usuario) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("insert into examerequisicaoetiquetas(fil_codigo, req_codigo, exa_codigo, mco_codigo, exi_datahora, exi_tipoetiqueta, usr_codigo) values (");
        buf.append(codigoFilial).append(", ");
        buf.append(codigoRequisicao).append(", ");
        buf.append(StringUtil.textoDBEscape(codigoExame)).append(", ");
        buf.append(codigoMaterial).append(", ");
        buf.append("current_timestamp, ");
        buf.append("'").append(tipoEtiqueta).append("', ");
        buf.append(StringUtil.textoDBEscape(usuario)).append(")");
        st.execute(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean gravaEtiquetaHPDirectExameRequisicao(String codigoFilial, String codigoRequisicao, ArrayList<ExameMaterial> listaExames, String etiqueta, int tipoEtiqueta) throws SQLException {
        boolean exameMaterial2;
        Statement st;
        block15: {
            StringBuilder buf = new StringBuilder();
            buf.append(" update examerequisicao ");
            buf.append("    set exr_codigoapoiado = ").append(StringUtil.textoDBEscape(etiqueta));
            buf.append("  where fil_codigo = ").append(codigoFilial);
            buf.append("    and req_codigo = ").append(codigoRequisicao);
            buf.append("    and (exa_codigo, mco_codigo) IN (");
            st = Conexao.getStatement();
            for (int i = 0; i < listaExames.size(); ++i) {
                ExameMaterial exameMaterial2 = listaExames.get(i);
                if (i > 0) {
                    buf.append(",");
                }
                buf.append("(").append(StringUtil.textoDBEscape(exameMaterial2.getCodigoExame()));
                buf.append(",").append(exameMaterial2.getCodigoMaterial()).append(")");
                ImprimirEtiquetasColetaTriagem.gravarHistoricoImpressao(st, codigoFilial, codigoRequisicao, exameMaterial2.getCodigoExame(), String.valueOf(exameMaterial2.getCodigoMaterial()), ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta) ? "C" : "T", Variaveis.login);
                Integer[] guias = RecepcaoUtil.verificaMultiGuias(codigoFilial, codigoRequisicao, true);
                String requisicoes = StringUtil.implode(Arrays.asList(guias), ",");
                StringBuilder bui = new StringBuilder("select count(req_codigo) as contagem from examerequisicaorecipiente ");
                bui.append("where fil_codigo = ");
                bui.append(codigoFilial);
                bui.append(" and exa_codigo = '");
                bui.append(exameMaterial2.getCodigoExame());
                bui.append("' and mco_codigo =  ");
                bui.append(exameMaterial2.getCodigoMaterial());
                bui.append(" and req_codigo in ( ");
                bui.append(requisicoes);
                bui.append(") and (rec_codigo in(");
                bui.append(ImprimirEtiquetasColetaTriagem.trataArrayTubo(exameMaterial2));
                bui.append(") or rec_kodigo in( ");
                bui.append(ImprimirEtiquetasColetaTriagem.trataArrayTubo(exameMaterial2));
                bui.append(")); ");
                try (ResultSet result = null;){
                    Object[] auxInt;
                    result = st.executeQuery(bui.toString());
                    if (!result.next()) continue;
                    boolean naoExisteExameRecipiente = result.getInt("contagem") <= 0;
                    String tipo = ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta) ? "C" : "T";
                    Array aux = exameMaterial2.getRecipiente();
                    for (Object a : auxInt = (Object[])aux.getArray()) {
                        bui.delete(0, bui.length());
                        if (naoExisteExameRecipiente) {
                            bui.append("insert into examerequisicaorecipiente(fil_codigo, exa_codigo,");
                            bui.append("mco_codigo, req_codigo, rec_codigo, ere_tipo, rec_kodigo, ere_codigoapoiado) values (");
                            bui.append(codigoFilial);
                            bui.append(", '");
                            bui.append(exameMaterial2.getCodigoExame());
                            bui.append("', ");
                            bui.append(exameMaterial2.getCodigoMaterial());
                            bui.append(", ");
                            bui.append(codigoRequisicao);
                            bui.append(", ");
                            bui.append(a);
                            bui.append(", '").append(tipo).append("'");
                            bui.append(", ");
                            bui.append(String.valueOf(a));
                            bui.append(", '");
                            bui.append(etiqueta).append("' ");
                            bui.append(")");
                        } else {
                            bui.append("update examerequisicaorecipiente set ere_codigoapoiado = '").append(etiqueta).append("' ");
                            bui.append("  where ");
                            bui.append("    fil_codigo = ").append(codigoFilial);
                            bui.append("    and exa_codigo = '").append(exameMaterial2.getCodigoExame()).append("' ");
                            bui.append("    and mco_codigo = ").append(exameMaterial2.getCodigoMaterial());
                            bui.append("    and req_codigo = ").append(codigoRequisicao);
                            bui.append("    and rec_codigo = ").append(a);
                            bui.append("    and ere_tipo = '").append(tipo).append("'");
                            bui.append("    and rec_kodigo = ").append(a);
                        }
                        Conexao.execute(codigoFilial, st, bui.toString());
                    }
                    continue;
                }
            }
            buf.append(") ");
            int qtde = Conexao.executeUpdate(codigoFilial, st, buf.toString());
            if (qtde != listaExames.size()) break block15;
            Conexao.arquivaSQL();
            boolean exameMaterial2 = true;
            Conexao.fecharStatement(st);
            return exameMaterial2;
        }
        try {
            Conexao.anulaSQL();
            exameMaterial2 = false;
        }
        catch (Exception e) {
            try {
                ArrayListAgrupadorDados<String> codigosExamesMateriais = new ArrayListAgrupadorDados<String>();
                for (ExameMaterial exameMaterial3 : listaExames) {
                    codigosExamesMateriais.add(exameMaterial3.getCodigoExame() + "/" + exameMaterial3.getCodigoMaterial());
                }
                throw new SQLException("N\u00e3o foi poss\u00edvel gravar o c\u00f3digo da etiqueta HP Direct nos exames. Filial = " + codigoFilial + ", requisi\u00e7\u00e3o = " + codigoRequisicao + ", exame/material = " + codigosExamesMateriais.toString() + ".\n" + e.getMessage());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return exameMaterial2;
    }

    private static String trataArrayTubo(ExameMaterial exameMaterial) {
        String tubos = exameMaterial.getRecipiente().toString().replaceAll("\\}", "").replaceAll("\\{", "");
        return !Funcoes.textoVazio(tubos) ? tubos : "0";
    }

    public static String getEtiquetasTermica(String filial, String requisicao, String usuario, int tipoEtiqueta) throws Exception {
        return ImprimirEtiquetasColetaTriagem.getEtiquetasTermica(filial, requisicao, null, null, usuario, false);
    }

    public static String getEtiquetasTermicaApoio(String filial, String requisicao, String usuario, boolean reimprimir) throws Exception {
        return ImprimirEtiquetasColetaTriagem.getEtiquetasTermica(filial, requisicao, null, null, "lay_tipoetqapoio", "lay_etqapoio", reimprimir, Impressao.CAMPOS_ETQ_APOIO, "F", usuario);
    }

    public static String getEtiquetasTermicaApoio(String filial, String requisicao, String usuario) throws Exception {
        return ImprimirEtiquetasColetaTriagem.getEtiquetasTermica(filial, requisicao, null, null, "lay_tipoetqapoio", "lay_etqapoio", true, Impressao.CAMPOS_ETQ_APOIO, "F", usuario);
    }

    public static String getEtiquetasTermicaApoio(String filial, String requisicao, Statement st1, Statement st2, Statement st3, String usuario, boolean atualizarCodigoApoiado) throws Exception {
        return ImprimirEtiquetasColetaTriagem.getEtiquetasTermica(false, filial, requisicao, null, null, "lay_tipoetqapoio", "lay_etqapoio", true, Impressao.CAMPOS_ETQ_APOIO, "F", st1, st2, st3, usuario, atualizarCodigoApoiado, null, ParametrosGerais.getTipoExportacaoInterface(), ParametrosGerais.isAgruparEtiquetaPorQtde(), ParametrosLocais.getParametro("imprimirEtiquetaTriagemSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSelecionadaSemMaterial"), ParametrosGerais.getLayCodigo(), ParametrosGerais.getExportarInterface(), ParametrosGerais.getAgruparInterface(), ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboTubo(), ParametrosGerais.getTuboPrimario(), ParametrosGerais.isUtilizarCapacidadeTuboPrimario());
    }

    public static String getEtiquetasTermicaApoio(String filial, String requisicao, Statement st1, Statement st2, Statement st3, String usuario, boolean atualizarCodigoApoiado, List<ParametroSet> listExames, boolean isEnviarEtiquetaComoApoio) throws Exception {
        return ImprimirEtiquetasColetaTriagem.getEtiquetasTermica(false, filial, requisicao, null, null, "lay_tipoetqapoio", "lay_etqapoio", true, Impressao.CAMPOS_ETQ_APOIO, "F", st1, st2, st3, usuario, atualizarCodigoApoiado, listExames, isEnviarEtiquetaComoApoio, false, ParametrosGerais.getTipoExportacaoInterface(), ParametrosGerais.isAgruparEtiquetaPorQtde(), ParametrosLocais.getParametro("imprimirEtiquetaTriagemSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSelecionadaSemMaterial"), ParametrosGerais.getLayCodigo(), ParametrosGerais.getExportarInterface(), ParametrosGerais.getAgruparInterface(), ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboTubo(), ParametrosGerais.getTuboPrimario(), ParametrosGerais.isUtilizarCapacidadeTuboPrimario());
    }

    public static String getEtiquetasTermica(String filial, String requisicao, String[] exames, int[] materiais, String usuario, boolean reimprimir) throws Exception {
        return ImprimirEtiquetasColetaTriagem.getEtiquetasTermica(filial, requisicao, exames, materiais, "lay_tipoetqcol", "lay_etqcol", reimprimir, Impressao.CAMPOS_ETQ_COLETA, "F", usuario);
    }

    public static String getEtiquetasTermica(String filial, String requisicao, String[] exames, int[] materiais, String campoTipo, String campoLayout, boolean reimprimir, String[] campos, String situacaoAdicional, String usuario) throws Exception {
        return ImprimirEtiquetasColetaTriagem.getEtiquetasTermica(false, filial, requisicao, exames, materiais, campoTipo, campoLayout, reimprimir, campos, situacaoAdicional, Conexao.getStatement(), Conexao.getStatement(), Conexao.getStatement(), usuario, ParametrosGerais.getTipoExportacaoInterface(), ParametrosGerais.isAgruparEtiquetaPorQtde(), ParametrosLocais.getParametro("imprimirEtiquetaTriagemSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSelecionadaSemMaterial"), ParametrosGerais.getLayCodigo(), ParametrosGerais.getExportarInterface(), ParametrosGerais.getAgruparInterface(), ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboTubo(), ParametrosGerais.getTuboPrimario(), ParametrosGerais.isUtilizarCapacidadeTuboPrimario());
    }

    public static String getEtiquetasTermica(boolean isColetaWeb, String filial, String requisicao, String[] exames, int[] materiais, String campoTipo, String campoLayout, boolean reimprimir, String[] campos, String situacaoAdicional, Statement st1, Statement st2, Statement st3, String usuario, String tipoExportacaoInterface, boolean agruparEtiquetaPorQtde, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, int layoutPadrao, int exportarInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario) throws Exception {
        return ImprimirEtiquetasColetaTriagem.getEtiquetasTermica(isColetaWeb, filial, requisicao, exames, materiais, campoTipo, campoLayout, reimprimir, campos, situacaoAdicional, st1, st2, st3, usuario, true, null, tipoExportacaoInterface, agruparEtiquetaPorQtde, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, layoutPadrao, exportarInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario);
    }

    public static String getEtiquetasTermica(boolean isColetaWeb, String filial, String requisicao, String[] exames, int[] materiais, String campoTipo, String campoLayout, boolean reimprimir, String[] campos, String situacaoAdicional, Statement st1, Statement st2, Statement st3, String usuario, boolean atualizarCodigoApoiado, List<ParametroSet> listExames, String tipoExportacaoInterface, boolean agruparEtiquetaPorQtde, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, int layoutPadrao, int exportarInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario) throws Exception {
        return ImprimirEtiquetasColetaTriagem.getEtiquetasTermica(isColetaWeb, filial, requisicao, exames, materiais, campoTipo, campoLayout, reimprimir, campos, situacaoAdicional, st1, st2, st3, usuario, atualizarCodigoApoiado, listExames, false, false, tipoExportacaoInterface, agruparEtiquetaPorQtde, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, layoutPadrao, exportarInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario);
    }

    public static String getEtiquetasTermica(boolean isColetaWeb, String filial, String requisicao, String[] exames, int[] materiais, String campoTipo, String campoLayout, boolean reimprimir, String[] campos, String situacaoAdicional, Statement st1, Statement st2, Statement st3, String usuario, boolean atualizarCodigoApoiado, List<ParametroSet> listExames, boolean isEnviarEtiquetaComoApoio, boolean gerarInterface, String tipoExportacaoInterface, boolean agruparEtiquetaPorQtde, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, int layoutPadrao, int exportarInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario) throws Exception {
        String etiquetas = "";
        ModeloGridTable modeloDados = ImprimirEtiquetasColetaTriagem.geraModeloDados(isColetaWeb, filial, requisicao, exames, materiais, reimprimir, campos, situacaoAdicional, st1, st2, st3, usuario, 1, atualizarCodigoApoiado, null, listExames, isEnviarEtiquetaComoApoio, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtiquetaPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario);
        if (modeloDados.getRowCount() > 0) {
            String codigoLayout = ExameUtil.getCodigoLayout(filial, codigoConvenio, codigoDestino, st1, layoutPadrao);
            StringBuilder buf = new StringBuilder("");
            buf.delete(0, buf.length());
            buf.append("select ");
            buf.append(campoTipo);
            buf.append(", ");
            buf.append(campoLayout);
            buf.append(" from layout where fil_codigo = ");
            buf.append(filial);
            buf.append(" and lay_codigo = ");
            buf.append(codigoLayout);
            ResultSet rsLayout = st1.executeQuery(buf.toString());
            if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString(campoLayout))) {
                String tipo = rsLayout.getString(campoTipo);
                if (tipo.equalsIgnoreCase("T")) {
                    ImpressaoTermica termica = new ImpressaoTermica();
                    termica.setDados(modeloDados);
                    etiquetas = termica.gerarEtiquetas(rsLayout.getString(campoLayout));
                }
                if (gerarInterface || exportarInterface == 1) {
                    ExportarInterface.criaInterface(isColetaWeb, filial, requisicao, "etiquetacoleta", st1, st2, gerarInterface, tipoExportacaoInterface, agruparInterface);
                }
            }
            rsLayout.close();
        }
        return etiquetas;
    }

    public static List<Etiqueta> criaEtiqueta(boolean isColetaWeb, String filial, String requisicao, String[] exames, int[] materiais, boolean reimprimir, String situacaoAdicional, Statement statement, Statement stInserir, Statement statementTemporario, String usuario, int tipoEtiqueta, boolean atualizarCodigoApoiado, ListaExameMaterial<ExameMaterial> listaExamesHPDirectNaoImprimir, List<ParametroSet> listExames, boolean isEnviarEtiquetaComoApoio, String codLabExterno, boolean agruparGuiasInterface, String parametroImprimirEtqTriagemSemMaterial, boolean parametroImprimirEtqColetaSemMaterial, boolean parametroImprimirEtqColetaSelecionadaSemMaterial, boolean agruparEtiquetaPorQtde, String tipoExportacaoInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario) throws SQLException {
        return ImprimirEtiquetasColetaTriagem.criaEtiqueta(isColetaWeb, filial, requisicao, exames, materiais, reimprimir, situacaoAdicional, statement, stInserir, statementTemporario, usuario, tipoEtiqueta, atualizarCodigoApoiado, listaExamesHPDirectNaoImprimir, listExames, isEnviarEtiquetaComoApoio, true, codLabExterno, false, agruparGuiasInterface, parametroImprimirEtqTriagemSemMaterial, parametroImprimirEtqColetaSemMaterial, parametroImprimirEtqColetaSelecionadaSemMaterial, agruparEtiquetaPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Etiqueta> criaEtiqueta(boolean isColetaWeb, String filial, String requisicao, String[] exames, int[] materiais, boolean reimprimir, String situacaoAdicional, Statement statement, Statement stInserir, Statement statementTemporario, String usuario, int tipoEtiqueta, boolean atualizarCodigoApoiado, ListaExameMaterial<ExameMaterial> listaExamesHPDirectNaoImprimir, List<ParametroSet> listExames, boolean isEnviarEtiquetaComoApoio, boolean gravarCodigoTuboRecipiente, String codLabExterno, boolean isSaoMarcos, boolean agruparGuiasInterface, String parametroImprimirEtqTriagemSemMaterial, boolean parametroImprimirEtqColetaSemMaterial, boolean parametroImprimirEtqColetaSelecionadaSemMaterial, boolean agruparEtiquetaPorQtde, String tipoExportacaoInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario) throws SQLException {
        String colunaVolume = ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta) ? "rco_volume" : "rtr_volume";
        String colunaQtde = ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta) ? "rco_qtde" : "rtr_qtde";
        String multiguiaPrincipal = requisicao;
        Integer[] multiguia = null;
        StringBuilder multiguias = new StringBuilder("");
        boolean agruparMultiguia = agruparGuiasInterface;
        if (exames != null && materiais != null && !agruparMultiguia && exames.length > 0 && materiais.length > 0) {
            ValorIn exa = ValorIn.criar(exames);
            ValorIn mat = ValorIn.criar(materiais);
            agruparMultiguia = DBUtil.requisicaoAgrupaMultiguiasLabExterno(statement, filial, requisicao, exa.toString(), ((Object)mat).toString(), codLabExterno);
        }
        if (agruparMultiguia) {
            multiguia = RecepcaoUtil.verificaMultiGuias(statement, filial, requisicao, true, false);
            for (Integer i : multiguia) {
                if (i < Integer.parseInt(multiguiaPrincipal)) {
                    multiguiaPrincipal = String.valueOf(i);
                }
                if (multiguias.length() > 0) {
                    multiguias.append(", ");
                }
                multiguias.append(String.valueOf(i));
            }
        }
        StringBuilder buf = ImprimirEtiquetasColetaTriagem.getSQL(filial, requisicao, exames, materiais, reimprimir, situacaoAdicional, statement, tipoEtiqueta, listaExamesHPDirectNaoImprimir, agruparMultiguia, multiguiaPrincipal, multiguias, parametroImprimirEtqTriagemSemMaterial, parametroImprimirEtqColetaSemMaterial, parametroImprimirEtqColetaSelecionadaSemMaterial, agruparEtiquetaPorQtde);
        ArrayList<Etiqueta> lista = new ArrayList<Etiqueta>();
        HashMap<String, Boolean> possuiLabExternoDaFilial = new HashMap<String, Boolean>();
        try (ResultSet rsColeta = null;){
            rsColeta = statement.executeQuery(buf.toString());
            while (rsColeta.next()) {
                boolean checkIntegrarLabExterno = rsColeta.getBoolean("fil_integrar");
                String labExternoFilial = rsColeta.getString("codigoLabExternoFilial");
                String exame = rsColeta.getString("exa_codigo");
                String labExternoExame = rsColeta.getString("codigoLabExternoExame");
                if (!checkIntegrarLabExterno || Funcoes.textoVazio(labExternoFilial) || Funcoes.textoVazio(labExternoExame) || !labExternoExame.equals(labExternoFilial)) continue;
                possuiLabExternoDaFilial.put(exame, true);
            }
            rsColeta.beforeFirst();
            while (rsColeta.next()) {
                codigoConvenio = rsColeta.getString("con_codigo");
                codigoDestino = rsColeta.getString("des_codigo");
                String codigoAdicionalTuboLabExterno = ImprimirEtiquetasColetaTriagem.getCodigoAdicionalTuboLabExterno(rsColeta.getString("lae_configuracao"));
                boolean enviarEtiquetaComoApoio = isEnviarEtiquetaComoApoio ? isEnviarEtiquetaComoApoio : ImprimirEtiquetasColetaTriagem.getEnviarEtiquetaLabExterno(rsColeta.getString("lae_configuracao"));
                LinkedHashMap<Integer, String> tubosParaImprimir = new LinkedHashMap<Integer, String>();
                tubosParaImprimir.put(rsColeta.getInt("rec_codigo"), rsColeta.getString("rec_descricao"));
                boolean checkIntegrarLabExterno = rsColeta.getBoolean("fil_integrar");
                String labExternoFilial = rsColeta.getString("codigoLabExternoFilial");
                String codigoExame = rsColeta.getString("exa_codigo");
                String mcoCodigo = rsColeta.getString("mco_codigo");
                String labExternoExame = rsColeta.getString("codigoLabExternoExame");
                if (checkIntegrarLabExterno && !Funcoes.textoVazio(labExternoFilial) && !Funcoes.textoVazio(labExternoExame) && possuiLabExternoDaFilial != null && possuiLabExternoDaFilial.containsKey(codigoExame) && ((Boolean)possuiLabExternoDaFilial.get(codigoExame)).booleanValue() && !labExternoExame.equals(labExternoFilial)) continue;
                int tuboPrincipal = rsColeta.getInt("rec_codigo");
                ValorIn codExame = ValorIn.criar(new String[]{codigoExame});
                agruparMultiguia = ImprimirEtiquetasColetaTriagem.isAgruparMultiguia(filial, rsColeta.getString("req_codigo"), codExame.toString(), mcoCodigo, labExternoExame, agruparGuiasInterface, statementTemporario);
                boolean curva = false;
                if (rsColeta.getBoolean("temInterface")) {
                    buf.setLength(0);
                    buf.append("select emi_curva, int_codigo from examematinterface ");
                    buf.append("where fil_codigo = ").append(filial);
                    buf.append(" and exa_codigo = '").append(StringUtil.textoDB(rsColeta.getString("exa_codigo"))).append("' ");
                    buf.append(" and mco_codigo = ").append(rsColeta.getString("mco_codigo"));
                    if (tipoExportacaoInterface.equals("P")) {
                        buf.append(" and emi_padrao = true ");
                    }
                    ResultSet rsCurva = stInserir.executeQuery(buf.toString());
                    ArrayList<Integer> interfacesParaCurvaTemp = new ArrayList<Integer>();
                    while (rsCurva.next()) {
                        if (!rsCurva.getBoolean("emi_curva")) continue;
                        interfacesParaCurvaTemp.add(rsCurva.getInt("int_codigo"));
                        curva = true;
                    }
                    if (!interfacesParaCurvaTemp.isEmpty()) {
                        tubosParaImprimir.clear();
                    }
                    for (Integer int_codigo : interfacesParaCurvaTemp) {
                        buf.delete(0, buf.length());
                        buf.append("select exa_kodigo, mco_kodigo from examematintdesmembrar ");
                        buf.append("where fil_codigo = ").append(filial);
                        buf.append(" and exa_codigo = '").append(StringUtil.textoDB(rsColeta.getString("exa_codigo"))).append("' ");
                        buf.append(" and mco_codigo = ").append(rsColeta.getString("mco_codigo"));
                        buf.append(" and int_codigo = ").append(int_codigo);
                        buf.append(" order by emd_ordem ");
                        rsCurva = stInserir.executeQuery(buf.toString());
                        while (rsCurva.next()) {
                            buf.setLength(0);
                            buf.append("select a.rec_codigo, c.rec_descricao ");
                            buf.append("from ");
                            if (ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta)) {
                                buf.append("recipcoleta a ");
                                buf.append("join recipientes c on c.fil_codigo = a.fil_codigo and c.rec_codigo = a.rec_codigo ");
                                buf.append("where a.fil_codigo = ").append(filial);
                                buf.append(" and a.exa_codigo = '").append(StringUtil.textoDB(rsCurva.getString("exa_kodigo"))).append("'");
                                buf.append(" and a.mco_codigo = ").append(rsCurva.getString("mco_kodigo"));
                                if (agruparInterface == 0) {
                                    buf.append(" and a.rco_interface = true ");
                                }
                            } else {
                                buf.append("reciptriagem a ");
                                buf.append("join recipientes c on c.fil_codigo = a.fil_codigo and c.rec_codigo = a.rec_codigo ");
                                buf.append("where a.fil_codigo = ").append(filial);
                                buf.append(" and a.exa_codigo = '").append(StringUtil.textoDB(rsCurva.getString("exa_kodigo"))).append("'");
                                buf.append(" and a.mco_codigo = ").append(rsCurva.getString("mco_kodigo"));
                                if (agruparInterface == 1) {
                                    buf.append(" and a.rtr_interface = true ");
                                }
                            }
                            buf.append(" order by a.rec_codigo ");
                            ResultSet rsTubos = statementTemporario.executeQuery(buf.toString());
                            while (rsTubos.next()) {
                                if (tubosParaImprimir.containsKey(rsTubos.getInt("rec_codigo"))) continue;
                                tubosParaImprimir.put(rsTubos.getInt("rec_codigo"), rsTubos.getString("rec_descricao"));
                            }
                        }
                    }
                }
                Iterator iterator = tubosParaImprimir.keySet().iterator();
                while (iterator.hasNext()) {
                    int tuboParaImprimir = (Integer)iterator.next();
                    String descricaoTubo = (String)tubosParaImprimir.get(tuboParaImprimir);
                    int qtde = DBUtil.campoNull(rsColeta.getString(colunaQtde)) ? 1 : rsColeta.getInt(colunaQtde);
                    int pos = -1;
                    for (int i = 0; i < qtde; ++i) {
                        String codigoRequisicaoMultiguia;
                        String string = codigoRequisicaoMultiguia = agruparMultiguia ? multiguiaPrincipal : rsColeta.getString("req_codigo");
                        if (isSaoMarcos) {
                            String codigoReq = Funcoes.preencheZero(filial, digitosTuboFilial) + Funcoes.preencheZero(codigoRequisicaoMultiguia, digitosTuboRequisicao);
                            pos = ImprimirEtiquetasColetaTriagem.localizarSaoMarcos(0, codigoReq, lista, tipoEtiqueta, digitosTuboTubo);
                        } else {
                            pos = ImprimirEtiquetasColetaTriagem.localizar(i, rsColeta.getInt("set_codigo"), String.valueOf(tuboParaImprimir), lista, tipoEtiqueta, rsColeta.getInt("mco_codigo"), tuboPrimario);
                        }
                        if (!agruparEtiquetaPorQtde && ImprimirEtiquetasColetaTriagem.isQtdeEtiquetaMaiorQUeUM(qtde, i)) {
                            pos = -1;
                        }
                        StringBuilder bui = new StringBuilder();
                        String codigoTubo = Funcoes.preencheZero(filial, digitosTuboFilial) + Funcoes.preencheZero(agruparMultiguia ? multiguiaPrincipal : rsColeta.getString("req_codigo"), digitosTuboRequisicao) + Funcoes.preencheZero(DBUtil.campoNull(String.valueOf(tuboParaImprimir)) ? "0" : String.valueOf(tuboParaImprimir), digitosTuboTubo);
                        String codigoSemTudo = Funcoes.preencheZero(filial, digitosTuboFilial) + Funcoes.preencheZero(agruparMultiguia ? multiguiaPrincipal : rsColeta.getString("req_codigo"), digitosTuboRequisicao);
                        String codigoComAdicionalLabExterno = "";
                        if (enviarEtiquetaComoApoio) {
                            codigoComAdicionalLabExterno = codigoTubo;
                            if (!Funcoes.textoVazio(codigoAdicionalTuboLabExterno)) {
                                codigoComAdicionalLabExterno = Funcoes.preencheZero(codigoAdicionalTuboLabExterno, digitosTuboFilial) + Funcoes.preencheZero(codigoRequisicaoMultiguia == null ? rsColeta.getString("req_codigo") : codigoRequisicaoMultiguia, digitosTuboRequisicao) + Funcoes.preencheZero(DBUtil.campoNull(String.valueOf(tuboParaImprimir)) ? "0" : String.valueOf(tuboParaImprimir), digitosTuboTubo);
                            }
                        }
                        if (tuboParaImprimir == tuboPrincipal || curva) {
                            bui.delete(0, bui.length());
                            if (tipoEtiqueta == 2 || tipoEtiqueta == 4) {
                                bui.append("update examerequisicao set exr_dataetqtriagem = current_timestamp, usr_codetqtriagem = '");
                            } else {
                                bui.append("update examerequisicao set exr_dataetqcoleta = current_timestamp, usr_codetqcoleta = '");
                            }
                            bui.append(StringUtil.textoDB(usuario));
                            bui.append("' ");
                            if (atualizarCodigoApoiado && DBUtil.campoExiste(stInserir, "examerequisicao", "exr_codigoapoiado")) {
                                if (Funcoes.textoVazio(codigoComAdicionalLabExterno)) {
                                    bui.append(", exr_codigoapoiado = null ");
                                } else {
                                    String etiquetaPrincipal = codigoComAdicionalLabExterno;
                                    if (curva) {
                                        etiquetaPrincipal = etiquetaPrincipal.substring(0, etiquetaPrincipal.length() - digitosTuboTubo);
                                        etiquetaPrincipal = etiquetaPrincipal + Funcoes.preencheZero(tuboPrincipal, digitosTuboTubo);
                                    }
                                    bui.append(", exr_codigoapoiado = '").append(etiquetaPrincipal).append("' ");
                                }
                            }
                            bui.append(" where fil_codigo = ").append(filial);
                            bui.append(" and exa_codigo = '");
                            bui.append(rsColeta.getString("exa_codigo"));
                            bui.append("' and mco_codigo =  ");
                            bui.append(rsColeta.getString("mco_codigo"));
                            bui.append(" and req_codigo = ");
                            bui.append(rsColeta.getString("req_codigo"));
                            if (isColetaWeb) {
                                stInserir.executeUpdate(bui.toString());
                            } else {
                                Conexao.executeUpdate(filial, stInserir, bui.toString());
                            }
                            ImprimirEtiquetasColetaTriagem.gravarHistoricoImpressao(stInserir, filial, rsColeta.getString("req_codigo"), rsColeta.getString("exa_codigo"), rsColeta.getString("mco_codigo"), ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta) ? "C" : "T", usuario);
                        }
                        bui = new StringBuilder("select count(req_codigo) as contagem from examerequisicaorecipiente ");
                        bui.append("where fil_codigo = ");
                        bui.append(filial);
                        bui.append(" and exa_codigo = '");
                        bui.append(rsColeta.getString("exa_codigo"));
                        bui.append("' and mco_codigo =  ");
                        bui.append(rsColeta.getString("mco_codigo"));
                        bui.append(" and req_codigo = ");
                        bui.append(rsColeta.getString("req_codigo"));
                        bui.append(" and rec_codigo = ");
                        bui.append(rsColeta.getString("rec_codigo"));
                        bui.append(" and rec_kodigo = ");
                        bui.append(String.valueOf(tuboParaImprimir));
                        try (ResultSet result = null;){
                            result = stInserir.executeQuery(bui.toString());
                            if (result.next()) {
                                if (listExames != null) {
                                    for (ParametroSet exame : listExames) {
                                        if (!exame.getString("codigoExame").equalsIgnoreCase(rsColeta.getString("exa_codigo")) || exame.getInt("codigoMaterial").intValue() != rsColeta.getInt("mco_codigo") || Funcoes.textoVazio(exame.getString("codigoApoiado"))) continue;
                                        codigoComAdicionalLabExterno = exame.getString("codigoApoiado");
                                        if (!isEnviarEtiquetaComoApoio) break;
                                        codigoComAdicionalLabExterno = codigoComAdicionalLabExterno.substring(0, codigoComAdicionalLabExterno.length() - digitosTuboTubo);
                                        codigoComAdicionalLabExterno = codigoComAdicionalLabExterno + Funcoes.preencheZero(tuboParaImprimir, digitosTuboTubo);
                                        break;
                                    }
                                }
                                if (result.getInt("contagem") <= 0) {
                                    bui.delete(0, bui.length());
                                    bui.append("insert into examerequisicaorecipiente(fil_codigo, exa_codigo,");
                                    bui.append("mco_codigo, req_codigo, rec_codigo, ere_tipo, rec_kodigo, ere_codigoapoiado) values (");
                                    bui.append(filial);
                                    bui.append(", '");
                                    bui.append(rsColeta.getString("exa_codigo"));
                                    bui.append("', ");
                                    bui.append(rsColeta.getString("mco_codigo"));
                                    bui.append(", ");
                                    bui.append(rsColeta.getString("req_codigo"));
                                    bui.append(", ");
                                    bui.append(rsColeta.getString("rec_codigo"));
                                    bui.append(", '").append(ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta) ? "C" : "T").append("'");
                                    bui.append(", ");
                                    bui.append(String.valueOf(tuboParaImprimir));
                                    if (gravarCodigoTuboRecipiente) {
                                        bui.append(", '").append(!Funcoes.textoVazio(codigoComAdicionalLabExterno) ? codigoComAdicionalLabExterno : codigoTubo).append("' ");
                                    } else {
                                        bui.append(", null ");
                                    }
                                    bui.append(")");
                                    if (isColetaWeb) {
                                        stInserir.execute(bui.toString());
                                    } else {
                                        Conexao.execute(filial, stInserir, bui.toString());
                                    }
                                } else {
                                    bui = new StringBuilder("update examerequisicaorecipiente set ere_codigoapoiado = '");
                                    bui.append(!Funcoes.textoVazio(codigoComAdicionalLabExterno) ? codigoComAdicionalLabExterno : codigoTubo);
                                    bui.append("' ");
                                    bui.append("where fil_codigo = ");
                                    bui.append(filial);
                                    bui.append(" and exa_codigo = '");
                                    bui.append(rsColeta.getString("exa_codigo"));
                                    bui.append("' and mco_codigo =  ");
                                    bui.append(rsColeta.getString("mco_codigo"));
                                    bui.append(" and req_codigo = ");
                                    bui.append(rsColeta.getString("req_codigo"));
                                    bui.append(" and rec_codigo = ");
                                    bui.append(rsColeta.getString("rec_codigo"));
                                    bui.append(" and rec_kodigo = ");
                                    bui.append(String.valueOf(tuboParaImprimir));
                                    if (isColetaWeb) {
                                        stInserir.execute(bui.toString());
                                    } else {
                                        Conexao.execute(filial, stInserir, bui.toString());
                                    }
                                }
                            }
                            if (pos > -1) {
                                if (multiguia != null && multiguia.length > 1 && lista != null) {
                                    boolean jaAdicionou = false;
                                    for (int j = 0; j < lista.size(); ++j) {
                                        if (!lista.get((int)j).codigosExames.contains(rsColeta.getString("exa_codigo")) || !lista.get((int)j).codigoTubo.equals(codigoTubo)) continue;
                                        jaAdicionou = true;
                                        break;
                                    }
                                    if (jaAdicionou) continue;
                                }
                                ImprimirEtiquetasColetaTriagem.adicionaTubo(lista, tipoEtiqueta, pos, String.valueOf(tuboParaImprimir), rsColeta.getString("exa_codigo"), rsColeta.getInt("mco_codigo"), rsColeta.getString("mco_descricao"), rsColeta.getString("mco_abreviatura"), qtde, rsColeta.getDouble(colunaVolume), rsColeta.getDouble("rec_capacidade"), codigoTubo, rsColeta.getString("pac_nome"), rsColeta.getString("pac_nomesocial"), rsColeta.getDate("pac_datanasc"), rsColeta.getInt("fil_codigo"), rsColeta.getString("fil_descricao"), rsColeta.getString("unm_codigo"), rsColeta.getInt("set_codigo"), rsColeta.getString("set_descricao"), rsColeta.getString("set_sigla"), rsColeta.getTimestamp("exr_datamaterial"), descricaoTubo, rsColeta.getString("col_codigo"), rsColeta.getString("col_descricao"), rsColeta.getInt("con_codigo"), rsColeta.getString("con_razao"), rsColeta.getString("con_fantasia"), rsColeta.getTimestamp("dataHoraAtual"), rsColeta.getDouble("req_peso"), rsColeta.getDouble("req_altura"), rsColeta.getString("req_idade") + " " + Tipos.tipoIdade(rsColeta.getString("req_anomes")), rsColeta.getString("tempoJejum"), rsColeta.getString("exr_volumediurese"), rsColeta.getString("exr_tempodiurese"), rsColeta.getBoolean("req_gestante"), rsColeta.getString("exr_descricaomaterial"), rsColeta.getBoolean("req_urgente"), rsColeta.getTimestamp("exr_datatriagem"), rsColeta.getString("pac_razaosocial"), rsColeta.getString("pac_cnpj"), rsColeta.getString("pac_proprietario"), rsColeta.getString("pac_sif"), rsColeta.getString("req_descricaoproduto"), rsColeta.getString("req_datafabricacao"), rsColeta.getString("req_numeroregistroproduto"), rsColeta.getString("req_temperaturacoletaproduto"), rsColeta.getString("req_numeroloteproduto"), rsColeta.getString("req_datavalidade"), rsColeta.getString("req_marcaproduto"), rsColeta.getString("req_lacreproduto"), rsColeta.getString("req_lacreprodutocontra"), rsColeta.getString("req_lacreprodutocontraempresa"), rsColeta.getString("req_doctoreferenciaproduto"), rsColeta.getString("req_temperaturarecebimento"), rsColeta.getString("req_tiporecebimentoproduto"), rsColeta.getInt("req_qtdeamostraproduto"), rsColeta.getDouble("req_qtdeunidadeproduto"), rsColeta.getString("unm_codigorequisicao"), rsColeta.getString("emb_descricao"), rsColeta.getDate("req_dataentregaprev"), rsColeta.getDate("req_datarecebimentoproduto"), rsColeta.getString("req_localcoletaproduto"), rsColeta.getTime("req_horarecebimentoproduto"), rsColeta.getString("multiguiaprincipal"), rsColeta.getString("multiguias"), rsColeta.getString("req_matricula"), rsColeta.getDouble("rec_volumeminimo"), rsColeta.getString("des_codigo"), rsColeta.getString("des_descricao"), rsColeta.getString("emc_instrcoleta"), rsColeta.getString("req_areaproduto"), rsColeta.getString("req_obs"), rsColeta.getString("codigoAlaHospital"), rsColeta.getString("descricaoAlaHospital"), rsColeta.getString("quartoHospital"), rsColeta.getString("leitoHospital"), rsColeta.getInt("codigoLabExternoPadrao"), rsColeta.getString("descricaoLabExternoPadrao"), codigoAdicionalTuboLabExterno, codigoComAdicionalLabExterno, rsColeta.getBoolean("emc_preparoespecial"), rsColeta.getString("pac_codigo"), rsColeta.getInt("req_idade"), rsColeta.getString("req_anomes"), Variaveis.nomeEstacao, rsColeta.getString("responsavelPacienteRequisicao"), rsColeta.getString("cpfResponsavelPacienteRequisicao"), rsColeta.getBoolean("incapacitadoPacienteRequisicao"), rsColeta.getString("responsavelPaciente"), rsColeta.getString("cpfResponsavelPaciente"), rsColeta.getBoolean("incapacitadoPaciente"), rsColeta.getString("dadosClinicosRequisicao"), rsColeta.getString("guiaRequisicao"), rsColeta.getString("codigoUsuarioAbertura"), rsColeta.getString("nomeUsuarioAbertura"), isSaoMarcos, rsColeta.getString("conservacaoExame"), rsColeta.getString("diasConservacaoExame"), rsColeta.getString("temperaturaInicialConservacaoExame"), rsColeta.getString("temperaturaFinalConservacaoExame"), rsColeta.getString("periodoGestacionalRequisicao"), rsColeta.getString("cpfPaciente"), rsColeta.getString("req_perguntas"), rsColeta.getString("req_sanitariasproduto"), rsColeta.getString("senhaWebPaciente"), rsColeta.getString("senhaWebRequisicao"), codigoSemTudo, tuboPrimario, utilizarCapacidadeTuboPrimario);
                                continue;
                            }
                            Etiqueta etq = new Etiqueta(String.valueOf(tuboParaImprimir), Funcoes.preencheVazio(rsColeta.getString("exa_codigo"), 6, 2), rsColeta.getInt("mco_codigo"), rsColeta.getString("mco_descricao"), rsColeta.getString("mco_abreviatura"), qtde, rsColeta.getDouble(colunaVolume), rsColeta.getDouble("rec_capacidade"), codigoTubo, rsColeta.getString("pac_nome"), rsColeta.getString("pac_nomesocial"), rsColeta.getDate("pac_datanasc"), rsColeta.getInt("fil_codigo"), rsColeta.getString("fil_descricao"), rsColeta.getString("unm_codigo"), rsColeta.getInt("set_codigo"), rsColeta.getString("set_descricao"), rsColeta.getString("set_sigla"), rsColeta.getTimestamp("exr_datamaterial"), descricaoTubo, rsColeta.getString("col_codigo"), rsColeta.getString("col_descricao"), rsColeta.getInt("con_codigo"), rsColeta.getString("con_razao"), rsColeta.getString("con_fantasia"), rsColeta.getTimestamp("dataHoraAtual"), rsColeta.getDouble("req_peso"), rsColeta.getDouble("req_altura"), rsColeta.getString("req_idade") + " " + Tipos.tipoIdade(rsColeta.getString("req_anomes")), rsColeta.getString("tempoJejum"), rsColeta.getString("exr_volumediurese"), rsColeta.getString("exr_tempodiurese"), rsColeta.getBoolean("req_gestante"), rsColeta.getString("exr_descricaomaterial"), rsColeta.getBoolean("req_urgente"), rsColeta.getTimestamp("exr_datatriagem"), rsColeta.getString("pac_razaosocial"), rsColeta.getString("pac_cnpj"), rsColeta.getString("pac_proprietario"), rsColeta.getString("pac_sif"), rsColeta.getString("req_descricaoproduto"), rsColeta.getString("req_datafabricacao"), rsColeta.getString("req_numeroregistroproduto"), rsColeta.getString("req_temperaturacoletaproduto"), rsColeta.getString("req_numeroloteproduto"), rsColeta.getString("req_datavalidade"), rsColeta.getString("req_marcaproduto"), rsColeta.getString("req_lacreproduto"), rsColeta.getString("req_lacreprodutocontra"), rsColeta.getString("req_lacreprodutocontraempresa"), rsColeta.getString("req_doctoreferenciaproduto"), rsColeta.getString("req_temperaturarecebimento"), rsColeta.getString("req_tiporecebimentoproduto"), rsColeta.getInt("req_qtdeamostraproduto"), rsColeta.getDouble("req_qtdeunidadeproduto"), rsColeta.getString("unm_codigorequisicao"), rsColeta.getString("emb_descricao"), rsColeta.getDate("req_dataentregaprev"), rsColeta.getDate("req_datarecebimentoproduto"), rsColeta.getTime("req_horarecebimentoproduto"), rsColeta.getString("req_localcoletaproduto"), rsColeta.getString("multiguiaprincipal"), rsColeta.getString("multiguias"), rsColeta.getString("req_matricula"), rsColeta.getDouble("rec_volumeminimo"), lista.size() + 1, rsColeta.getString("des_codigo"), rsColeta.getString("des_descricao"), rsColeta.getString("emc_instrcoleta"), rsColeta.getString("req_areaproduto"), rsColeta.getString("req_obs"), rsColeta.getString("codigoAlaHospital"), rsColeta.getString("descricaoAlaHospital"), rsColeta.getString("quartoHospital"), rsColeta.getString("leitoHospital"), rsColeta.getInt("codigoLabExternoPadrao"), rsColeta.getString("descricaoLabExternoPadrao"), codigoAdicionalTuboLabExterno, codigoComAdicionalLabExterno, rsColeta.getBoolean("emc_preparoespecial"), rsColeta.getString("pac_codigo"), rsColeta.getInt("req_idade"), rsColeta.getString("req_anomes"), Variaveis.nomeEstacao, rsColeta.getString("responsavelPacienteRequisicao"), rsColeta.getString("cpfResponsavelPacienteRequisicao"), rsColeta.getBoolean("incapacitadoPacienteRequisicao"), rsColeta.getString("responsavelPaciente"), rsColeta.getString("cpfResponsavelPaciente"), rsColeta.getBoolean("incapacitadoPaciente"), rsColeta.getString("dadosClinicosRequisicao"), rsColeta.getString("guiaRequisicao"), rsColeta.getString("codigoUsuarioAbertura"), rsColeta.getString("nomeUsuarioAbertura"), rsColeta.getString("periodoGestacionalRequisicao"), rsColeta.getString("cpfPaciente"), rsColeta.getString("req_perguntas"), rsColeta.getString("req_sanitariasproduto"), rsColeta.getString("senhaWebPaciente"), rsColeta.getString("senhaWebRequisicao"), codigoSemTudo);
                            etq.setConservacaoExame(rsColeta.getString("conservacaoExame"));
                            etq.setDiasConservacaoExame(rsColeta.getString("diasConservacaoExame"));
                            etq.setTemperaturaInicialConservacaoExame(rsColeta.getString("temperaturaInicialConservacaoExame"));
                            etq.setTemperaturaFinalConservacaoExame(rsColeta.getString("temperaturaFinalConservacaoExame"));
                            etq.exameParaRecoleta.add(new ExameAdicionado(rsColeta.getString("exa_codigo"), rsColeta.getInt("mco_codigo")));
                            lista.add(etq);
                            continue;
                        }
                    }
                }
            }
        }
        return lista;
    }

    private static String getSqlDadosRecipiente(String filial, String requisicao, boolean isColeta) {
        StringBuilder bui = new StringBuilder("SELECT a.exa_codigo, b.rec_codigo,\tc.rec_descricao, d.mco_codigo, a.req_codigo, s.set_codigo, a.fil_codigo ");
        bui.append(" FROM examerequisicao a");
        bui.append(" LEFT JOIN requisicao e ON a.fil_codigo = e.fil_codigo\tAND a.req_codigo = e.req_codigo");
        if (isColeta) {
            bui.append(" LEFT JOIN recipcoleta b ON a.fil_codigo = b.fil_codigo AND upper(a.exa_codigo) = upper(b.exa_codigo) AND a.mco_codigo = b.mco_codigo");
        } else {
            bui.append(" LEFT JOIN reciptriagem b ON a.fil_codigo = b.fil_codigo AND upper(a.exa_codigo) = upper(b.exa_codigo) AND a.mco_codigo = b.mco_codigo");
        }
        bui.append(" JOIN recipientes c ON b.fil_codigo = c.fil_codigo AND b.rec_codigo = c.rec_codigo");
        bui.append(" LEFT JOIN materialcoleta d ON a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo");
        bui.append(" LEFT JOIN examesetor es ON a.fil_codigo = es.fil_codigo AND upper(a.exa_codigo) = upper(es.exa_codigo)");
        bui.append(" LEFT JOIN setores s ON es.fil_codigo = s.fil_codigo AND es.set_codigo = s.set_codigo");
        bui.append(" WHERE a.fil_codigo = ").append(filial).append(" AND a.req_codigo IN (").append(requisicao).append(") ");
        bui.append(" AND (not e.req_excluida OR (e.req_excluida AND e.req_origemagendamento)) AND a.exr_excluido = false ");
        bui.append(" AND (a.exr_situacao = '' or a.exr_situacao is null OR a.exr_situacao = 'T' OR a.exr_situacao = 'R') ");
        bui.append(" AND es.ese_printetqcoleta = true ");
        bui.append(" ORDER BY b.rec_codigo, a.mco_codigo, ");
        if (isColeta) {
            bui.append("b.rco_qtde, ");
        } else {
            bui.append("b.rtr_qtde, ");
        }
        bui.append("a.exa_codigo ");
        return bui.toString();
    }

    public static void criaRecipiente(boolean isColetaWeb, String filial, String requisicao, int tipoEtiqueta, boolean isEnviarEtiquetaComoApoio, boolean agruparMultiguia, Statement st, Statement st2, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, int agruparInterface, boolean agruparGuiasInterface) {
        ResultSet rsRecipiente = null;
        LinkedHashMap tubosParaImprimir = new LinkedHashMap();
        String requisicaoPai = requisicao;
        if (agruparGuiasInterface && (agruparInterface == 0 || agruparInterface == 1)) {
            Integer[] multiguia;
            block11: {
                multiguia = null;
                try {
                    multiguia = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
                }
                catch (SQLException e1) {
                    if (isColetaWeb) break block11;
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificiar multiguia no carregamento de lote.\n" + e1.getMessage(), e1.getStackTrace());
                }
            }
            requisicao = StringUtil.implode(Arrays.asList(multiguia), ",");
        }
        try {
            rsRecipiente = st.executeQuery(ImprimirEtiquetasColetaTriagem.getSqlDadosRecipiente(filial, requisicao, ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta)));
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        try {
            while (rsRecipiente.next()) {
                String tipo;
                int tuboParaImprimir = rsRecipiente.getInt("rec_codigo");
                String codigoTubo = Funcoes.preencheZero(filial, digitosTuboFilial) + Funcoes.preencheZero(agruparMultiguia ? requisicaoPai : rsRecipiente.getString("req_codigo"), digitosTuboRequisicao) + Funcoes.preencheZero(DBUtil.campoNull(String.valueOf(tuboParaImprimir)) ? "0" : String.valueOf(tuboParaImprimir), digitosTuboTubo);
                StringBuilder bui = new StringBuilder("select count(req_codigo) as contagem from examerequisicaorecipiente ");
                bui.append("where fil_codigo = ");
                bui.append(filial);
                bui.append(" and exa_codigo = '");
                bui.append(rsRecipiente.getString("exa_codigo"));
                bui.append("' and mco_codigo =  ");
                bui.append(rsRecipiente.getString("mco_codigo"));
                bui.append(" and req_codigo = ");
                bui.append(rsRecipiente.getString("req_codigo"));
                bui.append(" and rec_codigo = ");
                bui.append(rsRecipiente.getString("rec_codigo"));
                bui.append(" and rec_kodigo = ");
                bui.append(rsRecipiente.getString("rec_codigo"));
                ResultSet result = null;
                result = st2.executeQuery(bui.toString());
                if (!result.next()) continue;
                bui.delete(0, bui.length());
                String string = tipo = ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta) ? "C" : "T";
                if (result.getInt("contagem") <= 0) {
                    bui.append("insert into examerequisicaorecipiente(fil_codigo, exa_codigo,");
                    bui.append("mco_codigo, req_codigo, rec_codigo, ere_tipo, rec_kodigo, ere_codigoapoiado) values (");
                    bui.append(filial);
                    bui.append(", '");
                    bui.append(rsRecipiente.getString("exa_codigo"));
                    bui.append("', ");
                    bui.append(rsRecipiente.getString("mco_codigo"));
                    bui.append(", ");
                    bui.append(rsRecipiente.getString("req_codigo"));
                    bui.append(", ");
                    bui.append(rsRecipiente.getString("rec_codigo"));
                    bui.append(", '").append(tipo).append("'");
                    bui.append(", ");
                    bui.append(rsRecipiente.getString("rec_codigo"));
                    bui.append(", '").append(codigoTubo).append("' ");
                    bui.append(")");
                } else {
                    bui.append("update examerequisicaorecipiente set ere_codigoapoiado = '").append(codigoTubo).append("' ");
                    bui.append("  where ");
                    bui.append("    fil_codigo = ").append(filial);
                    bui.append("    and exa_codigo = '").append(rsRecipiente.getString("exa_codigo")).append("' ");
                    bui.append("    and mco_codigo = ").append(rsRecipiente.getString("mco_codigo"));
                    bui.append("    and req_codigo = ").append(rsRecipiente.getString("req_codigo"));
                    bui.append("    and rec_codigo = ").append(rsRecipiente.getString("rec_codigo"));
                    bui.append("    and ere_tipo = '").append(tipo).append("'");
                    bui.append("    and rec_kodigo = ").append(rsRecipiente.getString("rec_codigo"));
                }
                if (isColetaWeb) {
                    st2.executeUpdate(bui.toString());
                    continue;
                }
                Conexao.execute(filial, st2, bui.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isQtdeEtiquetaMaiorQUeUM(int qtde, int i) {
        return qtde > 1 && i > 0;
    }

    private static boolean isAgruparMultiguia(String filial, String requisicao, String codExame, String mcoCodigo, String codLabExterno, boolean isAgruparGuiasInterface, Statement st) throws SQLException {
        return isAgruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filial, requisicao, codExame, mcoCodigo, codLabExterno);
    }

    private static StringBuilder getSQL(String filial, String requisicao, String[] exames, int[] materiais, boolean reimprimir, String situacaoAdicional, Statement statement, int tipoEtiqueta, ListaExameMaterial<ExameMaterial> listaExamesHPDirectNaoImprimir, boolean agruparMultiguia, String multiguiaPrincipal, StringBuilder multiguias, String parametroImprimirEtqTriagemSemMaterial, boolean parametroImprimirEtqColetaSemMaterial, boolean parametroImprimirEtqColetaSelecionadaSemMaterial, boolean agruparEtiquetaPorQtde) {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("select a.exa_codigo, c.rec_capacidade, b.rec_codigo, ");
        if (ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta)) {
            buf.append("b.rco_qtde, b.rco_volume, b.rco_interface as temInterface, ");
        } else {
            buf.append("b.rtr_qtde, b.rtr_volume, b.rtr_interface as temInterface, ");
        }
        buf.append("d.mco_abreviatura, d.mco_codigo, d.mco_descricao, a.req_codigo, f.pac_nome, f.pac_datanasc, c.rec_capacidade, c.unm_codigo, ");
        buf.append("s.set_codigo, s.set_descricao, s.set_sigla, a.fil_codigo, filial.fil_descricao, e.con_codigo, e.des_codigo, ");
        buf.append("a.exr_datamaterial, c.rec_descricao, coletas.col_codigo, coletas.col_descricao, ");
        buf.append("con.con_codigo, con.con_razao, con.con_fantasia, ");
        buf.append("destino.des_codigo, destino.des_descricao, ");
        buf.append("emc.emc_instrcoleta, e.req_obs, e.req_sanitariasproduto, e.req_perguntas, ");
        buf.append("current_timestamp as dataHoraAtual, (e.req_urgente or coalesce(a.exr_urgente, false)) as req_urgente, ");
        buf.append("e.req_peso, e.req_altura, e.req_idade, e.req_anomes, e.req_matricula, ");
        buf.append("CASE WHEN exr_intervaloJejum is null then TO_CHAR(exr_tempoJejum,'HH24:MI') else TO_CHAR(exr_intervaloJejum,'HH24:MI') end  as tempoJejum, a.exr_volumediurese, a.exr_tempodiurese, ");
        buf.append("e.req_responsavel as responsavelPacienteRequisicao, e.req_cpfresponsavel as cpfResponsavelPacienteRequisicao, coalesce(e.req_incapacitado,false) as incapacitadoPacienteRequisicao,");
        buf.append("f.pac_responsavel as responsavelPaciente, f.pac_cpfresponsavel as cpfResponsavelPaciente, coalesce(f.pac_incapacitado, false) as incapacitadoPaciente,");
        buf.append("e.req_gestante, a.exr_descricaomaterial, a.exr_datatriagem, e.req_idade, e.req_anomes, ");
        buf.append("f.pac_razaosocial, f.pac_proprietario, f.pac_cnpj, f.pac_sif, ");
        buf.append("e.req_descricaoproduto, e.req_datafabricacao, e.req_numeroregistroproduto, ");
        buf.append("e.req_temperaturacoletaproduto, e.req_numeroloteproduto, e.req_datavalidade, ");
        buf.append("e.req_localcoletaproduto,  c.rec_volumeminimo, ");
        buf.append("'").append(multiguiaPrincipal).append("' as multiguiaprincipal, ");
        buf.append("'").append((CharSequence)multiguias).append("' as multiguias, ");
        buf.append("e.req_marcaproduto, e.req_lacreproduto, e.req_lacreprodutocontra, e.req_areaproduto,");
        buf.append("e.req_lacreprodutocontraempresa, e.req_doctoreferenciaproduto, ");
        buf.append("e.req_temperaturarecebimento, e.req_tiporecebimentoproduto, ");
        buf.append("e.req_qtdeamostraproduto, e.req_qtdeunidadeproduto, e.unm_codigo as unm_codigorequisicao, ");
        buf.append("e.req_datarecebimentoproduto, e.req_horarecebimentoproduto, e.req_dataentregaprev, ");
        buf.append("emb.emb_descricao, ");
        buf.append("emc.emc_preparoespecial, ");
        buf.append("emc.emc_conservacao AS conservacaoExame, ");
        buf.append("emc.emc_diasconserva AS diasConservacaoExame, ");
        buf.append("emc.emc_temperaturainicial AS temperaturaInicialConservacaoExame, ");
        buf.append("emc.emc_temperaturafinal AS temperaturaFinalConservacaoExame, ");
        buf.append("e.req_dclinicos dadosClinicosRequisicao, ");
        buf.append("ala.ala_codigo as codigoAlaHospital, ");
        buf.append("ala.ala_descricao as descricaoAlaHospital, ");
        buf.append("e.req_quarto as quartoHospital, ");
        buf.append("e.req_leito as leitoHospital,");
        buf.append("lae.lae_configuracao, lae.lae_codigo as codigoLabExternoPadrao, lae.lae_descricao as descricaoLabExternoPadrao, '' as tuboComAdicionalLabExternoPadrao, ");
        buf.append("filial.lae_codigo as codigoLabExternoFilial,");
        buf.append("ele.lae_codigo as codigoLabExternoExame,");
        buf.append("filial.fil_integrar,");
        buf.append("f.pac_codigo, COALESCE(a.exr_codigoapoiado, '') as exr_codigoapoiado, f.pac_nomesocial, ");
        buf.append("req_guia as guiaRequisicao, e.usr_codabertura as codigoUsuarioAbertura, usr.usr_nome as nomeUsuarioAbertura ");
        buf.append(", e.req_periodogestacional as periodoGestacionalRequisicao, f.pac_cpf as cpfPaciente , f.pac_senhaweb as senhaWebPaciente, e.req_senhaweb as senhaWebRequisicao ");
        buf.append("from examerequisicao a ");
        buf.append("left join requisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo ");
        buf.append("left join paciente f on e.fil_codigo = f.fil_codigo and e.pac_codigo = f.pac_codigo ");
        if (ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta)) {
            buf.append("left join recipcoleta b on a.fil_codigo = b.fil_codigo and upper(a.exa_codigo) = upper(b.exa_codigo) and a.mco_codigo = b.mco_codigo ");
        } else {
            buf.append("left join reciptriagem b on a.fil_codigo = b.fil_codigo and upper(a.exa_codigo) = upper(b.exa_codigo) and a.mco_codigo = b.mco_codigo ");
        }
        buf.append("join recipientes c on b.fil_codigo = c.fil_codigo and b.rec_codigo = c.rec_codigo ");
        buf.append("left join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo ");
        buf.append("left join examesetor es on a.fil_codigo = es.fil_codigo and upper(a.exa_codigo) = upper(es.exa_codigo) ");
        buf.append("left join setores s on es.fil_codigo = s.fil_codigo and es.set_codigo = s.set_codigo ");
        buf.append("left join coletas on e.fil_codigo = coletas.fil_codigo and e.col_codigo = coletas.col_codigo ");
        buf.append("left join destino on e.fil_codigo = destino.fil_codigo and e.des_codigo = destino.des_codigo ");
        buf.append("left join examematcoleta emc on a.fil_codigo = emc.fil_codigo and a.exa_codigo = emc.exa_codigo and a.mco_codigo = emc.mco_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
        buf.append("left join convenios con on e.fil_codigo = con.fil_codigo and e.con_codigo = con.con_codigo ");
        buf.append("left join embalagemproduto emb on e.fil_codigo = emb.fil_codigo and e.emb_codigo = emb.emb_codigo ");
        buf.append("left join alahospital ala on e.fil_codigo = ala.fil_codigo and e.ala_codigo = ala.ala_codigo ");
        if (ImprimirEtiquetasColetaTriagem.isLabExternoPadraoFilial(statement, filial)) {
            buf.append("left join examematcoletalabexterno ele on a.fil_codigo = ele.fil_codigo and  a.exa_codigo = ele.exa_codigo and a.mco_codigo = ele.mco_codigo and (ele.ele_padrao or filial.lae_codigo = ele.lae_codigo) ");
        } else {
            buf.append("left join examematcoletalabexterno ele on a.fil_codigo = ele.fil_codigo and  a.exa_codigo = ele.exa_codigo and a.mco_codigo = ele.mco_codigo  and ele.ele_padrao  ");
        }
        buf.append("left join labexterno lae on a.fil_codigo = lae.fil_codigo and ele.lae_codigo = lae.lae_codigo ");
        buf.append("left join loteexternorequisicao ler on a.fil_codigo = ler.fil_codigo and lae.lae_codigo = ler.lae_codigo and a.req_codigo = ler.req_codigo ");
        buf.append("left join usuario usr on a.fil_codigo = usr.fil_codigo and e.usr_codabertura = usr.usr_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo IN (").append(agruparMultiguia ? multiguias : multiguiaPrincipal).append(") ");
        buf.append(" and (not e.req_excluida OR (e.req_excluida AND e.req_origemagendamento))  and a.exr_excluido = false ");
        buf.append(" and (a.exr_situacao = '' or a.exr_situacao is null or a.exr_situacao = '");
        buf.append("T");
        if (!Funcoes.textoVazio(situacaoAdicional)) {
            buf.append("' or a.exr_situacao = '");
            buf.append(situacaoAdicional);
        }
        if (tipoEtiqueta == 1 && parametroImprimirEtqColetaSemMaterial || tipoEtiqueta == 3 && parametroImprimirEtqColetaSelecionadaSemMaterial) {
            buf.append("' or a.exr_situacao = '").append("F");
            buf.append("' or a.exr_situacao = '").append("R");
        } else if (tipoEtiqueta == 2 && parametroImprimirEtqTriagemSemMaterial != null && parametroImprimirEtqTriagemSemMaterial.equals("1")) {
            buf.append("' or a.exr_situacao = '").append("F");
            buf.append("' or a.exr_situacao = '").append("R");
        }
        buf.append("' or a.exr_situacao = '").append("N");
        buf.append("' or a.exr_situacao = '").append("P");
        buf.append("')");
        if (exames != null && exames.length > 0 && materiais != null && exames.length == materiais.length) {
            buf.append(" and ( ");
            for (i = 0; i < exames.length; ++i) {
                buf.append("(a.exa_codigo = '");
                buf.append(exames[i]);
                buf.append("' and a.mco_codigo = ");
                buf.append(materiais[i]);
                buf.append(") ");
                if (i >= exames.length - 1) continue;
                buf.append(" or ");
            }
            buf.append(") ");
        } else if (exames != null && exames.length > 0) {
            buf.append(" and ( ");
            for (i = 0; i < exames.length; ++i) {
                buf.append("(a.exa_codigo = '");
                buf.append(exames[i]);
                buf.append("') ");
                if (i >= exames.length - 1) continue;
                buf.append(" or ");
            }
            buf.append(") ");
        }
        if (!reimprimir) {
            if (ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta)) {
                buf.append(" and a.exr_dataetqcoleta is null ");
            } else {
                buf.append(" and a.exr_dataetqtriagem is null ");
            }
        }
        if (ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta)) {
            buf.append(" and es.ese_printetqcoleta = true ");
        } else {
            buf.append(" and es.ese_printetqtriagem = true ");
        }
        if (listaExamesHPDirectNaoImprimir != null && !listaExamesHPDirectNaoImprimir.isEmpty()) {
            buf.append(" and (a.exa_codigo, a.mco_codigo) NOT IN (");
            for (i = 0; i < listaExamesHPDirectNaoImprimir.size(); ++i) {
                ExameMaterial exameMaterial = (ExameMaterial)listaExamesHPDirectNaoImprimir.get(i);
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append("(").append(StringUtil.textoDBEscape(exameMaterial.getCodigoExame()));
                buf.append(",").append(exameMaterial.getCodigoMaterial()).append(")");
            }
            buf.append(") ");
        }
        if (agruparEtiquetaPorQtde) {
            if (ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta)) {
                buf.append("order by b.rco_qtde desc ");
            } else {
                buf.append("order by b.rtr_qtde desc");
            }
        } else {
            buf.append(" order by s.set_codigo, b.rec_codigo, a.mco_codigo, ");
            if (ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta)) {
                buf.append("b.rco_qtde, ");
            } else {
                buf.append("b.rtr_qtde, ");
            }
            buf.append(" a.exa_codigo");
        }
        return buf;
    }

    private static boolean isEtiquetaColeta(int tipoEtiqueta) {
        return tipoEtiqueta == 1 || tipoEtiqueta == 3;
    }

    private static boolean isLabExternoPadraoFilial(Statement st, String filial) {
        StringBuilder buf = new StringBuilder("select fil_codigo, lae_codigo, fil_integrar from filiais_postocoleta ");
        buf.append(" where fil_codigo = ").append(filial);
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                return !DBUtil.campoNull(rs.getString("lae_codigo")) && rs.getBoolean("fil_integrar");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static String getCodigoRequisicaoMultiguia(String codigoExame, ArrayList<Registro> lista) {
        if (lista != null && codigoExame != null) {
            for (int i = 0; i < lista.size(); ++i) {
                Registro reg = lista.get(i);
                if (!codigoExame.equalsIgnoreCase(reg.getValor("exame").toString())) continue;
                return reg.getValor("requisicao").toString();
            }
        }
        return null;
    }

    private static int localizar(int posini, int setor, String tubo, ArrayList<Etiqueta> lista, int tipoEtiqueta, int materialCodigo, boolean tuboPrimario) {
        int retorno = -1;
        if (posini < lista.size() && !lista.isEmpty()) {
            for (int i = posini; i < lista.size(); ++i) {
                Etiqueta o = lista.get(i);
                if (!(o.codigoTubo instanceof String) || !o.codigoTubo.equals(tubo)) continue;
                boolean isColeta = ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta);
                boolean estaConfiguradoTuboPrimario = tuboPrimario;
                if ((!isColeta || !estaConfiguradoTuboPrimario) && (o.codigoSetor != setor || o.codigoMaterial != materialCodigo)) continue;
                retorno = i;
                break;
            }
        }
        return retorno;
    }

    private static int localizarSaoMarcos(int posini, String req, ArrayList<Etiqueta> lista, int tipoEtiqueta, int digitosTuboTubo) {
        int retorno = -1;
        if (posini < lista.size() && lista.size() > 0) {
            for (int i = posini; i < lista.size(); ++i) {
                Etiqueta o = lista.get(i);
                String codigoRequisicao = o.codigoRequisicao.substring(0, o.codigoRequisicao.length() - digitosTuboTubo);
                if (!req.equalsIgnoreCase(codigoRequisicao)) continue;
                retorno = i;
                break;
            }
        }
        return retorno;
    }

    private static ArrayList<Etiqueta> adicionaTubo(ArrayList<Etiqueta> lista, int tipoEtiqueta, int pos, String tubo, String exame, int codigoMaterial, String descricaoMaterial, String abrv, int qtde, double volume, double capacidade, String codigoRequisicaoTubo, String nomePaciente, String nomeSocialPaciente, Date dataNascimento, int codigoFilial, String descricaoFilial, String unidadeRecipiente, int codigoSetor, String descricaoSetor, String siglaSetor, Timestamp dataHora, String descricaoTubo, String codigoColeta, String descricaoColeta, int codigoConvenio, String razaoConvenio, String fantasiaConvenio, Timestamp dataHoraAtual, double peso, double altura, String idade, String jejum, String diurese, String tempoDiurese, boolean gestante, String descricaoMaterialColetado, boolean urgente, Timestamp dataHoraTriagem, String razaoSocialPaciente, String cnpjPaciente, String proprietarioPaciente, String sifPaciente, String descricaoProduto, String dataFabricacaoProduto, String numeroRegistroProduto, String temperaturaColetaProduto, String numeroLoteProduto, String dataValidadeProduto, String marcaProduto, String lacreProduto, String lacreContraProvaProduto, String lacreContraProvaEmpresaProduto, String documentoReferenciaProduto, String temperaturaRecebimentoProduto, String tipoRecebimentoProduto, int qtdeAmostrasProduto, double qtdeUnidadeProduto, String unidadeProduto, String embalagemProduto, Date dataEntrega, Date dataRecebimentoProduto, String localColetaProduto, Time horaRecebimentoProduto, String requisicaoPrincipalMultiguia, String requisicoesMultiguia, String matricula, double volumeMinimo, String codigoDestino, String descricaoDestino, String coletaExame, String areaProduto, String observacao, String codigoAlaHospital, String descricaoAlaHospital, String quartoHospital, String leitoHospital, int codigoLabExternoPadrao, String descricaoLabExternoPadrao, String adicionalLabExternoPadrao, String codigoTuboComAdicionalLabExterno, boolean preparoEspecial, String codigoPaciente, int idadeRequisicao, String anoMesRequisicao, String nomeEstacao, String responsavelPacienteRequisicao, String cpfResponsavelPacienteRequisicao, Boolean incapacitadoPacienteRequisicao, String responsavelPaciente, String cpfResponsavelPaciente, Boolean incapacitadoPaciente, String dadosClinicosRequisicao, String guiaRequisicao, String codigoUsuarioAbertura, String nomeUsuarioAbertura, boolean isSaoMarcos, String conservacaoExame, String diasConservacaoExame, String temperaturaInicialConservacaoExame, String temperaturaFinalConservacaoExame, String periodoGestacionalRequisicao, String cpfPaciente, String perguntasRequisicao, String caracteristicasSanitariasProdutoRequisicao, String senhaWebPaciente, String senhaWebRequisicao, String codigoRequisicaoWeb, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario) {
        Etiqueta s = lista.get(pos);
        double capacity = 0.0;
        double volumeUtilizado = 0.0;
        double novoVolume = 0.0;
        capacity = s.capacidadeRecipiente;
        volumeUtilizado = s.volumeUtilizadoRecipiente;
        if (volume > 0.0) {
            novoVolume = volume;
        }
        if (ImprimirEtiquetasColetaTriagem.isEtiquetaColeta(tipoEtiqueta) && tuboPrimario && !utilizarCapacidadeTuboPrimario) {
            capacity = 0.0;
        }
        if (capacity == 0.0 || capacity > 0.0 && capacity - volumeUtilizado >= novoVolume) {
            s.volumeUtilizadoRecipiente = volumeUtilizado + novoVolume;
            StringBuilder tmp = new StringBuilder(s.codigosExames);
            StringBuilder bufCons = new StringBuilder();
            if (!Funcoes.textoVazio(s.getConservacaoExame())) {
                bufCons.delete(0, bufCons.length());
                bufCons.append(s.getConservacaoExame()).append(" - ");
                bufCons.append(conservacaoExame);
                s.setConservacaoExame(bufCons.toString());
            }
            if (!Funcoes.textoVazio(s.getDiasConservacaoExame())) {
                bufCons.delete(0, bufCons.length());
                bufCons.append(s.getDiasConservacaoExame()).append(" - ");
                bufCons.append(diasConservacaoExame);
                s.setDiasConservacaoExame(bufCons.toString());
            }
            if (!Funcoes.textoVazio(s.getTemperaturaInicialConservacaoExame())) {
                bufCons.delete(0, bufCons.length());
                bufCons.append(s.getTemperaturaInicialConservacaoExame()).append(" - ");
                bufCons.append(temperaturaInicialConservacaoExame);
                s.setTemperaturaInicialConservacaoExame(bufCons.toString());
            }
            if (!Funcoes.textoVazio(s.getTemperaturaFinalConservacaoExame())) {
                bufCons.delete(0, bufCons.length());
                bufCons.append(s.getTemperaturaFinalConservacaoExame()).append(" - ");
                bufCons.append(temperaturaFinalConservacaoExame);
                s.setTemperaturaFinalConservacaoExame(bufCons.toString());
            }
            tmp.append(Funcoes.preencheVazio(exame, 6, 2));
            StringBuilder tmpPreparoEspecial = new StringBuilder(s.exameIdentificaPreparoEspecial);
            tmpPreparoEspecial.append(Funcoes.preencheVazio(exame, preparoEspecial ? 5 : 6, 2)).append(preparoEspecial ? "*" : "");
            if (!s.codigosExames.contains(Funcoes.preencheVazio(exame, 6, 2))) {
                s.codigosExames = tmp.toString();
                s.exameIdentificaPreparoEspecial = tmpPreparoEspecial.toString();
            }
            s.exameParaRecoleta.add(new ExameAdicionado(exame, codigoMaterial));
            if (!s.necessitaPreparoEspecial && preparoEspecial) {
                s.necessitaPreparoEspecial = preparoEspecial;
            }
        } else if (isSaoMarcos) {
            StringBuilder tmp = new StringBuilder(s.codigosExames);
            tmp.append(Funcoes.preencheVazio(exame, 6, 2));
            StringBuilder tmpPreparoEspecial = new StringBuilder(s.exameIdentificaPreparoEspecial);
            tmpPreparoEspecial.append(Funcoes.preencheVazio(exame, preparoEspecial ? 5 : 6, 2)).append(preparoEspecial ? "*" : "");
            if (!s.codigosExames.contains(Funcoes.preencheVazio(exame, 6, 2))) {
                s.codigosExames = tmp.toString();
                s.exameIdentificaPreparoEspecial = tmpPreparoEspecial.toString();
            }
            s.exameParaRecoleta.add(new ExameAdicionado(exame, codigoMaterial));
            if (!s.necessitaPreparoEspecial && preparoEspecial) {
                s.necessitaPreparoEspecial = preparoEspecial;
            }
        } else if ((pos = ImprimirEtiquetasColetaTriagem.localizar(pos + 1, codigoSetor, tubo, lista, tipoEtiqueta, codigoMaterial, tuboPrimario)) < 0) {
            Etiqueta etq = new Etiqueta(tubo, Funcoes.preencheVazio(exame, 6, 2), codigoMaterial, descricaoMaterial, abrv, qtde, volume, capacidade, codigoRequisicaoTubo, nomePaciente, nomeSocialPaciente, dataNascimento, codigoFilial, descricaoFilial, unidadeRecipiente, codigoSetor, descricaoSetor, siglaSetor, dataHora, descricaoTubo, codigoColeta, descricaoColeta, codigoConvenio, razaoConvenio, fantasiaConvenio, dataHoraAtual, peso, altura, idade, jejum, diurese, tempoDiurese, gestante, descricaoMaterialColetado, urgente, dataHoraTriagem, razaoSocialPaciente, cnpjPaciente, proprietarioPaciente, sifPaciente, descricaoProduto, dataFabricacaoProduto, numeroRegistroProduto, temperaturaColetaProduto, numeroLoteProduto, dataValidadeProduto, marcaProduto, lacreProduto, lacreContraProvaProduto, lacreContraProvaEmpresaProduto, documentoReferenciaProduto, temperaturaRecebimentoProduto, tipoRecebimentoProduto, qtdeAmostrasProduto, qtdeUnidadeProduto, unidadeProduto, embalagemProduto, dataEntrega, dataRecebimentoProduto, horaRecebimentoProduto, localColetaProduto, requisicaoPrincipalMultiguia, requisicoesMultiguia, matricula, volumeMinimo, lista.size() + 1, codigoDestino, descricaoDestino, coletaExame, areaProduto, observacao, codigoAlaHospital, descricaoAlaHospital, quartoHospital, leitoHospital, codigoLabExternoPadrao, descricaoLabExternoPadrao, adicionalLabExternoPadrao, codigoTuboComAdicionalLabExterno, preparoEspecial, codigoPaciente, idadeRequisicao, anoMesRequisicao, nomeEstacao, responsavelPacienteRequisicao, cpfResponsavelPacienteRequisicao, incapacitadoPacienteRequisicao, responsavelPaciente, cpfResponsavelPaciente, incapacitadoPaciente, dadosClinicosRequisicao, guiaRequisicao, codigoUsuarioAbertura, nomeUsuarioAbertura, periodoGestacionalRequisicao, cpfPaciente, perguntasRequisicao, caracteristicasSanitariasProdutoRequisicao, senhaWebPaciente, senhaWebRequisicao, codigoRequisicaoWeb);
            etq.setConservacaoExame(conservacaoExame);
            etq.setDiasConservacaoExame(diasConservacaoExame);
            etq.setTemperaturaFinalConservacaoExame(temperaturaInicialConservacaoExame);
            etq.setTemperaturaFinalConservacaoExame(temperaturaFinalConservacaoExame);
            etq.exameParaRecoleta.add(new ExameAdicionado(exame, codigoMaterial));
            lista.add(etq);
        } else {
            lista = ImprimirEtiquetasColetaTriagem.adicionaTubo(lista, tipoEtiqueta, pos, tubo, exame, codigoMaterial, descricaoMaterial, abrv, qtde, volume, capacidade, codigoRequisicaoTubo, nomePaciente, nomeSocialPaciente, dataNascimento, codigoFilial, descricaoFilial, unidadeRecipiente, codigoSetor, descricaoSetor, siglaSetor, dataHora, descricaoTubo, codigoColeta, descricaoColeta, codigoConvenio, razaoConvenio, fantasiaConvenio, dataHoraAtual, peso, altura, idade, jejum, diurese, tempoDiurese, gestante, descricaoMaterialColetado, urgente, dataHoraTriagem, razaoSocialPaciente, cnpjPaciente, proprietarioPaciente, sifPaciente, descricaoProduto, dataFabricacaoProduto, numeroRegistroProduto, temperaturaColetaProduto, numeroLoteProduto, dataValidadeProduto, marcaProduto, lacreProduto, lacreContraProvaProduto, lacreContraProvaEmpresaProduto, documentoReferenciaProduto, temperaturaRecebimentoProduto, tipoRecebimentoProduto, qtdeAmostrasProduto, qtdeUnidadeProduto, unidadeProduto, embalagemProduto, dataEntrega, dataRecebimentoProduto, localColetaProduto, horaRecebimentoProduto, requisicaoPrincipalMultiguia, requisicoesMultiguia, matricula, volumeMinimo, codigoDestino, descricaoDestino, coletaExame, areaProduto, observacao, codigoAlaHospital, descricaoAlaHospital, quartoHospital, leitoHospital, codigoLabExternoPadrao, descricaoLabExternoPadrao, adicionalLabExternoPadrao, codigoTuboComAdicionalLabExterno, preparoEspecial, codigoPaciente, idadeRequisicao, anoMesRequisicao, nomeEstacao, responsavelPacienteRequisicao, cpfResponsavelPacienteRequisicao, incapacitadoPacienteRequisicao, responsavelPaciente, cpfResponsavelPaciente, incapacitadoPaciente, dadosClinicosRequisicao, guiaRequisicao, codigoUsuarioAbertura, nomeUsuarioAbertura, isSaoMarcos, conservacaoExame, diasConservacaoExame, temperaturaInicialConservacaoExame, temperaturaFinalConservacaoExame, periodoGestacionalRequisicao, cpfPaciente, perguntasRequisicao, caracteristicasSanitariasProdutoRequisicao, senhaWebPaciente, senhaWebRequisicao, codigoRequisicaoWeb, tuboPrimario, utilizarCapacidadeTuboPrimario);
        }
        return lista;
    }

    private static String getCodigoAdicionalTuboLabExterno(String xml) {
        String retorno = "";
        if (!Funcoes.textoVazio(xml)) {
            boolean isEnviarTuboConcent = false;
            boolean isEnviarTuboJalis = false;
            boolean bl = isEnviarTuboConcent = xml.contains("enviarTuboLis") ? StringUtil.getBoolean(xml, "enviarTuboLis") : true;
            if (isEnviarTuboConcent && !Funcoes.textoVazio(retorno = StringUtil.getValor(xml, "codigoTuboLis"))) {
                return retorno;
            }
            boolean bl2 = isEnviarTuboJalis = xml.contains("enviarEtiquetaApoio") ? StringUtil.getBoolean(xml, "enviarEtiquetaApoio") : true;
            if (isEnviarTuboJalis && !Funcoes.textoVazio(retorno = StringUtil.getValor(xml, "codigoEtiquetaApoio"))) {
                return retorno;
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ListaExameMaterial getListaExamesHPDirect(String codigoFilial, String codigoRequisicao, String[] codigosExames, int[] codigosMateriais, int tipoEtiqueta, boolean isAgendamento) throws SQLException {
        Statement st;
        block11: {
            ListaExameMaterial<ExameMaterial> listaExameMaterial;
            StringBuilder buf = new StringBuilder();
            buf.append(" select exr.exa_codigo as codigoExame ");
            buf.append("       ,exr.mco_codigo as codigoMaterial ");
            buf.append("       ,con.con_codigo as codigoConvenio ");
            buf.append("       ,con.con_fantasia as fantasiaConvenio ");
            buf.append("       ,pac.pac_nome as nomePaciente ");
            buf.append("       ,pac.pac_nomesocial as nomeSocialPaciente ");
            buf.append("       ,pac.pac_datanasc as dataNascimentoPaciente ");
            buf.append("       ,pac.pac_codigo as codigoPaciente ");
            buf.append("       ,pac.pac_sexo as sexoPaciente ");
            buf.append("       ,lae.lae_configuracao as xmlConfiguracao ");
            buf.append("       ,lae.lae_codigo as codigoLabExterno ");
            buf.append("       ,ele.ele_xmllabexterno as xmlExamePardini ");
            buf.append("       ,lae.lae_codigo as codigoLaboratorioExterno ");
            buf.append("       ,exa.exa_descricao as descricaoExame ");
            buf.append("       ,mco.mco_descricao as descricaoMaterial ");
            buf.append("       ,req.req_data as dataColeta ");
            buf.append("       ,req.req_hora as horaColeta ");
            buf.append("       ,req.req_dum as dumPaciente ");
            buf.append("       ,req.req_idade as idade ");
            buf.append("       ,req.req_obs as observacao");
            buf.append("       ,req.req_peso as peso ");
            buf.append("       ,req.req_altura as alturaPaciente ");
            buf.append("       ,exr.exr_datamaterial as dataMaterial");
            buf.append("       ,exr.exr_codigoapoiado as codigoApoiado ");
            buf.append("       ,exr.exr_tempodiurese as tempoDiurese ");
            buf.append("       ,exr.exr_volumediurese as volumeDiurese ");
            buf.append("       ,exr.exr_descricaomaterial as materialInformado ");
            buf.append("       ,(CASE WHEN (trim(exrc.ere_codigoapoiado) != '') THEN cast(trim(exrc.ere_codigoapoiado) AS varchar) ELSE cast(trim(exr.exr_codigoapoiado) AS varchar) END)\tAS codigoEtiquetaArmazenada ");
            buf.append("       ,lae.lae_configuracao ilike ").append(StringUtil.textoDBEscape("%<enviarEtiquetaHpDirect>true%")).append(" as isGerarHPDirect");
            if (ParametrosGerais.getAgruparInterface() == 0) {
                buf.append("    ,(select array (select rcp.rec_codigo from recipcoleta rcp where req.fil_codigo = rcp.fil_codigo ");
                buf.append("\t\t and exa.exa_codigo = rcp.exa_codigo ");
                buf.append("\t\t and emc.mco_codigo = rcp.mco_codigo))::varchar[]  as recipiente ");
            } else {
                buf.append("    ,(select array (select rcp.rec_codigo from reciptriagem rcp where req.fil_codigo = rcp.fil_codigo ");
                buf.append("\t\t and exa.exa_codigo = rcp.exa_codigo ");
                buf.append("\t\t and emc.mco_codigo = rcp.mco_codigo))::varchar[]  as recipiente ");
            }
            buf.append("   from requisicao req ");
            buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
            buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
            buf.append("   join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
            buf.append("\t join examematcoleta emc on exr.fil_codigo = emc.fil_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
            buf.append("   join exames exa on emc.fil_codigo = exa.fil_codigo and emc.exa_codigo = exa.exa_codigo ");
            buf.append("   join materialcoleta mco on emc.fil_codigo = mco.fil_codigo and emc.mco_codigo = mco.mco_codigo ");
            buf.append("   join examematcoletalabexterno ele on emc.fil_codigo = ele.fil_codigo and emc.exa_codigo = ele.exa_codigo and emc.mco_codigo = ele.mco_codigo and ele.ele_padrao ");
            buf.append("   join labexterno lae on ele.fil_codigo = lae.fil_codigo and ele.lae_codigo = lae.lae_codigo ");
            buf.append("                       and lae.lae_protocolo = ").append(StringUtil.textoDBEscape(Protocolo.HPardini.getCodigo()));
            buf.append("   left join examerequisicaorecipiente exrc on exr.fil_codigo = exrc.fil_codigo and req.req_codigo = exrc.req_codigo and exa.exa_codigo = exrc.exa_codigo and emc.mco_codigo = exrc.mco_codigo ");
            buf.append("  where exr.fil_codigo = ").append(codigoFilial);
            buf.append("    and exr.req_codigo = ").append(codigoRequisicao);
            buf.append("    and not exr.exr_excluido ");
            buf.append("    and exr.exr_situacao  != '").append("F").append("'");
            buf.append("    and exr.exr_situacao  != '").append("A").append("'");
            buf.append("    and exr.exr_situacao  != '").append("C").append("'");
            buf.append("    and exr.exr_situacao  != '").append("I").append("'");
            buf.append("    and exr.exr_situacao  != '").append("L").append("'");
            buf.append("    and exr.exr_situacao  != '").append("E").append("'");
            if (!isAgendamento) {
                buf.append("    and exr.exr_datamaterial IS NOT NULL");
            }
            if (codigosExames != null && codigosMateriais != null && codigosExames.length > 0 && codigosMateriais.length > 0) {
                buf.append("  and (exr.exa_codigo, exr.mco_codigo) IN (");
                for (int i = 0; i < codigosExames.length; ++i) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    buf.append("(").append(StringUtil.textoDBEscape(codigosExames[i]));
                    buf.append(",").append(codigosMateriais[i]).append(")");
                }
                buf.append(" ) ");
            }
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block11;
                String xmlConfiguracao = rs.getString("xmlConfiguracao");
                boolean isEnviarRequisicaoWebService = StringUtil.getBoolean(xmlConfiguracao, "envioAutomatico");
                ListaExameMaterial<ExameMaterial> listaExameMaterial2 = new ListaExameMaterial<ExameMaterial>(rs.getString("nomePaciente"), rs.getInt("codigoConvenio"), rs.getString("fantasiaConvenio"), rs.getInt("codigoPaciente"), isEnviarRequisicaoWebService, rs.getString("dataNascimentoPaciente"), rs.getDate("dataColeta"), rs.getString("horaColeta"), rs.getString("dumPaciente"), rs.getString("sexoPaciente"), rs.getString("idade"), rs.getString("observacao"), rs.getString("peso"), rs.getString("alturaPaciente"));
                do {
                    xmlConfiguracao = rs.getString("xmlConfiguracao");
                    isEnviarRequisicaoWebService = StringUtil.getBoolean(xmlConfiguracao, "envioAutomatico");
                    String tagHPardini = StringUtil.getValor(xmlConfiguracao, "hpardini");
                    String tagTipoImpressao = StringUtil.getValor(tagHPardini, "tipoImpressao");
                    String tagModelo = StringUtil.getValor(tagHPardini, "modelo");
                    String tagModeloGrafico = StringUtil.getValor(tagModelo, "modeloGrafico");
                    String tagModeloDireto = StringUtil.getValor(tagModelo, "modeloTermico");
                    String tagCodigoProtocolo = StringUtil.getValor(tagHPardini, "codigoProtocolo");
                    isEnviarRequisicaoWebService = StringUtil.getBoolean(xmlConfiguracao, "envioAutomatico");
                    if (isEnviarRequisicaoWebService) {
                        listaExameMaterial2.setEnviarRequisicaoWebService(isEnviarRequisicaoWebService);
                        listaExameMaterial2.add(new ExameMaterial(rs.getString("codigoExame"), rs.getInt("codigoMaterial"), tagModelo, rs.getString("xmlExamePardini"), rs.getString("descricaoExame"), rs.getString("descricaoMaterial"), tagCodigoProtocolo, "T", rs.getString("codigoEtiquetaArmazenada"), rs.getInt("codigoLaboratorioExterno"), 1, rs.getArray("recipiente"), rs.getTimestamp("dataMaterial"), rs.getString("codigoApoiado"), rs.getString("tempoDiurese"), rs.getString("volumeDiurese"), rs.getString("codigoLabExterno"), rs.getString("materialInformado")));
                        continue;
                    }
                    if (!rs.getBoolean("isGerarHPDirect") || Funcoes.textoVazio(tagTipoImpressao) || Funcoes.textoVazio(tagModeloDireto) && Funcoes.textoVazio(tagModeloGrafico)) continue;
                    Array recipientes = rs.getArray("recipiente");
                    int qtdeEtiquetas = 1;
                    if (recipientes != null && recipientes.getArray() != null && recipientes.getArray() instanceof Object[] && ((Object[])recipientes.getArray()).length > 0) {
                        qtdeEtiquetas = ImprimirEtiquetasColetaTriagem.getQtdeEtiquetas(codigoFilial, rs.getString("codigoExame"), rs.getString("codigoMaterial"), ((Object[])recipientes.getArray())[0].toString(), tipoEtiqueta);
                    }
                    listaExameMaterial2.add(new ExameMaterial(rs.getString("codigoExame"), rs.getInt("codigoMaterial"), tagTipoImpressao.equalsIgnoreCase("C") ? tagModeloGrafico : tagModeloDireto, rs.getString("xmlExamePardini"), rs.getString("descricaoExame"), rs.getString("descricaoMaterial"), tagCodigoProtocolo, tagTipoImpressao, rs.getString("codigoEtiquetaArmazenada"), rs.getInt("codigoLaboratorioExterno"), qtdeEtiquetas, recipientes, null, null, null, null, rs.getString("codigoLabExterno"), rs.getString("materialInformado")));
                } while (rs.next());
                listaExameMaterial = listaExameMaterial2.size() > 0 ? listaExameMaterial2 : null;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return listaExameMaterial;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    private static boolean getEnviarEtiquetaLabExterno(String xml) {
        boolean retorno = false;
        if (!Funcoes.textoVazio(xml) && !(retorno = StringUtil.getBoolean(xml, "enviarTuboLis"))) {
            retorno = StringUtil.getBoolean(xml, "enviarEtiquetaApoio");
        }
        return retorno;
    }
}

