/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Map;

public class ImprimirEtiquetaLaudo {
    private static final int CAMPO_MAIOR_DATA = 1;
    private static final int CAMPO_MENOR_DATA = 2;

    public synchronized byte[] imprimir(String filial, String requisicao, Boolean isColetaWeb, Statement st, Statement st2, String impressoraLaudo, Integer codigoLayoutPadrao, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws SQLException, IOException {
        if (st == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer("");
        buf.append("select a.req_codigo as codigoRequisicao, a.req_data as dataRequisicao, a.req_dtfatura as dataFaturaRequisicao, a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,");
        buf.append("a.req_responsavel as responsavelPacienteRequisicao, a.req_cpfresponsavel as cpfResponsavelPacienteRequisicao, coalesce(a.req_incapacitado, false) as incapacitadoPacienteRequisicao,");
        buf.append("j.pac_responsavel as responsavelPaciente, j.pac_cpfresponsavel as cpfResponsavelPaciente, coalesce(j.pac_incapacitado, false) as incapacitadoPaciente,");
        buf.append("a.req_dclinicos as dadosClinicosRequisicao, a.req_obs as obsRequisicao, a.req_totpago as totalPagoRequisicao, a.req_horaentregaprev as horaEntregaRequisicao, a.req_total as totalRequisicao,");
        buf.append("a.req_horafatura as horaFaturaRequisicao, a.req_hora as horaRequisicao, a.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, a.req_idade as idadeRequisicao, a.req_anomes as anoMesRequisicao,");
        buf.append("a.req_matricula as matriculaRequisicao, a.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequisicao, a.req_titular as titularRequisicao, a.req_peso as pesoRequisicao,");
        buf.append("a.req_altura as alturaRequisicao, a.req_desconto as descontoRequisicao, a.req_vlrdesconto as valorDescontoRequisicao, a.req_notacaixa as notaCaixaRequisicao, ");
        buf.append("a.req_vlrexames as valorExamesRequisicao, a.req_vlrmateriais as valorMateriaisRequisicao, a.req_guia as guiaRequisicao, ");
        buf.append("a.req_acrescimo as acrescimoRequisicao, a.req_vlracrescimo as valorAcrescimoRequisicao, a.req_tipoultpagamento as tipoUltimoPagamentoRequisicao, ");
        buf.append("a.sit_codigo as codigoSituacao, g.sit_descricao as descricaoSituacao,");
        buf.append("a.usr_codigo as codigoUsuario, h.usr_nome as nomeUsuario, ");
        buf.append("o.cid_codigo as codigoCidadePaciente, o.cid_nome as descricaoCidadePaciente, o.cid_uf as estadoCidadePaciente,");
        buf.append("t.bai_codigo as codigoBairroPaciente, t.bai_descricao as descricaoBairroPaciente,");
        buf.append("a.des_codigo as codigoDestino, e.des_descricao as descricaoDestino, e.des_endereco as enderecoDestino, e.des_complemento as complementoDestino,e.des_cep as cepDestino, e.des_fone as foneDestino,");
        buf.append("a.col_codigo as codigoColeta, f.col_descricao as descricaoColeta, f.col_endereco as enderecoColeta, f.col_complemento as complementoColeta, f.col_cep as cepColeta, f.col_fone as foneColeta,");
        buf.append("a.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial,");
        buf.append("cidfilial.cid_codigo as codigoCidadeFilial, cidfilial.cid_nome as descricaoCidadeFilial, cidfilial.cid_uf as estadoCidadeFilial,");
        buf.append("baifilial.bai_codigo as codigoBairroFilial, baifilial.bai_descricao as descricaoBairroFilial,");
        buf.append("d.med_conselho as conselhoMedico, d.med_crm as crmMedico, d.med_uf as estadoCrmMedico, d.med_nome as nomeMedico, d.med_abrev as tratamentoMedico, d.med_endereco as enderecoMedico, d.med_numeroendereco as numeroEnderecoMedico, d.med_tipologradouroendereco as tipoLogradouroMedico,  d.med_complemento as complementoMedico, d.med_cep as cepMedico, d.med_fone as foneMedico, d.med_celular as celularMedico, d.med_fax as faxMedico, d.med_email as emailMedico, d.med_site as siteMedico,");
        buf.append("c.con_codigo as codigoConvenio, c.con_fantasia as fantasiaConvenio, c.con_razao as razaoSocialConvenio, c.con_endereco as enderecoConvenio, c.con_numeroendereco as numeroEnderecoConvenio, c.con_tipologradouroendereco as tipoLogradouroConvenio,  c.con_complemento as complementoConvenio, c.con_cep as cepConvenio, c.con_fone as foneConvenio, c.con_email1 as email1Convenio, c.con_email2 as email2Convenio, c.con_site as siteConvenio,");
        buf.append("j.pac_codigo as codigoPaciente, j.pac_nome as nomePaciente, j.pac_sexo as sexoPaciente, j.pac_datanasc as dataNascimentoPaciente, j.pac_grpsangue as grupoSanguineoPaciente, j.pac_fatorrh as fatorRHPaciente, j.pac_fatordu as fatorDUPaciente, j.pac_cor as corPaciente,");
        buf.append("j.pac_profissao as profissaoPaciente, j.pac_rg as rgPaciente, j.pac_cpf as cpfPaciente, j.pac_estcivil as estadoCivilPaciente, j.pac_dum as dumPaciente, j.pac_fone as fonePaciente, j.pac_celular as celularPaciente, j.pac_fax as faxPaciente, j.pac_fonecomercial as foneComercialPaciente,");
        buf.append("j.pac_endereco as enderecoPaciente, j.pac_numeroendereco as numeroEnderecoPaciente, j.pac_tipologradouroendereco as tipoLogradouroPaciente, j.pac_complemento as complementoPaciente, j.pac_cep as cepPaciente, j.pac_email as emailPaciente, j.pac_fonecontato as foneContatoPaciente, j.pac_nomecontato as contatoPaciente, ");
        buf.append("j.pac_senhaweb as senhaWebPaciente, null as dataPrimeiraColetaExameRequisicao, null as dataUltimaColetaExameRequisicao, null as datasColetasExameRequisicao, ");
        buf.append("current_timestamp as dataHoraCorrente, ");
        buf.append("'").append(Variaveis.filialPadrao).append("' as codigoFilialImpressao, ");
        buf.append("'").append(Variaveis.descricaoFilialPadrao).append("' as descricaoFilialImpressao, ");
        buf.append("'").append(Variaveis.login).append("' as usuarioLogado, ");
        buf.append("'").append(Variaveis.nomeUsuario).append("' as nomeUsuarioLogado ");
        buf.append(", a.req_periodogestacional as periodoGestacionalRequisicao ");
        buf.append(", a.req_perguntas as perguntasRequisicao ");
        buf.append("from requisicao a ");
        buf.append("left join convenios c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo ");
        buf.append("left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and upper(a.med_crm) = upper(d.med_crm) and a.med_uf = d.med_uf ");
        buf.append("left join destino e on a.fil_codigo = e.fil_codigo and upper(a.des_codigo) = upper(e.des_codigo) ");
        buf.append("left join coletas f on a.fil_codigo = f.fil_codigo and upper(a.col_codigo) = upper(f.col_codigo) ");
        buf.append("left join situacao g on a.fil_codigo = g.fil_codigo and a.sit_codigo = g.sit_codigo ");
        buf.append("left join usuario h on upper(a.usr_codigo) = upper(h.usr_codigo) ");
        buf.append("left join paciente j on a.fil_codigo = j.fil_codigo and a.pac_codigo = j.pac_codigo ");
        buf.append("left join cidades o on j.fil_codigo = o.fil_codigo and j.cid_codigo = o.cid_codigo ");
        buf.append("left join bairro t on j.fil_codigo = t.fil_codigo and j.bai_codigo = t.bai_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
        buf.append("left join cidades cidfilial on filial.fil_codigo = cidfilial.fil_codigo and filial.cid_codigo = cidfilial.cid_codigo ");
        buf.append("left join bairro baifilial on filial.fil_codigo = baifilial.fil_codigo and filial.bai_codigo = baifilial.bai_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo = ");
        buf.append(requisicao);
        buf.append(" and a.req_excluida = false ");
        ResultSet rs = st.executeQuery(buf.toString());
        String[] campos = Impressao.CAMPOS_ETQ_LAUDO;
        String[] perguntasFilial = RecepcaoUtil.getPerguntasFilial(filial, st2);
        if (perguntasFilial.length > 0) {
            campos = ArraysUtil.concatenar(campos, perguntasFilial);
        }
        ModeloGridTable modeloDados = new ModeloGridTable(campos);
        if (rs.next()) {
            modeloDados.addLine(new Object[campos.length]);
            String codigoConvenio = rs.getString("codigoConvenio");
            String codigoDestino = rs.getString("codigoDestino");
            for (int i = 1; i < Impressao.CAMPOS_ETQ_LAUDO.length; ++i) {
                if (RelatorioUtil.possuiColuna(rs, Impressao.CAMPOS_ETQ_LAUDO[i]) < 0) continue;
                if (Impressao.CAMPOS_ETQ_LAUDO[i].equalsIgnoreCase("sexoPaciente")) {
                    modeloDados.setValueAt(Tipos.tipoSexo(rs.getString(Impressao.CAMPOS_ETQ_LAUDO[i])), modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (Impressao.CAMPOS_ETQ_LAUDO[i].equalsIgnoreCase("tipoLogradouroPaciente") || Impressao.CAMPOS_ETQ_LAUDO[i].equalsIgnoreCase("tipoLogradouroConvenio") || Impressao.CAMPOS_ETQ_LAUDO[i].equalsIgnoreCase("tipoLogradouroMedico")) {
                    modeloDados.setValueAt(Tipos.tipoLogradouroDescricao(rs.getString(Impressao.CAMPOS_ETQ_LAUDO[i])), modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (Impressao.CAMPOS_ETQ_LAUDO[i].equalsIgnoreCase("corPaciente")) {
                    modeloDados.setValueAt(Tipos.tipoCor(rs.getString(Impressao.CAMPOS_ETQ_LAUDO[i])), modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (Impressao.CAMPOS_ETQ_LAUDO[i].equalsIgnoreCase("estadoCivilPaciente")) {
                    modeloDados.setValueAt(Tipos.tipoEstadoCivil(rs.getString(Impressao.CAMPOS_ETQ_LAUDO[i])), modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (Impressao.CAMPOS_ETQ_LAUDO[i].equalsIgnoreCase("dataPrimeiraColetaExameRequisicao")) {
                    modeloDados.setValueAt(ImprimirEtiquetaLaudo.getDataColetasMaxMin(rs.getString("codigoFilial"), rs.getString("codigoRequisicao"), 2, st2), modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (Impressao.CAMPOS_ETQ_LAUDO[i].equalsIgnoreCase("dataUltimaColetaExameRequisicao")) {
                    modeloDados.setValueAt(ImprimirEtiquetaLaudo.getDataColetasMaxMin(rs.getString("codigoFilial"), rs.getString("codigoRequisicao"), 1, st2), modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (Impressao.CAMPOS_ETQ_LAUDO[i].equalsIgnoreCase("datasColetasExameRequisicao")) {
                    modeloDados.setValueAt(ImprimirEtiquetaLaudo.getDataColetasLista(rs.getString("codigoFilial"), rs.getString("codigoRequisicao"), st2), modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (Impressao.CAMPOS_ETQ_LAUDO[i].equals("perguntasRequisicao")) {
                    if (Funcoes.textoVazio(rs.getString("perguntasRequisicao"))) continue;
                    Map<String, Object> respostasRequisicao = Resultado.getCamposResultado(rs.getString("perguntasRequisicao"));
                    for (Map.Entry<String, Object> resposta : respostasRequisicao.entrySet()) {
                        if (modeloDados.findColumn(resposta.getKey()) <= -1) continue;
                        modeloDados.setValueAt(resposta.getValue(), modeloDados.getRowCount() - 1, modeloDados.findColumn(resposta.getKey()));
                    }
                    continue;
                }
                modeloDados.setValueAt(rs.getObject(Impressao.CAMPOS_ETQ_LAUDO[i]), modeloDados.getRowCount() - 1, i);
            }
            String codigoLayout = ExameUtil.getCodigoLayout(filial, codigoConvenio, codigoDestino, st2, codigoLayoutPadrao);
            buf.delete(0, buf.length());
            buf.append("select ");
            buf.append("lay_etiquetalaudo");
            buf.append(", lay_tipoetiquetalaudo from layout where fil_codigo = ");
            buf.append(filial);
            buf.append(" and lay_codigo = ");
            buf.append(codigoLayout);
            ResultSet rsLayout = st.executeQuery(buf.toString());
            if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("lay_etiquetalaudo"))) {
                String tipo;
                String impressora = "";
                if (!isColetaWeb.booleanValue()) {
                    impressora = Impressao.comparaNomeImpressoraReduzido(impressoraLaudo);
                }
                if ((tipo = rsLayout.getString("lay_tipoetiquetalaudo")).equalsIgnoreCase("C")) {
                    Gerador gerador = new Gerador(casasPrecoExame, arredondamentoPrecoExame);
                    gerador.setImpressora(impressora);
                    String layComprovante = rsLayout.getString("lay_etiquetalaudo");
                    gerador.executar(layComprovante, modeloDados);
                    if (isColetaWeb.booleanValue()) {
                        return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), layComprovante);
                    }
                } else if (tipo.equalsIgnoreCase("T")) {
                    ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressoraLaudo), isColetaWeb);
                    termica.setDados(modeloDados);
                    termica.imprimir(rsLayout.getString("lay_etiquetalaudo"));
                }
            } else {
                Funcoes.mensagem(null, "Modelo da etiqueta de laudo n\u00e3o localizado ou n\u00e3o definido", 1);
            }
            rsLayout.close();
        }
        rs.close();
        return new byte[0];
    }

    public static Date getDataColetasMaxMin(String filial, String codigoRequisicao, int campoRetorno, Statement st) {
        StringBuilder buf = new StringBuilder();
        if (campoRetorno == 1) {
            buf.append(" select max(exr_datamaterial) as result ");
        } else if (campoRetorno == 2) {
            buf.append(" select min(exr_datamaterial) as result ");
        }
        buf.append("  from examerequisicao  ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append("   and req_codigo = ").append(codigoRequisicao);
        buf.append("   and not exr_excluido ");
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                if (Funcoes.textoVazio(rs.getString("result"))) {
                    return null;
                }
                return Funcoes.stringToDate(Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("result")));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    public static String getDataColetasLista(String filial, String codigoRequisicao, Statement st) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select distinct exr_datamaterial as result ");
        buf.append(" from examerequisicao  ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append("   and req_codigo = ").append(codigoRequisicao);
        buf.append("   and not exr_excluido ");
        buf.append(" order by exr_datamaterial ");
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            String retorno = "";
            while (rs.next()) {
                if (!Funcoes.textoVazio(retorno)) {
                    retorno = retorno + ", ";
                }
                retorno = retorno + Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp(1));
            }
            return retorno;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            return null;
        }
    }
}

