/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.impressao.termica.ImpressaoTermica;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ImprimirEtiquetaLamina {
    private static String getSelect() {
        StringBuilder buf = new StringBuilder();
        buf.append(" select a.req_codigo as codigoRequisicao ");
        buf.append("       ,a.exa_codigo as codigoExame ");
        buf.append("       ,a.mco_codigo as codigoMaterial ");
        buf.append("       ,erl.erl_identificador as identificacaoLaminaExame ");
        buf.append("       ,COALESCE(emc.emc_quantidadelaminas, 0) as quantidadeLaminas ");
        buf.append("       ,mco.mco_descricao as descricaoMaterial ");
        buf.append("       ,mco.mco_abreviatura as abreviaturaMaterial ");
        buf.append("       ,exa.exa_descricao as descricaoExame ");
        buf.append("       ,set.set_descricao as descricaoSetor ");
        buf.append("       ,set.set_sigla as siglaSetor ");
        buf.append("       ,ide.ide_codigo as codigoIdentificador ");
        buf.append("       ,ide.ide_descricao as descricaoIdentificador ");
        buf.append("       ,ide.ide_sigla as siglaIdentificador ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_razaosocial as razaoSocialPaciente ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,con.con_codigo as codigoConvenio ");
        buf.append("       ,con.con_razao as razaoSocialConvenio ");
        buf.append("       ,con.con_fantasia as fantasiaConvenio ");
        buf.append("       , ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append("   from examerequisicao a ");
        buf.append("   join requisicao req on a.fil_codigo = req.fil_codigo and a.req_codigo = req.req_codigo ");
        buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("   join examematcoleta emc on a.fil_codigo = emc.fil_codigo and a.exa_codigo = emc.exa_codigo and a.mco_codigo = emc.mco_codigo ");
        buf.append("   join materialcoleta mco on a.fil_codigo = mco.fil_codigo and a.mco_codigo = mco.mco_codigo ");
        buf.append("   join exames exa on a.fil_codigo = exa.fil_codigo and a.exa_codigo = exa.exa_codigo ");
        buf.append("   join examesetor ese on exa.fil_codigo = ese.fil_codigo and exa.exa_codigo = ese.exa_codigo ");
        buf.append("   join setores set on ese.fil_codigo = set.fil_codigo and ese.set_codigo = set.set_codigo ");
        buf.append("   join identificadorlamina ide on set.fil_codigo = ide.fil_codigo and set.ide_codigo = ide.ide_codigo ");
        buf.append("   join examerequisicaolaminas erl on a.fil_codigo = erl.fil_codigo and a.req_codigo = erl.req_codigo and a.exa_codigo = erl.exa_codigo and a.mco_codigo = erl.mco_codigo and set.set_codigo = erl.set_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        return buf.toString();
    }

    public static void imprimir(Integer filial, Integer requisicao) throws SQLException {
        StringBuilder buf = new StringBuilder(ImprimirEtiquetaLamina.getSelect());
        buf.append("  where a.fil_codigo = ").append(filial);
        buf.append("    and a.req_codigo = ").append(requisicao);
        if (ParametrosGerais.isOcultarApenasFaturamento()) {
            buf.append(" and a.exr_situacao <> 'A' ");
        }
        ImprimirEtiquetaLamina.imprimir(filial, buf.toString());
    }

    public static void imprimir(Integer filial, Integer requisicao, String exame, Integer material) throws SQLException {
        StringBuilder buf = new StringBuilder(ImprimirEtiquetaLamina.getSelect());
        buf.append("  where a.fil_codigo = ").append(filial);
        buf.append("    and a.req_codigo = ").append(requisicao);
        buf.append("    and a.exa_codigo = '").append(exame).append("' ");
        buf.append("    and a.mco_codigo = ").append(material);
        if (ParametrosGerais.isOcultarApenasFaturamento()) {
            buf.append(" and a.exr_situacao <> 'A' ");
        }
        ImprimirEtiquetaLamina.imprimir(filial, buf.toString());
    }

    private static void imprimir(Integer filial, String sql) throws SQLException {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        if (st == null || st2 == null) {
            return;
        }
        ResultSet rs = st.executeQuery(sql);
        ModeloGridTable modeloDados = null;
        ResultSet rsLayout = ImprimirEtiquetaLamina.getLayout(st2, filial);
        if (!rsLayout.next() || rsLayout.getObject("lay_etiquetalamina") == null || Funcoes.textoVazio(rsLayout.getString("lay_etiquetalamina"))) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
        } else {
            while (rs.next()) {
                int i;
                modeloDados = new ModeloGridTable(Impressao.CAMPOS_ETIQUETA_LAMINA);
                modeloDados.addLine(new Object[Impressao.CAMPOS_ETIQUETA_LAMINA.length]);
                for (int i2 = 0; i2 < Impressao.CAMPOS_ETIQUETA_LAMINA.length; ++i2) {
                    modeloDados.setValueAt(rs.getObject(Impressao.CAMPOS_ETIQUETA_LAMINA[i2]), modeloDados.getRowCount() - 1, i2);
                }
                String tipo = rsLayout.getString("lay_tipoetiquetalamina");
                if (tipo.equalsIgnoreCase("C")) {
                    for (i = 0; i < rs.getInt("quantidadeLaminas"); ++i) {
                        Gerador gerador = new Gerador(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraEtiquetaLamina")));
                        gerador.executar(rsLayout.getString("lay_etiquetalamina"), modeloDados);
                    }
                    continue;
                }
                if (!tipo.equalsIgnoreCase("T")) continue;
                for (i = 0; i < rs.getInt("quantidadeLaminas"); ++i) {
                    ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraEtiquetaLamina")), false);
                    termica.setDados(modeloDados);
                    termica.imprimir(rsLayout.getString("lay_etiquetalamina"));
                }
            }
        }
        if (rs != null) {
            rs.close();
        }
        if (rsLayout != null) {
            rsLayout.close();
        }
        st.close();
        st2.close();
    }

    private static ResultSet getLayout(Statement st, Integer filial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select lay_etiquetalamina ");
        buf.append("       ,lay_tipoetiquetalamina ");
        buf.append("   from layout ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and lay_codigo = ").append(String.valueOf(ParametrosGerais.getLayCodigo()));
        return Conexao.executeQuery(st, buf.toString());
    }
}

