/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.estoque.almoxarifado.EtiquetaEstoque;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.impressao.termica.ImpressaoTermica;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;

public class ImprimirEtiquetaEstoque {
    private String getSelect(EtiquetaEstoque.ObjetoTabela objetoTabela) {
        StringBuilder buf = new StringBuilder();
        buf.append("select a.nfi_numero as numeroNotaFiscal,  a.nfi_codigo as codigoNotaFiscal, a.nfi_tipocadastro as tipoCadastroNotaFiscal, a.nfi_datahora as datahoraNotaFiscal, ");
        buf.append("a.nfi_dataemissao as dataEmissaoNotaFiscal, a.nfi_situacao as situacaoNotaFiscal, a.nfi_datahoraimpressao as dataHoraImpressaoNotaFiscal, ");
        buf.append("a.nfi_observacao as observacaoNotaFiscal, a.nfi_valortotal as valorTotalNotaFiscal, COALESCE(a.nfi_tipo, '").append("E").append("') as tipoNotaFiscal, ");
        buf.append("a.nfi_subtotal as subTotalNotaFiscal, '' as faturasNotaFiscal, ");
        buf.append("a.nfi_datahoracancelada as dataHoraCanceladoNotaFiscal, ");
        buf.append("a.nfi_irrfvalor as valorIRRFNotaFiscal, a.nfi_irrfpercentual as percentualIRRFNotaFiscal, ");
        buf.append("a.nfi_issvalor as valorISSNotaFiscal, a.nfi_isspercentual as percentualISSNotaFiscal, ");
        buf.append("a.nfi_pisvalor as valorPISNotaFiscal, a.nfi_pispercentual as percentualPISNotaFiscal, ");
        buf.append("a.nfi_csllvalor as valorCSLLNotaFiscal, a.nfi_csllpercentual as percentualCSLLNotaFiscal, ");
        buf.append("a.nfi_cofinsvalor as valorCOFINSNotaFiscal, a.nfi_cofinspercentual as percentualCOFINSNotaFiscal, ");
        buf.append("a.nfi_inssvalor as valorINSSNotaFiscal, a.nfi_insspercentual as percentualINSSNotaFiscal, ");
        buf.append("a.ser_codigo as codigoSerie, serie.ser_descricao as descricaoSerie, ");
        buf.append("a.fpg_codigo as codigoFormaPagamento, forma.fpg_descricao as descricaoFormaPagamento, ");
        buf.append("a.usr_codigo as codigoUsuarioNotaFiscal, usuario.usr_nome as nomeUsuarioNotaFiscal, ");
        buf.append("a.usr_codimpressao as codigoUsuarioImpressaoNotaFiscal, usuarioimpressao.usr_nome as nomeUsuarioImpressaoNotaFiscal, ");
        buf.append("a.usr_codcancelada as codigoUsuarioCanceladoNotaFiscal, usuariocancelado.usr_nome as nomeUsuarioCanceladoNotaFiscal, ");
        buf.append("null as datasVencimentoNotaFiscal, null as datasVencimentoFatura,");
        buf.append("a.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, ");
        buf.append("filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, ");
        buf.append("filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, ");
        buf.append("filial.fil_razaosocial as razaoSocialFilial, ");
        buf.append("a.nfi_nomepagador as nomePagador, a.nfi_cpfpagador as cpfPagador, ");
        buf.append("0 as quantidadeRequisicoesFaturas, 0 as quantidadeExamesFaturas, null as menorDataPeriodoFiltroFaturas, null as maiorDataPeriodoFiltroFaturas, ");
        buf.append("cidfilial.cid_codigo as codigoCidadeFilial, cidfilial.cid_nome as descricaoCidadeFilial, cidfilial.cid_uf as estadoCidadeFilial, ");
        buf.append("baifilial.bai_codigo as codigoBairroFilial, baifilial.bai_descricao as descricaoBairroFilial, ");
        buf.append("b.svc_codigo as codigoServicoNotaFiscal, b.nfs_valor as valorServicoNotaFiscal, servico.svc_descricao as descricaoServicoNotaFiscal, ");
        buf.append("'").append(Variaveis.login).append("' as usuarioLogado, '").append(Variaveis.nomeUsuario).append("' as nomeUsuarioLogado, ");
        buf.append("'").append(objetoTabela.getLote()).append("' as loteMaterial, '").append(Funcoes.formataData("dd/MM/yyyy", objetoTabela.getDataLote())).append("' as dataLoteMaterial, '").append(Funcoes.formataData("dd/MM/yyyy", objetoTabela.getValidadeLote())).append("' as validadeLoteMaterial, ");
        buf.append("case ");
        buf.append("  when a.nfi_tipocadastro = '").append("O").append("' then a.con_codigo ");
        buf.append("  when a.nfi_tipocadastro = '").append("P").append("' then a.pac_codigo ");
        buf.append("  else a.ent_codigo ");
        buf.append("end as codigoCadastro, ");
        buf.append("'' as fantasiaCadastro, '' as razaoSocialCadastro, '' as foneCadastro, ");
        buf.append("'' as enderecoCadastro, '' as faxCadastro, '' as complementoCadastro, '' as cepCadastro, ");
        buf.append("'' as cnpjCpfCadastro, '' as ieRgCadastro, ");
        buf.append("'' as codigoCidadeCadastro, '' as nomeCidadeCadastro, '' as estadoCidadeCadastro, ");
        buf.append("'' as codigoBairroCadastro, '' as descricaoBairroCadastro ");
        buf.append(", m.mat_codigo as codigoMaterial, m.mat_descricao as descricaoMaterial ");
        buf.append(", m.unm_codigo as unidadeMaterial, m.mat_observacao as observacaoMaterial ");
        buf.append(", m.mat_modelo as materialModelo, m.mat_marca as marcaMaterial ");
        buf.append(", m.mat_dataultentrega as ultimaEntregaMaterial, m.mat_dataultcompra as ultimaCompraMaterial ");
        buf.append(", m.mat_valorultcompra as valorUltimaCompra, tpm.tpm_codigo as codigoTipoMaterial ");
        buf.append(", tpm.tpm_descricao as tipoMaterialDescricao  ");
        buf.append(", p.ped_codigo as codigoPedido, p.ped_datahora as dataHoraPedido ");
        buf.append(", p.ped_observacao as observacaoPedido, p.ped_dataautorizacao as dataAutorizacaoPedido ");
        buf.append(", p.ped_total as totalPedido, p.ped_nomevendedor as vendedorPedido ");
        buf.append(", p.ped_valorfrete as valorFretePedido, pma.pma_valorunitario as valorUnitarioMaterialPedido ");
        buf.append(", pma.pma_total as totalMaterialPedido, pma.pma_valordesconto as valorDescontoMaterialPedido ");
        buf.append(", ent.ent_codigo as codigoEntidade, ent.ent_razaosocial as razaoSocialEntidade ");
        buf.append(", ent.ent_fantasia as fantasiaEntidade, ent.ent_cpfcnpj as cpfCnpjEntidade ");
        buf.append(", ent.ent_endereco as enderecoEntidade, ent.ent_complemento as complementoEnderecoEntidade ");
        buf.append(", ent.ent_cep as cepEntidade, ent.ent_fone as telefoneEntidade ");
        buf.append(", ent.ent_fax as fazEntidade, ent.ent_celular as celularEntidade ");
        buf.append(", ent.ent_email as emailEntidade, ent.ent_nomecontato as contatoEntidade ");
        buf.append(", ent.ent_fonecontato as contatoFoneEntidade, ent.ent_numeroendereco as numeroEnderecoEntidade, ");
        buf.append("         current_timestamp as dataHoraCorrente, ");
        buf.append(Variaveis.filialPadrao).append(" as codigoFilialImpressao, ");
        buf.append("'").append(Variaveis.descricaoFilialPadrao).append("' as descricaoFilialImpressao ");
        buf.append("from notafiscal a ");
        buf.append("left join notafiscalservico b on a.fil_codigo = b.fil_codigo and a.nfi_codigo = b.nfi_codigo ");
        buf.append("left join notafiscalmaterial nfm on  nfm.nfi_codigo = a.nfi_codigo and nfm.fil_codigo = a.fil_codigo ");
        buf.append("left join material m on m.mat_codigo = nfm.mat_codigo and m.fil_codigo = a.fil_codigo ");
        buf.append("left join tipomaterial tpm on tpm.tpm_codigo = m.tpm_codigo and tpm.fil_codigo = m.fil_codigo ");
        buf.append("left join pedido p on p.ped_codigo = a.ped_codigo and p.fil_codigo = a.fil_codigo ");
        buf.append("left join pedidomaterial pma on pma.ped_codigo = p.ped_codigo and pma.fil_codigo = p.fil_codigo ");
        buf.append("left join entidade ent on (ent.ent_codigo = p.ent_codigo and ent.fil_codigo = a.fil_codigo) ");
        buf.append("  or (ent.ent_codigo = a.ent_codigo and ent.fil_codigo = a.fil_codigo) ");
        buf.append("left join servico servico on b.fil_codigo = servico.fil_codigo and b.svc_codigo = servico.svc_codigo ");
        buf.append("left join series serie on a.fil_codigo = serie.fil_codigo and a.ser_codigo = serie.ser_codigo ");
        buf.append("left join formapagto forma on a.fil_codigo = forma.fil_codigo and a.fpg_codigo = forma.fpg_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
        buf.append("left join cidades cidfilial on filial.fil_codigo = cidfilial.fil_codigo and filial.cid_codigo = cidfilial.cid_codigo ");
        buf.append("left join bairro baifilial on filial.fil_codigo = baifilial.fil_codigo and filial.bai_codigo = baifilial.bai_codigo ");
        buf.append("left join usuario usuario on a.usr_codigo = usuario.usr_codigo ");
        buf.append("left join usuario usuarioimpressao on a.usr_codimpressao = usuarioimpressao.usr_codigo ");
        buf.append("left join usuario usuariocancelado on a.usr_codcancelada = usuariocancelado.usr_codigo ");
        buf.append("where ");
        if (objetoTabela.getNotaFiscalBean() != null) {
            buf.append(" ((a.nfi_codigo = ").append(objetoTabela.getNotaFiscalBean().getCodigo()).append(" ) ");
        } else {
            buf.append(" ((a.nfi_codigo = null )");
        }
        buf.append(" or ");
        if (objetoTabela.getPedidoBean() != null) {
            buf.append(" (p.ped_codigo = ").append(objetoTabela.getPedidoBean().getCodigo()).append(" )) ");
        } else {
            buf.append(" (p.ped_codigo = null )) ");
        }
        buf.append(" and m.mat_codigo = ");
        buf.append(objetoTabela.getMaterialVO().getCodigo());
        buf.append(" and a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" order by a.nfi_codigo desc, p.ped_codigo desc");
        return buf.toString();
    }

    public void imprimir(List<EtiquetaEstoque.ObjetoTabela> objetoTabelas) throws SQLException {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        ResultSet rs = null;
        if (st == null || st2 == null) {
            return;
        }
        HashSet<Integer> materialImpresso = new HashSet<Integer>();
        ResultSet rsLayout = this.getLayout(st2, Variaveis.filialPadrao);
        if (rsLayout != null && !rsLayout.next() || rsLayout.getString("lay_etiquetaestoque") == null || Funcoes.textoVazio(rsLayout.getString("lay_etiquetaestoque"))) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Modelo n\u00e3o localizado ou n\u00e3o definido.", 2);
            return;
        }
        for (EtiquetaEstoque.ObjetoTabela objetoTabela : objetoTabelas) {
            if (objetoTabela.getModeloDadosPreenchido() != null) {
                int i;
                String layout;
                String tipo = rsLayout.getString("lay_tipoetiquetaestoque");
                if (tipo.equalsIgnoreCase("C")) {
                    layout = rsLayout.getString("lay_etiquetaestoque");
                    if (layout == null) continue;
                    i = 0;
                    while ((double)i < objetoTabela.getQuantidade()) {
                        Gerador gerador = new Gerador(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraEtiquetaEstoque")));
                        gerador.executar(rsLayout.getString("lay_etiquetaestoque"), objetoTabela.getModeloDadosPreenchido());
                        ++i;
                    }
                    continue;
                }
                if (!tipo.equalsIgnoreCase("T") || (layout = rsLayout.getString("lay_etiquetaestoque")) == null) continue;
                i = 0;
                while ((double)i < objetoTabela.getQuantidade()) {
                    ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraEtiquetaEstoque")), false);
                    termica.setDados(objetoTabela.getModeloDadosPreenchido());
                    termica.imprimir(rsLayout.getString("lay_etiquetaestoque"));
                    ++i;
                }
                continue;
            }
            rs = !objetoTabela.getTipo().equals(objetoTabela.getTipoManual()) ? st.executeQuery(this.getSelect(objetoTabela)) : st.executeQuery(this.getSelectManual(objetoTabela));
            ModeloGridTable modeloDados = null;
            while (rs.next()) {
                if (!materialImpresso.contains(rs.getInt("codigoMaterial"))) {
                    int i;
                    String layout;
                    modeloDados = new ModeloGridTable(Impressao.CAMPOS_ETIQUETA_ESTOQUE);
                    modeloDados.addLine(new Object[Impressao.CAMPOS_ETIQUETA_ESTOQUE.length]);
                    for (int i2 = 0; i2 < Impressao.CAMPOS_ETIQUETA_ESTOQUE.length; ++i2) {
                        modeloDados.setValueAt(rs.getObject(Impressao.CAMPOS_ETIQUETA_ESTOQUE[i2]), modeloDados.getRowCount() - 1, i2);
                    }
                    String tipo = rsLayout.getString("lay_tipoetiquetaestoque");
                    if (tipo.equalsIgnoreCase("C")) {
                        layout = rsLayout.getString("lay_etiquetaestoque");
                        if (layout != null) {
                            i = 0;
                            while ((double)i < objetoTabela.getQuantidade()) {
                                Gerador gerador = new Gerador(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                                gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraEtiquetaEstoque")));
                                gerador.executar(rsLayout.getString("lay_etiquetaestoque"), modeloDados);
                                ++i;
                            }
                        }
                    } else if (tipo.equalsIgnoreCase("T") && (layout = rsLayout.getString("lay_etiquetaestoque")) != null) {
                        i = 0;
                        while ((double)i < objetoTabela.getQuantidade()) {
                            ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraEtiquetaEstoque")), false);
                            termica.setDados(modeloDados);
                            termica.imprimir(rsLayout.getString("lay_etiquetaestoque"));
                            ++i;
                        }
                    }
                    materialImpresso.add(rs.getInt("codigoMaterial"));
                }
                materialImpresso.add(rs.getInt("codigoMaterial"));
            }
        }
        if (rs != null) {
            rs.close();
        }
        if (rsLayout != null) {
            rsLayout.close();
        }
        if (st != null) {
            st.close();
        }
        if (st2 != null) {
            st2.close();
        }
    }

    private String getSelectManual(EtiquetaEstoque.ObjetoTabela objetoTabela) {
        StringBuilder buf = new StringBuilder();
        buf.append(" SELECT '' AS numeroNotaFiscal,                                ");
        buf.append(" '' AS codigoNotaFiscal,                                       ");
        buf.append(" '' AS tipoCadastroNotaFiscal,                                 ");
        buf.append(" '' AS datahoraNotaFiscal,                                     ");
        buf.append(" '' AS dataEmissaoNotaFiscal,                                  ");
        buf.append(" '' AS situacaoNotaFiscal,                                     ");
        buf.append(" '' AS dataHoraImpressaoNotaFiscal,                            ");
        buf.append(" '' AS observacaoNotaFiscal,                                   ");
        buf.append(" '' AS valorTotalNotaFiscal,                                   ");
        buf.append(" '' AS tipoNotaFiscal,                                         ");
        buf.append(" '' AS subTotalNotaFiscal,                                     ");
        buf.append(" '' AS faturasNotaFiscal,                                      ");
        buf.append(" '' AS dataHoraCanceladoNotaFiscal,                            ");
        buf.append(" '' AS valorIRRFNotaFiscal,                                    ");
        buf.append(" '' AS percentualIRRFNotaFiscal,                               ");
        buf.append(" '' AS valorISSNotaFiscal,                                     ");
        buf.append(" '' AS percentualISSNotaFiscal,                                ");
        buf.append(" '' AS valorPISNotaFiscal,                                     ");
        buf.append(" '' AS percentualPISNotaFiscal,                                ");
        buf.append(" '' AS valorCSLLNotaFiscal,                                    ");
        buf.append(" '' AS percentualCSLLNotaFiscal,                               ");
        buf.append(" '' AS valorCOFINSNotaFiscal,                                  ");
        buf.append(" '' AS percentualCOFINSNotaFiscal,                             ");
        buf.append(" '' AS valorINSSNotaFiscal,                                    ");
        buf.append(" '' AS percentualINSSNotaFiscal,                               ");
        buf.append(" '' AS codigoSerie,                                            ");
        buf.append(" '' AS descricaoSerie,                                         ");
        buf.append(" '' AS codigoFormaPagamento,                                   ");
        buf.append(" '' AS descricaoFormaPagamento,                                ");
        buf.append(" '' AS codigoUsuarioNotaFiscal,                                ");
        buf.append(" '' AS nomeUsuarioNotaFiscal,                                  ");
        buf.append(" '' AS codigoUsuarioImpressaoNotaFiscal,                       ");
        buf.append(" '' AS nomeUsuarioImpressaoNotaFiscal,                         ");
        buf.append(" '' AS codigoUsuarioCanceladoNotaFiscal,                       ");
        buf.append(" '' AS nomeUsuarioCanceladoNotaFiscal,                         ");
        buf.append(" NULL AS datasVencimentoNotaFiscal,                            ");
        buf.append("'").append(Variaveis.login).append("' as usuarioLogado, '").append(Variaveis.nomeUsuario).append("' as nomeUsuarioLogado, ");
        buf.append("'").append(objetoTabela.getLote()).append("' as loteMaterial, '").append(Funcoes.formataData("dd/MM/yyyy", objetoTabela.getDataLote())).append("' as dataLoteMaterial, '").append(Funcoes.formataData("dd/MM/yyyy", objetoTabela.getValidadeLote())).append("' as validadeLoteMaterial, ");
        buf.append("   NULL AS datasVencimentoFatura,                              ");
        buf.append("      a.fil_codigo AS codigoFilial,                            ");
        buf.append("      filial.fil_descricao AS descricaoFilial,                 ");
        buf.append("      filial.fil_cnpj AS cnpjFilial,                           ");
        buf.append("      filial.fil_endereco AS enderecoFilial,                   ");
        buf.append("      filial.fil_complemento AS complementoFilial,             ");
        buf.append("      filial.fil_cep AS cepFilial,                             ");
        buf.append("      filial.fil_fone AS foneFilial,                           ");
        buf.append("      filial.fil_fax AS faxFilial,                             ");
        buf.append("      filial.fil_razaosocial AS razaoSocialFilial,             ");
        buf.append("      '' AS nomePagador,                                       ");
        buf.append("      '' AS cpfPagador,                                        ");
        buf.append("      0 AS quantidadeRequisicoesFaturas,                       ");
        buf.append("      0 AS quantidadeExamesFaturas,                            ");
        buf.append("      NULL AS menorDataPeriodoFiltroFaturas,                   ");
        buf.append("        NULL AS maiorDataPeriodoFiltroFaturas,                 ");
        buf.append(" \t       cidfilial.cid_codigo AS codigoCidadeFilial,           ");
        buf.append(" \t       cidfilial.cid_nome AS descricaoCidadeFilial,          ");
        buf.append(" \t       cidfilial.cid_uf AS estadoCidadeFilial,               ");
        buf.append(" \t       baifilial.bai_codigo AS codigoBairroFilial,           ");
        buf.append(" \t       baifilial.bai_descricao AS descricaoBairroFilial,     ");
        buf.append(" \t       '' AS codigoServicoNotaFiscal,                        ");
        buf.append(" \t       '' AS valorServicoNotaFiscal,                         ");
        buf.append(" \t       '' AS descricaoServicoNotaFiscal,                     ");
        buf.append(" \t       '' AS codigoCadastro,                                 ");
        buf.append(" \t       '' AS fantasiaCadastro,                               ");
        buf.append(" \t       '' AS razaoSocialCadastro,                            ");
        buf.append(" \t       '' AS foneCadastro,                                   ");
        buf.append(" \t       '' AS enderecoCadastro,                               ");
        buf.append(" \t       '' AS faxCadastro,                                    ");
        buf.append(" \t       '' AS complementoCadastro,                            ");
        buf.append(" \t       '' AS cepCadastro,                                    ");
        buf.append(" \t       '' AS cnpjCpfCadastro,                                ");
        buf.append(" \t       '' AS ieRgCadastro,                                   ");
        buf.append(" \t       '' AS codigoCidadeCadastro,                           ");
        buf.append(" \t       '' AS nomeCidadeCadastro,                             ");
        buf.append(" \t       '' AS estadoCidadeCadastro,                           ");
        buf.append(" \t       '' AS codigoBairroCadastro,                           ");
        buf.append(" \t       '' AS descricaoBairroCadastro ,                       ");
        buf.append(" \t       a.mat_codigo AS codigoMaterial,                       ");
        buf.append(" \t       a.mat_descricao AS descricaoMaterial ,                ");
        buf.append(" \t       a.unm_codigo AS unidadeMaterial,                      ");
        buf.append(" \t       a.mat_observacao AS observacaoMaterial ,              ");
        buf.append(" \t       a.mat_modelo AS materialModelo,                       ");
        buf.append(" \t       a.mat_marca AS marcaMaterial ,                        ");
        buf.append(" \t       a.mat_dataultentrega AS ultimaEntregaMaterial,        ");
        buf.append(" \t       a.mat_dataultcompra AS ultimaCompraMaterial ,         ");
        buf.append(" \t       a.mat_valorultcompra AS valorUltimaCompra,    ");
        buf.append(" \t       tpm.tpm_codigo AS codigoTipoMaterial ,                ");
        buf.append(" \t       tpm.tpm_descricao AS tipoMaterialDescricao ,          ");
        buf.append(" \t       '' AS codigoPedido,                                   ");
        buf.append(" \t       '' AS dataHoraPedido ,                                ");
        buf.append(" \t       '' AS observacaoPedido,                               ");
        buf.append(" \t       '' AS dataAutorizacaoPedido ,                         ");
        buf.append(" \t       '' AS totalPedido,                                    ");
        buf.append(" \t       '' AS vendedorPedido ,                                ");
        buf.append(" \t       '' AS valorFretePedido,                               ");
        buf.append(" \t       '' AS valorUnitarioMaterialPedido ,                   ");
        buf.append(" \t       '' AS totalMaterialPedido,                            ");
        buf.append(" \t       '' AS valorDescontoMaterialPedido,                    ");
        buf.append(" \t       '' AS codigoEntidade,                                 ");
        buf.append(" \t       '' AS razaoSocialEntidade,                            ");
        buf.append(" \t       '' AS fantasiaEntidade,                               ");
        buf.append(" \t       '' AS cpfCnpjEntidade,                                ");
        buf.append(" \t       '' AS enderecoEntidade,                               ");
        buf.append(" \t       '' AS complementoEnderecoEntidade,                    ");
        buf.append(" \t       '' AS cepEntidade,                                    ");
        buf.append(" \t       '' AS telefoneEntidade,                               ");
        buf.append(" \t       '' AS fazEntidade,                                    ");
        buf.append(" \t       '' AS celularEntidade,                                ");
        buf.append(" \t       '' AS emailEntidade,                                  ");
        buf.append(" \t       '' AS contatoEntidade,                                ");
        buf.append(" \t       '' AS contatoFoneEntidade,                            ");
        buf.append(" \t       '' AS numeroEnderecoEntidade,                         ");
        buf.append(" \t       '' AS loteMaterial,\t\t\t\t                     ");
        buf.append("           '' AS validadeLoteMaterial,                            ");
        buf.append("         current_timestamp as dataHoraCorrente, ");
        buf.append(Variaveis.filialPadrao).append(" as codigoFilialImpressao, ");
        buf.append("'").append(Variaveis.descricaoFilialPadrao).append("' as descricaoFilialImpressao ");
        buf.append(" FROM material a                                                               ");
        buf.append(" \t\t\tLEFT JOIN tipomaterial tpm ON tpm.tpm_codigo = a.tpm_codigo              ");
        buf.append(" \t\t\t\t\t AND tpm.fil_codigo = a.fil_codigo                                   ");
        buf.append(" \t\t\tLEFT JOIN filiais_postocoleta filial ON a.fil_codigo = filial.fil_codigo ");
        buf.append(" \t\t\tLEFT JOIN cidades cidfilial ON filial.fil_codigo = cidfilial.fil_codigo  ");
        buf.append(" \t\t\t     AND filial.cid_codigo = cidfilial.cid_codigo                        ");
        buf.append(" \t\t\tLEFT JOIN bairro baifilial ON filial.fil_codigo = baifilial.fil_codigo   ");
        buf.append(" \t\t\t\t\t AND filial.bai_codigo = baifilial.bai_codigo                        ");
        buf.append(" WHERE a.mat_codigo = ").append(objetoTabela.getMaterialVO().getCodigo());
        buf.append(" \t\t\t\t   AND a.fil_codigo = ").append(Variaveis.filialPadrao);
        return buf.toString();
    }

    private ResultSet getLayout(Statement st, String filial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select lay_etiquetaestoque ");
        buf.append("       ,lay_tipoetiquetaestoque ");
        buf.append("   from layout ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and lay_codigo = ").append(String.valueOf(ParametrosGerais.getLayCodigo()));
        return Conexao.executeQuery(st, buf.toString());
    }
}

