/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.relatorio.Gerador;
import jalis.service.impressao.ImprimirComprovanteService;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.impressao.matricial.ImpressaoRelatorio;
import jalis.util.impressao.matricial.Relatorio;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.postgresql.util.PGInterval;

public class ImprimirComprovante {
    private static final int RODAPE_COLUNA_CODIGO = 0;
    private static final int RODAPE_COLUNA_EXAME = 1;
    private static final int RODAPE_COLUNA_CODIGO_MATERIAL = 2;
    private static final int RODAPE_COLUNA_DESCRICAO_MATERIAL = 3;
    private static final int RODAPE_COLUNA_ABREVIATURA = 4;
    private static final int RODAPE_COLUNA_VOLUME = 6;
    private static final int RODAPE_COLUNA_CAPACIDADE = 7;
    private static final int RODAPE_COLUNA_REQUISICAO_TUBO = 8;
    private static final int RODAPE_COLUNA_PACIENTE = 9;
    private static final int RODAPE_COLUNA_RECIPIENTE = 10;
    private static final int RODAPE_COLUNA_ESTACAO = 11;
    private static final int RODAPE_COLUNA_SETOR = 12;
    private static final int QUANTIDADE_AGENDAMENTOS = 10;
    private static final int RODAPE_COLUNA_PACIENTE_NOME_SOCIAL = 13;
    private static String[] ADICIONAIS_COMPROVANTE = new String[]{"descricaoExameSemAcento", "codigoExame", "descricaoExame", "ambExame", "chExame", "valorExame", "valorMateriaisExame", "tempoJejumExame", "descricaoMaterial", "codigoMaterial", "abreviaturaMaterial", "dataColetaExame", "horaColetaExame", "usuarioColetaExame", "descricaoPrazo", "codigoPrazo", "codigoMetodo", "situacaoExame", "descricaoSituacaoExame", "descricaoMetodo", "materialInformadoExame", "dataEntregaExame", "horaEntregaExame", "valorCH", "autorizacaoExame", "observacaoPrazoCarenciaExame", "valorExameConvenio", "codigoSetorExame", "custoCBHPMExame", "ucoCBHPMExame", "valorPorteCBHPMExame", "porteCHBPMExame", "materialExternoExame", "descricaoSetorExame", "abreviaturaSetorExame", "soaExame", "coaExame", "urgenteExame", "certificadoInmetroExame"};
    private static final String[] ADICIONAIS_RODAPE_COMPROVANTE = new String[]{"codigoTuboRodape", "codigosExamesRodape", "codigoMaterialRodape", "nomePacienteRodape", "descricaoMaterialRodape", "abreviaturaMaterialRodape", "codigoRequisicaoRodape", "descricaoRecipienteRodape", "descricaoEstacaoRodape", "nomeSocialPacienteRodape"};
    private static final String[] CAMPOS_AGENDAMENTO = new String[]{"codigoAgendamento", "dataHoraAgendamento", "situacaoAgendamento", "observacaoAgendamento", "codigoSalaAtendimento", "descricaoSalaAtendimento"};
    private static int QTDE_CAMPOS_COMPROVANTE = ADICIONAIS_COMPROVANTE.length;
    private static final int QTDE_CAMPOS_RODAPE_COMPROVANTE = ADICIONAIS_RODAPE_COMPROVANTE.length;
    private BigDecimal acrescimoRequisicao = new BigDecimal(0);
    private BigDecimal descontoRequisicao = new BigDecimal(0);
    private BigDecimal totalRequisicaoProposta = new BigDecimal(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void imprimir(String filial, String requisicao) throws SQLException, IOException {
        ImprimirComprovante comprovante = new ImprimirComprovante();
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        Statement st3 = Conexao.getStatement();
        try {
            String baseWeb = Variaveis.codigoBaseWeb;
            if (!filial.equals(Variaveis.filialPadrao)) {
                baseWeb = ImprimirComprovante.buscaBaseWeb(st3, filial);
            }
            comprovante.imprimir(filial, requisicao, false, Conexao.getStatement(), Conexao.getStatement(), Conexao.getStatement(), Conexao.getStatement(), Conexao.getStatement(), ImprimirComprovante.isAlimentos(), ParametrosGerais.getOrdemComprovante(), ParametrosGerais.getOrdenarSetor(), ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame().ordinal(), ParametrosGerais.getPrecoMetodologia(), ParametrosGerais.getQtdeExamesCC(), ParametrosGerais.getColunasRodapeComprovante(), baseWeb, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboTubo(), ParametrosGerais.getLayCodigo(), ParametrosLocais.getParametro("impressoraComprovante"), ParametrosLocais.getParametro("tamanhoNomeImpressoras"), Funcoes.getNomeImpressorasLocais(), ParametrosGerais.isAgruparGuiasInterface(), ParametrosGerais.getAgruparInterface(), ParametrosGerais.getTipoIntegracao(), ParametrosGerais.getArredondamentoPrecoExame(), ParametrosGerais.getTipoExportacaoInterface(), ParametrosGerais.getTuboPrimario(), ParametrosLocais.getParametro("gerarEtiquetasComprovanteColeta"), ParametrosGerais.isOcultarApenasFaturamento());
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st, st2, st3);
            throw throwable;
        }
        Conexao.fecharStatement(st, st2, st3);
    }

    private static synchronized String buscaBaseWeb(Statement st, String filial) throws SQLException {
        String retorno = "";
        StringBuilder buf = new StringBuilder();
        buf.append("select fil_baseweb from filiais_postocoleta where fil_codigo = ").append(filial);
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next() && !Funcoes.textoVazio(rs.getString("fil_baseweb"))) {
            retorno = rs.getString("fil_baseweb");
        }
        if (Funcoes.textoVazio(retorno)) {
            buf.setLength(0);
            buf.append("select b.fil_baseweb from filiaisweb a join filiais_postocoleta b on a.fil_codigo = b.fil_codigo where a.fil_kodigo = ").append(filial);
            rs = st.executeQuery(buf.toString());
            if (rs.next() && !Funcoes.textoVazio(rs.getString("fil_baseweb"))) {
                retorno = rs.getString("fil_baseweb");
            }
        }
        rs.close();
        return retorno;
    }

    public synchronized byte[] imprimir(String filial, String requisicao, boolean isColetaWeb, Statement st, Statement st2, Statement stResultSet, Statement st3, Statement st4, boolean isAlimentos, String parametrosOrdenacaoComprovante, boolean parametrosOrdenarSetor, int parametrosCasasPrecoExame, int parametrosArredondamentoPrecoExame, boolean parametrosPrecoMetodologia, int qtdExamesCC, int colunasRodapeComprovante, String baseWeb, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, int codigoLayoutPadrao, String impressoraComprovante, String tamanhoNomeImpressora, String[] impressorasLocais, boolean agruparGuiasInterface, int agruparInteface, String tipoIntegracao, RoundingMode arredondamentoPrecoExame, String tipoExportacaoInterface, boolean isTuboPrimario, String gerarEtiquetasComprovante, boolean isOcultarApenasFaturamento) throws SQLException, IOException {
        ImprimirComprovanteService service = null;
        service = new ImprimirComprovanteService();
        StringBuilder buf = new StringBuilder(service.imprimir(filial, requisicao, isAlimentos, parametrosOrdenacaoComprovante, parametrosOrdenarSetor, parametrosCasasPrecoExame, parametrosArredondamentoPrecoExame, parametrosPrecoMetodologia, isOcultarApenasFaturamento));
        this.acrescimoRequisicao = new BigDecimal(0);
        this.descontoRequisicao = new BigDecimal(0);
        this.totalRequisicaoProposta = new BigDecimal(0);
        HashMap<String, Object> hash = Impressao.buscaDadosLancamentoRequisicao(filial, requisicao, st);
        String datasParciais = Impressao.pegaDatasEntregaParcial(st, filial, requisicao);
        boolean semMaterial = Impressao.verificaExamesSemMaterial(st, filial, requisicao);
        String multiguias = Arrays.toString((Object[])RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, false, false));
        if (multiguias == null) {
            multiguias = "";
        }
        String[] campos = ImprimirComprovante.adicionaColunasComprovante(Impressao.CAMPOS_COMPROVANTE, isAlimentos, qtdExamesCC, colunasRodapeComprovante);
        String[] perguntasFilial = RecepcaoUtil.getPerguntasFilial(filial, st);
        if (perguntasFilial.length > 0) {
            campos = ArraysUtil.concatenar(campos, perguntasFilial);
        }
        String[] camposAgendamento = ImprimirComprovante.adicionaColunasAgendamento(new String[0]);
        ModeloGridTable modeloDados = new ModeloGridTable(ArraysUtil.concatenar(ArraysUtil.concatenar(campos, Impressao.CAMPOS_LANCAMENTO_CAIXA), camposAgendamento));
        ResultSet rs = stResultSet.executeQuery(buf.toString());
        if (rs.next()) {
            int ultimaPosicao = Impressao.CAMPOS_COMPROVANTE.length;
            int contador = 1;
            String codigoConvenio = rs.getString("codigoConvenio");
            String codigoDestino = rs.getString("codigoDestino");
            int qtdeExames = RecepcaoUtil.getQtdeExamesSituacao(st2, filial, requisicao, "F");
            if (qtdExamesCC <= 1) {
                do {
                    ultimaPosicao = Impressao.CAMPOS_COMPROVANTE.length;
                    modeloDados.addLine(new Object[modeloDados.getColumnCount()]);
                    if (!hash.isEmpty()) {
                        Set<String> set = hash.keySet();
                        for (String string : set) {
                            Object value = hash.get(string);
                            int pos = modeloDados.findColumn(string);
                            if (pos <= -1) continue;
                            modeloDados.setValueAt(value, modeloDados.getRowCount() - 1, pos);
                        }
                    }
                    this.preencheValorCamposComprovante(st2, datasParciais, semMaterial, multiguias, rs, modeloDados, qtdeExames, baseWeb, digitosTuboFilial, digitosTuboRequisicao, tipoIntegracao);
                    ultimaPosicao = this.preencheValorCamposAdicionaisComprovante(st, filial, requisicao, rs, modeloDados, ultimaPosicao, qtdeExames, parametrosPrecoMetodologia, isAlimentos, arredondamentoPrecoExame, parametrosCasasPrecoExame);
                } while (rs.next());
            } else {
                boolean fimTabela = false;
                while (!fimTabela) {
                    modeloDados.addLine(new Object[modeloDados.getColumnCount()]);
                    if (!hash.isEmpty()) {
                        Set<String> set = hash.keySet();
                        for (String s : set) {
                            Object value = hash.get(s);
                            int pos = modeloDados.findColumn(s);
                            if (pos <= -1) continue;
                            modeloDados.setValueAt(value, modeloDados.getRowCount() - 1, pos);
                        }
                    }
                    this.preencheValorCamposComprovante(st, datasParciais, semMaterial, multiguias, rs, modeloDados, qtdeExames, baseWeb, digitosTuboFilial, digitosTuboRequisicao, tipoIntegracao);
                    while (contador <= qtdExamesCC && !fimTabela) {
                        ultimaPosicao = this.preencheValorCamposAdicionaisComprovante(st, filial, requisicao, rs, modeloDados, ultimaPosicao, qtdeExames, parametrosPrecoMetodologia, isAlimentos, arredondamentoPrecoExame, parametrosCasasPrecoExame);
                        fimTabela = !rs.next();
                        ++contador;
                    }
                    if (fimTabela) continue;
                    contador = 1;
                    ultimaPosicao = Impressao.CAMPOS_COMPROVANTE.length;
                }
            }
            if (!(!isAlimentos || this.totalRequisicaoProposta.equals(BigDecimal.ZERO) && this.acrescimoRequisicao.equals(BigDecimal.ZERO))) {
                this.totalRequisicaoProposta = this.totalRequisicaoProposta.add(this.acrescimoRequisicao).subtract(this.descontoRequisicao);
            }
            int ultimaPosicaoAux = ultimaPosicao = Impressao.CAMPOS_COMPROVANTE.length + QTDE_CAMPOS_COMPROVANTE * qtdExamesCC;
            this.geraColunaRodape(filial, requisicao, modeloDados, ultimaPosicao, qtdeExames, ultimaPosicaoAux, colunasRodapeComprovante, st, st2, st3, stResultSet, st4, agruparGuiasInterface, digitosTuboTubo, digitosTuboRequisicao, digitosTuboTubo, agruparInteface, tipoExportacaoInterface, isTuboPrimario, gerarEtiquetasComprovante, isColetaWeb);
            Impressao.adicionaMedicamento(filial, requisicao, modeloDados, st);
            ImprimirComprovante.preencheCamposAgendamento(modeloDados, filial, requisicao, st);
            String codigoLayout = ExameUtil.getCodigoLayout(filial, codigoConvenio, codigoDestino, st, codigoLayoutPadrao);
            buf.delete(0, buf.length());
            buf.append("select lay_comprovante, lay_tipocomprovante from layout where fil_codigo = ");
            buf.append(filial);
            buf.append(" and lay_codigo = ");
            buf.append(codigoLayout);
            ResultSet resultSet = st.executeQuery(buf.toString());
            if (resultSet.next() && !Funcoes.textoVazio(resultSet.getString("lay_comprovante")) && (resultSet.getString("lay_tipocomprovante").equals("C") && !Gerador.vazio(resultSet.getString("lay_comprovante")) || resultSet.getString("lay_tipocomprovante").equals("T") && !Funcoes.textoVazio(resultSet.getString("lay_comprovante")) || resultSet.getString("lay_tipocomprovante").equals("D") && !Relatorio.vazio(resultSet.getString("lay_comprovante")))) {
                String impressora = "";
                if (!isColetaWeb) {
                    impressora = Impressao.comparaNomeImpressoraReduzido(impressoraComprovante, tamanhoNomeImpressora, impressorasLocais);
                }
                if (resultSet.getString("lay_tipocomprovante").equals("C")) {
                    Gerador gerador = new Gerador(parametrosCasasPrecoExame, arredondamentoPrecoExame);
                    gerador.setImpressora(!isColetaWeb ? Impressao.comparaNomeImpressoraReduzido(impressora, tamanhoNomeImpressora, impressorasLocais) : "");
                    String layComprovante = resultSet.getString("lay_comprovante");
                    gerador.executar(layComprovante, modeloDados, null, false, true, isColetaWeb);
                    if (isColetaWeb) {
                        return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), layComprovante);
                    }
                    gerador.setPreVisualizar(true);
                } else if (resultSet.getString("lay_tipocomprovante").equals("T")) {
                    ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressoraComprovante, tamanhoNomeImpressora, impressorasLocais), isColetaWeb);
                    termica.setDados(modeloDados);
                    termica.imprimir(resultSet.getString("lay_comprovante"));
                } else {
                    Relatorio rel = new Relatorio();
                    rel.setCabecalhoRodape(resultSet.getString("lay_comprovante"), modeloDados);
                    for (int i = 0; i < modeloDados.getRowCount(); ++i) {
                        rel.addItem(modeloDados.getLine(i));
                    }
                    ImpressaoRelatorio ip = new ImpressaoRelatorio(impressora);
                    if (ip.imprimir(rel) && ParametrosLocais.getParametro("impressaoLaserMapa") != null && ParametrosLocais.getParametro("impressaoFinalizarMapa") != null && ParametrosLocais.getParametro("impressaoLaserMapa").equalsIgnoreCase("1") && ParametrosLocais.getParametro("impressaoFinalizarMapa").equalsIgnoreCase("1") && !rel.isCupom()) {
                        ip.terminar();
                    }
                }
            } else {
                Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
            }
            resultSet.close();
        }
        rs.close();
        st.close();
        return new byte[0];
    }

    private static boolean isAlimentos() {
        return Variaveis.tipoFilialPadrao.equals("A");
    }

    private void geraColunaRodape(String filial, String requisicao, ModeloGridTable modeloDados, int ultimaPosicao, int qtdeExames, int ultimaPosicaoAux, int colunas, Statement st, Statement st2, Statement st3, Statement st4, Statement st5, boolean agruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, int agruparInterface, String tipoExportacaoInterface, boolean isTuboPrimario, String gerarEtiquetasComprovante, boolean isColetaWeb) throws SQLException {
        if (colunas >= 1) {
            ArrayList listaRodape = ImprimirComprovante.criaRodape(filial, requisicao, st, st2, st3, st4, st5, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface, tipoExportacaoInterface, isTuboPrimario, gerarEtiquetasComprovante, isColetaWeb);
            for (int linha = 0; linha < modeloDados.getRowCount(); ++linha) {
                for (int i = 0; i < colunas && listaRodape.size() > 0; ++i) {
                    String[] c = (String[])listaRodape.remove(0);
                    for (int j = 0; j < QTDE_CAMPOS_RODAPE_COMPROVANTE; ++j) {
                        if (ADICIONAIS_RODAPE_COMPROVANTE[j].equals("codigoTuboRodape")) {
                            modeloDados.setValueAt(c[0], linha, ultimaPosicao++);
                            continue;
                        }
                        if (ADICIONAIS_RODAPE_COMPROVANTE[j].equals("codigosExamesRodape")) {
                            modeloDados.setValueAt(c[1], linha, ultimaPosicao++);
                            continue;
                        }
                        if (ADICIONAIS_RODAPE_COMPROVANTE[j].equals("nomePacienteRodape")) {
                            modeloDados.setValueAt(c[9], linha, ultimaPosicao++);
                            continue;
                        }
                        if (ADICIONAIS_RODAPE_COMPROVANTE[j].equals("nomeSocialPacienteRodape")) {
                            modeloDados.setValueAt(c[13], linha, ultimaPosicao++);
                            continue;
                        }
                        if (ADICIONAIS_RODAPE_COMPROVANTE[j].equals("codigoMaterialRodape")) {
                            modeloDados.setValueAt(c[2], linha, ultimaPosicao++);
                            continue;
                        }
                        if (ADICIONAIS_RODAPE_COMPROVANTE[j].equals("descricaoMaterialRodape")) {
                            modeloDados.setValueAt(c[3], linha, ultimaPosicao++);
                            continue;
                        }
                        if (ADICIONAIS_RODAPE_COMPROVANTE[j].equals("abreviaturaMaterialRodape")) {
                            modeloDados.setValueAt(c[4], linha, ultimaPosicao++);
                            continue;
                        }
                        if (ADICIONAIS_RODAPE_COMPROVANTE[j].equals("codigoRequisicaoRodape")) {
                            modeloDados.setValueAt(c[8], linha, ultimaPosicao++);
                            continue;
                        }
                        if (ADICIONAIS_RODAPE_COMPROVANTE[j].equals("descricaoRecipienteRodape")) {
                            modeloDados.setValueAt(c[10], linha, ultimaPosicao++);
                            continue;
                        }
                        if (ADICIONAIS_RODAPE_COMPROVANTE[j].equals("descricaoEstacaoRodape")) {
                            modeloDados.setValueAt(c[11], linha, ultimaPosicao++);
                            continue;
                        }
                        if (ADICIONAIS_RODAPE_COMPROVANTE[j].equals("quantidadeExameSemMaterial")) {
                            modeloDados.setValueAt(qtdeExames, linha, ultimaPosicao++);
                            continue;
                        }
                        modeloDados.setValueAt("", linha, ultimaPosicao++);
                    }
                }
                ultimaPosicao = ultimaPosicaoAux;
            }
        }
        if (modeloDados.findColumn("totalRequisicaoProposta") != -1) {
            modeloDados.setValueAt(this.totalRequisicaoProposta, modeloDados.getRowCount() - 1, modeloDados.findColumn("totalRequisicaoProposta"));
        }
    }

    private int preencheValorCamposAdicionaisComprovante(Statement st, String filial, String requisicao, ResultSet rs, ModeloGridTable modeloDados, int ultimaPosicao, int qtdeExames, boolean precoMetodologia, boolean isAlimentos, RoundingMode arredondamentoPrecoExame, int parametrosCasasPrecoExame) throws SQLException {
        for (int j = 0; j < QTDE_CAMPOS_COMPROVANTE; ++j) {
            if (ADICIONAIS_COMPROVANTE[j].indexOf("ambExame") > -1) {
                modeloDados.setValueAt(Impressao.pegaAMB(st, filial, rs.getString("codigoExame"), rs.getString("codigoMaterial"), rs.getString("codigoConvenio"), rs.getString("codigoMetodo"), precoMetodologia), modeloDados.getRowCount() - 1, ultimaPosicao++);
                continue;
            }
            if (ADICIONAIS_COMPROVANTE[j].indexOf("descricaoSituacaoExame") > -1) {
                modeloDados.setValueAt(Tipos.tipoSituacaoExame(rs.getString("descricaoSituacaoExame")), modeloDados.getRowCount() - 1, ultimaPosicao++);
                continue;
            }
            if (ADICIONAIS_COMPROVANTE[j].indexOf("valorExameConvenio") > -1) {
                modeloDados.setValueAt(ExameUtil.calculaPrecoExameConvenio(st, filial, rs.getString("codigoExame"), rs.getInt("codigoMaterial"), rs.getInt("codigoConvenio"), Integer.parseInt(requisicao), null, rs.getInt("codigoMetodo"), precoMetodologia, arredondamentoPrecoExame, parametrosCasasPrecoExame), modeloDados.getRowCount() - 1, ultimaPosicao++);
                continue;
            }
            if (ADICIONAIS_COMPROVANTE[j].indexOf("quantidadeExameSemMaterial") > -1) {
                modeloDados.setValueAt(qtdeExames, modeloDados.getRowCount() - 1, ultimaPosicao++);
                continue;
            }
            if (isAlimentos && ImprimirComprovante.possuiCampos(ADICIONAIS_COMPROVANTE[j], "codigoGrupoPrincipal")) {
                modeloDados.setValueAt(rs.getString("codigoGrupoPrincipal"), modeloDados.getRowCount() - 1, ultimaPosicao++);
                continue;
            }
            if (isAlimentos && ImprimirComprovante.possuiCampos(ADICIONAIS_COMPROVANTE[j], "descricaoGrupoPrincipal")) {
                modeloDados.setValueAt(rs.getString("descricaoGrupoPrincipal"), modeloDados.getRowCount() - 1, ultimaPosicao++);
                continue;
            }
            if (isAlimentos && ImprimirComprovante.possuiCampos(ADICIONAIS_COMPROVANTE[j], "valorExameProposta")) {
                this.totalRequisicaoProposta = this.totalRequisicaoProposta.add(rs.getBigDecimal("valorExameProposta"));
                modeloDados.setValueAt(rs.getString("valorExameProposta"), modeloDados.getRowCount() - 1, ultimaPosicao++);
                continue;
            }
            modeloDados.setValueAt(rs.getObject(ADICIONAIS_COMPROVANTE[j]), modeloDados.getRowCount() - 1, ultimaPosicao++);
        }
        return ultimaPosicao;
    }

    private static boolean possuiCampos(String linha, String campo) {
        return linha.indexOf(campo) > -1;
    }

    private void preencheValorCamposComprovante(Statement st, String datasParciais, boolean semMaterial, String multiguias, ResultSet rs, ModeloGridTable modeloDados, int qtdeExames, String baseWeb, int digitosTuboFilial, int digitosTuboRequisicao, String tipoIntegracao) throws SQLException {
        for (int i = 0; i < Impressao.CAMPOS_COMPROVANTE.length; ++i) {
            if (DBUtil.campoNull(rs.getString(Impressao.CAMPOS_COMPROVANTE[i]))) {
                modeloDados.setValueAt("", modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equalsIgnoreCase("tipoLogradouroConvenioRepasse") || Impressao.CAMPOS_COMPROVANTE[i].equalsIgnoreCase("tipoLogradouroConvenio") || Impressao.CAMPOS_COMPROVANTE[i].equalsIgnoreCase("tipoLogradouroCobrancaPaciente") || Impressao.CAMPOS_COMPROVANTE[i].equalsIgnoreCase("tipoLogradouroPaciente") || Impressao.CAMPOS_COMPROVANTE[i].equalsIgnoreCase("tipoLogradouroResponsavelRequisicao") || Impressao.CAMPOS_COMPROVANTE[i].equalsIgnoreCase("tipoLogradouroMedico")) {
                modeloDados.setValueAt(Tipos.tipoLogradouroDescricao(rs.getString(Impressao.CAMPOS_COMPROVANTE[i])), modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equals("sexoPaciente")) {
                modeloDados.setValueAt(Tipos.tipoSexo(rs.getString(Impressao.CAMPOS_COMPROVANTE[i])), modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equals("corPaciente")) {
                modeloDados.setValueAt(Tipos.tipoCor(rs.getString(Impressao.CAMPOS_COMPROVANTE[i])), modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equalsIgnoreCase("estadoCivilPaciente")) {
                modeloDados.setValueAt(Tipos.tipoEstadoCivil(rs.getString(Impressao.CAMPOS_COMPROVANTE[i])), modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equalsIgnoreCase("descricaoSituacaoExame")) {
                modeloDados.setValueAt(Tipos.tipoSituacaoExame(rs.getString(Impressao.CAMPOS_COMPROVANTE[i])), modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equalsIgnoreCase("tipoUltimoPagamentoRequisicao")) {
                modeloDados.setValueAt(Tipos.tipoPagamento(rs.getString("tipoUltimoPagamentoRequisicao")), modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equals("datasEntregaParcialRequisicao")) {
                modeloDados.setValueAt(datasParciais, modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equals("existeExamesSemMaterial")) {
                modeloDados.setValueAt(semMaterial, modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equals("multiguiasRequisicao")) {
                modeloDados.setValueAt(multiguias, modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equals("tipoIntegracaoEntreFiliais")) {
                modeloDados.setValueAt(Tipos.tipoIntegracao(tipoIntegracao), modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equals("quantidadeExameSemMaterial")) {
                modeloDados.setValueAt(qtdeExames, modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equals("perguntasrequisicao")) {
                int coluna = ImprimirComprovante.achaColunaPerguntasRequisicao(modeloDados);
                Map<String, Object> perguntasRequisicao = null;
                if (coluna <= -1) continue;
                perguntasRequisicao = Resultado.getCamposResultado(rs.getObject(Impressao.CAMPOS_COMPROVANTE[i]).toString());
                Iterator<String> iterator = perguntasRequisicao.keySet().iterator();
                while (iterator.hasNext()) {
                    String perguntas;
                    String p = perguntas = iterator.next();
                    modeloDados.insertColumn(p);
                    String resposta = (String)perguntasRequisicao.get(perguntas);
                    modeloDados.setValueAt(resposta, modeloDados.getRowCount() - 1, modeloDados.findColumn(p));
                }
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equals("idadeRequisicaoPaciente")) {
                modeloDados.setValueAt(Funcoes.getIntervaloParaString((PGInterval)rs.getObject(Impressao.CAMPOS_COMPROVANTE[i]), null), modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equals("valoracrescimorequisicao")) {
                this.acrescimoRequisicao = rs.getBigDecimal("valorAcrescimoRequisicao");
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equals("valordescontorequisicao")) {
                this.descontoRequisicao = rs.getBigDecimal("valorDescontoRequisicao");
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equals("chaveAcessoRequisicao")) {
                String chaveAcesso = ResultadosUtil.getChaveAcessoRequisicao(st, rs.getString("codigoFilial"), rs.getString("codigoRequisicao"), rs.getString("senhaWebRequisicao"), baseWeb, digitosTuboFilial, digitosTuboRequisicao);
                modeloDados.setValueAt(chaveAcesso, modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (Impressao.CAMPOS_COMPROVANTE[i].equals("perguntasRequisicao")) {
                if (Funcoes.textoVazio(rs.getString("perguntasRequisicao"))) continue;
                Map<String, Object> respostasRequisicao = Resultado.getCamposResultado(rs.getString("perguntasRequisicao"));
                for (Map.Entry<String, Object> resposta : respostasRequisicao.entrySet()) {
                    if (modeloDados.findColumn(resposta.getKey()) <= -1) continue;
                    modeloDados.setValueAt(resposta.getValue(), modeloDados.getRowCount() - 1, modeloDados.findColumn(resposta.getKey()));
                }
                continue;
            }
            modeloDados.setValueAt(rs.getObject(Impressao.CAMPOS_COMPROVANTE[i]), modeloDados.getRowCount() - 1, i);
        }
    }

    private static boolean isPermitirAdicionarRegistro(ArrayList listaGrupoExame, String codigoGrupoPrincipal) {
        return !listaGrupoExame.contains(codigoGrupoPrincipal) || ImprimirComprovante.isNull(codigoGrupoPrincipal);
    }

    private static boolean isNull(String s) {
        return s == null;
    }

    public static String[] adicionaColunasComprovante(String[] campos) {
        return ImprimirComprovante.adicionaColunasComprovante(campos, ImprimirComprovante.isAlimentos(), ParametrosGerais.getQtdeExamesCC(), ParametrosGerais.getColunasRodapeComprovante());
    }

    public static String[] adicionaColunasComprovante(String[] campos, boolean isAlimentos, int qtdeExamesCC, int colunasRodapeComprovante) {
        int contador;
        int i;
        ADICIONAIS_COMPROVANTE = new String[]{"descricaoExameSemAcento", "codigoExame", "descricaoExame", "ambExame", "chExame", "valorExame", "valorMateriaisExame", "tempoJejumExame", "descricaoMaterial", "codigoMaterial", "abreviaturaMaterial", "dataColetaExame", "horaColetaExame", "usuarioColetaExame", "descricaoPrazo", "codigoPrazo", "codigoMetodo", "situacaoExame", "descricaoSituacaoExame", "descricaoMetodo", "materialInformadoExame", "dataEntregaExame", "horaEntregaExame", "valorCH", "autorizacaoExame", "observacaoPrazoCarenciaExame", "valorExameConvenio", "codigoSetorExame", "custoCBHPMExame", "ucoCBHPMExame", "valorPorteCBHPMExame", "porteCHBPMExame", "materialExternoExame", "descricaoSetorExame", "abreviaturaSetorExame", "soaExame", "coaExame", "urgenteExame", "certificadoInmetroExame", "valorExameProposta"};
        if (isAlimentos) {
            ADICIONAIS_COMPROVANTE = ArraysUtil.concatenar(ADICIONAIS_COMPROVANTE, new String[]{"codigoGrupoPrincipal", "descricaoGrupoPrincipal"});
        }
        QTDE_CAMPOS_COMPROVANTE = ADICIONAIS_COMPROVANTE.length;
        String[] medicamento = Impressao.getCamposMedicamento();
        String[] novo = new String[campos.length + QTDE_CAMPOS_COMPROVANTE * qtdeExamesCC + QTDE_CAMPOS_RODAPE_COMPROVANTE * colunasRodapeComprovante + medicamento.length];
        for (int i2 = 0; i2 < campos.length; ++i2) {
            novo[i2] = campos[i2];
        }
        int ultimaPosicao = campos.length;
        if (qtdeExamesCC <= 1) {
            for (i = 0; i < QTDE_CAMPOS_COMPROVANTE; ++i) {
                novo[ultimaPosicao++] = ADICIONAIS_COMPROVANTE[i];
            }
        } else {
            for (contador = 1; contador <= qtdeExamesCC; ++contador) {
                for (i = 0; i < QTDE_CAMPOS_COMPROVANTE; ++i) {
                    novo[ultimaPosicao++] = ADICIONAIS_COMPROVANTE[i] + String.valueOf(contador);
                }
            }
        }
        if (colunasRodapeComprovante <= 1) {
            for (i = 0; i < QTDE_CAMPOS_RODAPE_COMPROVANTE; ++i) {
                novo[ultimaPosicao++] = ADICIONAIS_RODAPE_COMPROVANTE[i];
            }
        } else {
            for (contador = 1; contador <= colunasRodapeComprovante; ++contador) {
                for (i = 0; i < QTDE_CAMPOS_RODAPE_COMPROVANTE; ++i) {
                    novo[ultimaPosicao++] = ADICIONAIS_RODAPE_COMPROVANTE[i] + String.valueOf(contador);
                }
            }
        }
        for (String s : medicamento) {
            novo[ultimaPosicao++] = s;
        }
        novo = ArraysUtil.concatenar(novo, new String[]{"totalRequisicaoProposta"});
        return novo;
    }

    private static ArrayList criaRodape(String filial, String requisicao, Statement st1, Statement st2, Statement st3, Statement st4, Statement st5, boolean agruparGuiasInteface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, int agruparInterface, String tipoExportacaoInterface, boolean isTuboPrimario, String gerarEtiquetasComprovante, boolean isColetaWeb) throws SQLException {
        boolean agruparMultiguia = agruparGuiasInteface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st1, filial, requisicao);
        String multiguiaPrincipal = requisicao;
        Integer[] multiguia = RecepcaoUtil.verificaMultiGuias(st1, filial, requisicao, true);
        StringBuilder multiguias = new StringBuilder("");
        for (Integer i : multiguia) {
            if (i < Integer.parseInt(multiguiaPrincipal)) {
                multiguiaPrincipal = String.valueOf(i);
            }
            if (multiguias.length() > 0) {
                multiguias.append(", ");
            }
            multiguias.append(String.valueOf(i));
        }
        StringBuilder buf = new StringBuilder("select a.exa_codigo, c.rec_capacidade, b.rec_codigo, b.rco_qtde, b.rco_volume, ");
        buf.append("d.mco_abreviatura, d.mco_codigo, d.mco_descricao, a.req_codigo, f.pac_nome, a.exr_situacao, ");
        buf.append("'' as descricaoSituacaoExame, c.rec_descricao, estacao.est_descricao, es.set_codigo, COALESCE(a.exr_codigoapoiado, '') as exr_codigoapoiado,  f.pac_nomesocial ");
        buf.append("from examerequisicao a ");
        buf.append("left join requisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo ");
        buf.append("left join paciente f on e.fil_codigo = f.fil_codigo and e.pac_codigo = f.pac_codigo ");
        buf.append("left join recipcoleta b on a.fil_codigo = b.fil_codigo and upper(a.exa_codigo) = upper(b.exa_codigo) and a.mco_codigo = b.mco_codigo ");
        buf.append("left join recipientes c on a.fil_codigo = c.fil_codigo and b.rec_codigo = c.rec_codigo ");
        buf.append("left join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo ");
        buf.append("left join examematcoleta g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
        buf.append("left join examesetor es on a.fil_codigo = es.fil_codigo and upper(a.exa_codigo) = upper(es.exa_codigo) ");
        buf.append("left join estacoes estacao on e.est_codigo = estacao.est_codigo ");
        buf.append("where a.fil_codigo = ").append(filial);
        buf.append(" and a.req_codigo IN (").append(agruparMultiguia ? multiguias : requisicao).append(") ");
        buf.append(" and (a.exr_excluido = false or a.exr_excluido is null) and (e.req_excluida = false or e.req_excluida is null) ");
        buf.append(" order by es.set_codigo, b.rec_codigo, a.mco_codigo, b.rco_qtde, a.exa_codigo ");
        ResultSet rsRodape = st1.executeQuery(buf.toString());
        ArrayList<String[]> lista = new ArrayList<String[]>();
        try {
            while (rsRodape.next()) {
                int qtde = DBUtil.campoNull(rsRodape.getString("rco_qtde")) ? 1 : rsRodape.getInt("rco_qtde");
                LinkedHashMap<Integer, String> tubosParaImprimir = new LinkedHashMap<Integer, String>();
                tubosParaImprimir.put(rsRodape.getInt("rec_codigo"), rsRodape.getString("rec_descricao"));
                buf.setLength(0);
                buf.append("select emi_curva, int_codigo from examematinterface ");
                buf.append("where fil_codigo = ").append(filial);
                buf.append(" and exa_codigo = '").append(StringUtil.textoDB(rsRodape.getString("exa_codigo"))).append("' ");
                buf.append(" and mco_codigo = ").append(rsRodape.getString("mco_codigo"));
                if (tipoExportacaoInterface.equals("P")) {
                    buf.append(" and emi_padrao = true ");
                }
                ResultSet rsCurva = st2.executeQuery(buf.toString());
                ArrayList<Integer> interfacesParaCurvaTemp = new ArrayList<Integer>();
                while (rsCurva.next()) {
                    if (!rsCurva.getBoolean("emi_curva")) continue;
                    interfacesParaCurvaTemp.add(rsCurva.getInt("int_codigo"));
                }
                if (!interfacesParaCurvaTemp.isEmpty()) {
                    tubosParaImprimir.clear();
                }
                for (Integer int_codigo : interfacesParaCurvaTemp) {
                    buf.delete(0, buf.length());
                    buf.append("select exa_kodigo, mco_kodigo from examematintdesmembrar ");
                    buf.append("where fil_codigo = ").append(filial);
                    buf.append(" and exa_codigo = '").append(StringUtil.textoDB(rsRodape.getString("exa_codigo"))).append("' ");
                    buf.append(" and mco_codigo = ").append(rsRodape.getString("mco_codigo"));
                    buf.append(" and int_codigo = ").append(int_codigo);
                    rsCurva = st3.executeQuery(buf.toString());
                    while (rsCurva.next()) {
                        buf.setLength(0);
                        buf.append("select a.rec_codigo, c.rec_descricao ");
                        buf.append("from ");
                        buf.append("recipcoleta a ");
                        buf.append("join recipientes c on c.fil_codigo = a.fil_codigo and c.rec_codigo = a.rec_codigo ");
                        buf.append("where a.fil_codigo = ").append(filial);
                        buf.append(" and a.exa_codigo = '").append(StringUtil.textoDB(rsCurva.getString("exa_kodigo"))).append("'");
                        buf.append(" and a.mco_codigo = ").append(rsCurva.getString("mco_kodigo"));
                        if (agruparInterface == 0) {
                            buf.append(" and a.rco_interface = true ");
                        }
                        buf.append(" order by a.rec_codigo ");
                        ResultSet rsTubos = st4.executeQuery(buf.toString());
                        while (rsTubos.next()) {
                            if (tubosParaImprimir.containsKey(rsTubos.getInt("rec_codigo"))) continue;
                            tubosParaImprimir.put(rsTubos.getInt("rec_codigo"), rsTubos.getString("rec_descricao"));
                        }
                        rsTubos.close();
                    }
                }
                Iterator<Object> iterator = tubosParaImprimir.keySet().iterator();
                while (iterator.hasNext()) {
                    int tuboParaImprimir = (Integer)iterator.next();
                    String descricaoTubo = (String)tubosParaImprimir.get(tuboParaImprimir);
                    int pos = -1;
                    for (int i = 0; i < qtde; ++i) {
                        pos = ImprimirComprovante.localizar(0, rsRodape.getInt("set_codigo"), String.valueOf(tuboParaImprimir), lista, 0, isTuboPrimario);
                        String codigoRequisicaoMultiguia = agruparGuiasInteface ? multiguiaPrincipal : null;
                        String codigoTubo = Funcoes.preencheZero(filial, digitosTuboFilial) + Funcoes.preencheZero(codigoRequisicaoMultiguia == null ? rsRodape.getString("req_codigo") : codigoRequisicaoMultiguia, digitosTuboRequisicao) + Funcoes.preencheZero(DBUtil.campoNull(String.valueOf(tuboParaImprimir)) ? "0" : String.valueOf(tuboParaImprimir), digitosTuboTubo);
                        if (pos > -1) {
                            ImprimirComprovante.adicionaTubo(lista, pos, String.valueOf(tuboParaImprimir), rsRodape.getString("exa_codigo"), rsRodape.getString("mco_codigo"), rsRodape.getString("mco_descricao"), rsRodape.getString("mco_abreviatura"), String.valueOf(qtde), rsRodape.getString("rco_volume"), rsRodape.getString("rec_capacidade"), codigoTubo, rsRodape.getString("pac_nome"), descricaoTubo, rsRodape.getString("est_descricao"), rsRodape.getString("set_codigo"), rsRodape.getString("pac_nomesocial"), isTuboPrimario);
                        } else {
                            lista.add(new String[]{String.valueOf(tuboParaImprimir), rsRodape.getString("exa_codigo"), rsRodape.getString("mco_codigo"), rsRodape.getString("mco_descricao"), rsRodape.getString("mco_abreviatura"), String.valueOf(qtde), rsRodape.getString("rco_volume"), rsRodape.getString("rec_capacidade"), codigoTubo, rsRodape.getString("pac_nome"), descricaoTubo, rsRodape.getString("est_descricao"), rsRodape.getString("set_codigo"), rsRodape.getString("pac_nomesocial")});
                        }
                        if (gerarEtiquetasComprovante == null || !gerarEtiquetasComprovante.equalsIgnoreCase("1")) continue;
                        StringBuilder bui = new StringBuilder("select count(req_codigo) as contagem from examerequisicaorecipiente ");
                        bui.append("where fil_codigo = ");
                        bui.append(filial);
                        bui.append(" and exa_codigo = '");
                        bui.append(rsRodape.getString("exa_codigo"));
                        bui.append("' and mco_codigo =  ");
                        bui.append(rsRodape.getString("mco_codigo"));
                        bui.append(" and req_codigo = ");
                        bui.append(rsRodape.getString("req_codigo"));
                        bui.append(" and rec_codigo = ");
                        bui.append(rsRodape.getString("rec_codigo"));
                        bui.append(" and rec_kodigo = ");
                        bui.append(String.valueOf(tuboParaImprimir));
                        ResultSet result = st5.executeQuery(bui.toString());
                        if (!result.next() || result.getInt("contagem") > 0) continue;
                        bui.delete(0, bui.length());
                        bui.append("insert into examerequisicaorecipiente(fil_codigo, exa_codigo,");
                        bui.append("mco_codigo, req_codigo, rec_codigo, ere_tipo, rec_kodigo, ere_codigoapoiado) values (");
                        bui.append(filial);
                        bui.append(", '");
                        bui.append(rsRodape.getString("exa_codigo"));
                        bui.append("', ");
                        bui.append(rsRodape.getString("mco_codigo"));
                        bui.append(", ");
                        bui.append(rsRodape.getString("req_codigo"));
                        bui.append(", ");
                        bui.append(rsRodape.getString("rec_codigo"));
                        bui.append(", '").append("C").append("',");
                        bui.append(String.valueOf(tuboParaImprimir));
                        bui.append(", '");
                        bui.append(codigoTubo).append("' ");
                        bui.append(")");
                        Conexao.execute(filial, st5, bui.toString());
                        if (isColetaWeb) continue;
                        Conexao.arquivaSQL();
                    }
                }
            }
        }
        catch (Exception e) {
            if (!isColetaWeb) {
                Conexao.anulaSQL();
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImprimirComprovante: 627");
        }
        return lista;
    }

    private static int localizar(int posini, int setor, String tubo, ArrayList lista, int coluna, boolean isTuboPrimario) {
        int retorno = -1;
        if (posini < lista.size() && !lista.isEmpty()) {
            for (int i = posini; i < lista.size(); ++i) {
                String[] o = (String[])lista.get(i);
                if (o[coluna] == null || !o[coluna].equals(tubo) || !isTuboPrimario && (!Funcoes.isNumeric(o[12]) || Integer.parseInt(o[12]) != setor)) continue;
                retorno = i;
                break;
            }
        }
        return retorno;
    }

    private static ArrayList adicionaTubo(ArrayList lista, int pos, String tubo, String exame, String codigoMaterial, String descricaoMaterial, String abrv, String qtde, String volume, String capacidade, String codigoRequisicaoTubo, String nomePaciente, String recipiente, String descricaoEstacao, String setor, String nomeSocialPaciente, boolean isTuboPrimario) {
        String[] s = (String[])lista.get(pos);
        double capacity = 0.0;
        double volumeUtilizado = 0.0;
        double novoVolume = 0.0;
        if (Funcoes.isNumeric(s[7])) {
            capacity = Double.parseDouble(Funcoes.limpaDecimal(s[7]));
        }
        if (Funcoes.isNumeric(s[6])) {
            volumeUtilizado = Double.parseDouble(Funcoes.limpaDecimal(s[6]));
        }
        if (Funcoes.isNumeric(volume)) {
            novoVolume = Double.parseDouble(volume);
        }
        if (capacity == 0.0 || capacity > 0.0 && capacity - volumeUtilizado >= novoVolume) {
            s[6] = String.valueOf(volumeUtilizado + novoVolume);
            s[1] = s[1] + " " + exame;
        } else if ((pos = ImprimirComprovante.localizar(pos + 1, Integer.parseInt(setor), tubo, lista, 0, isTuboPrimario)) < 0) {
            lista.add(new String[]{tubo, exame, codigoMaterial, descricaoMaterial, abrv, qtde, volume, capacidade, codigoRequisicaoTubo, nomePaciente, recipiente, descricaoEstacao, setor, nomeSocialPaciente});
        } else {
            lista = ImprimirComprovante.adicionaTubo(lista, pos, tubo, exame, codigoMaterial, descricaoMaterial, abrv, qtde, volume, capacidade, codigoRequisicaoTubo, nomePaciente, recipiente, descricaoEstacao, setor, nomeSocialPaciente, isTuboPrimario);
        }
        return lista;
    }

    private static void preencheCamposAgendamento(ModeloGridTable modelo, String filial, String requisicao, Statement st) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select agd.agd_codigo as codigoAgendamento ");
        buf.append("       ,agd.agd_datahoraagenda as dataHoraAgendamento ");
        buf.append("       ,agd.agd_situacao as situacaoAgendamento ");
        buf.append("       ,agd.agd_observacao as observacaoAgendamento ");
        buf.append("       ,sal.sal_codigo as codigoSalaAtendimento ");
        buf.append("       ,sal.sal_descricao as descricaoSalaAtendimento ");
        buf.append("   from agendamento agd ");
        buf.append("   join salaatendimento sal on agd.fil_codigo = sal.fil_codigo and agd.sal_codigo = sal.sal_codigo ");
        buf.append("  where agd.fil_codigo = ").append(filial);
        buf.append("    and pegacodigomultiguiamae(agd.fil_codigo, agd.req_codigo) = pegacodigomultiguiamae(").append(filial).append(", ").append(requisicao).append(") ");
        buf.append("    and agd.agd_situacao IN ('").append("A").append("' ");
        buf.append("                            ,'").append("T").append("' ");
        buf.append("                            ,'").append("F").append("') ");
        buf.append("  order by agd.agd_datahoraagenda ");
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            int i = 1;
            while (rs.next()) {
                for (int k = 0; k < modelo.getRowCount(); ++k) {
                    for (int j = 0; j < CAMPOS_AGENDAMENTO.length; ++j) {
                        modelo.setValueAt(rs.getObject(CAMPOS_AGENDAMENTO[j]), k, modelo.findColumn(CAMPOS_AGENDAMENTO[j] + i));
                    }
                }
                ++i;
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi possivel buscar dados dos agendamentos.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private static int achaColunaPerguntasRequisicao(ModeloGridTable modelo) {
        return ImprimirComprovante.achaColuna(modelo, "perguntasRequisicao");
    }

    private static int achaColuna(ModeloGridTable modelo, String coluna) {
        int retorno = -1;
        for (int i = 0; i < modelo.getColumnCount(); ++i) {
            if (!modelo.getColumnName(i).equalsIgnoreCase(coluna)) continue;
            retorno = i;
            break;
        }
        return retorno;
    }

    public static String[] adicionaColunasAgendamento(String[] campos) {
        String[] colunas = new String[]{};
        for (int i = 0; i < 10; ++i) {
            String[] aux = new String[CAMPOS_AGENDAMENTO.length];
            for (int j = 0; j < CAMPOS_AGENDAMENTO.length; ++j) {
                aux[j] = CAMPOS_AGENDAMENTO[j] + (i + 1);
            }
            colunas = ArraysUtil.concatenar(colunas, aux);
        }
        return ArraysUtil.concatenar(campos, colunas);
    }
}

