/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.relatorio.Gerador;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.concurrent.Callable;
import org.postgresql.util.PGInterval;

public class ImprimirCarteira {
    public static void imprimir(String filial, String paciente) throws SQLException {
        ImprimirCarteira carteira = new ImprimirCarteira();
        carteira.imprimir(filial, paciente, false, Conexao.getStatement(), ParametrosGerais.getLayCodigo(), Variaveis.login, ParametrosLocais.getParametro("impressoraCarteira"), ParametrosLocais.getParametro("tamanhoNomeImpressoras"), Funcoes.getNomeImpressorasLocais(), () -> {
            try {
                Conexao.arquivaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, () -> {
            try {
                Conexao.anulaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
    }

    public byte[] imprimir(String filial, String paciente, boolean isColetaWeb, Statement st, int codigoLayoutPadrao, String login, String impressoraCarteira, String tamanhoImpressora, String[] impressorasLocais, Callable<Boolean> arquivar, Callable<Boolean> anular, int parametrosCasasPrecoExame, RoundingMode arredondamentoPrecoExame) throws SQLException {
        byte[] retorno = null;
        if (st == null) {
            return new byte[0];
        }
        StringBuilder buf = new StringBuilder("");
        buf.append("select ");
        buf.append(" a.pac_codigo as codigoPaciente, a.pac_nome as nomePaciente, a.pac_sexo as sexoPaciente, ");
        buf.append(" a.pac_responsavel as responsavelPaciente, a.pac_cpfresponsavel as cpfResponsavelPaciente, coalesce(a.pac_incapacitado, false) as incapacitadoPaciente,");
        buf.append(" a.pac_datanasc as dataNascimentoPaciente, a.pac_grpsangue as grupoSanguineoPaciente, ");
        buf.append(" a.pac_fatorrh as fatorRHPaciente, a.pac_fatordu as fatorDUPaciente, a.pac_cor as corPaciente, ");
        buf.append(" a.pac_profissao as profissaoPaciente, a.pac_rg as rgPaciente, a.pac_cpf as cpfPaciente, ");
        buf.append(" a.pac_estcivil as estadoCivilPaciente, a.pac_fone as fonePaciente, a.pac_celular as celularPaciente, ");
        buf.append(" a.pac_fax as faxPaciente, a.pac_fonecomercial as foneComercialPaciente, a.pac_endereco as enderecoPaciente, a.pac_numeroendereco as numeroEnderecoPaciente, ");
        buf.append(" a.pac_tipologradouroendereco as tipoLogradouroPaciente, a.pac_complemento as complementoPaciente, a.pac_cep as cepPaciente, a.pac_email as emailPaciente, ");
        buf.append(" a.pac_fonecontato as foneContatoPaciente, a.pac_nomecontato as contatoPaciente, ");
        buf.append(" a.pac_whatsapp as whatsAppPaciente, ");
        buf.append(" cidpaciente.cid_codigo as codigoCidadePaciente, cidpaciente.cid_nome as descricaoCidadePaciente, ");
        buf.append(" cidpaciente.cid_uf as estadoCidadePaciente, baipaciente.bai_codigo as codigoBairroPaciente, ");
        buf.append(" baipaciente.bai_descricao as descricaoBairroPaciente, a.pac_datahora as dataCadastroPaciente,  ");
        buf.append(" a.pac_senhaweb as senhaWebPaciente, a.pac_nomesocial as nomeSocialPaciente, ");
        buf.append(" a.con_codigo as codigoConvenio, a.pac_matricconv as matriculaPaciente, ");
        buf.append(" a.pac_validadecarteira as dataValidadeCarteiraPaciente, a.pac_nomeplano as planoPaciente,  ");
        buf.append(" a.pac_titularconv as titularPaciente, a.pac_cartaosus as cartaoSusPaciente, a.pac_prontuario as prontuarioPaciente, ");
        buf.append(" a.med_conselho as conselhoMedico, a.med_crm as crmMedico, a.med_uf as ufMedico, a.med_conselho as conselhoMedico, a.med_crm as crmMedico, a.med_uf as ufMedico,");
        buf.append(" med.med_nome as nomeMedico, conv.con_fantasia as fantasiaConvenio, conv.con_razao as razaoSocialConvenio, ");
        buf.append(" age(current_date, a.pac_datanasc) as idadeRequisicaoPaciente ");
        buf.append(" from paciente a ");
        buf.append(" left join cidades cidpaciente on a.fil_codigo = cidpaciente.fil_codigo and a.cid_codigo = cidpaciente.cid_codigo ");
        buf.append(" left join bairro baipaciente on a.fil_codigo = baipaciente.fil_codigo and a.bai_codigo = baipaciente.bai_codigo ");
        buf.append(" left join convenios conv on a.fil_codigo = conv.fil_codigo and a.con_codigo = conv.con_codigo ");
        buf.append(" left join medico med on a.fil_codigo = med.fil_codigo and a.med_crm = med.med_crm and a.med_conselho = med.med_conselho and a.med_uf = med.med_uf ");
        buf.append(" where a.fil_codigo = ").append(filial);
        buf.append(" and a.pac_codigo = ").append(paciente);
        ResultSet rs = st.executeQuery(buf.toString());
        ModeloGridTable modeloDados = new ModeloGridTable(Impressao.CAMPOS_CARTEIRA);
        if (rs.next()) {
            modeloDados.addLine(new Object[Impressao.CAMPOS_CARTEIRA.length]);
            for (int i = 0; i < Impressao.CAMPOS_CARTEIRA.length; ++i) {
                if (DBUtil.campoNull(rs.getString(Impressao.CAMPOS_CARTEIRA[i]))) {
                    modeloDados.setValueAt("", modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (Impressao.CAMPOS_CARTEIRA[i].equalsIgnoreCase("tipoLogradouroPaciente")) {
                    modeloDados.setValueAt(Tipos.tipoLogradouroDescricao(rs.getString(Impressao.CAMPOS_CARTEIRA[i])), modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (Impressao.CAMPOS_CARTEIRA[i].equals("sexoPaciente")) {
                    modeloDados.setValueAt(Tipos.tipoSexo(rs.getString(Impressao.CAMPOS_CARTEIRA[i])), modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (Impressao.CAMPOS_CARTEIRA[i].equals("fatorDUPaciente")) {
                    modeloDados.setValueAt(rs.getString(Impressao.CAMPOS_CARTEIRA[i]), modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (Impressao.CAMPOS_CARTEIRA[i].equals("corPaciente")) {
                    modeloDados.setValueAt(Tipos.tipoCor(rs.getString(Impressao.CAMPOS_CARTEIRA[i])), modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (Impressao.CAMPOS_CARTEIRA[i].equalsIgnoreCase("estadoCivilPaciente")) {
                    modeloDados.setValueAt(Tipos.tipoEstadoCivil(rs.getString(Impressao.CAMPOS_CARTEIRA[i])), modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (Impressao.CAMPOS_CARTEIRA[i].equals("idadeRequisicaoPaciente")) {
                    modeloDados.setValueAt(Funcoes.getIntervaloParaString((PGInterval)rs.getObject(Impressao.CAMPOS_CARTEIRA[i]), null), modeloDados.getRowCount() - 1, i);
                    continue;
                }
                modeloDados.setValueAt(rs.getObject(Impressao.CAMPOS_CARTEIRA[i]), modeloDados.getRowCount() - 1, i);
            }
            String codigoLayout = null;
            buf.delete(0, buf.length());
            buf.append(" select con.lay_codigo from convenios con ");
            buf.append(" left join paciente pac on con.fil_codigo = pac.fil_codigo and con.con_codigo = pac.con_codigo ");
            buf.append(" where con.fil_codigo = ").append(filial);
            buf.append(" and pac.pac_codigo = ").append(paciente);
            ResultSet rsConvenio = st.executeQuery(buf.toString());
            if (rsConvenio.next() && !Funcoes.textoVazio(rsConvenio.getString("lay_codigo"))) {
                codigoLayout = rsConvenio.getString("lay_codigo");
            }
            rsConvenio.close();
            if (codigoLayout == null) {
                codigoLayout = String.valueOf(codigoLayoutPadrao);
            }
            buf.delete(0, buf.length());
            buf.append("select lay_carteira, lay_tipocarteira from layout where fil_codigo = ");
            buf.append(filial);
            buf.append(" and lay_codigo = ");
            buf.append(codigoLayout);
            ResultSet rsLayout = st.executeQuery(buf.toString());
            if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("lay_carteira"))) {
                String tipo = rsLayout.getString("lay_tipocarteira");
                if (tipo.equalsIgnoreCase("C")) {
                    Gerador gerador = new Gerador(parametrosCasasPrecoExame, arredondamentoPrecoExame);
                    if (!isColetaWeb) {
                        gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraCarteira")));
                    }
                    String layCarteira = rsLayout.getString("lay_carteira");
                    gerador.executar(layCarteira, modeloDados, null, false, true, isColetaWeb);
                    if (isColetaWeb) {
                        retorno = Impressao.gerarPdfRelatorio(gerador.getRelatorio(), layCarteira);
                    }
                } else if (tipo.equalsIgnoreCase("T")) {
                    ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressoraCarteira, tamanhoImpressora, impressorasLocais), isColetaWeb);
                    termica.setDados(modeloDados);
                    retorno = termica.imprimir(rsLayout.getString("lay_carteira"), st, isColetaWeb, arquivar, anular);
                }
                buf.delete(0, buf.length());
                buf.append("update paciente set pac_imprimircarteira = false where fil_codigo = ").append(filial);
                buf.append(" and pac_codigo = ").append(paciente);
                st.execute(buf.toString());
                buf.delete(0, buf.length());
                buf.append("update paciente set pac_dataimpressaocarteira = '").append(Funcoes.formataData("MM/dd/yyyy HH:mm:ss", new Date())).append("',");
                buf.append("usr_codimpressaocarteira = '").append(StringUtil.textoDB(login)).append("' ");
                buf.append("where fil_codigo = ").append(filial);
                buf.append(" and pac_codigo = ").append(paciente);
                st.execute(buf.toString());
            } else if (!isColetaWeb) {
                Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
            } else {
                return new byte[0];
            }
            rsLayout.close();
        }
        rs.close();
        st.close();
        return retorno;
    }
}

