/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.impressao.matricial.ImpressaoRelatorio;
import jalis.util.impressao.matricial.Relatorio;
import jalis.util.logger.ErrorLogger;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.postgresql.util.PGInterval;

public class ImprimirAnexo {
    private static final int RODAPE_COLUNA_CODIGO = 0;
    private static final int RODAPE_COLUNA_EXAME = 1;
    private static final int RODAPE_COLUNA_CODIGO_MATERIAL = 2;
    private static final int RODAPE_COLUNA_DESCRICAO_MATERIAL = 3;
    private static final int RODAPE_COLUNA_ABREVIATURA = 4;
    private static final int RODAPE_COLUNA_QTDE = 5;
    private static final int RODAPE_COLUNA_VOLUME = 6;
    private static final int RODAPE_COLUNA_CAPACIDADE = 7;
    private static final int RODAPE_COLUNA_REQUISICAO_TUBO = 8;
    private static final int RODAPE_COLUNA_PACIENTE = 9;
    private static final int RODAPE_COLUNA_RECIPIENTE = 10;
    private static final int QUANTIDADE_AGENDAMENTOS = 10;
    private static final int RODAPE_COLUNA_PACIENTE_NOME_SOCIAL = 11;
    private static final String[] ADICIONAIS_ANEXO = new String[]{"codigoExame", "descricaoExame", "ambExame", "chExame", "valorExame", "valorMateriaisExame", "valorCH", "descricaoMaterial", "codigoMaterial", "abreviaturaMaterial", "dataColetaExame", "horaColetaExame", "tempoJejumExame", "usuarioColetaExame", "descricaoPrazo", "codigoPrazo", "codigoMetodo", "situacaoExame", "descricaoSituacaoExame", "descricaoMetodo", "materialInformadoExame", "dataEntregaExame", "horaEntregaExame", "autorizacaoExame", "observacaoPrazoCarenciaExame", "valorExameConvenio", "codigoSetorExame", "descricaoSetorExame", "custoCBHPMExame", "ucoCBHPMExame", "valorPorteCBHPMExame", "porteCHBPMExame", "materialExternoExame", "abreviaturaSetorExame", "soaExame", "coaExame", "urgenteExame", "certificadoInmetroExame", "nomeDoPlano"};
    private static final String[] ADICIONAIS_RODAPE_ANEXO = new String[]{"codigoTuboRodape", "codigosExamesRodape", "codigoMaterialRodape", "nomePacienteRodape", "descricaoMaterialRodape", "abreviaturaMaterialRodape", "codigoRequisicaoRodape", "descricaoRecipienteRodape", "nomeSocialPacienteRodape"};
    private static final String[] CAMPOS_AGENDAMENTO = new String[]{"codigoAgendamento", "dataHoraAgendamento", "situacaoAgendamento", "observacaoAgendamento", "codigoSalaAtendimento", "descricaoSalaAtendimento"};
    private static final int QTDE_CAMPOS_ANEXO = ADICIONAIS_ANEXO.length;
    private static final int QTDE_CAMPOS_RODAPE_ANEXO = ADICIONAIS_RODAPE_ANEXO.length;

    public static byte[] imprimir(String filial, String requisicao) throws SQLException {
        ImprimirAnexo anexo = new ImprimirAnexo();
        return anexo.imprimir(filial, requisicao, false, Conexao.getStatement(), Conexao.getStatement(), Conexao.getStatement(), ImprimirAnexo.isAlimentos(), ParametrosGerais.getOrdenarSetor(), ParametrosGerais.getOrdemComprovante(), ParametrosGerais.getQtdeExamesCC(), ParametrosGerais.getColunasRodapeComprovante(), ParametrosGerais.getTipoIntegracao(), ParametrosGerais.getPrecoMetodologia(), ParametrosGerais.getArredondamentoPrecoExame(), ParametrosGerais.getCasasPrecoExame(), Variaveis.filialPadrao, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboTubo(), ParametrosGerais.getLayCodigo(), ParametrosGerais.isOcultarApenasFaturamento());
    }

    /*
     * WARNING - void declaration
     */
    public byte[] imprimir(String filial, String requisicao, boolean isColetaWeb, Statement st, Statement st2, Statement st3, boolean isAlimentos, boolean ordenarSetor, String ordemComprovante, int qtdeExamesCC, int colunasRodapeComprovante, String tipoIntegracao, boolean precoMetodologia, RoundingMode arredondamentoPrecoExame, int parametrosCasasPrecoExame, String filialPadrao, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, int codigoLayoutPadrao, boolean ocultarApenasFaturamento) throws SQLException {
        if (st == null) {
            return new byte[0];
        }
        String sql = DBUtil.selectImpressaoAnexoRecibo(filial, requisicao, isAlimentos, ordenarSetor, ordemComprovante, ocultarApenasFaturamento, st).toString();
        HashMap<String, Object> hash = Impressao.buscaDadosLancamentoRequisicao(filial, requisicao, st);
        String datasParciais = Impressao.pegaDatasEntregaParcial(st, filial, requisicao);
        boolean semMaterial = Impressao.verificaExamesSemMaterial(st, filial, requisicao);
        String multiguias = Arrays.toString((Object[])RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, false, false));
        if (multiguias == null) {
            multiguias = "";
        }
        String[] campos = ImprimirAnexo.adicionaColunasAnexo(Impressao.CAMPOS_ANEXO, qtdeExamesCC, colunasRodapeComprovante);
        String[] perguntasFilial = RecepcaoUtil.getPerguntasFilial(filial, st);
        if (perguntasFilial.length > 0) {
            campos = ArraysUtil.concatenar(campos, perguntasFilial);
        }
        String[] camposAgendamento = ImprimirAnexo.adicionaColunasAgendamento(new String[0]);
        ModeloGridTable modeloDados = new ModeloGridTable(ArraysUtil.concatenar(ArraysUtil.concatenar(campos, Impressao.CAMPOS_LANCAMENTO_CAIXA), camposAgendamento));
        ResultSet rs = st3.executeQuery(sql);
        if (rs.next()) {
            int ultimaPosicao = Impressao.CAMPOS_ANEXO.length;
            int contador = 1;
            String codigoConvenio = rs.getString("codigoConvenio");
            String codigoDestino = rs.getString("codigoDestino");
            int qtdeExames = RecepcaoUtil.getQtdeExamesSituacao(st2, filial, requisicao, "F");
            if (qtdeExamesCC <= 1) {
                do {
                    ultimaPosicao = Impressao.CAMPOS_ANEXO.length;
                    modeloDados.addLine(new Object[modeloDados.getColumnCount()]);
                    if (!hash.isEmpty()) {
                        Set<String> set = hash.keySet();
                        for (String string : set) {
                            Object value = hash.get(string);
                            int pos = modeloDados.findColumn(string);
                            if (pos <= -1) continue;
                            modeloDados.setValueAt(value, modeloDados.getRowCount() - 1, pos);
                        }
                    }
                    for (int i = 0; i < Impressao.CAMPOS_ANEXO.length; ++i) {
                        if (DBUtil.campoNull(rs.getString(Impressao.CAMPOS_ANEXO[i]))) {
                            modeloDados.setValueAt("", modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_ANEXO[i].equals("tipoLogradouroPaciente") || Impressao.CAMPOS_ANEXO[i].equals("tipoLogradouroEnderecoCobranca") || Impressao.CAMPOS_ANEXO[i].equals("tipoLogradouroMedico") || Impressao.CAMPOS_ANEXO[i].equals("tipoLogradouroResponsavelRequisicao") || Impressao.CAMPOS_ANEXO[i].equals("tipoLogradouroConvenio")) {
                            modeloDados.setValueAt(Tipos.tipoLogradouroDescricao(rs.getString(Impressao.CAMPOS_ANEXO[i])), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_ANEXO[i].equals("sexoPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoSexo(rs.getString(Impressao.CAMPOS_ANEXO[i])), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_ANEXO[i].equals("corPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoCor(rs.getString(Impressao.CAMPOS_ANEXO[i])), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_ANEXO[i].equalsIgnoreCase("estadoCivilPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoEstadoCivil(rs.getString(Impressao.CAMPOS_ANEXO[i])), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_ANEXO[i].equalsIgnoreCase("tipoUltimoPagamentoRequisicao")) {
                            modeloDados.setValueAt(Tipos.tipoPagamento(rs.getString(Impressao.CAMPOS_ANEXO[i])), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_ANEXO[i].equals("datasEntregaParcialRequisicao")) {
                            modeloDados.setValueAt(datasParciais, modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_ANEXO[i].equals("existeExamesSemMaterial")) {
                            modeloDados.setValueAt(semMaterial, modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_ANEXO[i].equals("multiguiasRequisicao")) {
                            modeloDados.setValueAt(multiguias, modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_ANEXO[i].equals("tipoIntegracaoEntreFiliais")) {
                            modeloDados.setValueAt(Tipos.tipoIntegracao(tipoIntegracao), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_ANEXO[i].equals("codigoCBOMedico")) {
                            String codigo = StringUtil.getValor(rs.getString(Impressao.CAMPOS_ANEXO[i]), "cbo");
                            if (Funcoes.textoVazio(codigo)) continue;
                            codigo = StringUtil.getValor(codigo, "codigo");
                            modeloDados.setValueAt(codigo, modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_ANEXO[i].equals("descricaoCBOMedico")) {
                            String descricao = StringUtil.getValor(rs.getString(Impressao.CAMPOS_ANEXO[i]), "cbo");
                            if (Funcoes.textoVazio(descricao)) continue;
                            descricao = StringUtil.getValor(descricao, "descricao");
                            modeloDados.setValueAt(descricao, modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_ANEXO[i].equals("quantidadeExameSemMaterial")) {
                            modeloDados.setValueAt(qtdeExames, modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_ANEXO[i].equals("idadeRequisicaoPaciente")) {
                            modeloDados.setValueAt(Funcoes.getIntervaloParaString((PGInterval)rs.getObject(Impressao.CAMPOS_ANEXO[i]), null), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_ANEXO[i].equals("perguntasRequisicao")) {
                            if (Funcoes.textoVazio(rs.getString("perguntasRequisicao"))) continue;
                            Map<String, Object> respostasRequisicao = Resultado.getCamposResultado(rs.getString("perguntasRequisicao"));
                            for (Map.Entry<String, Object> resposta : respostasRequisicao.entrySet()) {
                                if (modeloDados.findColumn(resposta.getKey()) <= -1) continue;
                                modeloDados.setValueAt(resposta.getValue(), modeloDados.getRowCount() - 1, modeloDados.findColumn(resposta.getKey()));
                            }
                            continue;
                        }
                        modeloDados.setValueAt(rs.getObject(Impressao.CAMPOS_ANEXO[i]), modeloDados.getRowCount() - 1, i);
                    }
                    for (int j = 0; j < QTDE_CAMPOS_ANEXO; ++j) {
                        if (ADICIONAIS_ANEXO[j].indexOf("ambExame") > -1) {
                            modeloDados.setValueAt(Impressao.pegaAMB(st, filial, rs.getString("codigoExame"), rs.getString("codigoMaterial"), rs.getString("codigoConvenio"), rs.getString("codigoMetodo"), precoMetodologia), modeloDados.getRowCount() - 1, ultimaPosicao++);
                            continue;
                        }
                        if (ADICIONAIS_ANEXO[j].indexOf("descricaoSituacaoExame") > -1) {
                            modeloDados.setValueAt(Tipos.tipoSituacaoExame(rs.getString("descricaoSituacaoExame")), modeloDados.getRowCount() - 1, ultimaPosicao++);
                            continue;
                        }
                        if (ADICIONAIS_ANEXO[j].indexOf("valorExameConvenio") > -1) {
                            modeloDados.setValueAt(ExameUtil.calculaPrecoExameConvenio(st, filial, rs.getString("codigoExame"), rs.getInt("codigoMaterial"), rs.getInt("codigoConvenio"), Integer.parseInt(requisicao), null, rs.getInt("codigoMetodo"), precoMetodologia, arredondamentoPrecoExame, parametrosCasasPrecoExame), modeloDados.getRowCount() - 1, ultimaPosicao++);
                            continue;
                        }
                        if (ADICIONAIS_ANEXO[j].indexOf("quantidadeExameSemMaterial") > -1) {
                            modeloDados.setValueAt(qtdeExames, modeloDados.getRowCount() - 1, ultimaPosicao++);
                            continue;
                        }
                        modeloDados.setValueAt(rs.getObject(ADICIONAIS_ANEXO[j]), modeloDados.getRowCount() - 1, ultimaPosicao++);
                    }
                } while (rs.next());
            } else {
                boolean fimTabela = false;
                while (!fimTabela) {
                    void var39_49;
                    modeloDados.addLine(new Object[modeloDados.getColumnCount()]);
                    if (!hash.isEmpty()) {
                        Set<String> set = hash.keySet();
                        for (String s : set) {
                            Iterator<Map.Entry<String, Object>> value = hash.get(s);
                            int pos = modeloDados.findColumn(s);
                            if (pos <= -1) continue;
                            modeloDados.setValueAt(value, modeloDados.getRowCount() - 1, pos);
                        }
                    }
                    int linhaModelo = modeloDados.getRowCount() - 1;
                    boolean bl = false;
                    while (var39_49 < Impressao.CAMPOS_ANEXO.length) {
                        if (DBUtil.campoNull(rs.getString(Impressao.CAMPOS_ANEXO[var39_49]))) {
                            modeloDados.setValueAt("", linhaModelo, (int)var39_49);
                        } else if (Impressao.CAMPOS_ANEXO[var39_49].equals("tipoLogradouroPaciente") || Impressao.CAMPOS_ANEXO[var39_49].equals("tipoLogradouroEnderecoCobranca") || Impressao.CAMPOS_ANEXO[var39_49].equals("tipoLogradouroMedico") || Impressao.CAMPOS_ANEXO[var39_49].equals("tipoLogradouroResponsavelRequisicao") || Impressao.CAMPOS_ANEXO[var39_49].equals("tipoLogradouroConvenio")) {
                            modeloDados.setValueAt(Tipos.tipoLogradouroDescricao(rs.getString(Impressao.CAMPOS_ANEXO[var39_49])), linhaModelo, (int)var39_49);
                        } else if (Impressao.CAMPOS_ANEXO[var39_49].equals("sexoPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoSexo(rs.getString(Impressao.CAMPOS_ANEXO[var39_49])), linhaModelo, (int)var39_49);
                        } else if (Impressao.CAMPOS_ANEXO[var39_49].equals("corPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoCor(rs.getString(Impressao.CAMPOS_ANEXO[var39_49])), linhaModelo, (int)var39_49);
                        } else if (Impressao.CAMPOS_ANEXO[var39_49].equalsIgnoreCase("estadoCivilPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoEstadoCivil(rs.getString(Impressao.CAMPOS_ANEXO[var39_49])), linhaModelo, (int)var39_49);
                        } else if (Impressao.CAMPOS_ANEXO[var39_49].equalsIgnoreCase("tipoUltimoPagamentoRequisicao")) {
                            modeloDados.setValueAt(Tipos.tipoPagamento(rs.getString(Impressao.CAMPOS_ANEXO[var39_49])), linhaModelo, (int)var39_49);
                        } else if (Impressao.CAMPOS_ANEXO[var39_49].equals("datasEntregaParcialRequisicao")) {
                            modeloDados.setValueAt(datasParciais, linhaModelo, (int)var39_49);
                        } else if (Impressao.CAMPOS_ANEXO[var39_49].equals("existeExamesSemMaterial")) {
                            modeloDados.setValueAt(semMaterial, linhaModelo, (int)var39_49);
                        } else if (Impressao.CAMPOS_ANEXO[var39_49].equals("multiguiasRequisicao")) {
                            modeloDados.setValueAt(multiguias, linhaModelo, (int)var39_49);
                        } else if (Impressao.CAMPOS_ANEXO[var39_49].equals("tipoIntegracaoEntreFiliais")) {
                            modeloDados.setValueAt(Tipos.tipoIntegracao(tipoIntegracao), linhaModelo, (int)var39_49);
                        } else if (Impressao.CAMPOS_ANEXO[var39_49].equals("codigoCBOMedico")) {
                            String codigo = StringUtil.getValor(rs.getString(Impressao.CAMPOS_ANEXO[var39_49]), "cbo");
                            if (!Funcoes.textoVazio(codigo)) {
                                codigo = StringUtil.getValor(codigo, "codigo");
                                modeloDados.setValueAt(codigo, linhaModelo, (int)var39_49);
                            }
                        } else if (Impressao.CAMPOS_ANEXO[var39_49].equals("descricaoCBOMedico")) {
                            String descricao = StringUtil.getValor(rs.getString(Impressao.CAMPOS_ANEXO[var39_49]), "cbo");
                            if (!Funcoes.textoVazio(descricao)) {
                                descricao = StringUtil.getValor(descricao, "descricao");
                                modeloDados.setValueAt(descricao, linhaModelo, (int)var39_49);
                            }
                        } else if (Impressao.CAMPOS_ANEXO[var39_49].equals("quantidadeExameSemMaterial")) {
                            modeloDados.setValueAt(qtdeExames, linhaModelo, (int)var39_49);
                        } else if (Impressao.CAMPOS_ANEXO[var39_49].equals("idadeRequisicaoPaciente")) {
                            modeloDados.setValueAt(Funcoes.getIntervaloParaString((PGInterval)rs.getObject(Impressao.CAMPOS_ANEXO[var39_49]), null), modeloDados.getRowCount() - 1, (int)var39_49);
                        } else if (Impressao.CAMPOS_ANEXO[var39_49].equals("perguntasRequisicao")) {
                            if (!Funcoes.textoVazio(rs.getString("perguntasRequisicao"))) {
                                Map<String, Object> respostasRequisicao = Resultado.getCamposResultado(rs.getString("perguntasRequisicao"));
                                for (Map.Entry<String, Object> resposta : respostasRequisicao.entrySet()) {
                                    if (modeloDados.findColumn(resposta.getKey()) <= -1) continue;
                                    modeloDados.setValueAt(resposta.getValue(), modeloDados.getRowCount() - 1, modeloDados.findColumn(resposta.getKey()));
                                }
                            }
                        } else {
                            modeloDados.setValueAt(rs.getObject(Impressao.CAMPOS_ANEXO[var39_49]), linhaModelo, (int)var39_49);
                        }
                        ++var39_49;
                    }
                    while (contador <= qtdeExamesCC) {
                        for (int i = 0; i < QTDE_CAMPOS_ANEXO; ++i) {
                            if (ADICIONAIS_ANEXO[i].indexOf("ambExame") > -1) {
                                modeloDados.setValueAt(fimTabela ? "" : Impressao.pegaAMB(st, filial, rs.getString("codigoExame"), rs.getString("codigoMaterial"), rs.getString("codigoConvenio"), rs.getString("codigoMetodo"), precoMetodologia), linhaModelo, ultimaPosicao++);
                                continue;
                            }
                            if (ADICIONAIS_ANEXO[i].indexOf("descricaoSituacaoExame") > -1) {
                                modeloDados.setValueAt(fimTabela ? "" : Tipos.tipoSituacaoExame(rs.getString("descricaoSituacaoExame")), linhaModelo, ultimaPosicao++);
                                continue;
                            }
                            if (ADICIONAIS_ANEXO[i].indexOf("valorExameConvenio") > -1) {
                                modeloDados.setValueAt(fimTabela ? "" : ExameUtil.calculaPrecoExameConvenio(st, filial, rs.getString("codigoExame"), rs.getInt("codigoMaterial"), rs.getInt("codigoConvenio"), Integer.parseInt(requisicao), null, rs.getInt("codigoMetodo"), precoMetodologia, arredondamentoPrecoExame, parametrosCasasPrecoExame), linhaModelo, ultimaPosicao++);
                                continue;
                            }
                            if (ADICIONAIS_ANEXO[i].indexOf("quantidadeExameSemMaterial") > -1) {
                                modeloDados.setValueAt(qtdeExames, linhaModelo, ultimaPosicao++);
                                continue;
                            }
                            modeloDados.setValueAt(fimTabela ? "" : rs.getObject(ADICIONAIS_ANEXO[i]), linhaModelo, ultimaPosicao++);
                        }
                        fimTabela = !rs.next();
                        ++contador;
                    }
                    if (fimTabela) continue;
                    contador = 1;
                    ultimaPosicao = Impressao.CAMPOS_ANEXO.length;
                }
            }
            int colunas = colunasRodapeComprovante;
            if (colunas > 1) {
                void var39_51;
                ArrayList listaRodape = ImprimirAnexo.criaRodape(filial, requisicao, st, filialPadrao, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo);
                boolean bl = true;
                while (var39_51 <= colunas) {
                    if (var39_51 <= listaRodape.size()) {
                        String[] c = (String[])listaRodape.get((int)(var39_51 - true));
                        for (int j = 0; j < QTDE_CAMPOS_RODAPE_ANEXO; ++j) {
                            if (ADICIONAIS_RODAPE_ANEXO[j].equals("codigoTuboRodape")) {
                                modeloDados.setValueAt(c[0], 0, ultimaPosicao++);
                                continue;
                            }
                            if (ADICIONAIS_RODAPE_ANEXO[j].equals("codigosExamesRodape")) {
                                modeloDados.setValueAt(c[1], 0, ultimaPosicao++);
                                continue;
                            }
                            if (ADICIONAIS_RODAPE_ANEXO[j].equals("codigoMaterialRodape")) {
                                modeloDados.setValueAt(c[2], 0, ultimaPosicao++);
                                continue;
                            }
                            if (ADICIONAIS_RODAPE_ANEXO[j].equals("nomePacienteRodape")) {
                                modeloDados.setValueAt(c[9], 0, ultimaPosicao++);
                                continue;
                            }
                            if (ADICIONAIS_RODAPE_ANEXO[j].equals("nomeSocialPacienteRodape")) {
                                modeloDados.setValueAt(c[11], 0, ultimaPosicao++);
                                continue;
                            }
                            if (ADICIONAIS_RODAPE_ANEXO[j].equals("descricaoMaterialRodape")) {
                                modeloDados.setValueAt(c[3], 0, ultimaPosicao++);
                                continue;
                            }
                            if (ADICIONAIS_RODAPE_ANEXO[j].equals("abreviaturaMaterialRodape")) {
                                modeloDados.setValueAt(c[4], 0, ultimaPosicao++);
                                continue;
                            }
                            if (ADICIONAIS_RODAPE_ANEXO[j].equals("codigoRequisicaoRodape")) {
                                modeloDados.setValueAt(c[8], 0, ultimaPosicao++);
                                continue;
                            }
                            if (ADICIONAIS_RODAPE_ANEXO[j].equals("descricaoRecipienteRodape")) {
                                modeloDados.setValueAt(c[10], 0, ultimaPosicao++);
                                continue;
                            }
                            if (ADICIONAIS_RODAPE_ANEXO[j].equals("quantidadeExameSemMaterial")) {
                                modeloDados.setValueAt(qtdeExames, 0, ultimaPosicao++);
                                continue;
                            }
                            modeloDados.setValueAt("", 0, ultimaPosicao++);
                        }
                    }
                    ++var39_51;
                }
            }
            Impressao.adicionaMedicamento(filial, requisicao, modeloDados, st);
            ImprimirAnexo.preencheCamposAgendamento(modeloDados, filial, requisicao, st);
            Gerador gerador = new Gerador(parametrosCasasPrecoExame, arredondamentoPrecoExame);
            if (!isColetaWeb) {
                gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraAnexo")));
            }
            String string = ExameUtil.getCodigoLayout(filial, codigoConvenio, codigoDestino, st, codigoLayoutPadrao);
            StringBuilder buf = new StringBuilder();
            buf.append("select lay_anexo, lay_tipoanexo from layout where fil_codigo = ");
            buf.append(filial);
            buf.append(" and lay_codigo = ");
            buf.append(string);
            ResultSet rsLayout = st.executeQuery(buf.toString());
            if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("lay_anexo")) && (rsLayout.getString("lay_tipoanexo").equals("C") && !Gerador.vazio(rsLayout.getString("lay_anexo")) || rsLayout.getString("lay_tipoanexo").equals("D") && !Relatorio.vazio(rsLayout.getString("lay_anexo")))) {
                String impressora = "";
                if (!isColetaWeb) {
                    impressora = Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraAnexo"));
                }
                if (rsLayout.getString("lay_tipoanexo").equals("C")) {
                    if (!isColetaWeb) {
                        gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(impressora));
                    }
                    String layAnexo = rsLayout.getString("lay_anexo");
                    gerador.executar(layAnexo, modeloDados, null, false, true, isColetaWeb);
                    if (isColetaWeb) {
                        return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), layAnexo);
                    }
                } else {
                    Relatorio rel = new Relatorio();
                    rel.setCabecalhoRodape(rsLayout.getString("lay_anexo"), modeloDados);
                    for (int i = 0; i < modeloDados.getRowCount(); ++i) {
                        rel.addItem(modeloDados.getLine(i));
                    }
                    ImpressaoRelatorio ip = new ImpressaoRelatorio(impressora);
                    if (ip.imprimir(rel) && ParametrosLocais.getParametro("impressaoLaserMapa") != null && ParametrosLocais.getParametro("impressaoFinalizarMapa") != null && ParametrosLocais.getParametro("impressaoLaserMapa").equalsIgnoreCase("1") && ParametrosLocais.getParametro("impressaoFinalizarMapa").equalsIgnoreCase("1") && !rel.isCupom()) {
                        ip.terminar();
                    }
                }
            } else {
                Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
            }
            rsLayout.close();
        }
        rs.close();
        st.close();
        st2.close();
        st3.close();
        return new byte[0];
    }

    private static String getSql(String filial, String requisicao, boolean isAlimentos, boolean ordenarSetor, String ordemComprovante) {
        StringBuilder subQuerryNumeroNotaFiscal = new StringBuilder();
        subQuerryNumeroNotaFiscal.append(" (select numeroNotaFiscal from (select");
        subQuerryNumeroNotaFiscal.append(" case\twhen nota.nfi_numero is not null and  nota.nfi_situacao = 'A' then nota.nfi_numero ");
        subQuerryNumeroNotaFiscal.append(" when nfat.nfi_numero is not null and  nfat.nfi_situacao = 'A' then nfat.nfi_numero ");
        subQuerryNumeroNotaFiscal.append(" else null ");
        subQuerryNumeroNotaFiscal.append(" end as numeroNotaFiscal ");
        subQuerryNumeroNotaFiscal.append(" from requisicao a ");
        subQuerryNumeroNotaFiscal.append(" left join faturarequisicao freq on ");
        subQuerryNumeroNotaFiscal.append(" a.fil_codigo = freq.fil_codigo ");
        subQuerryNumeroNotaFiscal.append(" and a.req_codigo = freq.req_codigo ");
        subQuerryNumeroNotaFiscal.append(" left join faturanotafiscal fatnota on ");
        subQuerryNumeroNotaFiscal.append(" freq.fil_codigo = fatnota.fil_codigo ");
        subQuerryNumeroNotaFiscal.append(" and freq.fat_codigo = fatnota.fat_codigo ");
        subQuerryNumeroNotaFiscal.append(" left join requisicaonotafiscal reqnf on ");
        subQuerryNumeroNotaFiscal.append(" a.fil_codigo = reqnf.fil_codigo ");
        subQuerryNumeroNotaFiscal.append(" and a.req_codigo = reqnf.req_codigo ");
        subQuerryNumeroNotaFiscal.append(" left join notafiscal nota on ");
        subQuerryNumeroNotaFiscal.append(" nota.fil_codigo = reqnf.fil_codigo ");
        subQuerryNumeroNotaFiscal.append(" and nota.nfi_codigo = reqnf.nfi_codigo left join notafiscal nfat on ");
        subQuerryNumeroNotaFiscal.append(" fatnota.fil_codigo = nfat.fil_codigo and fatnota.nfi_codigo = nfat.nfi_codigo\twhere a.req_codigo = ");
        subQuerryNumeroNotaFiscal.append(requisicao);
        subQuerryNumeroNotaFiscal.append(" ) as numeroNotaFIscal where numeroNotaFiscal is not null and a.fil_codigo = ");
        subQuerryNumeroNotaFiscal.append(filial + " ");
        StringBuilder buf = new StringBuilder("");
        buf.append("select a.req_codigo as codigoRequisicao, a.req_data as dataRequisicao, a.req_dtfatura as dataFaturaRequisicao, a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,");
        buf.append(subQuerryNumeroNotaFiscal + "), ");
        buf.append("a.req_responsavel as responsavelPacienteRequisicao, a.req_cpfresponsavel as cpfResponsavelPacienteRequisicao, a.req_incapacitado as incapacitadoPacienteRequisicao,");
        buf.append("j.pac_responsavel as responsavelPaciente, j.pac_cpfresponsavel as cpfResponsavelPaciente, j.pac_incapacitado as incapacitadoPaciente,");
        buf.append("a.req_dclinicos as dadosClinicosRequisicao, a.req_obs as obsRequisicao, a.req_totpago as totalPagoRequisicao, a.req_horaentregaprev as horaEntregaRequisicao, a.req_total as totalRequisicao,");
        buf.append("a.req_horafatura as horaFaturaRequisicao, a.req_hora as horaRequisicao, a.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, a.req_idade as idadeRequisicao, a.req_anomes as anoMesRequisicao,");
        buf.append("a.req_matricula as matriculaRequisicao, a.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequisicao, a.req_titular as titularRequisicao, a.req_peso as pesoRequisicao,");
        buf.append("a.req_altura as alturaRequisicao, a.req_desconto as descontoRequisicao, a.req_vlrdesconto as valorDescontoRequisicao,");
        buf.append("a.req_acrescimo as acrescimoRequisicao, a.req_vlracrescimo as valorAcrescimoRequisicao, a.req_notacaixa as notaCaixaRequisicao, ");
        buf.append("a.req_vlrexames as valorExamesRequisicao, a.req_vlrmateriais as valorMateriaisRequisicao, a.req_guia as guiaRequisicao, a.req_guiaprincipal as guiaPrincipalRequisicao, ");
        buf.append("a.sit_codigo as codigoSituacao, g.sit_descricao as descricaoSituacao, a.req_tipoultpagamento as tipoUltimoPagamentoRequisicao,");
        buf.append("a.req_imprimirseparado as imprimirSeparadoRequisicao, '' as datasEntregaParcialRequisicao, a.req_prontuario as prontuarioRequisicao, ");
        buf.append("a.req_complementodestino as complementoDestinoRequisicao, '' as multiguiasRequisicao, a.req_cartaosus as cartaoSUSRequisicao, ");
        buf.append("a.usr_codigo as codigoUsuario, h.usr_nome as nomeUsuario, h.usr_assinatura as assinaturaUsuario,");
        buf.append("a.usr_codabertura as codigoUsuarioAbertura, ab.usr_nome as nomeUsuarioAbertura, ab.usr_assinatura as assinaturaUsuarioAbertura,");
        buf.append("k.cid_codigo as codigoCidadeConvenio, k.cid_nome as descricaoCidadeConvenio, k.cid_uf as estadoCidadeConvenio,");
        buf.append("l.cid_codigo as codigoCidadeMedico, l.cid_nome as descricaoCidadeMedico, l.cid_uf as estadoCidadeMedico,");
        buf.append("m.cid_codigo as codigoCidadeDestino, m.cid_nome as descricaoCidadeDestino, m.cid_uf as estadoCidadeDestino,");
        buf.append("n.cid_codigo as codigoCidadeColeta, n.cid_nome as descricaoCidadeColeta, n.cid_uf as estadoCidadeColeta,");
        buf.append("o.cid_codigo as codigoCidadePaciente, o.cid_nome as descricaoCidadePaciente, o.cid_uf as estadoCidadePaciente,");
        buf.append("p.bai_codigo as codigoBairroConvenio, p.bai_descricao as descricaoBairroConvenio,");
        buf.append("q.bai_codigo as codigoBairroMedico, q.bai_descricao as descricaoBairroMedico,");
        buf.append("r.bai_codigo as codigoBairroDestino, r.bai_descricao as descricaoBairroDestino,");
        buf.append("s.bai_codigo as codigoBairroColeta, s.bai_descricao as descricaoBairroColeta, false as existeExamesSemMaterial,");
        buf.append("t.bai_codigo as codigoBairroPaciente, t.bai_descricao as descricaoBairroPaciente,");
        buf.append("a.des_codigo as codigoDestino, e.des_descricao as descricaoDestino, e.des_endereco as enderecoDestino, e.des_complemento as complementoDestino,e.des_cep as cepDestino, e.des_fone as foneDestino, e.des_enviarweb as enviarParaWebDestino, ");
        buf.append("a.col_codigo as codigoColeta, f.col_descricao as descricaoColeta, f.col_endereco as enderecoColeta, f.col_complemento as complementoColeta, f.col_cep as cepColeta, f.col_fone as foneColeta,");
        buf.append("a.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial,");
        buf.append("cidfilial.cid_codigo as codigoCidadeFilial, cidfilial.cid_nome as descricaoCidadeFilial, cidfilial.cid_uf as estadoCidadeFilial,");
        buf.append("baifilial.bai_codigo as codigoBairroFilial, baifilial.bai_descricao as descricaoBairroFilial,");
        buf.append("filial.fil_integrar as integracaoEntreFiliais, '' as tipoIntegracaoEntreFiliais, ");
        buf.append("d.med_crm as conselhoMedico, d.med_crm as crmMedico, d.med_uf as estadoCrmMedico, d.med_nome as nomeMedico, d.med_abrev as tratamentoMedico, d.med_endereco as enderecoMedico, d.med_numeroendereco as numeroEnderecoMedico, d.med_tipologradouroendereco as tipoLogradouroMedico, d.med_complemento as complementoMedico, d.med_cep as cepMedico, d.med_fone as foneMedico, d.med_celular as celularMedico, d.med_fax as faxMedico, d.med_email as emailMedico, d.med_site as siteMedico,");
        buf.append("d.med_cbo as codigoCBOMedico, d.med_cbo as descricaoCBOMedico, operadora.mec_codigooperadora as codigoOperadoraMedico, ");
        buf.append("c.con_codigo as codigoConvenio, c.con_fantasia as fantasiaConvenio, c.con_razao as razaoSocialConvenio, c.con_endereco as enderecoConvenio, c.con_numeroendereco as numeroEnderecoConvenio, c.con_tipologradouroendereco as tipoLogradouroConvenio, c.con_complemento as complementoConvenio, c.con_cep as cepConvenio, c.con_fone as foneConvenio, c.con_email1 as email1Convenio, c.con_email2 as email2Convenio, c.con_site as siteConvenio, (c.con_cobrexame is not null and c.con_cobrexame = true and c.con_percpgto is not null and c.con_percpgto > 0) as cobraExameBalcaoConvenio, ");
        buf.append("conrepasse.con_codigo as codigoConvenioRepasse, conrepasse.con_fantasia as fantasiaConvenioRepasse, conrepasse.con_razao as razaoSocialConvenioRepasse, conrepasse.con_endereco as enderecoConvenioRepasse, conrepasse.con_complemento as complementoConvenioRepasse, conrepasse.con_cep as cepConvenioRepasse, conrepasse.con_fone as foneConvenioRepasse, conrepasse.con_email1 as email1ConvenioRepasse, conrepasse.con_email2 as email2ConvenioRepasse, conrepasse.con_site as siteConvenioRepasse,");
        buf.append("j.pac_codigo as codigoPaciente, j.pac_nome as nomePaciente, j.pac_sexo as sexoPaciente, j.pac_datanasc as dataNascimentoPaciente, j.pac_grpsangue as grupoSanguineoPaciente, j.pac_fatorrh as fatorRHPaciente, j.pac_fatordu as fatorDUPaciente, j.pac_cor as corPaciente,");
        buf.append("j.pac_profissao as profissaoPaciente, j.pac_rg as rgPaciente, j.pac_cpf as cpfPaciente, j.pac_estcivil as estadoCivilPaciente, j.pac_dum as dumPaciente, j.pac_fone as fonePaciente, j.pac_celular as celularPaciente, j.pac_fax as faxPaciente, j.pac_fonecomercial as foneComercialPaciente,");
        buf.append("j.pac_endereco as enderecoPaciente,j.pac_numeroendereco as numeroEnderecoPaciente, j.pac_tipologradouroendereco as tipoLogradouroPaciente, j.pac_complemento as complementoPaciente, j.pac_cep as cepPaciente, j.pac_email as emailPaciente, j.pac_fonecontato as foneContatoPaciente, j.pac_nomecontato as contatoPaciente, b.exr_vlrch as valorCH,");
        buf.append("j.pac_nomepagador as nomePagadorPaciente, j.pac_cpfpagador as cpfPagadorPaciente, ");
        buf.append("j.pac_senhaweb as senhaWebPaciente, b.exr_vlrexame as valorExameConvenio, j.pac_codigoapoiado as codigoApoiadoPaciente, ");
        buf.append("b.exa_codigo as codigoExame, w.exa_descricao as descricaoExame, b.exr_vlrchexame as ambExame, b.exr_vlrchexame as chExame, b.exr_vlrexame as valorExame,b.exr_vlrmaterial as valorMateriaisExame, b.exr_situacao as situacaoExame, '' as descricaoSituacaoExame, ");
        buf.append("w.exa_soa as soaExame, w.exa_coa as coaExame, w.exa_inmetro as certificadoInmetroExame, ");
        buf.append("v.mco_descricao as descricaoMaterial, v.mco_codigo as codigoMaterial, v.mco_abreviatura as abreviaturaMaterial, b.exr_datamaterial as dataColetaExame, b.exr_datamaterial as horaColetaExame, ");
        buf.append("coalesce(b.exr_urgente, false) as urgenteExame, b.exr_matexterno as materialExternoExame, ");
        buf.append("b.usr_codmaterial as usuarioColetaExame, prazo.prz_descricao as descricaoPrazo, prazo.prz_codigo as codigoPrazo, metodo.met_codigo as codigoMetodo, ");
        buf.append("metodo.met_descricao as descricaoMetodo, b.exr_descricaomaterial as materialInformadoExame, b.exr_dataentregaprev as dataEntregaExame, b.exr_dataentregaprev as horaEntregaExame, ");
        buf.append("b.exr_codautorizacao as autorizacaoExame, CASE WHEN b.exr_intervaloJejum is null then TO_CHAR(b.exr_tempoJejum,'HH24:MI:SS') else TO_CHAR(b.exr_intervaloJejum,'HH24:MI:SS') end as tempoJejumExame, b.exr_motivoprazo as observacaoPrazoCarenciaExame, ");
        buf.append("b.exr_valorcusto as custoCBHPMExame, b.exr_valoruco as ucoCBHPMExame, b.exr_valorporte as valorPorteCBHPMExame, b.exr_porte as porteCHBPMExame, ");
        buf.append("exmsetor.set_codigo as codigoSetorExame, setores.set_descricao as descricaoSetorExame, setores.set_sigla as abreviaturaSetorExame, ");
        buf.append("a.req_quarto as quartoRequisicao, a.req_leito as leitoRequisicao, a.ala_codigo as codigoAla, ala.ala_descricao as descricaoAla, ");
        buf.append("tpe.tpe_codigo as codigoTabelaPreco, tpe.tpe_descricao as descricaoTabelaPreco, tpe.tpe_moeda as moedaTabelaPreco, ");
        buf.append("a.req_descricaoproduto as descricaoProdutoRequisicao, ");
        buf.append("a.req_datafabricacao as dataFabricacaoProdutoRequisicao, ");
        buf.append("a.req_numeroregistroproduto as numeroRegistroProdutoRequisicao, ");
        buf.append("a.req_temperaturacoletaproduto as temperaturaColetaProdutoRequisicao, ");
        buf.append("a.req_numeroloteproduto as numeroLoteProdutoRequisicao, ");
        buf.append("a.req_datavalidade as dataValidadeProdutoRequisicao, ");
        buf.append("a.req_marcaproduto as marcaProdutoRequisicao, ");
        buf.append("a.req_datacoletaproduto as dataColetaProdutoRequisicao, ");
        buf.append("a.req_horacoletaproduto as horaColetaProdutoRequisicao, ");
        buf.append("a.req_lacreproduto as lacreProdutoRequisicao, ");
        buf.append("a.req_lacreprodutocontra as lacreContraProvaProdutoRequisicao, ");
        buf.append("a.req_lacreprodutocontraempresa as lacreContraProvaEmpresaProdutoRequisicao, ");
        buf.append("a.req_doctoreferenciaproduto as documentoReferenciaProdutoRequisicao, ");
        buf.append("a.req_temperaturarecebimento as temperaturaRecebimentoProdutoRequisicao, ");
        buf.append("a.req_sanitariasproduto as caracteristicasSanitariasProdutoRequisicao, ");
        buf.append("a.req_condicoesambproduto as condicoesAmbientaisProdutoRequisicao, ");
        buf.append("a.req_procedimentocoletaproduto as procedimentoColetaProdutoRequisicao, ");
        buf.append("a.req_tiporecebimentoproduto as tipoRecebimentoProdutoRequisicao, ");
        buf.append("a.req_partidaproduto as partidaProdutoRequisicao, ");
        buf.append("a.req_qtdeamostraproduto as qtdeAmostrasProdutoRequisicao, ");
        buf.append("a.req_qtdeunidadeproduto as qtdeUnidadeProdutoRequisicao, ");
        buf.append("a.req_anoprpproduto as anoPRPProdutoRequisicao, a.req_cicloprpproduto as cicloPRPProdutoRequisicao, ");
        buf.append("a.req_amostraprpproduto as amostraPRPProdutoRequisicao, a.req_amostrasupprpproduto as amostraSupervisaoPRPProdutoRequisicao, ");
        buf.append("a.req_horainicioturnoprpproduto as horaInicioTurnoPRPProdutoRequisicao, a.req_linhaprpproduto as linhaPRPProdutoRequisicao, ");
        buf.append("a.req_volumeabateprpproduto as volumeAbatePRPProdutoRequisicao, a.req_turnoprpproduto as turnoPRPProdutoRequisicao, ");
        if (isAlimentos) {
            buf.append("pal.pal_codigo as codigoProdutoAlimento, ");
            buf.append("pal.pal_descricao as descricaoProdutoAlimento, ");
            buf.append("cpl.cpl_codigo as codigoCategoriaProdutoAlimento, ");
            buf.append("cpl.cpl_descricao as descricaoCategoriaProdutoAlimento, ");
        } else {
            buf.append("'' as codigoProdutoAlimento, ");
            buf.append("'' as descricaoProdutoAlimento, ");
            buf.append("'' as codigoCategoriaProdutoAlimento, ");
            buf.append("'' as descricaoCategoriaProdutoAlimento, ");
        }
        buf.append("a.req_areaproduto as areaProdutoRequisicao, ");
        buf.append("a.unm_codigo as codigoUnidadeProdutoRequisicao, ");
        buf.append("a.req_nomeplano as nomeDoPlano,");
        buf.append("unidademedida.unm_descricao as descricaoUnidadeProdutoRequisicao, ");
        buf.append("a.emb_codigo as codigoEmbalagemProdutoRequisicao, ");
        buf.append("emb.emb_descricao as descricaoEmbalagemProdutoRequisicao, ");
        buf.append("paccontatos.pco_nome as nomeResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_cargo as cargoResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_email as emailResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_fone as foneResponsavelRequisicao_, ");
        buf.append("ent.ent_fantasia as nomeResponsavelRequisicao, ");
        buf.append("ent.ent_cargo as cargoResponsavelRequisicao, ");
        buf.append("ent.ent_email as emailResponsavelRequisicao, ");
        buf.append("ent.ent_fone as foneResponsavelRequisicao, ");
        buf.append("ent.ent_razaosocial as razaoSocialResponsavelRequisicao, ");
        buf.append("ent.ent_endereco as enderecoResponsavelRequisicao, ");
        buf.append("ent.ent_tipologradouroendereco as tipoLogradouroResponsavelRequisicao, ");
        buf.append("ent.ent_numeroendereco as numeroEnderecoResponsavelRequisicao, ");
        buf.append("ent.ent_complemento as complementoResponsavelRequisicao, ");
        buf.append("ent.ent_cep as cepResponsavelRequisicao, ");
        buf.append("ent.ent_cpfcnpj as cpfCnpjResponsavelRequisicao, ");
        buf.append("cidentidade.cid_nome as descricaoCidadeResponsavelRequisicao, ");
        buf.append("cidentidade.cid_uf as estadoCidadeResponsavelRequisicao, ");
        buf.append("baientidade.bai_descricao as descricaoBairroResponsavelRequisicao, ");
        buf.append("entempresapaciente.ent_codigo as codigoEmpresaPaciente, entempresapaciente.ent_fantasia as fantasiaEmpresaPaciente, ");
        buf.append("entempresapaciente.ent_razaosocial as razaoSocialEmpresaPaciente, entempresapaciente.ent_fone as foneEmpresaPaciente, ");
        buf.append("a.req_datarecebimentoproduto as dataRecebimentoProdutoRequisicao, ");
        buf.append("a.req_horarecebimentoproduto as horaRecebimentoProdutoRequisicao, ");
        buf.append("a.req_localcoletaproduto as localColetaProdutoRequisicao, ");
        buf.append("a.req_nrsolicitacaoproduto as numeroSolicitacaoProdutoRequisicao, ");
        buf.append("a.req_fornecedorproduto as fornecedorProdutoRequisicao, ");
        buf.append("j.bai_codigocobranca as codigoBairroCobrancaPaciente, ");
        buf.append("baicobranca.bai_descricao as descricaoBairroCobrancaPaciente, ");
        buf.append("j.cid_codigocobranca as codigoCidadeCobrancaPaciente, ");
        buf.append("cidcobranca.cid_nome as descricaoCidadeCobrancaPaciente, ");
        buf.append("cidcobranca.cid_uf as estadoCidadeCobrancaPaciente, ");
        buf.append("j.pac_razaosocial as razaoSocialPaciente, ");
        buf.append("j.pac_cnpj as cnpjPaciente, ");
        buf.append("j.pac_ie as inscricaoEstadualPaciente, ");
        buf.append("j.pac_proprietario as proprietarioPaciente, ");
        buf.append("j.pac_sif as sifPaciente, ");
        buf.append("j.pac_tipologradouroendcobranca as tipoLogradouroCobrancaPaciente, ");
        buf.append("j.pac_enderecocobranca as enderecoCobrancaPaciente, ");
        buf.append("j.pac_numeroenderecocobranca as numeroEnderecoCobrancaPaciente, ");
        buf.append("j.pac_complementocobranca as complementoCobrancaPaciente, ");
        buf.append("j.pac_cepcobranca as cepCobrancaPaciente, ");
        buf.append("j.pac_fonecobranca as foneCobrancaPaciente, ");
        buf.append("j.pac_responsavelcobranca as responsavelCobrancaPaciente, ");
        buf.append("j.pac_pelagem as pelagemPaciente, ");
        buf.append("j.pac_cartaosus as cartaoSUSPaciente, ");
        buf.append("j.pac_fumante as fumantePaciente, ");
        buf.append("j.pac_diabetico as diabeticoPaciente, ");
        buf.append("j.pac_nomesocial as nomeSocialPaciente, ");
        buf.append("j.pac_whatsapp as whatsAppPaciente, ");
        buf.append("especie.epc_codigo as codigoEspecie, especie.epc_descricao as descricaoEspecie, especie.epc_cientifico as cientificoEspecie, ");
        buf.append("raca.rac_codigo as codigoRaca, raca.rac_descricao as descricaoRaca, raca.rac_cientifico as cientificoRaca, ");
        buf.append("us.uns_codigo as codigoUnidadeSaude, us.uns_descricao as descricaoUnidadeSaude, us.uns_endereco as enderecoUnidadeSaude, us.uns_complemento as complementoUnidadeSaude, us.uns_cep as cepUnidadeSaude, us.uns_fone as foneUnidadeSaude,");
        buf.append("cidadeus.cid_codigo as codigoCidadeUnidadeSaude, cidadeus.cid_nome as descricaoCidadeUnidadeSaude, cidadeus.cid_uf as estadoCidadeUnidadeSaude,");
        buf.append("bairrous.bai_codigo as codigoBairroUnidadeSaude, bairrous.bai_descricao as descricaoBairroUnidadeSaude, ");
        buf.append("pai.pai_codigo as codigoPais, pai.pai_nome as nomePais, a.req_datacertificadoalimentos as dataCertificado, ");
        buf.append("a.req_numerocertificadoalimentos as numeroCertificado, a.req_tcaalimentos as termoColetaAmostra, ");
        buf.append("a.req_totaltaxa as totalTaxaRequisicao, ");
        buf.append("'' as quantidadeExameSemMaterial, ");
        buf.append("a.req_procedencia as procedenciaRequisicao ");
        buf.append(", age(a.req_data, j.pac_datanasc) as idadeRequisicaoPaciente ");
        buf.append(", a.req_periodogestacional as periodoGestacionalRequisicao, j.pac_passaporte as passaportePaciente ");
        buf.append(", a.req_perguntas as perguntasRequisicao ");
        buf.append("from requisicao a ");
        buf.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        buf.append("left join convenios c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo ");
        buf.append("left join convenios conrepasse on a.fil_codigo = conrepasse.fil_codigo and a.con_codrepasse = conrepasse.con_codigo ");
        buf.append("left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and a.med_crm = d.med_crm and a.med_uf = d.med_uf ");
        buf.append("left join medicoconveniotiss operadora on a.fil_codigo = operadora.fil_codigo and a.med_conselho = operadora.med_conselho and a.med_crm = operadora.med_crm and a.med_uf = operadora.med_uf and a.con_codigo = operadora.con_codigo ");
        buf.append("left join destino e on a.fil_codigo = e.fil_codigo and upper(a.des_codigo) = upper(e.des_codigo) ");
        buf.append("left join coletas f on a.fil_codigo = f.fil_codigo and upper(a.col_codigo) = upper(f.col_codigo) ");
        buf.append("left join situacao g on a.fil_codigo = g.fil_codigo and a.sit_codigo = g.sit_codigo ");
        buf.append("left join usuario h on upper(a.usr_codigo) = upper(h.usr_codigo) ");
        buf.append("left join usuario ab on upper(a.usr_codabertura) = upper(ab.usr_codigo) ");
        buf.append("left join paciente j on a.fil_codigo = j.fil_codigo and a.pac_codigo = j.pac_codigo ");
        buf.append("left join cidades k on c.fil_codigo = k.fil_codigo and c.cid_codigo = k.cid_codigo ");
        buf.append("left join cidades l on d.fil_codigo = l.fil_codigo and d.cid_codigo = l.cid_codigo ");
        buf.append("left join cidades m on e.fil_codigo = m.fil_codigo and e.cid_codigo = m.cid_codigo ");
        buf.append("left join cidades n on f.fil_codigo = n.fil_codigo and f.cid_codigo = n.cid_codigo ");
        buf.append("left join cidades o on j.fil_codigo = o.fil_codigo and j.cid_codigo = o.cid_codigo ");
        buf.append("left join bairro p on c.fil_codigo = p.fil_codigo and c.bai_codigo = p.bai_codigo ");
        buf.append("left join bairro q on d.fil_codigo = q.fil_codigo and d.bai_codigo = q.bai_codigo ");
        buf.append("left join bairro r on e.fil_codigo = r.fil_codigo and e.bai_codigo = r.bai_codigo ");
        buf.append("left join bairro s on f.fil_codigo = s.fil_codigo and f.bai_codigo = s.bai_codigo ");
        buf.append("left join bairro t on j.fil_codigo = t.fil_codigo and j.bai_codigo = t.bai_codigo ");
        buf.append("left join examematcoleta u on b.fil_codigo = u.fil_codigo and upper(b.exa_codigo) = upper(u.exa_codigo) and b.mco_codigo = u.mco_codigo ");
        buf.append("left join materialcoleta v on u.fil_codigo = v.fil_codigo and u.mco_codigo = v.mco_codigo ");
        buf.append("left join exames w on b.fil_codigo = w.fil_codigo and upper(b.exa_codigo) = upper(w.exa_codigo) ");
        buf.append("left join examesetor exmsetor on w.fil_codigo = exmsetor.fil_codigo and upper(w.exa_codigo) = upper(exmsetor.exa_codigo) and exmsetor.ese_default = true ");
        buf.append("left join setores setores on exmsetor.fil_codigo = setores.fil_codigo and exmsetor.set_codigo = setores.set_codigo ");
        buf.append("left join prazoentrega prazo on u.fil_codigo = prazo.fil_codigo and u.prz_codigo = prazo.prz_codigo ");
        buf.append("left join metodologia metodo on b.fil_codigo = metodo.fil_codigo and b.met_codigo = metodo.met_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
        buf.append("left join cidades cidfilial on filial.fil_codigo = cidfilial.fil_codigo and filial.cid_codigo = cidfilial.cid_codigo ");
        buf.append("left join bairro baifilial on filial.fil_codigo = baifilial.fil_codigo and filial.bai_codigo = baifilial.bai_codigo ");
        buf.append("left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo ");
        buf.append("left join tabelaprecoexames tpe on c.fil_codigo = tpe.fil_codigo and c.tpe_codigo = tpe.tpe_codigo ");
        buf.append("left join unidademedida on a.fil_codigo = unidademedida.fil_codigo and a.unm_codigo = unidademedida.unm_codigo ");
        buf.append("left join pacientescontatos paccontatos on a.fil_codigo = paccontatos.fil_codigo and a.pac_codigo = paccontatos.pac_codigo and a.pco_codigo = paccontatos.pco_codigo ");
        buf.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
        buf.append("left join entidade entempresapaciente on j.fil_codigo = entempresapaciente.fil_codigo and j.ent_codempresa = entempresapaciente.ent_codigo ");
        buf.append("left join cidades cidcobranca on j.fil_codigo = cidcobranca.fil_codigo and j.cid_codigocobranca = cidcobranca.cid_codigo ");
        buf.append("left join bairro baicobranca on j.fil_codigo = baicobranca.fil_codigo and j.bai_codigocobranca = baicobranca.bai_codigo ");
        buf.append("left join embalagemproduto emb on a.fil_codigo = emb.fil_codigo and a.emb_codigo = emb.emb_codigo ");
        buf.append("left join unidadesaude us on a.fil_codigo = us.fil_codigo and a.uns_codigo = us.uns_codigo ");
        buf.append("left join cidades cidadeus on us.fil_codigo = cidadeus.fil_codigo and us.cid_codigo = cidadeus.cid_codigo ");
        buf.append("left join bairro bairrous on us.fil_codigo = bairrous.fil_codigo and us.bai_codigo = bairrous.bai_codigo ");
        buf.append("left join especie on j.fil_codigo = especie.fil_codigo and j.epc_codigo = especie.epc_codigo ");
        buf.append("left join raca on especie.fil_codigo = raca.fil_codigo and especie.epc_codigo = raca.epc_codigo and j.rac_codigo = raca.rac_codigo ");
        buf.append("left join cidades cidentidade on ent.fil_codigo = cidentidade.fil_codigo and ent.cid_codigo = cidentidade.cid_codigo ");
        buf.append("left join bairro baientidade on ent.fil_codigo = baientidade.fil_codigo and ent.bai_codigo = baientidade.bai_codigo ");
        buf.append("left join pais pai on a.pai_codigo = pai.pai_codigo and a.fil_codigo = pai.fil_codigo ");
        if (isAlimentos) {
            buf.append("left join produtoalimentos pal on a.fil_codigo = pal.fil_codigo and pal.pal_codigo = a.pal_codigo ");
            buf.append("left join categoriaprodutoalimentos cpl on a.fil_codigo = cpl.fil_codigo and a.cpl_codigo = cpl.cpl_codigo and cpl.cpl_codigo = pal.cpl_codigo ");
        }
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo = ");
        buf.append(requisicao);
        buf.append(" and (a.req_excluida = false or (a.req_excluida = true and a.req_origemagendamento = true)) and b.exr_excluido = false ");
        if (ordenarSetor) {
            buf.append(" and exmsetor.ese_default = true ");
        }
        buf.append(" order by ");
        if (ordemComprovante.equals("A")) {
            buf.append(" b.exr_ordem ");
        } else {
            if (ordenarSetor) {
                buf.append(" exmsetor.set_codigo, ");
            }
            buf.append(" a.req_codigo ");
            if (ordemComprovante.equals("C")) {
                buf.append(", b.exa_codigo");
            } else if (ordemComprovante.equals("P")) {
                buf.append(", u.emc_pagina, u.emc_ordem, b.exa_codigo, b.mco_codigo ");
            }
        }
        return buf.toString();
    }

    private static boolean isAlimentos() {
        return Variaveis.tipoFilialPadrao.equals("A");
    }

    public static String[] adicionaColunasAnexo(String[] campos, int qtdeExamesCC, int colunasRodapeComprovante) {
        int contador;
        int i;
        String[] medicamento = Impressao.getCamposMedicamento();
        String[] novo = new String[campos.length + QTDE_CAMPOS_ANEXO * qtdeExamesCC + QTDE_CAMPOS_RODAPE_ANEXO * colunasRodapeComprovante + medicamento.length];
        for (int i2 = 0; i2 < campos.length; ++i2) {
            novo[i2] = campos[i2];
        }
        int ultimaPosicao = campos.length;
        if (qtdeExamesCC <= 1) {
            for (i = 0; i < QTDE_CAMPOS_ANEXO; ++i) {
                novo[ultimaPosicao++] = ADICIONAIS_ANEXO[i];
            }
        } else {
            for (contador = 1; contador <= qtdeExamesCC; ++contador) {
                for (i = 0; i < QTDE_CAMPOS_ANEXO; ++i) {
                    novo[ultimaPosicao++] = ADICIONAIS_ANEXO[i] + String.valueOf(contador);
                }
            }
        }
        if (colunasRodapeComprovante <= 1) {
            for (i = 0; i < QTDE_CAMPOS_RODAPE_ANEXO; ++i) {
                novo[ultimaPosicao++] = ADICIONAIS_RODAPE_ANEXO[i];
            }
        } else {
            for (contador = 1; contador <= colunasRodapeComprovante; ++contador) {
                for (i = 0; i < QTDE_CAMPOS_RODAPE_ANEXO; ++i) {
                    novo[ultimaPosicao++] = ADICIONAIS_RODAPE_ANEXO[i] + String.valueOf(contador);
                }
            }
        }
        for (String s : medicamento) {
            novo[ultimaPosicao++] = s;
        }
        return novo;
    }

    private static ArrayList criaRodape(String filial, String requisicao, Statement statement, String filialPadrao, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo) throws SQLException {
        StringBuffer buf = new StringBuffer("select a.exa_codigo, c.rec_capacidade, b.rec_codigo, b.rco_qtde, b.rco_volume, ");
        buf.append("d.mco_abreviatura, d.mco_codigo, d.mco_descricao, a.req_codigo, f.pac_nome, f.pac_nomesocial, c.rec_descricao ");
        buf.append("from examerequisicao a ");
        buf.append("left join requisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo ");
        buf.append("left join paciente f on e.fil_codigo = f.fil_codigo and e.pac_codigo = f.pac_codigo ");
        buf.append("left join recipcoleta b on a.fil_codigo = b.fil_codigo and upper(a.exa_codigo) = upper(b.exa_codigo) and a.mco_codigo = b.mco_codigo ");
        buf.append("left join recipientes c on b.fil_codigo = c.fil_codigo and b.rec_codigo = c.rec_codigo ");
        buf.append("left join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo ");
        buf.append("left join examematcoleta g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo = ");
        buf.append(requisicao);
        buf.append(" order by b.rec_codigo, a.mco_codigo, b.rco_qtde, g.emc_pagina, g.emc_ordem, a.exa_codigo, a.mco_codigo ");
        ResultSet rsRodape = statement.executeQuery(buf.toString());
        ArrayList<String[]> lista = new ArrayList<String[]>();
        while (rsRodape.next()) {
            int qtde = DBUtil.campoNull(rsRodape.getString("rco_qtde")) ? 1 : rsRodape.getInt("rco_qtde");
            int pos = -1;
            for (int i = 0; i < qtde; ++i) {
                pos = ImprimirAnexo.localizar(0, rsRodape.getString("rec_codigo"), lista, 0);
                String codigoTubo = Funcoes.preencheZero(filialPadrao, digitosTuboFilial) + Funcoes.preencheZero(rsRodape.getString("req_codigo"), digitosTuboRequisicao) + Funcoes.preencheZero(DBUtil.campoNull(rsRodape.getString("rec_codigo")) ? "0" : rsRodape.getString("rec_codigo"), digitosTuboTubo);
                if (pos > -1) {
                    ImprimirAnexo.adicionaTubo(lista, pos, rsRodape.getString("rec_codigo"), rsRodape.getString("exa_codigo"), rsRodape.getString("mco_codigo"), rsRodape.getString("mco_descricao"), rsRodape.getString("mco_abreviatura"), String.valueOf(qtde), rsRodape.getString("rco_volume"), rsRodape.getString("rec_capacidade"), codigoTubo, rsRodape.getString("pac_nome"), rsRodape.getString("rec_descricao"), rsRodape.getString("pac_nomesocial"));
                    continue;
                }
                lista.add(new String[]{rsRodape.getString("rec_codigo"), rsRodape.getString("exa_codigo"), rsRodape.getString("mco_codigo"), rsRodape.getString("mco_descricao"), rsRodape.getString("mco_abreviatura"), String.valueOf(qtde), rsRodape.getString("rco_volume"), rsRodape.getString("rec_capacidade"), codigoTubo, rsRodape.getString("pac_nome"), rsRodape.getString("rec_descricao"), rsRodape.getString("pac_nomesocial")});
            }
        }
        return lista;
    }

    private static int localizar(int posini, String tubo, ArrayList lista, int coluna) {
        int retorno = -1;
        if (posini < lista.size() && lista.size() > 0) {
            for (int i = posini; i < lista.size(); ++i) {
                String[] o = (String[])lista.get(i);
                if (!o[coluna].equals(tubo)) continue;
                retorno = i;
                break;
            }
        }
        return retorno;
    }

    private static ArrayList adicionaTubo(ArrayList lista, int pos, String tubo, String exame, String codigoMaterial, String descricaoMaterial, String abrv, String qtde, String volume, String capacidade, String codigoRequisicaoTubo, String nomePaciente, String recipiente, String nomeSocialPaciente) {
        String[] s = (String[])lista.get(pos);
        double capacity = 0.0;
        double volumeUtilizado = 0.0;
        double novoVolume = 0.0;
        if (Funcoes.isNumeric(s[7])) {
            capacity = Double.parseDouble(Funcoes.limpaDecimal(s[7]));
        }
        if (Funcoes.isNumeric(s[6])) {
            volumeUtilizado = Double.parseDouble(Funcoes.limpaDecimal(s[6]));
        }
        if (Funcoes.isNumeric(volume)) {
            novoVolume = Double.parseDouble(volume);
        }
        if (capacity == 0.0 || capacity > 0.0 && capacity - volumeUtilizado >= novoVolume) {
            s[6] = String.valueOf(volumeUtilizado + novoVolume);
            s[1] = s[1] + " " + exame;
        } else if ((pos = ImprimirAnexo.localizar(pos + 1, tubo, lista, 0)) < 0) {
            lista.add(new String[]{tubo, exame, codigoMaterial, descricaoMaterial, abrv, qtde, volume, capacidade, codigoRequisicaoTubo, nomePaciente, recipiente, nomeSocialPaciente});
        } else {
            lista = ImprimirAnexo.adicionaTubo(lista, pos, tubo, exame, codigoMaterial, descricaoMaterial, abrv, qtde, volume, capacidade, codigoRequisicaoTubo, nomePaciente, recipiente, nomeSocialPaciente);
        }
        return lista;
    }

    private static void preencheCamposAgendamento(ModeloGridTable modelo, String filial, String requisicao, Statement st) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select agd.agd_codigo as codigoAgendamento ");
        buf.append("       ,agd.agd_datahoraagenda as dataHoraAgendamento ");
        buf.append("       ,agd.agd_situacao as situacaoAgendamento ");
        buf.append("       ,agd.agd_observacao as observacaoAgendamento ");
        buf.append("       ,sal.sal_codigo as codigoSalaAtendimento ");
        buf.append("       ,sal.sal_descricao as descricaoSalaAtendimento ");
        buf.append("   from agendamento agd ");
        buf.append("   join salaatendimento sal on agd.fil_codigo = sal.fil_codigo and agd.sal_codigo = sal.sal_codigo ");
        buf.append("  where agd.fil_codigo = ").append(filial);
        buf.append("    and pegacodigomultiguiamae(agd.fil_codigo, agd.req_codigo) = pegacodigomultiguiamae(").append(filial).append(", ").append(requisicao).append(") ");
        buf.append("    and agd.agd_situacao IN ('").append("A").append("' ");
        buf.append("                            ,'").append("T").append("' ");
        buf.append("                            ,'").append("F").append("') ");
        buf.append("  order by agd.agd_datahoraagenda ");
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            int i = 1;
            while (rs.next()) {
                for (int k = 0; k < modelo.getRowCount(); ++k) {
                    for (int j = 0; j < CAMPOS_AGENDAMENTO.length; ++j) {
                        modelo.setValueAt(rs.getObject(CAMPOS_AGENDAMENTO[j]), k, modelo.findColumn(CAMPOS_AGENDAMENTO[j] + i));
                    }
                }
                ++i;
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi possivel buscar dados dos agendamentos.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    public static String[] adicionaColunasAgendamento(String[] campos) {
        String[] colunas = new String[]{};
        for (int i = 0; i < 10; ++i) {
            String[] aux = new String[CAMPOS_AGENDAMENTO.length];
            for (int j = 0; j < CAMPOS_AGENDAMENTO.length; ++j) {
                aux[j] = CAMPOS_AGENDAMENTO[j] + (i + 1);
            }
            colunas = ArraysUtil.concatenar(colunas, aux);
        }
        return ArraysUtil.concatenar(campos, colunas);
    }
}

