/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import br.com.thread.openpdf.text.Document;
import br.com.thread.openpdf.text.Rectangle;
import br.com.thread.openpdf.text.pdf.DefaultFontMapper;
import br.com.thread.openpdf.text.pdf.FontMapper;
import br.com.thread.openpdf.text.pdf.PdfContentByte;
import br.com.thread.openpdf.text.pdf.PdfGraphics2D;
import br.com.thread.openpdf.text.pdf.PdfImportedPage;
import br.com.thread.openpdf.text.pdf.PdfReader;
import br.com.thread.openpdf.text.pdf.PdfTemplate;
import br.com.thread.openpdf.text.pdf.PdfWriter;
import jalis.apoio.servidorws.parametroset.ParametroSet;
import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.impressao.CampoAssinaturaLaudo;
import jalis.laboratorio.impressao.Documento;
import jalis.laboratorio.util.impressao.DadosImpressao;
import jalis.laboratorio.util.impressao.ImprimirAnexo;
import jalis.laboratorio.util.impressao.ImprimirAnexoCobranca;
import jalis.laboratorio.util.impressao.ImprimirAtestado;
import jalis.laboratorio.util.impressao.ImprimirCapa;
import jalis.laboratorio.util.impressao.ImprimirCarteira;
import jalis.laboratorio.util.impressao.ImprimirComprovante;
import jalis.laboratorio.util.impressao.ImprimirEtiquetaLamina;
import jalis.laboratorio.util.impressao.ImprimirEtiquetaLaudo;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasColetaTriagem;
import jalis.laboratorio.util.impressao.ImprimirGuia;
import jalis.laboratorio.util.impressao.ImprimirIdentificacaoEstante;
import jalis.laboratorio.util.impressao.ImprimirIdentificacaoTubo;
import jalis.laboratorio.util.impressao.ImprimirMapa;
import jalis.laboratorio.util.impressao.ImprimirProtocoloDestino;
import jalis.laboratorio.util.impressao.ImprimirRecepcaoAmostra;
import jalis.laboratorio.util.impressao.ImprimirRecibo;
import jalis.laboratorio.util.impressao.ImprimirTermoConsentimento;
import jalis.laboratorio.util.impressao.ThreadExportaPDFWebImpressao;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class Impressao {
    public static final int IMPRESSAO_GUIA = 0;
    public static final int IMPRESSAO_GUIA_TIPO_SOLICITADOS = 1;
    private static String razao;
    public static final String[] CAMPOS_ORCAMENTO;
    public static final String[] CAMPOS_CARTEIRA;
    public static final String[] CAMPOS_COMPROVANTE;
    public static final String[] CAMPOS_RECEPCAO_AMOSTRA;
    public static final String[] CAMPOS_RECIBO;
    public static final String[] CAMPOS_CAPA;
    public static final String[] CAMPOS_ANEXO;
    public static final String[] CAMPOS_ANEXO_COBRANCA;
    public static final String[] CAMPOS_GUIA;
    public static final String[] CAMPOS_ETQ_COLETA;
    public static final String[] CAMPOS_ETQ_TRIAGEM;
    public static final String[] CAMPOS_ETQ_APOIO;
    public static final String[] CAMPOS_MAPA;
    public static final String[] CAMPOS_LAUDO;
    public static final String[] CAMPOS_EXAME;
    public static final CampoAssinaturaLaudo[] CAMPOS_ASSINATURA_LAUDO;
    public static final String[] CAMPOS_LANCAMENTO_CAIXA;
    public static final String[] CAMPOS_INSTRUCOES;
    public static final String[] CAMPOS_ATESTADO;
    public static final String[] CAMPOS_PROTOCOLO_DESTINO;
    public static final String[] CAMPOS_MEDICAMENTO;
    public static final String[] CAMPOS_NOTA_FISCAL_SAIDA;
    public static final String[] CAMPOS_ETIQUETA_ESTOQUE;
    public static final String[] CAMPOS_NOTA_FISCAL_PESSOA_FISICA;
    public static final String[] CAMPOS_ETIQUETA_MATERIAL_ENVIADO;
    public static final String[] CAMPOS_RECIBO_MATERIAL_ENVIADO;
    public static final String[] CAMPOS_IDENTIFICACAO_ESTANTE;
    public static final String[] CAMPOS_IDENTIFICACAO_TUBO;
    public static final String[] CAMPOS_ETIQUETA_LAMINA;
    public static final String[] CAMPOS_PROPOSTA;
    public static final String[] CAMPOS_IDENTIFICACAO_COLETA;
    public static final String[] CAMPOS_ETIQUETA_HP_DIRECT;
    public static final String[] CAMPOS_ETIQUETA_SM;
    public static final String[] CAMPOS_ETQ_LAUDO;
    public static final String[] CAMPOS_NOTIFICACAO;
    public static final String[] CAMPOS_TERMO_CONSENTIMENTO_TIPO_EXAME;

    public static synchronized void imprimirComprovante(String filial, String requisicao) throws SQLException, IOException {
        ImprimirComprovante.imprimir(filial, requisicao);
    }

    public static synchronized void imprimirRecibo(String filial, String requisicao) throws SQLException {
        ImprimirRecibo.imprimir(filial, requisicao);
    }

    public static synchronized void imprimirCapa(String filial, String requisicao) throws SQLException {
        ImprimirCapa.imprimir(filial, requisicao);
    }

    public static synchronized void imprimirAnexo(String filial, String requisicao) throws SQLException {
        ImprimirAnexo.imprimir(filial, requisicao);
    }

    public static synchronized void imprimirAnexoCobranca(String filial, String requisicao) throws SQLException {
        ImprimirAnexoCobranca.imprimir(filial, requisicao);
    }

    public static synchronized void imprimirTermoConsentimento(String filial, String requisicao, String codTermo, Integer codLayout, String paciente) throws Exception {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        ImprimirTermoConsentimento termo = new ImprimirTermoConsentimento();
        termo.imprimir(filial, requisicao, codTermo, codLayout, paciente, st, st2, ParametrosGerais.getAgruparImpressaoTermo(), false, ParametrosLocais.getParametro("impressoraTermoConsentimento"), ParametrosLocais.getParametro("tamanhoNomeImpressoras"), Funcoes.getNomeImpressorasLocais(), Variaveis.tipoFilialPadrao.equals("A"), ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame(), ParametrosGerais.getPrecoMetodologia(), ParametrosGerais.isOcultarApenasFaturamento(), ParametrosGerais.getOrdenarSetor(), ParametrosGerais.getOrdemComprovante(), ParametrosGerais.getQtdeExamesCC(), ParametrosGerais.getTipoIntegracao(), ParametrosGerais.getColunasRodapeComprovante(), ParametrosGerais.isAgruparGuiasInterface(), ParametrosGerais.getTipoExportacaoInterface(), ParametrosGerais.getAgruparInterface(), ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboTubo(), ParametrosGerais.getTuboPrimario(), () -> {
            try {
                Conexao.arquivaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, () -> {
            try {
                Conexao.anulaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        Conexao.fecharStatement(st, st2);
    }

    public static synchronized void imprimirRecepcaoAmostra(String filial, String requisicao) throws SQLException {
        ImprimirRecepcaoAmostra.imprimir(filial, requisicao);
    }

    public static synchronized void imprimirCarteira(String filial, String paciente) throws SQLException {
        ImprimirCarteira.imprimir(filial, paciente);
    }

    public static void imprimirGuia(Object owner, String filial, String requisicao, boolean imprimirTodas, int tipoGuia) throws SQLException {
        ImprimirGuia.imprimir((Window)owner, filial, requisicao, imprimirTodas, tipoGuia);
    }

    public static synchronized void imprimirIdentificacaoEstante(String filial, String estante) throws SQLException {
        ImprimirIdentificacaoEstante.imprimir(filial, estante);
    }

    public static synchronized void imprimirIdentificacaoTubo(Integer filial, Integer filialRequisicao, Integer codigoEstante, Integer codigoRequisicao, Integer codigoRecipienteFilho, Integer codigoSetor, Integer codigoGeladeira, String codigoPrateleira, Date dataHoraAdicaoSoroteca, Date dataVencimento) throws SQLException {
        ImprimirIdentificacaoTubo.imprimir(filial, filialRequisicao, codigoEstante, codigoRequisicao, codigoRecipienteFilho, codigoSetor, codigoGeladeira, codigoPrateleira, dataHoraAdicaoSoroteca, dataVencimento);
    }

    public static synchronized void imprimirEtiquetaLamina(Integer codigoFilial, Integer codigoRequisicao) throws SQLException {
        ImprimirEtiquetaLamina.imprimir(codigoFilial, codigoRequisicao);
    }

    public static synchronized void imprimirEtiquetaLamina(Integer codigoFilial, Integer codigoRequisicao, String codigoExame, Integer codigoMaterial) throws SQLException {
        ImprimirEtiquetaLamina.imprimir(codigoFilial, codigoRequisicao, codigoExame, codigoMaterial);
    }

    public static void imprimirGuia(String filial, String requisicao, int codigoConvenio, int tipoGuia) throws SQLException {
        ImprimirGuia.imprimir(filial, requisicao, codigoConvenio, tipoGuia);
    }

    public static synchronized void imprimirProtocoloDestino(String filial, String requisicao) throws SQLException {
        Impressao.imprimirProtocoloDestino(filial, requisicao, true, false);
    }

    public static synchronized void imprimirProtocoloDestino(String filial, String requisicao, boolean mostrarMensagem, boolean visualizar) throws SQLException {
        ImprimirProtocoloDestino.imprimir(filial, requisicao, mostrarMensagem, visualizar);
    }

    public static synchronized void imprimirMapa(String filial, String requisicao, boolean reimprimir) throws Exception {
        boolean naoPermiteVisualizarPaciente = Acesso.getAcesso(Long.parseLong("0300100302"));
        ImprimirMapa.imprimir(filial, requisicao, null, null, reimprimir, false, naoPermiteVisualizarPaciente, -1);
    }

    public static synchronized void imprimirMapa(String filial, String requisicao, String[] exames, int[] materiais, boolean reimprimir, boolean naoPermiteVisualizarPaciente, int metodoSelecionado) throws Exception {
        String[] exm = null;
        if (exames != null && materiais != null) {
            exm = new String[exames.length + materiais.length];
            int count = 0;
            for (int i = 0; i < exames.length; ++i) {
                exm[count++] = exames[i];
                exm[count++] = String.valueOf(materiais[i]);
            }
        }
        ImprimirMapa.imprimir(filial, requisicao, exm, null, reimprimir, false, naoPermiteVisualizarPaciente, metodoSelecionado);
    }

    public static synchronized void imprimirEtiquetaLaudo(String filial, String requisicao) throws Exception {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        String impressora = ParametrosLocais.getParametro("impressoraEtqLaudo");
        ImprimirEtiquetaLaudo etiquetaLaudo = new ImprimirEtiquetaLaudo();
        etiquetaLaudo.imprimir(filial, requisicao, false, st, st2, impressora, ParametrosGerais.getLayCodigo(), ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
        Conexao.fecharStatement(st, st2);
    }

    public static synchronized String getEtiquetaColetaApoio(String filial, String requisicao, boolean reimprimir) throws Exception {
        return ImprimirEtiquetasColetaTriagem.getEtiquetasTermicaApoio(filial, requisicao, Variaveis.login, reimprimir);
    }

    public static synchronized String getEtiquetaColetaApoio(String filial, String requisicao) throws Exception {
        return ImprimirEtiquetasColetaTriagem.getEtiquetasTermicaApoio(filial, requisicao, Variaveis.login);
    }

    public static synchronized String getEtiquetaColetaApoio(String filial, String requisicao, Statement st1, Statement st2, Statement st3, boolean atualizarCodigoApoiado) throws Exception {
        return ImprimirEtiquetasColetaTriagem.getEtiquetasTermicaApoio(filial, requisicao, st1, st2, st3, Variaveis.login, atualizarCodigoApoiado, null, false);
    }

    public static synchronized String getEtiquetaColetaApoio(String filial, String requisicao, String[] exames, int[] materiais, Statement st1, Statement st2, Statement st3, boolean atualizarCodigoApoiado) throws Exception {
        return ImprimirEtiquetasColetaTriagem.getEtiquetasTermica(filial, requisicao, exames, materiais, "lay_tipoetqapoio", "lay_etqapoio", true, CAMPOS_ETQ_APOIO, "F", Variaveis.login);
    }

    public static synchronized String getEtiquetaColetaApoio(String filial, String requisicao, Statement st1, Statement st2, Statement st3, boolean atualizarCodigoApoiado, List<ParametroSet> listExames, boolean isEnviarEtiquetaCodigoApoio) throws Exception {
        return ImprimirEtiquetasColetaTriagem.getEtiquetasTermicaApoio(filial, requisicao, st1, st2, st3, Variaveis.login, atualizarCodigoApoiado, listExames, isEnviarEtiquetaCodigoApoio);
    }

    public static synchronized String getEtiquetaColetaApoio(DadosImpressao dadosImpressao) throws Exception {
        String filial = dadosImpressao.getFilial();
        String requisicao = dadosImpressao.getRequisicao();
        String[] exames = dadosImpressao.getExames();
        int[] materiais = dadosImpressao.getMateriais();
        Statement st1 = dadosImpressao.getStatament1();
        Statement st2 = dadosImpressao.getStatament2();
        Statement st3 = dadosImpressao.getStatament3();
        boolean atualizarCodigoApoiado = dadosImpressao.isAtualizarCodigoApoiado();
        List<ParametroSet> listExames = dadosImpressao.getListExames();
        boolean isEnviarEtiquetaCodigoApoio = dadosImpressao.isAtualizarCodigoApoiado();
        boolean gerarInterfaceApoio = dadosImpressao.isGerarInterface();
        return ImprimirEtiquetasColetaTriagem.getEtiquetasTermica(false, filial, requisicao, exames, materiais, "lay_tipoetqapoio", "lay_etqapoio", true, CAMPOS_ETQ_APOIO, "F", st1, st2, st3, Variaveis.login, atualizarCodigoApoiado, listExames, isEnviarEtiquetaCodigoApoio, gerarInterfaceApoio, ParametrosGerais.getTipoExportacaoInterface(), ParametrosGerais.isAgruparEtiquetaPorQtde(), ParametrosLocais.getParametro("imprimirEtiquetaTriagemSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSelecionadaSemMaterial"), ParametrosGerais.getLayCodigo(), ParametrosGerais.getExportarInterface(), ParametrosGerais.getAgruparInterface(), ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboTubo(), ParametrosGerais.getTuboPrimario(), ParametrosGerais.isUtilizarCapacidadeTuboPrimario());
    }

    public static synchronized boolean imprimirEtiquetaColeta(String filial, String requisicao) throws Exception {
        return ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, Variaveis.login, 1);
    }

    public static synchronized String getEtiquetaColeta(String filial, String requisicao) throws Exception {
        return ImprimirEtiquetasColetaTriagem.getEtiquetasTermica(filial, requisicao, Variaveis.login, 1);
    }

    public static synchronized void imprimirEtiquetaColeta(String filial, String requisicao, boolean reimprimir, boolean mostrarMensagem) throws Exception {
        ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, null, null, reimprimir, Variaveis.login, 1, mostrarMensagem);
    }

    public static synchronized void imprimirEtiquetaColeta(String filial, String requisicao, boolean reimprimir) throws Exception {
        ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, null, null, reimprimir, Variaveis.login, 1, true);
    }

    public static synchronized void imprimirEtiquetaColetaWs(String filial, String requisicao, boolean reimprimir, boolean naoEnviaParaImpressora) throws Exception {
        ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, null, null, reimprimir, Variaveis.login, 1, true, naoEnviaParaImpressora, false);
    }

    public static synchronized void imprimirEtiquetaColeta(String filial, String requisicao, String exame, int material) throws Exception {
        ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, new String[]{exame}, new int[]{material}, false, Variaveis.login, 1, true);
    }

    public static synchronized void imprimirEtiquetaColeta(String filial, String requisicao, String exame, int material, boolean reimprimir) throws Exception {
        ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, new String[]{exame}, new int[]{material}, reimprimir, Variaveis.login, 1, true);
    }

    public static synchronized void imprimirEtiquetaColeta(String filial, String requisicao, String[] exame, int[] material, boolean reimprimir, boolean mostrarMensagem, boolean isAgendamento) throws Exception {
        ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, exame, material, reimprimir, Variaveis.login, 1, mostrarMensagem, false, isAgendamento);
    }

    public static synchronized void imprimirEtiquetaColeta(String filial, String requisicao, String[] exame, int[] material, boolean reimprimir, int tipoEtiqueta) throws Exception {
        ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, exame, material, reimprimir, Variaveis.login, tipoEtiqueta, true);
    }

    public static synchronized void imprimirEtiquetaColeta(String filial, String requisicao, String[] exame, int[] material, boolean reimprimir, int tipoEtiqueta, boolean impressaoAutomaticaColetaSelecionada) throws Exception {
        ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, exame, material, reimprimir, Variaveis.login, tipoEtiqueta, true, impressaoAutomaticaColetaSelecionada, false);
    }

    public static synchronized boolean imprimirEtiquetaColeta(String filial, String requisicao, String[] exame, int[] material, boolean reimprimir) throws Exception {
        return ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, exame, material, reimprimir, Variaveis.login, 1, true);
    }

    public static synchronized void imprimirEtiquetaTriagem(String filial, String requisicao, String usuario, boolean mostrarMensagem) throws Exception {
        ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, null, null, true, usuario, 2, mostrarMensagem);
    }

    public static synchronized void imprimirEtiquetaTriagem(String filial, String requisicao, String usuario) throws Exception {
        ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, usuario, 2);
    }

    public static synchronized void imprimirEtiquetaTriagem(String filial, String requisicao, String codigoExame, int codigoMaterial, String usuario, boolean reimprimir) throws Exception {
        ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, new String[]{codigoExame}, new int[]{codigoMaterial}, reimprimir, usuario, 2, true);
    }

    public static synchronized void imprimirEtiquetaTriagem(String filial, String requisicao, String[] codigoExame, String usuario, boolean reimprimir, boolean mostrarMensagem) throws Exception {
        String[] exames = null;
        int[] materiais = null;
        if (codigoExame != null) {
            exames = new String[codigoExame.length / 2];
            materiais = new int[codigoExame.length / 2];
            int pos = 0;
            for (int i = 0; i < codigoExame.length; i += 2) {
                exames[pos] = codigoExame[i];
                materiais[pos++] = Integer.valueOf(codigoExame[i + 1]);
            }
        }
        ImprimirEtiquetasColetaTriagem.imprimir(filial, requisicao, exames, materiais, reimprimir, usuario, 2, mostrarMensagem);
    }

    public static synchronized void imprimirAtestadoPaciente(String filial, String requisicao) throws SQLException {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        String impressoraAtestado = ParametrosLocais.getParametro("impressoraAtestado");
        ImprimirAtestado imprimirAtestado = new ImprimirAtestado();
        imprimirAtestado.imprimir(filial, requisicao, 0, st, st2, false, impressoraAtestado, ParametrosGerais.getLayCodigo());
        Conexao.fecharStatement(st, st2);
    }

    public static synchronized void imprimirAtestadoAcompanhante(String filial, String requisicao) throws SQLException {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        ImprimirAtestado imprimirAtestado = new ImprimirAtestado();
        String impressoraAtestado = ParametrosLocais.getParametro("impressoraAtestado");
        imprimirAtestado.imprimir(filial, requisicao, 1, st, st2, false, impressoraAtestado, ParametrosGerais.getLayCodigo());
        Conexao.fecharStatement(st, st2);
    }

    public static synchronized String[] getCamposComprovante() {
        return ImprimirComprovante.adicionaColunasAgendamento(ArraysUtil.concatenar(ImprimirComprovante.adicionaColunasComprovante(CAMPOS_COMPROVANTE), CAMPOS_LANCAMENTO_CAIXA));
    }

    public static synchronized String[] getCamposGuia(int qtdeColunas) {
        return ImprimirGuia.adicionaColunasGuia(CAMPOS_GUIA, qtdeColunas);
    }

    public static synchronized String[] getCamposRecibo() {
        return ImprimirRecibo.adicionaColunasAgendamento(ArraysUtil.concatenar(ImprimirRecibo.adicionaColunasRecibo(CAMPOS_RECIBO, ParametrosGerais.getQtdeExamesCC()), CAMPOS_LANCAMENTO_CAIXA));
    }

    public static synchronized String[] getCamposAnexoCobranca() {
        return ImprimirAnexoCobranca.adicionaColunasAgendamento(ImprimirAnexoCobranca.adicionaColunasAnexo(ArraysUtil.concatenar(CAMPOS_ANEXO_COBRANCA, CAMPOS_LANCAMENTO_CAIXA), ParametrosGerais.getQtdeExamesCC(), ParametrosGerais.getColunasRodapeComprovante()));
    }

    public static synchronized String[] getCamposCapa() {
        return ImprimirCapa.adicionaColunasAgendamento(ImprimirCapa.adicionaColunasCapa(CAMPOS_CAPA, ParametrosGerais.getQtdeExamesCC(), ParametrosGerais.getColunasRodapeComprovante()));
    }

    public static synchronized String[] getCamposAnexo() {
        return ImprimirAnexo.adicionaColunasAgendamento(ImprimirAnexo.adicionaColunasAnexo(ArraysUtil.concatenar(CAMPOS_ANEXO, CAMPOS_LANCAMENTO_CAIXA), ParametrosGerais.getQtdeExamesCC(), ParametrosGerais.getColunasRodapeComprovante()));
    }

    public static synchronized String[] getCamposProtocoloDestino() {
        return ImprimirComprovante.adicionaColunasComprovante(CAMPOS_PROTOCOLO_DESTINO);
    }

    public static synchronized String[] getCamposMedicamento() {
        int QTDE = 10;
        int contador = 0;
        String[] retorno = new String[CAMPOS_MEDICAMENTO.length * 10];
        for (String s : CAMPOS_MEDICAMENTO) {
            for (int i = 1; i <= 10; ++i) {
                retorno[contador++] = s + Funcoes.formataDecimal("00", i);
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String pegaAMB(String filial, String exame, String material, String convenio, String metodologia) throws SQLException {
        Statement st = Conexao.getStatement();
        String retorno = "";
        try {
            retorno = Impressao.pegaAMB(st, filial, exame, material, convenio, metodologia);
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "Impressao: 1771");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static String pegaAMB(Statement st, String filial, String exame, String material, String convenio, String metodologia) throws SQLException {
        return Impressao.pegaAMB(st, filial, exame, material, convenio, metodologia, ParametrosGerais.getPrecoMetodologia());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String pegaAMB(Statement st, String filial, String exame, String material, String convenio, String metodologia, boolean pesquisarPorMetodologia) throws SQLException {
        StringBuilder buf = new StringBuilder();
        if (pesquisarPorMetodologia) {
            buf.append(" select COALESCE(NULLIF(TRIM(dtm.dtm_codamb), ''), dtp.dtp_codamb) as amb from convenios a ");
            buf.append(" left join detalhetabelaprecometodologia dtm on a.fil_codigo = dtm.fil_codigo and a.tpe_codigo = dtm.tpe_codigo and dtm.met_codigo = ").append(metodologia);
            buf.append(" and upper(dtm.exa_codigo) = upper('").append(exame.toUpperCase()).append("') and dtm.mco_codigo = ").append(material);
        } else {
            buf.append(" select dtp.dtp_codamb as amb from convenios a ");
        }
        buf.append(" left join detalhetabelapreco dtp on a.fil_codigo = dtp.fil_codigo and a.tpe_codigo = dtp.tpe_codigo and upper(dtp.exa_codigo) = upper('").append(exame.toUpperCase());
        buf.append("') and dtp.mco_codigo = ").append(material);
        buf.append(" where a.fil_codigo = ").append(filial);
        buf.append(" and a.con_codigo = ").append(convenio);
        ResultSet result = null;
        String amb = "";
        try {
            result = st.executeQuery(buf.toString());
            if (result.next()) {
                amb = result.getString("amb");
            }
        }
        catch (Throwable throwable) {
            Impressao.fechaConexao(result);
            throw throwable;
        }
        Impressao.fechaConexao(result);
        return amb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, Object> buscaDadosLancamentoRequisicao(String filial, String requisicao, Statement st) throws SQLException {
        HashMap<String, Object> hash = new HashMap<String, Object>();
        StringBuilder buf = new StringBuilder("select a.lcx_codigo as codigoUltimoPagamentoRequisicao, ");
        buf.append("a.lcx_tipo as debitoCreditoUltimoPagamentoRequisicao,");
        buf.append("a.lcx_datahora as dataHoraUltimoPagamentoRequisicao,");
        buf.append("a.lcx_valor as valorUltimoPagamentoRequisicao, a.lcx_banco as bancoUltimoPagamentoRequisicao, ");
        buf.append("a.lcx_agencia as agenciaUltimoPagamentoRequisicao, a.lcx_documento as documentoUltimoPagamentoRequisicao, ");
        buf.append("a.lcx_obs as observacaoUltimoPagamentoRequisicao, a.lcx_tipodocumento as tipoDocumentoUltimoPagamentoRequisicao, ");
        buf.append("a.lcx_tipopagamento as tipoPagamentoUltimoPagamentoRequisicao, a.lcx_nrcheque as numeroChequeUltimoPagamentoRequisicao, ");
        buf.append("a.lcx_validadecartao as validadeCartaoUltimoPagamentoRequisicao, a.lcx_nrcartao as numeroCartaoUltimoPagamentoRequisicao, ");
        buf.append("a.lcx_cartaocredito as cartaoCreditoUltimoPagamentoRequisicao, a.lcx_conta as contaUltimoPagamentoRequisicao, ");
        buf.append("a.lcx_conciliacao as dataConciliacaoUltimoPagamentoRequisicao, a.lcx_vencimento as dataVencimentoUltimoPagamentoRequisicao, ");
        buf.append("a.usr_codigo as codigoUsuarioUltimoPagamentoRequisicao, a.est_codigo as codigoEstacaoUltimoPagamentoRequisicao, ");
        buf.append("a.cco_reduzido as codigoContaCorrenteUltimoPagamentoRequisicao, c.cco_conta as contaContaCorrenteUltimoPagamentoRequisicao, ");
        buf.append("c.cco_titular as titularContaCorrenteUltimoPagamentoRequisicao, ");
        buf.append("a.lcx_nomepagador as nomePagadorPagamentoRequisicao, a.lcx_cpfpagador as cpfPagadorPagamentoRequisicao, ");
        buf.append("req.req_nomeplano as nomeDoPlano ");
        buf.append("from requisicaolanctocaixa b ");
        buf.append("left join lanctocaixa a on b.fil_codigo = a.fil_codigo and b.lcx_codigo = a.lcx_codigo and b.est_codigo = a.est_codigo ");
        buf.append("left join contacorrente c on a.fil_codigo = c.fil_codigo and a.cco_reduzido = c.cco_reduzido ");
        buf.append("left join requisicao req on b.fil_codigo = req.fil_codigo and b.req_codigo = req.req_codigo ");
        buf.append("where b.fil_codigo = ");
        buf.append(filial);
        buf.append(" and b.req_codigo = ");
        buf.append(requisicao);
        buf.append(" order by a.lcx_codigo desc ");
        buf.append(" limit 1 ");
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                for (String c : CAMPOS_LANCAMENTO_CAIXA) {
                    try {
                        if (rs.findColumn(c) <= -1) continue;
                        if (c.equalsIgnoreCase("debitoCreditoUltimoPagamentoRequisicao")) {
                            hash.put(c, Tipos.tipoLancamentoCaixa(rs.getString(c)));
                            continue;
                        }
                        if (c.equalsIgnoreCase("tipoDocumentoUltimoPagamentoRequisicao")) {
                            hash.put(c, Tipos.tipoDocumento(rs.getString(c)));
                            continue;
                        }
                        if (c.equalsIgnoreCase("tipoPagamentoUltimoPagamentoRequisicao")) {
                            hash.put(c, Tipos.tipoPagamento(rs.getString(c)));
                            continue;
                        }
                        hash.put(c, rs.getObject(c));
                    }
                    catch (Exception ex) {
                        hash.put(c, "");
                    }
                }
            }
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adicionaMedicamento(String filial, String requisicao, ModeloGridTable tabela, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder("select a.mto_codigo as codigoMedicamento, b.mto_descricao as descricaoMedicamento, ");
        buf.append("a.rem_dosagem as dosagemMedicamento, a.rem_horadose as horaDosagemMedicamento, ");
        buf.append("a.rem_datadose as dataDosagemMedicamento from requisicaomedicamento a ");
        buf.append("left join medicamentos b on a.fil_codigo = b.fil_codigo and a.mto_codigo = b.mto_codigo ");
        buf.append(" where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and req_codigo = ");
        buf.append(requisicao);
        int coluna = 1;
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                String codigo = Funcoes.formataDecimal("00", coluna++);
                int posicao = -1;
                posicao = tabela.findColumn("codigoMedicamento" + codigo);
                if (posicao > 0) {
                    tabela.setValueAt(rs.getString("codigoMedicamento"), tabela.getRowCount() - 1, posicao);
                }
                if ((posicao = tabela.findColumn("descricaoMedicamento" + codigo)) > 0) {
                    tabela.setValueAt(rs.getString("descricaoMedicamento"), tabela.getRowCount() - 1, posicao);
                }
                if ((posicao = tabela.findColumn("dosagemMedicamento" + codigo)) > 0) {
                    tabela.setValueAt(rs.getString("dosagemMedicamento"), tabela.getRowCount() - 1, posicao);
                }
                if ((posicao = tabela.findColumn("horaDosagemMedicamento" + codigo)) > 0) {
                    tabela.setValueAt(rs.getTime("horaDosagemMedicamento"), tabela.getRowCount() - 1, posicao);
                }
                if ((posicao = tabela.findColumn("dataDosagemMedicamento" + codigo)) <= 0) continue;
                tabela.setValueAt(rs.getDate("dataDosagemMedicamento"), tabela.getRowCount() - 1, posicao);
            }
        }
    }

    public static String comparaNomeImpressoraReduzido(String nomeReduzido) {
        return Impressao.comparaNomeImpressoraReduzido(nomeReduzido, ParametrosLocais.getParametro("tamanhoNomeImpressoras"), Funcoes.getNomeImpressorasLocais());
    }

    public static String comparaNomeImpressoraReduzido(String nomeReduzido, String tamanhoNomeImpressora, String[] impressorasLocais) {
        String retorno = nomeReduzido;
        if (Funcoes.isNumeric(tamanhoNomeImpressora) && Integer.parseInt(tamanhoNomeImpressora) > 0) {
            String[] impressoras;
            for (String s : impressoras = impressorasLocais) {
                if (!s.startsWith(nomeReduzido)) continue;
                retorno = s;
                break;
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String pegaDatasEntregaParcial(Statement st, String filial, String requisicao) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("select distinct exr_dataentregaprev from examerequisicao ");
        bui.append("where fil_codigo = ").append(filial);
        bui.append(" and req_codigo = ").append(requisicao);
        bui.append(" and exr_excluido = false ");
        bui.append(" order by exr_dataentregaprev");
        StringBuilder retorno = new StringBuilder();
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            while (rs.next()) {
                retorno.append(!DBUtil.campoNull(rs.getString("exr_dataentregaprev")) ? Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("exr_dataentregaprev")) : "").append(" ");
            }
        }
        return retorno.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String pegaDatasColetaExames(Statement st, String filial, String requisicao) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append(" select exr_datamaterial, exr_excluido from examerequisicao ");
        bui.append(" where fil_codigo = ").append(filial);
        bui.append(" and req_codigo = ").append(requisicao);
        StringBuilder retorno = new StringBuilder();
        ResultSet rs = null;
        try {
            rs = st.executeQuery(bui.toString());
            while (rs.next()) {
                if (rs.getBoolean("exr_excluido") || DBUtil.campoNull(rs.getString("exr_datamaterial"))) continue;
                String data = Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("exr_datamaterial"));
                if (retorno.toString().contains(data)) continue;
                retorno.append(data).append(" ");
            }
        }
        catch (Throwable throwable) {
            Impressao.fechaConexao(rs);
            throw throwable;
        }
        Impressao.fechaConexao(rs);
        return retorno.toString().trim();
    }

    public static boolean verificaExamesSemMaterial(Statement st, String filial, String requisicao) throws SQLException {
        boolean retorno = false;
        StringBuilder bui = new StringBuilder();
        bui.append("select exa_codigo from examerequisicao ");
        bui.append("where fil_codigo = ").append(filial);
        bui.append(" and req_codigo = ").append(requisicao);
        bui.append(" and (exr_situacao = '").append("F").append("' ");
        bui.append(" or exr_situacao = '").append("R").append("')");
        bui.append(" and exr_excluido = false ");
        ResultSet rs = st.executeQuery(bui.toString());
        retorno = rs.next();
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date pegaDataColetaRequisicaoProduto(Statement st, String filial, String requisicao) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("select distinct exr_datamaterial from examerequisicao ");
        bui.append("where fil_codigo = ").append(filial);
        bui.append(" and req_codigo = ").append(requisicao);
        bui.append(" and exr_excluido = false ");
        bui.append(" order by exr_datamaterial");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            if (rs.next() && !DBUtil.campoNull(rs.getString("exr_datamaterial"))) {
                Timestamp timestamp = rs.getTimestamp("exr_datamaterial");
                return timestamp;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date pegaUltimaDataExameRequisicao(Statement st, String filial, String requisicao, String campo) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("select max(").append(campo).append(") from examerequisicao ");
        bui.append("where fil_codigo = ").append(filial);
        bui.append(" and req_codigo = ").append(requisicao);
        bui.append(" and exr_excluido = false ");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            if (rs.next() && !DBUtil.campoNull(rs.getString(1))) {
                Timestamp timestamp = rs.getTimestamp(1);
                return timestamp;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date pegaPrimeiraDataExameRequisicao(Statement st, String filial, String requisicao) throws SQLException {
        Timestamp timestamp;
        StringBuilder sql = new StringBuilder();
        sql.append(" select exr_datamaterial, exr_excluido from examerequisicao ");
        sql.append(" where fil_codigo = ").append(filial);
        sql.append(" and req_codigo = ").append(requisicao);
        ResultSet rs = null;
        try {
            Timestamp dataExame = null;
            rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                if (!Impressao.dataVazia(rs, "exr_datamaterial") || dataExame != null && !dataExame.after((Date)rs.getTimestamp("exr_datamaterial"))) continue;
                dataExame = rs.getTimestamp("exr_datamaterial");
            }
            timestamp = dataExame;
        }
        catch (Throwable throwable) {
            Impressao.fechaConexao(rs);
            throw throwable;
        }
        Impressao.fechaConexao(rs);
        return timestamp;
    }

    public static Date pegaPrimeiraDataHistoricoSituacoes(Statement st, String filial, String requisicao, String situacao) throws SQLException {
        return Impressao.pegaPrimeiraDataHistoricoSituacoes(st, filial, requisicao, "", "", situacao);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date pegaPrimeiraDataHistoricoSituacoes(Statement st, String filial, String requisicao, String exame, String material, String situacao) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("select min(a.ers_datahora) from examerequisicaosituacoes a ");
        bui.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
        bui.append("where a.fil_codigo = ").append(filial);
        bui.append(" and a.req_codigo = ").append(requisicao);
        if (!Funcoes.textoVazio(exame) && !Funcoes.textoVazio(material)) {
            bui.append(" and a.exa_codigo = '").append(StringUtil.textoDB(exame)).append("' ");
            bui.append(" and a.mco_codigo = ").append(material);
        }
        bui.append(" and a.ers_situacao = '").append(situacao.trim()).append("' ");
        bui.append(" and b.exr_excluido = false ");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            if (rs.next() && !DBUtil.campoNull(rs.getString(1))) {
                Timestamp timestamp = rs.getTimestamp(1);
                return timestamp;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, Registro> pegaDataHistoricoSituacoes(Statement st, String filial, String requisicao, String exame, String material, boolean dataMaxima, String ... situacoes) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append(" select a.ers_situacao as situacao, ");
        bui.append(dataMaxima ? "\tmax(a.ers_datahora) as datahoraMax, " : "");
        bui.append(" min(a.ers_datahora) as datahoraMin ");
        bui.append(" from examerequisicaosituacoes a ");
        bui.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
        bui.append(" where a.fil_codigo = ").append(filial);
        bui.append(" and a.req_codigo = ").append(requisicao);
        if (!Funcoes.textoVazio(exame) && !Funcoes.textoVazio(material)) {
            bui.append(" and a.exa_codigo = '").append(StringUtil.textoDB(exame)).append("' ");
            bui.append(" and a.mco_codigo = ").append(material);
        }
        bui.append(" and a.ers_situacao in(");
        for (int i = 0; i < situacoes.length; ++i) {
            bui.append(" '").append(situacoes[i]).append("' ");
            if (i >= situacoes.length - 1) continue;
            bui.append(", ");
        }
        bui.append(") ");
        bui.append(" and b.exr_excluido = false ");
        bui.append(" group by a.ers_situacao ");
        HashMap<String, Registro> map = new HashMap<String, Registro>();
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            while (rs.next() && !DBUtil.campoNull(rs.getString("datahoraMin"))) {
                map.put(rs.getString("situacao"), new Registro(rs));
            }
        }
        return map;
    }

    public static boolean verificaExamesEmAndamento(Statement st, String filial, String requisicao) throws SQLException {
        return Impressao.verificaExamesEmAndamento(st, filial, requisicao, ParametrosGerais.getConferencia());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verificaExamesEmAndamento(Statement st, String filial, String requisicao, boolean considerarConferencia) throws SQLException {
        boolean bl;
        StringBuilder bui = new StringBuilder();
        bui.append("select exa_codigo, exr_situacao, exr_excluido from examerequisicao ");
        bui.append("where fil_codigo = ").append(filial);
        bui.append(" and req_codigo = ").append(requisicao);
        ResultSet rs = null;
        try {
            rs = st.executeQuery(bui.toString());
            while (rs.next()) {
                if (rs.getBoolean("exr_excluido") || rs.getString("exr_situacao") == null || Impressao.verificaSituacao(rs, considerarConferencia)) continue;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            Impressao.fechaConexao(rs);
            throw throwable;
        }
        {
            Impressao.fechaConexao(rs);
            return bl;
        }
        Impressao.fechaConexao(rs);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verificaExamesCertificadosInmetro(Statement st, String filial, String requisicao) throws SQLException {
        boolean retorno = false;
        StringBuilder bui = new StringBuilder();
        bui.append("select a.exa_codigo from examerequisicao a ");
        bui.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        bui.append("where a.fil_codigo = ").append(filial);
        bui.append(" and a.req_codigo = ").append(requisicao);
        bui.append(" and b.exa_inmetro = true ");
        bui.append(" and a.exr_excluido = false ");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            retorno = rs.next();
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getQuantidadeAlteracoesRequisicao(Statement st, String filial, String requisicao) throws SQLException {
        int retorno = 0;
        StringBuilder bui = new StringBuilder();
        bui.append("select count(req_codigo) from requisicaolog ");
        bui.append("where fil_codigo = ").append(filial);
        bui.append(" and req_codigo = ").append(requisicao);
        bui.append(" and rlo_tipo = '").append("A").append("'");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            retorno = rs.next() ? rs.getInt(1) : 0;
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date[] pegaUltimaDataExameRequisicao(Statement st, String filial, String requisicao) throws SQLException {
        Date[] dateArray;
        StringBuilder bui = new StringBuilder();
        bui.append(" select exr_datadigita, exr_dataassina, exr_datamaterial, exr_excluido from examerequisicao ");
        bui.append("where fil_codigo = ").append(filial);
        bui.append(" and req_codigo = ").append(requisicao);
        ResultSet rs = null;
        Date[] datas = new Date[3];
        try {
            rs = st.executeQuery(bui.toString());
            while (rs.next()) {
                Impressao.validaUltimaData(rs, datas);
            }
            dateArray = datas;
        }
        catch (Throwable throwable) {
            Impressao.fechaConexao(rs);
            throw throwable;
        }
        Impressao.fechaConexao(rs);
        return dateArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getQuantidadeAlteracoesRequisicaoComConferencia(Statement st, String filial, String requisicao) throws SQLException {
        int retorno = 0;
        StringBuilder bui = new StringBuilder();
        bui.append("select count(req_codigo) from requisicaolog ");
        bui.append("where fil_codigo = ").append(filial);
        bui.append(" and req_codigo = ").append(requisicao);
        bui.append(" and rlo_tipo = '").append("C").append("'");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            retorno = rs.next() ? rs.getInt(1) : 0;
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaiorQuantidadeRetificacoesLaudo(Statement st, String filial, String requisicao) throws SQLException {
        int retorno = 0;
        StringBuilder bui = new StringBuilder();
        bui.append("select count(exa_codigo), exa_codigo, mco_codigo from examerequisicaohistoricolaudo ");
        bui.append("where fil_codigo = ").append(filial);
        bui.append(" and req_codigo = ").append(requisicao);
        bui.append(" group by exa_codigo, mco_codigo ");
        bui.append(" order by 1 desc limit 1 ");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            retorno = rs.next() ? rs.getInt(1) : 0;
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registro getDadosAlteracoesRequisicaoComConferencia(Statement st, String filial, String requisicao) throws SQLException {
        Registro retorno = null;
        StringBuilder bui = new StringBuilder();
        bui.append("select a.mva_codigo, a.rlo_descricaomotivo, a.rlo_datahora, b.mva_descricao from requisicaolog a ");
        bui.append("left join motivoalteracao b on a.fil_codigo = b.fil_codigo and a.mva_codigo = b.mva_codigo ");
        bui.append("where a.fil_codigo = ").append(filial);
        bui.append(" and a.req_codigo = ").append(requisicao);
        bui.append(" and a.rlo_tipo = '").append("C").append("'");
        bui.append(" order by a.rlo_codigo desc limit 1 ");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            retorno = rs.next() ? new Registro(rs) : null;
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registro getDadosAlteracoesRequisicao(Statement st, String filial, String requisicao) throws SQLException {
        Registro retorno = null;
        StringBuilder bui = new StringBuilder();
        bui.append("select a.mva_codigo, a.rlo_descricaomotivo, a.rlo_datahora, b.mva_descricao from requisicaolog a ");
        bui.append("left join motivoalteracao b on a.fil_codigo = b.fil_codigo and a.mva_codigo = b.mva_codigo ");
        bui.append("where a.fil_codigo = ").append(filial);
        bui.append(" and a.req_codigo = ").append(requisicao);
        bui.append(" and a.rlo_tipo = '").append("A").append("'");
        bui.append(" order by a.rlo_codigo desc limit 1 ");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            retorno = rs.next() ? new Registro(rs) : null;
        }
        return retorno;
    }

    public static String pegaHashExameRequisicao(Statement st, String filial, String requisicao, String exame, String material) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("select exh_hash from examerequisicaohash ");
        bui.append("where fil_codigo = ").append(filial);
        bui.append(" and req_codigo = ").append(requisicao);
        bui.append(" and exa_codigo = '").append(StringUtil.textoDB(exame)).append("' ");
        bui.append(" and mco_codigo = ").append(material);
        bui.append(" order by exh_codigo desc limit 1 ");
        ResultSet rs = st.executeQuery(bui.toString());
        if (rs.next() && !DBUtil.campoNull(rs.getString(1))) {
            return rs.getString(1);
        }
        return "";
    }

    public static String getSqlDescricaoVolumeRecipientesColetaTriagemExameRequisicao(String filial, String exame, String material, boolean isColeta) {
        StringBuilder sql = new StringBuilder();
        if (isColeta) {
            sql.append(" select b.rec_descricao, to_char(a.rco_volume, '990D000') as volume from recipcoleta a ");
        } else {
            sql.append(" select b.rec_descricao, to_char(a.rtr_volume, '990D000') as volume from reciptriagem a  ");
        }
        sql.append(" left join recipientes b on a.fil_codigo = b.fil_codigo and a.rec_codigo = b.rec_codigo ");
        sql.append("where a.fil_codigo = ").append(filial);
        sql.append(" and a.exa_codigo = '").append(StringUtil.textoDB(exame)).append("' ");
        sql.append(" and a.mco_codigo = ").append(material);
        sql.append(" order by a.rec_codigo ");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDataImpressaoEtqTriagemInicial(Statement st, String filial, String requisicao) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("select a.exi_datahora as exi_datahora from examerequisicaoetiquetas a ");
        bui.append("where a.fil_codigo = ").append(filial);
        bui.append(" and a.req_codigo=").append(requisicao);
        bui.append(" and a.exi_tipoetiqueta = 'T'");
        bui.append(" order by a.exi_datahora limit 1 ");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            if (rs.next()) {
                Timestamp timestamp = rs.getTimestamp("exi_datahora");
                return timestamp;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDataImpressaoEtqTriagemFinal(Statement st, String filial, String requisicao) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("select a.exi_datahora as exi_datahora from examerequisicaoetiquetas a ");
        bui.append("where a.fil_codigo = ").append(filial);
        bui.append(" and a.req_codigo=").append(requisicao);
        bui.append(" and a.exi_tipoetiqueta = 'T'");
        bui.append(" order by a.exi_datahora desc limit 1 ");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            if (rs.next()) {
                Timestamp timestamp = rs.getTimestamp("exi_datahora");
                return timestamp;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDataImpressaoEtqColetaInicial(Statement st, String filial, String requisicao) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("select a.exi_datahora as exi_datahora from examerequisicaoetiquetas a ");
        bui.append("where a.fil_codigo = ").append(filial);
        bui.append(" and a.req_codigo=").append(requisicao);
        bui.append(" and a.exi_tipoetiqueta = 'C'");
        bui.append(" order by a.exi_datahora limit 1 ");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            if (rs.next()) {
                Timestamp timestamp = rs.getTimestamp("exi_datahora");
                return timestamp;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDataImpressaoEtqColetaFinal(Statement st, String filial, String requisicao) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("select a.exi_datahora as exi_datahora from examerequisicaoetiquetas a ");
        bui.append("where a.fil_codigo = ").append(filial);
        bui.append(" and a.req_codigo=").append(requisicao);
        bui.append(" and a.exi_tipoetiqueta = 'C'");
        bui.append(" order by a.exi_datahora desc limit 1 ");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            if (rs.next()) {
                Timestamp timestamp = rs.getTimestamp("exi_datahora");
                return timestamp;
            }
        }
        return null;
    }

    public static String[] pegaDescricaoRecipientesColetaTriagemExameRequisicao(ResultSet rs) throws SQLException {
        String[] descricaoVolume = new String[2];
        StringBuilder descricao = new StringBuilder();
        StringBuilder volume = new StringBuilder();
        while (rs.next()) {
            if (descricao.length() > 0) {
                descricao.append(", ");
            }
            if (volume.length() > 0) {
                volume.append(", ");
            }
            descricao.append(rs.getString("rec_descricao"));
            volume.append(rs.getString("volume"));
        }
        descricaoVolume[0] = descricao.toString();
        descricaoVolume[1] = volume.toString();
        rs.close();
        return descricaoVolume;
    }

    public static void exportarPDFParaWeb(String filial, String requisicao, String codigoBaseWeb) {
        ThreadExportaPDFWebImpressao th = new ThreadExportaPDFWebImpressao(filial, requisicao, codigoBaseWeb);
        th.start();
    }

    public static byte[] gerarPdfRelatorio(Relatorio rel, String layout) {
        DefaultFontMapper mapper = new DefaultFontMapper();
        mapper.insertDirectory("c:/windows/fonts");
        float w = StringUtil.getFloat(layout, "larguraPagina") * 10.0f;
        float h = StringUtil.getFloat(layout, "alturaPagina") * 10.0f;
        float larguraPagina = ScreenUtil.getPixelsDeMilimetros(w);
        float alturaPaginaPixels = ScreenUtil.getPixelsDeMilimetros(h);
        int totalPaginas = rel.getQuantidadePaginas();
        int largura = (int)larguraPagina;
        int altura = (int)alturaPaginaPixels;
        Document document = new Document(new Rectangle(0.0f, 0.0f, (float)largura, (float)altura));
        ByteArrayOutputStream arrayPdf = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)arrayPdf);
        writer.setFullCompression();
        document.open();
        PdfContentByte cb = writer.getDirectContent();
        for (int p = 0; p < totalPaginas; ++p) {
            PdfTemplate tp = cb.createTemplate((float)largura, (float)altura);
            PdfGraphics2D g2 = new PdfGraphics2D(cb, (float)largura, (float)altura, (FontMapper)mapper, false, false, 0.0f);
            PageFormat pf = new PageFormat();
            if (largura > altura) {
                pf.setOrientation(0);
            }
            rel.print((Graphics)g2, pf, p);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            document.newPage();
        }
        document.close();
        writer.close();
        return arrayPdf.toByteArray();
    }

    public static byte[] gerarPdfDocumento(Documento doc) throws IOException, PrinterException {
        DefaultFontMapper mapper = new DefaultFontMapper();
        mapper.insertDirectory("c:/windows/fonts");
        doc.setConsiderarPDF(true);
        doc.prepararImpressao();
        int totalPaginas = doc.getQuantidadePaginas();
        int largura = doc.getLarguraAreaImpressao() + doc.getMargemDireita() + doc.getMargemEsquerda();
        int altura = doc.getAlturaAreaImpressao() + doc.getMargemInferior() + doc.getMargemSuperior();
        Document document = new Document(new Rectangle(0.0f, 0.0f, (float)largura, (float)altura));
        ByteArrayOutputStream arrayPdf = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)arrayPdf);
        writer.setFullCompression();
        document.setMargins((float)doc.getMargemEsquerda(), (float)doc.getMargemDireita(), (float)doc.getMargemSuperior(), (float)doc.getMargemInferior());
        document.open();
        PdfContentByte cb = writer.getDirectContent();
        writer.setMargins((float)doc.getMargemEsquerda(), (float)doc.getMargemDireita(), (float)doc.getMargemSuperior(), (float)doc.getMargemInferior());
        String mascaraPDF = doc.getMascaraPdf();
        for (int p = 0; p < totalPaginas; ++p) {
            if (!Funcoes.textoVazio(mascaraPDF)) {
                PdfReader layoutCliente = new PdfReader(Base64.decodeBase64((String)mascaraPDF));
                PdfImportedPage ip = writer.getImportedPage(layoutCliente, 1);
                cb = writer.getDirectContent();
                cb.addTemplate((PdfTemplate)ip, 0.0f, 0.0f);
            }
            PdfTemplate tp = cb.createTemplate((float)largura, (float)altura);
            PdfGraphics2D g2 = new PdfGraphics2D(cb, (float)largura, (float)altura, (FontMapper)mapper, false, false, 0.0f);
            doc.print((Graphics)g2, new PageFormat(), p);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            document.newPage();
        }
        document.close();
        writer.close();
        return arrayPdf.toByteArray();
    }

    private static void validaUltimaData(ResultSet rs, Date[] datas) throws SQLException {
        String[] campoData = new String[]{"exr_datadigita", "exr_dataassina", "exr_datamaterial"};
        for (int i = 0; i < 3; ++i) {
            if (!Impressao.dataVazia(rs, campoData[i]) || datas[i] != null && !datas[i].before(rs.getTimestamp(campoData[i]))) continue;
            datas[i] = rs.getTimestamp(campoData[i]);
        }
    }

    private static boolean dataVazia(ResultSet rs, String campo) throws SQLException {
        return !rs.getBoolean("exr_excluido") && rs.getTimestamp(campo) != null;
    }

    private static boolean verificaSituacao(ResultSet rs, boolean considerarConferencia) throws SQLException {
        return rs.getString("exr_excluido").equals("E") || rs.getString("exr_excluido").equals("A") || rs.getString("exr_excluido").equals("I") || rs.getString("exr_excluido").equals(considerarConferencia ? "C" : "L");
    }

    private static void fechaConexao(ResultSet rs) throws SQLException {
        if (rs != null) {
            rs.close();
        }
    }

    /*
     * Opcode count of 19776 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        CAMPOS_ORCAMENTO = new String[]{"cnpjCpfConvenio", "codigoExame", "descricaoExame", "materialColetadoExame", "abreviaturaMaterialColetadoExame", "valorDescontoExame", "valorAcrescimoExame", "precoExame", "celularPaciente", "codigoPrazoEntregaExame", "descricaoPrazoEntregaExame", "referenciasExames", "referenciaExame", "ambExame", "terceirizado", "fantasiaConvenio", "codigoConvenio", "valorDesconto", "percentualDesconto", "valorAcrescimo", "percentualAcrescimo", "codigoFilial", "razaoSocialFilial", "descricaoFilial", "foneFilial", "nomeCidade", "estadoCidade", "cnpjFilial", "enderecoFilial", "complementoFilial", "nomeBairro", "faxFilial", "cepFilial", "codigoUsuario", "nomeUsuario", "assinaturaUsuario", "codigoUsuarioLogado", "nomeUsuarioLogado", "assinaturaUsuarioLogado", "dataHoraOrcamento", "codigoOrcamento", "codigoPaciente", "nomePaciente", "solicitanteOrcamento", "proprietarioOrcamento", "animalOrcamento", "limiteQuantificacaoExame", "foneOrcamento", "contatoOrcamento", "foneContatoOrcamento", "emailOrcamento", "validadeOrcamento", "observacaoOrcamento", "valorUnitarioExame", "quantidadeExameOrcamento", "codigoFormaPagamento", "descricaoFormaPagamento", "certificadoInmetroExame", "codigoMetodologiaExame", "descricaoMetodologiaExame", "quantidadeAlteracoesOrcamento", "diferencaValorMinimo", "valorTotalOrcamento", "limiteDeDeteccaoExame", "senhaWebConvenio", "cpfPaciente", "cnpjEmpresa", "possuiExameCertificadoInmetro", "passaportePaciente"};
        CAMPOS_CARTEIRA = new String[]{"numeroEnderecoPaciente", "tipoLogradouroPaciente", "codigoPaciente", "nomePaciente", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "whatsAppPaciente", "fatorRHPaciente", "fatorDUPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroPaciente", "descricaoBairroPaciente", "dataCadastroPaciente", "senhaWebPaciente", "nomeSocialPaciente", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente", "idadeRequisicaoPaciente", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "matriculaPaciente", "dataValidadeCarteiraPaciente", "planoPaciente", "titularPaciente", "cartaoSusPaciente", "prontuarioPaciente", "conselhoMedico", "crmMedico", "ufMedico", "nomeMedico"};
        CAMPOS_COMPROVANTE = new String[]{"cartaoSUSPaciente", "cartaoSUSRequisicao", "numeroEnderecoCobrancaPaciente", "numeroEnderecoResponsavelRequisicao", "numeroEnderecoPaciente", "numeroEnderecoConvenioRepasse", "whatsAppPaciente", "numeroEnderecoConvenio", "numeroEnderecoMedico", "tipoLogradouroMedico", "tipoLogradouroResponsavelRequisicao", "tipoLogradouroPaciente", "tipoLogradouroCobrancaPaciente", "tipoLogradouroConvenio", "tipoLogradouroConvenioRepasse", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anoMesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "guiaRequisicao", "notaCaixaRequisicao", "complementoDestinoRequisicao", "multiguiasRequisicao", "imprimirSeparadoRequisicao", "datasEntregaParcialRequisicao", "existeExamesSemMaterial", "codigoSituacao", "descricaoSituacao", "tipoUltimoPagamentoRequisicao", "prontuarioRequisicao", "codigoUsuario", "nomeUsuario", "assinaturaUsuario", "codigoUsuarioAbertura", "nomeUsuarioAbertura", "assinaturaUsuarioAbertura", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoCidadeUnidadeSaude", "descricaoCidadeUnidadeSaude", "estadoCidadeUnidadeSaude", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroMedico", "descricaoBairroMedico", "codigoBairroDestino", "descricaoBairroDestino", "codigoBairroColeta", "descricaoBairroColeta", "perguntasRequisicao", "codigoBairroUnidadeSaude", "descricaoBairroUnidadeSaude", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "enviarParaWebDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoUnidadeSaude", "descricaoUnidadeSaude", "enderecoUnidadeSaude", "complementoUnidadeSaude", "cepUnidadeSaude", "foneUnidadeSaude", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "integracaoEntreFiliais", "tipoIntegracaoEntreFiliais", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "nomeMedicoSemAcentos", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "siteMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "codigoConvenioRepasse", "fantasiaConvenioRepasse", "razaoSocialConvenioRepasse", "enderecoConvenioRepasse", "complementoConvenioRepasse", "cepConvenioRepasse", "foneConvenioRepasse", "email1ConvenioRepasse", "email2ConvenioRepasse", "siteConvenioRepasse", "codigoPaciente", "nomePaciente", "nomePacienteSemAcentos", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorRHPaciente", "fatorDUPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "nomePagadorPaciente", "cpfPagadorPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "senhaWebPaciente", "quartoRequisicao", "leitoRequisicao", "codigoAla", "descricaoAla", "codigoTabelaPreco", "descricaoTabelaPreco", "moedaTabelaPreco", "fumantePaciente", "diabeticoPaciente", "periodoGestacionalRequisicao", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "dataColetaProdutoRequisicao", "horaColetaProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "caracteristicasSanitariasProdutoRequisicao", "condicoesAmbientaisProdutoRequisicao", "procedimentoColetaProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "partidaProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "descricaoUnidadeProdutoRequisicao", "areaProdutoRequisicao", "codigoEmbalagemProdutoRequisicao", "descricaoEmbalagemProdutoRequisicao", "nomeResponsavelRequisicao", "foneResponsavelRequisicao", "anoPRPProdutoRequisicao", "cicloPRPProdutoRequisicao", "amostraPRPProdutoRequisicao", "amostraSupervisaoPRPProdutoRequisicao", "horaInicioTurnoPRPProdutoRequisicao", "turnoPRPProdutoRequisicao", "linhaPRPProdutoRequisicao", "volumeAbatePRPProdutoRequisicao", "cargoResponsavelRequisicao", "emailResponsavelRequisicao", "razaoSocialResponsavelRequisicao", "enderecoResponsavelRequisicao", "complementoResponsavelRequisicao", "cepResponsavelRequisicao", "cpfCnpjResponsavelRequisicao", "descricaoCidadeResponsavelRequisicao", "estadoCidadeResponsavelRequisicao", "descricaoBairroResponsavelRequisicao", "dataRecebimentoProdutoRequisicao", "horaRecebimentoProdutoRequisicao", "localColetaProdutoRequisicao", "numeroSolicitacaoProdutoRequisicao", "fornecedorProdutoRequisicao", "codigoProdutoAlimento", "descricaoProdutoAlimento", "codigoCategoriaProdutoAlimento", "descricaoCategoriaProdutoAlimento", "procedenciaRequisicao", "suplementoRequisicao", "nomeMae", "codigoBairroCobrancaPaciente", "descricaoBairroCobrancaPaciente", "codigoCidadeCobrancaPaciente", "descricaoCidadeCobrancaPaciente", "estadoCidadeCobrancaPaciente", "razaoSocialPaciente", "cnpjPaciente", "inscricaoEstadualPaciente", "proprietarioPaciente", "sifPaciente", "enderecoCobrancaPaciente", "complementoCobrancaPaciente", "cepCobrancaPaciente", "foneCobrancaPaciente", "responsavelCobrancaPaciente", "pelagemPaciente", "codigoEspecie", "descricaoEspecie", "cientificoEspecie", "codigoRaca", "descricaoRaca", "cientificoRaca", "codigoEmpresaPaciente", "fantasiaEmpresaPaciente", "razaoSocialEmpresaPaciente", "foneEmpresaPaciente", "codigoPais", "nomePais", "dataCertificado", "numeroCertificado", "termoColetaAmostra", "totalTaxaRequisicao", "quantidadeExameSemMaterial", "nomeSocialPaciente", "responsavelPacienteRequisicao", "cpfResponsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente", "idadeRequisicaoPaciente", "chaveAcessoRequisicao", "passaportePaciente"};
        CAMPOS_RECEPCAO_AMOSTRA = new String[]{"numeroEnderecoCobrancaPaciente", "numeroEnderecoResponsavelRequisicao", "numeroEnderecoPaciente", "numeroEnderecoConvenioRepasse", "numeroEnderecoConvenio", "numeroEnderecoMedico", "tipoLogradouroMedico", "tipoLogradouroResponsavelRequisicao", "tipoLogradouroPaciente", "tipoLogradouroCobrancaPaciente", "tipoLogradouroConvenio", "tipoLogradouroConvenioRepasse", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anoMesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "guiaRequisicao", "notaCaixaRequisicao", "complementoDestinoRequisicao", "multiguiasRequisicao", "imprimirSeparadoRequisicao", "datasEntregaParcialRequisicao", "existeExamesSemMaterial", "codigoSituacao", "descricaoSituacao", "tipoUltimoPagamentoRequisicao", "prontuarioRequisicao", "codigoUsuario", "nomeUsuario", "assinaturaUsuario", "codigoUsuarioAbertura", "nomeUsuarioAbertura", "assinaturaUsuarioAbertura", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoCidadeUnidadeSaude", "descricaoCidadeUnidadeSaude", "estadoCidadeUnidadeSaude", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroMedico", "descricaoBairroMedico", "codigoBairroDestino", "descricaoBairroDestino", "codigoBairroColeta", "descricaoBairroColeta", "codigoBairroUnidadeSaude", "descricaoBairroUnidadeSaude", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "enviarParaWebDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoUnidadeSaude", "descricaoUnidadeSaude", "enderecoUnidadeSaude", "complementoUnidadeSaude", "cepUnidadeSaude", "foneUnidadeSaude", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "integracaoEntreFiliais", "tipoIntegracaoEntreFiliais", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "nomeMedicoSemAcentos", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "siteMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "codigoConvenioRepasse", "fantasiaConvenioRepasse", "razaoSocialConvenioRepasse", "enderecoConvenioRepasse", "complementoConvenioRepasse", "cepConvenioRepasse", "foneConvenioRepasse", "email1ConvenioRepasse", "email2ConvenioRepasse", "siteConvenioRepasse", "codigoPaciente", "nomePaciente", "nomePacienteSemAcentos", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorRHPaciente", "fatorDUPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "nomePagadorPaciente", "cpfPagadorPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "senhaWebPaciente", "quartoRequisicao", "leitoRequisicao", "codigoAla", "descricaoAla", "codigoTabelaPreco", "descricaoTabelaPreco", "moedaTabelaPreco", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "dataColetaProdutoRequisicao", "horaColetaProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "caracteristicasSanitariasProdutoRequisicao", "condicoesAmbientaisProdutoRequisicao", "procedimentoColetaProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "partidaProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "descricaoUnidadeProdutoRequisicao", "areaProdutoRequisicao", "codigoEmbalagemProdutoRequisicao", "descricaoEmbalagemProdutoRequisicao", "nomeResponsavelRequisicao", "foneResponsavelRequisicao", "anoPRPProdutoRequisicao", "cicloPRPProdutoRequisicao", "amostraPRPProdutoRequisicao", "amostraSupervisaoPRPProdutoRequisicao", "horaInicioTurnoPRPProdutoRequisicao", "turnoPRPProdutoRequisicao", "linhaPRPProdutoRequisicao", "volumeAbatePRPProdutoRequisicao", "cargoResponsavelRequisicao", "emailResponsavelRequisicao", "razaoSocialResponsavelRequisicao", "enderecoResponsavelRequisicao", "complementoResponsavelRequisicao", "cepResponsavelRequisicao", "cpfCnpjResponsavelRequisicao", "descricaoCidadeResponsavelRequisicao", "estadoCidadeResponsavelRequisicao", "descricaoBairroResponsavelRequisicao", "dataRecebimentoProdutoRequisicao", "horaRecebimentoProdutoRequisicao", "localColetaProdutoRequisicao", "numeroSolicitacaoProdutoRequisicao", "fornecedorProdutoRequisicao", "codigoProdutoAlimento", "descricaoProdutoAlimento", "codigoCategoriaProdutoAlimento", "descricaoCategoriaProdutoAlimento", "codigoBairroCobrancaPaciente", "descricaoBairroCobrancaPaciente", "codigoCidadeCobrancaPaciente", "descricaoCidadeCobrancaPaciente", "estadoCidadeCobrancaPaciente", "razaoSocialPaciente", "cnpjPaciente", "inscricaoEstadualPaciente", "proprietarioPaciente", "sifPaciente", "enderecoCobrancaPaciente", "complementoCobrancaPaciente", "cepCobrancaPaciente", "foneCobrancaPaciente", "responsavelCobrancaPaciente", "pelagemPaciente", "codigoEspecie", "descricaoEspecie", "cientificoEspecie", "codigoRaca", "descricaoRaca", "cientificoRaca", "codigoEmpresaPaciente", "fantasiaEmpresaPaciente", "razaoSocialEmpresaPaciente", "foneEmpresaPaciente", "codigoPais", "nomePais", "dataCertificado", "numeroCertificado", "termoColetaAmostra", "totalTaxaRequisicao", "nomeSocialPaciente", "procedenciaRequisicao", "responsavelPacienteRequisicao", "cpfResponsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente"};
        CAMPOS_RECIBO = new String[]{"cartaoSUSPaciente", "cartaoSUSRequisicao", "tipoLogradouroEnderecoPaciente", "tipoLogradouroResponsavelRequisicao", "tipoLogradouroCobrancaPaciente", "tipoLogradouroConvenio", "whatsAppPaciente", "tipoLogradouroConvenioRepasse", "tipoLogradouroMedico", "numeroEnderecoConvenio", "numeroEnderecoMedico", "numeroEnderecoConvenioRepasse", "numeroEnderecoPaciente", "numeroEnderecoResponsavelRequisicao", "numeroEnderecoCobrancaPaciente", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anoMesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "guiaRequisicao", "notaCaixaRequisicao", "prontuarioRequisicao", "complementoDestinoRequisicao", "multiguiasRequisicao", "imprimirSeparadoRequisicao", "datasEntregaParcialRequisicao", "existeExamesSemMaterial", "codigoSituacao", "descricaoSituacao", "tipoUltimoPagamentoRequisicao", "codigoUsuario", "nomeUsuario", "assinaturaUsuario", "codigoUsuarioAbertura", "nomeUsuarioAbertura", "assinaturaUsuarioAbertura", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoCidadeUnidadeSaude", "descricaoCidadeUnidadeSaude", "estadoCidadeUnidadeSaude", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroMedico", "descricaoBairroMedico", "codigoBairroDestino", "descricaoBairroDestino", "codigoBairroColeta", "descricaoBairroColeta", "codigoBairroUnidadeSaude", "descricaoBairroUnidadeSaude", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "enviarParaWebDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoUnidadeSaude", "descricaoUnidadeSaude", "enderecoUnidadeSaude", "complementoUnidadeSaude", "cepUnidadeSaude", "foneUnidadeSaude", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "integracaoEntreFiliais", "tipoIntegracaoEntreFiliais", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "siteMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "codigoConvenioRepasse", "fantasiaConvenioRepasse", "razaoSocialConvenioRepasse", "enderecoConvenioRepasse", "complementoConvenioRepasse", "cepConvenioRepasse", "foneConvenioRepasse", "email1ConvenioRepasse", "email2ConvenioRepasse", "siteConvenioRepasse", "codigoPaciente", "nomePaciente", "nomeSocialPaciente", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorRHPaciente", "fatorDUPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "senhaWebPaciente", "quartoRequisicao", "nomePagadorPaciente", "cpfPagadorPaciente", "passaportePaciente", "leitoRequisicao", "codigoAla", "descricaoAla", "codigoTabelaPreco", "descricaoTabelaPreco", "moedaTabelaPreco", "fumantePaciente", "diabeticoPaciente", "codigoProdutoAlimento", "descricaoProdutoAlimento", "codigoCategoriaProdutoAlimento", "descricaoCategoriaProdutoAlimento", "periodoGestacionalRequisicao", "numeroNotaFiscal", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "dataColetaProdutoRequisicao", "horaColetaProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "caracteristicasSanitariasProdutoRequisicao", "condicoesAmbientaisProdutoRequisicao", "procedimentoColetaProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "partidaProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "descricaoUnidadeProdutoRequisicao", "anoPRPProdutoRequisicao", "cicloPRPProdutoRequisicao", "amostraPRPProdutoRequisicao", "amostraSupervisaoPRPProdutoRequisicao", "horaInicioTurnoPRPProdutoRequisicao", "turnoPRPProdutoRequisicao", "linhaPRPProdutoRequisicao", "volumeAbatePRPProdutoRequisicao", "areaProdutoRequisicao", "codigoEmbalagemProdutoRequisicao", "descricaoEmbalagemProdutoRequisicao", "nomeResponsavelRequisicao", "foneResponsavelRequisicao", "cargoResponsavelRequisicao", "emailResponsavelRequisicao", "razaoSocialResponsavelRequisicao", "enderecoResponsavelRequisicao", "complementoResponsavelRequisicao", "cepResponsavelRequisicao", "cpfCnpjResponsavelRequisicao", "descricaoCidadeResponsavelRequisicao", "estadoCidadeResponsavelRequisicao", "descricaoBairroResponsavelRequisicao", "dataRecebimentoProdutoRequisicao", "horaRecebimentoProdutoRequisicao", "localColetaProdutoRequisicao", "numeroSolicitacaoProdutoRequisicao", "fornecedorProdutoRequisicao", "procedenciaRequisicao", "codigoBairroCobrancaPaciente", "descricaoBairroCobrancaPaciente", "codigoCidadeCobrancaPaciente", "descricaoCidadeCobrancaPaciente", "estadoCidadeCobrancaPaciente", "razaoSocialPaciente", "cnpjPaciente", "inscricaoEstadualPaciente", "proprietarioPaciente", "sifPaciente", "enderecoCobrancaPaciente", "complementoCobrancaPaciente", "cepCobrancaPaciente", "foneCobrancaPaciente", "responsavelCobrancaPaciente", "pelagemPaciente", "codigoEspecie", "descricaoEspecie", "cientificoEspecie", "codigoRaca", "descricaoRaca", "cientificoRaca", "codigoEmpresaPaciente", "fantasiaEmpresaPaciente", "razaoSocialEmpresaPaciente", "foneEmpresaPaciente", "codigoPais", "nomePais", "dataCertificado", "numeroCertificado", "termoColetaAmostra", "totalTaxaRequisicao", "quantidadeExameSemMaterial", "responsavelPacienteRequisicao", "cpfResponsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente", "idadeRequisicaoPaciente", "perguntasRequisicao", "nomeMae"};
        CAMPOS_CAPA = new String[]{"cartaoSUSPaciente", "cartaoSUSRequisicao", "numeroEnderecoCobrancaPaciente", "numeroEnderecoResponsavelRequisicao", "numeroEnderecoPaciente", "numeroEnderecoConvenio", "numeroEnderecoMedico", "whatsAppPaciente", "tipoLogradouroPaciente", "tipoLogradouroConvenio", "tipoLogradouroResponsavelRequisicao", "tipoLogradouroMedico", "tipoLogradouroCobrancaPaciente", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anoMesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "guiaRequisicao", "notaCaixaRequisicao", "prontuarioRequisicao", "complementoDestinoRequisicao", "multiguiasRequisicao", "imprimirSeparadoRequisicao", "datasEntregaParcialRequisicao", "existeExamesSemMaterial", "codigoSituacao", "descricaoSituacao", "tipoUltimoPagamentoRequisicao", "codigoUsuario", "nomeUsuario", "assinaturaUsuario", "codigoUsuarioAbertura", "nomeUsuarioAbertura", "assinaturaUsuarioAbertura", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoCidadeUnidadeSaude", "descricaoCidadeUnidadeSaude", "estadoCidadeUnidadeSaude", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroMedico", "descricaoBairroMedico", "codigoBairroDestino", "descricaoBairroDestino", "codigoBairroColeta", "descricaoBairroColeta", "codigoBairroUnidadeSaude", "descricaoBairroUnidadeSaude", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "enviarParaWebDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoUnidadeSaude", "descricaoUnidadeSaude", "enderecoUnidadeSaude", "complementoUnidadeSaude", "cepUnidadeSaude", "foneUnidadeSaude", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "integracaoEntreFiliais", "tipoIntegracaoEntreFiliais", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "siteMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "codigoConvenioRepasse", "fantasiaConvenioRepasse", "razaoSocialConvenioRepasse", "enderecoConvenioRepasse", "complementoConvenioRepasse", "cepConvenioRepasse", "foneConvenioRepasse", "email1ConvenioRepasse", "email2ConvenioRepasse", "siteConvenioRepasse", "codigoPaciente", "nomePaciente", "nomeSocialPaciente", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorRHPaciente", "fatorDUPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "senhaWebPaciente", "quartoRequisicao", "nomePagadorPaciente", "cpfPagadorPaciente", "leitoRequisicao", "codigoAla", "descricaoAla", "codigoTabelaPreco", "descricaoTabelaPreco", "moedaTabelaPreco", "codigoApoiadoPaciente", "vipPaciente", "fumantePaciente", "diabeticoPaciente", "procedenciaRequisicao", "periodoGestacionalRequisicao", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "dataColetaProdutoRequisicao", "horaColetaProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "caracteristicasSanitariasProdutoRequisicao", "condicoesAmbientaisProdutoRequisicao", "procedimentoColetaProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "partidaProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "descricaoUnidadeProdutoRequisicao", "anoPRPProdutoRequisicao", "cicloPRPProdutoRequisicao", "amostraPRPProdutoRequisicao", "amostraSupervisaoPRPProdutoRequisicao", "horaInicioTurnoPRPProdutoRequisicao", "turnoPRPProdutoRequisicao", "linhaPRPProdutoRequisicao", "volumeAbatePRPProdutoRequisicao", "areaProdutoRequisicao", "codigoEmbalagemProdutoRequisicao", "descricaoEmbalagemProdutoRequisicao", "nomeResponsavelRequisicao", "foneResponsavelRequisicao", "cargoResponsavelRequisicao", "emailResponsavelRequisicao", "razaoSocialResponsavelRequisicao", "enderecoResponsavelRequisicao", "complementoResponsavelRequisicao", "cepResponsavelRequisicao", "cpfCnpjResponsavelRequisicao", "descricaoCidadeResponsavelRequisicao", "estadoCidadeResponsavelRequisicao", "descricaoBairroResponsavelRequisicao", "dataRecebimentoProdutoRequisicao", "horaRecebimentoProdutoRequisicao", "localColetaProdutoRequisicao", "numeroSolicitacaoProdutoRequisicao", "fornecedorProdutoRequisicao", "codigoProdutoAlimento", "descricaoProdutoAlimento", "codigoCategoriaProdutoAlimento", "descricaoCategoriaProdutoAlimento", "suplementoRequisicao", "codigoBairroCobrancaPaciente", "descricaoBairroCobrancaPaciente", "codigoCidadeCobrancaPaciente", "descricaoCidadeCobrancaPaciente", "estadoCidadeCobrancaPaciente", "razaoSocialPaciente", "cnpjPaciente", "inscricaoEstadualPaciente", "proprietarioPaciente", "sifPaciente", "enderecoCobrancaPaciente", "complementoCobrancaPaciente", "cepCobrancaPaciente", "foneCobrancaPaciente", "responsavelCobrancaPaciente", "pelagemPaciente", "codigoEspecie", "descricaoEspecie", "cientificoEspecie", "codigoRaca", "descricaoRaca", "cientificoRaca", "codigoEmpresaPaciente", "fantasiaEmpresaPaciente", "razaoSocialEmpresaPaciente", "foneEmpresaPaciente", "codigoPais", "nomePais", "dataCertificado", "numeroCertificado", "termoColetaAmostra", "totalTaxaRequisicao", "quantidadeExameSemMaterial", "responsavelPacienteRequisicao", "cpfResponsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente", "observacaoPaciente", "codigoFilialCodigoRequisicao", "codigoFilialCodigoRequisicaoCodigoTubo", "idadeRequisicaoPaciente", "passaportePaciente", "perguntasRequisicao", "nomeMae"};
        CAMPOS_ANEXO = new String[]{"cartaoSUSPaciente", "cartaoSUSRequisicao", "numeroEnderecoMedico", "numeroEnderecoPaciente", "numeroEnderecoResponsavelRequisicao", "numeroEnderecoCobrancaPaciente", "whatsAppPaciente", "tipoLogradouroPaciente", "tipoLogradouroMedico", "tipoLogradouroResponsavelRequisicao", "tipoLogradouroConvenio", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anoMesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "guiaRequisicao", "notaCaixaRequisicao", "prontuarioRequisicao", "complementoDestinoRequisicao", "multiguiasRequisicao", "guiaPrincipalRequisicao", "imprimirSeparadoRequisicao", "datasEntregaParcialRequisicao", "existeExamesSemMaterial", "codigoSituacao", "descricaoSituacao", "tipoUltimoPagamentoRequisicao", "codigoUsuario", "nomeUsuario", "assinaturaUsuario", "codigoUsuarioAbertura", "nomeUsuarioAbertura", "assinaturaUsuarioAbertura", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoCidadeUnidadeSaude", "descricaoCidadeUnidadeSaude", "estadoCidadeUnidadeSaude", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroMedico", "descricaoBairroMedico", "codigoBairroDestino", "descricaoBairroDestino", "codigoBairroColeta", "descricaoBairroColeta", "codigoBairroUnidadeSaude", "descricaoBairroUnidadeSaude", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "enviarParaWebDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoUnidadeSaude", "descricaoUnidadeSaude", "enderecoUnidadeSaude", "complementoUnidadeSaude", "cepUnidadeSaude", "foneUnidadeSaude", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "integracaoEntreFiliais", "tipoIntegracaoEntreFiliais", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "siteMedico", "codigoCBOMedico", "descricaoCBOMedico", "codigoOperadoraMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "cobraExameBalcaoConvenio", "codigoConvenioRepasse", "fantasiaConvenioRepasse", "razaoSocialConvenioRepasse", "enderecoConvenioRepasse", "complementoConvenioRepasse", "cepConvenioRepasse", "foneConvenioRepasse", "email1ConvenioRepasse", "email2ConvenioRepasse", "siteConvenioRepasse", "codigoPaciente", "nomePaciente", "nomeSocialPaciente", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorRHPaciente", "fatorDUPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "senhaWebPaciente", "quartoRequisicao", "nomePagadorPaciente", "cpfPagadorPaciente", "leitoRequisicao", "codigoAla", "descricaoAla", "codigoTabelaPreco", "descricaoTabelaPreco", "moedaTabelaPreco", "fumantePaciente", "diabeticoPaciente", "procedenciaRequisicao", "idadeRequisicaoPaciente", "periodoGestacionalRequisicao", "numeroNotaFiscal", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "dataColetaProdutoRequisicao", "horaColetaProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "caracteristicasSanitariasProdutoRequisicao", "condicoesAmbientaisProdutoRequisicao", "procedimentoColetaProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "partidaProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "descricaoUnidadeProdutoRequisicao", "anoPRPProdutoRequisicao", "cicloPRPProdutoRequisicao", "amostraPRPProdutoRequisicao", "amostraSupervisaoPRPProdutoRequisicao", "horaInicioTurnoPRPProdutoRequisicao", "turnoPRPProdutoRequisicao", "linhaPRPProdutoRequisicao", "volumeAbatePRPProdutoRequisicao", "areaProdutoRequisicao", "codigoEmbalagemProdutoRequisicao", "descricaoEmbalagemProdutoRequisicao", "nomeResponsavelRequisicao", "foneResponsavelRequisicao", "cargoResponsavelRequisicao", "emailResponsavelRequisicao", "razaoSocialResponsavelRequisicao", "enderecoResponsavelRequisicao", "complementoResponsavelRequisicao", "cepResponsavelRequisicao", "cpfCnpjResponsavelRequisicao", "descricaoCidadeResponsavelRequisicao", "estadoCidadeResponsavelRequisicao", "descricaoBairroResponsavelRequisicao", "dataRecebimentoProdutoRequisicao", "horaRecebimentoProdutoRequisicao", "localColetaProdutoRequisicao", "numeroSolicitacaoProdutoRequisicao", "fornecedorProdutoRequisicao", "codigoProdutoAlimento", "descricaoProdutoAlimento", "codigoCategoriaProdutoAlimento", "descricaoCategoriaProdutoAlimento", "codigoBairroCobrancaPaciente", "descricaoBairroCobrancaPaciente", "codigoCidadeCobrancaPaciente", "descricaoCidadeCobrancaPaciente", "estadoCidadeCobrancaPaciente", "razaoSocialPaciente", "cnpjPaciente", "inscricaoEstadualPaciente", "proprietarioPaciente", "sifPaciente", "enderecoCobrancaPaciente", "complementoCobrancaPaciente", "cepCobrancaPaciente", "foneCobrancaPaciente", "responsavelCobrancaPaciente", "pelagemPaciente", "codigoEspecie", "descricaoEspecie", "cientificoEspecie", "codigoRaca", "descricaoRaca", "cientificoRaca", "codigoEmpresaPaciente", "fantasiaEmpresaPaciente", "razaoSocialEmpresaPaciente", "foneEmpresaPaciente", "codigoPais", "nomePais", "dataCertificado", "numeroCertificado", "termoColetaAmostra", "totalTaxaRequisicao", "codigoApoiadoPaciente", "quantidadeExameSemMaterial", "nomeDoPlano", "responsavelPacienteRequisicao", "cpfResponsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente", "passaportePaciente", "perguntasRequisicao", "nomeMae"};
        CAMPOS_ANEXO_COBRANCA = new String[]{"cartaoSUSPaciente", "cartaoSUSRequisicao", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "whatsAppPaciente", "numeroEnderecoPaciente", "tipoLogradouroPaciente", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anoMesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "guiaRequisicao", "notaCaixaRequisicao", "prontuarioRequisicao", "complementoDestinoRequisicao", "multiguiasRequisicao", "guiaPrincipalRequisicao", "imprimirSeparadoRequisicao", "datasEntregaParcialRequisicao", "existeExamesSemMaterial", "codigoSituacao", "descricaoSituacao", "tipoUltimoPagamentoRequisicao", "codigoUsuario", "nomeUsuario", "assinaturaUsuario", "codigoUsuarioAbertura", "nomeUsuarioAbertura", "assinaturaUsuarioAbertura", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoCidadeUnidadeSaude", "descricaoCidadeUnidadeSaude", "estadoCidadeUnidadeSaude", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroMedico", "descricaoBairroMedico", "codigoBairroDestino", "descricaoBairroDestino", "codigoBairroColeta", "descricaoBairroColeta", "codigoBairroUnidadeSaude", "descricaoBairroUnidadeSaude", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "enviarParaWebDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoUnidadeSaude", "descricaoUnidadeSaude", "enderecoUnidadeSaude", "complementoUnidadeSaude", "cepUnidadeSaude", "foneUnidadeSaude", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "integracaoEntreFiliais", "tipoIntegracaoEntreFiliais", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "siteMedico", "codigoCBOMedico", "descricaoCBOMedico", "codigoOperadoraMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "cobraExameBalcaoConvenio", "codigoConvenioRepasse", "fantasiaConvenioRepasse", "razaoSocialConvenioRepasse", "enderecoConvenioRepasse", "complementoConvenioRepasse", "cepConvenioRepasse", "foneConvenioRepasse", "email1ConvenioRepasse", "email2ConvenioRepasse", "siteConvenioRepasse", "codigoPaciente", "nomePaciente", "nomeSocialPaciente", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorRHPaciente", "fatorDUPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "senhaWebPaciente", "quartoRequisicao", "nomePagadorPaciente", "cpfPagadorPaciente", "leitoRequisicao", "codigoAla", "descricaoAla", "codigoTabelaPreco", "descricaoTabelaPreco", "moedaTabelaPreco", "fumantePaciente", "diabeticoPaciente", "procedenciaRequisicao", "idadeRequisicaoPaciente", "periodoGestacionalRequisicao", "numeroNotaFiscal", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "dataColetaProdutoRequisicao", "horaColetaProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "caracteristicasSanitariasProdutoRequisicao", "condicoesAmbientaisProdutoRequisicao", "procedimentoColetaProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "partidaProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "descricaoUnidadeProdutoRequisicao", "anoPRPProdutoRequisicao", "cicloPRPProdutoRequisicao", "amostraPRPProdutoRequisicao", "amostraSupervisaoPRPProdutoRequisicao", "horaInicioTurnoPRPProdutoRequisicao", "turnoPRPProdutoRequisicao", "linhaPRPProdutoRequisicao", "volumeAbatePRPProdutoRequisicao", "areaProdutoRequisicao", "codigoEmbalagemProdutoRequisicao", "descricaoEmbalagemProdutoRequisicao", "nomeResponsavelRequisicao", "foneResponsavelRequisicao", "cargoResponsavelRequisicao", "emailResponsavelRequisicao", "razaoSocialResponsavelRequisicao", "enderecoResponsavelRequisicao", "complementoResponsavelRequisicao", "cepResponsavelRequisicao", "cpfCnpjResponsavelRequisicao", "descricaoCidadeResponsavelRequisicao", "estadoCidadeResponsavelRequisicao", "descricaoBairroResponsavelRequisicao", "dataRecebimentoProdutoRequisicao", "horaRecebimentoProdutoRequisicao", "localColetaProdutoRequisicao", "numeroSolicitacaoProdutoRequisicao", "fornecedorProdutoRequisicao", "codigoProdutoAlimento", "descricaoProdutoAlimento", "codigoCategoriaProdutoAlimento", "descricaoCategoriaProdutoAlimento", "codigoBairroCobrancaPaciente", "descricaoBairroCobrancaPaciente", "codigoCidadeCobrancaPaciente", "descricaoCidadeCobrancaPaciente", "estadoCidadeCobrancaPaciente", "razaoSocialPaciente", "cnpjPaciente", "inscricaoEstadualPaciente", "proprietarioPaciente", "sifPaciente", "enderecoCobrancaPaciente", "complementoCobrancaPaciente", "cepCobrancaPaciente", "foneCobrancaPaciente", "responsavelCobrancaPaciente", "pelagemPaciente", "codigoEspecie", "descricaoEspecie", "cientificoEspecie", "codigoRaca", "descricaoRaca", "cientificoRaca", "codigoEmpresaPaciente", "fantasiaEmpresaPaciente", "razaoSocialEmpresaPaciente", "foneEmpresaPaciente", "codigoPais", "nomePais", "dataCertificado", "numeroCertificado", "termoColetaAmostra", "totalTaxaRequisicao", "responsavelPacienteRequisicao", "cpfResponsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente", "perguntasRequisicao"};
        CAMPOS_GUIA = new String[]{"numeroEnderecoPaciente", "tipoLogradouroPaciente", "numeroEnderecoConvenio", "tipoLogradouroEnderecoConvenio", "whatsAppPaciente", "numeroEnderecoMedico", "tipoLogradouroMedico", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anoMesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "prontuarioRequisicao", "guiaPrincipalRequisicao", "validadeCarteiraMatriculaRequisicao", "nomePlanoRequisicao", "cartaoSUSRequisicao", "cnpjConvenio", "guiaRequisicao", "notaCaixaRequisicao", "validadeGuiaRequisicao", "novaValidadeGuiaRequisicao", "codigoSituacao", "tipoUltimoPagamentoRequisicao", "codigosCID10", "descricoesCID10", "codigoCBOMedico", "descricaoCBOMedico", "codigoUsuario", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoCidadeUnidadeSaude", "descricaoCidadeUnidadeSaude", "estadoCidadeUnidadeSaude", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroMedico", "descricaoBairroMedico", "codigoBairroDestino", "descricaoBairroDestino", "codigoBairroColeta", "descricaoBairroColeta", "codigoBairroUnidadeSaude", "descricaoBairroUnidadeSaude", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoUnidadeSaude", "descricaoUnidadeSaude", "enderecoUnidadeSaude", "complementoUnidadeSaude", "cepUnidadeSaude", "foneUnidadeSaude", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "cnesFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "siteMedico", "cpfMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "codigoTabelaPreco", "descricaoTabelaPreco", "moedaTabelaPreco", "codigoTabelaANSTabelaPreco", "descricaoTabelaANSTabelaPreco", "valorCHTabelaPreco", "codigoPaciente", "nomePaciente", "nomeSocialPaciente", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorRHPaciente", "fatorDUPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "validadeCarteiraPaciente", "nomePlanoPaciente", "codigoApoiadoPaciente", "autorizacaoGuiaRequisicao", "qtdeExames", "gruposExame", "codigoOperadoraMedico", "validadeAutorizacaoRequisicao", "procedenciaRequisicao", "idadeRequisicaoPaciente", "periodoGestacionalRequisicao", "codigoPrestadorNaOperadora", "registroANS", "convenioRegistroANS", "codigoCBOSPadraoTiss", "cartaoSUSPadraoTiss", "indicadorAcidenteTiss", "nomeExecutante", "conselhoExecutante", "ufExecutante", "codigoExecutante", "cnpjConvenio", "cartaoSUSPaciente", "cartaoSUSRequisicao", "neonatoRequisicao", "responsavelPacienteRequisicao", "cpfResponsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente"};
        CAMPOS_ETQ_COLETA = new String[]{"codigoTubo", "codigosExames", "codigosExamesIdenficaPreparoEspecial", "codigoMaterial", "nomePaciente", "nomeSocialPaciente", "descricaoMaterial", "abreviaturaMaterial", "codigoRequisicao", "descricaoRecipiente", "pesoPaciente", "alturaPaciente", "idadePaciente", "gestantePaciente", "tempoJejumExame", "volumeDiureseExame", "descricaoMaterialInformado", "codigoFilial", "descricaoFilial", "capacidadeRecipiente", "dataHoraColeta", "unidadeRecipiente", "codigoSetor", "descricaoSetor", "siglaSetor", "volumeMinimoRecipiente", "cpfResponsavelPacienteRequisicao", "observacaoRequisicao", "necessitaPreparoEspecial", "codigoColeta", "descricaoColeta", "volumeUtilizadoRecipiente", "codigoDestino", "descricaoDestino", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "dataHoraAtual", "urgenteRequisicao", "tempoDiureseExame", "razaoSocialPaciente", "cnpjPaciente", "proprietarioPaciente", "sifPaciente", "matriculaRequisicao", "coletaExame", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "embalagemProdutoRequisicao", "dataEntregaRequisicao", "dataRecebimentoProdutoRequisicao", "contadorEtiqueta", "horaRecebimentoProdutoRequisicao", "localColetaProdutoRequisicao", "quantidadeEtiquetas", "codigosMultiGuiaRequisicao", "codigoPrincipalMultiGuiaRequisicao", "exameParaRecoleta", "areaProdutoRequisicao", "codigoAlaHospital", "descricaoAlaHospital", "quartoHospital", "leitoHospital", "perguntasRequisicao", "caracteristicasSanitariasProdutoRequisicao", "codigoLabExternoPadrao", "descricaoLabExternoPadrao", "adicionalLabExternoPadrao", "codigoTuboComAdicionalLabExternoPadrao", "codigoPaciente", "dataNascimentoPaciente", "idadeRequisicao", "anoMesRequisicao", "nomeEstacao", "responsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente", "dadosClinicosRequisicao", "guiaRequisicao", "codigoUsuarioAbertura", "nomeUsuarioAbertura", "conservacaoExame", "diasConservacaoExame", "temperaturaInicialConservacaoExame", "temperaturaFinalConservacaoExame", "periodoGestacionalRequisicao", "cpfPaciente", "senhaWebPaciente", "senhaWebRequisicao", "codigoRequisicaoWeb"};
        CAMPOS_ETQ_TRIAGEM = new String[]{"codigoTubo", "codigosExames", "codigosExamesIdenficaPreparoEspecial", "codigoMaterial", "nomePaciente", "nomeSocialPaciente", "descricaoMaterial", "abreviaturaMaterial", "codigoRequisicao", "descricaoRecipiente", "pesoPaciente", "alturaPaciente", "idadePaciente", "gestantePaciente", "tempoJejumExame", "volumeDiureseExame", "descricaoMaterialInformado", "codigoFilial", "descricaoFilial", "capacidadeRecipiente", "dataHoraColeta", "unidadeRecipiente", "codigoSetor", "descricaoSetor", "siglaSetor", "volumeMinimoRecipiente", "observacaoRequisicao", "necessitaPreparoEspecial", "codigoColeta", "descricaoColeta", "dataHoraTriagem", "volumeUtilizadoRecipiente", "codigoDestino", "descricaoDestino", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "dataHoraAtual", "urgenteRequisicao", "tempoDiureseExame", "razaoSocialPaciente", "cnpjPaciente", "proprietarioPaciente", "sifPaciente", "matriculaRequisicao", "coletaExame", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "embalagemProdutoRequisicao", "dataEntregaRequisicao", "dataRecebimentoProdutoRequisicao", "contadorEtiqueta", "horaRecebimentoProdutoRequisicao", "localColetaProdutoRequisicao", "quantidadeEtiquetas", "codigosMultiGuiaRequisicao", "codigoPrincipalMultiGuiaRequisicao", "exameParaRecoleta", "areaProdutoRequisicao", "codigoAlaHospital", "descricaoAlaHospital", "quartoHospital", "leitoHospital", "perguntasRequisicao", "caracteristicasSanitariasProdutoRequisicao", "codigoLabExternoPadrao", "descricaoLabExternoPadrao", "adicionalLabExternoPadrao", "codigoTuboComAdicionalLabExternoPadrao", "codigoPaciente", "dataNascimentoPaciente", "idadeRequisicao", "anoMesRequisicao", "nomeEstacao", "responsavelPacienteRequisicao", "cpfResponsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente", "codigoUsuarioAbertura", "nomeUsuarioAbertura", "conservacaoExame", "diasConservacaoExame", "temperaturaInicialConservacaoExame", "temperaturaFinalConservacaoExame", "periodoGestacionalRequisicao", "cpfPaciente", "guiaRequisicao", "senhaWebPaciente", "senhaWebRequisicao", "codigoRequisicaoWeb"};
        CAMPOS_ETQ_APOIO = new String[]{"codigoTubo", "codigosExames", "codigosExamesIdenficaPreparoEspecial", "codigoMaterial", "nomePaciente", "nomeSocialPaciente", "codigoConvenio", "descricaoMaterial", "abreviaturaMaterial", "codigoRequisicao", "descricaoRecipiente", "pesoPaciente", "alturaPaciente", "idadePaciente", "gestantePaciente", "tempoJejumExame", "volumeDiureseExame", "codigoFilial", "descricaoFilial", "capacidadeRecipiente", "dataHoraColeta", "unidadeRecipiente", "codigoSetor", "descricaoSetor", "siglaSetor", "volumeMinimoRecipiente", "observacaoRequisicao", "necessitaPreparoEspecial", "codigoColeta", "descricaoColeta", "codigoDestino", "descricaoDestino", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "dataHoraAtual", "matriculaRequisicao", "coletaExame", "razaoSocialPaciente", "cnpjPaciente", "proprietarioPaciente", "sifPaciente", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "embalagemProdutoRequisicao", "dataEntregaRequisicao", "dataRecebimentoProdutoRequisicao", "contadorEtiqueta", "horaRecebimentoProdutoRequisicao", "localColetaProdutoRequisicao", "quantidadeEtiquetas", "codigosMultiGuiaRequisicao", "codigoPrincipalMultiGuiaRequisicao", "exameParaRecoleta", "areaProdutoRequisicao", "codigoPaciente", "codigoLabExternoPadrao", "descricaoLabExternoPadrao", "adicionalLabExternoPadrao", "codigoTuboComAdicionalLabExternoPadrao", "idadeRequisicao", "anoMesRequisicao", "responsavelPacienteRequisicao", "cpfResponsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente", "senhaWebPaciente", "senhaWebRequisicao", "codigoRequisicaoWeb", "caracteristicasSanitariasProdutoRequisicao", "codigoUsuarioAbertura", "conservacaoExame", "dadosClinicosRequisicao", "dataNascimentoPaciente", "descricaoMaterialInformado", "diasConservacaoExame", "guiaRequisicao", "nomeEstacao", "nomeUsuarioAbertura", "temperaturaFinalConservacaoExame", "temperaturaInicialConservacaoExame", "urgenteRequisicao", "volumeUtilizadoRecipiente"};
        CAMPOS_MAPA = new String[]{"numeroEnderecoCobrancaPaciente", "numeroEnderecoPaciente", "numeroEnderecoConvenio", "numeroEnderecoMedico", "tipoLogradouroPaciente", "whatsAppPaciente", "tipoLogradouroCobrancaPaciente", "tipoLogradouroConvenio", "tipoLogradouroMedico", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anoMesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "imprimirSeparadoRequisicao", "datasEntregaParcialRequisicao", "codigosExames", "quartoRequisicao", "leitoRequisicao", "codigoAla", "descricaoAla", "codigoCopiaRequisicao", "perguntasRequisicao", "prontuarioRequisicao", "respostaExameRequisicao", "medicamentosRequisicao", "complementoDestinoRequisicao", "codigoSituacao", "descricaoSituacao", "codigoUsuario", "nomeUsuario", "codigoUsuarioAbertura", "nomeUsuarioAbertura", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoCidadeUnidadeSaude", "descricaoCidadeUnidadeSaude", "estadoCidadeUnidadeSaude", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroMedico", "descricaoBairroMedico", "codigoBairroDestino", "descricaoBairroDestino", "codigoBairroColeta", "descricaoBairroColeta", "codigoBairroUnidadeSaude", "descricaoBairroUnidadeSaude", "codigoPrioridade", "descricaoPrioridade", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoUnidadeSaude", "descricaoUnidadeSaude", "enderecoUnidadeSaude", "complementoUnidadeSaude", "cepUnidadeSaude", "foneUnidadeSaude", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "siteMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "codigoConvenioRepasse", "fantasiaConvenioRepasse", "razaoSocialConvenioRepasse", "enderecoConvenioRepasse", "complementoConvenioRepasse", "cepConvenioRepasse", "foneConvenioRepasse", "email1ConvenioRepasse", "email2ConvenioRepasse", "siteConvenioRepasse", "codigoPaciente", "nomePaciente", "nomeSocialPaciente", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorRHPaciente", "fatorDUPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "diabeticoPaciente", "fumantePaciente", "codigoSetor", "descricaoSetor", "responsavelSetor", "siglaSetor", "codigoExame", "descricaoExame", "ambExame", "chExame", "valorExame", "valorExamesRequisicao", "valorMateriaisRequisicao", "situacaoExame", "descricaoSituacaoExame", "dataEntregaExame", "horaEntregaExame", "tempoJejumExame", "materialInformadoExame", "urgenteExame", "usuarioColetaExame", "nomeUsuarioColetaExame", "codigoMaterial", "descricaoMaterial", "abreviaturaMaterial", "dataColetaExame", "horaColetaExame", "tempoDiureseExame", "volumeDiureseExame", "instrucoesColetaExame", "codigoApoiadoPaciente", "temRecoleta", "codigoMetodo", "procedenciaRequisicao", "periodoGestacionalRequisicao", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "dataColetaProdutoRequisicao", "horaColetaProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "caracteristicasSanitariasProdutoRequisicao", "condicoesAmbientaisProdutoRequisicao", "procedimentoColetaProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "partidaProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "descricaoUnidadeProdutoRequisicao", "anoPRPProdutoRequisicao", "cicloPRPProdutoRequisicao", "amostraPRPProdutoRequisicao", "amostraSupervisaoPRPProdutoRequisicao", "horaInicioTurnoPRPProdutoRequisicao", "turnoPRPProdutoRequisicao", "linhaPRPProdutoRequisicao", "volumeAbatePRPProdutoRequisicao", "areaProdutoRequisicao", "codigoEmbalagemProdutoRequisicao", "descricaoEmbalagemProdutoRequisicao", "nomeResponsavelRequisicao", "foneResponsavelRequisicao", "cargoResponsavelRequisicao", "emailResponsavelRequisicao", "dataRecebimentoProdutoRequisicao", "horaRecebimentoProdutoRequisicao", "localColetaProdutoRequisicao", "numeroSolicitacaoProdutoRequisicao", "codigoProdutoAlimento", "descricaoProdutoAlimento", "codigoCategoriaProdutoAlimento", "descricaoCategoriaProdutoAlimento", "descricaoCategoriaProdutoAlimento", "suplementoRequisicao", "codigoBairroCobrancaPaciente", "descricaoBairroCobrancaPaciente", "codigoCidadeCobrancaPaciente", "descricaoCidadeCobrancaPaciente", "estadoCidadeCobrancaPaciente", "razaoSocialPaciente", "cnpjPaciente", "inscricaoEstadualPaciente", "proprietarioPaciente", "sifPaciente", "enderecoCobrancaPaciente", "complementoCobrancaPaciente", "cepCobrancaPaciente", "foneCobrancaPaciente", "responsavelCobrancaPaciente", "codigosMultiGuiaRequisicao", "codigoPrincipalMultiGuiaRequisicao", "pelagemPaciente", "codigoEspecie", "descricaoEspecie", "cientificoEspecie", "codigoRaca", "descricaoRaca", "cientificoRaca", "responsavelPacienteRequisicao", "cpfResponsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente", "cartaoSUSPaciente", "cartaoSUSRequisicao", "idadeRequisicaoPaciente", "passaportePaciente"};
        CAMPOS_LAUDO = new String[]{"cartaoSUSPaciente", "cartaoSUSRequisicao", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "guiaRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anoMesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "examesIncompletosRequisicao", "complementoDestinoRequisicao", "codigoSituacao", "descricaoSituacao", "maiorQuantidadeRetificacoesLaudo", "codigoUsuario", "nomeUsuario", "assinaturaUsuario", "dataPrimeiraColetaRequisicao", "dataUltimaColetaRequisicao", "datasColetaRequisicao", "dataPrimeiraImpressaoRequisicao", "dataHoraUltimaImpressaoExame", "dataPrimeiraDigitacaoRequisicao", "dataPrimeiraConferenciaRequisicao", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroMedico", "descricaoBairroMedico", "chaveAcessoRequisicao", "codigoBairroDestino", "descricaoBairroDestino", "passaportePaciente", "codigoBairroColeta", "descricaoBairroColeta", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoUnidadeSaude", "descricaoUnidadeSaude", "enderecoUnidadeSaude", "complementoUnidadeSaude", "cepUnidadeSaude", "foneUnidadeSaude", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "idadeExtensoRequisicao", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "siteMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "codigoPaciente", "nomePaciente", "nomeSocialPaciente", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorRHPaciente", "fatorDUPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "idadePaciente", "anoMesPaciente", "maePaciente", "paiPaciente", "fumantePaciente", "diabeticoPaciente", "numeroEnderecoPaciente", "tipoEnderecoPaciente", "descricaoLaboratorioExternoExame", "quartoRequisicao", "leitoRequisicao", "codigoAla", "descricaoAla", "prontuarioRequisicao", "razaoAssinatura", "procedenciaRequisicao", "idadeRequisicaoPaciente", "periodoGestacionalRequisicao", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "dataColetaProdutoRequisicao", "horaColetaProdutoRequisicao", "dataRecebimentoProdutoRequisicao", "horaRecebimentoProdutoRequisicao", "localColetaProdutoRequisicao", "numeroSolicitacaoProdutoRequisicao", "fornecedorProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "caracteristicasSanitariasProdutoRequisicao", "condicoesAmbientaisProdutoRequisicao", "procedimentoColetaProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "partidaProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "descricaoUnidadeProdutoRequisicao", "anoPRPProdutoRequisicao", "cicloPRPProdutoRequisicao", "amostraPRPProdutoRequisicao", "amostraSupervisaoPRPProdutoRequisicao", "horaInicioTurnoPRPProdutoRequisicao", "turnoPRPProdutoRequisicao", "linhaPRPProdutoRequisicao", "volumeAbatePRPProdutoRequisicao", "areaProdutoRequisicao", "codigoEmbalagemProdutoRequisicao", "descricaoEmbalagemProdutoRequisicao", "nomeResponsavelRequisicao", "foneResponsavelRequisicao", "cargoResponsavelRequisicao", "emailResponsavelRequisicao", "nomeResponsavelRequisicao_", "foneResponsavelRequisicao_", "cargoResponsavelRequisicao_", "emailResponsavelRequisicao_", "codigoProdutoAlimento", "descricaoProdutoAlimento", "codigoCategoriaProdutoAlimento", "descricaoCategoriaProdutoAlimento", "responsavelPacienteRequisicao", "cpfResponsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "suplementoRequisicao", "codigoBairroCobrancaPaciente", "descricaoBairroCobrancaPaciente", "codigoCidadeCobrancaPaciente", "descricaoCidadeCobrancaPaciente", "estadoCidadeCobrancaPaciente", "razaoSocialPaciente", "cnpjPaciente", "inscricaoEstadualPaciente", "proprietarioPaciente", "sifPaciente", "enderecoCobrancaPaciente", "complementoCobrancaPaciente", "cepCobrancaPaciente", "foneCobrancaPaciente", "responsavelCobrancaPaciente", "codigoPaisProdutoRequisicao", "descricaoPaisProdutoRequisicao", "dataCertificadoProdutoRequisicao", "numeroCertificadoProdutoRequisicao", "termoColetaAmostraProdutoRequisicao", "programaRequisicao", "dataUltimoExameDigitadoRequisicao", "dataUltimoExameConferidoRequisicao", "possuiExameCertificadoInmetro", "quantidadeAlteracoesRequisicao", "quantidadeAlteracoesComConferenciaRequisicao", "codigoUltimoMotivoAlteracao", "descricaoUltimoMotivoAlteracao", "dataUltimoMotivoAlteracao", "motivoUltimoMotivoAlteracao", "codigoUltimoMotivoAlteracaoComConferenciaRequisicao", "descricaoUltimoMotivoAlteracaoComConferenciaRequisicao", "dataUltimoMotivoAlteracaoComConferenciaRequisicao", "motivoUltimoMotivoAlteracaoComConferenciaRequisicao", "codigoUltimoMotivoAlteracaoOficial", "descricaoUltimoMotivoAlteracaoOficial", "motivoUltimoMotivoAlteracaoOficial", "dataUltimoMotivoAlteracaoOficial", "codigoUltimoMotivoAlteracaoComConferenciaRequisicaoOficial", "descricaoUltimoMotivoAlteracaoComConferenciaRequisicaoOficial", "motivoUltimoMotivoAlteracaoComConferenciaRequisicaoOficial", "dataUltimoMotivoAlteracaoComConferenciaRequisicaoOficial", "pelagemPaciente", "codigoEspecie", "descricaoEspecie", "cientificoEspecie", "codigoRaca", "descricaoRaca", "cientificoRaca", "codigoUsuarioDigitacao", "nomeUsuarioDigitacao", "assinaturaUsuarioDigitacao", "dataConferenciaExame", "codigoUsuarioConferencia", "nomeUsuarioConferencia", "assinaturaUsuarioConferencia", "codigoUsuarioLogado", "nomeUsuarioLogado", "assinaturaUsuarioLogado", "dataColetaExame", "horaColetaExame", "hashResultado", "resultadoRetificadoExame", "codigoEmpresaPaciente", "fantasiaEmpresaPaciente", "razaoSocialEmpresaPaciente", "foneEmpresaPaciente", "motivoUltimaRetificacao", "dataHoraUltimaRetificacao", "usuarioUltimaRetificacao", "codigoSetorExamePadrao", "descricaoSetorExamePadrao", "siglaSetorExamePadrao", "dataImpressaoEtqTriagemInicial", "dataImpressaoEtqTriagemFinal", "dataImpressaoEtqColetaInicial", "dataImpressaoEtqColetaFinal"};
        CAMPOS_EXAME = new String[]{"codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "horaFaturaRequisicao", "horaRequisicao", "guiaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anomesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "complementoDestinoRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "codigoSituacao", "descricaoSituacao", "codigoUsuario", "nomeUsuario", "assinaturaUsuario", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroMedico", "descricaoBairroMedico", "codigoBairroDestino", "descricaoBairroDestino", "codigoBairroColeta", "descricaoBairroColeta", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "siteMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "codigoPaciente", "nomePaciente", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorrhPaciente", "fatorduPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "fumantePaciente", "diabeticoPaciente", "codigoApoiadoPaciente", "codigoAMBExame", "foneContatoPaciente", "contatoPaciente", "valorCh", "codigoExame", "descricaoExame", "ambExame", "chExame", "valorExame", "valorReferenciaExame", "certificadoInmetroExame", "passaportePaciente", "valorMateriaisExame", "situacaoExame", "descricaoSituacaoExame", "descricaoMaterial", "codigoMaterial", "abreviaturaMaterial", "dataColetaExame", "horaColetaExame", "usuarioColetaExame", "nomeUsuarioColetaExame", "descricaoPrazo", "codigoPrazo", "codigoMetodo", "materialExternoExame", "referenciaMetodo", "codigoMetodoExame", "codigoSOAExame", "codigoCOAExame", "urgenteExame", "resultadoRetificadoExame", "dataDigitacaoExame", "dataConferenciaExame", "descricaoMetodo", "materialInformadoExame", "dataEntregaExame", "horaEntregaExame", "codigoUsuarioDigitacao", "nomeUsuarioDigitacao", "assinaturaUsuarioDigitacao", "codigoUsuarioConferencia", "nomeUsuarioConferencia", "assinaturaUsuarioConferencia", "autorizacaoExame", "codigoUsuarioLogado", "nomeUsuarioLogado", "assinaturaUsuarioLogado", "tempoDiureseExame", "volumeDiureseExame", "tempoJejumExame", "descricaoTipoMaterialColeta", "codigoTipoMaterialColeta", "valorIncertezaTipoMaterialColeta", "codigoSetorExamePadrao", "descricaoSetorExamePadrao", "responsavelSetorExamePadrao", "siglaSetorExamePadrao", "conservacaoExame", "diasConservacaoExame", "temperaturaInicialConservacaoExame", "temperaturaFinalConservacaoExame", "descricaoRecipientesColetaExame", "volumeRecipientesColetaExame", "descricaoRecipientesTriagemExame", "volumeRecipientesTriagemExame"};
        CAMPOS_ASSINATURA_LAUDO = CampoAssinaturaLaudo.values();
        CAMPOS_LANCAMENTO_CAIXA = new String[]{"codigoUltimoPagamentoRequisicao", "debitoCreditoUltimoPagamentoRequisicao", "dataHoraUltimoPagamentoRequisicao", "valorUltimoPagamentoRequisicao", "bancoUltimoPagamentoRequisicao", "agenciaUltimoPagamentoRequisicao", "documentoUltimoPagamentoRequisicao", "observacaoUltimoPagamentoRequisicao", "tipoDocumentoUltimoPagamentoRequisicao", "tipoPagamentoUltimoPagamentoRequisicao", "numeroChequeUltimoPagamentoRequisicao", "validadeCartaoUltimoPagamentoRequisicao", "numeroCartaoUltimoPagamentoRequisicao", "cartaoCreditoUltimoPagamentoRequisicao", "contaUltimoPagamentoRequisicao", "dataConciliacaoUltimoPagamentoRequisicao", "dataVencimentoUltimoPagamentoRequisicao", "codigoUsuarioUltimoPagamentoRequisicao", "codigoEstacaoUltimoPagamentoRequisicao", "codigoContaCorrenteUltimoPagamentoRequisicao", "contaContaCorrenteUltimoPagamentoRequisicao", "titularContaCorrenteUltimoPagamentoRequisicao", "nomePagadorPagamentoRequisicao", "cpfPagadorPagamentoRequisicao", "nomeDoPlano"};
        CAMPOS_INSTRUCOES = new String[]{"codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anomesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "codigoSituacao", "descricaoSituacao", "codigoUsuario", "nomeUsuario", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroDestino", "descricaoBairroDestino", "codigoBairroColeta", "descricaoBairroColeta", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "siteMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "codigoPaciente", "nomePaciente", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorrhPaciente", "fatorduPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "valorChExame", "codigoExame", "descricaoExame", "ambExame", "chExame", "valorExame", "valorMateriaisExame", "situacaoExame", "descricaoSituacaoExame", "descricaoMaterial", "codigoMaterial", "abreviaturaMaterial", "dataColetaExame", "horaColetaExame", "usuarioColetaExame", "descricaoPrazo", "codigoPrazo", "codigoMetodo", "descricaoMetodo", "materialInformadoExame", "dataEntregaExame", "horaEntregaExame", "autorizacaoExame", "codigoUsuarioLogado", "nomeUsuarioLogado"};
        CAMPOS_ATESTADO = new String[]{"numeroEnderecoMedico", "numeroEnderecoConvenio", "numeroEnderecoPaciente", "tipoLogradouroPaciente", "tipoLogradouroConvenio", "tipoLogradouroMedico", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "whatsAppPaciente", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anoMesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "guiaRequisicao", "notaCaixaRequisicao", "codigoSituacao", "descricaoSituacao", "tipoUltimoPagamentoRequisicao", "codigoUsuario", "nomeUsuario", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "siteMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "codigoPaciente", "nomePaciente", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorRHPaciente", "fatorDUPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "senhaWebPaciente", "dataPrimeiraColetaExameRequisicao", "dataUltimaColetaExameRequisicao", "datasColetasExameRequisicao", "nomeSocialPaciente", "procedenciaRequisicao", "responsavelPacienteRequisicao", "cpfResponsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente", "idadeRequisicaoPaciente", "periodoGestacionalRequisicao", "passaportePaciente", "nomeMae"};
        CAMPOS_PROTOCOLO_DESTINO = new String[]{"cartaoSUSPaciente", "cartaoSUSRequisicao", "numeroEnderecoMedico", "numeroEnderecoPaciente", "numeroEnderecoConvenio", "tipoLogradouroPaciente", "tipoLogradouroConvenio", "whatsAppPaciente", "tipoLogradouroMedico", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anoMesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "guiaRequisicao", "notaCaixaRequisicao", "complementoDestinoRequisicao", "existeExamesSemMaterial", "imprimirSeparadoRequisicao", "datasEntregaParcialRequisicao", "codigoSituacao", "descricaoSituacao", "tipoUltimoPagamentoRequisicao", "codigoUsuario", "nomeUsuario", "assinaturaUsuario", "codigoUsuarioAbertura", "nomeUsuarioAbertura", "assinaturaUsuarioAbertura", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroMedico", "descricaoBairroMedico", "codigoBairroDestino", "descricaoBairroDestino", "codigoBairroColeta", "descricaoBairroColeta", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "enviarParaWebDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "siteMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "codigoPaciente", "nomePaciente", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorRHPaciente", "fatorDUPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "senhaWebPaciente", "quartoRequisicao", "leitoRequisicao", "codigoAla", "descricaoAla", "nomeSocialPaciente", "procedenciaRequisicao", "responsavelPacienteRequisicao", "cpfResponsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "perguntasRequisicao", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente", "idadeRequisicaoPaciente", "periodoGestacionalRequisicao"};
        CAMPOS_MEDICAMENTO = new String[]{"codigoMedicamento", "descricaoMedicamento", "dosagemMedicamento", "horaDosagemMedicamento", "dataDosagemMedicamento"};
        CAMPOS_NOTA_FISCAL_SAIDA = new String[]{"codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "numeroNotaFiscal", "tipoCadastroNotaFiscal", "dataHoraNotaFiscal", "dataEmissaoNotaFiscal", "situacaoNotaFiscal", "dataHoraImpressaoNotaFiscal", "observacaoNotaFiscal", "valorTotalNotaFiscal", "subTotalNotaFiscal", "tipoNotaFiscal", "faturasNotaFiscal", "dataHoraCanceladoNotaFiscal", "valorIRRFNotaFiscal", "percentualIRRFNotaFiscal", "valorISSNotaFiscal", "percentualISSNotaFiscal", "valorPISNotaFiscal", "percentualPISNotaFiscal", "valorCSLLNotaFiscal", "percentualCSLLNotaFiscal", "valorCOFINSNotaFiscal", "percentualCOFINSNotaFiscal", "valorINSSNotaFiscal", "percentualINSSNotaFiscal", "codigoSerie", "descricaoSerie", "codigoFormaPagamento", "descricaoFormaPagamento", "codigoUsuarioNotaFiscal", "nomeUsuarioNotaFiscal", "codigoUsuarioImpressaoNotaFiscal", "nomeUsuarioImpressaoNotaFiscal", "codigoUsuarioCanceladoNotaFiscal", "nomeUsuarioCanceladoNotaFiscal", "datasVencimentoNotaFiscal", "datasVencimentoFatura", "codigoCadastro", "fantasiaCadastro", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "cnpjCpfCadastro", "ieRgCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro", "estadoCidadeCadastro", "codigoBairroCadastro", "descricaoBairroCadastro", "codigoServicoNotaFiscal", "descricaoServicoNotaFiscal", "valorServicoNotaFiscal", "quantidadeRequisicoesFaturas", "quantidadeExamesFaturas", "menorDataPeriodoFiltroFaturas", "maiorDataPeriodoFiltroFaturas"};
        CAMPOS_ETIQUETA_ESTOQUE = new String[]{"celularEntidade", "cepCadastro", "cepEntidade", "cepFilial", "cnpjCpfCadastro", "cnpjFilial", "codigoBairroCadastro", "codigoBairroFilial", "codigoCadastro", "codigoCidadeCadastro", "codigoCidadeFilial", "codigoEntidade", "codigoFilial", "codigoFormaPagamento", "codigoMaterial", "codigoNotaFiscal", "codigoPedido", "codigoSerie", "codigoServicoNotaFiscal", "codigoTipoMaterial", "codigoUsuarioCanceladoNotaFiscal", "codigoUsuarioImpressaoNotaFiscal", "codigoUsuarioNotaFiscal", "complementoCadastro", "complementoEnderecoEntidade", "complementoFilial", "contatoEntidade", "contatoFoneEntidade", "cpfCnpjEntidade", "dataAutorizacaoPedido", "dataEmissaoNotaFiscal", "dataHoraCanceladoNotaFiscal", "dataHoraImpressaoNotaFiscal", "dataHoraNotaFiscal", "dataHoraPedido", "datasVencimentoFatura", "datasVencimentoNotaFiscal", "descricaoBairroCadastro", "descricaoBairroFilial", "descricaoCidadeFilial", "descricaoFilial", "descricaoFormaPagamento", "descricaoSerie", "descricaoServicoNotaFiscal", "emailEntidade", "enderecoCadastro", "enderecoEntidade", "enderecoFilial", "estadoCidadeCadastro", "estadoCidadeFilial", "fantasiaCadastro", "fantasiaEntidade", "faturasNotaFiscal", "faxCadastro", "faxFilial", "fazEntidade", "foneCadastro", "foneFilial", "ieRgCadastro", "maiorDataPeriodoFiltroFaturas", "descricaoMaterial", "marcaMaterial", "materialModelo", "observacaoMaterial", "ultimaCompraMaterial", "ultimaEntregaMaterial", "valorUltimaCompra", "menorDataPeriodoFiltroFaturas", "nomeCidadeCadastro", "nomeUsuarioCanceladoNotaFiscal", "nomeUsuarioImpressaoNotaFiscal", "nomeUsuarioNotaFiscal", "numeroEnderecoEntidade", "numeroNotaFiscal", "observacaoNotaFiscal", "observacaoPedido", "percentualCOFINSNotaFiscal", "percentualCSLLNotaFiscal", "percentualINSSNotaFiscal", "percentualIRRFNotaFiscal", "percentualISSNotaFiscal", "percentualPISNotaFiscal", "quantidadeExamesFaturas", "quantidadeRequisicoesFaturas", "razaoSocialCadastro", "razaoSocialEntidade", "razaoSocialFilial", "situacaoNotaFiscal", "subTotalNotaFiscal", "telefoneEntidade", "telefoneEntidade", "tipoCadastroNotaFiscal", "tipoMaterialDescricao", "tipoNotaFiscal", "totalMaterialPedido", "totalPedido", "unidadeMaterial", "valorCOFINSNotaFiscal", "valorCSLLNotaFiscal", "valorDescontoMaterialPedido", "valorFretePedido", "valorINSSNotaFiscal", "valorIRRFNotaFiscal", "valorISSNotaFiscal", "valorPISNotaFiscal", "valorServicoNotaFiscal", "valorTotalNotaFiscal", "valorUnitarioMaterialPedido", "vendedorPedido", "loteMaterial", "validadeLoteMaterial", "usuarioLogado", "dataHoraCorrente", "nomeUsuarioLogado", "codigoFilialImpressao", "descricaoFilialImpressao"};
        CAMPOS_NOTA_FISCAL_PESSOA_FISICA = new String[]{"codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "numeroNotaFiscal", "tipoCadastroNotaFiscal", "dataHoraNotaFiscal", "dataEmissaoNotaFiscal", "situacaoNotaFiscal", "dataHoraImpressaoNotaFiscal", "observacaoNotaFiscal", "valorTotalNotaFiscal", "subTotalNotaFiscal", "tipoNotaFiscal", "faturasNotaFiscal", "dataHoraCanceladoNotaFiscal", "valorIRRFNotaFiscal", "percentualIRRFNotaFiscal", "valorISSNotaFiscal", "percentualISSNotaFiscal", "valorPISNotaFiscal", "percentualPISNotaFiscal", "valorCSLLNotaFiscal", "percentualCSLLNotaFiscal", "valorCOFINSNotaFiscal", "percentualCOFINSNotaFiscal", "valorINSSNotaFiscal", "percentualINSSNotaFiscal", "codigoSerie", "descricaoSerie", "codigoFormaPagamento", "descricaoFormaPagamento", "codigoUsuarioNotaFiscal", "nomeUsuarioNotaFiscal", "codigoUsuarioImpressaoNotaFiscal", "nomeUsuarioImpressaoNotaFiscal", "codigoUsuarioCanceladoNotaFiscal", "nomeUsuarioCanceladoNotaFiscal", "datasVencimentoNotaFiscal", "datasVencimentoFatura", "codigoCadastro", "fantasiaCadastro", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "cnpjCpfCadastro", "ieRgCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro", "estadoCidadeCadastro", "codigoBairroCadastro", "descricaoBairroCadastro", "codigoServicoNotaFiscal", "descricaoServicoNotaFiscal", "valorServicoNotaFiscal", "quantidadeRequisicoesFaturas", "quantidadeExamesFaturas", "menorDataPeriodoFiltroFaturas", "maiorDataPeriodoFiltroFaturas", "nomePagador", "cpfPagador"};
        CAMPOS_ETIQUETA_MATERIAL_ENVIADO = new String[]{"codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "codigoPaciente", "nomePaciente", "razaoSocialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "fonePaciente", "emailPaciente", "codigoCelulaEstoqueOrigem", "descricaoCelulaEstoqueOrigem", "codigoCelulaEstoqueDestino", "descricaoCelulaEstoqueDestino", "codigoCidadeConvenio", "nomeCidadeConvenio", "ufCidadeConvenio", "codigoCidadePaciente", "nomeCidadePaciente", "ufCidadePaciente", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoMaterial", "descricaoMaterial", "marcaMaterial", "modeloMaterial", "codigoUnidadeMedida", "descricaoUnidadeMedida", "codigoTipoMaterial", "descricaoTipoMaterial", "codigoUsuarioResponsavelMaterial", "nomeUsuarioResponsavelMaterial", "codigoIdentificacaoMaterialEnviado", "dataEnvioMaterialEnviado", "codigoUsuarioMaterialEnviado", "nomeUsuarioEnvioMaterialEnviado", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial"};
        CAMPOS_RECIBO_MATERIAL_ENVIADO = new String[]{"numeroEnderecoConvenio", "numeroEnderecoPaciente", "tipoLogradouroPaciente", "tipoLogradouroConvenio", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "codigoPaciente", "nomePaciente", "razaoSocialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "fonePaciente", "emailPaciente", "codigoCidadeConvenio", "nomeCidadeConvenio", "ufCidadeConvenio", "codigoCidadePaciente", "nomeCidadePaciente", "ufCidadePaciente", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoMaterial", "descricaoMaterial", "marcaMaterial", "modeloMaterial", "codigoUnidadeMedida", "descricaoUnidadeMedida", "codigoTipoMaterial", "descricaoTipoMaterial", "codigoUsuarioResponsavelMaterial", "nomeUsuarioResponsavelMaterial", "dataEnvioMaterialEnviado", "codigoUsuarioMaterialEnviado", "nomeUsuarioEnvioMaterialEnviado", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "codigoCelulaEstoqueOrigem", "descricaoCelulaEstoqueOrigem", "codigoCelulaEstoqueDestino", "descricaoCelulaEstoqueDestino", "quantidadeMaterialEnviado", "numeroNotaFiscal"};
        CAMPOS_IDENTIFICACAO_ESTANTE = new String[]{"codigoGeladeira", "descricaoGeladeira", "codigoSetorGeladeira", "codigoUsuarioCriacaoGeladeira", "inativaGeladeira", "codigoPrateleira", "codigoEstante", "linhasEstante", "colunasEstante", "identificadorEstante", "pacoteEstante", "reutilizarEstante", "dataDescarteEstante", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "identificacaoEstante"};
        CAMPOS_IDENTIFICACAO_TUBO = new String[]{"codigoTubo", "codigosExames", "codigoMaterial", "nomePaciente", "descricaoMaterial", "abreviaturaMaterial", "codigoRequisicao", "codigoRecipientePai", "descricaoRecipientePai", "unidadeRecipientePai", "codigoRecipienteFilho", "descricaoRecipienteFilho", "unidadeRecipienteFilho", "codigoFilial", "descricaoFilial", "codigoSetor", "descricaoSetor", "siglaSetor", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "dataHoraAtual", "cpfPaciente", "dataHoraAdicaoSoroteca", "codigoGeladeira", "descricaoGeladeira", "codigoSetorGeladeira", "codigoPrateleira", "codigoEstante", "linhasEstante", "colunasEstante", "identificadorEstante", "dataVencimentoSoroteca"};
        CAMPOS_ETIQUETA_LAMINA = new String[]{"codigoRequisicao", "codigoExame", "codigoMaterial", "identificacaoLaminaExame", "quantidadeLaminas", "descricaoMaterial", "abreviaturaMaterial", "descricaoExame", "descricaoSetor", "siglaSetor", "codigoIdentificador", "descricaoIdentificador", "siglaIdentificador", "nomePaciente", "razaoSocialPaciente", "cpfPaciente", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio"};
        CAMPOS_PROPOSTA = new String[]{"cnpjCpfConvenio", "codigoConvenio", "descricaoConvenio", "contatoConvenio", "foneConvenio", "emailConvenio", "terceirizado", "cidadeConvenio", "ufConvenio", "dataOrcamento", "codigoOrcamento", "codigoGrupoPrincipal", "descricaoGrupoPrincipal", "codigoGrupoExame", "descricaoGrupoExame", "codigoExame", "descricaoExame", "codigoMetodologiaExame", "descricaoMetodologiaExame", "valorExame", "limiteQuantificacaoExame", "valorBrutoGrupo", "valorLiquidoGrupo", "somatorioValorLiquidoGrupos", "prazoEntregaGrupoPrincipal", "somatorioValorBrutoGrupos", "fantasiaConvenio", "percentualDesconto", "valorDesconto", "valorAcrescimo", "percentualAcrescimo", "codigoFilial", "razaoSocialFilial", "descricaoFilial", "foneFilial", "nomeCidade", "estadoCidade", "cnpjFilial", "enderecoFilial", "certificadoInmetroExame", "complementoFilial", "nomeBairro", "faxFilial", "cepFilial", "codigoUsuario", "nomeUsuario", "assinaturaUsuario", "codigoUsuarioLogado", "nomeUsuarioLogado", "assinaturaUsuarioLogado", "dataHoraOrcamento", "codigoPaciente", "nomePaciente", "solicitanteOrcamento", "proprietarioOrcamento", "animalOrcamento", "foneOrcamento", "contatoOrcamento", "foneContatoOrcamento", "emailOrcamento", "validadeOrcamento", "observacaoOrcamento", "materialColetadoExame", "abreviaturaMaterialColetadoExame", "valorUnitarioExame", "quantidadeExameOrcamento", "codigoFormaPagamento", "descricaoFormaPagamento", "valorTotalExame", "considerarComoExameFilho", "valorGrupoPrincipal", "valorTotalOrcamento", "quantidadeAlteracoesOrcamento", "limiteDeDeteccaoExame", "senhaWebConvenio", "descricaoPrazoEntregaExame", "cpfPaciente", "cnpjEmpresa", "possuiExameCertificadoInmetro"};
        CAMPOS_IDENTIFICACAO_COLETA = new String[]{"codigoFilial", "razaoSocialFilial", "descricaoFilial", "foneFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "ufCidadeFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "codigoBairroFilial", "nomeBairroFilial", "faxFilial", "cepFilial", "codigoOrcamento", "dataHoraOrcamento", "percentualDesconto", "valorDesconto", "valorAcrescimo", "percentualAcrescimo", "codigoUsuarioOrcamento", "nomeUsuarioOrcamento", "assinaturaUsuarioOrcamento", "codigoUsuarioLogado", "nomeUsuarioLogado", "assinaturaUsuarioLogado", "solicitanteOrcamento", "foneOrcamento", "emailOrcamento", "contatoOrcamento", "foneContatoOrcamento", "validadeOrcamento", "observacaoOrcamento", "codigoFormaPagamentoOrcamento", "descricaoFormaPagamentoOrcamento", "codigoGrupoPrincipal", "descricaoGrupoPrincipal", "codigoGrupoExame", "descricaoGrupoExame", "valorBrutoGrupo", "valorLiquidoGrupo", "somatorioValorLiquidoGrupos", "prazoEntregaGrupoPrincipal", "somatorioValorBrutoGrupos", "codigosExames", "descricoesExames", "codigoMaterialExames", "abreviaturaMaterialColetadoExames", "descricaoMaterialExames", "abreviaturaMaterialExame", "codigoCliente", "fantasiaCliente", "razaoSocialCliente", "cnpjCliente", "ieCliente", "sifCliente", "emailCliente", "foneCliente", "faxCliente", "observacaoCliente", "tipoLogradouroCliente", "tipoLogradouroCobrancaCliente", "enderecoCliente", "enderecoCobrancaClente", "numeroEnderecoCliente", "numeroEnderecoCobrancaCliente", "complementoEnderecoCliente", "complementoEnderecoCobrancaCliente", "pontoReferenciaEnderecoCliente", "codigoBairroCliente", "codigoBairroCobrancaCliente", "descricaoBairroCliente", "descricaoBairroCobrancaCliente", "cepCliente", "cepCobrancaCliente", "codigoCidadeCliente", "codigoCidadeCobrancaCliente", "ufCidadeCliente", "ufCidadeCobrancaCliente", "foneCobrancaCliente", "descricaoCidadeCliente", "descricaoCidadeCobrancaCliente", "codigoConvenio", "tipoPessoaConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjCpfConvenio", "ieConvenio", "inscricaoMunicipalConvenio", "codigoCidadeConvenio", "descricaoCidadeConvenio", "ufCidadeConvenio", "tipoLogradouroConvenio", "enderecoConvenio", "numeroEnderecoConvenio", "complementoEnderecoConvenio", "codigoBairroConvenio", "descricaoBairroConvenio", "cepConvenio", "foneConvenio", "faxConvenio", "contatoConvenio", "email1Convenio", "siteConvenio", "observacaoConvenio", "codigoCidadeCobrancaConvenio", "descricaoCidadeCobrancaConvenio", "ufCidadeCobrancaConvenio", "tipoLogradouroEnderecoCobrancaConvenio", "enderecoCobrancaConvenio", "numeroEnderecoCobrancaConvenio", "complementoEnderecoCobrancaConvenio", "codigoBairroEnderecoCobrancaConvenio", "descricaoBairroEnderecoCobrancaConvenio", "cepCobrancaConvenio", "agrupamentoMaterialExame"};
        CAMPOS_ETIQUETA_HP_DIRECT = new String[]{"codigoFilial", "codigoRequisicao", "nomePaciente", "codigoPaciente", "pedidoHPardini", "codigoConveniadoHPardini", "pedidoConveniado", "materialBiologico", "conservante", "codigoExameHPardini", "codigoEtiquetaHPardini", "codigoExame", "descricaoExame", "codigoMaterial", "descricaoMaterial", "codigoConvenio", "fantasiaConvenio", "codigoRecipiente", "descricaoRecipiente"};
        CAMPOS_ETIQUETA_SM = ArraysUtil.concatenar(CAMPOS_ETQ_COLETA, new String[]{"codigoApoioSaoMarcos"});
        CAMPOS_ETQ_LAUDO = new String[]{"cartaoSUSPaciente", "cartaoSUSRequisicao", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "guiaRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anoMesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "examesIncompletosRequisicao", "complementoDestinoRequisicao", "codigoSituacao", "descricaoSituacao", "maiorQuantidadeRetificacoesLaudo", "codigoUsuario", "nomeUsuario", "assinaturaUsuario", "dataPrimeiraColetaRequisicao", "dataUltimaColetaRequisicao", "datasColetaRequisicao", "dataPrimeiraImpressaoRequisicao", "dataHoraUltimaImpressaoExame", "dataPrimeiraDigitacaoRequisicao", "dataPrimeiraConferenciaRequisicao", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroMedico", "descricaoBairroMedico", "codigoBairroDestino", "descricaoBairroDestino", "codigoBairroColeta", "descricaoBairroColeta", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoUnidadeSaude", "descricaoUnidadeSaude", "enderecoUnidadeSaude", "complementoUnidadeSaude", "cepUnidadeSaude", "foneUnidadeSaude", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "siteMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "codigoPaciente", "nomePaciente", "nomeSocialPaciente", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorRHPaciente", "fatorDUPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "idadePaciente", "anoMesPaciente", "maePaciente", "paiPaciente", "fumantePaciente", "diabeticoPaciente", "numeroEnderecoPaciente", "tipoEnderecoPaciente", "quartoRequisicao", "leitoRequisicao", "codigoAla", "descricaoAla", "prontuarioRequisicao", "razaoAssinatura", "procedenciaRequisicao", "dataHoraCorrente", "codigoFilialImpressao", "descricaoFilialImpressao", "usuarioLogado", "nomeUsuarioLogado", "periodoGestacionalRequisicao", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "dataColetaProdutoRequisicao", "horaColetaProdutoRequisicao", "dataRecebimentoProdutoRequisicao", "horaRecebimentoProdutoRequisicao", "localColetaProdutoRequisicao", "numeroSolicitacaoProdutoRequisicao", "fornecedorProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "caracteristicasSanitariasProdutoRequisicao", "condicoesAmbientaisProdutoRequisicao", "procedimentoColetaProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "partidaProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "descricaoUnidadeProdutoRequisicao", "anoPRPProdutoRequisicao", "cicloPRPProdutoRequisicao", "amostraPRPProdutoRequisicao", "amostraSupervisaoPRPProdutoRequisicao", "horaInicioTurnoPRPProdutoRequisicao", "turnoPRPProdutoRequisicao", "linhaPRPProdutoRequisicao", "volumeAbatePRPProdutoRequisicao", "areaProdutoRequisicao", "codigoEmbalagemProdutoRequisicao", "descricaoEmbalagemProdutoRequisicao", "nomeResponsavelRequisicao", "foneResponsavelRequisicao", "cargoResponsavelRequisicao", "emailResponsavelRequisicao", "nomeResponsavelRequisicao_", "foneResponsavelRequisicao_", "cargoResponsavelRequisicao_", "emailResponsavelRequisicao_", "codigoProdutoAlimento", "descricaoProdutoAlimento", "codigoCategoriaProdutoAlimento", "descricaoCategoriaProdutoAlimento", "codigoBairroCobrancaPaciente", "descricaoBairroCobrancaPaciente", "codigoCidadeCobrancaPaciente", "descricaoCidadeCobrancaPaciente", "estadoCidadeCobrancaPaciente", "razaoSocialPaciente", "cnpjPaciente", "inscricaoEstadualPaciente", "proprietarioPaciente", "sifPaciente", "enderecoCobrancaPaciente", "complementoCobrancaPaciente", "cepCobrancaPaciente", "foneCobrancaPaciente", "responsavelCobrancaPaciente", "codigoPaisProdutoRequisicao", "descricaoPaisProdutoRequisicao", "dataCertificadoProdutoRequisicao", "numeroCertificadoProdutoRequisicao", "termoColetaAmostraProdutoRequisicao", "dataUltimoExameDigitadoRequisicao", "dataUltimoExameConferidoRequisicao", "possuiExameCertificadoInmetro", "quantidadeAlteracoesRequisicao", "quantidadeAlteracoesComConferenciaRequisicao", "codigoUltimoMotivoAlteracao", "descricaoUltimoMotivoAlteracao", "dataUltimoMotivoAlteracao", "motivoUltimoMotivoAlteracao", "codigoUltimoMotivoAlteracaoComConferenciaRequisicao", "descricaoUltimoMotivoAlteracaoComConferenciaRequisicao", "dataUltimoMotivoAlteracaoComConferenciaRequisicao", "motivoUltimoMotivoAlteracaoComConferenciaRequisicao", "pelagemPaciente", "codigoEspecie", "descricaoEspecie", "cientificoEspecie", "codigoRaca", "descricaoRaca", "cientificoRaca", "codigoUsuarioDigitacao", "nomeUsuarioDigitacao", "assinaturaUsuarioDigitacao", "dataConferenciaExame", "codigoUsuarioConferencia", "nomeUsuarioConferencia", "assinaturaUsuarioConferencia", "codigoUsuarioLogado", "nomeUsuarioLogado", "assinaturaUsuarioLogado", "dataColetaExame", "horaColetaExame", "hashResultado", "resultadoRetificadoExame", "codigoEmpresaPaciente", "fantasiaEmpresaPaciente", "razaoSocialEmpresaPaciente", "foneEmpresaPaciente", "motivoUltimaRetificacao", "dataHoraUltimaRetificacao", "usuarioUltimaRetificacao", "perguntasRequisicao", "responsavelPacienteRequisicao", "cpfResponsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente"};
        CAMPOS_NOTIFICACAO = new String[]{"codigoPaciente", "nomePaciente", "nomeSocialPaciente", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorRHPaciente", "fatorDUPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "senhaWebPaciente", "quartoRequisicao", "nomePagadorPaciente", "cpfPagadorPaciente", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anoMesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "guiaRequisicao", "notaCaixaRequisicao", "complementoDestinoRequisicao", "tipoUltimoPagamentoRequisicao", "prontuarioRequisicao", "perguntasRequisicao", "quartoRequisicao", "periodoGestacionalRequisicao", "leitoRequisicao", "codigoAlaRequisicao", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "dataColetaProdutoRequisicao", "horaColetaProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "caracteristicasSanitariasProdutoRequisicao", "condicoesAmbientaisProdutoRequisicao", "procedimentoColetaProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "partidaProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "descricaoUnidadeProdutoRequisicao", "areaProdutoRequisicao", "codigoEmbalagemProdutoRequisicao", "descricaoEmbalagemProdutoRequisicao", "nomeResponsavelRequisicao", "foneResponsavelRequisicao", "anoPRPProdutoRequisicao", "cicloPRPProdutoRequisicao", "amostraPRPProdutoRequisicao", "amostraSupervisaoPRPProdutoRequisicao", "horaInicioTurnoPRPProdutoRequisicao", "turnoPRPProdutoRequisicao", "linhaPRPProdutoRequisicao", "volumeAbatePRPProdutoRequisicao", "cargoResponsavelRequisicao", "emailResponsavelRequisicao", "razaoSocialResponsavelRequisicao", "enderecoResponsavelRequisicao", "complementoResponsavelRequisicao", "cepResponsavelRequisicao", "cpfCnpjResponsavelRequisicao", "descricaoCidadeResponsavelRequisicao", "estadoCidadeResponsavelRequisicao", "descricaoBairroResponsavelRequisicao", "dataRecebimentoProdutoRequisicao", "horaRecebimentoProdutoRequisicao", "localColetaProdutoRequisicao", "numeroSolicitacaoProdutoRequisicao", "fornecedorProdutoRequisicao", "codigoProdutoAlimento", "descricaoProdutoAlimento", "codigoCategoriaProdutoAlimento", "descricaoCategoriaProdutoAlimento", "procedenciaRequisicao", "suplementoRequisicao", "codigoFilial", "razaoSocialFilial", "descricaoFilial", "foneFilial", "nomeCidadeFilial", "estadoCidadeFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "nomeBairro", "faxFilial", "cepFilial", "codigoExame", "descricaoExame", "materialColetadoExame", "abreviaturaMaterialColetadoExame", "ambExame", "dataImpressao", "passaportePaciente", "maePaciente", "numeroEnderecoPaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "descricaoBairroPaciente", "dataColetaExameRequisicao", "dataAssinaturaExameRequisicao", "dataDigitacaoExameRequisicao", "CNESFilial"};
        CAMPOS_TERMO_CONSENTIMENTO_TIPO_EXAME = new String[]{"numeroEnderecoMedico", "numeroEnderecoConvenio", "numeroEnderecoPaciente", "tipoLogradouroPaciente", "tipoLogradouroConvenio", "tipoLogradouroMedico", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "whatsAppPaciente", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anoMesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "guiaRequisicao", "notaCaixaRequisicao", "codigoSituacao", "descricaoSituacao", "tipoUltimoPagamentoRequisicao", "codigoUsuario", "nomeUsuario", "passaportePaciente", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "siteMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "codigoPaciente", "nomePaciente", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorRHPaciente", "fatorDUPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "senhaWebPaciente", "dataPrimeiraColetaExameRequisicao", "dataUltimaColetaExameRequisicao", "datasColetasExameRequisicao", "nomeSocialPaciente", "procedenciaRequisicao", "responsavelPacienteRequisicao", "cpfResponsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente", "idadeRequisicaoPaciente", "periodoGestacionalRequisicao"};
    }
}

