/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.importador.imagem;

import jalis.comum.ParametrosLocais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.importador.imagem.AbstractImportadorImagem;
import jalis.laboratorio.util.importador.imagem.ConfigurarDiretorio;
import jalis.laboratorio.util.importador.imagem.DialogoSelecionarImagem;
import jalis.laboratorio.util.importador.imagem.ProtocoloImportarImagem;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import javax.swing.ImageIcon;

public class ImagensDiretorio
extends AbstractImportadorImagem {
    private String enderecoDiretorio = "";
    private ImageIcon[] imagens = new ImageIcon[0];

    @Override
    public ImageIcon selecionarImagem(String codigoImagem) {
        DialogoSelecionarImagem d = DialogoSelecionarImagem.novaInstancia(Laboratorio.getInstancia(), this.buscaDiretorioInicial());
        d.setVisible(true);
        if (d.getOK()) {
            this.imagens = d.getImagensSelecionadas();
            return d.getImagemSelecionada();
        }
        return null;
    }

    @Override
    public boolean configurar() {
        ConfigurarDiretorio conf = ConfigurarDiretorio.novaInstancia(Laboratorio.getInstancia());
        if (conf != null) {
            conf.setDiretorio(this.enderecoDiretorio);
            conf.setVisible(true);
            if (conf.getOK()) {
                this.enderecoDiretorio = conf.getDiretorio();
                return true;
            }
        }
        return false;
    }

    private String buscaDiretorioInicial() {
        String dir = ParametrosLocais.getParametro("importadorImagemDigitacao");
        String d = "";
        if (!Funcoes.textoVazio(dir) && !Funcoes.textoVazio(d = StringUtil.getValor(dir, "enderecoDiretorio"))) {
            return d;
        }
        return ".";
    }

    @Override
    public void setXML(String xml) {
        if (xml != null && !Funcoes.textoVazio(StringUtil.getValor(xml, "enderecoDiretorio"))) {
            this.enderecoDiretorio = StringUtil.getValor(xml, "enderecoDiretorio");
        }
    }

    @Override
    public String getXML() {
        return "<enderecoDiretorio>" + this.enderecoDiretorio + "</enderecoDiretorio>";
    }

    @Override
    public ProtocoloImportarImagem getProtocolo() {
        return ProtocoloImportarImagem.DIRETORIO;
    }

    @Override
    public ImageIcon[] imagensSelecionadas() {
        return this.imagens;
    }
}

