/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.importador.imagem;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.importador.imagem.AbstractImportadorImagem;
import jalis.laboratorio.util.importador.imagem.DCM4CHE2025;
import jalis.laboratorio.util.importador.imagem.ImagensDiretorio;
import jalis.laboratorio.util.importador.imagem.ProtocoloImportarImagem;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.util.ArrayList;

public class FabricaImportarImagem {
    public static AbstractImportadorImagem novoImportador(ProtocoloImportarImagem protocolo) {
        if (protocolo == ProtocoloImportarImagem.DCM4CHE_2_0_25) {
            return new DCM4CHE2025();
        }
        if (protocolo == ProtocoloImportarImagem.DIRETORIO) {
            return new ImagensDiretorio();
        }
        return null;
    }

    public static String[] getNomeProtocolos() {
        ArrayList<String> nomes = new ArrayList<String>();
        for (ProtocoloImportarImagem p : ProtocoloImportarImagem.getProtocolos()) {
            nomes.add(p.getNome());
        }
        return nomes.toArray(new String[nomes.size()]);
    }

    public static String getXMLConfiguracao(ProtocoloImportarImagem protocolo, AbstractImportadorImagem importador) {
        String retorno = "";
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("importadorImagem");
        xml.escrever("protocolo", protocolo.getNome());
        if (importador != null) {
            xml.escrever("configuracao", importador.getXML());
        }
        try {
            xml.fechar("importadorImagem");
            retorno = xml.getXML();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "FabricaimportarImagem: 54");
        }
        return retorno;
    }

    public static AbstractImportadorImagem getImportadorDeConfiguracao(String xml) {
        String nomeProtocolo;
        AbstractImportadorImagem importador;
        if (xml != null && StringUtil.getValor(xml, "importadorImagem").trim().length() > 0 && (importador = FabricaImportarImagem.novoImportador(ProtocoloImportarImagem.getProtocolo(nomeProtocolo = StringUtil.getValor(xml, "protocolo")))) != null) {
            importador.setXML(StringUtil.getValor(xml, "configuracao"));
            return importador;
        }
        return null;
    }
}

