/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.importador.imagem;

import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class DialogoZoom
extends JDialog
implements ActionListener {
    private ImageIcon imagem = null;
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JPanel panelImagem = new JPanel(){

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (DialogoZoom.this.imagem != null) {
                Graphics2D g2 = (Graphics2D)g;
                g2.drawImage(DialogoZoom.this.imagem.getImage(), 0, 0, DialogoZoom.this.imagem.getIconWidth(), DialogoZoom.this.imagem.getIconHeight(), null);
            }
        }
    };
    private JScrollPane scroll = new JScrollPane(this.panelImagem);

    public DialogoZoom(JDialog owner) {
        super((Dialog)owner, "Visualizando imagem");
        this.setSize(new Dimension(700, 500));
        this.setLocationRelativeTo(owner);
        this.setLayout(new BorderLayout());
        this.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonFechar), "South");
        this.add((Component)this.scroll, "Center");
        this.scroll.setAutoscrolls(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void setImagem(ImageIcon imagem) {
        this.imagem = imagem;
        this.panelImagem.setSize(imagem.getIconWidth(), imagem.getIconHeight());
        this.panelImagem.setPreferredSize(new Dimension(imagem.getIconWidth(), imagem.getIconHeight()));
        this.scroll.getHorizontalScrollBar().setMaximum(imagem.getIconWidth());
        this.scroll.getVerticalScrollBar().setMaximum(imagem.getIconHeight());
    }
}

