/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.importador.imagem;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.importador.imagem.PanelImagem;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class DialogoSelecionarImagem
extends AbstractDialogoOKCancelar {
    private TTextField textDiretorio = new TTextField();
    private JButton buttonDiretorio = ComponenteFactory.novoJButton(this, true);
    private ArrayList<PanelImagem> imagens = new ArrayList();
    private JPanel panelCentral = this.getPanelCentral();
    private JPanel panelImagens = new JPanel();
    private SplashMensagem splash = new SplashMensagem();

    public static DialogoSelecionarImagem novaInstancia(Object owner, String diretorioInicial) {
        if (owner instanceof JDialog) {
            return new DialogoSelecionarImagem((JDialog)owner, "Selecionar imagem", diretorioInicial);
        }
        if (owner instanceof JFrame) {
            return new DialogoSelecionarImagem((JFrame)owner, "Selecionar imagem", diretorioInicial);
        }
        return null;
    }

    public DialogoSelecionarImagem(JDialog owner, String titulo, String diretorioInicial) {
        super((Dialog)owner, titulo);
        this.iniciar(owner, diretorioInicial);
    }

    public DialogoSelecionarImagem(JFrame owner, String titulo, String diretorioInicial) {
        super((Frame)owner, titulo);
        this.iniciar(owner, diretorioInicial);
    }

    private void iniciar(Component owner, String diretorioInicial) {
        this.setSize(new Dimension(465, 500));
        this.setLocationRelativeTo(owner);
        this.getBotaoOK().setText("Selecionar");
        this.textDiretorio.setEditable(false);
        this.textDiretorio.setText(diretorioInicial);
        this.textDiretorio.setPreferredSize(new Dimension(100, 20));
        this.textDiretorio.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    if (DialogoSelecionarImagem.this.pesquisarDiretorio()) {
                        DialogoSelecionarImagem.this.carregarImagensDiretorio(DialogoSelecionarImagem.this.textDiretorio.getText());
                    }
                } else {
                    super.keyPressed(e);
                }
            }
        });
        this.panelCentral.setLayout(new BorderLayout());
        JPanel panelDiretorio = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        panelDiretorio.add((Component)this.textDiretorio, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        panelDiretorio.add((Component)this.buttonDiretorio, c);
        this.panelCentral.add((Component)panelDiretorio, "North");
        this.panelCentral.add((Component)new JScrollPane(this.panelImagens), "Center");
        this.textDiretorio.setText(diretorioInicial);
        this.carregarImagensDiretorio(this.textDiretorio.getText());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonDiretorio) {
            if (this.pesquisarDiretorio()) {
                this.carregarImagensDiretorio(this.textDiretorio.getText());
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean pesquisarDiretorio() {
        boolean retorno = false;
        JFileChooser file = new JFileChooser(this.textDiretorio.getText());
        if (null != file) {
            file.setDialogTitle("Selecionar diret\u00f3rio de imagens");
            file.setFileSelectionMode(1);
            if (file.showOpenDialog(this) == 0) {
                retorno = true;
                this.textDiretorio.setText(file.getSelectedFile().getPath());
            }
        }
        return retorno;
    }

    public void adicionaImagem(String path) {
        this.adicionaImagem(new ImageIcon(path));
    }

    public void adicionaImagem(ImageIcon image) {
        if (image != null) {
            this.imagens.add(new PanelImagem(image));
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.posicionaImagens();
        }
        super.setVisible(b);
    }

    public ImageIcon getImagemSelecionada() {
        for (PanelImagem img : this.imagens) {
            if (!img.isSelecionado()) continue;
            return img.getImagem();
        }
        return null;
    }

    public ImageIcon[] getImagensSelecionadas() {
        ArrayList<ImageIcon> imgs = new ArrayList<ImageIcon>();
        for (PanelImagem img : this.imagens) {
            if (!img.isSelecionado()) continue;
            imgs.add(img.getImagem());
        }
        return imgs.toArray(new ImageIcon[imgs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void carregarImagensDiretorio(String diretorio) {
        this.splash.mostrar("Carregando imagens...");
        this.limparImagens();
        try {
            File f = new File(diretorio);
            if (f.exists() && f.getAbsoluteFile().exists() && f.isDirectory()) {
                ArrayList<File> arquivos = new ArrayList<File>();
                arquivos.addAll(Arrays.asList(f.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        int pos = pathname.getPath().lastIndexOf(".");
                        String extensao = "";
                        if (pos > 0) {
                            extensao = pathname.getPath().substring(pathname.getPath().lastIndexOf(".") + 1);
                        }
                        return pathname.isFile() && pos > 0 && (extensao.equalsIgnoreCase("jpeg") || extensao.equalsIgnoreCase("jpg") || extensao.equalsIgnoreCase("gif") || extensao.equalsIgnoreCase("png") || extensao.equalsIgnoreCase("bmp"));
                    }
                })));
                if (arquivos != null) {
                    Collections.sort(arquivos, new Comparator<File>(){

                        @Override
                        public int compare(File o1, File o2) {
                            return null == o1 || null == o2 ? 0 : o1.getName().compareTo(o2.getName());
                        }
                    });
                    for (File fs : arquivos) {
                        this.adicionaImagem(new ImageIcon(fs.getAbsolutePath()));
                    }
                }
                this.posicionaImagens();
            }
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e1.getMessage(), e1.getStackTrace(), "DialogoSelecionarImagem: 156");
        }
        finally {
            this.splash.apagar();
        }
    }

    private void limparImagens() {
        this.imagens.clear();
    }

    private void posicionaImagens() {
        final GridBagConstraints c = new GridBagConstraints();
        this.panelImagens.setLayout(new GridBagLayout());
        this.panelImagens.removeAll();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                c.gridwidth = 1;
                c.gridheight = 1;
                c.fill = 0;
                c.anchor = 18;
                c.gridx = -1;
                c.gridy = 0;
                c.insets = new Insets(2, 2, 2, 2);
                int imagensPorLinha = DialogoSelecionarImagem.this.getWidth() / 215;
                for (PanelImagem img : DialogoSelecionarImagem.this.imagens) {
                    ++c.gridx;
                    if (c.gridx > 1) {
                        c.gridx = 0;
                        ++c.gridy;
                    }
                    DialogoSelecionarImagem.this.panelImagens.add((Component)img, c);
                }
                c.gridx = 0;
                ++c.gridy;
                c.gridwidth = 2;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                DialogoSelecionarImagem.this.panelImagens.add((Component)new JPanel(), c);
                DialogoSelecionarImagem.this.panelCentral.revalidate();
                DialogoSelecionarImagem.this.panelCentral.repaint();
            }
        });
    }
}

