/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.importador.imagem;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.importador.imagem.AbstractImportadorImagem;
import jalis.laboratorio.util.importador.imagem.ConfigurarDCM4CHE2025;
import jalis.laboratorio.util.importador.imagem.DialogoSelecionarImagem;
import jalis.laboratorio.util.importador.imagem.ProtocoloImportarImagem;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class DCM4CHE2025
extends AbstractImportadorImagem {
    private String enderecoServidor = "";

    @Override
    public ImageIcon selecionarImagem(String codigoImagem) {
        ArrayList<String> imagens = new ArrayList<String>();
        try {
            String[] imgs;
            String s;
            URL url = new URL(this.enderecoServidor + "?accno=" + codigoImagem);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setDoInput(true);
            con.setDoOutput(false);
            con.connect();
            BufferedReader buf = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder retorno = new StringBuilder();
            while ((s = buf.readLine()) != null) {
                retorno.append(s);
            }
            for (String str : imgs = StringUtil.getValores(retorno.toString(), "imagem")) {
                imagens.add(str);
            }
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e1.getMessage(), e1.getStackTrace(), "DCM4CHE2025: 61");
        }
        if (imagens == null || imagens.size() == 0) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhuma imagem localizada", 5);
            return null;
        }
        DialogoSelecionarImagem d = DialogoSelecionarImagem.novaInstancia(Laboratorio.getInstancia(), "");
        try {
            for (String s : imagens) {
                d.adicionaImagem(new ImageIcon(new URL(s)));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        d.setVisible(true);
        if (d.getOK()) {
            return d.getImagemSelecionada();
        }
        return null;
    }

    @Override
    public boolean configurar() {
        ConfigurarDCM4CHE2025 conf = ConfigurarDCM4CHE2025.novaInstancia(Laboratorio.getInstancia());
        if (conf != null) {
            conf.setServidor(this.enderecoServidor);
            conf.setVisible(true);
            if (conf.getOK()) {
                this.enderecoServidor = conf.getServidor();
                return true;
            }
        }
        return false;
    }

    @Override
    public void setXML(String xml) {
        if (xml != null && !Funcoes.textoVazio(StringUtil.getValor(xml, "enderecoServidor"))) {
            this.enderecoServidor = StringUtil.getValor(xml, "enderecoServidor");
        }
    }

    @Override
    public String getXML() {
        return "<enderecoServidor>" + this.enderecoServidor + "</enderecoServidor>";
    }

    @Override
    public ProtocoloImportarImagem getProtocolo() {
        return ProtocoloImportarImagem.DCM4CHE_2_0_25;
    }

    @Override
    public ImageIcon[] imagensSelecionadas() {
        return null;
    }
}

