/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico.unimedassis;

import br.gov.ans.www.padroes.tiss.schemas.Dm_simNao;
import br.gov.ans.www.padroes.tiss.schemas.Dm_tipoTransacao;
import jalis.comum.Conexao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.TissWS;
import jalis.laboratorio.util.faturamento.eletronico.tiss.VersaoTiss;
import jalis.laboratorio.util.faturamento.eletronico.unimedassis.ComunicacaoUnimedAssis;
import jalis.model.bean.cadastro.FilialBean;
import jalis.util.Funcoes;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public class SolicitaStatusAutorizacaoUnimedAssis
extends TissWS {
    private static final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private static final String TAG_BODY = "soapenv:Body";
    private static final String TAG_CABECALHO = "sch:cabecalho";
    private static final String TAG_SOLICITACAO_STATUS_AUTORIZACAO_WS = "sch:solicitacaoStatusAutorizacaoWS";
    private static final String TAG_IDENTIFICACAO_TRANSACAO = "sch:identificacaoTransacao";
    private static final String TAG_TIPO_TRANSACAO = "sch:tipoTransacao";
    private static final String TAG_SEQUENCIAL_TRANSACAO = "sch:sequencialTransacao";
    private static final String TAG_DATA_REGISTRO_TRANSACAO = "sch:dataRegistroTransacao";
    private static final String TAG_HORA_REGISTRO_TRANSACAO = "sch:horaRegistroTransacao";
    private static final String TAG_ORIGEM = "sch:origem";
    private static final String TAG_IDENTIFICACAO_PRESTADOR = "sch:identificacaoPrestador";
    private static final String TAG_CODIGO_PRESTADOR_NA_OPERADORA = "sch:codigoPrestadorNaOperadora";
    private static final String TAG_DESTINO = "sch:destino";
    private static final String TAG_REGISTRO_ANS = "sch:registroANS";
    private static final String TAG_PADRAO = "sch:Padrao";
    private static final String TAG_LOGIN_SENHA_PRESTADOR = "sch:loginSenhaPrestador";
    private static final String TAG_LOGIN_PRESTADOR = "sch:loginPrestador";
    private static final String TAG_SENHA_PRESTADOR = "sch:senhaPrestador";
    private static final String TAG_NUMERO_GUIA_PRESTADOR = "sch:numeroGuiaPrestador";
    private static final String TAG_DADOS_BENEFICIARIO = "sch:dadosBeneficiario";
    private static final String TAG_NUMERO_CARTEIRA = "sch:numeroCarteira";
    private static final String TAG_ATENDIMENTO_RN = "sch:atendimentoRN";
    private static final String TAG_HASH = "sch:hash";
    private static final String TAG_SOLICITACAO_STATUS_AUTORIZACAO = "sch:solicitacaoStatusAutorizacao";
    private static final String TAG_IDENTIFICACAO_SOLICITACAO = "sch:identificacaoSolicitacao";
    private static final String TAG_DADOS_CONTRATADO = "sch:dadosContratado";
    public static final String TAG_SERVICO_AUTORIZADO = "ans:servicoAutorizado";
    public static final String TAG_NUMERO_GUIA_OPERADORA = "ans:numeroGuiaOperadora";
    public static final String TAG_PROCEDIMENTO = "ans:procedimento";
    public static final String TAG_CODIGO_PROCEDIMENTO = "ans:codigoProcedimento";
    public static final String TAG_DESCRICAO_PROCEDIMENTO = "ans:descricaoProcedimento";
    public static final String TAG_QUANTIDADE_AUTORIZADA = "ans:quantidadeAutorizada";
    public static final String TAG_MOTIVOS_NEGATIVA = "ans:motivosNegativa";
    public static final String TAG_MOTIVO_NEGATIVA = "ans:motivoNegativa";
    public static final String TAG_CODIGO_GLOSA = "ans:codigoGlosa";
    public static final String TAG_DESCRICAO_GLOSA = "ans:descricaoGlosa";
    public static final String TAG_MENSAGEM_ERRO = "ans:mensagemErro";
    public static final String TAG_AUTORIZACAO_SERVICO = "ans:autorizacaoServico";
    public static final String TAG_DADOS_AUTORIZACAO = "ans:dadosAutorizacao";
    public static final String TAG_SENHA = "ans:senha";
    public static final String TAG_VALIDADE_SENHA = "ans:dataValidadeSenha";
    public static final String TAG_STATUS_AUTORIZACAO = "ans:statusSolicitacao";
    public static final String TAG_DATA_AUTORIZACAO = "ans:dataAutorizacao";
    public static final String TAG_DATA_VALIDADE = "ans:dataValidadeSenha";
    private String padrao = null;
    private String sequencialTransacao = null;
    private String dataRegistroTransacao = null;
    private String horaRegistroTransacao = null;
    private String codigoPrestadorNaOperadora = null;
    private String registroANS = null;
    private String codigoNaOperadora = null;
    private String nomeContratado = null;
    private String numeroGuiaPrestador = null;
    private String numeroCarteira = null;
    private String nomeBeneficiario = null;
    private String address = null;
    private String login = "";
    private String senha = "";

    private String getXMLAutorizacao() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.escrever("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:sch=\"http://www.ans.gov.br/padroes/tiss/schemas\" xmlns:xd=\"http://www.w3.org/2000/09/xmldsig#\">");
            xml.escrever("<soapenv:Header/>");
            xml.abrir(TAG_BODY);
            xml.abrir(TAG_SOLICITACAO_STATUS_AUTORIZACAO_WS);
            this.montaCabecalhoSolicitacaoStatusAutorizacao(xml);
            this.montaSolicitacaoStatusAutorizacao(xml);
            xml.escrever(TAG_HASH, this.getSenha());
            xml.fechar(TAG_SOLICITACAO_STATUS_AUTORIZACAO_WS);
            xml.fechar(TAG_BODY);
            xml.escrever("</soapenv:Envelope>");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return xml.getXML();
    }

    public XMLStringBuilder montaCabecalhoSolicitacaoStatusAutorizacao(XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(TAG_CABECALHO);
        xml.abrir(TAG_IDENTIFICACAO_TRANSACAO);
        xml.escrever(TAG_TIPO_TRANSACAO, Dm_tipoTransacao.SOLICITA_STATUS_AUTORIZACAO.toString());
        xml.escrever(TAG_SEQUENCIAL_TRANSACAO, this.getSequencialTransacao());
        xml.escrever(TAG_DATA_REGISTRO_TRANSACAO, this.getDataRegistroTransacao());
        xml.escrever(TAG_HORA_REGISTRO_TRANSACAO, this.getHoraRegistroTransacao());
        xml.fechar(TAG_IDENTIFICACAO_TRANSACAO);
        xml.abrir(TAG_ORIGEM);
        xml.abrir(TAG_IDENTIFICACAO_PRESTADOR);
        xml.escrever(TAG_CODIGO_PRESTADOR_NA_OPERADORA, this.getCodigoPrestadorNaOperadora());
        xml.fechar(TAG_IDENTIFICACAO_PRESTADOR);
        xml.fechar(TAG_ORIGEM);
        xml.abrir(TAG_DESTINO);
        xml.escrever(TAG_REGISTRO_ANS, this.getRegistroANS());
        xml.fechar(TAG_DESTINO);
        xml.escrever(TAG_PADRAO, this.getPadrao());
        xml.abrir(TAG_LOGIN_SENHA_PRESTADOR);
        xml.escrever(TAG_LOGIN_PRESTADOR, this.getLogin());
        xml.escrever(TAG_SENHA_PRESTADOR, this.getSenha());
        xml.fechar(TAG_LOGIN_SENHA_PRESTADOR);
        xml.fechar(TAG_CABECALHO);
        return xml;
    }

    private XMLStringBuilder montaSolicitacaoStatusAutorizacao(XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(TAG_SOLICITACAO_STATUS_AUTORIZACAO);
        xml.abrir(TAG_IDENTIFICACAO_SOLICITACAO);
        xml.escrever(TAG_REGISTRO_ANS, this.getRegistroANS());
        xml.escrever(TAG_NUMERO_GUIA_PRESTADOR, this.getNumeroGuiaPrestador());
        xml.fechar(TAG_IDENTIFICACAO_SOLICITACAO);
        xml.abrir(TAG_DADOS_BENEFICIARIO);
        xml.escrever(TAG_NUMERO_CARTEIRA, this.getNumeroCarteira());
        xml.escrever(TAG_ATENDIMENTO_RN, Dm_simNao.N.toString());
        xml.fechar(TAG_DADOS_BENEFICIARIO);
        xml.abrir(TAG_DADOS_CONTRATADO);
        xml.escrever(TAG_CODIGO_PRESTADOR_NA_OPERADORA, this.getCodigoPrestadorNaOperadora());
        xml.fechar(TAG_DADOS_CONTRATADO);
        xml.fechar(TAG_SOLICITACAO_STATUS_AUTORIZACAO);
        return xml;
    }

    public static String solicitarStatusAutorizacaoUnimedAssis(FilialBean filial, String paciente, String matricula, String guia, String configAutorizacaoProcedimento) throws Exception {
        SplashMensagem splash = null;
        String xmlConfigAutorizacao = StringUtil.getValor(configAutorizacaoProcedimento, "configuracaoAutorizacao");
        String caminhoWSAutorizacao = StringUtil.getValor(xmlConfigAutorizacao, "caminhoWebService");
        String codigoPrestador = StringUtil.getValor(xmlConfigAutorizacao, "codigoPrestador");
        String seqTransacao = StringUtil.getValor(xmlConfigAutorizacao, "sequencialTransacao");
        String registroANS = StringUtil.getValor(xmlConfigAutorizacao, "registroANS");
        String login = StringUtil.getValor(xmlConfigAutorizacao, "login");
        String senha = StringUtil.getValor(xmlConfigAutorizacao, "senha");
        Integer seq = Integer.parseInt(seqTransacao) + 1;
        SolicitaStatusAutorizacaoUnimedAssis solicitaStatusAutorizacao = new SolicitaStatusAutorizacaoUnimedAssis();
        solicitaStatusAutorizacao.setDataRegistroTransacao(Funcoes.formataData("yyyy-MM-dd", new Date()));
        solicitaStatusAutorizacao.setHoraRegistroTransacao(Funcoes.formataData("HH:mm:ss", new Date()));
        solicitaStatusAutorizacao.setAddress(caminhoWSAutorizacao);
        solicitaStatusAutorizacao.setSequencialTransacao(String.valueOf(seq));
        solicitaStatusAutorizacao.setNumeroCarteira(matricula.trim());
        solicitaStatusAutorizacao.setNomeBeneficiario(paciente);
        solicitaStatusAutorizacao.setNomeContratado(filial != null ? filial.getRazaoSocial() : "");
        solicitaStatusAutorizacao.setPadrao(VersaoTiss.V_4_01_00.toString());
        solicitaStatusAutorizacao.setCodigoPrestadorNaOperadora(codigoPrestador);
        solicitaStatusAutorizacao.setRegistroANS(registroANS);
        solicitaStatusAutorizacao.setNumeroGuiaPrestador(guia);
        solicitaStatusAutorizacao.setLogin(login);
        solicitaStatusAutorizacao.setSenha(senha);
        String autorizacao = null;
        splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
        splash.mostrar("Consultando procedimentos. Aguarde...");
        try {
            ComunicacaoUnimedAssis comunicacaoUnimedAssis = new ComunicacaoUnimedAssis(solicitaStatusAutorizacao.getXMLAutorizacao(), solicitaStatusAutorizacao.getAddress());
            autorizacao = comunicacaoUnimedAssis.enviarSolicitacaoStatusAutorizacaoXML();
            splash.apagar();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            splash.apagar();
        }
        return autorizacao;
    }

    private String criptografaSenha(String senha) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(senha.getBytes(), 0, senha.length());
            BigInteger password = new BigInteger(1, m.digest());
            senha = String.format("%1$032X", password);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return senha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void atualizaConfiguracaoStatusProcedimento(int sequencia, String xml, String codFilial, String codConvenio) {
        StringBuilder buf = new StringBuilder(xml);
        String seqAnterior = StringUtil.getValor(xml, "sequencialTransacao");
        String anterior = "<sequencialTransacao>" + seqAnterior + "</" + "sequencialTransacao" + ">";
        String novo = "<sequencialTransacao>" + sequencia + "</" + "sequencialTransacao" + ">";
        buf.replace(xml.indexOf(anterior), xml.indexOf(anterior) + anterior.length(), String.valueOf(novo));
        xml = buf.toString();
        buf.setLength(0);
        buf.append("update convenios set con_configstatustiss = '").append(xml).append("' ");
        buf.append(" where fil_codigo = ").append(codFilial);
        buf.append(" and con_codigo = ").append(codConvenio);
        Statement st = Conexao.getStatement();
        try {
            Conexao.executeUpdate(codFilial, st, buf.toString());
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel atualizar as configura\u00e7\u00f5es da solicita\u00e7\u00e3o de procedimento.\n" + e.getMessage(), e.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    public String getPadrao() {
        return this.padrao;
    }

    public void setPadrao(String padrao) {
        this.padrao = padrao;
    }

    public String getSequencialTransacao() {
        return this.sequencialTransacao;
    }

    public void setSequencialTransacao(String sequencialTransacao) {
        this.sequencialTransacao = sequencialTransacao;
    }

    public String getDataRegistroTransacao() {
        return this.dataRegistroTransacao;
    }

    public void setDataRegistroTransacao(String dataRegistroTransacao) {
        this.dataRegistroTransacao = dataRegistroTransacao;
    }

    public String getHoraRegistroTransacao() {
        return this.horaRegistroTransacao;
    }

    public void setHoraRegistroTransacao(String horaRegistroTransacao) {
        this.horaRegistroTransacao = horaRegistroTransacao;
    }

    public String getCodigoPrestadorNaOperadora() {
        return this.codigoPrestadorNaOperadora;
    }

    public void setCodigoPrestadorNaOperadora(String codigoPrestadorNaOperadora) {
        this.codigoPrestadorNaOperadora = codigoPrestadorNaOperadora;
    }

    public String getRegistroANS() {
        return this.registroANS;
    }

    public void setRegistroANS(String registroANS) {
        this.registroANS = registroANS;
    }

    public String getCodigoNaOperadora() {
        return this.codigoNaOperadora;
    }

    public void setCodigoNaOperadora(String codigoNaOperadora) {
        this.codigoNaOperadora = codigoNaOperadora;
    }

    public String getNomeContratado() {
        return this.nomeContratado;
    }

    public void setNomeContratado(String nomeContratado) {
        this.nomeContratado = nomeContratado;
    }

    public String getNumeroGuiaPrestador() {
        return this.numeroGuiaPrestador;
    }

    public void setNumeroGuiaPrestador(String numeroGuiaPrestador) {
        this.numeroGuiaPrestador = numeroGuiaPrestador;
    }

    public String getNumeroCarteira() {
        return this.numeroCarteira;
    }

    public void setNumeroCarteira(String numeroCarteira) {
        this.numeroCarteira = numeroCarteira;
    }

    public String getNomeBeneficiario() {
        return this.nomeBeneficiario;
    }

    public void setNomeBeneficiario(String nomeBeneficiario) {
        this.nomeBeneficiario = nomeBeneficiario;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = this.criptografaSenha(senha).toLowerCase();
    }
}

