/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico.unimedassis;

import jalis.comum.dados.DadosExames;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;

public class SelecionaExamesUnimedAssis
extends AbstractDialogoOKCancelar
implements ActionListener {
    private static final int COLUNA_CHECKBOX = 3;
    private static final int COLUNA_OBJETO = 4;
    private static final String TITULO = "Selecione o exame correspondente";
    private JLabel labelAMB = new JLabel("C\u00f3digo AMB:");
    private JLabel labelQtdAutorizada = new JLabel("Qtde. autorizada:");
    private TTextField textAMB = new TTextField(50, 3);
    private TTextField textQtd = new TTextField(3, 3);
    private int qntAutorizada = 0;
    private transient ArrayList<DadosExames> examesJaAdicionadosRequisicao = new ArrayList();
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Material", ""}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 3) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3;
        }
    };
    int[] colunas = new int[]{65, 0, 100, 20};
    JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, this.colunas);
    JScrollPane scrollExames = new JScrollPane(this.tableExames);

    public static SelecionaExamesUnimedAssis novaInstancia(Object owner) {
        return owner instanceof Frame ? new SelecionaExamesUnimedAssis((Frame)owner) : new SelecionaExamesUnimedAssis((Dialog)owner);
    }

    public SelecionaExamesUnimedAssis(Frame owner) {
        super(owner, TITULO);
        this.iniciar();
        this.setLocationRelativeTo(owner);
    }

    public SelecionaExamesUnimedAssis(Dialog owner) {
        super(owner, TITULO);
        this.iniciar();
        this.setLocationRelativeTo(owner);
    }

    public void setGuia(String guia) {
        this.setTitle("Selecione o exame correspondente da guia " + guia);
    }

    private void iniciar() {
        this.setSize(new Dimension(750, 300));
        this.setResizable(false);
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        this.tableExames.setModel(this.modeloExames);
        this.scrollExames.setPreferredSize(new Dimension(20, 20));
        Font fonte = new Font(this.labelAMB.getFont().getName(), 1, this.labelAMB.getFont().getSize());
        this.labelAMB.setFont(fonte);
        this.labelQtdAutorizada.setFont(fonte);
        this.textAMB.setPreferredSize(new Dimension(480, 20));
        this.textQtd.setPreferredSize(new Dimension(40, 20));
        this.textQtd.setMinimumSize(new Dimension(40, 20));
        this.modeloExames.setColumnSize(new int[]{100, 200, 700}, this.tableExames);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 0, 0);
        panel.add((Component)this.labelAMB, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(1, 5, 0, 0);
        panel.add((Component)this.textAMB, c);
        c.gridwidth = 0;
        c.insets = new Insets(1, 5, 0, 0);
        ++c.gridx;
        c.fill = 0;
        panel.add((Component)this.labelQtdAutorizada, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(1, 120, 0, 0);
        panel.add((Component)this.textQtd, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)this.scrollExames, c);
        this.textQtd.setEditable(false);
        this.textAMB.setEditable(false);
        this.setUsuarioPodeCancelar(false);
        this.buttonCancelar.setVisible(false);
        this.tableExames.registerKeyboardAction(null, KeyStroke.getKeyStroke(10, 0), 1);
        this.tableExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ScreenUtil.requisitarFoco(SelecionaExamesUnimedAssis.this.buttonOK);
                }
            }
        });
        this.tableExames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SelecionaExamesUnimedAssis.this.tableExames.getSelectedRow() >= 0) {
                    Registro reg = (Registro)SelecionaExamesUnimedAssis.this.modeloExames.getValueAt(SelecionaExamesUnimedAssis.this.tableExames.getSelectedRow(), 4);
                    SelecionaExamesUnimedAssis.this.textAMB.setText(reg.getString("exame"));
                }
            }
        });
        ScreenUtil.requisitarFoco(this.textAMB);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK && !this.validaExamesSelecionados()) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "\u00c9 obrigat\u00f3rio selecionar a quantidade de exames autorizados.", 2);
            return;
        }
        super.actionPerformed(e);
    }

    private boolean validaExamesSelecionados() {
        ArrayList<Registro> examesSelecionados = new ArrayList<Registro>();
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            boolean isSelecionado = (Boolean)this.modeloExames.getValueAt(i, 3);
            if (!isSelecionado) continue;
            examesSelecionados.add((Registro)this.modeloExames.getValueAt(i, 4));
        }
        return examesSelecionados.size() == this.getQntAutorizada();
    }

    public void setExames(List<Registro> exames) {
        String codAMB = "";
        for (Registro c : exames) {
            ExameVO exameVO = (ExameVO)c.getValor("objetoExame");
            this.modeloExames.addLine(new Object[]{exameVO.getCodigo(), c.getValor("exa_descricao"), c.getValor("mco_descricao"), this.isExameJaAdicionadoRequisicao(c), c});
            codAMB = (String)c.getValor("exame");
        }
        this.textAMB.setText(codAMB);
        this.textQtd.setText(String.valueOf(this.getQntAutorizada()));
        this.tableExames.getSelectionModel().setSelectionInterval(0, 0);
    }

    public List<Registro> getExames() {
        ArrayList<Registro> exames = new ArrayList<Registro>();
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            boolean isSelecionado = (Boolean)this.modeloExames.getValueAt(i, 3);
            if (!isSelecionado) continue;
            exames.add((Registro)this.modeloExames.getValueAt(i, 4));
        }
        return exames;
    }

    private boolean isExameJaAdicionadoRequisicao(Registro exame) {
        if (this.examesJaAdicionadosRequisicao.isEmpty()) {
            return false;
        }
        for (DadosExames dadosExameRequisicao : this.examesJaAdicionadosRequisicao) {
            String codExame = (String)exame.getValor("codigoexame");
            Integer codMaterial = (Integer)exame.getValor("codigomaterial");
            if (!codExame.equals(dadosExameRequisicao.getCodigo()) || !codMaterial.equals(dadosExameRequisicao.getCodigoMaterialColetado())) continue;
            this.examesJaAdicionadosRequisicao.remove(dadosExameRequisicao);
            return true;
        }
        return false;
    }

    public void setExamesJaAdicionadosRequisicao(ArrayList<DadosExames> examesGridRequisicao) {
        this.examesJaAdicionadosRequisicao = examesGridRequisicao;
    }

    public ArrayList<DadosExames> getExamesJaAdicionadosRequisicao() {
        return this.examesJaAdicionadosRequisicao;
    }

    public int getQntAutorizada() {
        return this.qntAutorizada;
    }

    public void setQntAutorizada(int qntAutorizada) {
        this.qntAutorizada = qntAutorizada;
    }
}

