/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico.unimedassis;

import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class ComunicacaoUnimedAssis {
    private static final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private String xml = "";
    private String caminho = "";

    public ComunicacaoUnimedAssis(String xml, String caminho) {
        this.xml = xml;
        this.caminho = caminho;
    }

    public HttpUriRequest request(String xml, String url) {
        return RequestBuilder.post((String)url.replace("?wsdl", "")).addHeader("Content-Type", "text/xml").setCharset(StandardCharsets.UTF_8).setEntity((HttpEntity)new StringEntity(xml, "UTF-8")).build();
    }

    public SSLConnectionSocketFactory construirSSL() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
        return new SSLConnectionSocketFactory(builder.build());
    }

    public boolean redirecionar(CloseableHttpResponse response) {
        return null != response && response.getStatusLine().getStatusCode() == 301;
    }

    public boolean statusOK(CloseableHttpResponse response) {
        return null != response && response.getStatusLine().getStatusCode() == 200;
    }

    private CloseableHttpResponse request(String url) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, IOException {
        CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.construirSSL()).build();
        HttpUriRequest request = this.request(this.xml, url);
        return client.execute(request);
    }

    public String enviarSolicitacaoStatusAutorizacaoXML() {
        CloseableHttpResponse response = null;
        String retorno = "";
        try {
            ComunicacaoUnimedAssis.debug(this.xml, this.caminho);
            response = this.request(this.caminho);
            if (this.redirecionar(response)) {
                for (Header header : response.getAllHeaders()) {
                    if (!header.getName().equals("Location")) continue;
                    response = this.request(header.getValue());
                    break;
                }
            }
            if (response != null) {
                HttpEntity entity = response.getEntity();
                retorno = StringUtil.xmlToTexto(EntityUtils.toString((HttpEntity)entity));
                ComunicacaoUnimedAssis.debug(retorno, "RETORNO(" + this.caminho + ")");
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter conex\u00e3o com a operadora.", 1);
            return "";
        }
        return retorno;
    }

    private static void debug(String mensagem, String tipo) {
        if (DEBUG) {
            StringBuilder bui = new StringBuilder();
            bui.append("===================== ");
            bui.append(tipo);
            bui.append(" =====================\n");
            bui.append(mensagem);
            bui.append("\n========================================================================");
            System.out.println(bui.toString());
        }
    }
}

