/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico.tiss;

import jalis.util.Funcoes;

public enum VersaoTiss {
    V_2_01_03("2.01.03", 20103),
    V_2_02_01("2.02.01", 20201),
    V_2_02_02("2.02.02", 20202),
    V_2_02_03("2.02.03", 20203),
    V_3_00_01("3.00.01", 30001),
    V_3_01_00("3.01.00", 30100),
    V_3_02_00("3.02.00", 30200),
    V_3_02_01("3.02.01", 30201),
    V_3_02_02("3.02.02", 30202),
    V_3_03_00("3.03.00", 30300),
    V_3_03_01("3.03.01", 30301),
    V_3_03_02("3.03.02", 30302),
    V_3_03_03("3.03.03", 30303),
    V_3_04_00("3.04.00", 30400),
    V_3_04_01("3.04.01", 30401),
    V_3_05_00("3.05.00", 30500),
    V_4_00_00("4.00.00", 40000),
    V_4_00_01("4.00.01", 40001),
    V_4_01_00("4.01.00", 40100);

    private String descricao;
    private Integer numero;

    private VersaoTiss(String descricao, Integer numero) {
        this.descricao = descricao;
        this.numero = numero;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public Integer getNumero() {
        return this.numero;
    }

    public static VersaoTiss getVersaoPorDescricao(String descricaoVersao) {
        VersaoTiss versao = null;
        if (!Funcoes.textoVazio(descricaoVersao)) {
            for (VersaoTiss v : VersaoTiss.values()) {
                if (!descricaoVersao.equalsIgnoreCase(v.getDescricao())) continue;
                return v;
            }
        }
        return versao;
    }

    public boolean isVersaoMaior(VersaoTiss versaoTiss) {
        return this.getNumero() >= versaoTiss.getNumero();
    }

    public String toString() {
        return this.descricao;
    }
}

