/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico.tiss;

import jalis.laboratorio.util.faturamento.eletronico.tiss.VersaoTiss;
import jalis.util.Funcoes;
import java.util.ArrayList;

public enum TipoAtendimento {
    REMOCAO("01", "Remo\u00e7\u00e3o", VersaoTiss.V_4_00_00),
    PEQUENA_CIRURGIA("02", "Pequena Cirurgia", VersaoTiss.V_4_00_00),
    OUTRAS_TERAPIAS("03", "Outras Terapias", VersaoTiss.V_4_00_00),
    CONSULTA("04", "Consulta", VersaoTiss.V_4_00_00),
    EXAMES_AMBULATORIAL("05", "Exames Ambulatorial", VersaoTiss.V_4_00_00),
    ATENDIMENTO_DOMICILIAR("06", "Atendimento Domiciliar", VersaoTiss.V_3_05_00),
    INTERNACAO("07", "Interna\u00e7\u00e3o", VersaoTiss.V_3_05_00),
    QUIMIOTERAPIA("08", "Quimioterapia", VersaoTiss.V_4_00_00),
    RADIOTERAPIA("09", "Radioterapia", VersaoTiss.V_4_00_00),
    TERAPIA_RENAL_SUBSTITUTIVA("10", "Terapia Renal Substitutiva (TRS)", VersaoTiss.V_4_00_00),
    PRONTO_SOCORRO("11", "Pronto Socorro", VersaoTiss.V_3_05_00),
    OCUPACIONAL("12", "Ocupacional", VersaoTiss.V_3_05_00),
    PEQUENOS_ATENDIMENTOS("13", "Pequenos atendimentos", VersaoTiss.V_4_00_00),
    SAUDE_OCUPACIONAL_ADMISSIONAL("14", "Sa\u00fade Ocupacional - Admissional", VersaoTiss.V_3_05_00),
    SAUDE_OCUPACIONAL_DEMISSIONAL("15", "Sa\u00fade Ocupacional - Demissional", VersaoTiss.V_3_05_00),
    SAUDE_OCUPACIONAL_PERIODICO("16", "Sa\u00fade Ocupacional - Peri\u00f3dico", VersaoTiss.V_3_05_00),
    SAUDE_OCUPACIONAL_RETORNO("17", "Sa\u00fade Ocupacional - Retorno ao trabalho", VersaoTiss.V_3_05_00),
    SAUDE_OCUPACIONAL_MUDANCA_FUNCAO("18", "Sa\u00fade Ocupacional - Mudan\u00e7a de fun\u00e7\u00e3o", VersaoTiss.V_3_05_00),
    SAUDE_OCUPACIONAL_PROMOCAO_SAUDE("19", "Sa\u00fade Ocupacional - Promo\u00e7\u00e3o a sa\u00fade", VersaoTiss.V_3_05_00),
    SAUDE_OCUPACIONAL_BENEFICIARIO_NOVO("20", "Sa\u00fade Ocupacional - Benefici\u00e1rio novo", VersaoTiss.V_3_05_00),
    SAUDE_OCUPACIONAL_ASSISTENCIA_DEMITIDOS("21", "Sa\u00fade Ocupacional - Assist\u00eancia a demitidos", VersaoTiss.V_3_05_00),
    TELESSAUDE("22", "Telessaude", VersaoTiss.V_3_05_00),
    EXAME("23", "Exame", VersaoTiss.V_4_00_01),
    TIPO_ATENDIMENTO_SITUACAO("24", "Utilizar tipo de atendimento da situa\u00e7\u00e3o", VersaoTiss.V_4_00_00);

    private String codigo;
    private String descricao;
    private VersaoTiss versaoTiss;

    private TipoAtendimento(String codigo, String descricao, VersaoTiss versaoTiss) {
        this.codigo = codigo;
        this.descricao = descricao;
        this.versaoTiss = versaoTiss;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public VersaoTiss getVersaoTiss() {
        return this.versaoTiss;
    }

    public static String getCodigoPorTipoAtendimento(String tipoAtendimento) {
        if (Funcoes.textoVazio(tipoAtendimento)) {
            return EXAMES_AMBULATORIAL.getCodigo();
        }
        if (!tipoAtendimento.contains("-")) {
            return TIPO_ATENDIMENTO_SITUACAO.getDescricao();
        }
        String[] tipos = tipoAtendimento.split("-");
        for (TipoAtendimento ta : TipoAtendimento.values()) {
            if (!tipos[0].equals(ta.getCodigo())) continue;
            return ta.getCodigo();
        }
        return EXAMES_AMBULATORIAL.getCodigo();
    }

    public static TipoAtendimento getTipoAtendimentoPorCodigoEDescricao(String tipoAtendimento) {
        if (Funcoes.textoVazio(tipoAtendimento)) {
            return EXAMES_AMBULATORIAL;
        }
        if (!tipoAtendimento.contains("-")) {
            return TIPO_ATENDIMENTO_SITUACAO;
        }
        String[] tipos = tipoAtendimento.split("-");
        for (TipoAtendimento ta : TipoAtendimento.values()) {
            if (!tipos[0].equals(ta.getCodigo())) continue;
            return ta;
        }
        return EXAMES_AMBULATORIAL;
    }

    public static TipoAtendimento[] getAtendimentosPorVersaoTiss(VersaoTiss versaoTiss) {
        ArrayList<TipoAtendimento> tipos = new ArrayList<TipoAtendimento>();
        if (versaoTiss == null) {
            for (TipoAtendimento ta : TipoAtendimento.values()) {
                if (ta.getVersaoTiss().getNumero() > VersaoTiss.V_4_00_00.getNumero()) continue;
                tipos.add(ta);
            }
        }
        if (versaoTiss != null && versaoTiss.equals((Object)VersaoTiss.V_4_00_00)) {
            for (TipoAtendimento ta : TipoAtendimento.values()) {
                if (!ta.getVersaoTiss().equals((Object)VersaoTiss.V_4_00_00)) continue;
                tipos.add(ta);
            }
        }
        if (versaoTiss != null && (versaoTiss.equals((Object)VersaoTiss.V_4_00_01) || versaoTiss.equals((Object)VersaoTiss.V_4_01_00))) {
            for (TipoAtendimento ta : TipoAtendimento.values()) {
                if (!ta.getVersaoTiss().equals((Object)VersaoTiss.V_4_00_00) && !ta.getVersaoTiss().equals((Object)VersaoTiss.V_4_00_01)) continue;
                tipos.add(ta);
            }
        }
        return tipos.toArray(new TipoAtendimento[tipos.size()]);
    }

    public String toString() {
        if (this.equals((Object)TIPO_ATENDIMENTO_SITUACAO)) {
            return this.descricao;
        }
        return this.codigo + "-" + this.descricao;
    }
}

