/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico.tiss;

import jalis.util.Funcoes;

public enum RegimeAtendimento {
    AMBULATORIAL("01", "Ambulatorial"),
    DOMICILIAR("02", "Domiciliar"),
    INTERNACAO("03", "Interna\u00e7\u00e3o"),
    PRONTO_SOCORRO("04", "Pronto Socorro"),
    TELESSAUDE("05", "Telessa\u00fade");

    private String codigo;
    private String descricao;

    private RegimeAtendimento(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static RegimeAtendimento getRegimeAtendimentoPorCodigoEDescricao(String regimeAtendimento) {
        if (!regimeAtendimento.contains("-")) {
            return AMBULATORIAL;
        }
        String[] codigoDescricao = regimeAtendimento.split("-");
        for (RegimeAtendimento ra : RegimeAtendimento.values()) {
            if (!codigoDescricao[0].equals(ra.getCodigo())) continue;
            return ra;
        }
        return AMBULATORIAL;
    }

    public static RegimeAtendimento getRegimeAtendimentoPorCodigo(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            return AMBULATORIAL;
        }
        for (RegimeAtendimento ra : RegimeAtendimento.values()) {
            if (!codigo.contentEquals(ra.getCodigo())) continue;
            return ra;
        }
        return AMBULATORIAL;
    }

    public String toString() {
        return this.codigo + "-" + this.descricao;
    }
}

