/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico.tiss;

import jalis.util.Funcoes;

public enum GrauParticipacao {
    CIRURGIAO("00", "Cirurgi\u00e3o"),
    PRIMEIRO_AUXILIAR("01", "Primeiro Auxiliar"),
    SEGUNDO_AUXILIAR("02", "Segundo Auxiliar"),
    TERCEIRO_AUXILIAR("03", "Terceiro Auxiliar"),
    QUARTO_AUXILIAR("04", "Quarto Auxiliar"),
    INSTRUMENTADOR("05", "Instrumentador"),
    ANESTESISTA("06", "Anestesista"),
    AUXILIAR_ANESTESIA("07", "Auxiliar de anestesia"),
    CONSULTOR("08", "Consultor"),
    PERFUSIONISTA("09", "Perfusionista"),
    PEDIATRA_SALA_PARTO("10", "Pediatra na sala de parto"),
    AUXILIAR_SADT("11", "Auxiliar SADT"),
    CLINICO("12", "Cl\u00ednico"),
    INTENSIVISTA("13", "Intensivista");

    private String codigo = null;
    private String descricao = null;

    private GrauParticipacao(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static GrauParticipacao getGrauParticipacao(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            return null;
        }
        for (GrauParticipacao aux : GrauParticipacao.values()) {
            if (!codigo.equalsIgnoreCase(aux.getCodigo())) continue;
            return aux;
        }
        return null;
    }

    public String toString() {
        return this.descricao;
    }
}

