/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico.tiss;

import jalis.comum.CBOS;
import jalis.comum.ConstantesGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.Tiss;
import jalis.laboratorio.util.faturamento.eletronico.tiss.GrauParticipacao;
import jalis.laboratorio.util.faturamento.eletronico.tiss.RegimeAtendimento;
import jalis.laboratorio.util.faturamento.eletronico.tiss.TipoAtendimento;
import jalis.laboratorio.util.faturamento.eletronico.tiss.VersaoTiss;
import jalis.laboratorio.util.faturamento.eletronico.tiss.ViaAcessoEnum;
import jalis.util.DialogoFiltro;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ValidaDoc;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ConfigurarTiss
extends JDialog
implements ActionListener {
    public static final String CODIGO_PRESTADOR = "codigoPrestadorNaOperadora";
    public static final String CNPJ_PRESTADOR = "cnpjPrestadorNaOperadora";
    public static final String SEQUENCIAL_LOTE = "sequencialLote";
    public static final String REGISTRO_ANS = "registroANS";
    public static final String CONVENIO_REGISTRO_ANS = "convenioRegistroANS";
    public static final String NOME_ARQUIVO = "nomeArquivoTiss";
    public static final String GUIA_AUTOMATICA = "guiaAutomatica";
    public static final String GUIA_OPERADORA = "adicionarGuiaOperadora";
    public static final String CNPJ_OPERADORA = "adicionarCNPJOperadora";
    public static final String SOLICITAR_LOTE = "solicitarLote";
    public static final String NOME_EXECUTANTE = "nomeExecutante";
    public static final String CONSELHO_EXECUTANTE = "conselhoExecutante";
    public static final String UF_EXECUTANTE = "ufExecutante";
    public static final String CODIGO_EXECUTANTE = "codigoExecutante";
    public static final String REPETIR_GUIA_OPERADORA = "repetirGuiaOperadora";
    public static final String TAMANHO_GUIA = "tamanhoGuia";
    public static final String ENVIAR_CRM = "enviarCRM";
    public static final String ENVIAR_CID10_SEM_MASCARA = "enviarCID10SemMascara";
    public static final String IGNORAR_CODIGO_FILIAL = "ignorarCodigoFilial";
    public static final String IGNORAR_MILISSEGUNDOS = "ignorarMilissegundos";
    public static final String CODIFICACAO_ARQUIVO = "codificacaoArquivo";
    public static final String LIMITE_GUIAS_ARQUIVO = "limiteGuiasArquivo";
    public static final String VALOR_ZERO_GUIA_PRINCIPAL = "valorZeroGuiaPrincipal";
    public static final String PROIBIR_GUIA_REPETIDA = "proibirGuiaRepetida";
    public static final String TAMANHO_MINIMO_GUIA = "tamanhoMinimoGuia";
    public static final String UTILIZAR_SADT_INTERNADO = "utilizarSADTInternado";
    public static final String UTILIZAR_DATA_COLETA = "utilizarDataColeta";
    public static final String TIPO_ATENDIMENTO = "tipoAtendimento";
    public static final String INDICADOR_ACIDENTE = "indicadorAcidente";
    public static final String IGNORAR_CODIGO_OPERADORA_MEDICO = "ignorarCodigoOperadoraMedico";
    public static final String UTILIZAR_GUIA_COMO_AUTORIZACAO = "utilizarGuiaComoAutorizacao";
    public static final String LIMPAR_CARACTERES_DA_GUIA = "limparCaracteresGuia";
    public static final String NAO_UTILIZAR_CNPJ_PRESTADOR = "naoUtilizarCNPJPrestador";
    public static final String ENVIAR_REDUCAO_ACRESCIMO = "enviarReducaoAcrescimo";
    public static final String CBOS_PADRAO = "cbosPadrao";
    public static final String REMOVER_PONTOS_CBOS = "removerPontoCBO";
    public static final String CARTAO_SUS_PADRAO = "cartaoSUS";
    public static final String GRAU_PARTICIPACAO_EXECUTANTE = "grauParticipacaoExecutante";
    public static final String UTILIZAR_CPF_CNPJ_PADRAO = "utilizarCpfCnpjPadrao";
    public static final String CPF_CNPJ = "cpfCnpj";
    public static final String NAO_UTILIZAR_GRAU_PARTICIPACAO = "naoUtilizarGrauParticipacao";
    public static final String ASSINAR_ARQUIVO_ELETRONICO = "assinarArquivoEletronico";
    public static final String ENVIAR_CARACTERES_MATRICULA = "enviarCaracteresMatricula";
    public static final String NOME_ARQUIVO_TISS = "Padr\u00e3o Tiss";
    public static final String NOME_ARQUIVO_JALIS = "Padr\u00e3o Jalis";
    public static final String NAO_INFORMAR_VIA_ACESSO = "naoUtilizaViaAcesso";
    public static final String NAO_INFORMAR_TECNICA_UTILIZADA = "naoInformaTecnicaUtilizada";
    public static final String VIA_DE_ACESSO = "viaDeAcesso";
    public static final String ENVIAR_INDICACAO_CLINICA = "enviarIndicacaoClinica";
    public static final String REGIME_ATENDIMENTO = "regimeAtendimento";
    public static final String ENVIAR_SAUDE_OCUPACIONAL = "enviarSaudeOcupacional";
    public static final String ENVIAR_ID_COBERTURA_ESPECIAL = "enviarIdCoberturaEspecial";
    public static final String NAO_ENVIAR_CPF_CNPJ_PRESTADOR_MEDICO_SOLICITANTE = "naoEnviarCpfCnpjPrestadorMedicoSolicitante";
    public static final String ENVIAR_CODIGO_PRESTADOR_PADRAO_PARA_MEDICO_SOLICITANTE = "enviarCodigoPrestadorPadraoMedicoSolicitante";
    public static final String ENVIAR_HORARIO_PROCEDIMENTOS = "enviarHorarioProcedimentos";
    public static final String IGNORAR_CODIGO_EXAME_AGRUPAMENTO_PROCEDIMENTOS = "ignorarCodigoExameAgrupamentoProcedimentos";
    TTextField textCNPJPrestador = new TTextField(18, 7);
    TTextField textCodigoPrestador = new TTextField(18);
    TTextField txtRegistroANS = new TTextField(7, 1);
    TTextField txtConvenioRegistroANS = new TTextField(7, 1);
    TTextField textSequencial = new TTextField(4, 1);
    TTextField textNomeExecutante = new TTextField(70);
    TTextField textCodigoExecutante = new TTextField(10);
    JTextField textTamanhoGuia = new TTextField(2, 1);
    TTextField textLimiteGuiasArquivo = new TTextField(3, 1);
    TTextField textTamanhoMinimoGuia = new TTextField(2, 1);
    TTextField textCbosPadrao = new TTextField(50, 3);
    JButton buttonConsultaCBOS = ComponenteFactory.novoJButton(this, true);
    TTextField textCartaoSUS = new TTextField(15, 1);
    JButton buttonSalvar = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    JComboBox comboNome = new JComboBox<String>(new String[]{"Padr\u00e3o Tiss", "Padr\u00e3o Jalis"});
    JComboBox comboConselhoExecutante = new JComboBox<String>(ConstantesGerais.CONSELHOS);
    JComboBox comboEstadoExecutante = new JComboBox<String>(ConstantesGerais.ESTADOS);
    JComboBox<VersaoTiss> comboVersao = new JComboBox<VersaoTiss>(VersaoTiss.values());
    JComboBox<RegimeAtendimento> comboRegimeAtendimento = new JComboBox<RegimeAtendimento>(RegimeAtendimento.values());
    JComboBox comboViaAcesso = new JComboBox<Object>(new Object[]{ViaAcessoEnum.VIA_ACESSO_UNICA, ViaAcessoEnum.VIA_ACESSO_MESMA_VIA, ViaAcessoEnum.VIA_ACESSO_DIFERENTES_VIAS});
    JComboBox comboCodificacao = new JComboBox<Object>(new Object[]{FaturamentoEletronico.CODIFICACAO.ISO_8859_1, FaturamentoEletronico.CODIFICACAO.UTF_8});
    JComboBox comboIndicadorAcidente = new JComboBox<String>(ConstantesGerais.INDICADOR_ACIDENTE);
    JComboBox<TipoAtendimento> comboTipoAtendimento = new JComboBox<TipoAtendimento>(TipoAtendimento.getAtendimentosPorVersaoTiss(null));
    JComboBox comboGrauParticipacao = new JComboBox<Object>(new Object[]{GrauParticipacao.CIRURGIAO, GrauParticipacao.PRIMEIRO_AUXILIAR, GrauParticipacao.SEGUNDO_AUXILIAR, GrauParticipacao.TERCEIRO_AUXILIAR, GrauParticipacao.QUARTO_AUXILIAR, GrauParticipacao.INSTRUMENTADOR, GrauParticipacao.ANESTESISTA, GrauParticipacao.AUXILIAR_ANESTESIA, GrauParticipacao.CONSULTOR, GrauParticipacao.PERFUSIONISTA, GrauParticipacao.PEDIATRA_SALA_PARTO, GrauParticipacao.AUXILIAR_SADT, GrauParticipacao.CLINICO, GrauParticipacao.INTENSIVISTA});
    JCheckBox checkGuia = new JCheckBox("Utilizar c\u00f3digo da requisi\u00e7\u00e3o quando Sem Guia");
    JCheckBox checkGuiaOperadora = new JCheckBox("Adicionar numeroGuiaOperadora no arquivo");
    JCheckBox checkRepetirNumeroGuia = new JCheckBox("Repetir n\u00famero guia em numeroGuiaOperadora");
    JCheckBox checkCNPJOperadora = new JCheckBox("Adicionar CNPJ da Operadora no arquivo");
    JCheckBox checkSolicitarLote = ComponenteFactory.novoJCheckBox("Solicitar n\u00famero do lote ao criar o arquivo", this);
    JCheckBox checkEnviarCRM = new JCheckBox("Utilizar CRM de m\u00e9dico como codigoOperadora");
    JCheckBox checkEnviarCID10SemMascara = new JCheckBox("Enviar CID-10 sem m\u00e1scara");
    JCheckBox checkIgnorarCodigoFilial = new JCheckBox("Ignorar c\u00f3digo da filial");
    JCheckBox checkIgnorarMilissegundos = new JCheckBox("Ignorar milissegundos em tags de horas");
    JCheckBox checkValorZeroGuiaPrincipal = new JCheckBox("Utilizar valor 0 (zero) para Guia Principal");
    JCheckBox checkProibirGuiasRepetidas = new JCheckBox("Proibir guias repetidas");
    JCheckBox checkUtilizarDataColeta = new JCheckBox("Utilizar data de coleta como data de atendimento");
    JCheckBox checkIgnorarCodOperadoraMedico = new JCheckBox("Ignorar c\u00f3digo do m\u00e9dico na operadora e enviar CRM");
    JCheckBox checkUtilizarGuiaAutorizacao = new JCheckBox("Utilizar n\u00famero da guia como autoriza\u00e7\u00e3o");
    JCheckBox checkLimparCaracteresGuia = new JCheckBox("Limpar caracteres da guia");
    JCheckBox checkNaoUtilizarCNPJPrestador = new JCheckBox("N\u00e3o utilizar CNPJ do Prestador");
    JCheckBox checkEnviarUmReducaoAcrescimo = new JCheckBox("Enviar redu\u00e7\u00e3o de acr\u00e9scimo");
    JCheckBox checkRemoverPontoCBO = new JCheckBox("Enviar apenas n\u00fameros no CBOS");
    TTextField textoCpfCnpj = new TTextField(14, 1);
    JCheckBox checkUtilizarCPFCNPJPadrao = new JCheckBox("Utilizar CPF/CNPJ padr\u00e3o para o m\u00e9dico solicitante");
    JCheckBox checkAssinarArquivoEletronico = new JCheckBox("Assinar arquivo eletr\u00f4nico");
    JCheckBox checkNaoUtilizarGrauParticipacao = new JCheckBox("N\u00e3o utilizar grau de participa\u00e7\u00e3o do executante");
    JCheckBox checkEnviarCaracteresMatricula = new JCheckBox("Enviar caracteres da matr\u00edcula");
    JCheckBox checkNaoInformarViaAcesso = new JCheckBox("N\u00e3o informar via de acesso");
    JCheckBox checkNaoInformarTecnicaUsada = new JCheckBox("N\u00e3o informar t\u00e9cnica utilizada");
    JCheckBox checkEnviarIndicacaoClinica = new JCheckBox("Enviar indica\u00e7\u00e3o cl\u00ednica");
    JCheckBox checkEnviarSaudeOcupacional = new JCheckBox("Enviar Sa\u00fade ocupacional");
    JCheckBox checkEnviarIdentificadorDeCoberturaEspecial = new JCheckBox("Enviar identificador de Cobertura especial");
    JCheckBox checkNaoEnviarCpfCnpjPrestador = new JCheckBox("N\u00e3o enviar CPF/CNPJ/Prestador para o m\u00e9dico solicitante");
    JCheckBox checkEnviarCodigoPrestadorPadrao = new JCheckBox("Enviar c\u00f3digo prestador padr\u00e3o para o m\u00e9dico solicitante");
    JCheckBox checkEnviarHorarioProcedimentos = new JCheckBox("Enviar tag hor\u00e1rio nos procedimentos");
    JCheckBox checkIgnorarCodigoExameAgrupamento = new JCheckBox("Ignorar c\u00f3digo do exame no agrupamento de procedimentos");
    private Map<Integer, String[]> map = new HashMap<Integer, String[]>();
    private boolean ok = false;
    private String sequencia = "";

    public ConfigurarTiss(JFrame owner) {
        super((Frame)owner, "Configurando Tiss");
        this.setSize(new Dimension(780, 700));
        this.setResizable(false);
        this.setLocationRelativeTo(owner);
        this.setModal(true);
        JPanel panelCentro = new JPanel(new GridBagLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)panelCentro, "Center");
        this.checkGuia.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConfigurarTiss.this.checkIgnorarCodigoFilial.setEnabled(true);
                } else {
                    ConfigurarTiss.this.checkIgnorarCodigoFilial.setEnabled(false);
                    ConfigurarTiss.this.checkIgnorarCodigoFilial.setSelected(false);
                }
            }
        });
        JLabel labelAux = null;
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.gridheight = 1;
        c.fill = 2;
        c.weighty = 0.0;
        c.insets = new Insets(0, 2, 0, 0);
        labelAux = new JLabel("CNPJ do Prestador");
        labelAux.setDisplayedMnemonic('P');
        labelAux.setLabelFor(this.textCNPJPrestador);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.textCNPJPrestador.setPreferredSize(new Dimension(250, 20));
        this.textCNPJPrestador.setMinimumSize(new Dimension(250, 20));
        c.insets = new Insets(0, 2, 0, 0);
        panelCentro.add((Component)this.textCNPJPrestador, c);
        ++c.gridy;
        c.insets = new Insets(0, 2, 0, 0);
        labelAux = new JLabel("C\u00f3digo do Prestador");
        labelAux.setLabelFor(this.textCodigoPrestador);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.textCodigoPrestador.setPreferredSize(new Dimension(20, 20));
        c.insets = new Insets(0, 2, 0, 0);
        panelCentro.add((Component)this.textCodigoPrestador, c);
        ++c.gridy;
        c.insets = new Insets(0, 2, 0, 0);
        labelAux = new JLabel("Registro ANS (guias)");
        labelAux.setDisplayedMnemonic('R');
        labelAux.setLabelFor(this.txtRegistroANS);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.txtRegistroANS.setPreferredSize(new Dimension(20, 20));
        c.insets = new Insets(0, 2, 0, 0);
        panelCentro.add((Component)this.txtRegistroANS, c);
        ++c.gridy;
        c.insets = new Insets(0, 2, 0, 0);
        labelAux = new JLabel("Registro ANS (destino)");
        labelAux.setDisplayedMnemonic('e');
        labelAux.setLabelFor(this.txtConvenioRegistroANS);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.txtConvenioRegistroANS.setPreferredSize(new Dimension(20, 20));
        c.insets = new Insets(0, 2, 0, 0);
        panelCentro.add((Component)this.txtConvenioRegistroANS, c);
        ++c.gridy;
        c.insets = new Insets(0, 2, 0, 0);
        labelAux = new JLabel("Sequencial");
        labelAux.setDisplayedMnemonic('l');
        labelAux.setLabelFor(this.textSequencial);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.textSequencial.setPreferredSize(new Dimension(20, 20));
        c.insets = new Insets(0, 2, 0, 0);
        panelCentro.add((Component)this.textSequencial, c);
        ++c.gridy;
        c.insets = new Insets(0, 2, 0, 0);
        labelAux = new JLabel("Nome do executante");
        labelAux.setDisplayedMnemonic('N');
        labelAux.setLabelFor(this.textNomeExecutante);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.textNomeExecutante.setPreferredSize(new Dimension(20, 20));
        c.insets = new Insets(0, 2, 0, 0);
        panelCentro.add((Component)this.textNomeExecutante, c);
        ++c.gridy;
        c.insets = new Insets(0, 2, 0, 0);
        labelAux = new JLabel("C\u00f3digo do executante");
        labelAux.setDisplayedMnemonic('i');
        labelAux.setLabelFor(this.textCodigoExecutante);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.textCodigoExecutante.setPreferredSize(new Dimension(20, 20));
        c.insets = new Insets(0, 2, 0, 0);
        panelCentro.add((Component)this.textCodigoExecutante, c);
        ++c.gridy;
        c.insets = new Insets(0, 2, 0, 0);
        labelAux = new JLabel("CBOS (padr\u00e3o)");
        labelAux.setDisplayedMnemonic('a');
        labelAux.setLabelFor(this.textCbosPadrao);
        panelCentro.add((Component)labelAux, c);
        JPanel panelCbos = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 0;
        gb.insets = new Insets(0, 0, 0, 0);
        this.textCbosPadrao.setPreferredSize(new Dimension(280, 20));
        this.textCbosPadrao.setMinimumSize(new Dimension(280, 20));
        this.textCbosPadrao.setEditable(false);
        panelCbos.add((Component)this.textCbosPadrao, gb);
        ++gb.gridx;
        this.buttonConsultaCBOS.setPreferredSize(new Dimension(25, 20));
        panelCbos.add((Component)this.buttonConsultaCBOS, gb);
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        panelCentro.add((Component)panelCbos, c);
        ++c.gridy;
        c.insets = new Insets(0, 2, 0, 0);
        labelAux = new JLabel("Grau de participa\u00e7\u00e3o do executante");
        labelAux.setDisplayedMnemonic('g');
        labelAux.setLabelFor(this.comboGrauParticipacao);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        panelCentro.add((Component)this.comboGrauParticipacao, c);
        c.gridy = 0;
        c.gridx = 1;
        c.insets = new Insets(0, 10, 0, 2);
        labelAux = new JLabel("Conselho do executante");
        labelAux.setDisplayedMnemonic('o');
        labelAux.setLabelFor(this.comboConselhoExecutante);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.comboConselhoExecutante.setPreferredSize(new Dimension(20, 20));
        this.comboConselhoExecutante.setMinimumSize(new Dimension(20, 20));
        c.insets = new Insets(0, 10, 0, 2);
        panelCentro.add((Component)this.comboConselhoExecutante, c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 2);
        labelAux = new JLabel("UF do executante");
        labelAux.setDisplayedMnemonic('U');
        labelAux.setLabelFor(this.comboEstadoExecutante);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.comboEstadoExecutante.setPreferredSize(new Dimension(20, 20));
        this.comboEstadoExecutante.setMinimumSize(new Dimension(20, 20));
        c.insets = new Insets(0, 10, 0, 2);
        panelCentro.add((Component)this.comboEstadoExecutante, c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 2);
        labelAux = new JLabel("Vers\u00e3o do arquivo");
        labelAux.setDisplayedMnemonic('V');
        labelAux.setLabelFor(this.comboVersao);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 2);
        this.comboVersao.setPreferredSize(new Dimension(20, 20));
        this.comboVersao.setMinimumSize(new Dimension(20, 20));
        panelCentro.add(this.comboVersao, c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 2);
        labelAux = new JLabel("Via de Acesso");
        labelAux.setLabelFor(this.comboViaAcesso);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 2);
        this.comboViaAcesso.setPreferredSize(new Dimension(20, 20));
        this.comboViaAcesso.setMinimumSize(new Dimension(20, 20));
        panelCentro.add((Component)this.comboViaAcesso, c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 2);
        labelAux = new JLabel("Regime atendimento");
        labelAux.setLabelFor(this.comboRegimeAtendimento);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 2);
        this.comboRegimeAtendimento.setPreferredSize(new Dimension(20, 20));
        this.comboRegimeAtendimento.setMinimumSize(new Dimension(20, 20));
        panelCentro.add(this.comboRegimeAtendimento, c);
        ++c.gridy;
        c.gridwidth = 3;
        c.insets = new Insets(0, 10, 0, 2);
        labelAux = new JLabel("Guias por arquivo (m\u00edn = 1, m\u00e1x = 100)");
        labelAux.setDisplayedMnemonic('G');
        labelAux.setLabelFor(this.textLimiteGuiasArquivo);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.textLimiteGuiasArquivo.setPreferredSize(new Dimension(20, 20));
        c.insets = new Insets(0, 10, 0, 2);
        panelCentro.add((Component)this.textLimiteGuiasArquivo, c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 2);
        labelAux = new JLabel("Qtde. m\u00edn. de caracteres da guia (0 = qualquer)");
        labelAux.setDisplayedMnemonic('m');
        labelAux.setLabelFor(this.textTamanhoMinimoGuia);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.textTamanhoMinimoGuia.setPreferredSize(new Dimension(20, 20));
        c.insets = new Insets(0, 10, 0, 2);
        panelCentro.add((Component)this.textTamanhoMinimoGuia, c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 2);
        labelAux = new JLabel("Cart\u00e3o SUS padr\u00e3o (em caso de n\u00e3o informar)");
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.textCartaoSUS.setPreferredSize(new Dimension(20, 20));
        c.insets = new Insets(0, 10, 0, 2);
        panelCentro.add((Component)this.textCartaoSUS, c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 2);
        labelAux = new JLabel("CPF/CNPJ ou C\u00d3DIGO PRESTADOR do m\u00e9dico padr\u00e3o");
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.textoCpfCnpj.setPreferredSize(new Dimension(20, 20));
        c.insets = new Insets(0, 10, 0, 2);
        panelCentro.add((Component)this.textoCpfCnpj, c);
        if (!this.checkEnviarCodigoPrestadorPadrao.isSelected() || !this.checkUtilizarCPFCNPJPadrao.isSelected()) {
            this.textoCpfCnpj.setEditable(false);
        } else {
            this.textoCpfCnpj.setEditable(true);
        }
        c.gridy = 0;
        c.gridx = 3;
        c.gridwidth = 1;
        c.insets = new Insets(0, 10, 0, 2);
        labelAux = new JLabel("Indicador de Acidente");
        labelAux.setDisplayedMnemonic('I');
        labelAux.setLabelFor(this.comboIndicadorAcidente);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.comboIndicadorAcidente.setPreferredSize(new Dimension(20, 20));
        this.comboIndicadorAcidente.setMinimumSize(new Dimension(20, 20));
        c.insets = new Insets(0, 10, 0, 2);
        panelCentro.add((Component)this.comboIndicadorAcidente, c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 2);
        labelAux = new JLabel("Tipo do Atendimento");
        labelAux.setDisplayedMnemonic('T');
        labelAux.setLabelFor(this.comboTipoAtendimento);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.comboTipoAtendimento.setPreferredSize(new Dimension(20, 20));
        this.comboTipoAtendimento.setMinimumSize(new Dimension(20, 20));
        c.insets = new Insets(0, 10, 0, 2);
        panelCentro.add(this.comboTipoAtendimento, c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 2);
        labelAux = new JLabel("Padr\u00e3o do nome do arquivo");
        labelAux.setDisplayedMnemonic('a');
        labelAux.setLabelFor(this.comboNome);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 2);
        this.comboNome.setPreferredSize(new Dimension(20, 20));
        this.comboNome.setMinimumSize(new Dimension(20, 20));
        panelCentro.add((Component)this.comboNome, c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 2);
        labelAux = new JLabel("Qtde. de caracteres da guia (0 = vari\u00e1vel)");
        labelAux.setDisplayedMnemonic('Q');
        labelAux.setLabelFor(this.textTamanhoGuia);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.textTamanhoGuia.setPreferredSize(new Dimension(20, 20));
        c.insets = new Insets(0, 10, 0, 2);
        panelCentro.add((Component)this.textTamanhoGuia, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.insets = new Insets(0, 10, 0, 2);
        labelAux = new JLabel("Codifica\u00e7\u00e3o do arquivo eletr\u00f4nico");
        labelAux.setDisplayedMnemonic('d');
        labelAux.setLabelFor(this.comboCodificacao);
        panelCentro.add((Component)labelAux, c);
        ++c.gridy;
        this.comboCodificacao.setPreferredSize(new Dimension(20, 20));
        this.comboCodificacao.setMinimumSize(new Dimension(20, 20));
        c.insets = new Insets(0, 10, 0, 2);
        panelCentro.add((Component)this.comboCodificacao, c);
        c.gridy = 25;
        c.gridx = 0;
        c.gridwidth = 4;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        GridLayout gl = new GridLayout(15, 2);
        gl.setVgap(0);
        JPanel panelCheck = new JPanel(gl);
        panelCentro.add((Component)panelCheck, c);
        this.checkIgnorarCodigoFilial.setMargin(new Insets(0, 16, 0, 0));
        this.checkGuia.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkGuia);
        this.checkGuiaOperadora.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkGuiaOperadora);
        this.checkIgnorarCodigoFilial.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkIgnorarCodigoFilial);
        this.checkRepetirNumeroGuia.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkRepetirNumeroGuia);
        this.checkCNPJOperadora.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkCNPJOperadora);
        this.checkSolicitarLote.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkSolicitarLote);
        this.checkEnviarCRM.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkEnviarCRM);
        this.checkEnviarCID10SemMascara.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkEnviarCID10SemMascara);
        this.checkIgnorarMilissegundos.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkIgnorarMilissegundos);
        this.checkValorZeroGuiaPrincipal.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkValorZeroGuiaPrincipal);
        this.checkProibirGuiasRepetidas.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkProibirGuiasRepetidas);
        this.checkUtilizarDataColeta.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkUtilizarDataColeta);
        this.checkIgnorarCodOperadoraMedico.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkIgnorarCodOperadoraMedico);
        this.checkUtilizarGuiaAutorizacao.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkUtilizarGuiaAutorizacao);
        this.checkLimparCaracteresGuia.setToolTipText("Remove os caracteres '.,-\\/ da guia");
        this.checkLimparCaracteresGuia.setPreferredSize(new Dimension(20, 20));
        panelCheck.add(this.checkLimparCaracteresGuia);
        this.checkRemoverPontoCBO.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkRemoverPontoCBO);
        this.checkEnviarUmReducaoAcrescimo.setToolTipText("Enviar redu\u00e7\u00e3o de acr\u00e9scimo");
        this.checkEnviarUmReducaoAcrescimo.setPreferredSize(new Dimension(20, 16));
        this.checkNaoUtilizarCNPJPrestador.setToolTipText("N\u00e3o utilizar o CNPJ do Prestador no arquivo");
        this.checkNaoUtilizarCNPJPrestador.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkNaoUtilizarCNPJPrestador);
        this.checkUtilizarCPFCNPJPadrao.setToolTipText("Utilizar CPF/CNPJ padr\u00e3o para o m\u00e9dico solicitante");
        this.checkUtilizarCPFCNPJPadrao.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkUtilizarCPFCNPJPadrao);
        this.checkNaoUtilizarGrauParticipacao.setToolTipText("N\u00e3o utilizar grau de participa\u00e7\u00e3o do executante");
        this.checkNaoUtilizarGrauParticipacao.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkNaoUtilizarGrauParticipacao);
        this.checkAssinarArquivoEletronico.setToolTipText("Incluir a assinatura digital");
        this.checkAssinarArquivoEletronico.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkAssinarArquivoEletronico);
        this.checkNaoInformarViaAcesso.setToolTipText("N\u00e3o informar via de acesso");
        this.checkNaoInformarViaAcesso.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkNaoInformarViaAcesso);
        this.checkEnviarCaracteresMatricula.setToolTipText("Enviar caracteres na matr\u00edcula");
        this.checkEnviarCaracteresMatricula.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkEnviarCaracteresMatricula);
        this.checkNaoInformarTecnicaUsada.setToolTipText("N\u00e3o informar t\u00e9cnica utilizada");
        this.checkNaoInformarTecnicaUsada.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkNaoInformarTecnicaUsada);
        this.checkEnviarIndicacaoClinica.setToolTipText("Enviar indica\u00e7\u00e3o cl\u00ednica");
        this.checkEnviarIndicacaoClinica.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkEnviarIndicacaoClinica);
        this.checkEnviarHorarioProcedimentos.setToolTipText("Enviar tag hor\u00e1rio nos procedimentos");
        this.checkEnviarHorarioProcedimentos.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkEnviarHorarioProcedimentos);
        this.checkNaoEnviarCpfCnpjPrestador.setToolTipText("N\u00e3o enviar CPF/CNPJ/Prestador para o m\u00e9dico solicitante");
        this.checkNaoEnviarCpfCnpjPrestador.setPreferredSize(new Dimension(20, 16));
        this.checkNaoEnviarCpfCnpjPrestador.setVisible(false);
        this.checkEnviarCodigoPrestadorPadrao.setToolTipText("Enviar c\u00f3digo prestador padr\u00e3o para o m\u00e9dico solicitante");
        this.checkEnviarCodigoPrestadorPadrao.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkEnviarCodigoPrestadorPadrao);
        this.checkEnviarSaudeOcupacional.setToolTipText("Enviar Sa\u00fade ocupacional");
        this.checkEnviarSaudeOcupacional.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkEnviarSaudeOcupacional);
        this.checkEnviarIdentificadorDeCoberturaEspecial.setToolTipText("Enviar ID de cobertura especial");
        this.checkEnviarIdentificadorDeCoberturaEspecial.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkEnviarIdentificadorDeCoberturaEspecial);
        this.checkIgnorarCodigoExameAgrupamento.setToolTipText("Ignorar c\u00f3digo do exame no agrupamento de procedimentos");
        this.checkIgnorarCodigoExameAgrupamento.setPreferredSize(new Dimension(20, 16));
        panelCheck.add(this.checkIgnorarCodigoExameAgrupamento);
        VersaoTiss selecionado = (VersaoTiss)((Object)this.comboVersao.getSelectedItem());
        boolean isVersaoMaior30300 = selecionado.isVersaoMaior(VersaoTiss.V_3_03_00);
        this.checkAssinarArquivoEletronico.setEnabled(isVersaoMaior30300);
        boolean isVersaoMaior30050 = selecionado.isVersaoMaior(VersaoTiss.V_3_05_00);
        this.checkIgnorarCodigoExameAgrupamento.setEnabled(isVersaoMaior30050);
        this.checkUtilizarCPFCNPJPadrao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigurarTiss.this.checkUtilizarCPFCNPJPadrao.isSelected()) {
                    ConfigurarTiss.this.checkNaoEnviarCpfCnpjPrestador.setSelected(false);
                    ConfigurarTiss.this.textoCpfCnpj.setEditable(true);
                    ConfigurarTiss.this.validate();
                    ConfigurarTiss.this.repaint();
                } else {
                    ConfigurarTiss.this.textoCpfCnpj.setEditable(false);
                    ConfigurarTiss.this.validate();
                    ConfigurarTiss.this.repaint();
                }
            }
        });
        this.checkNaoEnviarCpfCnpjPrestador.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigurarTiss.this.checkNaoEnviarCpfCnpjPrestador.isSelected()) {
                    ConfigurarTiss.this.checkUtilizarCPFCNPJPadrao.setSelected(false);
                }
            }
        });
        this.checkEnviarCodigoPrestadorPadrao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurarTiss.this.verificarCheckCodigoPadraoSeleciondo();
            }
        });
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.add(this.buttonSalvar);
        panelBotoes.add(this.buttonCancelar);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        panelCentro.add((Component)panelBotoes, c);
        Funcoes.montaEnter((JComponent)panelCentro);
        Funcoes.montaEnter((JComponent)panelBotoes);
        this.checkRepetirNumeroGuia.addActionListener(this);
        this.checkGuiaOperadora.addActionListener(this);
        this.checkIgnorarCodOperadoraMedico.addActionListener(this);
        this.checkEnviarCRM.addActionListener(this);
        this.checkNaoUtilizarCNPJPrestador.addActionListener(this);
        this.comboRegimeAtendimento.setEnabled(false);
        this.comboVersao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurarTiss.this.alterarOpcoesConformeVersaoSelecionada(e);
            }
        });
    }

    private void verificarCheckCodigoPadraoSeleciondo() {
        if (this.checkEnviarCodigoPrestadorPadrao.isSelected()) {
            this.checkUtilizarCPFCNPJPadrao.setSelected(false);
            this.checkUtilizarCPFCNPJPadrao.setEnabled(false);
            this.checkEnviarCRM.setSelected(false);
            this.checkEnviarCRM.setEnabled(false);
            this.textoCpfCnpj.setEditable(true);
            this.validate();
            this.repaint();
        } else {
            this.checkUtilizarCPFCNPJPadrao.setEnabled(true);
            this.checkEnviarCRM.setEnabled(true);
            this.textoCpfCnpj.setEditable(false);
            this.validate();
            this.repaint();
        }
    }

    private void alterarOpcoesConformeVersaoSelecionada(ActionEvent e) {
        TipoAtendimento[] atendimentosPadrao;
        this.comboRegimeAtendimento.setEnabled(false);
        this.checkEnviarSaudeOcupacional.setEnabled(false);
        this.checkEnviarIdentificadorDeCoberturaEspecial.setEnabled(false);
        this.checkNaoEnviarCpfCnpjPrestador.setVisible(false);
        VersaoTiss versaoTissSelecionada = (VersaoTiss)((Object)this.comboVersao.getSelectedItem());
        if (!versaoTissSelecionada.isVersaoMaior(VersaoTiss.V_3_03_00)) {
            this.checkRemoverPontoCBO.setSelected(false);
            this.checkRemoverPontoCBO.setEnabled(false);
        } else {
            this.checkRemoverPontoCBO.setEnabled(true);
        }
        this.comboGrauParticipacao.setEnabled(versaoTissSelecionada.isVersaoMaior(VersaoTiss.V_3_01_00));
        if (versaoTissSelecionada.isVersaoMaior(VersaoTiss.V_3_02_00)) {
            this.checkUtilizarCPFCNPJPadrao.setEnabled(true);
            this.textoCpfCnpj.setEnabled(true);
        } else {
            this.checkUtilizarCPFCNPJPadrao.setSelected(false);
            this.checkUtilizarCPFCNPJPadrao.setEnabled(false);
            this.textoCpfCnpj.setEnabled(false);
        }
        if (versaoTissSelecionada.isVersaoMaior(VersaoTiss.V_3_03_00)) {
            this.checkAssinarArquivoEletronico.setEnabled(true);
        } else {
            this.checkAssinarArquivoEletronico.setEnabled(false);
            this.checkAssinarArquivoEletronico.setSelected(false);
        }
        if (versaoTissSelecionada.isVersaoMaior(VersaoTiss.V_3_05_00)) {
            this.checkNaoEnviarCpfCnpjPrestador.setVisible(true);
            this.checkNaoInformarTecnicaUsada.setEnabled(true);
            this.checkNaoInformarViaAcesso.setEnabled(true);
            this.comboViaAcesso.setEnabled(true);
            this.checkEnviarCodigoPrestadorPadrao.setEnabled(true);
            this.checkEnviarHorarioProcedimentos.setEnabled(true);
            this.checkIgnorarCodigoExameAgrupamento.setEnabled(true);
            if (this.checkEnviarCodigoPrestadorPadrao.isSelected()) {
                this.checkUtilizarCPFCNPJPadrao.setSelected(false);
                this.checkUtilizarCPFCNPJPadrao.setEnabled(false);
                this.checkEnviarCRM.setSelected(false);
                this.checkEnviarCRM.setEnabled(false);
                this.textoCpfCnpj.setEditable(true);
                this.validate();
                this.repaint();
            }
        } else {
            this.checkNaoEnviarCpfCnpjPrestador.setVisible(false);
            this.checkNaoInformarTecnicaUsada.setEnabled(false);
            this.checkNaoInformarViaAcesso.setEnabled(false);
            this.comboViaAcesso.setEnabled(false);
            this.checkEnviarHorarioProcedimentos.setEnabled(false);
            this.checkEnviarCodigoPrestadorPadrao.setEnabled(false);
            this.checkEnviarCodigoPrestadorPadrao.setSelected(false);
            this.checkIgnorarCodigoExameAgrupamento.setEnabled(false);
            this.checkIgnorarCodigoExameAgrupamento.setSelected(false);
            this.checkEnviarCRM.setEnabled(true);
            if (versaoTissSelecionada.isVersaoMaior(VersaoTiss.V_3_02_00)) {
                this.checkUtilizarCPFCNPJPadrao.setEnabled(true);
            } else {
                this.checkUtilizarCPFCNPJPadrao.setSelected(false);
                this.checkUtilizarCPFCNPJPadrao.setEnabled(false);
            }
        }
        TipoAtendimento tipoSelecionado = (TipoAtendimento)((Object)this.comboTipoAtendimento.getSelectedItem());
        this.comboTipoAtendimento.removeAllItems();
        for (TipoAtendimento ta : atendimentosPadrao = TipoAtendimento.getAtendimentosPorVersaoTiss(null)) {
            this.comboTipoAtendimento.addItem(ta);
        }
        if (versaoTissSelecionada.isVersaoMaior(VersaoTiss.V_4_00_00)) {
            TipoAtendimento[] atendimentosPorVersao;
            this.comboRegimeAtendimento.setEnabled(true);
            this.checkEnviarSaudeOcupacional.setEnabled(true);
            this.checkEnviarIdentificadorDeCoberturaEspecial.setEnabled(true);
            this.comboTipoAtendimento.removeAllItems();
            for (TipoAtendimento ta : atendimentosPorVersao = TipoAtendimento.getAtendimentosPorVersaoTiss(versaoTissSelecionada)) {
                this.comboTipoAtendimento.addItem(ta);
            }
            TipoAtendimento selecionadoV4 = tipoSelecionado.getVersaoTiss().getNumero() >= VersaoTiss.V_4_00_00.getNumero() ? tipoSelecionado : TipoAtendimento.EXAMES_AMBULATORIAL;
            this.comboTipoAtendimento.setSelectedItem((Object)selecionadoV4);
        } else {
            this.comboTipoAtendimento.setSelectedItem((Object)tipoSelecionado);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean bl = this.ok = e.getSource() == this.buttonSalvar;
        if (this.ok) {
            if (Funcoes.textoVazio(this.textCNPJPrestador.getText()) && !ValidaDoc.checkDoc(this.textCNPJPrestador.getText(), 7)) {
                Funcoes.mensagem(this, "Campo CNPJ do Prestador inv\u00e1lido", 2);
                ScreenUtil.requisitarFoco(this.textCNPJPrestador);
                return;
            }
            if (Funcoes.textoVazio(this.textCodigoPrestador.getText()) && this.comboVersao.getSelectedItem().equals((Object)VersaoTiss.V_3_00_01)) {
                Funcoes.mensagem(this, "Campo C\u00f3digo do Prestador inv\u00e1lido", 2);
                ScreenUtil.requisitarFoco(this.textCodigoPrestador);
                return;
            }
            if (Funcoes.textoVazio(this.textLimiteGuiasArquivo) || !Funcoes.isNumeric(this.textLimiteGuiasArquivo.getText())) {
                Funcoes.mensagem(this, "O limite de guias por arquivo deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textLimiteGuiasArquivo);
                return;
            }
            Integer limite = Integer.parseInt(this.textLimiteGuiasArquivo.getText());
            if (limite <= 0 || limite > 100) {
                Funcoes.mensagem(this, "O limite de guias por arquivo deve estar entre 1 e 100.", 2);
                ScreenUtil.requisitarFoco(this.textLimiteGuiasArquivo);
                return;
            }
            if (this.comboVersao.getSelectedItem().equals((Object)VersaoTiss.V_3_00_01) && this.checkIgnorarCodOperadoraMedico.isSelected()) {
                Funcoes.mensagem(this, "A vers\u00e3o 3.00.01 n\u00e3o \u00e9 compat\u00edvel com a configura\u00e7\u00e3o de \"Ignorar c\u00f3digo do m\u00e9dico na operadora e enviar CRM\"", 2);
                return;
            }
            if (this.checkUtilizarCPFCNPJPadrao.isSelected() && !this.textoCpfCnpj.getText().isEmpty() && this.textoCpfCnpj.getText().length() != 11 && this.textoCpfCnpj.getText().length() != 14) {
                Funcoes.mensagem(this, "Campo CPF/CNPJ inv\u00e1lido", 1);
                this.textoCpfCnpj.selectAll();
                this.textoCpfCnpj.grabFocus();
                return;
            }
            if (this.checkEnviarCodigoPrestadorPadrao.isSelected() && Funcoes.textoVazio(this.textoCpfCnpj.getText())) {
                Funcoes.mensagem(this, "Informe o campo CPF/CNPJ ou C\u00d3DIGO PRESTADOR do m\u00e9dico padr\u00e3o.", 1);
                this.textoCpfCnpj.selectAll();
                this.textoCpfCnpj.grabFocus();
                return;
            }
            if (this.checkEnviarCodigoPrestadorPadrao.isSelected() && this.textoCpfCnpj.getText().length() != 14) {
                Funcoes.mensagem(this, "Campo C\u00d3DIGO PRESTADOR do m\u00e9dico padr\u00e3o deve conter 14 d\u00edgitos.", 1);
                this.textoCpfCnpj.selectAll();
                this.textoCpfCnpj.grabFocus();
                return;
            }
            this.setVisible(false);
        } else if (e.getSource() == this.checkSolicitarLote) {
            this.textSequencial.setEnabled(!this.checkSolicitarLote.isSelected());
        } else if (e.getSource() == this.checkGuiaOperadora) {
            if (!this.checkGuiaOperadora.isSelected()) {
                this.checkRepetirNumeroGuia.setSelected(false);
            }
        } else if (e.getSource() == this.checkRepetirNumeroGuia) {
            if (this.checkRepetirNumeroGuia.isSelected() && !this.checkGuiaOperadora.isSelected()) {
                this.checkGuiaOperadora.setSelected(true);
            }
        } else if (e.getSource() == this.checkIgnorarCodOperadoraMedico) {
            if (this.checkEnviarCRM.isSelected()) {
                Funcoes.mensagem(this, "A op\u00e7\u00e3o 'Utilizar CRM de m\u00e9dico como codigoOperadora' ser\u00e1 desativada pois n\u00e3o enviar\u00e1 a tag codigoOperadora.", 2);
                this.checkEnviarCRM.setSelected(false);
            }
        } else if (e.getSource() == this.checkEnviarCRM) {
            if (this.checkIgnorarCodOperadoraMedico.isSelected()) {
                Funcoes.mensagem(this, "A op\u00e7\u00e3o 'Ignorar c\u00f3digo do m\u00e9dico na operadora e enviar CRM' ser\u00e1 desativada para que tag codigoOperadora seja enviada.", 2);
                this.checkIgnorarCodOperadoraMedico.setSelected(false);
            }
        } else if (e.getSource() == this.checkNaoUtilizarCNPJPrestador) {
            if (this.checkNaoUtilizarCNPJPrestador.isSelected() && Funcoes.textoVazio(this.textCodigoPrestador.getText())) {
                Funcoes.mensagem(this, "Campo C\u00f3digo do Prestador inv\u00e1lido", 2);
                this.checkNaoUtilizarCNPJPrestador.setSelected(false);
                ScreenUtil.requisitarFoco(this.textCodigoPrestador);
                return;
            }
        } else if (e.getSource() == this.buttonConsultaCBOS) {
            this.filtraCBOS();
        } else {
            this.setVisible(false);
        }
    }

    public boolean ok() {
        return this.ok;
    }

    private void filtraCBOS() {
        DialogoFiltro item = new DialogoFiltro(Laboratorio.getInstancia(), "CBOS", true);
        CBOS.CBO[] cbos = CBOS.getCBOS((VersaoTiss)((Object)this.comboVersao.getSelectedItem()));
        Object[] array = new String[cbos.length];
        for (int i = 0; i < cbos.length; ++i) {
            array[i] = cbos[i].descricao;
        }
        if (this.map.isEmpty() && !Funcoes.textoVazio(this.textCbosPadrao)) {
            this.map.put(new Integer(0), new String[]{this.textCbosPadrao.getText()});
        }
        item.setDados(this.map, array, new String[]{"descricao", "codigo"}, new String[]{"Descri\u00e7\u00e3o", "#"}, new int[]{0, 50});
        item.setVisible(true);
        if (item.ok()) {
            this.textCbosPadrao.grabFocus();
            String[] sel = item.getSelecionados(0);
            if (sel == null || sel.length == 0) {
                this.map.clear();
            } else {
                this.map.put(new Integer(0), sel);
            }
            if (sel != null && sel.length > 1) {
                Funcoes.mensagem(this, "Selecione apenas um CBOS padr\u00e3o.", 2);
                this.filtraCBOS();
            } else if (sel == null || sel.length == 0) {
                this.textCbosPadrao.clear();
            } else {
                this.textCbosPadrao.setText(sel[0]);
            }
        }
    }

    public void setXML(String xml) {
        if (xml != null) {
            String cpfCnpjPadrao;
            String temp = StringUtil.getValor(xml, CODIGO_PRESTADOR);
            if (ValidaDoc.checkDoc(temp, 7) && (StringUtil.getValor(xml, CNPJ_PRESTADOR) == null || Funcoes.textoVazio(StringUtil.getValor(xml, CNPJ_PRESTADOR)))) {
                this.textCNPJPrestador.setText(temp);
            }
            this.textCodigoPrestador.setText(temp);
            temp = StringUtil.getValor(xml, CNPJ_PRESTADOR);
            if (!Funcoes.textoVazio(temp)) {
                this.textCNPJPrestador.setText(temp);
            }
            this.sequencia = StringUtil.getValor(xml, SEQUENCIAL_LOTE);
            if (!Funcoes.isNumeric(this.sequencia)) {
                this.sequencia = "0";
            }
            this.txtRegistroANS.setText(StringUtil.getValor(xml, REGISTRO_ANS));
            this.txtConvenioRegistroANS.setText(StringUtil.getValor(xml, CONVENIO_REGISTRO_ANS));
            this.textSequencial.setText(StringUtil.getValor(xml, SEQUENCIAL_LOTE));
            this.checkGuia.setSelected(StringUtil.getValor(xml, GUIA_AUTOMATICA).toString().equalsIgnoreCase("1"));
            if (!this.checkGuia.isSelected()) {
                this.checkIgnorarCodigoFilial.setSelected(false);
                this.checkIgnorarCodigoFilial.setEnabled(false);
            }
            this.checkGuiaOperadora.setSelected(StringUtil.getBoolean(xml, GUIA_OPERADORA));
            this.checkRepetirNumeroGuia.setSelected(StringUtil.getBoolean(xml, REPETIR_GUIA_OPERADORA));
            this.checkValorZeroGuiaPrincipal.setSelected(StringUtil.getBoolean(xml, VALOR_ZERO_GUIA_PRINCIPAL));
            this.checkCNPJOperadora.setSelected(StringUtil.getBoolean(xml, CNPJ_OPERADORA));
            this.checkSolicitarLote.setSelected(StringUtil.getBoolean(xml, SOLICITAR_LOTE));
            this.textNomeExecutante.setText(StringUtil.getValor(xml, NOME_EXECUTANTE));
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, CONSELHO_EXECUTANTE))) {
                this.comboConselhoExecutante.setSelectedItem(StringUtil.getValor(xml, CONSELHO_EXECUTANTE));
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, UF_EXECUTANTE))) {
                this.comboEstadoExecutante.setSelectedItem(StringUtil.getValor(xml, UF_EXECUTANTE));
            }
            this.textCodigoExecutante.setText(StringUtil.getValor(xml, CODIGO_EXECUTANTE));
            this.textCbosPadrao.setText(StringUtil.getValor(xml, CBOS_PADRAO));
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, "versaoArquivo"))) {
                VersaoTiss versao = VersaoTiss.getVersaoPorDescricao(StringUtil.getValor(xml, "versaoArquivo"));
                this.comboVersao.setSelectedItem((Object)versao);
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, NOME_ARQUIVO))) {
                this.comboNome.setSelectedItem(StringUtil.getValor(xml, NOME_ARQUIVO));
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, CODIFICACAO_ARQUIVO))) {
                this.comboCodificacao.setSelectedItem((Object)FaturamentoEletronico.CODIFICACAO.getCodificacao(StringUtil.getValor(xml, CODIFICACAO_ARQUIVO)));
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, INDICADOR_ACIDENTE))) {
                this.comboIndicadorAcidente.setSelectedItem(StringUtil.getValor(xml, INDICADOR_ACIDENTE));
            } else {
                this.comboIndicadorAcidente.setSelectedIndex(3);
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, TIPO_ATENDIMENTO))) {
                this.comboTipoAtendimento.setSelectedItem((Object)TipoAtendimento.getTipoAtendimentoPorCodigoEDescricao(StringUtil.getValor(xml, TIPO_ATENDIMENTO)));
            } else {
                this.comboTipoAtendimento.setSelectedIndex(4);
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, VIA_DE_ACESSO))) {
                this.comboViaAcesso.setSelectedItem((Object)ViaAcessoEnum.getViaAcessoEnum(StringUtil.getValor(xml, VIA_DE_ACESSO)));
            }
            this.checkEnviarCID10SemMascara.setSelected(StringUtil.getBoolean(xml, ENVIAR_CID10_SEM_MASCARA));
            this.checkEnviarCRM.setSelected(StringUtil.getBoolean(xml, ENVIAR_CRM));
            this.checkIgnorarCodigoFilial.setSelected(StringUtil.getBoolean(xml, IGNORAR_CODIGO_FILIAL));
            this.checkIgnorarMilissegundos.setSelected(StringUtil.getBoolean(xml, IGNORAR_MILISSEGUNDOS));
            this.checkProibirGuiasRepetidas.setSelected(StringUtil.getBoolean(xml, PROIBIR_GUIA_REPETIDA));
            this.checkUtilizarDataColeta.setSelected(StringUtil.getBoolean(xml, UTILIZAR_DATA_COLETA));
            this.checkIgnorarCodOperadoraMedico.setSelected(StringUtil.getBoolean(xml, IGNORAR_CODIGO_OPERADORA_MEDICO));
            this.checkUtilizarGuiaAutorizacao.setSelected(StringUtil.getBoolean(xml, UTILIZAR_GUIA_COMO_AUTORIZACAO));
            this.checkLimparCaracteresGuia.setSelected(StringUtil.getBoolean(xml, LIMPAR_CARACTERES_DA_GUIA));
            this.checkNaoUtilizarCNPJPrestador.setSelected(StringUtil.getBoolean(xml, NAO_UTILIZAR_CNPJ_PRESTADOR));
            this.checkEnviarUmReducaoAcrescimo.setSelected(StringUtil.getBoolean(xml, ENVIAR_REDUCAO_ACRESCIMO));
            this.checkRemoverPontoCBO.setSelected(StringUtil.getBoolean(xml, REMOVER_PONTOS_CBOS));
            this.checkNaoUtilizarGrauParticipacao.setSelected(StringUtil.getBoolean(xml, NAO_UTILIZAR_GRAU_PARTICIPACAO));
            this.checkEnviarCaracteresMatricula.setSelected(StringUtil.getBoolean(xml, ENVIAR_CARACTERES_MATRICULA));
            this.checkNaoInformarTecnicaUsada.setSelected(StringUtil.getBoolean(xml, NAO_INFORMAR_TECNICA_UTILIZADA));
            this.checkNaoInformarViaAcesso.setSelected(StringUtil.getBoolean(xml, NAO_INFORMAR_VIA_ACESSO));
            this.checkEnviarIndicacaoClinica.setSelected(StringUtil.getBoolean(xml, ENVIAR_INDICACAO_CLINICA));
            this.checkEnviarCodigoPrestadorPadrao.setSelected(StringUtil.getBoolean(xml, ENVIAR_CODIGO_PRESTADOR_PADRAO_PARA_MEDICO_SOLICITANTE));
            this.checkEnviarHorarioProcedimentos.setSelected(StringUtil.getBoolean(xml, ENVIAR_HORARIO_PROCEDIMENTOS));
            this.verificarCheckCodigoPadraoSeleciondo();
            this.textCartaoSUS.setText(StringUtil.getValor(xml, CARTAO_SUS_PADRAO));
            this.checkAssinarArquivoEletronico.setSelected(StringUtil.getBoolean(xml, ASSINAR_ARQUIVO_ELETRONICO));
            this.checkUtilizarCPFCNPJPadrao.setSelected(StringUtil.getBoolean(xml, UTILIZAR_CPF_CNPJ_PADRAO));
            this.checkIgnorarCodigoExameAgrupamento.setSelected(StringUtil.getBoolean(xml, IGNORAR_CODIGO_EXAME_AGRUPAMENTO_PROCEDIMENTOS));
            if (this.checkUtilizarCPFCNPJPadrao.isSelected() || this.checkEnviarCodigoPrestadorPadrao.isSelected()) {
                this.textoCpfCnpj.setEditable(true);
            }
            if ((cpfCnpjPadrao = StringUtil.getValor(xml, CPF_CNPJ)) != null && !cpfCnpjPadrao.isEmpty()) {
                this.textoCpfCnpj.setText(cpfCnpjPadrao);
            }
            if (StringUtil.getBoolean(xml, UTILIZAR_SADT_INTERNADO)) {
                this.comboTipoAtendimento.setSelectedItem((Object)TipoAtendimento.INTERNACAO);
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, TAMANHO_GUIA))) {
                this.textTamanhoGuia.setText(StringUtil.getValor(xml, TAMANHO_GUIA));
            } else {
                this.textTamanhoGuia.setText("0");
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, LIMITE_GUIAS_ARQUIVO))) {
                this.textLimiteGuiasArquivo.setText(StringUtil.getValor(xml, LIMITE_GUIAS_ARQUIVO));
            } else {
                this.textLimiteGuiasArquivo.setText("100");
            }
            if (Funcoes.textoVazio(StringUtil.getValor(xml, TAMANHO_MINIMO_GUIA))) {
                this.textTamanhoMinimoGuia.setText("0");
            } else {
                this.textTamanhoMinimoGuia.setText(StringUtil.getValor(xml, TAMANHO_MINIMO_GUIA));
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, GRAU_PARTICIPACAO_EXECUTANTE))) {
                GrauParticipacao grauParticipacao = GrauParticipacao.getGrauParticipacao(StringUtil.getValor(xml, GRAU_PARTICIPACAO_EXECUTANTE));
                if (grauParticipacao != null) {
                    this.comboGrauParticipacao.setSelectedItem((Object)grauParticipacao);
                } else {
                    this.comboIndicadorAcidente.setSelectedIndex(0);
                }
            } else {
                this.comboIndicadorAcidente.setSelectedIndex(0);
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, REGIME_ATENDIMENTO))) {
                this.comboRegimeAtendimento.setSelectedItem((Object)RegimeAtendimento.getRegimeAtendimentoPorCodigoEDescricao(StringUtil.getValor(xml, REGIME_ATENDIMENTO)));
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, ENVIAR_SAUDE_OCUPACIONAL))) {
                this.checkEnviarSaudeOcupacional.setSelected(StringUtil.getBoolean(xml, ENVIAR_SAUDE_OCUPACIONAL));
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, ENVIAR_ID_COBERTURA_ESPECIAL))) {
                this.checkEnviarIdentificadorDeCoberturaEspecial.setSelected(StringUtil.getBoolean(xml, ENVIAR_ID_COBERTURA_ESPECIAL));
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, NAO_ENVIAR_CPF_CNPJ_PRESTADOR_MEDICO_SOLICITANTE))) {
                this.checkNaoEnviarCpfCnpjPrestador.setSelected(StringUtil.getBoolean(xml, NAO_ENVIAR_CPF_CNPJ_PRESTADOR_MEDICO_SOLICITANTE));
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, ENVIAR_CODIGO_PRESTADOR_PADRAO_PARA_MEDICO_SOLICITANTE))) {
                this.checkEnviarCodigoPrestadorPadrao.setSelected(StringUtil.getBoolean(xml, ENVIAR_CODIGO_PRESTADOR_PADRAO_PARA_MEDICO_SOLICITANTE));
            }
        }
    }

    public String getXML() {
        XMLStringBuilder buf = new XMLStringBuilder();
        buf.abrir("faturamentoEletronico");
        buf.escrever("protocolo", Tiss.getNomeProtocolo());
        buf.escrever(CNPJ_PRESTADOR, this.textCNPJPrestador.getText());
        buf.escrever(CODIGO_PRESTADOR, this.textCodigoPrestador.getText());
        if (Funcoes.isNumeric(this.textSequencial.getText()) && Funcoes.isNumeric(this.sequencia) && Integer.parseInt(this.sequencia) < Integer.parseInt(this.textSequencial.getText())) {
            this.sequencia = this.textSequencial.getText();
        }
        buf.escrever(SEQUENCIAL_LOTE, this.sequencia);
        buf.escrever(REGISTRO_ANS, this.txtRegistroANS.getText());
        buf.escrever(CONVENIO_REGISTRO_ANS, this.txtConvenioRegistroANS.getText());
        buf.escrever(NOME_ARQUIVO, this.comboNome.getSelectedItem().toString());
        buf.escrever(GUIA_AUTOMATICA, this.checkGuia.isSelected() ? "1" : "0");
        buf.escrever(GUIA_OPERADORA, this.checkGuiaOperadora.isSelected() ? "True" : "False");
        buf.escrever(REPETIR_GUIA_OPERADORA, this.checkRepetirNumeroGuia.isSelected() ? "True" : "False");
        buf.escrever(VALOR_ZERO_GUIA_PRINCIPAL, this.checkValorZeroGuiaPrincipal.isSelected() ? "True" : "False");
        buf.escrever(CNPJ_OPERADORA, this.checkCNPJOperadora.isSelected() ? "True" : "False");
        buf.escrever(SOLICITAR_LOTE, this.checkSolicitarLote.isSelected() ? "True" : "False");
        VersaoTiss versao = (VersaoTiss)((Object)this.comboVersao.getSelectedItem());
        buf.escrever("versaoArquivo", versao.getDescricao());
        buf.escrever(UF_EXECUTANTE, this.comboEstadoExecutante.getSelectedItem().toString());
        buf.escrever(CONSELHO_EXECUTANTE, this.comboConselhoExecutante.getSelectedItem().toString());
        buf.escrever(INDICADOR_ACIDENTE, this.comboIndicadorAcidente.getSelectedItem().toString());
        buf.escrever(TIPO_ATENDIMENTO, this.comboTipoAtendimento.getSelectedItem().toString());
        buf.escrever(NOME_EXECUTANTE, this.textNomeExecutante.getText());
        buf.escrever(CODIGO_EXECUTANTE, this.textCodigoExecutante.getText());
        buf.escrever(TAMANHO_GUIA, Funcoes.textoVazio(this.textTamanhoGuia.getText()) ? "0" : this.textTamanhoGuia.getText());
        buf.escrever(ENVIAR_CID10_SEM_MASCARA, this.checkEnviarCID10SemMascara.isSelected() ? "True" : "False");
        buf.escrever(ENVIAR_CRM, this.checkEnviarCRM.isSelected() ? "True" : "False");
        buf.escrever(IGNORAR_CODIGO_FILIAL, this.checkIgnorarCodigoFilial.isSelected() ? "True" : "False");
        buf.escrever(IGNORAR_MILISSEGUNDOS, this.checkIgnorarMilissegundos.isSelected() ? "True" : "False");
        buf.escrever(CODIFICACAO_ARQUIVO, this.comboCodificacao.getSelectedItem().toString());
        buf.escrever(LIMITE_GUIAS_ARQUIVO, Funcoes.textoVazio(this.textLimiteGuiasArquivo.getText()) ? "100" : this.textLimiteGuiasArquivo.getText());
        buf.escrever(PROIBIR_GUIA_REPETIDA, this.checkProibirGuiasRepetidas.isSelected() ? "True" : "False");
        buf.escrever(TAMANHO_MINIMO_GUIA, Funcoes.textoVazio(this.textTamanhoMinimoGuia) ? "0" : this.textTamanhoMinimoGuia.getText());
        buf.escrever(UTILIZAR_DATA_COLETA, this.checkUtilizarDataColeta.isSelected() ? "True" : "False");
        buf.escrever(IGNORAR_CODIGO_OPERADORA_MEDICO, this.checkIgnorarCodOperadoraMedico.isSelected() ? "True" : "False");
        buf.escrever(UTILIZAR_GUIA_COMO_AUTORIZACAO, this.checkUtilizarGuiaAutorizacao.isSelected() ? "True" : "False");
        buf.escrever(LIMPAR_CARACTERES_DA_GUIA, this.checkLimparCaracteresGuia.isSelected() ? "True" : "False");
        buf.escrever(NAO_UTILIZAR_CNPJ_PRESTADOR, this.checkNaoUtilizarCNPJPrestador.isSelected() ? "True" : "False");
        buf.escrever(ENVIAR_REDUCAO_ACRESCIMO, this.checkEnviarUmReducaoAcrescimo.isSelected() ? "True" : "False");
        buf.escrever(REMOVER_PONTOS_CBOS, this.checkRemoverPontoCBO.isSelected() ? "True" : "False");
        buf.escrever(CBOS_PADRAO, this.textCbosPadrao.getText());
        buf.escrever(CARTAO_SUS_PADRAO, this.textCartaoSUS.getText());
        buf.escrever(UTILIZAR_SADT_INTERNADO, "False");
        buf.escrever(GRAU_PARTICIPACAO_EXECUTANTE, ((GrauParticipacao)((Object)this.comboGrauParticipacao.getSelectedItem())).getCodigo());
        buf.escrever(UTILIZAR_CPF_CNPJ_PADRAO, this.checkUtilizarCPFCNPJPadrao.isSelected() ? "True" : "False");
        buf.escrever(CPF_CNPJ, this.textoCpfCnpj.getText());
        buf.escrever(NAO_UTILIZAR_GRAU_PARTICIPACAO, this.checkNaoUtilizarGrauParticipacao.isSelected() ? "True" : "False");
        buf.escrever(ASSINAR_ARQUIVO_ELETRONICO, this.checkAssinarArquivoEletronico.isSelected() ? "True" : "False");
        buf.escrever(ENVIAR_CARACTERES_MATRICULA, this.checkEnviarCaracteresMatricula.isSelected() ? "True" : "False");
        buf.escrever(ENVIAR_INDICACAO_CLINICA, this.checkEnviarIndicacaoClinica.isSelected() ? "True" : "False");
        VersaoTiss versaoSelecionada = (VersaoTiss)((Object)this.comboVersao.getSelectedItem());
        if (versaoSelecionada.isVersaoMaior(VersaoTiss.V_3_05_00)) {
            buf.escrever(VIA_DE_ACESSO, ((ViaAcessoEnum)((Object)this.comboViaAcesso.getSelectedItem())).getCodigo());
            buf.escrever(NAO_INFORMAR_TECNICA_UTILIZADA, this.checkNaoInformarTecnicaUsada.isSelected() ? "True" : "False");
            buf.escrever(NAO_INFORMAR_VIA_ACESSO, this.checkNaoInformarViaAcesso.isSelected() ? "True" : "False");
            buf.escrever(NAO_ENVIAR_CPF_CNPJ_PRESTADOR_MEDICO_SOLICITANTE, this.checkNaoEnviarCpfCnpjPrestador.isSelected() ? "True" : "False");
            buf.escrever(ENVIAR_CODIGO_PRESTADOR_PADRAO_PARA_MEDICO_SOLICITANTE, this.checkEnviarCodigoPrestadorPadrao.isSelected() ? "True" : "False");
            buf.escrever(ENVIAR_HORARIO_PROCEDIMENTOS, this.checkEnviarHorarioProcedimentos.isSelected() ? "True" : "False");
            buf.escrever(IGNORAR_CODIGO_EXAME_AGRUPAMENTO_PROCEDIMENTOS, this.checkIgnorarCodigoExameAgrupamento.isSelected() ? "True" : "False");
        }
        if (versaoSelecionada.isVersaoMaior(VersaoTiss.V_4_00_00)) {
            buf.escrever(REGIME_ATENDIMENTO, this.comboRegimeAtendimento.getSelectedItem().toString());
            buf.escrever(ENVIAR_SAUDE_OCUPACIONAL, this.checkEnviarSaudeOcupacional.isSelected() ? "True" : "False");
            buf.escrever(ENVIAR_ID_COBERTURA_ESPECIAL, this.checkEnviarIdentificadorDeCoberturaEspecial.isSelected() ? "True" : "False");
        }
        try {
            buf.fechar("faturamentoEletronico");
        }
        catch (XMLStringBuilderException e) {
            e.printStackTrace();
        }
        return buf.toString();
    }
}

