/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico.solicitacaoprocedimento.ituverava;

import br.gov.ans.www.padroes.tiss.schemas.ituverava.AutorizacaoProcedimentoWS;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.CabecalhoTransacao;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.CabecalhoTransacaoDestino;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.CabecalhoTransacaoIdentificacaoTransacao;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.CabecalhoTransacaoOrigem;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.CabecalhoTransacaoOrigemIdentificacaoPrestador;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.Ct_autorizacaoDados;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.Ct_beneficiarioDados;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.Ct_contratadoDados;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.Ct_contratadoProfissionalDados;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.Ct_guiaCabecalho;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.Ct_motivoGlosa;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.Ct_prestadorIdentificacao;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.Ct_procedimentoAutorizado;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.Ct_procedimentoDados;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.Ct_solicitacaoProcedimento;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.Ctm_spSadtSolicitacaoGuia;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.Ctm_spSadtSolicitacaoGuiaDadosExecutante;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.Ctm_spSadtSolicitacaoGuiaDadosSolicitante;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.Ctm_spSadtSolicitacaoGuiaProcedimentosSolicitados;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.Dm_simNao;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.Dm_tipoTransacao;
import br.gov.ans.www.padroes.tiss.schemas.ituverava.SolicitacaoProcedimentoWS;
import br.gov.ans.www.tiss.ws.tipos.tisssolicitacaoprocedimento.ituverava.v40100.TissSolicitacaoProcedimentoLocator;
import br.gov.ans.www.tiss.ws.tipos.tisssolicitacaoprocedimento.ituverava.v40100.TissSolicitacaoProcedimento_PortType;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import jalis.comum.Conexao;
import jalis.comum.dados.DadosExames;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.SolicitacaoProcedimento;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.math.BigInteger;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class SolicitarProcedimentoItuverava
extends SolicitacaoProcedimento {
    private static final String CARATER_ATENDIMENTO = "1";
    private static final String TIPOETAPAAUTORIZACAO = "2";
    private String padrao = null;
    private String sequencialTransacao = null;
    private String dataRegistroTransacao = null;
    private String horaRegistroTransacao = null;
    private String codigoPrestadorNaOperadora = null;
    private String registroANS = null;
    private String dataSolicitacao = "";
    private String codigoNaOperadora = null;
    private String CNES = null;
    private String nomeContratado = null;
    private String codigoTabela = null;
    private String nomeProfissional = null;
    private String conselhoProfissional = null;
    private String numeroConselhoProfissional = null;
    private String UF = null;
    private String CBOS = null;
    private String numeroGuiaPrestador = null;
    private String numeroCarteira = null;
    private String nomeBeneficiario = null;
    private String address = null;
    private String nomeContratadoExecutante = null;
    private ArrayList<DadosExames> listaExames = new ArrayList();
    private String login = "";
    private String senha = "";

    public CabecalhoTransacao montaCabecalhoTransacaoItuverava() throws DatatypeConfigurationException {
        CabecalhoTransacao cabecalhoTransacao = new CabecalhoTransacao();
        cabecalhoTransacao.setIdentificacaoTransacao(this.montaCabecalhoIdentificacaoTransacao());
        cabecalhoTransacao.setOrigem(this.montaOrigem());
        cabecalhoTransacao.setDestino(this.montaDestino());
        cabecalhoTransacao.setPadrao(this.addHash(this.getPadrao()));
        return cabecalhoTransacao;
    }

    private CabecalhoTransacaoIdentificacaoTransacao montaCabecalhoIdentificacaoTransacao() throws DatatypeConfigurationException {
        CabecalhoTransacaoIdentificacaoTransacao identificacaoTransacao = new CabecalhoTransacaoIdentificacaoTransacao();
        this.addHash(Dm_tipoTransacao.SOLICITACAO_PROCEDIMENTOS.toString());
        identificacaoTransacao.setTipoTransacao(Dm_tipoTransacao.SOLICITACAO_PROCEDIMENTOS);
        identificacaoTransacao.setSequencialTransacao(this.addHash(this.getSequencialTransacao()));
        identificacaoTransacao.setDataRegistroTransacao(this.addHash(this.getDataRegistroTransacao()));
        identificacaoTransacao.setHoraRegistroTransacao(this.addHash(this.getHoraRegistroTransacao()));
        return identificacaoTransacao;
    }

    private CabecalhoTransacaoOrigem montaOrigem() {
        CabecalhoTransacaoOrigemIdentificacaoPrestador identificacaoPrestador = new CabecalhoTransacaoOrigemIdentificacaoPrestador();
        identificacaoPrestador.setCodigoPrestadorNaOperadora(this.addHash(this.getCodigoPrestadorNaOperadora()));
        CabecalhoTransacaoOrigem origem = new CabecalhoTransacaoOrigem();
        origem.setIdentificacaoPrestador(identificacaoPrestador);
        return origem;
    }

    private CabecalhoTransacaoDestino montaDestino() {
        String regANS = this.addHash(this.getRegistroANS());
        CabecalhoTransacaoDestino destino = new CabecalhoTransacaoDestino();
        destino.setRegistroANS(regANS);
        return destino;
    }

    private Ct_prestadorIdentificacao montaPrestadorIdentificacao() {
        String codPrestadorNaOperadora = this.addHash(this.getCodigoPrestadorNaOperadora());
        Ct_prestadorIdentificacao prestadorIdentificacao = new Ct_prestadorIdentificacao();
        prestadorIdentificacao.setCodigoPrestadorNaOperadora(codPrestadorNaOperadora);
        return prestadorIdentificacao;
    }

    private Ct_solicitacaoProcedimento montaSolicitacaoProcedimento(String filial, String empresa) throws DatatypeConfigurationException {
        Ctm_spSadtSolicitacaoGuia solicitacaoSPSADT = this.montaSolicitacaoSPSADT(filial, empresa);
        Ct_solicitacaoProcedimento solicitacaoProcedimento = new Ct_solicitacaoProcedimento();
        solicitacaoProcedimento.setSolicitacaoSPSADT(solicitacaoSPSADT);
        return solicitacaoProcedimento;
    }

    private Ctm_spSadtSolicitacaoGuia montaSolicitacaoSPSADT(String filial, String empresa) throws DatatypeConfigurationException {
        Ct_guiaCabecalho cabecalhoSolicitacao = this.montaCabecalhoSolicitacao();
        String tipoEtapaAutorizacao = this.addHash(TIPOETAPAAUTORIZACAO);
        Ct_beneficiarioDados dadosBeneficiario = this.montaBeneficiarioDados();
        Ctm_spSadtSolicitacaoGuiaDadosSolicitante dadosSolicitante = this.montaDadosSolicitante(filial, empresa);
        String caraterAtendimento = this.addHash(CARATER_ATENDIMENTO);
        Ctm_spSadtSolicitacaoGuia ctmSpSadtGuia = new Ctm_spSadtSolicitacaoGuia();
        String dataSolicitacao = this.addHash(this.getDataSolicitacao());
        String indicacaoClincia = !Funcoes.textoVazio(this.getIndicacaoClinica()) ? this.addHash(this.getIndicacaoClinica()) : "";
        this.montaProcedimentosSolicitados(ctmSpSadtGuia);
        Ctm_spSadtSolicitacaoGuiaDadosExecutante dadosExecutante = this.montaDadosExecutante();
        ctmSpSadtGuia.setCabecalhoSolicitacao(cabecalhoSolicitacao);
        ctmSpSadtGuia.setDadosBeneficiario(dadosBeneficiario);
        ctmSpSadtGuia.setDadosSolicitante(dadosSolicitante);
        ctmSpSadtGuia.setCaraterAtendimento(caraterAtendimento);
        ctmSpSadtGuia.setDataSolicitacao(dataSolicitacao);
        if (!Funcoes.textoVazio(indicacaoClincia)) {
            ctmSpSadtGuia.setIndicacaoClinica(indicacaoClincia);
        }
        ctmSpSadtGuia.setDadosExecutante(dadosExecutante);
        ctmSpSadtGuia.setTipoEtapaAutorizacao(tipoEtapaAutorizacao);
        return ctmSpSadtGuia;
    }

    private Ctm_spSadtSolicitacaoGuiaDadosExecutante montaDadosExecutante() {
        String codigoPrestadorOperadora = this.addHash(this.getCodigoPrestadorNaOperadora());
        String cnes = this.addHash(this.getCNES());
        Ctm_spSadtSolicitacaoGuiaDadosExecutante dadosExecutante = new Ctm_spSadtSolicitacaoGuiaDadosExecutante();
        dadosExecutante.setCodigonaOperadora(codigoPrestadorOperadora);
        dadosExecutante.setCNES(cnes);
        return dadosExecutante;
    }

    private void montaProcedimentosSolicitados(Ctm_spSadtSolicitacaoGuia ctmSpSadtGuia) {
        ArrayList<DadosExames> listaExames = this.getListaExames();
        if (listaExames == null || listaExames.size() == 0) {
            return;
        }
        Ctm_spSadtSolicitacaoGuiaProcedimentosSolicitados[] procedimentosSolicitados = new Ctm_spSadtSolicitacaoGuiaProcedimentosSolicitados[listaExames.size()];
        ctmSpSadtGuia.setProcedimentosSolicitados(procedimentosSolicitados);
        for (int i = 0; i < listaExames.size(); ++i) {
            String codigoProcedimento = listaExames.get(i).getCodigoAMBTabelaPreco();
            String descricaoProcedimento = listaExames.get(i).getDescricao();
            String qtde = String.valueOf(listaExames.get(i).getQuantidadeExame());
            BigInteger quantidadeSolicitada = new BigInteger(qtde);
            Ct_procedimentoDados procedimento = this.montaProcedimento(this.getCodigoTabela(), codigoProcedimento, descricaoProcedimento);
            this.addHash(qtde);
            Ctm_spSadtSolicitacaoGuiaProcedimentosSolicitados procedimentoSolicitado = new Ctm_spSadtSolicitacaoGuiaProcedimentosSolicitados();
            procedimentoSolicitado.setProcedimento(procedimento);
            procedimentoSolicitado.setQuantidadeSolicitada(quantidadeSolicitada);
            ctmSpSadtGuia.setProcedimentosSolicitados(i, procedimentoSolicitado);
        }
    }

    private Ct_procedimentoDados montaProcedimento(String codigoTabela, String codigoProcedimento, String descricaoProcedimento) {
        Ct_procedimentoDados dadosProcedimentos = new Ct_procedimentoDados();
        dadosProcedimentos.setCodigoTabela(this.addHash(codigoTabela));
        dadosProcedimentos.setCodigoProcedimento(this.addHash(StringUtil.limpaString(codigoProcedimento, new String[]{".", "-"})));
        String descricao = StringUtil.removerAcentos(descricaoProcedimento);
        dadosProcedimentos.setDescricaoProcedimento(this.addHash(descricao));
        return dadosProcedimentos;
    }

    private Ctm_spSadtSolicitacaoGuiaDadosSolicitante montaDadosSolicitante(String filial, String empresa) {
        Ct_contratadoDados contratadoSolicitante = this.montaContratadoSolicitante(filial, empresa);
        Ctm_spSadtSolicitacaoGuiaDadosSolicitante dadosSolicitante = new Ctm_spSadtSolicitacaoGuiaDadosSolicitante();
        dadosSolicitante.setContratadoSolicitante(contratadoSolicitante);
        dadosSolicitante.setNomeContratadoSolicitante(this.addHash(this.getNomeProfissional()));
        Ct_contratadoProfissionalDados profissionalSolicitante = this.montaProfissionalSolicitante();
        dadosSolicitante.setProfissionalSolicitante(profissionalSolicitante);
        return dadosSolicitante;
    }

    private Ct_contratadoProfissionalDados montaProfissionalSolicitante() {
        String nomeProf = this.addHash(this.getNomeProfissional());
        String conselhoProf = this.addHash(this.getConselhoProfissional());
        String numeroConselhoProf = this.addHash(this.getNumeroConselhoProfissional());
        String uf = this.addHash(this.getUF());
        String cBOS = this.addHash(this.getCBOS());
        Ct_contratadoProfissionalDados contratadoProfissional = new Ct_contratadoProfissionalDados();
        contratadoProfissional.setNomeProfissional(nomeProf);
        contratadoProfissional.setConselhoProfissional(conselhoProf);
        contratadoProfissional.setNumeroConselhoProfissional(numeroConselhoProf);
        contratadoProfissional.setUF(uf);
        contratadoProfissional.setCBOS(cBOS);
        return contratadoProfissional;
    }

    private Ct_contratadoDados montaContratadoSolicitante(String filial, String empresa) {
        Ct_contratadoDados contatadoDados = new Ct_contratadoDados();
        if (!Funcoes.textoVazio(filial) && !Funcoes.textoVazio(empresa)) {
            Registro reg = this.buscaDadosEmpresa(filial, empresa);
            String codPrestadorNaOperadora = this.addHash(reg.getString("ent_rgie"));
            contatadoDados.setCodigoPrestadorNaOperadora(codPrestadorNaOperadora);
        } else {
            String codPrestadorNaOperadora = this.addHash("0244" + Funcoes.preencheZero(this.getNumeroConselhoProfissional(), 8));
            contatadoDados.setCodigoPrestadorNaOperadora(codPrestadorNaOperadora);
        }
        return contatadoDados;
    }

    private Registro buscaDadosEmpresa(String filial, String empresa) {
        Registro reg = new Registro();
        StringBuilder bui = new StringBuilder();
        bui.append(" select ent_rgie, ent_razaosocial from entidade ");
        bui.append(" where fil_codigo = ").append(filial);
        bui.append(" and ent_codigo = ").append(empresa);
        try {
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), bui.toString());
            if (rs.next()) {
                reg = reg.carregar(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return reg;
    }

    private Ct_guiaCabecalho montaCabecalhoSolicitacao() {
        String regANS = this.addHash(this.getRegistroANS());
        String numeroGuiaPrest = this.addHash(this.getNumeroGuiaPrestador());
        Ct_guiaCabecalho cabecalhoGuia = new Ct_guiaCabecalho();
        cabecalhoGuia.setRegistroANS(regANS);
        cabecalhoGuia.setNumeroGuiaPrestador(numeroGuiaPrest);
        return cabecalhoGuia;
    }

    private Ct_beneficiarioDados montaBeneficiarioDados() {
        String numCarteira = this.addHash(this.getNumeroCarteira());
        Dm_simNao atendimentoRN = this.isRecemNascido() != false ? Dm_simNao.S : Dm_simNao.N;
        this.addHash(atendimentoRN.toString());
        Ct_beneficiarioDados beneficiario = new Ct_beneficiarioDados();
        beneficiario.setNumeroCarteira(numCarteira);
        beneficiario.setAtendimentoRN(atendimentoRN);
        return beneficiario;
    }

    private SolicitacaoProcedimentoWS montaMensagemCompleta(String filial, String empresa) throws NoSuchAlgorithmException, DatatypeConfigurationException {
        CabecalhoTransacao cabecalho = this.montaCabecalhoTransacaoItuverava();
        Ct_solicitacaoProcedimento solicitacaoProcedimento = this.montaSolicitacaoProcedimento(filial, empresa);
        SolicitacaoProcedimentoWS solicitaProcedimentoWS = new SolicitacaoProcedimentoWS();
        solicitaProcedimentoWS.setCabecalho(cabecalho);
        solicitaProcedimentoWS.setSolicitacaoProcedimento(solicitacaoProcedimento);
        solicitaProcedimentoWS.setHash(this.calculaHash());
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        System.out.println(xstream.toXML((Object)solicitaProcedimentoWS));
        return solicitaProcedimentoWS;
    }

    private XMLGregorianCalendar converterDataEmXMLGregorianCalendar(String data) throws DatatypeConfigurationException {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = df.parse(data);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            XMLGregorianCalendar xmlDate3 = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(10), cal.get(12), cal.get(13), Integer.MIN_VALUE, Integer.MIN_VALUE);
            return xmlDate3;
        }
        catch (ParseException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    public List<HashMap<String, String>> enviarSolicitacaoItuverava(String filial, String empresa) throws Exception {
        TissSolicitacaoProcedimentoLocator proxy = new TissSolicitacaoProcedimentoLocator();
        TissSolicitacaoProcedimento_PortType port = proxy.gettissSolicitacaoProcedimento_Port(new URL(this.getAddress()));
        AutorizacaoProcedimentoWS autorizacao = new AutorizacaoProcedimentoWS();
        ArrayList<HashMap<String, String>> listaRetorno = new ArrayList();
        try {
            autorizacao = port.tissSolicitacaoProcedimento_Operation(this.montaMensagemCompleta(filial, empresa));
            listaRetorno = this.tratarRetornoAutorizacao(autorizacao);
        }
        catch (Exception e) {
            HashMap<String, String> retorno = new HashMap<String, String>();
            retorno.put("codigoGlosa", e.toString());
            retorno.put("descricaoGlosa", e.toString());
            listaRetorno.add(retorno);
        }
        return listaRetorno;
    }

    private List<HashMap<String, String>> tratarRetornoAutorizacao(AutorizacaoProcedimentoWS autorizacao) {
        ArrayList<HashMap<String, String>> listaRetorno = new ArrayList<HashMap<String, String>>();
        if (autorizacao != null) {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            System.out.println("\n\n" + xstream.toXML((Object)autorizacao));
            if (autorizacao.getAutorizacaoProcedimento() != null) {
                if (autorizacao.getAutorizacaoProcedimento().getAutorizacaoServico() != null && autorizacao.getAutorizacaoProcedimento().getAutorizacaoServico().getServicosAutorizados().length > 0) {
                    for (int i = 0; i < autorizacao.getAutorizacaoProcedimento().getAutorizacaoServico().getServicosAutorizados().length; ++i) {
                        Ct_procedimentoAutorizado autorizacaoServico;
                        HashMap<String, String> retorno = new HashMap<String, String>();
                        if (autorizacao.getAutorizacaoProcedimento().getAutorizacaoServico().getDadosAutorizacao() != null) {
                            retorno.putAll(this.retornaAutorizados(autorizacao.getAutorizacaoProcedimento().getAutorizacaoServico().getDadosAutorizacao()));
                        }
                        if ((autorizacaoServico = autorizacao.getAutorizacaoProcedimento().getAutorizacaoServico().getServicosAutorizados()[i]).getProcedimento() != null && autorizacaoServico.getQuantidadeAutorizada().compareTo(BigInteger.ZERO) > 0) {
                            retorno.put("codigoProcedimento", autorizacaoServico.getProcedimento().getCodigoProcedimento());
                        }
                        if (autorizacaoServico.getMotivosNegativa() != null && autorizacaoServico.getMotivosNegativa().length > 0) {
                            retorno.putAll(this.retornaNegativa(autorizacaoServico.getMotivosNegativa()));
                        }
                        if (autorizacao.getAutorizacaoProcedimento().getMensagemErro() != null && !Funcoes.textoVazio(autorizacao.getAutorizacaoProcedimento().getMensagemErro().getDescricaoGlosa())) {
                            retorno.put("codigoGlosa", autorizacao.getAutorizacaoProcedimento().getMensagemErro().getCodigoGlosa());
                            retorno.put("descricaoGlosa", autorizacao.getAutorizacaoProcedimento().getMensagemErro().getDescricaoGlosa());
                        }
                        listaRetorno.add(retorno);
                    }
                } else if (autorizacao.getAutorizacaoProcedimento().getMensagemErro() != null && !Funcoes.textoVazio(autorizacao.getAutorizacaoProcedimento().getMensagemErro().getDescricaoGlosa())) {
                    HashMap<String, String> retorno = new HashMap<String, String>();
                    retorno.put("codigoGlosa", autorizacao.getAutorizacaoProcedimento().getMensagemErro().getCodigoGlosa());
                    retorno.put("descricaoGlosa", autorizacao.getAutorizacaoProcedimento().getMensagemErro().getDescricaoGlosa());
                    listaRetorno.add(retorno);
                }
            }
        }
        return listaRetorno;
    }

    private Map<String, String> retornaAutorizados(Ct_autorizacaoDados autorizacaoDados) {
        HashMap<String, String> retorno = new HashMap<String, String>();
        if (autorizacaoDados != null) {
            retorno.put("senha", autorizacaoDados.getSenha());
            retorno.put("dataAutorizacao", autorizacaoDados.getDataAutorizacao());
            retorno.put("numeroGuiaPrestadora", autorizacaoDados.getNumeroGuiaOperadora());
            retorno.put("dataValidadeSenha", autorizacaoDados.getDataValidadeSenha());
        }
        return retorno;
    }

    private Map<String, String> retornaNegativa(Ct_motivoGlosa[] motivosNegativa) {
        HashMap<String, String> retorno = new HashMap<String, String>();
        StringBuilder mensagemNegativa = new StringBuilder();
        for (int i = 0; i < motivosNegativa.length; ++i) {
            Ct_motivoGlosa motivo = motivosNegativa[i];
            mensagemNegativa.append(motivo.getCodigoGlosa());
            mensagemNegativa.append(" " + motivo.getDescricaoGlosa() + "\n");
        }
        retorno.put("codigoGlosa", mensagemNegativa.toString());
        retorno.put("descricaoGlosa", mensagemNegativa.toString());
        return retorno;
    }

    @Override
    public String getPadrao() {
        return this.padrao;
    }

    @Override
    public void setPadrao(String padrao) {
        this.padrao = padrao;
    }

    @Override
    public String getSequencialTransacao() {
        return this.sequencialTransacao;
    }

    @Override
    public void setSequencialTransacao(String sequencialTransacao) {
        this.sequencialTransacao = sequencialTransacao;
    }

    @Override
    public String getDataRegistroTransacao() {
        return this.dataRegistroTransacao;
    }

    @Override
    public void setDataRegistroTransacao(String dataRegistroTransacao) {
        this.dataRegistroTransacao = dataRegistroTransacao;
    }

    @Override
    public String getHoraRegistroTransacao() {
        return this.horaRegistroTransacao;
    }

    @Override
    public void setHoraRegistroTransacao(String horaRegistroTransacao) {
        this.horaRegistroTransacao = horaRegistroTransacao;
    }

    @Override
    public String getCodigoPrestadorNaOperadora() {
        return this.codigoPrestadorNaOperadora;
    }

    @Override
    public void setCodigoPrestadorNaOperadora(String codigoPrestadorNaOperadora) {
        this.codigoPrestadorNaOperadora = codigoPrestadorNaOperadora;
    }

    @Override
    public String getRegistroANS() {
        return this.registroANS;
    }

    @Override
    public void setRegistroANS(String registroANS) {
        this.registroANS = registroANS;
    }

    @Override
    public String getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    @Override
    public void setDataSolicitacao(String dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    @Override
    public String getCodigoNaOperadora() {
        return this.codigoNaOperadora;
    }

    @Override
    public void setCodigoNaOperadora(String codigoNaOperadora) {
        this.codigoNaOperadora = codigoNaOperadora;
    }

    @Override
    public String getCNES() {
        return this.CNES;
    }

    @Override
    public void setCNES(String CNES) {
        this.CNES = CNES;
    }

    @Override
    public String getNomeContratado() {
        return this.nomeContratado;
    }

    @Override
    public void setNomeContratado(String nomeContratado) {
        this.nomeContratado = nomeContratado;
    }

    @Override
    public ArrayList<DadosExames> getListaExames() {
        return this.listaExames;
    }

    @Override
    public void setListaExames(ArrayList<DadosExames> listaExames) {
        this.listaExames = listaExames;
    }

    @Override
    public String getCodigoTabela() {
        return this.codigoTabela;
    }

    @Override
    public void setCodigoTabela(String codigoTabela) {
        this.codigoTabela = codigoTabela;
    }

    @Override
    public String getNomeProfissional() {
        return this.nomeProfissional;
    }

    @Override
    public void setNomeProfissional(String nomeProfissional) {
        this.nomeProfissional = nomeProfissional;
    }

    @Override
    public String getConselhoProfissional() {
        return this.conselhoProfissional;
    }

    @Override
    public void setConselhoProfissional(String conselhoProfissional) {
        this.conselhoProfissional = conselhoProfissional;
    }

    @Override
    public String getNumeroConselhoProfissional() {
        return this.numeroConselhoProfissional;
    }

    @Override
    public void setNumeroConselhoProfissional(String numeroConselhoProfissional) {
        this.numeroConselhoProfissional = numeroConselhoProfissional;
    }

    @Override
    public String getUF() {
        return this.UF;
    }

    @Override
    public void setUF(String UF) {
        this.UF = UF;
    }

    @Override
    public String getCBOS() {
        return this.CBOS;
    }

    @Override
    public void setCBOS(String CBOS2) {
        this.CBOS = CBOS2;
    }

    @Override
    public String getNumeroGuiaPrestador() {
        return this.numeroGuiaPrestador;
    }

    @Override
    public void setNumeroGuiaPrestador(String numeroGuiaPrestador) {
        this.numeroGuiaPrestador = numeroGuiaPrestador;
    }

    @Override
    public String getNumeroCarteira() {
        return this.numeroCarteira;
    }

    @Override
    public void setNumeroCarteira(String numeroCarteira) {
        this.numeroCarteira = numeroCarteira;
    }

    @Override
    public String getNomeBeneficiario() {
        return this.nomeBeneficiario;
    }

    @Override
    public void setNomeBeneficiario(String nomeBeneficiario) {
        this.nomeBeneficiario = nomeBeneficiario;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public String getNomeContratadoExecutante() {
        return this.nomeContratadoExecutante;
    }

    @Override
    public void setNomeContratadoExecutante(String nomeContratadoExecutante) {
        this.nomeContratadoExecutante = nomeContratadoExecutante;
    }

    @Override
    public String getLogin() {
        return this.login;
    }

    @Override
    public void setLogin(String login) {
        this.login = login;
    }

    @Override
    public String getSenha() {
        return this.senha;
    }

    @Override
    public void setSenha(String senha) {
        this.senha = senha;
    }
}

