/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico.sgucard;

import br.gov.ans.www.padroes.tiss.schemas.Dm_simNao;
import br.gov.ans.www.padroes.tiss.schemas.Dm_tipoTransacao;
import jalis.comum.dados.DadosExames;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.TissWS;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class SolicitacaoProcedimentoSguCard
extends TissWS {
    private static final String CARATER_ATENDIMENTO = "1";
    private static final String TAG_BODY = "SOAP-ENV:Body";
    private static final String TAG_CABECALHO = "ns3:cabecalho";
    private static final String TAG_IDENTIFICACAO_TRANSACAO = "ns3:identificacaoTransacao";
    private static final String TAG_TIPO_TRANSACAO = "ns3:tipoTransacao";
    private static final String TAG_SEQUENCIAL_TRANSACAO = "ns3:sequencialTransacao";
    private static final String TAG_DATA_REGISTRO_TRANSACAO = "ns3:dataRegistroTransacao";
    private static final String TAG_HORA_REGISTRO_TRANSACAO = "ns3:horaRegistroTransacao";
    private static final String TAG_ORIGEM = "ns3:origem";
    private static final String TAG_IDENTIFICACAO_PRESTADOR = "ns3:identificacaoPrestador";
    private static final String TAG_CODIGO_PRESTADOR_NA_OPERADORA = "ns3:codigoPrestadorNaOperadora";
    private static final String TAG_DESTINO = "ns3:destino";
    private static final String TAG_REGISTRO_ANS = "ns3:registroANS";
    private static final String TAG_PADRAO = "ns3:Padrao";
    private static final String TAG_LOGIN_SENHA_PRESTADOR = "ns3:loginSenhaPrestador";
    private static final String TAG_LOGIN_PRESTADOR = "ns3:loginPrestador";
    private static final String TAG_SENHA_PRESTADOR = "ns3:senhaPrestador";
    private static final String TAG_SOLICITACAO_PROCEDIMENTO = "ns3:solicitacaoProcedimento";
    private static final String TAG_SOLICITACAO_SPSADT = "ns3:solicitacaoSP-SADT";
    private static final String TAG_CABECALHO_SOLICITACAO = "ns3:cabecalhoSolicitacao";
    private static final String TAG_NUMERO_GUIA_PRESTADOR = "ns3:numeroGuiaPrestador";
    private static final String TAG_DADOS_BENEFICIARIO = "ns3:dadosBeneficiario";
    private static final String TAG_NUMERO_CARTEIRA = "ns3:numeroCarteira";
    private static final String TAG_ATENDIMENTO_RN = "ns3:atendimentoRN";
    private static final String TAG_NOME_BENEFICIARIO = "ns3:nomeBeneficiario";
    private static final String TAG_DADOS_SOLICITANTE = "ns3:dadosSolicitante";
    private static final String TAG_CONTRATADO_SOLICITANTE = "ns3:contratadoSolicitante";
    private static final String TAG_NOME_CONTRATADO = "ns3:nomeContratado";
    private static final String TAG_PROFISSIONAL_SOCILITANTE = "ns3:profissionalSolicitante";
    private static final String TAG_NOME_PROFISSIONAL = "ns3:nomeProfissional";
    private static final String TAG_CONSELHO_PROFISSIONAL = "ns3:conselhoProfissional";
    private static final String TAG_NUMERO_CONSELHO_PROFISSIONAL = "ns3:numeroConselhoProfissional";
    private static final String TAG_UF = "ns3:UF";
    private static final String TAG_CBOS = "ns3:CBOS";
    private static final String TAG_CARATER_ATENDIMENTO = "ns3:caraterAtendimento";
    private static final String TAG_DATA_SOLICITACAO = "ns3:dataSolicitacao";
    private static final String TAG_PROCEDIMENTOS_SOLICITADOS = "ns3:procedimentosSolicitados";
    private static final String TAG_PROCEDIMENTO = "ns3:procedimento";
    private static final String TAG_CODIGO_TABELA = "ns3:codigoTabela";
    private static final String TAG_CODIGO_PROCEDIMENTO = "ns3:codigoProcedimento";
    private static final String TAG_DESCRICAO_PROCEDIMENTO = "ns3:descricaoProcedimento";
    private static final String TAG_QUANTIDADE_SOLICITADA = "ns3:quantidadeSolicitada";
    private static final String TAG_DADOS_EXECUTANTE = "ns3:dadosExecutante";
    private static final String TAG_CODIGO_NA_OPERAORA = "ns3:codigonaOperadora";
    private static final String TAG_CNES = "ns3:CNES";
    private static final String TAG_HASH = "ns3:hash";
    private static final String TAG_AUTORIZACAO_PROCEDIMENTO = "ans:autorizacaoProcedimento";
    private static final String TAG_AUTORIZACAO_SERVICO = "ans:autorizacaoServico";
    private static final String TAG_DADOS_AUTORIZACAO = "ans:dadosAutorizacao";
    private static final String TAG_SENHA = "ans:senha";
    private static final String TAG_VALIDADE_SENHA = "ans:dataValidadeSenha";
    private static final String TAG_STATUS_AUTORIZACAO = "ans:statusSolicitacao";
    private static final String TAG_MOTIVOS_NEGATIVA = "ans:motivosNegativa";
    private static final String TAG_MOTIVO_NEGATIVA = "ans:motivoNegativa";
    private static final String TAG_NUMERO_GUIA_OPERADORA = "numeroGuiaOperadora";
    private static final String TAG_DATA_AUTORIZACAO = "ans:dataAutorizacao";
    private static final String TAG_DATA_VALIDADE = "ans:dataValidadeSenha";
    private static final String TAG_MENSAGEM_ERRO = "ans:mensagemErro";
    private static final String TAG_CODIGO_GLOSA = "ans:codigoGlosa";
    private static final String TAG_DESCRICAO_GLOSA = "ans:descricaoGlosa";
    private String padrao = null;
    private String sequencialTransacao = null;
    private String dataRegistroTransacao = null;
    private String horaRegistroTransacao = null;
    private String codigoPrestadorNaOperadora = null;
    private String registroANS = null;
    private String dataSolicitacao = "";
    private String codigoNaOperadora = null;
    private String CNES = null;
    private String nomeContratado = null;
    private String codigoTabela = null;
    private String nomeProfissional = null;
    private String conselhoProfissional = null;
    private String numeroConselhoProfissional = null;
    private String UF = null;
    private String CBOS = null;
    private String numeroGuiaPrestador = null;
    private String numeroCarteira = null;
    private String nomeBeneficiario = null;
    private String address = null;
    private String nomeContratadoExecutante = null;
    private ArrayList<DadosExames> listaExames = new ArrayList();
    private String login = "";
    private String senha = "";
    private Boolean recemNascido;

    public String enviarSolicitacaoXML() throws Exception {
        String requestSoap = this.getXML();
        SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection soapConnection = soapConnectionFactory.createConnection();
        String url = this.getAddress();
        MimeHeaders headers = new MimeHeaders();
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage msg = messageFactory.createMessage(headers, (InputStream)new ByteArrayInputStream(requestSoap.getBytes()));
        try {
            SOAPMessage soapResponse = soapConnection.call(msg, (Object)url);
            Document xmlRespostaARequisicao = soapResponse.getSOAPBody().getOwnerDocument();
            return SolicitacaoProcedimentoSguCard.converteXMLParaString(xmlRespostaARequisicao, 0);
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter conex\u00e3o com a operadora.", 1);
            return "";
        }
    }

    public static String converteXMLParaString(Document xml, int espacosIdentacao) {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            transfac.setAttribute("indent-number", new Integer(espacosIdentacao));
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(xml);
            trans.transform(source, result);
            String xmlString = sw.toString();
            return xmlString;
        }
        catch (TransformerException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    private String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.escrever("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\">");
            xml.escrever("<SOAP-ENV:Header/>");
            xml.abrir(SolicitacaoProcedimentoSguCard.getTagBody());
            xml.escrever("<ns3:solicitacaoProcedimentoWS xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:ns3=\"http://www.ans.gov.br/padroes/tiss/schemas\">");
            this.montaCabecalhoSolicitacao(xml);
            this.montaSolicitacaoProcedimento(xml);
            xml.escrever(SolicitacaoProcedimentoSguCard.getTagHash(), this.calculaHash());
            xml.escrever("</ns3:solicitacaoProcedimentoWS>");
            xml.fechar(SolicitacaoProcedimentoSguCard.getTagBody());
            xml.escrever("</SOAP-ENV:Envelope>");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return xml.getXML();
    }

    public XMLStringBuilder montaCabecalhoSolicitacao(XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(SolicitacaoProcedimentoSguCard.getTagCabecalho());
        xml.abrir(SolicitacaoProcedimentoSguCard.getTagIdentificacaoTransacao());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagTipoTransacao(), Dm_tipoTransacao.SOLICITACAO_PROCEDIMENTOS.toString());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagSequencialTransacao(), this.getSequencialTransacao());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagDataRegistroTransacao(), this.getDataRegistroTransacao());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagHoraRegistroTransacao(), this.getHoraRegistroTransacao());
        xml.fechar(SolicitacaoProcedimentoSguCard.getTagIdentificacaoTransacao());
        xml.abrir(SolicitacaoProcedimentoSguCard.getTagOrigem());
        xml.abrir(SolicitacaoProcedimentoSguCard.getTagIdentificacaoPrestador());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagCodigoPrestadorNaOperadora(), this.getCodigoPrestadorNaOperadora());
        xml.fechar(SolicitacaoProcedimentoSguCard.getTagIdentificacaoPrestador());
        xml.fechar(SolicitacaoProcedimentoSguCard.getTagOrigem());
        xml.abrir(SolicitacaoProcedimentoSguCard.getTagDestino());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagRegistroAns(), this.getRegistroANS());
        xml.fechar(SolicitacaoProcedimentoSguCard.getTagDestino());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagPadrao(), this.getPadrao());
        xml.abrir(SolicitacaoProcedimentoSguCard.getTagLoginSenhaPrestador());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagLoginPrestador(), this.getLogin());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagSenhaPrestador(), this.getSenha());
        xml.fechar(SolicitacaoProcedimentoSguCard.getTagLoginSenhaPrestador());
        xml.fechar(SolicitacaoProcedimentoSguCard.getTagCabecalho());
        return xml;
    }

    private XMLStringBuilder montaSolicitacaoProcedimento(XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(SolicitacaoProcedimentoSguCard.getTagSolicitacaoProcedimento());
        xml.abrir(SolicitacaoProcedimentoSguCard.getTagSolicitacaoSpsadt());
        xml.abrir(SolicitacaoProcedimentoSguCard.getTagCabecalhoSolicitacao());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagRegistroAns(), this.getRegistroANS());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagNumeroGuiaPrestador(), this.getNumeroGuiaPrestador());
        xml.fechar(SolicitacaoProcedimentoSguCard.getTagCabecalhoSolicitacao());
        xml.escrever(this.getTipoEtapaAutorizacao());
        xml.abrir(SolicitacaoProcedimentoSguCard.getTagDadosBeneficiario());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagNumeroCarteira(), this.getNumeroCarteira());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagAtendimentoRn(), this.isRecemNascido() != false ? Dm_simNao.S.toString() : Dm_simNao.N.toString());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagNomeBeneficiario(), this.getNomeBeneficiario());
        xml.fechar(SolicitacaoProcedimentoSguCard.getTagDadosBeneficiario());
        xml.abrir(SolicitacaoProcedimentoSguCard.getTagDadosSolicitante());
        xml.abrir(SolicitacaoProcedimentoSguCard.getTagContratadoSolicitante());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagCodigoPrestadorNaOperadora(), this.getCodigoPrestadorNaOperadora());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagNomeContratado(), this.getNomeContratado());
        xml.fechar(SolicitacaoProcedimentoSguCard.getTagContratadoSolicitante());
        xml.abrir(SolicitacaoProcedimentoSguCard.getTagProfissionalSocilitante());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagNomeProfissional(), this.getNomeProfissional());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagConselhoProfissional(), this.getConselhoProfissional());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagNumeroConselhoProfissional(), this.getNumeroConselhoProfissional());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagUf(), this.getUF());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagCbos(), this.getCBOS());
        xml.fechar(SolicitacaoProcedimentoSguCard.getTagProfissionalSocilitante());
        xml.fechar(SolicitacaoProcedimentoSguCard.getTagDadosSolicitante());
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagCaraterAtendimento(), CARATER_ATENDIMENTO);
        xml.escrever(SolicitacaoProcedimentoSguCard.getTagDataSolicitacao(), this.getDataSolicitacao());
        xml.abrir(SolicitacaoProcedimentoSguCard.getTagProcedimentosSolicitados());
        this.montaProcedimentosSolicitados(xml);
        xml.fechar(SolicitacaoProcedimentoSguCard.getTagProcedimentosSolicitados());
        xml.fechar(SolicitacaoProcedimentoSguCard.getTagSolicitacaoSpsadt());
        xml.fechar(SolicitacaoProcedimentoSguCard.getTagSolicitacaoProcedimento());
        return xml;
    }

    private String getTipoEtapaAutorizacao() {
        return "<ns3:tipoEtapaAutorizacao>1</ns3:tipoEtapaAutorizacao>";
    }

    private XMLStringBuilder montaProcedimentosSolicitados(XMLStringBuilder xml) throws XMLStringBuilderException {
        ArrayList<DadosExames> listaExames = this.getListaExames();
        if (listaExames == null || listaExames.size() == 0) {
            return xml;
        }
        for (int i = 0; i < listaExames.size(); ++i) {
            String codigoProcedimento = listaExames.get(i).getCodigoAMBTabelaPreco();
            String descricaoProcedimento = listaExames.get(i).getDescricao();
            String quantidadeSolicitada = String.valueOf(listaExames.get(i).getQuantidadeExame());
            xml.abrir(SolicitacaoProcedimentoSguCard.getTagProcedimento());
            xml.escrever(SolicitacaoProcedimentoSguCard.getTagCodigoTabela(), this.getCodigoTabela());
            xml.escrever(SolicitacaoProcedimentoSguCard.getTagCodigoProcedimento(), StringUtil.limpaString(codigoProcedimento, new String[]{".", "-"}));
            xml.escrever(SolicitacaoProcedimentoSguCard.getTagDescricaoProcedimento(), descricaoProcedimento);
            xml.fechar(SolicitacaoProcedimentoSguCard.getTagProcedimento());
            xml.escrever(SolicitacaoProcedimentoSguCard.getTagQuantidadeSolicitada(), quantidadeSolicitada);
        }
        return xml;
    }

    public String getPadrao() {
        return this.padrao;
    }

    public void setPadrao(String padrao) {
        this.padrao = padrao;
    }

    public String getSequencialTransacao() {
        return this.sequencialTransacao;
    }

    public void setSequencialTransacao(String sequencialTransacao) {
        this.sequencialTransacao = sequencialTransacao;
    }

    public String getDataRegistroTransacao() {
        return this.dataRegistroTransacao;
    }

    public void setDataRegistroTransacao(String dataRegistroTransacao) {
        this.dataRegistroTransacao = dataRegistroTransacao;
    }

    public String getHoraRegistroTransacao() {
        return this.horaRegistroTransacao;
    }

    public void setHoraRegistroTransacao(String horaRegistroTransacao) {
        this.horaRegistroTransacao = horaRegistroTransacao;
    }

    public String getCodigoPrestadorNaOperadora() {
        return this.codigoPrestadorNaOperadora;
    }

    public void setCodigoPrestadorNaOperadora(String codigoPrestadorNaOperadora) {
        this.codigoPrestadorNaOperadora = codigoPrestadorNaOperadora;
    }

    public String getRegistroANS() {
        return this.registroANS;
    }

    public void setRegistroANS(String registroANS) {
        this.registroANS = registroANS;
    }

    public String getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    public void setDataSolicitacao(String dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    public String getCodigoNaOperadora() {
        return this.codigoNaOperadora;
    }

    public void setCodigoNaOperadora(String codigoNaOperadora) {
        this.codigoNaOperadora = codigoNaOperadora;
    }

    public String getCNES() {
        return this.CNES;
    }

    public void setCNES(String CNES) {
        this.CNES = CNES;
    }

    public String getNomeContratado() {
        return this.nomeContratado;
    }

    public void setNomeContratado(String nomeContratado) {
        this.nomeContratado = nomeContratado;
    }

    public ArrayList<DadosExames> getListaExames() {
        return this.listaExames;
    }

    public void setListaExames(ArrayList<DadosExames> listaExames) {
        this.listaExames = listaExames;
    }

    public String getCodigoTabela() {
        return this.codigoTabela;
    }

    public void setCodigoTabela(String codigoTabela) {
        this.codigoTabela = codigoTabela;
    }

    public String getNomeProfissional() {
        return this.nomeProfissional;
    }

    public void setNomeProfissional(String nomeProfissional) {
        this.nomeProfissional = nomeProfissional;
    }

    public String getConselhoProfissional() {
        return this.conselhoProfissional;
    }

    public void setConselhoProfissional(String conselhoProfissional) {
        this.conselhoProfissional = conselhoProfissional;
    }

    public String getNumeroConselhoProfissional() {
        return this.numeroConselhoProfissional;
    }

    public void setNumeroConselhoProfissional(String numeroConselhoProfissional) {
        this.numeroConselhoProfissional = numeroConselhoProfissional;
    }

    public String getUF() {
        return this.UF;
    }

    public void setUF(String UF) {
        this.UF = UF;
    }

    public String getCBOS() {
        return this.CBOS;
    }

    public void setCBOS(String CBOS2) {
        this.CBOS = CBOS2;
    }

    public String getNumeroGuiaPrestador() {
        return this.numeroGuiaPrestador;
    }

    public void setNumeroGuiaPrestador(String numeroGuiaPrestador) {
        this.numeroGuiaPrestador = numeroGuiaPrestador;
    }

    public String getNumeroCarteira() {
        return this.numeroCarteira;
    }

    public void setNumeroCarteira(String numeroCarteira) {
        this.numeroCarteira = numeroCarteira;
    }

    public String getNomeBeneficiario() {
        return this.nomeBeneficiario;
    }

    public void setNomeBeneficiario(String nomeBeneficiario) {
        this.nomeBeneficiario = nomeBeneficiario;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getNomeContratadoExecutante() {
        return this.nomeContratadoExecutante;
    }

    public void setNomeContratadoExecutante(String nomeContratadoExecutante) {
        this.nomeContratadoExecutante = nomeContratadoExecutante;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public static String getTagBody() {
        return TAG_BODY;
    }

    public static String getTagCabecalho() {
        return TAG_CABECALHO;
    }

    public static String getTagIdentificacaoTransacao() {
        return TAG_IDENTIFICACAO_TRANSACAO;
    }

    public static String getTagTipoTransacao() {
        return TAG_TIPO_TRANSACAO;
    }

    public static String getTagSequencialTransacao() {
        return TAG_SEQUENCIAL_TRANSACAO;
    }

    public static String getTagDataRegistroTransacao() {
        return TAG_DATA_REGISTRO_TRANSACAO;
    }

    public static String getTagHoraRegistroTransacao() {
        return TAG_HORA_REGISTRO_TRANSACAO;
    }

    public static String getTagOrigem() {
        return TAG_ORIGEM;
    }

    public static String getTagIdentificacaoPrestador() {
        return TAG_IDENTIFICACAO_PRESTADOR;
    }

    public static String getTagCodigoPrestadorNaOperadora() {
        return TAG_CODIGO_PRESTADOR_NA_OPERADORA;
    }

    public static String getTagDestino() {
        return TAG_DESTINO;
    }

    public static String getTagRegistroAns() {
        return TAG_REGISTRO_ANS;
    }

    public static String getTagPadrao() {
        return TAG_PADRAO;
    }

    public static String getTagLoginSenhaPrestador() {
        return TAG_LOGIN_SENHA_PRESTADOR;
    }

    public static String getTagLoginPrestador() {
        return TAG_LOGIN_PRESTADOR;
    }

    public static String getTagSenhaPrestador() {
        return TAG_SENHA_PRESTADOR;
    }

    public static String getTagSolicitacaoProcedimento() {
        return TAG_SOLICITACAO_PROCEDIMENTO;
    }

    public static String getTagSolicitacaoSpsadt() {
        return TAG_SOLICITACAO_SPSADT;
    }

    public static String getTagCabecalhoSolicitacao() {
        return TAG_CABECALHO_SOLICITACAO;
    }

    public static String getTagNumeroGuiaPrestador() {
        return TAG_NUMERO_GUIA_PRESTADOR;
    }

    public static String getTagDadosBeneficiario() {
        return TAG_DADOS_BENEFICIARIO;
    }

    public static String getTagNumeroCarteira() {
        return TAG_NUMERO_CARTEIRA;
    }

    public static String getTagAtendimentoRn() {
        return TAG_ATENDIMENTO_RN;
    }

    public static String getTagNomeBeneficiario() {
        return TAG_NOME_BENEFICIARIO;
    }

    public static String getTagDadosSolicitante() {
        return TAG_DADOS_SOLICITANTE;
    }

    public static String getTagContratadoSolicitante() {
        return TAG_CONTRATADO_SOLICITANTE;
    }

    public static String getTagNomeContratado() {
        return TAG_NOME_CONTRATADO;
    }

    public static String getTagProfissionalSocilitante() {
        return TAG_PROFISSIONAL_SOCILITANTE;
    }

    public static String getTagNomeProfissional() {
        return TAG_NOME_PROFISSIONAL;
    }

    public static String getTagConselhoProfissional() {
        return TAG_CONSELHO_PROFISSIONAL;
    }

    public static String getTagNumeroConselhoProfissional() {
        return TAG_NUMERO_CONSELHO_PROFISSIONAL;
    }

    public static String getTagUf() {
        return TAG_UF;
    }

    public static String getTagCbos() {
        return TAG_CBOS;
    }

    public static String getTagCaraterAtendimento() {
        return TAG_CARATER_ATENDIMENTO;
    }

    public static String getTagDataSolicitacao() {
        return TAG_DATA_SOLICITACAO;
    }

    public static String getTagProcedimentosSolicitados() {
        return TAG_PROCEDIMENTOS_SOLICITADOS;
    }

    public static String getTagProcedimento() {
        return TAG_PROCEDIMENTO;
    }

    public static String getTagCodigoTabela() {
        return TAG_CODIGO_TABELA;
    }

    public static String getTagCodigoProcedimento() {
        return TAG_CODIGO_PROCEDIMENTO;
    }

    public static String getTagDescricaoProcedimento() {
        return TAG_DESCRICAO_PROCEDIMENTO;
    }

    public static String getTagQuantidadeSolicitada() {
        return TAG_QUANTIDADE_SOLICITADA;
    }

    public static String getTagDadosExecutante() {
        return TAG_DADOS_EXECUTANTE;
    }

    public static String getTagCodigoNaOperaora() {
        return TAG_CODIGO_NA_OPERAORA;
    }

    public static String getTagCnes() {
        return TAG_CNES;
    }

    public static String getTagHash() {
        return TAG_HASH;
    }

    public static String getTagAutorizacaoServico() {
        return TAG_AUTORIZACAO_SERVICO;
    }

    public static String getTagNumeroguiaoperadora() {
        return TAG_NUMERO_GUIA_OPERADORA;
    }

    public static String getTagDataAutorizacao() {
        return TAG_DATA_AUTORIZACAO;
    }

    public static String getTagDataValidade() {
        return "ans:dataValidadeSenha";
    }

    public static String getTagAutorizacaoProcedimento() {
        return TAG_AUTORIZACAO_PROCEDIMENTO;
    }

    public static String getTagMensagemErro() {
        return TAG_MENSAGEM_ERRO;
    }

    public static String getTagCodigoGlosa() {
        return TAG_CODIGO_GLOSA;
    }

    public static String getTagDescricaoGlosa() {
        return TAG_DESCRICAO_GLOSA;
    }

    public static String getTagDadosAutorizacao() {
        return TAG_DADOS_AUTORIZACAO;
    }

    public static String getTagSenha() {
        return TAG_SENHA;
    }

    public static String getTagValidadeSenha() {
        return "ans:dataValidadeSenha";
    }

    public static String getTagStatusAutorizacao() {
        return TAG_STATUS_AUTORIZACAO;
    }

    public static String getTagNumeroGuiaOperadora() {
        return TAG_NUMERO_GUIA_OPERADORA;
    }

    public static String getTagMotivoNegativa() {
        return TAG_MOTIVO_NEGATIVA;
    }

    public static String getTagMotivosNegativa() {
        return TAG_MOTIVOS_NEGATIVA;
    }

    public Boolean isRecemNascido() {
        return this.recemNascido;
    }

    public void setRecemNascido(Boolean recemNascido) {
        this.recemNascido = recemNascido;
    }
}

