/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico.save;

import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.save.DadosAdicionaisSave;
import jalis.laboratorio.util.faturamento.eletronico.save.DadosExamesSave;
import jalis.laboratorio.util.faturamento.eletronico.save.SaveDao;
import jalis.laboratorio.util.faturamento.eletronico.save.TipoAtendimentoSave;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;

public class SaveService {
    public ArrayList<Registro> buscaExamesRequisicao(Integer codigoFilial, Integer codigoRequisicao, String filtroExames) throws SQLException {
        SaveDao dao = new SaveDao();
        ResultSet rs = dao.buscaExamesRequisicao(codigoFilial, codigoRequisicao, filtroExames);
        ArrayList<Registro> listaExames = new ArrayList<Registro>();
        while (rs.next()) {
            String xml = rs.getString("con_faturaeletronica");
            String codigoPrestador = StringUtil.getValor(xml, "codigoPrestador");
            String usuarios = StringUtil.getValor(xml, "usuariosSave");
            String usuarioRequisicao = rs.getString("usr_codigo");
            DadosExamesSave dadosExamesSave = new DadosExamesSave();
            DadosAdicionaisSave dadosAdicionaisSave = new DadosAdicionaisSave();
            dadosAdicionaisSave.setCentroCusto(rs.getString("req_centrocustosave"));
            dadosAdicionaisSave.setTipoAtendimento(TipoAtendimentoSave.setCodigo(rs.getString("req_tipoatendimentosave")));
            dadosAdicionaisSave.setCodigoAtendimento(rs.getString("req_codigoatendimentosave"));
            dadosExamesSave.setCodigoPrestador(codigoPrestador);
            dadosExamesSave.setDadosAdicionais(dadosAdicionaisSave);
            dadosExamesSave.setCodigoTuss(StringUtil.removeCaracteresNaoNumericos(rs.getString("dtp_codamb")));
            dadosExamesSave.setQuantidadeExames(1);
            String codigoSequencial = rs.getString("fil_codigo");
            codigoSequencial = Funcoes.preencheZero(codigoSequencial, 2);
            codigoSequencial = codigoSequencial + Funcoes.preencheZero(rs.getString("req_codigo"), 6);
            codigoSequencial = codigoSequencial + Funcoes.preencheZero(rs.getString("exr_ordem"), 2);
            dadosExamesSave.setSequencialLis(codigoSequencial);
            Date dataSolicitacao = rs.getDate("req_data");
            Timestamp horaSolicitacao = rs.getTimestamp("req_hora");
            String dataHoraSolicitacao = Funcoes.formataData("yyyy-MM-dd", dataSolicitacao);
            dataHoraSolicitacao = dataHoraSolicitacao + " " + Funcoes.formataData("HH:mm:ss", horaSolicitacao);
            dadosExamesSave.setCodigoUsuario(rs.getString("usr_codassina"));
            dadosExamesSave.setDataHoraSolicitacao(dataHoraSolicitacao);
            dadosExamesSave.setDataHoraRealizacao(Funcoes.formataData("yyyy-mm-dd HH:mm:ss", rs.getTimestamp("exr_dataassina")));
            Registro registro = new Registro(rs);
            registro.setValor("fil_codigo", rs.getInt("fil_codigo"));
            registro.setValor("req_codigo", rs.getInt("req_codigo"));
            registro.setValor("exa_codigo", rs.getString("exa_codigo"));
            registro.setValor("mco_codigo", rs.getInt("mco_codigo"));
            registro.setValor("mco_abreviatura", rs.getString("mco_abreviatura"));
            registro.setValor("exa_descricao", rs.getString("exa_descricao"));
            registro.setValor("exr_situacao", rs.getString("exr_situacao"));
            registro.setValor("dadosExamesSave", dadosExamesSave);
            listaExames.add(registro);
        }
        return listaExames;
    }

    public void gerarArquivo(Object owner, List<Registro> listaExames, String xmlConfiguracao) throws IOException, Exception {
        SaveDao saveDao = new SaveDao();
        StringBuilder buf = new StringBuilder();
        ArrayList<String> usuarios = new ArrayList<String>();
        for (Registro registro : listaExames) {
            DadosExamesSave dadosExamesSave = (DadosExamesSave)registro.getValor("dadosExamesSave");
            buf.append(dadosExamesSave.getCodigoPrestador()).append(";");
            buf.append(dadosExamesSave.getDadosAdicionais().getTipoAtendimento().getTipoAtendimentoSave()).append(";");
            buf.append(dadosExamesSave.getDadosAdicionais().getCodigoAtendimento()).append(";");
            buf.append(dadosExamesSave.getDadosAdicionais().getCentroCusto()).append(";");
            buf.append(dadosExamesSave.getDataHoraSolicitacao()).append(";");
            buf.append(dadosExamesSave.getDataHoraRealizacao()).append(";");
            String usuario = this.getCodigoUsuarioSave(dadosExamesSave.getCodigoUsuario(), xmlConfiguracao);
            if (Funcoes.textoVazio(usuario)) {
                usuarios.add(dadosExamesSave.getCodigoUsuario());
            }
            buf.append(usuario).append(";");
            buf.append(dadosExamesSave.getCodigoTuss()).append(";");
            buf.append(dadosExamesSave.getQuantidadeExames()).append(";");
            buf.append(dadosExamesSave.getSequencialLis()).append(";");
        }
        if (usuarios.size() > 0) {
            String lista = "\n Usu\u00e1rios: ";
            for (int i = 0; i < usuarios.size(); ++i) {
                if (lista.contains((CharSequence)usuarios.get(i))) continue;
                if (i > 0 && !lista.contains((CharSequence)usuarios.get(i))) {
                    lista = lista + ", ";
                }
                lista = lista + (String)usuarios.get(i);
            }
            String msg = "O arquivo n\u00e3o pode ser gerado.";
            msg = msg + "\nExistem resultados conferidos por profissionais n\u00e3o configurados na integra\u00e7\u00e3o.";
            msg = msg + lista;
            Funcoes.mensagem((Component)owner, msg, 2);
        } else {
            int codigoSequencial = saveDao.getSequencial();
            String path = StringUtil.getValor(xmlConfiguracao, "pastaLocal");
            while (!Funcoes.diretorioExiste(path)) {
                JFileChooser file = ComponenteFactory.novoJFileChooser();
                file.setFileSelectionMode(1);
                if (file.showSaveDialog(Laboratorio.getInstancia()) != 0) continue;
                path = file.getSelectedFile().getAbsolutePath();
            }
            String arquivo = Funcoes.formataData("yyMMdd", new java.util.Date());
            String fatura = Funcoes.preencheZero(codigoSequencial, 6);
            arquivo = path + File.separator + arquivo + fatura;
            if (!arquivo.toLowerCase().endsWith(".csv")) {
                arquivo = arquivo + ".csv";
                saveDao.insereIntegracaoSave(Integer.parseInt(Variaveis.filialPadrao), codigoSequencial);
                for (Registro registro : listaExames) {
                    saveDao.insereIntegracaoSaveExameRequisicao(registro.getInt("fil_codigo"), Integer.parseInt(Variaveis.filialPadrao), codigoSequencial, registro.getString("exa_codigo"), registro.getInt("mco_codigo"), registro.getInt("req_codigo"));
                }
                StringUtil.escreverArquivoTexto(arquivo, buf.toString());
                StringBuilder mensagem = new StringBuilder("Arquivo criado com sucesso.\n");
                mensagem.append(arquivo);
                Funcoes.mensagem((Component)owner, mensagem.toString(), 2);
            }
        }
    }

    private String getCodigoUsuarioSave(String codigoUsuario, String xmlConfiguracao) {
        String usuarios = StringUtil.getValor(xmlConfiguracao, "listaUsuarios");
        String[] listaUsuarios = usuarios.split("usuariosSave");
        for (int i = 0; i < listaUsuarios.length; ++i) {
            String usuarioSave = listaUsuarios[i];
            if (!(usuarioSave = StringUtil.getValor(usuarioSave, "usuarioSave")).equalsIgnoreCase(codigoUsuario)) continue;
            String codigoSave = StringUtil.getValor(listaUsuarios[i], "codigoSave");
            return codigoSave;
        }
        return "";
    }
}

