/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico.save;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.util.Funcoes;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SaveDao {
    public ResultSet buscaExamesRequisicao(Integer codigoFilial, Integer codigoRequisicao, String filtroExames) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        buf.append("      req.fil_codigo ");
        buf.append("      ,req.req_codigo ");
        buf.append("      ,req.req_tipoatendimentosave ");
        buf.append("      ,req.req_codigoatendimentosave ");
        buf.append("      ,req.req_centrocustosave ");
        buf.append("      ,req.req_data ");
        buf.append("      ,req.req_hora ");
        buf.append("      ,exr.usr_codigo ");
        buf.append("      ,exr.exr_ordem ");
        buf.append("      ,exr.exr_dataassina ");
        buf.append("      ,exr.usr_codassina ");
        buf.append("      ,con.con_faturaeletronica ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("      ,n.dtm_codamb as dtp_codamb ");
        } else {
            buf.append("      ,n.dtp_codamb ");
        }
        buf.append("      ,exr.exa_codigo ");
        buf.append("      ,mco.mco_codigo ");
        buf.append("      ,mco.mco_abreviatura ");
        buf.append("      ,exa.exa_descricao ");
        buf.append("      ,exr.exr_situacao ");
        buf.append("  from requisicao req ");
        buf.append("  left join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("  left join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("  left join filiais_postocoleta fil on req.fil_codigo = fil.fil_codigo ");
        buf.append("  left join materialcoleta mco on exr.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo ");
        buf.append("  left join exames exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("  left join detalhetabelaprecometodologia n on exr.fil_codigo = n.fil_codigo and exr.exa_codigo = n.exa_codigo and exr.mco_codigo = n.mco_codigo and con.tpe_codigo = n.tpe_codigo and exr.met_codigo = n.met_codigo ");
        } else {
            buf.append("  left join detalhetabelapreco n on exr.fil_codigo = n.fil_codigo and exr.exa_codigo = n.exa_codigo and exr.mco_codigo = n.mco_codigo and con.tpe_codigo = n.tpe_codigo ");
        }
        buf.append(" where req.fil_codigo = ").append(codigoFilial);
        buf.append("   and req.req_codigo = ").append(codigoRequisicao);
        if (!Funcoes.textoVazio(filtroExames)) {
            buf.append("  and ").append(filtroExames);
        }
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        return rs;
    }

    public int getSequencial() throws SQLException {
        int codigoSequencial = 0;
        StringBuilder buf = new StringBuilder();
        buf.append("select nextval('integracaosave_").append(Variaveis.filialPadrao).append("_sequence') as sequencia");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            codigoSequencial = rs.getInt("sequencia");
        }
        return codigoSequencial;
    }

    public void insereIntegracaoSave(int codigoFilialExportando, int codigoSequencial) throws SQLException {
        PreparedStatement preparedStatement = Conexao.getPreparedStatement("insert into integracaosave values(?, ?, now(), ?);");
        preparedStatement.setInt(1, codigoFilialExportando);
        preparedStatement.setInt(2, codigoSequencial);
        preparedStatement.setString(3, Variaveis.login);
        preparedStatement.execute();
        preparedStatement.close();
    }

    public void insereIntegracaoSaveExameRequisicao(int codigoFilialExame, int codigoFilialExportando, int codigoSequencial, String codigoExame, int codigoMatColeta, int codigoRequisicao) throws SQLException {
        PreparedStatement preparedStatement = Conexao.getPreparedStatement("insert into integracaosaveexamerequisicao values(?, ?, ?, ?, ?, ?);");
        preparedStatement.setInt(1, codigoFilialExame);
        preparedStatement.setInt(2, codigoFilialExportando);
        preparedStatement.setInt(3, codigoSequencial);
        preparedStatement.setString(4, codigoExame);
        preparedStatement.setInt(5, codigoMatColeta);
        preparedStatement.setInt(6, codigoRequisicao);
        preparedStatement.execute();
        preparedStatement.close();
    }
}

