/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico.save;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.util.faturamento.eletronico.save.DadosAdicionaisSave;
import jalis.laboratorio.util.faturamento.eletronico.save.TipoAtendimentoSave;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class InfoDadosAdicionaisSave
extends AbstractDialogoOKCancelar {
    private static final String titulo = "Dados adicionais Save";
    private JLabel labelTipoAtendimento = new JLabel("Tipo Atendimento:");
    private JComboBox comboTipoAtendimento = ComponenteFactory.novoJComboBox(new Object[]{"Selecione", TipoAtendimentoSave.INTERNACAO.getDescricao(), TipoAtendimentoSave.AMBULATORIAL.getDescricao(), TipoAtendimentoSave.URGENCIA.getDescricao(), TipoAtendimentoSave.EXTERNOS.getDescricao()});
    private JLabel labelCodigoAtendimento = new JLabel("C\u00f3d. Atendimento:");
    private TTextField textAtendimento = new TTextField(10, 1);
    private JLabel labelCentroCusto = new JLabel("Centro de custo:");
    private TTextField textCentroCusto = new TTextField(3, 1);
    private DadosAdicionaisSave dadosAdicionais;

    public static InfoDadosAdicionaisSave novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new InfoDadosAdicionaisSave((Frame)pai, titulo);
        }
        return new InfoDadosAdicionaisSave((Dialog)pai, titulo);
    }

    public InfoDadosAdicionaisSave(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public InfoDadosAdicionaisSave(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(270, 130));
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone16x16.png").getImage());
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.comboTipoAtendimento.setPreferredSize(new Dimension(150, 20));
        this.comboTipoAtendimento.setSelectedIndex(0);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(1, 0, 1, 0);
        this.getPanelCentral().add((Component)this.labelTipoAtendimento, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.comboTipoAtendimento, c);
        c.gridx = 0;
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelCodigoAtendimento, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.textAtendimento, c);
        c.gridx = 0;
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelCentroCusto, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.textCentroCusto, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            if (this.validaCampos()) {
                this.dadosAdicionais = new DadosAdicionaisSave();
                this.dadosAdicionais.setCentroCusto(this.textCentroCusto.getText());
                this.dadosAdicionais.setCodigoAtendimento(this.textAtendimento.getText());
                this.dadosAdicionais.setTipoAtendimento(TipoAtendimentoSave.setDescricao(this.comboTipoAtendimento.getSelectedItem().toString()));
                this.ok = true;
                this.dispose();
            }
        } else if (e.getSource() == this.buttonCancelar) {
            this.dispose();
        }
    }

    private boolean validaCampos() {
        if (this.comboTipoAtendimento.getSelectedIndex() == 0) {
            Funcoes.mensagem(this, "O tipo de atendimento da solicita\u00e7\u00e3o deve ser informado.", 1);
            ScreenUtil.requisitarFoco(this.comboTipoAtendimento);
            return false;
        }
        if (Funcoes.textoVazio(this.textAtendimento)) {
            Funcoes.mensagem(this, "O c\u00f3digo de atendimento da solicita\u00e7\u00e3o deve ser informado.", 1);
            ScreenUtil.requisitarFoco(this.textAtendimento);
            return false;
        }
        if (Funcoes.textoVazio(this.textCentroCusto)) {
            Funcoes.mensagem(this, "O c\u00f3digo do centro de custo da solicita\u00e7\u00e3o deve ser informado.", 1);
            ScreenUtil.requisitarFoco(this.textCentroCusto);
            return false;
        }
        return true;
    }

    public DadosAdicionaisSave getDadosAdicionais() {
        return this.dadosAdicionais;
    }

    public void setDadosAdicionais(DadosAdicionaisSave dadosAdicionais) {
        this.dadosAdicionais = dadosAdicionais;
        if (dadosAdicionais != null) {
            this.textAtendimento.setText(dadosAdicionais.getCodigoAtendimento());
            this.comboTipoAtendimento.setSelectedItem(dadosAdicionais.getTipoAtendimento().getDescricao());
            this.textCentroCusto.setText(dadosAdicionais.getCentroCusto());
        }
    }
}

