/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico.save;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.Save;
import jalis.laboratorio.util.faturamento.eletronico.save.UsuarioSave;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class ConfigurarSave
extends AbstractDialogoOKCancelar
implements ActionListener {
    public static String titulo = "Configurando SAVE";
    private static final Integer COLUNA_CODIGO = 0;
    private static final Integer COLUNA_NOME = 1;
    private static final Integer COLUNA_CODIGOSAVE = 2;
    private JLabel labelCodigoPrestador = new JLabel("C\u00f3digo Prestador:");
    private TTextField textPrestador = new TTextField(5, 1);
    private JLabel labelPastaLocal = new JLabel("Pasta local do arquivo:");
    private TTextField textPastaLocal = new TTextField(50, 3);
    private JButton buttonBuscaPasta = ComponenteFactory.novoJButton("...", 'L', this);
    private JPanel panelProfissional = new JPanel();
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio");
    private TTextField textUsuario = new TTextField(50, 3);
    private JButton buttonBuscaUsuario = ComponenteFactory.novoJButton("", 'L', this);
    private JLabel labelNome = new JLabel("Nome");
    private TTextField textNome = new TTextField(50, 3);
    private JLabel labelCodigoSave = new JLabel("C\u00f3digo no Save");
    private TTextField textCodigoSave = new TTextField(3, 1);
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", 'L', this);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Usu\u00e1rio", "Nome", "C\u00f3digo Save"});
    private JTable tableUsuario = new JTable(this.modelo);
    private List<UsuarioSave> listaUsuarios = new ArrayList<UsuarioSave>();
    private String xml;

    public static ConfigurarSave novaInstancia(Object frame) {
        if (frame instanceof Frame) {
            return new ConfigurarSave((Frame)frame, titulo);
        }
        return new ConfigurarSave((Dialog)frame, titulo);
    }

    public ConfigurarSave(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public ConfigurarSave(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(460, 340));
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone16x16.png").getImage());
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.buttonBuscaUsuario.setFocusable(false);
        this.textNome.setFocusable(false);
        this.getBotaoOK().setText("Salvar");
        this.getBotaoOK().setMnemonic('S');
        this.textPrestador.setPreferredSize(new Dimension(200, 20));
        this.buttonBuscaPasta.setPreferredSize(new Dimension(30, 18));
        this.textPastaLocal.setPreferredSize(new Dimension(230, 20));
        this.panelProfissional.setBorder(new TitledBorder("Profissionais"));
        this.buttonBuscaUsuario.setPreferredSize(new Dimension(30, 18));
        this.buttonOK.setPreferredSize(new Dimension(40, 18));
        this.textUsuario.setPreferredSize(new Dimension(60, 20));
        this.textNome.setPreferredSize(new Dimension(170, 20));
        this.textNome.setEditable(false);
        this.textCodigoSave.setPreferredSize(new Dimension(80, 20));
        this.modelo.setColumnSize(new int[]{70, 0, 100}, this.tableUsuario);
        Funcoes.imagemPesquisa(this.buttonBuscaUsuario);
        JScrollPane scroll = new JScrollPane(this.tableUsuario);
        scroll.setPreferredSize(new Dimension(180, 150));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.labelCodigoPrestador, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.getPanelCentral().add((Component)this.textPrestador, c);
        c.gridx = 0;
        c.gridwidth = 1;
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelPastaLocal, c);
        ++c.gridx;
        c.gridwidth = 1;
        this.getPanelCentral().add((Component)this.textPastaLocal, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.buttonBuscaPasta, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        this.getPanelCentral().add((Component)this.panelProfissional, c);
        this.panelProfissional.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 1, 0, 0);
        this.panelProfissional.add((Component)this.labelUsuario, c);
        c.gridx += 2;
        this.panelProfissional.add((Component)this.labelNome, c);
        ++c.gridx;
        this.panelProfissional.add((Component)this.labelCodigoSave, c);
        c.gridx = 0;
        ++c.gridy;
        this.panelProfissional.add((Component)this.textUsuario, c);
        ++c.gridx;
        this.panelProfissional.add((Component)this.buttonBuscaUsuario, c);
        ++c.gridx;
        this.panelProfissional.add((Component)this.textNome, c);
        ++c.gridx;
        this.panelProfissional.add((Component)this.textCodigoSave, c);
        ++c.gridx;
        this.panelProfissional.add((Component)this.buttonOK, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 5;
        this.panelProfissional.add((Component)scroll, c);
        this.montaListener();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaUsuario) {
            this.buscarUsuario();
        } else if (e.getSource() == this.buttonCancelar) {
            this.dispose();
        } else if (e.getSource() == this.buttonOK) {
            this.adicionarUsuario();
        } else if (e.getSource() == this.buttonBuscaPasta) {
            this.selecionaPasta();
        } else if (e.getSource() == this.getBotaoOK() && this.validaCampos()) {
            this.ok = true;
            this.dispose();
        }
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.textPrestador.getText())) {
            Funcoes.mensagem(this, "C\u00f3digo do Prestador n\u00e3o informado.", 1);
            ScreenUtil.requisitarFoco(this.textPrestador);
            return false;
        }
        if (Funcoes.textoVazio(this.textPastaLocal.getText())) {
            Funcoes.mensagem(this, "Pasta local n\u00e3o informado.", 1);
            ScreenUtil.requisitarFoco(this.textPastaLocal);
            return false;
        }
        if (this.modelo.getRowCount() == 0) {
            Funcoes.mensagem(this, "Nenhum usu\u00e1rio informado.", 1);
            ScreenUtil.requisitarFoco(this.textUsuario);
            return false;
        }
        return true;
    }

    private void montaListener() {
        this.textUsuario.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConfigurarSave.this.buscarUsuario();
                }
            }
        });
        this.textUsuario.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ConfigurarSave.this.selecionaUsuario();
            }
        });
        this.tableUsuario.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 2 && (row = ConfigurarSave.this.tableUsuario.getSelectedRow()) >= 0) {
                    String codigoUsuario = ConfigurarSave.this.modelo.getValueAt(row, 0).toString();
                    String nomeUsuario = ConfigurarSave.this.modelo.getValueAt(row, 1).toString();
                    String codigoSave = ConfigurarSave.this.modelo.getValueAt(row, 2).toString();
                    ConfigurarSave.this.textUsuario.setText(codigoUsuario);
                    ConfigurarSave.this.textNome.setText(nomeUsuario);
                    ConfigurarSave.this.textCodigoSave.setText(codigoSave);
                }
            }
        });
        this.tableUsuario.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (e.getKeyCode() == 127) {
                    int resp;
                    int row2 = ((JTable)e.getSource()).getSelectedRow();
                    if (row2 >= 0 && (resp = Funcoes.mensagem(Laboratorio.getInstancia(), "Deseja excluir o registro selecionado?", 4)) == 0) {
                        String codigoUsuario = (String)ConfigurarSave.this.modelo.getValueAt(row2, COLUNA_CODIGO);
                        ConfigurarSave.this.modelo.removeLine(row2);
                        UsuarioSave usuarioSave = null;
                        for (UsuarioSave usrSave : ConfigurarSave.this.listaUsuarios) {
                            if (usuarioSave == null || !usrSave.equals(usuarioSave)) continue;
                            usuarioSave = usrSave;
                            break;
                        }
                        ConfigurarSave.this.listaUsuarios.remove(usuarioSave);
                    }
                } else if (e.getKeyCode() == 32 && (row = ConfigurarSave.this.tableUsuario.getSelectedRow()) >= 0) {
                    String codigoUsuario = ConfigurarSave.this.modelo.getValueAt(row, 0).toString();
                    String nomeUsuario = ConfigurarSave.this.modelo.getValueAt(row, 1).toString();
                    String codigoSave = ConfigurarSave.this.modelo.getValueAt(row, 2).toString();
                    ConfigurarSave.this.textUsuario.setText(codigoUsuario);
                    ConfigurarSave.this.textNome.setText(nomeUsuario);
                    ConfigurarSave.this.textCodigoSave.setText(codigoSave);
                }
            }
        });
    }

    private void adicionarUsuario() {
        if (Funcoes.textoVazio(this.textNome)) {
            Funcoes.mensagem(this, "O c\u00f3digo de usu\u00e1rio deve ser informado.", 1);
            ScreenUtil.requisitarFoco(this.textUsuario);
            return;
        }
        if (Funcoes.textoVazio(this.textCodigoSave)) {
            Funcoes.mensagem(this, "O c\u00f3digo de cadastro no sistema Save deve ser informado", 1);
            ScreenUtil.requisitarFoco(this.textCodigoSave);
            return;
        }
        boolean inclusao = true;
        block0: for (int i = 0; i < this.tableUsuario.getRowCount(); ++i) {
            String usuario = (String)this.tableUsuario.getValueAt(i, COLUNA_CODIGO);
            if (!this.textUsuario.getText().equals(usuario)) continue;
            this.modelo.setValueAt(this.textCodigoSave.getText(), i, COLUNA_CODIGOSAVE);
            for (int j = 0; j < this.listaUsuarios.size(); ++j) {
                UsuarioSave usuarioSave = this.listaUsuarios.get(i);
                if (!usuarioSave.getCodigoUsuario().equals(usuario)) continue;
                usuarioSave.setCodigoSave(this.textCodigoSave.getText());
                this.listaUsuarios.set(i, usuarioSave);
                inclusao = false;
                continue block0;
            }
        }
        if (inclusao) {
            this.adicionarTabela();
        }
        this.limpaPanelProfissional();
    }

    private void adicionarTabela() {
        UsuarioSave usuarioSave = new UsuarioSave();
        usuarioSave.setCodigoSave(this.textCodigoSave.getText());
        usuarioSave.setCodigoUsuario(this.textUsuario.getText());
        usuarioSave.setNomeUsuario(this.textNome.getText());
        this.listaUsuarios.add(usuarioSave);
        this.modelo.addLine(new String[]{usuarioSave.getCodigoUsuario(), usuarioSave.getNomeUsuario(), usuarioSave.getCodigoSave()});
    }

    private void limpaPanelProfissional() {
        this.textUsuario.clear();
        this.textNome.clear();
        this.textCodigoSave.clear();
        ScreenUtil.requisitarFoco(this.textUsuario);
    }

    private void selecionaUsuario() {
        Statement st;
        if (this.textUsuario.getText().trim().length() > 0 && (st = Conexao.getStatement()) != null) {
            try {
                ResultSet rs = Conexao.executeQuery(st, "select usr_codigo, usr_nome from usuario where  upper(usr_codigo)=upper(" + this.textUsuario.getTextDBEscape() + ") ");
                if (rs.next()) {
                    this.textNome.setText(rs.getString("usr_nome"));
                    this.textUsuario.setText(rs.getString("usr_codigo"));
                } else {
                    this.labelNome.setText("N\u00e3o cadastrado");
                }
            }
            catch (SQLException sqlex) {
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
            }
        }
    }

    private void selecionaPasta() {
        String path = "";
        JFileChooser file = ComponenteFactory.novoJFileChooser();
        file.setFileSelectionMode(1);
        if (file.showSaveDialog(this) == 0) {
            path = file.getSelectedFile().getAbsolutePath();
        }
        if (!Funcoes.textoVazio(path)) {
            this.textPastaLocal.setText(path);
        }
    }

    private void buscarUsuario() {
        Hashtable resultado = Pesquisas.usuario(this, true);
        if (resultado != null) {
            this.textUsuario.setText(resultado.get("usr_codigo").toString());
        }
        this.textUsuario.requestFocus();
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder("<faturamentoEletronico>");
        xml.append("<").append("protocolo").append(">");
        xml.append(Save.getNomeProtocolo());
        xml.append("</").append("protocolo").append(">");
        xml.append("<").append("codigoPrestador").append(">");
        xml.append(this.textPrestador.getText());
        xml.append("</").append("codigoPrestador").append(">");
        xml.append("<").append("pastaLocal").append(">");
        xml.append(this.textPastaLocal.getText());
        xml.append("</").append("pastaLocal").append(">");
        xml.append("<").append("listaUsuarios").append(">");
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String codigoSave;
            String nome;
            String usuario = (String)this.tableUsuario.getValueAt(i, COLUNA_CODIGO);
            xml.append("<").append("usuariosSave").append(">");
            if (!Funcoes.textoVazio(usuario)) {
                xml.append("<").append("usuarioSave").append(">");
                xml.append(usuario);
                xml.append("</").append("usuarioSave").append(">");
            }
            if (!Funcoes.textoVazio(nome = (String)this.tableUsuario.getValueAt(i, COLUNA_NOME))) {
                xml.append("<").append("nomeUsuarioSave").append(">");
                xml.append(nome);
                xml.append("</").append("nomeUsuarioSave").append(">");
            }
            if (!Funcoes.textoVazio(codigoSave = (String)this.tableUsuario.getValueAt(i, COLUNA_CODIGOSAVE))) {
                xml.append("<").append("codigoSave").append(">");
                xml.append(codigoSave);
                xml.append("</").append("codigoSave").append(">");
            }
            xml.append("</").append("usuariosSave").append(">");
        }
        xml.append("</").append("listaUsuarios").append(">");
        xml.append("</faturamentoEletronico>");
        return xml.toString();
    }

    public void setXml(String xml) {
        this.xml = xml;
        if (!Funcoes.textoVazio(xml)) {
            this.textPrestador.setText(StringUtil.getValor(xml, "codigoPrestador"));
            String pasta = StringUtil.getValor(xml, "pastaLocal");
            pasta = pasta.replaceAll("\\\\+", Matcher.quoteReplacement("\\"));
            this.textPastaLocal.setText(pasta);
            String usuarios = StringUtil.getValor(xml, "listaUsuarios");
            String[] listUsuarios = usuarios.split("usuariosSave");
            for (int i = 0; i < listUsuarios.length; ++i) {
                String usuario = listUsuarios[i];
                String usr = StringUtil.getValor(usuario, "usuarioSave");
                String nome = StringUtil.getValor(usuario, "nomeUsuarioSave");
                String codigoSave = StringUtil.getValor(usuario, "codigoSave");
                if (Funcoes.textoVazio(usr)) continue;
                UsuarioSave usuarioSave = new UsuarioSave();
                usuarioSave.setCodigoSave(codigoSave);
                usuarioSave.setCodigoUsuario(usr);
                usuarioSave.setNomeUsuario(nome);
                this.listaUsuarios.add(usuarioSave);
                this.modelo.addLine(new String[]{usr, nome, codigoSave});
            }
        }
    }
}

