/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico.bpa;

import jalis.laboratorio.util.faturamento.eletronico.bpa.DadosLinha;
import jalis.laboratorio.util.faturamento.eletronico.bpa.OrgaoDestino;
import jalis.laboratorio.util.faturamento.eletronico.bpa.Raca;
import jalis.laboratorio.util.faturamento.eletronico.bpa.TipoBPA;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class DadosHeader {
    private static final int LINHAS_POR_FOLHA = 99;
    private int anoProducao = 0;
    private int mesProducao = 0;
    private String nomeOrgaoOrigem = "";
    private String siglaOrgaoOrigem = "";
    private String cnpjResponsavel = "";
    private String nomeDestino = "";
    private OrgaoDestino orgaoDestino = OrgaoDestino.ESTADUAL;
    private String cnesRealizante;
    private String cnsProfissional;
    StringBuilder linha = new StringBuilder();

    public int getAnoProducao() {
        return this.anoProducao;
    }

    public void setAnoProducao(int anoProducao) {
        this.anoProducao = anoProducao;
    }

    public int getMesProducao() {
        return this.mesProducao;
    }

    public void setMesProducao(int mesProducao) {
        this.mesProducao = mesProducao;
    }

    public String getNomeOrgaoOrigem() {
        return this.nomeOrgaoOrigem;
    }

    public void setNomeOrgaoOrigem(String nomeOrgaoOrigem) {
        this.nomeOrgaoOrigem = nomeOrgaoOrigem;
    }

    public String getSiglaOrgaoOrigem() {
        return this.siglaOrgaoOrigem;
    }

    public void setSiglaOrgaoOrigem(String siglaOrgaoOrigem) {
        this.siglaOrgaoOrigem = siglaOrgaoOrigem;
    }

    public String getCnpjResponsavel() {
        return this.cnpjResponsavel;
    }

    public void setCnpjResponsavel(String cnpjResponsavel) {
        this.cnpjResponsavel = cnpjResponsavel;
    }

    public String getNomeDestino() {
        return this.nomeDestino;
    }

    public void setNomeDestino(String nomeDestino) {
        this.nomeDestino = nomeDestino;
    }

    public OrgaoDestino getOrgaoDestino() {
        return this.orgaoDestino;
    }

    public void setOrgaoDestino(OrgaoDestino orgaoDestino) {
        this.orgaoDestino = orgaoDestino;
    }

    public String getCnesRealizante() {
        return this.cnesRealizante;
    }

    public void setCnesRealizante(String cnesRealizante) {
        this.cnesRealizante = cnesRealizante;
    }

    public String getCnsProfissional() {
        return this.cnsProfissional;
    }

    public void setCnsProfissional(String cnsProfissional) {
        this.cnsProfissional = cnsProfissional;
    }

    public String gerarLinha(ArrayList<DadosLinha> linhas) {
        StringBuilder linha = new StringBuilder();
        linha.append("01");
        linha.append("#BPA#");
        linha.append(Funcoes.preencheZero(this.anoProducao, 4)).append(Funcoes.preencheZero(this.mesProducao, 2));
        linha.append(Funcoes.preencheZero(linhas.size(), 6));
        int qtdeFolhas = linhas.size() / 99;
        if (linhas.size() % 99 > 0) {
            ++qtdeFolhas;
        }
        linha.append(Funcoes.preencheZero(qtdeFolhas, 6));
        linha.append(Funcoes.preencheZero(this.gerarVerificador(linhas), 4));
        linha.append(Funcoes.preencheVazio(this.nomeOrgaoOrigem, 30, 2));
        linha.append(Funcoes.preencheVazio(this.siglaOrgaoOrigem, 6, 2));
        linha.append(Funcoes.preencheZero(StringUtil.limpaString(this.cnpjResponsavel, new String[]{".", ",", "/", "-"}), 14));
        linha.append(Funcoes.preencheVazio(this.nomeDestino, 40, 2));
        linha.append(this.orgaoDestino.getSigla());
        linha.append("Jalis     ");
        linha.append("\n");
        return linha.toString();
    }

    public ArrayList<String> validarDados(ArrayList<DadosLinha> linhas) {
        ArrayList<String> retorno = new ArrayList<String>();
        if (this.anoProducao <= 0 || this.mesProducao <= 0) {
            retorno.add("Ano ou m\u00eas de produ\u00e7\u00e3o incorretos");
        }
        if (linhas == null || linhas.isEmpty()) {
            retorno.add("Nenhum procedimento foi adicionado");
        }
        return retorno;
    }

    private int gerarVerificador(ArrayList<DadosLinha> linhas) {
        int soma = 0;
        for (DadosLinha d : linhas) {
            soma = (int)((long)soma + (d.getCodigoProcedimento() + (long)d.getQuantidade()));
        }
        int resto = soma % 1111;
        return resto + 1111;
    }

    public String gerarLinhasExames(ArrayList<DadosLinha> linhas) {
        StringBuilder buf = new StringBuilder();
        Collections.sort(linhas, new Comparator<DadosLinha>(){

            @Override
            public int compare(DadosLinha o1, DadosLinha o2) {
                if (o1 != null && o2 != null) {
                    String descricao1 = "";
                    String descricao2 = "";
                    if (o1.getTipo().getSigla().equals(TipoBPA.INDIVIDUALIZADO.getSigla())) {
                        descricao1 = o1.getCnsPaciente();
                    }
                    if (o2.getTipo().getSigla().equals(TipoBPA.INDIVIDUALIZADO.getSigla())) {
                        descricao2 = o2.getCnsPaciente();
                    }
                    String filreq1 = Funcoes.preencheZero(o1.getFilial(), 3) + Funcoes.preencheZero(o1.getRequisicao(), 8);
                    String filreq2 = Funcoes.preencheZero(o2.getFilial(), 3) + Funcoes.preencheZero(o2.getRequisicao(), 8);
                    return Long.compare(Long.parseLong(filreq1), Long.parseLong(filreq2)) + o1.getTipo().getSigla().compareTo(o2.getTipo().getSigla()) + new Long(o1.getCodigoProcedimento()).compareTo(new Long(o2.getCodigoProcedimento()));
                }
                return 0;
            }
        });
        int folha = 1;
        int sequenciaFolha = 1;
        for (DadosLinha linha : linhas) {
            linha.setFolha(folha);
            linha.setSequencialFolha(sequenciaFolha++);
            if (sequenciaFolha <= 99) continue;
            ++folha;
            sequenciaFolha = 1;
        }
        for (DadosLinha linha : linhas) {
            if (linha.getTipo().getSigla().equals(TipoBPA.CONSOLIDADO.getSigla())) {
                buf.append(this.geraLinhaConsolidada(linha));
                continue;
            }
            if (!linha.getTipo().getSigla().equals(TipoBPA.INDIVIDUALIZADO.getSigla())) continue;
            buf.append(this.geraLinhaIndividualizada(linha));
        }
        return buf.toString();
    }

    private String geraLinhaConsolidada(DadosLinha linha) {
        StringBuilder buf = new StringBuilder();
        buf.append("02");
        buf.append(Funcoes.preencheZero(this.cnesRealizante, 7));
        buf.append(Funcoes.preencheZero(this.anoProducao, 4)).append(Funcoes.preencheZero(this.mesProducao, 2));
        buf.append(Funcoes.preencheVazio(linha.getCodigoCBO(), 6, 2));
        buf.append(Funcoes.preencheZero(linha.getFolha(), 3));
        buf.append(Funcoes.preencheZero(linha.getSequencialFolha(), 2));
        buf.append(Funcoes.preencheZero(linha.getCodigoProcedimento(), 10));
        buf.append(Funcoes.preencheZero(linha.getIdade(), 3));
        buf.append(Funcoes.preencheZero(linha.getQuantidade(), 6));
        buf.append(linha.getOrigemInformacoes().getSigla());
        buf.append("\n");
        return buf.toString();
    }

    private String geraLinhaIndividualizada(DadosLinha linha) {
        StringBuilder buf = new StringBuilder();
        buf.append("03");
        buf.append(Funcoes.preencheZero(this.cnesRealizante, 7));
        buf.append(Funcoes.preencheZero(this.anoProducao, 4)).append(Funcoes.preencheZero(this.mesProducao, 2));
        buf.append(Funcoes.preencheVazio(this.cnsProfissional, 15, 2));
        buf.append(Funcoes.preencheVazio(linha.getCodigoCBO(), 6, 2));
        buf.append(Funcoes.preencheVazio(linha.getDataAtendimento() != null ? Funcoes.formataData("yyyyMMdd", linha.getDataAtendimento()) : "", 8, 2));
        buf.append(Funcoes.preencheZero(linha.getFolha(), 3));
        buf.append(Funcoes.preencheZero(linha.getSequencialFolha(), 2));
        buf.append(Funcoes.preencheZero(linha.getCodigoProcedimento(), 10));
        buf.append(Funcoes.preencheVazio(!Funcoes.textoVazio(linha.getCnsPaciente()) ? linha.getCnsPaciente() : "", 15, 2));
        buf.append(linha.getSexoPaciente());
        buf.append(Funcoes.preencheVazio(!Funcoes.textoVazio(linha.getIbgeCidadePaciente()) ? linha.getIbgeCidadePaciente() : "", 6, 2));
        buf.append(Funcoes.preencheVazio(!Funcoes.textoVazio(linha.getCid10()) ? StringUtil.limpaString(linha.getCid10(), new String[]{".", "-"}) : "", 4, 2));
        buf.append(linha.getIdade() >= 0 && linha.getIdade() <= 130 ? Funcoes.preencheZero(linha.getIdade(), 3) : "000");
        buf.append(Funcoes.preencheZero(linha.getQuantidade(), 6));
        buf.append(Funcoes.preencheZero(!Funcoes.textoVazio(linha.getCaraterAtendimento()) ? linha.getCaraterAtendimento() : "", 2));
        buf.append(Funcoes.preencheVazio(!Funcoes.textoVazio(linha.getAutorizacaoEstabelecimento()) ? linha.getAutorizacaoEstabelecimento() : "", 13, 2));
        buf.append(linha.getOrigemInformacoes().getSigla());
        buf.append(linha.getNomePaciente().length() > 30 ? linha.getNomePaciente().substring(0, 30) : Funcoes.preencheVazio(linha.getNomePaciente(), 30, 2));
        buf.append(linha.getDataNascimentoPaciente() != null ? Funcoes.formataData("yyyyMMdd", linha.getDataNascimentoPaciente()) : "        ");
        buf.append(linha.getRacaPaciente().getSigla());
        buf.append(!linha.getRacaPaciente().getSigla().equals(Raca.INDIGENA.getSigla()) ? "    " : Funcoes.preencheZero(linha.getEtniaPaciente(), 4));
        buf.append(linha.getNacionalidadePaciente() > 0 ? Funcoes.preencheZero(linha.getNacionalidadePaciente(), 3) : "010");
        buf.append(linha.getCodigoServico() > 0 ? Funcoes.preencheZero(linha.getCodigoServico(), 3) : "   ");
        buf.append(linha.getClassificacaoServico() > 0 ? Funcoes.preencheZero(linha.getClassificacaoServico(), 3) : "   ");
        buf.append(linha.getSequenciaEquipe() > 0 ? Funcoes.preencheZero(linha.getSequenciaEquipe(), 8) : "        ");
        buf.append(linha.getCodigoAreaEquipe() > 0 ? Funcoes.preencheZero(linha.getCodigoAreaEquipe(), 4) : "    ");
        buf.append(!Funcoes.textoVazio(linha.getCnpjOPM()) ? StringUtil.limpaString(linha.getCnpjOPM(), new String[]{".", ",", "/", "-"}) : Funcoes.preencheVazio("", 14, 2));
        buf.append(!Funcoes.textoVazio(linha.getCepPaciente()) ? StringUtil.limpaString(linha.getCepPaciente(), new String[]{".", "-"}) : Funcoes.preencheVazio("", 8, 2));
        buf.append(!Funcoes.textoVazio(linha.getLogradouroPaciente()) ? Funcoes.preencheZero(linha.getLogradouroPaciente(), 3) : Funcoes.preencheVazio("", 3, 2));
        buf.append(!Funcoes.textoVazio(linha.getEnderecoPaciente()) ? (linha.getEnderecoPaciente().length() > 30 ? linha.getEnderecoPaciente().substring(0, 30) : Funcoes.preencheVazio(linha.getEnderecoPaciente(), 30, 2)) : "");
        buf.append(!Funcoes.textoVazio(linha.getComplementoPaciente()) ? (linha.getComplementoPaciente().length() > 10 ? linha.getComplementoPaciente().substring(0, 10) : Funcoes.preencheVazio(linha.getComplementoPaciente(), 10, 2)) : Funcoes.preencheVazio(linha.getComplementoPaciente(), 10, 2));
        buf.append(!Funcoes.textoVazio(linha.getNumeroPaciente()) ? Funcoes.preencheVazio(linha.getNumeroPaciente(), 5, 2) : "SN/00");
        buf.append(!Funcoes.textoVazio(linha.getBairroPaciente()) ? (linha.getBairroPaciente().length() > 30 ? linha.getBairroPaciente().substring(0, 30) : Funcoes.preencheVazio(linha.getBairroPaciente(), 30, 2)) : "");
        buf.append(!Funcoes.textoVazio(linha.getTelefonePaciente()) ? Funcoes.preencheZero(Funcoes.cortaString(StringUtil.limpaString(linha.getTelefonePaciente(), new String[]{".", "-", "(", ")", " "}), 11), 11) : Funcoes.preencheVazio("", 11, 2));
        buf.append(!Funcoes.textoVazio(linha.getEmailPaciente()) ? (linha.getEmailPaciente().length() > 40 ? linha.getEmailPaciente().substring(0, 40) : Funcoes.preencheVazio(linha.getEmailPaciente(), 40, 2)) : "");
        buf.append(linha.getIdentificaoNacionalEquipe() > 0 ? Funcoes.preencheZero(linha.getIdentificaoNacionalEquipe(), 10) : "          ");
        buf.append("\n");
        return buf.toString();
    }
}

