/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico.bpa;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.cadastro.ServicosClassificacao;
import jalis.laboratorio.cadastro.ServicosClassificacaoModel;
import jalis.laboratorio.util.faturamento.eletronico.BPA;
import jalis.laboratorio.util.faturamento.eletronico.bpa.OrgaoDestino;
import jalis.util.ComponenteUtils;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ValidaDoc;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConfigurarBPA
extends AbstractDialogoOKCancelar
implements ActionListener {
    TTextField textAnoProducao = new TTextField(4, 1);
    TTextField textMesProducao = new TTextField(2, 1);
    TTextField textNomeDestino = new TTextField(30, 3);
    TTextField textCNPJResponsavel = new TTextField(18, 7);
    TTextField textNomeOrgaoOrigem = new TTextField(30);
    TTextField textSiglaOrgaoOrigem = new TTextField(6);
    TTextField textCnsProfissional = new TTextField(15, 1);
    TTextField textCBOPadrao = new TTextField(7);
    TTextField textCID10Padrao = new TTextField(5);
    JComboBox comboCaraterAtendimento = ComponenteFactory.novoJcomboBoxPopup(BPA.CARATER_ATENDIMENTO, 100, 0);
    JComboBox comboOrgaoDestino = ComponenteFactory.novoJcomboBoxPopup(new String[]{OrgaoDestino.ESTADUAL.toString(), OrgaoDestino.MUNICIPAL.toString()}, 100, 0);
    ArrayList<ServicosClassificacaoModel> arrayServicos = new ArrayList();
    ArrayList<Integer> arrayCodigoServicos = new ArrayList();
    ArrayList<ServicosClassificacaoModel> arrayServicosClassificacao = new ArrayList();
    Object[] arrayListaDadosAdicionais;
    private JLabel labelNomeDestino = new JLabel("Nome Destino:");
    private JLabel labelAno = new JLabel("Ano Produ\u00e7\u00e3o:");
    private JLabel labelMes = new JLabel("M\u00eas Produ\u00e7\u00e3o:");
    private JLabel labelCnpj = new JLabel("CNPJ Respons\u00e1vel:");
    private JLabel labelNomeOrgaoOrigem = new JLabel("Nome Org\u00e3o Origem:");
    private JLabel labelSiglaOrgaoOrigem = new JLabel("Sigla Org\u00e3o Origem:");
    private JLabel labelCns = new JLabel("CNS Profissional:");
    private JLabel labelCaraterAtendimento = new JLabel("Car\u00e1ter Atendimento");
    private JButton buttonServicosClassificacao = ComponenteFactory.novoJButton("Servi\u00e7os de Classifica\u00e7\u00e3o", 'L', this);
    private JCheckBox checkIgnorarCBOSMedico = new JCheckBox("Ignorar CBOS do M\u00e9dico e enviar CBO Executante");
    private JFrame teste;
    private boolean ok = false;

    public ConfigurarBPA(JFrame owner, Object[] arrayListaDadosAdicionais) {
        super((Frame)owner, "Configurando BPA");
        this.textCBOPadrao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.temNumero(ConfigurarBPA.this.textCBOPadrao.getText())) {
                    ConfigurarBPA.this.textCBOPadrao.clear();
                }
            }
        });
        this.teste = owner;
        this.arrayListaDadosAdicionais = arrayListaDadosAdicionais;
        this.setSize(new Dimension(420, 330));
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        ComponenteUtils.maskCBO("####.##", new TTextField[]{this.textCBOPadrao});
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConfigurarBPA.this.setVisible(false);
            }
        });
        this.carregaServicosClassificacao();
        this.carregaCodigosServicosClassificacao();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.labelNomeDestino, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelAno, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelMes, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelCnpj, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelNomeOrgaoOrigem, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelSiglaOrgaoOrigem, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelCns, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelCaraterAtendimento, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)new JLabel("CBO Executante:"), c);
        ++c.gridy;
        this.getPanelCentral().add((Component)new JLabel("CID10 Padr\u00e3o:"), c);
        ++c.gridy;
        this.getPanelCentral().add((Component)new JLabel("Org\u00e3o Destino:"), c);
        ++c.gridy;
        c.gridwidth = 2;
        this.getPanelCentral().add((Component)this.checkIgnorarCBOSMedico, c);
        c.gridy = 0;
        c.gridx = 1;
        c.weightx = 0.0;
        c.gridwidth = 3;
        c.fill = 2;
        this.textNomeDestino.setPreferredSize(new Dimension(180, 20));
        this.textNomeDestino.setMinimumSize(new Dimension(180, 20));
        this.getPanelCentral().add((Component)this.textNomeDestino, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.fill = 2;
        this.textAnoProducao.setPreferredSize(new Dimension(20, 20));
        this.textAnoProducao.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textAnoProducao, c);
        ++c.gridy;
        this.textMesProducao.setPreferredSize(new Dimension(20, 20));
        this.textMesProducao.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textMesProducao, c);
        ++c.gridy;
        this.textCNPJResponsavel.setPreferredSize(new Dimension(180, 20));
        this.textCNPJResponsavel.setMinimumSize(new Dimension(180, 20));
        this.getPanelCentral().add((Component)this.textCNPJResponsavel, c);
        ++c.gridy;
        this.textNomeOrgaoOrigem.setPreferredSize(new Dimension(180, 20));
        this.textNomeOrgaoOrigem.setMinimumSize(new Dimension(180, 20));
        this.getPanelCentral().add((Component)this.textNomeOrgaoOrigem, c);
        ++c.gridy;
        this.textSiglaOrgaoOrigem.setPreferredSize(new Dimension(20, 20));
        this.textSiglaOrgaoOrigem.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textSiglaOrgaoOrigem, c);
        ++c.gridy;
        this.textCnsProfissional.setPreferredSize(new Dimension(180, 20));
        this.textCnsProfissional.setMinimumSize(new Dimension(180, 20));
        this.getPanelCentral().add((Component)this.textCnsProfissional, c);
        ++c.gridy;
        this.comboCaraterAtendimento.setPreferredSize(new Dimension(180, 25));
        this.comboCaraterAtendimento.setMinimumSize(new Dimension(180, 25));
        this.getPanelCentral().add((Component)this.comboCaraterAtendimento, c);
        ++c.gridy;
        this.textCBOPadrao.setPreferredSize(new Dimension(180, 20));
        this.textCBOPadrao.setMinimumSize(new Dimension(180, 20));
        this.getPanelCentral().add((Component)this.textCBOPadrao, c);
        ++c.gridy;
        this.textCID10Padrao.setPreferredSize(new Dimension(180, 20));
        this.textCID10Padrao.setMinimumSize(new Dimension(180, 20));
        this.getPanelCentral().add((Component)this.textCID10Padrao, c);
        ++c.gridy;
        this.comboOrgaoDestino.setPreferredSize(new Dimension(180, 20));
        this.comboOrgaoDestino.setMinimumSize(new Dimension(180, 20));
        this.getPanelCentral().add((Component)this.comboOrgaoDestino, c);
        ++c.gridx;
        c.anchor = 13;
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.getPanelCentral().add((Component)new JLabel(), c);
        this.montaBotaoServicosClassificacao();
    }

    private void montaBotaoServicosClassificacao() {
        JPanel panelBotoes = this.getPanelBotoesDireita();
        panelBotoes.removeAll();
        panelBotoes.add(this.buttonServicosClassificacao);
        panelBotoes.add(this.buttonOK);
        panelBotoes.add(this.buttonCancelar);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.ok = e.getSource() == this.buttonOK;
        Object o = e.getSource();
        if (this.ok) {
            if (!this.validarCampos()) {
                return;
            }
            this.setVisible(false);
        } else if (o == this.buttonServicosClassificacao) {
            this.configurarServicosClassificacao();
        } else if (o == this.buttonCancelar) {
            this.setVisible(false);
        }
    }

    private boolean validarCampos() {
        if (this.cboPadraoObrigatorio()) {
            Funcoes.mensagem(this, "\u00c9 necess\u00e1rio informar o campo CBO Executante.", 2);
            ScreenUtil.requisitarFoco(this.textCBOPadrao);
            return false;
        }
        if (Funcoes.textoVazio(this.textAnoProducao.getText()) || Funcoes.textoVazio(this.textMesProducao)) {
            Funcoes.mensagem(this, "M\u00eas/Ano Produ\u00e7\u00e3o devem ser informados.", 2);
            ScreenUtil.requisitarFoco(this.textAnoProducao);
            return false;
        }
        if (Funcoes.textoVazio(this.textNomeDestino)) {
            Funcoes.mensagem(this, "Campo 'Nome Destino' \u00e9 obrigat\u00f3rio.", 2);
            ScreenUtil.requisitarFoco(this.textNomeDestino);
            return false;
        }
        if (this.cnpjValido()) {
            Funcoes.mensagem(this, "Campo CNPJ do Respons\u00e1vel inv\u00e1lido", 2);
            ScreenUtil.requisitarFoco(this.textCNPJResponsavel);
            return false;
        }
        if (Funcoes.textoVazio(this.textNomeOrgaoOrigem)) {
            Funcoes.mensagem(this, "Campo 'Nome Org\u00e3o Origem' \u00e9 obrigat\u00f3rio.", 2);
            ScreenUtil.requisitarFoco(this.textNomeOrgaoOrigem);
            return false;
        }
        if (Funcoes.textoVazio(this.textSiglaOrgaoOrigem)) {
            Funcoes.mensagem(this, "Campo 'Sigla Org\u00e3o Origem' \u00e9 obrigat\u00f3rio.", 2);
            ScreenUtil.requisitarFoco(this.textSiglaOrgaoOrigem);
            return false;
        }
        if (Funcoes.textoVazio(this.textCnsProfissional)) {
            Funcoes.mensagem(this, "Campo 'CNS Profissional' \u00e9 obrigat\u00f3rio.", 2);
            ScreenUtil.requisitarFoco(this.textCnsProfissional);
            return false;
        }
        return true;
    }

    private void configurarServicosClassificacao() {
        ServicosClassificacao modalServicos = ServicosClassificacao.novaInstancia(this, this.arrayCodigoServicos);
        if (modalServicos != null) {
            modalServicos.setServicosClassificacao(this.arrayServicos);
            modalServicos.setVisible(true);
            if (modalServicos.getOK()) {
                this.arrayServicosClassificacao = modalServicos.getArrayServicosClassificacao();
            } else {
                this.arrayServicos = modalServicos.getArrayServicosClassificacaoOriginal();
                this.arrayServicosClassificacao = modalServicos.getArrayServicosClassificacaoOriginal();
            }
        }
    }

    public ArrayList<ServicosClassificacaoModel> getArrayServicosClassificacao() {
        return this.arrayServicosClassificacao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void carregaServicosClassificacao() {
        if (this.arrayListaDadosAdicionais != null) {
            if (this.arrayListaDadosAdicionais.length <= 0) return;
            int i = 0;
            while (i < this.arrayListaDadosAdicionais.length) {
                this.arrayServicos.add((ServicosClassificacaoModel)this.arrayListaDadosAdicionais[i]);
                ++i;
            }
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT fil_codigo, abp_codigoamb, abp_classificacao, abp_servico FROM ambbpa WHERE fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                this.arrayServicos.add(new ServicosClassificacaoModel(rs.getInt("fil_codigo"), rs.getString("abp_codigoamb"), rs.getString("abp_classificacao"), rs.getString("abp_servico")));
            }
            this.arrayServicosClassificacao = this.arrayServicos;
        }
        catch (SQLException ex) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "BPA");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return;
        }
        Conexao.fecharStatement(st);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void carregaCodigosServicosClassificacao() {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT DISTINCT abp_servico FROM ambbpa WHERE fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" ORDER BY abp_servico ASC");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                if (Funcoes.textoVazio(rs.getString("abp_servico"))) continue;
                this.arrayCodigoServicos.add(Integer.valueOf(rs.getString("abp_servico")));
            }
        }
        catch (SQLException ex) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "BPA");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    public boolean ok() {
        return this.ok;
    }

    public void setXML(String xml) {
        if (!Funcoes.textoVazio(xml)) {
            this.textAnoProducao.setText(StringUtil.getValor(xml, "AnoProducao"));
            this.textMesProducao.setText(StringUtil.getValor(xml, "MesProducao"));
            this.textNomeDestino.setText(StringUtil.getValor(xml, "NomeDestino"));
            this.textCNPJResponsavel.clear();
            this.textCNPJResponsavel.setText(StringUtil.getValor(xml, "CnpjResponsavel"));
            this.textNomeOrgaoOrigem.setText(StringUtil.getValor(xml, "NomeOrgaoOrigem"));
            this.textSiglaOrgaoOrigem.setText(StringUtil.getValor(xml, "SiglaOrgaoOrigem"));
            this.textCnsProfissional.setText(StringUtil.getValor(xml, "CnsProfissional"));
            this.textCBOPadrao.setText(StringUtil.getValor(xml, "CBOPadrao"));
            this.textCID10Padrao.setText(StringUtil.getValor(xml, "CID10Padrao"));
            this.comboCaraterAtendimento.setSelectedIndex(StringUtil.getInt(xml, "CaraterAtendimento"));
            this.comboOrgaoDestino.setSelectedItem(StringUtil.getValor(xml, "OrgaoDestino"));
            this.checkIgnorarCBOSMedico.setSelected(StringUtil.getBoolean(xml, "ConsideraCBOExecutante"));
        }
    }

    public String getTextAnoProducao() {
        return this.textAnoProducao.getText();
    }

    public void setTextAnoProducao(TTextField textAnoProducao) {
        this.textAnoProducao = textAnoProducao;
    }

    public String getTextMesProducao() {
        return this.textMesProducao.getText();
    }

    public void setTextMesProducao(TTextField textMesProducao) {
        this.textMesProducao = textMesProducao;
    }

    public String getTextNomeDestino() {
        return this.textNomeDestino.getText();
    }

    public void setTextNomeDestino(TTextField textNomeDestino) {
        this.textNomeDestino = textNomeDestino;
    }

    public String getTextCNPJResponsavel() {
        return this.textCNPJResponsavel.getText();
    }

    public void setTextCNPJResponsavel(TTextField textCNPJResponsavel) {
        this.textCNPJResponsavel = textCNPJResponsavel;
    }

    public String getTextNomeOrgaoOrigem() {
        return this.textNomeOrgaoOrigem.getText();
    }

    public void setTextNomeOrgaoOrigem(TTextField textNomeOrgaoOrigem) {
        this.textNomeOrgaoOrigem = textNomeOrgaoOrigem;
    }

    public String getTextSiglaOrgaoOrigem() {
        return this.textSiglaOrgaoOrigem.getText();
    }

    public void setTextSiglaOrgaoOrigem(TTextField textSiglaOrgaoOrigem) {
        this.textSiglaOrgaoOrigem = textSiglaOrgaoOrigem;
    }

    public String getTextCnsProfissional() {
        return this.textCnsProfissional.getText();
    }

    public void setTextCnsProfissional(TTextField textCnsProfissional) {
        this.textCnsProfissional = textCnsProfissional;
    }

    public String getTextCBOPadrao() {
        return this.textCBOPadrao.getText();
    }

    public void setTextCBOPadrao(TTextField textCBOPadrao) {
        this.textCBOPadrao = textCBOPadrao;
    }

    public String getTextCID10Padrao() {
        return this.textCID10Padrao.getText();
    }

    public void setTextCID10Padrao(TTextField textCID10Padrao) {
        this.textCID10Padrao = textCID10Padrao;
    }

    public JComboBox getComboCaraterAtendimento() {
        return this.comboCaraterAtendimento;
    }

    public void setComboCaraterAtendimento(JComboBox comboCaraterAtendimento) {
        this.comboCaraterAtendimento = comboCaraterAtendimento;
    }

    public JComboBox getComboOrgaoDestino() {
        return this.comboOrgaoDestino;
    }

    public void setComboOrgaoDestino(JComboBox comboOrgaoDestino) {
        this.comboOrgaoDestino = comboOrgaoDestino;
    }

    public JCheckBox getCheckIgnorarCBOSMedico() {
        return this.checkIgnorarCBOSMedico;
    }

    public void setCheckIgnorarCBOSMedico(JCheckBox checkIgnorarCBOSMedico) {
        this.checkIgnorarCBOSMedico = checkIgnorarCBOSMedico;
    }

    private boolean cnpjValido() {
        return Funcoes.textoVazio(this.textCNPJResponsavel.getText()) || !ValidaDoc.checkDoc(this.textCNPJResponsavel.getText(), 7);
    }

    private boolean cboPadraoObrigatorio() {
        return this.checkIgnorarCBOSMedico.isSelected() && Funcoes.textoVazio(this.textCBOPadrao);
    }
}

