/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import br.gov.ans.www.padroes.tiss.schemas.Dm_tipoTransacao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.TissWS;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class VerificacaoElegibilidadeXML
extends TissWS {
    private static final String TAG_BODY = "SOAP-ENV:Body";
    private static final String TAG_CABECALHO = "ns3:cabecalho";
    private static final String TAG_IDENTIFICACAO_TRANSACAO = "ns3:identificacaoTransacao";
    private static final String TAG_TIPO_TRANSACAO = "ns3:tipoTransacao";
    private static final String TAG_SEQUENCIAL_TRANSACAO = "ns3:sequencialTransacao";
    private static final String TAG_DATA_REGISTRO_TRANSACAO = "ns3:dataRegistroTransacao";
    private static final String TAG_HORA_REGISTRO_TRANSACAO = "ns3:horaRegistroTransacao";
    private static final String TAG_ORIGEM = "ns3:origem";
    private static final String TAG_IDENTIFICACAO_PRESTADOR = "ns3:identificacaoPrestador";
    private static final String TAG_CODIGO_PRESTADOR_NA_OPERADORA = "ns3:codigoPrestadorNaOperadora";
    private static final String TAG_DESTINO = "ns3:destino";
    private static final String TAG_REGISTRO_ANS = "ns3:registroANS";
    private static final String TAG_PADRAO = "ns3:Padrao";
    private static final String TAG_LOGIN_SENHA_PRESTADOR = "ns3:loginSenhaPrestador";
    private static final String TAG_LOGIN_PRESTADOR = "ns3:loginPrestador";
    private static final String TAG_SENHA_PRESTADOR = "ns3:senhaPrestador";
    private static final String TAG_NUMERO_CARTEIRA = "ns3:numeroCarteira";
    private static final String TAG_NOME_BENEFICIARIO = "ns3:nomeBeneficiario";
    private static final String TAG_NOME_CONTRATADO = "ns3:nomeContratado";
    private static final String TAG_HASH = "ns3:hash";
    private static final String TAG_PEDIDO_ELEGIBILIDADE = "ns3:pedidoElegibilidade";
    private static final String TAG_DADOS_PRESTADOR = "ns3:dadosPrestador";
    private static final String TAG_RESPOSTA_ELEGIBILIDADE = "ans:respostaElegibilidade";
    private static final String TAG_MENSAGEM_ERRO = "ans:mensagemErro";
    private static final String TAG_CODIGO_GLOSA = "ans:codigoGlosa";
    private static final String TAG_DESCRICAO_GLOSA = "ans:descricaoGlosa";
    private String padrao = null;
    private String registroANS = null;
    private String sequencialTransacao = null;
    private String dataRegistroTransacao = null;
    private String horaRegistroTransacao = null;
    private String numeroCarteira = null;
    private String nomeBeneficiario = null;
    private String nomeContratado = null;
    private String address = null;
    private String codigoPrestadorNaOperadora = null;
    private String login = "";
    private String senha = "";

    public String verificarElegibilidadeXML() throws Exception {
        String requestSoap = this.getXML();
        SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection soapConnection = soapConnectionFactory.createConnection();
        String url = this.getAddress();
        MimeHeaders headers = new MimeHeaders();
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage msg = messageFactory.createMessage(headers, (InputStream)new ByteArrayInputStream(requestSoap.getBytes()));
        try {
            SOAPMessage soapResponse = soapConnection.call(msg, (Object)url);
            Document xmlRespostaARequisicao = soapResponse.getSOAPBody().getOwnerDocument();
            return VerificacaoElegibilidadeXML.converteXMLParaString(xmlRespostaARequisicao, 0);
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter conex\u00e3o com a operadora.", 1);
            return "";
        }
    }

    public static String converteXMLParaString(Document xml, int espacosIdentacao) {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            transfac.setAttribute("indent-number", new Integer(espacosIdentacao));
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(xml);
            trans.transform(source, result);
            String xmlString = sw.toString();
            return xmlString;
        }
        catch (TransformerException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    private String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.escrever("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\">");
            xml.escrever("<SOAP-ENV:Header/>");
            xml.abrir(VerificacaoElegibilidadeXML.getTagBody());
            xml.escrever("<ns3:pedidoElegibilidadeWS xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:ns3=\"http://www.ans.gov.br/padroes/tiss/schemas\">");
            this.montaCabecalhoElegibilidade(xml);
            this.montaVerificacaoElegibilidade(xml);
            xml.escrever(VerificacaoElegibilidadeXML.getTagHash(), this.calculaHash());
            xml.escrever("</ns3:pedidoElegibilidadeWS>");
            xml.fechar(VerificacaoElegibilidadeXML.getTagBody());
            xml.escrever("</SOAP-ENV:Envelope>");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return xml.getXML();
    }

    public XMLStringBuilder montaCabecalhoElegibilidade(XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(VerificacaoElegibilidadeXML.getTagCabecalho());
        xml.abrir(VerificacaoElegibilidadeXML.getTagIdentificacaoTransacao());
        xml.escrever(VerificacaoElegibilidadeXML.getTagTipoTransacao(), Dm_tipoTransacao.VERIFICA_ELEGIBILIDADE.toString());
        xml.escrever(VerificacaoElegibilidadeXML.getTagSequencialTransacao(), this.getSequencialTransacao());
        xml.escrever(VerificacaoElegibilidadeXML.getTagDataRegistroTransacao(), this.getDataRegistroTransacao());
        xml.escrever(VerificacaoElegibilidadeXML.getTagHoraRegistroTransacao(), this.getHoraRegistroTransacao());
        xml.fechar(VerificacaoElegibilidadeXML.getTagIdentificacaoTransacao());
        xml.abrir(VerificacaoElegibilidadeXML.getTagOrigem());
        xml.abrir(VerificacaoElegibilidadeXML.getTagIdentificacaoPrestador());
        xml.escrever(VerificacaoElegibilidadeXML.getTagCodigoPrestadorNaOperadora(), this.getCodigoPrestadorNaOperadora());
        xml.fechar(VerificacaoElegibilidadeXML.getTagIdentificacaoPrestador());
        xml.fechar(VerificacaoElegibilidadeXML.getTagOrigem());
        xml.abrir(VerificacaoElegibilidadeXML.getTagDestino());
        xml.escrever(VerificacaoElegibilidadeXML.getTagRegistroAns(), this.getRegistroANS());
        xml.fechar(VerificacaoElegibilidadeXML.getTagDestino());
        xml.escrever(VerificacaoElegibilidadeXML.getTagPadrao(), this.getPadrao());
        xml.abrir(VerificacaoElegibilidadeXML.getTagLoginSenhaPrestador());
        xml.escrever(VerificacaoElegibilidadeXML.getTagLoginPrestador(), this.getLogin());
        xml.escrever(VerificacaoElegibilidadeXML.getTagSenhaPrestador(), this.getSenha());
        xml.fechar(VerificacaoElegibilidadeXML.getTagLoginSenhaPrestador());
        xml.fechar(VerificacaoElegibilidadeXML.getTagCabecalho());
        return xml;
    }

    private XMLStringBuilder montaVerificacaoElegibilidade(XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(VerificacaoElegibilidadeXML.getTagPedidoElegibilidade());
        xml.abrir(VerificacaoElegibilidadeXML.getTagDadosPrestador());
        xml.escrever(VerificacaoElegibilidadeXML.getTagCodigoPrestadorNaOperadora(), this.getCodigoPrestadorNaOperadora());
        xml.escrever(VerificacaoElegibilidadeXML.getTagNomeContratado(), this.getNomeContratado());
        xml.fechar(VerificacaoElegibilidadeXML.getTagDadosPrestador());
        xml.escrever(VerificacaoElegibilidadeXML.getTagNumeroCarteira(), this.getNumeroCarteira());
        xml.escrever(VerificacaoElegibilidadeXML.getTagNomeBeneficiario(), this.getNomeBeneficiario());
        xml.fechar(VerificacaoElegibilidadeXML.getTagPedidoElegibilidade());
        return xml;
    }

    public String getSequencialTransacao() {
        return this.sequencialTransacao;
    }

    public void setSequencialTransacao(String sequencialTransacao) {
        this.sequencialTransacao = sequencialTransacao;
    }

    public String getDataRegistroTransacao() {
        return this.dataRegistroTransacao;
    }

    public void setDataRegistroTransacao(String dataRegistroTransacao) {
        this.dataRegistroTransacao = dataRegistroTransacao;
    }

    public String getHoraRegistroTransacao() {
        return this.horaRegistroTransacao;
    }

    public void setHoraRegistroTransacao(String horaRegistroTransacao) {
        this.horaRegistroTransacao = horaRegistroTransacao;
    }

    public String getCodigoPrestadorNaOperadora() {
        return this.codigoPrestadorNaOperadora;
    }

    public void setCodigoPrestadorNaOperadora(String codigoPrestadorNaOperadora) {
        this.codigoPrestadorNaOperadora = codigoPrestadorNaOperadora;
    }

    public String getRegistroANS() {
        return this.registroANS;
    }

    public void setRegistroANS(String registroANS) {
        this.registroANS = registroANS;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public String getPadrao() {
        return this.padrao;
    }

    public void setPadrao(String padrao) {
        this.padrao = padrao;
    }

    public String getNomeContratado() {
        return this.nomeContratado;
    }

    public void setNomeContratado(String nomeContratado) {
        this.nomeContratado = nomeContratado;
    }

    public String getNumeroCarteira() {
        return this.numeroCarteira;
    }

    public void setNumeroCarteira(String numeroCarteira) {
        this.numeroCarteira = numeroCarteira;
    }

    public String getNomeBeneficiario() {
        return this.nomeBeneficiario;
    }

    public void setNomeBeneficiario(String nomeBeneficiario) {
        this.nomeBeneficiario = nomeBeneficiario;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public static String getTagBody() {
        return TAG_BODY;
    }

    public static String getTagNomeBeneficiario() {
        return TAG_NOME_BENEFICIARIO;
    }

    public static String getTagCabecalho() {
        return TAG_CABECALHO;
    }

    public static String getTagIdentificacaoTransacao() {
        return TAG_IDENTIFICACAO_TRANSACAO;
    }

    public static String getTagTipoTransacao() {
        return TAG_TIPO_TRANSACAO;
    }

    public static String getTagSequencialTransacao() {
        return TAG_SEQUENCIAL_TRANSACAO;
    }

    public static String getTagDataRegistroTransacao() {
        return TAG_DATA_REGISTRO_TRANSACAO;
    }

    public static String getTagHoraRegistroTransacao() {
        return TAG_HORA_REGISTRO_TRANSACAO;
    }

    public static String getTagOrigem() {
        return TAG_ORIGEM;
    }

    public static String getTagIdentificacaoPrestador() {
        return TAG_IDENTIFICACAO_PRESTADOR;
    }

    public static String getTagCodigoPrestadorNaOperadora() {
        return TAG_CODIGO_PRESTADOR_NA_OPERADORA;
    }

    public static String getTagDestino() {
        return TAG_DESTINO;
    }

    public static String getTagRegistroAns() {
        return TAG_REGISTRO_ANS;
    }

    public static String getTagPadrao() {
        return TAG_PADRAO;
    }

    public static String getTagLoginSenhaPrestador() {
        return TAG_LOGIN_SENHA_PRESTADOR;
    }

    public static String getTagLoginPrestador() {
        return TAG_LOGIN_PRESTADOR;
    }

    public static String getTagSenhaPrestador() {
        return TAG_SENHA_PRESTADOR;
    }

    public static String getTagHash() {
        return TAG_HASH;
    }

    public static String getTagNumeroCarteira() {
        return TAG_NUMERO_CARTEIRA;
    }

    public static String getTagNomeContratado() {
        return TAG_NOME_CONTRATADO;
    }

    public static String getTagPedidoElegibilidade() {
        return TAG_PEDIDO_ELEGIBILIDADE;
    }

    public static String getTagDadosPrestador() {
        return TAG_DADOS_PRESTADOR;
    }

    public static String getTagRespostaElegibilidade() {
        return TAG_RESPOSTA_ELEGIBILIDADE;
    }

    public static String getTagMensagemErro() {
        return TAG_MENSAGEM_ERRO;
    }

    public static String getTagCodigoGlosa() {
        return TAG_CODIGO_GLOSA;
    }

    public static String getTagDescricaoGlosa() {
        return TAG_DESCRICAO_GLOSA;
    }
}

