/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ArquivoFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ConfigurarUnimedCampinas;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.GuiaVirtual;
import jalis.laboratorio.util.faturamento.eletronico.JanelaConfiguracaoFaturamentoBPA;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Window;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.util.ArrayList;
import javax.swing.JFrame;

public class UnimedCampinas
extends AbstractFaturamentoEletronico
implements FaturamentoEletronico {
    private static final String[] CARACTERES_PROIBIDOS = new String[]{",", ".", "/", "-"};
    public static final int QTDE_EXAMES_GRADE = 50;
    private final int CASAS_DECIMAIS = 2;
    private Registro config = null;
    private StringBuilder conteudo = new StringBuilder();
    private String sqlFaturas = null;
    private final Campos CAB_TIPO_ARQUIVO = new Campos(1, 6, 0);
    private final Campos CAB_CODIGO_LOCAL = new Campos(7, 14, 1);
    private final Campos CAB_TIPO_LOCAL = new Campos(15, 16, 2);
    private final Campos CAB_MES_ANO_PRODUCAO = new Campos(17, 22, 2);
    private final Campos CAB_DATA_RECEBIMENTO = new Campos(23, 30, 1);
    private final Campos CAB_GRADE = new Campos(31, 36, 2);
    private final Campos CAB_DATA_ENTREGA_ARQUIVO = new Campos(37, 44, 3);
    private final Campos CAB_NUMERO_UNIMED = new Campos(45, 54, 1);
    private final Campos CAB_VAZIO = new Campos(55, 69, 0);
    private final Campos CAB_COMPLEMENTO = new Campos(70, 293, 1);
    private final Campos MOV_DIA_MES_ANO_HORA_MINUTO = new Campos(1, 12, 4);
    private final Campos MOV_NUMERO_AUTORIZACAO = new Campos(13, 23, 2);
    private final Campos MOV_CODIGO_USUARIO = new Campos(24, 40, 2);
    private final Campos MOV_TIPO_SERVICO = new Campos(41, 41, 2);
    private final Campos MOV_CODIGO_SERVICO = new Campos(42, 49, 2);
    private final Campos MOV_QUANTIDADE = new Campos(50, 56, 2);
    private final Campos MOV_VALOR_REAIS = new Campos(57, 65, 2);
    private final Campos MOV_CID_PRIMARIO = new Campos(66, 69, 1);
    private final Campos MOV_CID_SECUNDARIO = new Campos(70, 73, 1);
    private final Campos MOV_COD_SOLICITANTE = new Campos(74, 84, 2);
    private final Campos MOV_COD_EXECUTANTE = new Campos(85, 95, 2);
    private final Campos MOV_VIA_ACESSO = new Campos(96, 96, 0);
    private final Campos MOV_PARTICIPACAO_EQUIPE_MEDICA = new Campos(97, 98, 2);
    private final Campos MOV_PACIENTE_INTERNADO = new Campos(99, 99, 0);
    private final Campos MOV_ATENDIMENTO_URGENCIA = new Campos(100, 100, 0);
    private final Campos MOV_ACIDENTE_TRABALHO = new Campos(101, 101, 0);
    private final Campos MOV_NOME_PACIENTE = new Campos(102, 201, 0);
    private final Campos MOV_SEXO_PACIENTE = new Campos(202, 202, 0);
    private final Campos MOV_ESTADO_CIVIL = new Campos(203, 203, 2);
    private final Campos MOV_DATA_NASCIMENTO = new Campos(204, 211, 3);
    private final Campos MOV_CPF = new Campos(212, 241, 1);
    private final Campos MOV_TIPO_ORIGEM_USUARIO = new Campos(242, 242, 2);
    private final Campos MOV_COD_ORIGEM_USUARIO = new Campos(243, 259, 1);
    private final Campos MOV_NACIONALIDADE = new Campos(260, 265, 0);
    private final Campos MOV_DATA_INTERNACAO = new Campos(266, 273, 0);
    private final Campos MOV_DATA_ALTA = new Campos(274, 281, 0);
    private final Campos MOV_TIPO_ALTA = new Campos(282, 283, 0);
    private final Campos MOV_UNCP_SOLICITANTE = new Campos(284, 291, 1);
    private final Campos MOV_TIPO_LOCAL_SOLICITANTE = new Campos(292, 293, 2);

    private String substring(String str, int tamanho) {
        return str.substring(0, str.length() > tamanho ? tamanho : str.length());
    }

    private String getValor(Object valor, Campos campo, boolean usarNullBranco) throws Exception {
        if (campo == null) {
            throw new Exception("Campo n\u00e3o informado.");
        }
        if (valor == null) {
            if (!usarNullBranco) {
                return Funcoes.preencheZero(0, campo.tamanho);
            }
            return Funcoes.preencheVazio(" ", campo.tamanho, 1);
        }
        if (campo.tipo == 2) {
            if (valor instanceof Integer) {
                Integer valorAux = Integer.valueOf(valor.toString());
                return this.substring(Funcoes.preencheZero(valorAux, campo.tamanho), campo.tamanho);
            }
            if (valor instanceof Double || valor instanceof BigDecimal) {
                Double valorAux = Double.valueOf(valor.toString());
                String aux = Funcoes.formataDecimal(valorAux, 2);
                aux = StringUtil.limpaString(aux, CARACTERES_PROIBIDOS);
                return this.substring(Funcoes.preencheZero(aux, campo.tamanho), campo.tamanho);
            }
            if (valor instanceof String) {
                String aux = StringUtil.limpaString(valor.toString(), CARACTERES_PROIBIDOS);
                return this.substring(Funcoes.preencheZero(aux, campo.tamanho), campo.tamanho);
            }
            throw new Exception("Tipo do valor incorreto para formata\u00e7\u00e3o NUM\u00c9RICA. Tipo = \"" + valor.getClass() + "\".");
        }
        if (campo.tipo == 0 || campo.tipo == 1) {
            String aux = campo.toString();
            String valorSemAcento = StringUtil.removerAcentos(valor.toString());
            return this.substring(Funcoes.preencheVazio(valorSemAcento, campo.tamanho, 2), campo.tamanho);
        }
        if (campo.tipo == 3) {
            if (valor instanceof Date) {
                return this.substring(Funcoes.formataData("ddMMyyyy", (Date)valor), campo.tamanho);
            }
            if (valor instanceof String) {
                java.util.Date aux = Funcoes.getData("dd/MM/yyyy", valor.toString());
                return this.substring(Funcoes.formataData("ddMMyyyy", aux), campo.tamanho);
            }
            throw new Exception("Valor data incorreto. Tipo = \"" + valor.getClass() + "\".");
        }
        if (campo.tipo == 4) {
            if (valor instanceof Time) {
                return this.substring(Funcoes.formataData("ddMMyyyyHHmm", (Time)valor), campo.tamanho);
            }
            if (valor instanceof java.util.Date) {
                return this.substring(Funcoes.formataData("ddMMyyyyHHmm", (java.util.Date)valor), campo.tamanho);
            }
            throw new Exception("Valor data/hora incorreto. Tipo = \"" + valor.getClass() + "\".");
        }
        throw new Exception("Tipo de dados desconhecido. Tipo = \"" + valor.getClass() + "\".");
    }

    public String getLetraNumeroGeracao(int numero) {
        int aux = 65 + --numero;
        return String.valueOf((char)aux);
    }

    private String getSql(String convenio, int codigoFatura) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fre.req_codigo as codigoRequisicao ");
        buf.append("       ,fre.fil_kodigo as codigoFilial ");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.req_hora as horaRequisicao ");
        buf.append("       ,req.med_crm as crmMedico ");
        buf.append("       ,req.med_uf as ufMedico ");
        buf.append("       ,req.med_conselho as conselhoMedico ");
        buf.append("       ,req.req_matricula as matriculaRequisicao ");
        buf.append("       ,CASE WHEN COALESCE(req.req_urgente, true) THEN 'S' ELSE 'N' END as urgenteRequisicao ");
        buf.append("       ,CASE WHEN length(trim(exr.exr_codautorizacao)) = 0 THEN null ELSE trim(exr.exr_codautorizacao) END as autorizacaoExameRequisicao ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,(select c10.c10_codigo ");
        buf.append("           from requisicaocid10 c10 ");
        buf.append("          where req.fil_codigo = c10.fil_codigo ");
        buf.append("            and req.req_codigo = c10.req_codigo ");
        buf.append("          limit 1) as cid10Exame ");
        buf.append("       ,fil_razaosocial as razaoSocialFilial ");
        buf.append("       ,mec.mec_codigooperadora as codigoSolicitante ");
        buf.append("       ,fer.exa_codfilho as codigoExame ");
        buf.append("       ,mco.mco_codigo as codigoMaterial ");
        buf.append("       ,CASE WHEN con.con_titdep = 'T' THEN COALESCE(NULLIF(TRIM(req.req_titular), ''), pac.pac_nome) ELSE pac.pac_nome END as ordemPaciente ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("       ,det.dtm_codamb as ambExame ");
        } else {
            buf.append("       ,det.dtp_codamb as ambExame ");
        }
        buf.append("   from faturarequisicao      fre ");
        buf.append("   join fatura                fat on fre.fil_codigo = fat.fil_codigo and fre.fat_codigo = fat.fat_codigo ");
        buf.append("   join requisicao            req on fre.fil_kodigo = req.fil_codigo and fre.req_codigo = req.req_codigo ");
        buf.append("   join paciente              pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join faturaexamerequisicao fer on fre.fil_codigo = fer.fil_codigo and fre.fat_codigo = fer.fat_codigo and fre.req_codigo = fer.req_codigo and fre.fil_kodigo = fer.fil_kodigo ");
        buf.append("   join examerequisicao       exr on fer.fil_kodigo = exr.fil_codigo and fer.req_codigo = exr.req_codigo and fer.exa_codigo = exr.exa_codigo and fer.mco_codigo = exr.mco_codigo ");
        buf.append("   left join convenios        con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("   left join convenios \t     \tconprinc on req.fil_codigo = conprinc.fil_codigo and req.con_codigo = conprinc.con_codigo ");
        buf.append("   left join exames           exa on fer.fil_kodigo = exa.fil_codigo and fer.exa_codfilho = exa.exa_codigo ");
        buf.append("   left join examematcoleta   emc on fer.fil_kodigo = emc.fil_codigo and fer.exa_codfilho = emc.exa_codigo and fer.mco_codfilho = emc.mco_codigo ");
        buf.append("   left join materialcoleta   mco on fer.fil_kodigo = mco.fil_codigo and fer.mco_codfilho = mco.mco_codigo ");
        buf.append("   left join medico           med on req.fil_codigo = med.fil_codigo and req.med_crm = med.med_crm and req.med_conselho = med.med_conselho and req.med_uf = med.med_uf ");
        buf.append("   left join destino          des on req.fil_codigo = des.fil_codigo and req.des_codigo = des.des_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("   left join detalhetabelaprecometodologia det on req.fil_codigo = det.fil_codigo and con.tpe_codigo = det.tpe_codigo and fer.exa_codfilho = det.exa_codigo and fer.mco_codfilho = det.mco_codigo and exr.met_codigo = det.met_codigo ");
        } else {
            buf.append("   left join detalhetabelapreco det on req.fil_codigo = det.fil_codigo and con.tpe_codigo = det.tpe_codigo and fer.exa_codfilho = det.exa_codigo and fer.mco_codfilho = det.mco_codigo ");
        }
        if (ParametrosGerais.getOrdenarSetor()) {
            buf.append(" left join examesetor ese on exa.fil_codigo = ese.fil_codigo and exa.exa_codigo = ese.exa_codigo ");
        }
        buf.append("   join filiais_postocoleta   fil on fre.fil_codigo = fil.fil_codigo ");
        buf.append("   left join medicoconveniotiss mec on req.fil_codigo = mec.fil_codigo and req.med_uf = mec.med_uf and req.med_conselho = mec.med_conselho and req.med_crm = mec.med_crm and req.con_codigo = mec.con_codigo ");
        buf.append("  where fre.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and fre.fat_codigo = ").append(codigoFatura);
        buf.append("    and fat.fat_datacancelamento is null ");
        buf.append("    and not req.req_excluida ");
        if (ParametrosGerais.getOrdenarSetor()) {
            buf.append("  and ese.ese_default = true ");
        }
        buf.append(" order by ").append(this.getOrderBy(convenio));
        return buf.toString();
    }

    private String getOrderBy(String convenio) throws SQLException {
        StringBuilder buf = new StringBuilder();
        StringBuilder bufOrdemConvenio = new StringBuilder();
        bufOrdemConvenio.append(" select con_ordemfatura ");
        bufOrdemConvenio.append("   from convenios ");
        bufOrdemConvenio.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
        bufOrdemConvenio.append("    and con_codigo = ").append(convenio);
        Statement st = Conexao.getStatement();
        String ordemFatura = "R";
        ResultSet rsOrdem = Conexao.executeQuery(st, bufOrdemConvenio.toString());
        if (rsOrdem.next()) {
            ordemFatura = rsOrdem.getString("con_ordemfatura");
            if (Variaveis.tipoFilialPadrao.equals("A")) {
                buf.append(" des.des_descricao, ");
            }
            if (ordemFatura == null || ordemFatura.equals("R")) {
                buf.append(" fer.fil_kodigo, fer.req_codigo, ");
            } else if (ordemFatura.equals("D")) {
                buf.append(" req.req_data, fer.fil_kodigo, fer.req_codigo, ");
            } else if (ordemFatura.equals("F")) {
                buf.append(" req.req_dtfatura, fer.fil_kodigo, fer.req_codigo, ");
            } else if (ordemFatura.equals("N")) {
                buf.append(" ordemPaciente, fer.fil_kodigo, fer.req_codigo, ");
            } else if (ordemFatura.equals("G")) {
                buf.append(" req.req_guia, fer.fil_kodigo, fer.req_codigo, ");
            } else if (ordemFatura.equals("M")) {
                buf.append(" req.req_matricula, fer.fil_kodigo, fer.req_codigo, ");
            } else if (ordemFatura.equals("E")) {
                buf.append(" med.med_nome, fer.fil_kodigo, fer.req_codigo, ");
            } else if (ordemFatura.equals("C")) {
                buf.append(" med.med_crm, fer.fil_kodigo, fer.req_codigo, ");
            } else if (ordemFatura.equals("X")) {
                buf.append(" req.req_data, exr.exr_guia, fer.fil_kodigo, fer.req_codigo, ");
            } else if (ordemFatura.equals("T")) {
                buf.append(" req.des_codigo, fer.fil_kodigo, fer.req_codigo, ");
            } else if (ordemFatura.equals("P")) {
                buf.append(" req.req_data, pac.pac_nome, fer.fil_kodigo, fer.req_codigo, ");
            }
        }
        buf.append(" conprinc.con_codigo ");
        if (ParametrosGerais.getOrdemComprovante().equals("A")) {
            buf.append(" ,exr_ordem, fer.exa_codfilho, mco.mco_codigo ");
        } else {
            if (ParametrosGerais.getOrdenarSetor()) {
                buf.append(" ,set_codigo ");
            }
            if (ParametrosGerais.getOrdemComprovante().equals("C")) {
                buf.append(" ,codigoexame, codigomaterial ");
            } else if (ParametrosGerais.getOrdemComprovante().equals("P")) {
                buf.append(" ,emc.emc_pagina, emc.emc_ordem, codigoexame, codigomaterial ");
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<ArquivoFaturamentoEletronico> criarArquivo(Object owner, int codigoFatura, String codigoConvenio, String diretorioArquivos) {
        ArrayList<ArquivoFaturamentoEletronico> retorno;
        Statement st;
        block9: {
            StringBuilder buf;
            block8: {
                st = Conexao.getStatement();
                buf = new StringBuilder();
                retorno = new ArrayList<ArquivoFaturamentoEletronico>();
                buf.append(" select fat.con_codigo  ");
                buf.append("       ,con.con_faturaeletronica ");
                buf.append("   from fatura    fat ");
                buf.append("   join convenios con on fat.fil_codigo = con.fil_codigo and fat.con_codigo = con.con_codigo ");
                buf.append("  where fat.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and fat.fat_codigo = ").append(codigoFatura);
                buf.append("    and fat.fat_datacancelamento is null ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block8;
                ConfigurarUnimedCampinas telaConf = new ConfigurarUnimedCampinas((Window)Laboratorio.getInstancia(), true);
                telaConf.setXML(rs.getString("con_faturaeletronica"));
                telaConf.setVisible(true);
                if (telaConf.ok()) {
                    this.config = this.parseXMLConfiguracao(telaConf.getXML());
                    this.config.setValor("con_codigo", rs.getString("con_codigo"));
                    break block8;
                }
                Funcoes.mensagem(null, "A gera\u00e7\u00e3o foi cancelada.", 5);
                ArrayList<ArquivoFaturamentoEletronico> arrayList = retorno;
                Conexao.fecharStatement(st);
                return arrayList;
            }
            try {
                if (this.config == null) break block9;
                retorno = this.gerarArquivo(codigoFatura, codigoConvenio);
                String gradeAux = this.config.getString("grade");
                int grade = Integer.parseInt(gradeAux);
                this.config.setValor("grade", grade + 1);
                buf.delete(0, buf.length());
                buf.append(" update convenios ");
                buf.append("    set con_faturaeletronica = '").append(StringUtil.textoDB(this.registroToXML(this.config))).append("' ");
                buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and con_codigo = ").append(this.config.getValor("con_codigo"));
                Conexao.execute(Variaveis.filialPadrao, st, buf);
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ArquivoFaturamentoEletronico> gerarArquivo(int codigoFatura, String codigoConvenio) throws Exception {
        if (this.config == null) {
            throw new Exception("XML de configura\u00e7\u00e3o n\u00e3o informado");
        }
        Statement st = Conexao.getStatement();
        try {
            this.sqlFaturas = this.getSql(codigoConvenio, codigoFatura);
            ResultSet rsFatura = Conexao.executeQuery(st, this.sqlFaturas);
            String gradeAux = this.config.getString("grade");
            if (gradeAux == null || Funcoes.textoVazio(gradeAux) || !Funcoes.isNumeric(gradeAux)) {
                throw new Exception("A grade da gera\u00e7\u00e3o deve ser configurada.");
            }
            int grade = Integer.parseInt(gradeAux);
            int i = 0;
            while (rsFatura.next()) {
                if (i % 50 == 0) {
                    this.escreveCabecalho(rsFatura, grade + i / 50);
                    this.config.setValor("grade", grade + i / 50);
                }
                this.escreveExame(rsFatura);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        StringBuilder nomeArquivo = new StringBuilder();
        nomeArquivo.append("CO");
        String mesAux = this.config.getString("mesReferencia");
        if (mesAux == null || Funcoes.textoVazio(mesAux) || !Funcoes.isNumeric(mesAux)) {
            throw new Exception("O m\u00eas de refer\u00eancia deve ser configurado.");
        }
        int mes = Integer.parseInt(mesAux);
        nomeArquivo.append(mes + 1);
        nomeArquivo.append(this.config.getValor("anoReferencia"));
        nomeArquivo.append(".");
        String numeroGeracao = this.config.getString("numeroGeracao");
        if (numeroGeracao == null || !Funcoes.isNumeric(numeroGeracao)) {
            throw new Exception("N\u00famero da gera\u00e7\u00e3o n\u00e3o informado ou inv\u00e1lido.");
        }
        nomeArquivo.append(this.getLetraNumeroGeracao(Integer.parseInt(numeroGeracao)));
        nomeArquivo.append(this.config.getValor("idLaboratorio"));
        ArrayList<ArquivoFaturamentoEletronico> retorno = new ArrayList<ArquivoFaturamentoEletronico>();
        retorno.add(new ArquivoFaturamentoEletronico(nomeArquivo.toString(), this.conteudo.toString()));
        return retorno;
    }

    private void escreveCabecalho(ResultSet rs, int grade) throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es do faturamento eletr\u00f4nico n\u00e3o foram carregadas.", 2);
            return;
        }
        if (this.conteudo.length() > 0) {
            this.conteudo.append("\n");
        }
        this.conteudo.append(this.getValor(this.config.getValor("tipoArquivo"), this.CAB_TIPO_ARQUIVO, false));
        this.conteudo.append(this.getValor("UNCP" + this.config.getValor("codigoLocal"), this.CAB_CODIGO_LOCAL, false));
        this.conteudo.append(this.getValor(9, this.CAB_TIPO_LOCAL, false));
        this.conteudo.append(this.getValor(Integer.parseInt(Integer.parseInt(this.config.getString("mesReferencia")) + 1 + this.config.getString("anoReferencia")), this.CAB_MES_ANO_PRODUCAO, false));
        this.conteudo.append(this.getValor(null, this.CAB_DATA_RECEBIMENTO, true));
        this.conteudo.append(this.getValor(grade, this.CAB_GRADE, false));
        this.conteudo.append(this.getValor(this.config.getValor("dataEntrega"), this.CAB_DATA_ENTREGA_ARQUIVO, false));
        this.conteudo.append(this.getValor(null, this.CAB_NUMERO_UNIMED, true));
        this.conteudo.append(this.getValor(null, this.CAB_VAZIO, true));
        this.conteudo.append(this.getValor(rs.getString("razaoSocialFilial"), this.CAB_COMPLEMENTO, true));
    }

    private void escreveExame(ResultSet rs) throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es do faturamento eletr\u00f4nico n\u00e3o foram carregadas.", 2);
            return;
        }
        this.conteudo.append("\n");
        this.conteudo.append(this.getValor(Funcoes.getData("yyyy-MM-dd HH:mm", rs.getString("dataRequisicao") + " " + rs.getString("horaRequisicao")), this.MOV_DIA_MES_ANO_HORA_MINUTO, false));
        this.conteudo.append(this.getValor(rs.getString("autorizacaoExameRequisicao"), this.MOV_NUMERO_AUTORIZACAO, true));
        this.conteudo.append(this.getValor(rs.getString("matriculaRequisicao"), this.MOV_CODIGO_USUARIO, true));
        this.conteudo.append(this.getValor(2, this.MOV_TIPO_SERVICO, false));
        this.conteudo.append(this.getValor(rs.getString("ambExame"), this.MOV_CODIGO_SERVICO, false));
        this.conteudo.append(this.getValor(1.0, this.MOV_QUANTIDADE, false));
        this.conteudo.append(this.getValor(null, this.MOV_VALOR_REAIS, false));
        this.conteudo.append(this.getValor(rs.getString("cid10Exame") == null ? "Z00" : rs.getString("cid10Exame"), this.MOV_CID_PRIMARIO, true));
        this.conteudo.append(this.getValor(null, this.MOV_CID_SECUNDARIO, true));
        this.conteudo.append(this.getValor(rs.getInt("codigoSolicitante"), this.MOV_COD_SOLICITANTE, false));
        this.conteudo.append(this.getValor(this.config.getString("codigoExecutante"), this.MOV_COD_EXECUTANTE, false));
        this.conteudo.append(this.getValor(null, this.MOV_VIA_ACESSO, true));
        this.conteudo.append(this.getValor(null, this.MOV_PARTICIPACAO_EQUIPE_MEDICA, false));
        this.conteudo.append(this.getValor("N", this.MOV_PACIENTE_INTERNADO, true));
        this.conteudo.append(this.getValor(rs.getString("urgenteRequisicao"), this.MOV_ATENDIMENTO_URGENCIA, true));
        this.conteudo.append(this.getValor("N", this.MOV_ACIDENTE_TRABALHO, true));
        this.conteudo.append(this.getValor(rs.getString("nomePaciente"), this.MOV_NOME_PACIENTE, true));
        this.conteudo.append(this.getValor(null, this.MOV_SEXO_PACIENTE, true));
        this.conteudo.append(this.getValor(null, this.MOV_ESTADO_CIVIL, false));
        this.conteudo.append(this.getValor(null, this.MOV_DATA_NASCIMENTO, false));
        this.conteudo.append(this.getValor(null, this.MOV_CPF, true));
        this.conteudo.append(this.getValor(null, this.MOV_TIPO_ORIGEM_USUARIO, false));
        this.conteudo.append(this.getValor(null, this.MOV_COD_ORIGEM_USUARIO, true));
        this.conteudo.append(this.getValor(null, this.MOV_NACIONALIDADE, true));
        this.conteudo.append(this.getValor(null, this.MOV_DATA_INTERNACAO, true));
        this.conteudo.append(this.getValor(null, this.MOV_DATA_ALTA, true));
        this.conteudo.append(this.getValor(null, this.MOV_TIPO_ALTA, true));
        Integer uncp = this.getUncpMedico(rs.getString("conselhoMedico"), rs.getString("crmMedico"), rs.getString("ufMedico"));
        this.conteudo.append(this.getValor(uncp == null ? "" : "UNCP" + uncp, this.MOV_UNCP_SOLICITANTE, true));
        this.conteudo.append(this.getValor(2, this.MOV_TIPO_LOCAL_SOLICITANTE, false));
    }

    public Integer getUncpMedico(String conselho, String crm, String uf) {
        String xmlMedicos = this.config.getString("medicos");
        if (xmlMedicos != null && !Funcoes.textoVazio(xmlMedicos)) {
            String[] arrayMedicos = StringUtil.getValores(xmlMedicos, "medico");
            for (int i = 0; i < arrayMedicos.length; ++i) {
                String xmlMedico = arrayMedicos[i];
                String conselhoAux = StringUtil.getValor(xmlMedico, "conselho");
                String crmAux = StringUtil.getValor(xmlMedico, "crm");
                String ufAux = StringUtil.getValor(xmlMedico, "uf");
                String uncp = StringUtil.getValor(xmlMedico, "uncp");
                if (!conselhoAux.equalsIgnoreCase(conselho) || !crmAux.equalsIgnoreCase(crm) || !ufAux.equalsIgnoreCase(uf) || Funcoes.textoVazio(uncp) || !Funcoes.isNumeric(uncp)) continue;
                return Integer.parseInt(uncp);
            }
        }
        return null;
    }

    @Override
    public String configurar(JFrame parent, String xml) {
        String retorno = xml;
        ConfigurarUnimedCampinas conf = new ConfigurarUnimedCampinas((Window)parent);
        conf.setXML(xml);
        conf.setVisible(true);
        if (conf.ok()) {
            retorno = conf.getXML();
            this.config = this.parseXMLConfiguracao(retorno);
        }
        return retorno;
    }

    @Override
    public Registro parseXMLConfiguracao(String xml) {
        Registro r = new Registro();
        r.setValor("codigoExecutante", StringUtil.getValor(xml, "codigoExecutante"));
        r.setValor("dataEntrega", StringUtil.getValor(xml, "dataEntrega"));
        r.setValor("codigoLocal", StringUtil.getValor(xml, "codigoLocal"));
        r.setValor("tipoArquivo", StringUtil.getValor(xml, "tipoArquivo"));
        r.setValor("idLaboratorio", StringUtil.getValor(xml, "idLaboratorio"));
        r.setValor("numeroGeracao", StringUtil.getValor(xml, "numeroGeracao"));
        r.setValor("anoReferencia", StringUtil.getValor(xml, "anoReferencia"));
        r.setValor("mesReferencia", StringUtil.getValor(xml, "mesReferencia"));
        r.setValor("grade", StringUtil.getValor(xml, "grade"));
        r.setValor("medicos", StringUtil.getValor(xml, "medicos"));
        return r;
    }

    private String registroToXML(Registro r) {
        StringBuilder buf = new StringBuilder("<faturamentoEletronico>");
        buf.append("<protocolo>").append(UnimedCampinas.getNomeProtocolo()).append("</protocolo>");
        buf.append(StringUtil.getTag("codigoExecutante", r.getValor("codigoExecutante").toString()));
        buf.append(StringUtil.getTag("dataEntrega", r.getValor("dataEntrega").toString()));
        buf.append(StringUtil.getTag("codigoLocal", r.getValor("codigoLocal").toString()));
        buf.append(StringUtil.getTag("tipoArquivo", r.getValor("tipoArquivo").toString()));
        buf.append(StringUtil.getTag("idLaboratorio", r.getValor("idLaboratorio").toString()));
        buf.append(StringUtil.getTag("numeroGeracao", r.getValor("numeroGeracao").toString()));
        buf.append(StringUtil.getTag("anoReferencia", r.getValor("anoReferencia").toString()));
        buf.append(StringUtil.getTag("mesReferencia", r.getValor("mesReferencia").toString()));
        buf.append(StringUtil.getTag("grade", r.getValor("grade").toString()));
        buf.append(StringUtil.getTag("medicos", r.getValor("medicos").toString()));
        buf.append("</faturamentoEletronico>");
        return buf.toString();
    }

    @Override
    public boolean solicitarDiretorioNoInicio() {
        return false;
    }

    @Override
    public String[] situacoesPermitidasExame(String xml) {
        return null;
    }

    @Override
    public boolean validarCasasDecimais() {
        return true;
    }

    @Override
    public String getCodificacaoArquivo() {
        return FaturamentoEletronico.CODIFICACAO.ISO_8859_1.codificacao;
    }

    public static String getNomeProtocolo() {
        return "Unimed Campinas";
    }

    public static String getExtensaoArquivo() {
        return null;
    }

    @Override
    public void verificaErrosFatura(ArrayList<DadosFaturamento> requisicoes, Registro configuracaoConvenio0) {
    }

    @Override
    public ArrayList<GuiaVirtual.Campo> getCamposObrigatorios(String versao) {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasSolicitados() {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasExecutados() {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampo> getCamposIncorretos(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasSolicitados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasExecutados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public boolean gravaAlteracoes(DadosFaturamento requisicao, String guia, Registro configuracao) {
        return false;
    }

    @Override
    public void preencheValoresCampos(DadosFaturamento requisicao, Registro configuracaoEletronico, String guia) {
    }

    @Override
    public void preencheValoresTabelas(DadosFaturamento requisicao, String guia) {
    }

    @Override
    public void getValoresPreenchidos(DadosFaturamento requisicao, ArrayList<DadosExameFaturamento> exames, Registro configuracaoEletronico) {
    }

    @Override
    public void aplicarModificacoesGerais(ArrayList<DadosFaturamento> requisicoes, DadosFaturamento requisicao, DadosFaturamento requisicaoModificada, Registro configuracaoEletronico, Registro configuracaoEletronicoModificada) {
    }

    @Override
    public Object[] getListaDadosAdicionais() {
        return null;
    }

    @Override
    public void setListaDadosAdicionais(Object[] listaDadosAdicionais) {
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampoBPA> getCamposIncorretosBPA(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<JanelaConfiguracaoFaturamentoBPA.CampoBPA> getCamposObrigatoriosBPA() {
        return null;
    }

    class Campos {
        public static final int TIPO_CARACTER = 0;
        public static final int TIPO_ALFA_NUMERICO = 1;
        public static final int TIPO_NUMERICO = 2;
        public static final int TIPO_DATA = 3;
        public static final int TIPO_DATA_HORA = 4;
        int posIni = -1;
        int posFim = -1;
        int tamanho = -1;
        int tipo = 0;

        public Campos(int posicaoInicial, int posicaoFinal, int tipo) {
            this.posIni = posicaoInicial;
            this.posFim = posicaoFinal;
            this.tamanho = posicaoFinal - posicaoInicial + 1;
            this.tipo = tipo;
        }
    }
}

