/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.comum.CBOS;
import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.TabelaANS;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DetalhamentoErroFaturamento;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.AutorizacaoExame;
import jalis.laboratorio.resultados.CertificadoHabilitadoAssinar;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ArquivoFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.GuiaVirtual;
import jalis.laboratorio.util.faturamento.eletronico.JanelaConfiguracaoFaturamentoBPA;
import jalis.laboratorio.util.faturamento.eletronico.Operadoras;
import jalis.laboratorio.util.faturamento.eletronico.Requisicao;
import jalis.laboratorio.util.faturamento.eletronico.Util;
import jalis.laboratorio.util.faturamento.eletronico.VisualizaErros;
import jalis.laboratorio.util.faturamento.eletronico.tiss.ConfigurarTiss;
import jalis.laboratorio.util.faturamento.eletronico.tiss.Conselho;
import jalis.laboratorio.util.faturamento.eletronico.tiss.DadosTiss;
import jalis.laboratorio.util.faturamento.eletronico.tiss.ErrosFaturamento;
import jalis.laboratorio.util.faturamento.eletronico.tiss.GrauParticipacao;
import jalis.laboratorio.util.faturamento.eletronico.tiss.RegimeAtendimento;
import jalis.laboratorio.util.faturamento.eletronico.tiss.TipoAtendimento;
import jalis.laboratorio.util.faturamento.eletronico.tiss.VersaoTiss;
import jalis.model.bean.cadastro.FilialBean;
import jalis.service.cadastro.FilialService;
import jalis.util.ArraysUtil;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.ValidaDoc;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.CertificadoException;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Frame;
import java.awt.Window;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JFrame;

public class Tiss
extends AbstractFaturamentoEletronico
implements FaturamentoEletronico {
    private static final String MENSAGEM_TISS = ":mensagemTISS";
    private static final String HASH = ":hash";
    private static final String EPILOGO = ":epilogo";
    private static final String GUIA_FATURAMENTO = ":guiaFaturamento";
    private static final String GUIAS = ":guias";
    private static final String GUIAS_TISS = ":guiasTISS";
    private static final String NUMERO_LOTE = ":numeroLote";
    private static final String LOTE_GUIAS = ":loteGuias";
    private static final String PRESTADOR_PARA_OPERADORA = ":prestadorParaOperadora";
    private static final String GUIA_SP_SADT = ":guiaSP-SADT";
    private static final String VERSAO_PADRAO = ":versaoPadrao";
    private static final String REGISTRO_ANS = ":registroANS";
    private static final String DESTINO = ":destino";
    private static final String FABRICANTE_APLICATIVO = ":fabricanteAplicativo";
    private static final String VERSAO_APLICATIVO = ":versaoAplicativo";
    private static final String NOME_APLICATIVO = ":nomeAplicativo";
    private static final String IDENTIFICACAO_SOFTWARE_GERADOR = ":identificacaoSoftwareGerador";
    private static final String CABECALHO = ":cabecalho";
    private static final String IDENTIFICACAO_PRESTADOR = ":identificacaoPrestador";
    private static final String CODIGO_PRESTADOR_NA_OPERADORA = ":codigoPrestadorNaOperadora";
    private static final String CNPJ = ":CNPJ";
    private static final String ORIGEM = ":origem";
    private static final String HORA_REGISTRO_TRANSACAO = ":horaRegistroTransacao";
    private static final String DATA_REGISTRO_TRANSACAO = ":dataRegistroTransacao";
    private static final String SEQUENCIAL_TRANSACAO = ":sequencialTransacao";
    private static final String TIPO_TRANSACAO = ":tipoTransacao";
    private static final String IDENTIFICACAO_TRANSACAO = ":identificacaoTransacao";
    private final String FORMATO_DATA = "yyyy-MM-dd";
    private String FORMATO_TIMESTAMP = "yyyy-MM-dd'T'HH:mm:ss.S";
    private String FORMATO_HORA = "HH:mm:ss.S";
    Registro config = null;
    private String hashCalculado = "";
    private int sequencialItem = 0;
    private Integer segundos = 1;
    private Integer minutos = 0;
    private Integer hora = 0;
    private Integer codRequisicao = 0;
    public static final String TIPO_ATENDIMENTO_USAR_SITUACAO = "Utilizar tipo de atendimento da situa\u00e7\u00e3o";
    public static final String VERSAO_ARQUIVO = "versaoArquivo";
    public static final String VIA_ACESSO_UNICA = "\u00danica";
    public static final String VIA_ACESSO_MESMA_VIA = "Mesma V\u00eda";
    public static final String VIA_ACESSO_DIFERENTES_VIAS = "Diferentes v\u00edas";

    public static String getNomeProtocolo() {
        return "TISS";
    }

    public static String getExtensaoArquivo() {
        return "xml";
    }

    @Override
    public String configurar(JFrame parent, String xml) {
        String retorno = xml;
        ConfigurarTiss conf = new ConfigurarTiss(parent);
        conf.setXML(xml);
        conf.setVisible(true);
        if (conf.ok()) {
            retorno = conf.getXML();
            this.config = this.parseXMLConfiguracao(retorno);
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<ArquivoFaturamentoEletronico> criarArquivo(Object owner, int codigoFatura, String codigoConvenio, String diretorioArquivos) {
        ArrayList<ArquivoFaturamentoEletronico> retorno;
        Statement st;
        block7: {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            retorno = new ArrayList<ArquivoFaturamentoEletronico>();
            try {
                buf.append("select a.con_codigo, b.con_faturaeletronica, b.con_ordemfatura ");
                buf.append("from fatura a ");
                buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
                buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append(" and a.fat_codigo = ").append(codigoFatura);
                buf.append(" and a.fat_datacancelamento is null ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                String ordemFatura = null;
                if (rs.next()) {
                    this.config = this.parseXMLConfiguracao(rs.getString("con_faturaeletronica"));
                    this.config.setValor("con_codigo", rs.getString("con_codigo"));
                    ordemFatura = rs.getString("con_ordemfatura");
                }
                if (this.config == null) break block7;
                retorno = this.gerarArquivo(owner, st, codigoFatura, codigoConvenio, ordemFatura);
                buf.delete(0, buf.length());
                buf.append("update convenios set con_faturaeletronica = '").append(StringUtil.textoDB(this.registroToXML(this.config))).append("' ");
                buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append(" and con_codigo = ").append(this.config.getValor("con_codigo"));
                Conexao.execute(Variaveis.filialPadrao, st, buf);
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Tiss (63)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private ArrayList<ArquivoFaturamentoEletronico> gerarArquivo(Object parent, Statement st, int codigoFatura, String codigoConvenio, String ordemFatura) throws Exception {
        if (this.config == null) {
            throw new Exception("XML de configura\u00e7\u00e3o n\u00e3o informado");
        }
        if (this.config.getValor(VERSAO_ARQUIVO).toString().equals(VersaoTiss.V_3_00_01.getDescricao())) {
            this.config.setValor(VERSAO_ARQUIVO, VersaoTiss.V_3_01_00.getDescricao());
        }
        if (this.config.getBoolean("ignorarMilissegundos")) {
            this.FORMATO_TIMESTAMP = "yyyy-MM-dd'T'HH:mm:ss";
            this.FORMATO_HORA = "HH:mm:ss";
        }
        int sequencial = (Integer)this.config.getValor("sequencialLote");
        String tagANS = this.getTagAns();
        ArrayList<ArquivoFaturamentoEletronico> retorno = new ArrayList<ArquivoFaturamentoEletronico>();
        ArrayList<DadosTiss> listaRequisicoes = this.carregaRequisicoesFaturamento(st, codigoFatura, ordemFatura, tagANS);
        int posicao = 0;
        int contReq = 0;
        ArrayList<String> errosGeracao = new ArrayList<String>();
        while (contReq < listaRequisicoes.size()) {
            StringBuilder hashArquivo = new StringBuilder();
            if (this.config.getBoolean("solicitarLote")) {
                String novoSequencial = Funcoes.showDigitacao(parent instanceof Window ? (Window)parent : null, "Sequencial", "N\u00famero sequencial do lote", String.valueOf(sequencial));
                if (Funcoes.isNumeric(novoSequencial)) {
                    sequencial = Integer.parseInt(novoSequencial);
                }
            } else {
                ++sequencial;
            }
            this.config.setValor("sequencialLote", sequencial);
            DadosTiss.clearHashPrincipal();
            StringBuilder buf = new StringBuilder();
            XMLStringBuilder xmlPrincipal = new XMLStringBuilder();
            this.escreveHeader(xmlPrincipal, tagANS);
            HashMap<String, String> atributos = new HashMap<String, String>();
            atributos.put("xmlns:" + tagANS, "http://www.ans.gov.br/padroes/tiss/schemas");
            xmlPrincipal.abrir(tagANS + MENSAGEM_TISS, atributos);
            xmlPrincipal.abrir(tagANS + CABECALHO);
            boolean isVersaoAcima30001 = this.isVersaoAcima(VersaoTiss.V_3_00_01);
            this.escreveIdentificacao(tagANS, xmlPrincipal);
            this.escreveOrigem(tagANS, xmlPrincipal, isVersaoAcima30001);
            this.escreveDestino(tagANS, xmlPrincipal);
            this.escreveIdentificaoSoftware(tagANS, xmlPrincipal);
            xmlPrincipal.fechar(tagANS + CABECALHO);
            xmlPrincipal.abrir(tagANS + PRESTADOR_PARA_OPERADORA);
            xmlPrincipal.abrir(tagANS + LOTE_GUIAS);
            xmlPrincipal.escrever(tagANS + NUMERO_LOTE, DadosTiss.addHashPrincipal(this.config.getValor("sequencialLote").toString()));
            if (isVersaoAcima30001) {
                xmlPrincipal.abrir(tagANS + GUIAS_TISS);
            } else {
                xmlPrincipal.abrir(tagANS + GUIAS);
                xmlPrincipal.abrir(tagANS + GUIA_FATURAMENTO);
            }
            hashArquivo.append(DadosTiss.getHashPrincipal());
            int contador = 0;
            boolean arquivoCheio = false;
            while (contReq < listaRequisicoes.size()) {
                String xml = listaRequisicoes.get((int)contReq).linhaDados;
                String[] guias = StringUtil.getValores(xml, tagANS + ":guiaSP_SADT");
                if (!listaRequisicoes.get((int)contReq).erros.isEmpty()) {
                    errosGeracao.addAll(listaRequisicoes.get((int)contReq).erros);
                }
                int i = posicao;
                while (i < guias.length) {
                    xmlPrincipal.escrever(tagANS + (isVersaoAcima30001 ? GUIA_SP_SADT : ":guiaSP_SADT"), guias[i]);
                    String guia = StringUtil.getValor(guias[i], tagANS + ":numeroGuiaPrestador");
                    hashArquivo.append(listaRequisicoes.get(contReq).getHashGuia(guia));
                    if (++contador == Integer.parseInt(this.config.getValor("limiteGuiasArquivo").toString())) {
                        arquivoCheio = true;
                        ++i;
                        ++posicao;
                        break;
                    }
                    ++i;
                    ++posicao;
                }
                if (posicao == guias.length) {
                    posicao = 0;
                    ++contReq;
                }
                if (!arquivoCheio) continue;
                break;
            }
            if (isVersaoAcima30001) {
                xmlPrincipal.fechar(tagANS + GUIAS_TISS);
            } else {
                xmlPrincipal.fechar(tagANS + GUIA_FATURAMENTO);
                xmlPrincipal.fechar(tagANS + GUIAS);
            }
            xmlPrincipal.fechar(tagANS + LOTE_GUIAS);
            xmlPrincipal.fechar(tagANS + PRESTADOR_PARA_OPERADORA);
            xmlPrincipal.abrir(tagANS + EPILOGO);
            this.hashCalculado = StringUtil.calcularCodigoHash(hashArquivo.toString());
            xmlPrincipal.escrever(tagANS + HASH, this.hashCalculado);
            xmlPrincipal.fechar(tagANS + EPILOGO);
            xmlPrincipal.fechar(tagANS + MENSAGEM_TISS);
            String assinado = "";
            boolean assinarArquivoEletronico = this.config.getBoolean("assinarArquivoEletronico");
            if (assinarArquivoEletronico && this.isVersaoAcima(VersaoTiss.V_3_03_00)) {
                assinado = Tiss.assinarXML(xmlPrincipal.getXML());
            }
            String nomeArquivo = "fat_" + codigoConvenio + "_" + Funcoes.formataData("ddMMyyyy_HHmm", new Date()) + "_" + String.valueOf(retorno.size() + 1) + "." + Tiss.getExtensaoArquivo();
            if (this.config.getValor("nomeArquivoTiss") != null && this.config.getValor("nomeArquivoTiss").toString().equals("Padr\u00e3o Tiss")) {
                nomeArquivo = Funcoes.preencheZero(this.config.getValor("sequencialLote").toString(), 20) + "_" + this.hashCalculado + "." + Tiss.getExtensaoArquivo();
            }
            if (!this.isVersaoAcima(VersaoTiss.V_3_03_00) || !assinarArquivoEletronico) {
                retorno.add(new ArquivoFaturamentoEletronico(nomeArquivo, xmlPrincipal.getXML()));
                continue;
            }
            retorno.add(new ArquivoFaturamentoEletronico(nomeArquivo, assinado));
        }
        if (!errosGeracao.isEmpty()) {
            VisualizaErros ve = VisualizaErros.novaInstancia(parent, "Diverg\u00eancias na gera\u00e7\u00e3o do Tiss", errosGeracao);
            if (ve != null) {
                ve.dispose();
            }
            return new ArrayList<ArquivoFaturamentoEletronico>();
        }
        return retorno;
    }

    public static String assinarXML(String xml) throws Exception, CertificadoException {
        CertificadoHabilitadoAssinar certificado = null;
        String xmlAssinado = null;
        try {
            certificado = ResultadosUtil.tipoCertificacao(Variaveis.filialPadrao);
            if (certificado == null) {
                return xml;
            }
            certificado.setGerarArquivoXmlFisico(false);
            certificado.setXmlOriginal(xml);
            certificado = ResultadosUtil.assinarXmlLaudo(certificado);
            xmlAssinado = certificado.getXmlAssinado();
        }
        catch (Exception e) {
            throw new CertificadoException(e.getMessage());
        }
        return xmlAssinado;
    }

    private String getTagAns() {
        String tagANS = this.config.getValor(VERSAO_ARQUIVO).toString().equals(VersaoTiss.V_2_02_02.getDescricao()) || this.config.getValor(VERSAO_ARQUIVO).toString().equals(VersaoTiss.V_2_02_03.getDescricao()) ? "ansTISS" : "ans";
        return tagANS;
    }

    private ArrayList<DadosTiss> carregaRequisicoesFaturamento(Statement st, int codigoFatura, String ordemFatura, String tagANS) throws SQLException, XMLStringBuilderException {
        StringBuilder bui = new StringBuilder();
        bui.append("select a.req_codigo ");
        bui.append("      ,a.fil_kodigo ");
        bui.append("      ,COALESCE(c.con_codrepasse = a.con_codigo, false) as isRepasse ");
        bui.append("      ,CASE WHEN con.con_titdep = 'T' THEN COALESCE(NULLIF(TRIM(c.req_titular), ''), pac.pac_nome) ELSE pac.pac_nome END as ordemPaciente ");
        bui.append("  from faturarequisicao a ");
        bui.append("  join fatura b on a.fil_codigo = b.fil_codigo and a.fat_codigo = b.fat_codigo ");
        bui.append("  join requisicao c on a.fil_kodigo = c.fil_codigo and a.req_codigo = c.req_codigo ");
        bui.append("  join paciente pac on c.fil_codigo = pac.fil_codigo and c.pac_codigo = pac.pac_codigo ");
        bui.append("  join convenios con on b.fil_codigo = con.fil_codigo and b.con_codigo = con.con_codigo ");
        bui.append("  join medico med on c.fil_codigo = med.fil_codigo and c.med_crm = med.med_crm and c.med_uf = med.med_uf and c.med_conselho = med.med_conselho ");
        bui.append(" where b.fil_codigo = ").append(Variaveis.filialPadrao);
        bui.append("   and b.fat_codigo = ").append(codigoFatura);
        bui.append("   and b.fat_datacancelamento is null ");
        bui.append("   and c.req_excluida = false ");
        bui.append(" order by  ");
        if (ordemFatura == null || ordemFatura.equals("R")) {
            bui.append(" c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("D")) {
            bui.append(" c.req_data, c.fil_codigo, c.req_codigo ");
        } else if (ordemFatura.equals("F")) {
            bui.append(" c.req_dtfatura, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("N")) {
            bui.append(" ordemPaciente, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("G")) {
            bui.append(" c.req_guia, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("M")) {
            bui.append(" c.req_matricula, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("E")) {
            bui.append(" med.med_nome, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("C")) {
            bui.append(" med.med_crm, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("X")) {
            bui.append(" c.req_data, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("T")) {
            bui.append(" c.des_codigo, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("P")) {
            bui.append(" c.req_data, pac.pac_nome, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("W")) {
            bui.append(" c.ent_codempresa, c.fil_codigo, c.req_codigo ");
        }
        bui.append(" ,c.con_codigo ");
        ResultSet rs = Conexao.executeQuery(st, bui);
        ArrayList<Requisicao> requisicoes = new ArrayList<Requisicao>();
        while (rs.next()) {
            requisicoes.add(new Requisicao(rs.getInt("fil_kodigo"), rs.getInt("req_codigo"), rs.getBoolean("isRepasse")));
        }
        ArrayList<DadosTiss> listaRequisicoes = new ArrayList<DadosTiss>();
        for (int i = 0; i < requisicoes.size(); ++i) {
            int qtde;
            DadosTiss registro = new DadosTiss();
            registro.qtdeGuias = qtde = this.criarLoteGuias(st, codigoFatura, (Requisicao)requisicoes.get(i), tagANS, registro);
            listaRequisicoes.add(registro);
        }
        return listaRequisicoes;
    }

    private void escreveHeader(XMLStringBuilder xmlPrincipal, String tagANS) {
        if (this.config.getValor("codificacaoArquivo") == null || Funcoes.textoVazio(this.config.getValor("codificacaoArquivo").toString()) || this.config.getValor("codificacaoArquivo").toString().equalsIgnoreCase(FaturamentoEletronico.CODIFICACAO.UTF_8.toString())) {
            xmlPrincipal.escreveHeader("1.0", "UTF-8");
        } else if (this.config.getValor("codificacaoArquivo").toString().equalsIgnoreCase(FaturamentoEletronico.CODIFICACAO.ISO_8859_1.toString())) {
            xmlPrincipal.escreveHeader("1.0", "ISO-8859-1");
        }
    }

    private void escreveIdentificaoSoftware(String tagANS, XMLStringBuilder xmlPrincipal) throws XMLStringBuilderException {
        if (this.isVersaoAcima(VersaoTiss.V_3_02_02)) {
            xmlPrincipal.escrever(tagANS + ":Padrao", DadosTiss.addHashPrincipal(this.config.getValor(VERSAO_ARQUIVO).toString()));
        } else {
            xmlPrincipal.escrever(tagANS + VERSAO_PADRAO, DadosTiss.addHashPrincipal(this.config.getValor(VERSAO_ARQUIVO).toString()));
        }
        if (this.config.getValor(VERSAO_ARQUIVO).toString().equals(VersaoTiss.V_2_02_02.getDescricao()) || this.config.getValor(VERSAO_ARQUIVO).toString().equals(VersaoTiss.V_2_02_03.getDescricao())) {
            xmlPrincipal.abrir(tagANS + IDENTIFICACAO_SOFTWARE_GERADOR);
            xmlPrincipal.escrever(tagANS + NOME_APLICATIVO, DadosTiss.addHashPrincipal("Jalis"));
            xmlPrincipal.escrever(tagANS + VERSAO_APLICATIVO, DadosTiss.addHashPrincipal(ConstantesGerais.NRVERSAO));
            xmlPrincipal.escrever(tagANS + FABRICANTE_APLICATIVO, DadosTiss.addHashPrincipal("Thread Desenvolvimento de Software"));
            xmlPrincipal.fechar(tagANS + IDENTIFICACAO_SOFTWARE_GERADOR);
        }
    }

    private void escreveDestino(String tagANS, XMLStringBuilder xmlPrincipal) throws XMLStringBuilderException {
        xmlPrincipal.abrir(tagANS + DESTINO);
        xmlPrincipal.escrever(tagANS + REGISTRO_ANS, DadosTiss.addHashPrincipal(this.config.getValor("convenioRegistroANS").toString()));
        xmlPrincipal.fechar(tagANS + DESTINO);
    }

    private void escreveOrigem(String tagANS, XMLStringBuilder xmlPrincipal, boolean isVersaoAcima30001) throws XMLStringBuilderException {
        xmlPrincipal.abrir(tagANS + ORIGEM);
        xmlPrincipal.abrir(tagANS + (isVersaoAcima30001 ? IDENTIFICACAO_PRESTADOR : CODIGO_PRESTADOR_NA_OPERADORA));
        if (isVersaoAcima30001 && ValidaDoc.checkDoc(this.limpaCNPJ(this.config.getValor("cnpjPrestadorNaOperadora").toString()), 7) && !this.config.getBoolean("naoUtilizarCNPJPrestador")) {
            xmlPrincipal.escrever(tagANS + CNPJ, DadosTiss.addHashPrincipal(StringUtil.limpaString(this.config.getValor("cnpjPrestadorNaOperadora").toString(), new String[]{",", ".", "/", "-"})));
        } else if (ValidaDoc.checkDoc(this.limpaCNPJ(this.config.getValor("codigoPrestadorNaOperadora").toString()), 7)) {
            xmlPrincipal.escrever(tagANS + CNPJ, DadosTiss.addHashPrincipal(StringUtil.limpaString(this.config.getValor("codigoPrestadorNaOperadora").toString(), new String[]{",", ".", "/", "-"})));
        } else {
            xmlPrincipal.escrever(tagANS + CODIGO_PRESTADOR_NA_OPERADORA, DadosTiss.addHashPrincipal(StringUtil.limpaString(this.config.getValor("codigoPrestadorNaOperadora").toString(), new String[]{",", ".", "/", "-"})));
        }
        xmlPrincipal.fechar(tagANS + (isVersaoAcima30001 ? IDENTIFICACAO_PRESTADOR : CODIGO_PRESTADOR_NA_OPERADORA));
        xmlPrincipal.fechar(tagANS + ORIGEM);
    }

    private void escreveIdentificacao(String tagANS, XMLStringBuilder xmlPrincipal) throws XMLStringBuilderException {
        xmlPrincipal.abrir(tagANS + IDENTIFICACAO_TRANSACAO);
        xmlPrincipal.escrever(tagANS + TIPO_TRANSACAO, DadosTiss.addHashPrincipal("ENVIO_LOTE_GUIAS"));
        xmlPrincipal.escrever(tagANS + SEQUENCIAL_TRANSACAO, DadosTiss.addHashPrincipal(this.config.getValor("sequencialLote").toString()));
        xmlPrincipal.escrever(tagANS + DATA_REGISTRO_TRANSACAO, DadosTiss.addHashPrincipal(Funcoes.formataData("yyyy-MM-dd", new Date())));
        xmlPrincipal.escrever(tagANS + HORA_REGISTRO_TRANSACAO, DadosTiss.addHashPrincipal(Funcoes.formataData(this.FORMATO_HORA, new Date())));
        xmlPrincipal.fechar(tagANS + IDENTIFICACAO_TRANSACAO);
    }

    public static boolean verificaVersaoTiss3(String versaoTiss) {
        return versaoTiss.equals(VersaoTiss.V_3_01_00.getDescricao()) || versaoTiss.equals(VersaoTiss.V_3_02_00.getDescricao()) || versaoTiss.equals(VersaoTiss.V_3_02_01.getDescricao()) || versaoTiss.equalsIgnoreCase(VersaoTiss.V_3_02_02.getDescricao());
    }

    public boolean verificaVersaoTiss(String versao) {
        return this.config.getValor(VERSAO_ARQUIVO).toString().equals(versao);
    }

    private boolean isVersaoAcima(VersaoTiss versaoTiss) {
        String versao = this.config.getValor(VERSAO_ARQUIVO).toString().replace(".", "");
        return Integer.valueOf(versao) >= versaoTiss.getNumero();
    }

    private boolean isVersaoAcima(VersaoTiss versaoTiss, Registro registro) {
        String versao = registro.getValor(VERSAO_ARQUIVO).toString().replace(".", "");
        return Integer.valueOf(versao) >= versaoTiss.getNumero();
    }

    public static String pegaCodigoCBOTiss(String cbosPadraoConvenio, String cbosMedico, VersaoTiss versaoTiss) {
        String cbo = "";
        cbo = Tiss.validaCboValidoVersao3000(cbosPadraoConvenio, cbosMedico) ? Tiss.getCodigoCBO("", cbosPadraoConvenio, versaoTiss) : Tiss.getCodigoCBO(cbosMedico, cbosPadraoConvenio, versaoTiss);
        return cbo;
    }

    public static boolean validaCboValidoVersao3000(String cbosPadraoConvenio, String cbosMedico) {
        return cbosMedico.indexOf(46) <= 0 && cbosPadraoConvenio.indexOf(46) > 0;
    }

    public boolean verificaConselhoPermitido(VersaoTiss versaoTiss, String conselho) {
        if (versaoTiss == null || Funcoes.textoVazio(conselho)) {
            return false;
        }
        if (versaoTiss.isVersaoMaior(VersaoTiss.V_4_00_00) && !Funcoes.textoVazio(conselho)) {
            for (Conselho c : Conselho.values()) {
                if (!conselho.equals(c.getSigla())) continue;
                return true;
            }
        }
        if (!Funcoes.textoVazio(conselho)) {
            for (Conselho c : Conselho.values()) {
                if (c.isAPartirDaVersao4() || !conselho.equals(c.getSigla())) continue;
                return true;
            }
        }
        return false;
    }

    private int criarLoteGuias(Statement st, int codigoFatura, Requisicao requisicao, String tagANS, DadosTiss reg) throws SQLException, XMLStringBuilderException {
        XMLStringBuilder retorno = new XMLStringBuilder();
        StringBuilder bufGuias = this.getSqlGuias(codigoFatura, requisicao);
        ArrayList erros = new ArrayList();
        boolean existeTipoAtendimento = DBUtil.campoExiste(Conexao.getStatement(), "situacao", "sit_tipoatendimento");
        boolean versao30100_30200_30201 = this.isVersaoAcima(VersaoTiss.V_3_01_00);
        boolean isVersaoAcima30001 = this.isVersaoAcima(VersaoTiss.V_3_00_01);
        int qtde = 0;
        ResultSet rsGuias = Conexao.executeQuery(Conexao.getStatement(), bufGuias.toString());
        if (rsGuias != null) {
            while (rsGuias.next()) {
                ++qtde;
                StringBuilder bui = this.getSqlRequisicoesFaturamento(requisicao, existeTipoAtendimento, rsGuias);
                PreparedStatement pst = Conexao.getPreparedStatement(bui.toString());
                bui = this.getSqlAutorizacao(requisicao, rsGuias);
                PreparedStatement pstAutorizacao = Conexao.getPreparedStatement(bui.toString());
                HashMap<String, String> nomeExames = this.carregaAgrupaExames(st, codigoFatura, requisicao);
                pst.setInt(1, requisicao.filial);
                pst.setInt(2, codigoFatura);
                pst.setInt(3, requisicao.codigo);
                if (!(rsGuias == null || rsGuias.getString("guia") == null || Funcoes.textoVazio(rsGuias.getString("guia")) || rsGuias.getString("guia").equalsIgnoreCase("-1") || requisicao.isRepasse)) {
                    pst.setString(4, rsGuias.getString("guia"));
                    pst.setString(5, rsGuias.getString("guia"));
                }
                boolean isLimparCaracteresGuia = this.config.getBoolean("limparCaracteresGuia");
                ResultSet rs = Conexao.executeQuery(pst);
                if (rs.next()) {
                    boolean isAutorizacaoEscolhidaNotNull;
                    String guiaExame;
                    ResultSet rsAut;
                    boolean isAutorizacaoNotNull;
                    boolean isGuiaPrincipalNotNull;
                    String codigoGuia;
                    int configTamanhoGuia = Funcoes.textoVazio(this.config.getString("tamanhoGuia")) ? 0 : Integer.parseInt(this.config.getString("tamanhoGuia"));
                    String string = codigoGuia = rsGuias == null || rsGuias.getString("guia") == null ? "-1" : rsGuias.getString("guia");
                    if ((codigoGuia.equalsIgnoreCase("-1") || Funcoes.textoVazio(codigoGuia)) && this.config.getBoolean("guiaAutomatica")) {
                        codigoGuia = this.config.getBoolean("ignorarCodigoFilial") ? Funcoes.preencheZero(rs.getString("req_codigo"), 8) : Funcoes.preencheZero(rs.getString("fil_kodigo"), 2) + Funcoes.preencheZero(rs.getString("req_codigo"), 8);
                    } else if (codigoGuia.equalsIgnoreCase("-1") || Funcoes.textoVazio(codigoGuia)) {
                        codigoGuia = "";
                    } else if (isLimparCaracteresGuia) {
                        codigoGuia = StringUtil.limpaString(codigoGuia, new String[]{",", ".", "/", "-"});
                    }
                    String codigoGuiaPrincipal = rs.getString("req_guiaprincipal");
                    codigoGuiaPrincipal = StringUtil.limpaString(codigoGuiaPrincipal, new String[]{",", ".", "/", "-"});
                    String matricula = rs.getString("req_matricula");
                    if (!this.config.getBoolean("enviarCaracteresMatricula")) {
                        matricula = StringUtil.limpaString(matricula, new String[]{",", ".", "/", "-"});
                    }
                    matricula = StringUtil.testaTamanhoString(matricula, 40);
                    if (configTamanhoGuia > 0) {
                        codigoGuia = Funcoes.preencheZero(codigoGuia, configTamanhoGuia);
                        codigoGuiaPrincipal = Funcoes.preencheZero(codigoGuiaPrincipal, configTamanhoGuia);
                    }
                    retorno.abrir(tagANS + ":guiaSP_SADT");
                    boolean bl = isGuiaPrincipalNotNull = rs.getString("req_guiaprincipal") != null && !Funcoes.textoVazio(rs.getString("req_guiaprincipal"));
                    if (!isVersaoAcima30001) {
                        this.escreverIdentificacaoGuiaSADT(tagANS, reg, retorno, rs, codigoGuia, codigoGuiaPrincipal);
                        if (this.config.getBoolean("valorZeroGuiaPrincipal")) {
                            retorno.escrever(tagANS + ":numeroGuiaPrincipal", reg.addHashGuia(codigoGuia, "0"));
                        } else if (isGuiaPrincipalNotNull && !rs.getString("req_guiaprincipal").equalsIgnoreCase("null")) {
                            retorno.escrever(tagANS + ":numeroGuiaPrincipal", reg.addHashGuia(codigoGuia, codigoGuiaPrincipal));
                        }
                    }
                    this.escreverCabecalhoGuia(tagANS, reg, retorno, rs, codigoGuia, codigoGuiaPrincipal, isVersaoAcima30001);
                    pstAutorizacao.setInt(1, requisicao.filial);
                    pstAutorizacao.setInt(2, codigoFatura);
                    pstAutorizacao.setInt(3, requisicao.codigo);
                    boolean isGuiaNotNull = rsGuias != null && rsGuias.getString("guia") != null && !Funcoes.textoVazio(rsGuias.getString("guia")) && !rsGuias.getString("guia").equalsIgnoreCase("-1") && !requisicao.isRepasse;
                    boolean isUtilizarGuiaComoAutorizacao = this.config.getBoolean("utilizarGuiaComoAutorizacao");
                    if (isGuiaNotNull) {
                        pstAutorizacao.setString(4, rsGuias.getString("guia"));
                    }
                    boolean bl2 = isAutorizacaoNotNull = (rsAut = Conexao.executeQuery(pstAutorizacao)).next() && !DBUtil.campoNull(rsAut.getString("exr_codautorizacao")) && !Funcoes.textoVazio(rsAut.getString("exr_codautorizacao"));
                    if (isAutorizacaoNotNull || isUtilizarGuiaComoAutorizacao) {
                        retorno.abrir(tagANS + ":dadosAutorizacao");
                    }
                    class InfoAutorizacao {
                        String codigoAutorizacao;
                        Date dataAutorizacao;
                        Date validadeAutorizacao;

                        InfoAutorizacao() {
                        }

                        public String toString() {
                            return this.codigoAutorizacao + this.dataAutorizacao + this.validadeAutorizacao;
                        }
                    }
                    InfoAutorizacao autorizacaoEscolhida = null;
                    if (isAutorizacaoNotNull && !isUtilizarGuiaComoAutorizacao) {
                        AutorizacaoExame telaAutorizacao = new AutorizacaoExame((Frame)Laboratorio.getInstancia(), true, false);
                        ArrayList<InfoAutorizacao> listaAut = new ArrayList<InfoAutorizacao>();
                        do {
                            DadosMaterial mat = new DadosMaterial(0, rsAut.getString("mco_descricao"), false, false);
                            telaAutorizacao.adicionarExames(rsAut.getString("exa_codigo"), mat, rsAut.getString("exa_descricao"), rsAut.getString("exr_codautorizacao"), rsAut.getDate("dataAutorizacao"), rsAut.getDate("validadeAutorizacao"), rsAut.getString("exa_codigo"));
                            InfoAutorizacao infoAut = new InfoAutorizacao();
                            infoAut.codigoAutorizacao = rsAut.getString("exr_codautorizacao");
                            infoAut.dataAutorizacao = rsAut.getDate("dataAutorizacao");
                            infoAut.validadeAutorizacao = rsAut.getDate("validadeAutorizacao");
                            boolean jaInserido = false;
                            for (int i = 0; i < listaAut.size(); ++i) {
                                if (!((InfoAutorizacao)listaAut.get(i)).toString().equals(infoAut.toString())) continue;
                                jaInserido = true;
                                break;
                            }
                            if (jaInserido) continue;
                            listaAut.add(infoAut);
                        } while (rsAut.next());
                        if (listaAut.size() > 1) {
                            try {
                                if (telaAutorizacao.getCountExames() > 0) {
                                    telaAutorizacao.setVisible(true);
                                }
                                String codigoEscolhido = telaAutorizacao.getCodigoAutorizacaoEscolhida();
                                for (int i = 0; i < listaAut.size(); ++i) {
                                    if (!((InfoAutorizacao)listaAut.get((int)i)).codigoAutorizacao.equalsIgnoreCase(codigoEscolhido)) continue;
                                    autorizacaoEscolhida = (InfoAutorizacao)listaAut.get(i);
                                }
                            }
                            catch (Exception e) {
                                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                            }
                        } else {
                            autorizacaoEscolhida = (InfoAutorizacao)listaAut.get(0);
                        }
                    }
                    if (isVersaoAcima30001 && (isAutorizacaoNotNull || isUtilizarGuiaComoAutorizacao) && this.config.getBoolean("adicionarGuiaOperadora")) {
                        if (this.config.getBoolean("repetirGuiaOperadora") && Funcoes.textoVazio(rs.getString("req_guiaprincipal"))) {
                            retorno.escrever(tagANS + ":numeroGuiaOperadora", reg.addHashGuia(codigoGuia, codigoGuia));
                        } else {
                            retorno.escrever(tagANS + ":numeroGuiaOperadora", reg.addHashGuia(codigoGuia, codigoGuiaPrincipal));
                        }
                    }
                    String string2 = isGuiaNotNull ? rsGuias.getString("guia") : (guiaExame = isGuiaPrincipalNotNull ? rs.getString("req_guiaprincipal") : null);
                    if (isLimparCaracteresGuia) {
                        guiaExame = StringUtil.limpaString(codigoGuia, new String[]{",", ".", "/", "-"});
                    }
                    boolean bl3 = isAutorizacaoEscolhidaNotNull = autorizacaoEscolhida != null && autorizacaoEscolhida.codigoAutorizacao != null && !Funcoes.textoVazio(autorizacaoEscolhida.codigoAutorizacao) && autorizacaoEscolhida.dataAutorizacao != null;
                    if (isUtilizarGuiaComoAutorizacao || isAutorizacaoEscolhidaNotNull) {
                        Date dataAutorizacao = isUtilizarGuiaComoAutorizacao ? rs.getDate("dataGuia") : autorizacaoEscolhida.dataAutorizacao;
                        retorno.escrever(tagANS + ":dataAutorizacao", reg.addHashGuia(codigoGuia, Funcoes.formataData("yyyy-MM-dd", dataAutorizacao)));
                        if (isVersaoAcima30001) {
                            Date validadeAutorizacao;
                            retorno.escrever(tagANS + ":senha", reg.addHashGuia(codigoGuia, isUtilizarGuiaComoAutorizacao ? (guiaExame != null ? (guiaExame.length() > 20 ? guiaExame.substring(0, 20) : guiaExame) : codigoGuia) : (autorizacaoEscolhida.codigoAutorizacao.length() > 20 ? autorizacaoEscolhida.codigoAutorizacao.substring(0, 20) : autorizacaoEscolhida.codigoAutorizacao)));
                            Date date = isUtilizarGuiaComoAutorizacao ? (rs.getDate("validadeGuia") != null ? rs.getDate("validadeGuia") : rs.getDate("dataGuia")) : (validadeAutorizacao = autorizacaoEscolhida.validadeAutorizacao);
                            if (validadeAutorizacao != null) {
                                retorno.escrever(tagANS + ":dataValidadeSenha", reg.addHashGuia(codigoGuia, Funcoes.formataData("yyyy-MM-dd", validadeAutorizacao)));
                            }
                        } else {
                            Date validadeAutorizacao;
                            retorno.escrever(tagANS + ":senhaAutorizacao", reg.addHashGuia(codigoGuia, isUtilizarGuiaComoAutorizacao ? (guiaExame.length() > 20 ? guiaExame.substring(0, 20) : guiaExame) : (autorizacaoEscolhida.codigoAutorizacao.length() > 20 ? autorizacaoEscolhida.codigoAutorizacao.substring(0, 20) : autorizacaoEscolhida.codigoAutorizacao)));
                            Date date = validadeAutorizacao = isUtilizarGuiaComoAutorizacao && !isAutorizacaoEscolhidaNotNull ? rs.getDate("validadeGuia") : autorizacaoEscolhida.validadeAutorizacao;
                            if (validadeAutorizacao != null) {
                                retorno.escrever(tagANS + ":validadeSenha", reg.addHashGuia(codigoGuia, Funcoes.formataData("yyyy-MM-dd", validadeAutorizacao)));
                            }
                        }
                    }
                    if (isAutorizacaoNotNull || isUtilizarGuiaComoAutorizacao) {
                        retorno.fechar(tagANS + ":dadosAutorizacao");
                    }
                    this.escreverDadosBeneficiario(tagANS, reg, retorno, rs, codigoGuia, matricula, isVersaoAcima30001);
                    this.escreverDadosSolicitante(tagANS, reg, requisicao, retorno, rs, codigoGuia, isVersaoAcima30001);
                    String cbos = this.getCbos(rs);
                    this.escreverPrestadorExecutante(tagANS, reg, retorno, rs, codigoGuia, isVersaoAcima30001);
                    if (isVersaoAcima30001) {
                        this.escreverDadosSolicitacao(tagANS, reg, retorno, rs, codigoGuia);
                        this.escreverDadosExecutante(tagANS, reg, retorno, rs, codigoGuia, versao30100_30200_30201);
                        this.escreverDadosAtendimento(tagANS, reg, retorno, rs, codigoGuia, this.config);
                    } else {
                        retorno.escrever(tagANS + ":caraterAtendimento", reg.addHashGuia(codigoGuia, "E"));
                        if (this.config.getBoolean("utilizarDataColeta")) {
                            retorno.escrever(tagANS + ":dataHoraAtendimento", reg.addHashGuia(codigoGuia, Funcoes.formataData(this.FORMATO_TIMESTAMP, rs.getTimestamp("exr_datamaterial") == null ? rs.getTimestamp("exr_data") : rs.getTimestamp("exr_datamaterial"))));
                        } else {
                            retorno.escrever(tagANS + ":dataHoraAtendimento", reg.addHashGuia(codigoGuia, Funcoes.formataData(this.FORMATO_TIMESTAMP, rs.getTimestamp("exr_data"))));
                        }
                        String cid = this.pegaCodigoCid10(rs.getString("fil_codigo"), rs.getString("req_codigo"));
                        if (!Funcoes.textoVazio(cid)) {
                            this.escreverDiagnosticoAtendimento(tagANS, reg, retorno, codigoGuia, cid);
                        }
                        String descTipoAtendimento = this.config.getValor("tipoAtendimento").toString();
                        if (this.config.getBoolean("utilizarSADTInternado")) {
                            retorno.escrever(tagANS + ":tipoSaida", reg.addHashGuia(codigoGuia, "4"));
                            retorno.escrever(tagANS + ":tipoAtendimento", reg.addHashGuia(codigoGuia, "07"));
                        } else {
                            retorno.escrever(tagANS + ":tipoSaida", reg.addHashGuia(codigoGuia, "3"));
                            retorno.escrever(tagANS + ":tipoAtendimento", reg.addHashGuia(codigoGuia, TipoAtendimento.getCodigoPorTipoAtendimento(descTipoAtendimento)));
                        }
                    }
                    XMLStringBuilder retornoProcedimentos = new XMLStringBuilder();
                    XMLStringBuilder retornoOutrasDespesas = new XMLStringBuilder();
                    double valorTotalServicos = 0.0;
                    double valorTotalOutrasDespesas = 0.0;
                    int casasDecimais = ParametrosGerais.getCasasPrecoExame();
                    RoundingMode arredondamentoPreco = ParametrosGerais.getArredondamentoPrecoExame();
                    DadosConvenios dadosConvenios = ConvenioUtil.getDadosConvenios(rs.getString("fil_codigo"), rs.getInt("con_codigo"));
                    if (!Funcoes.objectIsNull(dadosConvenios) && dadosConvenios.getConvenioUtilizarCasasDecimais()) {
                        casasDecimais = dadosConvenios.getConvenioCasasPrecoExame();
                        arredondamentoPreco = dadosConvenios.getConvenioTipoArredondamentoPrecoRoundingMode();
                    }
                    int sequencialDespesa = 1;
                    do {
                        if (!rs.getBoolean("exa_servicotiss")) {
                            ++this.sequencialItem;
                            if (!versao30100_30200_30201) {
                                this.escreverProcedimentoExecutadoV1(tagANS, reg, retornoProcedimentos, nomeExames, rs, codigoGuia, isVersaoAcima30001, valorTotalServicos);
                                valorTotalServicos += rs.getDouble("total");
                                continue;
                            }
                            this.escreverProcedimentoExecutadoV2(tagANS, reg, retornoProcedimentos, nomeExames, rs, codigoGuia, cbos, isVersaoAcima30001, requisicao, this.sequencialItem, casasDecimais, arredondamentoPreco);
                            valorTotalServicos += rs.getDouble("total");
                            continue;
                        }
                        this.escreveDespesas(tagANS, retornoOutrasDespesas, sequencialDespesa, rs, nomeExames, casasDecimais, arredondamentoPreco, reg, codigoGuia);
                        valorTotalOutrasDespesas += rs.getDouble("total");
                        ++sequencialDespesa;
                    } while (rs.next());
                    if (!retornoProcedimentos.vazio()) {
                        retorno.abrir(tagANS + (isVersaoAcima30001 ? ":procedimentosExecutados" : ":procedimentosRealizados"));
                        retorno.escrever(this.removeQuebraLinha(retornoProcedimentos.getXML()));
                        retorno.fechar(tagANS + (isVersaoAcima30001 ? ":procedimentosExecutados" : ":procedimentosRealizados"));
                    }
                    if (!retornoOutrasDespesas.vazio()) {
                        retorno.abrir(tagANS.concat(":outrasDespesas"));
                        retorno.escrever(this.removeQuebraLinha(retornoOutrasDespesas.getXML()));
                        retorno.fechar(tagANS.concat(":outrasDespesas"));
                    }
                    retorno.abrir(tagANS + ":valorTotal");
                    BigDecimal bigDecimal = new BigDecimal(String.valueOf(valorTotalServicos)).setScale(casasDecimais, arredondamentoPreco);
                    retorno.escrever(tagANS + (isVersaoAcima30001 ? ":valorProcedimentos" : ":servicosExecutados"), reg.addHashGuia(codigoGuia, bigDecimal.toString()));
                    BigDecimal bigDeciamlOutrasDespesas = new BigDecimal(String.valueOf(valorTotalOutrasDespesas)).setScale(casasDecimais, arredondamentoPreco);
                    bigDecimal = new BigDecimal(String.valueOf(valorTotalServicos)).setScale(casasDecimais, arredondamentoPreco).add(bigDeciamlOutrasDespesas);
                    retorno.escrever(tagANS + (isVersaoAcima30001 ? ":valorTotalGeral" : ":totalGeral"), reg.addHashGuia(codigoGuia, bigDecimal.toString()));
                    retorno.fechar(tagANS + ":valorTotal");
                    retorno.fechar(tagANS + ":guiaSP_SADT");
                }
                Conexao.fecharStatement(pst);
            }
        }
        if (!erros.isEmpty()) {
            String msg = String.format("CBOS do m\u00e9dico ou conv\u00eanio configurado n\u00e3o \u00e9 v\u00e1lido para a vers\u00e3o do Tiss acima da %s:\n%s", VersaoTiss.V_3_00_01.getDescricao(), StringUtil.implode(erros, "\n"));
            reg.linhaDados = "";
            reg.erros.addAll(erros);
            return qtde;
        }
        reg.linhaDados = retorno.getXML();
        return qtde;
    }

    private String removeQuebraLinha(String xml) {
        if (!xml.isEmpty() && xml.substring(xml.length() - 1, xml.length()).equals("\n")) {
            return xml.substring(0, xml.length() - 1);
        }
        return xml;
    }

    private void escreverCabecalhoGuia(String tagANS, DadosTiss reg, XMLStringBuilder retorno, ResultSet rs, String codigoGuia, String codigoGuiaPrincipal, boolean isVersaoAcima30001) throws SQLException, XMLStringBuilderException {
        if (isVersaoAcima30001) {
            retorno.abrir(tagANS + ":cabecalhoGuia");
            retorno.escrever(tagANS + REGISTRO_ANS, reg.addHashGuia(codigoGuia, this.config.getValor("convenioRegistroANS").toString()));
            retorno.escrever(tagANS + ":numeroGuiaPrestador", reg.addHashGuia(codigoGuia, codigoGuia));
            String tmpTipoAtendimento = this.config.getValor("tipoAtendimento").toString();
            if (!Funcoes.textoVazio(tmpTipoAtendimento) && tmpTipoAtendimento.equalsIgnoreCase(TIPO_ATENDIMENTO_USAR_SITUACAO)) {
                String tmpTipoAtendimentoSituacao = rs.getString("sit_tipoatendimento");
                if (!Funcoes.textoVazio(tmpTipoAtendimentoSituacao) && tmpTipoAtendimentoSituacao.equalsIgnoreCase("07")) {
                    retorno.escrever(tagANS + ":guiaPrincipal", reg.addHashGuia(codigoGuia, this.config.getBoolean("valorZeroGuiaPrincipal") ? "0" : codigoGuiaPrincipal));
                }
            } else if (TipoAtendimento.getCodigoPorTipoAtendimento(tmpTipoAtendimento).equalsIgnoreCase("07")) {
                retorno.escrever(tagANS + ":guiaPrincipal", reg.addHashGuia(codigoGuia, this.config.getBoolean("valorZeroGuiaPrincipal") ? "0" : codigoGuiaPrincipal));
            }
            retorno.fechar(tagANS + ":cabecalhoGuia");
        }
    }

    private void escreverIdentificacaoGuiaSADT(String tagANS, DadosTiss reg, XMLStringBuilder retorno, ResultSet rs, String codigoGuia, String codigoGuiaPrincipal) throws SQLException, XMLStringBuilderException {
        retorno.abrir(tagANS + ":identificacaoGuiaSADTSP");
        retorno.abrir(tagANS + ":identificacaoFontePagadora");
        retorno.escrever(tagANS + REGISTRO_ANS, reg.addHashGuia(codigoGuia, StringUtil.limpaString(this.config.getString("registroANS").toString(), new String[]{",", ".", "/", "-"})));
        retorno.fechar(tagANS + ":identificacaoFontePagadora");
        retorno.escrever(tagANS + ":dataEmissaoGuia", reg.addHashGuia(codigoGuia, Funcoes.formataData("yyyy-MM-dd", rs.getDate("dataGuia"))));
        retorno.escrever(tagANS + ":numeroGuiaPrestador", reg.addHashGuia(codigoGuia, codigoGuia));
        if (this.config.getBoolean("adicionarGuiaOperadora")) {
            if (this.config.getBoolean("repetirGuiaOperadora") && Funcoes.textoVazio(rs.getString("req_guiaprincipal"))) {
                retorno.escrever(tagANS + ":numeroGuiaOperadora", reg.addHashGuia(codigoGuia, codigoGuia));
            } else {
                retorno.escrever(tagANS + ":numeroGuiaOperadora", reg.addHashGuia(codigoGuia, codigoGuiaPrincipal));
            }
        }
        retorno.fechar(tagANS + ":identificacaoGuiaSADTSP");
    }

    private void escreverProcedimentoExecutadoV2(String tagANS, DadosTiss reg, XMLStringBuilder retorno, HashMap<String, String> nomeExames, ResultSet rs, String codigoGuia, String cbos, boolean isVersaoAcima30001, Requisicao requisicao, int sequencialItem, int casasDecimais, RoundingMode arredondamentoPreco) throws SQLException, XMLStringBuilderException {
        retorno.abrir(tagANS + ":procedimentoExecutado");
        if (this.isVersaoAcima(VersaoTiss.V_3_04_00)) {
            retorno.escrever(tagANS + ":sequencialItem", reg.addHashGuia(codigoGuia, String.valueOf(sequencialItem)));
        }
        if (this.config != null && this.config.getBoolean("utilizarDataColeta")) {
            retorno.escrever(tagANS + ":dataExecucao", reg.addHashGuia(codigoGuia, Funcoes.formataData("yyyy-MM-dd", rs.getTimestamp("exr_datamaterial") == null ? rs.getTimestamp("exr_data") : rs.getTimestamp("exr_datamaterial"))));
        } else {
            retorno.escrever(tagANS + ":dataExecucao", reg.addHashGuia(codigoGuia, Funcoes.formataData("yyyy-MM-dd", rs.getTimestamp("exr_data"))));
        }
        if (Boolean.valueOf(this.config.getString("enviarHorarioProcedimentos")).booleanValue()) {
            Integer n;
            Object object;
            Timestamp horaMinuto = rs.getTimestamp("req_hora");
            Calendar c = Calendar.getInstance();
            c.setTime(horaMinuto);
            if (this.codRequisicao.equals(0) || !this.codRequisicao.equals(requisicao.codigo)) {
                this.hora = c.get(11);
                this.minutos = c.get(12);
                this.segundos = 1;
                this.codRequisicao = requisicao.codigo;
            }
            if (this.segundos > 1) {
                Tiss tiss = this;
                object = tiss.segundos;
                n = tiss.segundos = Integer.valueOf(tiss.segundos + 1);
            }
            StringBuilder h = new StringBuilder();
            h.append(this.hora.toString().length() < 2 ? "0" + this.hora.toString() : this.hora.toString()).append(":");
            h.append(this.minutos.toString().length() < 2 ? "0" + this.minutos.toString() : this.minutos.toString()).append(":");
            h.append(this.segundos.toString().length() < 2 ? "0" + this.segundos.toString() : this.segundos.toString());
            retorno.escrever(tagANS + ":horaInicial", reg.addHashGuia(codigoGuia, h.toString()));
            if (this.segundos == 59) {
                this.segundos = 0;
                object = this;
                n = ((Tiss)object).minutos;
                Integer n2 = ((Tiss)object).minutos = Integer.valueOf(((Tiss)object).minutos + 1);
                if (this.minutos == 60) {
                    this.minutos = 0;
                    object = this;
                    n = ((Tiss)object).hora;
                    n2 = ((Tiss)object).hora = Integer.valueOf(((Tiss)object).hora + 1);
                }
            }
            object = this.segundos;
            n = this.segundos = Integer.valueOf(this.segundos + 1);
            h.delete(0, h.length());
            h.append(this.hora.toString().length() < 2 ? "0" + this.hora.toString() : this.hora.toString()).append(":");
            h.append(this.minutos.toString().length() < 2 ? "0" + this.minutos.toString() : this.minutos.toString()).append(":");
            h.append(this.segundos.toString().length() < 2 ? "0" + this.segundos.toString() : this.segundos.toString());
            retorno.escrever(tagANS + ":horaFinal", reg.addHashGuia(codigoGuia, h.toString()));
        }
        retorno.abrir(tagANS + ":procedimento");
        retorno.escrever(tagANS + ":codigoTabela", reg.addHashGuia(codigoGuia, rs.getString("tpe_tabelaans")));
        retorno.escrever(tagANS + ":codigoProcedimento", reg.addHashGuia(codigoGuia, StringUtil.testaTamanhoString(StringUtil.limpaString(rs.getString("dtp_codamb"), new String[]{"-", "/", "\\", ".", ","}), 10)));
        if (nomeExames.containsKey(rs.getString("dtp_codamb"))) {
            String descricaoExame = nomeExames.get(rs.getString("dtp_codamb"));
            descricaoExame = descricaoExame.length() > 60 ? descricaoExame.substring(0, 59) : descricaoExame;
            retorno.escrever(tagANS + ":descricaoProcedimento", reg.addHashGuia(codigoGuia, StringUtil.removerAcentos(descricaoExame)));
        }
        retorno.fechar(tagANS + ":procedimento");
        retorno.escrever(tagANS + ":quantidadeExecutada", reg.addHashGuia(codigoGuia, rs.getString("contagem")));
        if (this.verificaVersaoTiss(VersaoTiss.V_3_05_00.getDescricao())) {
            if (!this.config.getBoolean("naoUtilizaViaAcesso")) {
                String viaAcesso = this.config.getString("viaDeAcesso") != "" ? this.config.getString("viaDeAcesso") : "1";
                retorno.escrever(tagANS + ":viaAcesso", reg.addHashGuia(codigoGuia, viaAcesso));
            }
            if (!this.config.getBoolean("naoInformaTecnicaUtilizada")) {
                retorno.escrever(tagANS + ":tecnicaUtilizada", reg.addHashGuia(codigoGuia, "1"));
            }
        } else {
            retorno.escrever(tagANS + ":viaAcesso", reg.addHashGuia(codigoGuia, "1"));
            retorno.escrever(tagANS + ":tecnicaUtilizada", reg.addHashGuia(codigoGuia, "1"));
        }
        retorno.escrever(tagANS + ":reducaoAcrescimo", reg.addHashGuia(codigoGuia, "1.00"));
        BigDecimal bigDecimal = new BigDecimal(rs.getString("mediapreco")).setScale(casasDecimais, arredondamentoPreco);
        retorno.escrever(tagANS + ":valorUnitario", reg.addHashGuia(codigoGuia, bigDecimal.toString()));
        bigDecimal = new BigDecimal(rs.getString("total")).setScale(casasDecimais, arredondamentoPreco);
        retorno.escrever(tagANS + ":valorTotal", reg.addHashGuia(codigoGuia, bigDecimal.toString()));
        if (!Funcoes.textoVazio(this.config.getValor("nomeExecutante").toString()) && !Funcoes.textoVazio(this.config.getString("codigoPrestadorNaOperadora").toString())) {
            String erro;
            String x;
            retorno.abrir(tagANS + ":equipeSadt");
            boolean naoUtilizarGrauParticipacao = this.config.getBoolean("naoUtilizarGrauParticipacao");
            if (!naoUtilizarGrauParticipacao) {
                retorno.escrever(tagANS + ":grauPart", reg.addHashGuia(codigoGuia, this.config.getValor("grauParticipacaoExecutante").toString()));
            }
            retorno.abrir(tagANS + ":codProfissional");
            retorno.escrever(tagANS + CODIGO_PRESTADOR_NA_OPERADORA, reg.addHashGuia(codigoGuia, StringUtil.limpaString(this.config.getString("codigoPrestadorNaOperadora").toString(), new String[]{",", ".", "/", "-"})));
            retorno.fechar(tagANS + ":codProfissional");
            retorno.escrever(tagANS + ":nomeProf", reg.addHashGuia(codigoGuia, this.trocaCaracteres(this.config.getValor("nomeExecutante").toString())));
            VersaoTiss versaoTiss = VersaoTiss.getVersaoPorDescricao(this.config.getString(VERSAO_ARQUIVO));
            retorno.escrever(tagANS + ":conselho", reg.addHashGuia(codigoGuia, Tiss.getCodigoTermoConselho(this.config.getValor("conselhoExecutante").toString(), versaoTiss)));
            retorno.escrever(tagANS + ":numeroConselhoProfissional", reg.addHashGuia(codigoGuia, this.config.getValor("codigoExecutante").toString()));
            retorno.escrever(tagANS + ":UF", reg.addHashGuia(codigoGuia, Tiss.getCodigoTermoUF(this.config.getValor("ufExecutante").toString())));
            boolean isVersaoAcima40000 = this.isVersaoAcima(VersaoTiss.V_4_00_00);
            String cbosPadraoConvenio = "";
            String cboMedico = StringUtil.getValor(StringUtil.getValor(rs.getString("med_cbo"), "cbo"), "codigo");
            if (CBOS.getDescCBO(this.config.getString("cbosPadrao")) != null) {
                cbosPadraoConvenio = CBOS.getDescCBO((String)this.config.getString((String)"cbosPadrao")).codigo;
            }
            String cbosTiss = Tiss.getCodigoCBO(cboMedico, cbosPadraoConvenio, VersaoTiss.getVersaoPorDescricao(this.config.getString(VERSAO_ARQUIVO)));
            String string = x = Funcoes.textoVazio(rs.getString("med_cbo")) && !Funcoes.textoVazio(this.config.getString("cbosPadrao")) ? cbosPadraoConvenio : cboMedico;
            if (!(x.indexOf(46) > 0 || !isVersaoAcima30001 || Funcoes.textoVazio(cbosPadraoConvenio) && Funcoes.textoVazio(x) || reg.erros.contains(erro = String.format("Filial: %s Requisi\u00e7\u00e3o: %s Conv\u00eanio: %s CBOS do conv\u00eanio: %s CBOS do m\u00e9dico: %s ", requisicao.filial, requisicao.codigo, rs.getString("con_codigo"), cbosPadraoConvenio, cboMedico)))) {
                reg.erros.add(erro);
            }
            retorno.escrever(tagANS + ":CBOS", reg.addHashGuia(codigoGuia, Tiss.getCodigoCBO("", cbosPadraoConvenio, VersaoTiss.getVersaoPorDescricao(this.config.getString(VERSAO_ARQUIVO)))));
            retorno.fechar(tagANS + ":equipeSadt");
        }
        retorno.fechar(tagANS + ":procedimentoExecutado");
    }

    private void escreveDespesas(String tagANS, XMLStringBuilder retorno, int sequenciaItem, ResultSet rs, HashMap<String, String> nomeExames, int casasDecimais, RoundingMode arredondamentoPreco, DadosTiss reg, String codigoGuia) throws XMLStringBuilderException, SQLException {
        String codigoDespesa = rs.getString("exa_coddespesatiss");
        String dataExecucao = "";
        Timestamp dateDataExecucao = rs.getTimestamp("exr_data");
        if (this.config.getBoolean("utilizarDataColeta") && !Funcoes.textoVazio(rs.getString("exr_datamaterial"))) {
            dateDataExecucao = rs.getTimestamp("exr_datamaterial");
        }
        if (!Funcoes.objectIsNull(dateDataExecucao)) {
            dataExecucao = Funcoes.formataData("yyyy-MM-dd", dateDataExecucao);
        }
        String hora = "";
        if (!Funcoes.textoVazio(rs.getString("exr_data"))) {
            hora = Funcoes.formataHora(rs.getTimestamp("exr_data"), true);
        }
        String codigoTabela = rs.getString("tpe_tabservicotiss");
        String codigoProcedimento = StringUtil.testaTamanhoString(StringUtil.limpaString(rs.getString("dtp_codamb"), new String[]{"-", "/", "\\", ".", ","}), 10);
        String quantidadeExecutada = rs.getString("contagem");
        String unidadeMedida = rs.getString("exa_undmedidatiss");
        if (!Funcoes.textoVazio(unidadeMedida)) {
            unidadeMedida = Funcoes.preencheZero(unidadeMedida, 3);
        }
        String reducaoAcrescimo = "1.00";
        BigDecimal bigDecimal = new BigDecimal(rs.getString("mediapreco")).setScale(casasDecimais, arredondamentoPreco);
        String valorUnitario = bigDecimal.toString();
        bigDecimal = new BigDecimal(rs.getString("total")).setScale(casasDecimais, arredondamentoPreco);
        String valorTotal = bigDecimal.toString();
        String descricaoProcedimento = "";
        if (nomeExames.containsKey(rs.getString("dtp_codamb"))) {
            descricaoProcedimento = nomeExames.get(rs.getString("dtp_codamb"));
        }
        retorno.abrir(tagANS.concat(":despesa"));
        retorno.escrever(tagANS.concat(":sequencialItem"), reg.addHashGuia(codigoGuia, String.valueOf(sequenciaItem)));
        retorno.escrever(tagANS.concat(":codigoDespesa"), reg.addHashGuia(codigoGuia, codigoDespesa));
        retorno.abrir(tagANS.concat(":servicosExecutados"));
        retorno.escrever(tagANS.concat(":dataExecucao"), reg.addHashGuia(codigoGuia, dataExecucao));
        retorno.escrever(tagANS.concat(":horaInicial"), reg.addHashGuia(codigoGuia, hora));
        retorno.escrever(tagANS.concat(":horaFinal"), reg.addHashGuia(codigoGuia, hora));
        retorno.escrever(tagANS.concat(":codigoTabela"), reg.addHashGuia(codigoGuia, codigoTabela));
        retorno.escrever(tagANS.concat(":codigoProcedimento"), reg.addHashGuia(codigoGuia, codigoProcedimento));
        retorno.escrever(tagANS.concat(":quantidadeExecutada"), reg.addHashGuia(codigoGuia, quantidadeExecutada));
        retorno.escrever(tagANS.concat(":unidadeMedida"), reg.addHashGuia(codigoGuia, unidadeMedida));
        retorno.escrever(tagANS.concat(":reducaoAcrescimo"), reg.addHashGuia(codigoGuia, reducaoAcrescimo));
        retorno.escrever(tagANS.concat(":valorUnitario"), reg.addHashGuia(codigoGuia, valorUnitario));
        retorno.escrever(tagANS.concat(":valorTotal"), reg.addHashGuia(codigoGuia, valorTotal));
        retorno.escrever(tagANS.concat(":descricaoProcedimento"), reg.addHashGuia(codigoGuia, StringUtil.removerAcentos(descricaoProcedimento)));
        retorno.fechar(tagANS.concat(":servicosExecutados"));
        retorno.fechar(tagANS.concat(":despesa"));
    }

    private void escreverProcedimentoExecutadoV1(String tagANS, DadosTiss reg, XMLStringBuilder retorno, HashMap<String, String> nomeExames, ResultSet rs, String codigoGuia, boolean isVersaoAcima30001, double valorTotalServicos) throws SQLException, XMLStringBuilderException {
        if (isVersaoAcima30001) {
            retorno.abrir(tagANS + ":procedimentoExecutado");
            if (this.config.getBoolean("utilizarDataColeta")) {
                retorno.escrever(tagANS + ":dataExecucao", reg.addHashGuia(codigoGuia, Funcoes.formataData("yyyy-MM-dd", rs.getTimestamp("exr_datamaterial") == null ? rs.getTimestamp("exr_data") : rs.getTimestamp("exr_datamaterial"))));
            } else {
                retorno.escrever(tagANS + ":dataExecucao", reg.addHashGuia(codigoGuia, Funcoes.formataData("yyyy-MM-dd", rs.getTimestamp("exr_data"))));
            }
            retorno.abrir(tagANS + ":procedimento");
            retorno.escrever(tagANS + ":codigoTabela", reg.addHashGuia(codigoGuia, rs.getString("tpe_tabelaans")));
            retorno.escrever(tagANS + ":codigoProcedimento", reg.addHashGuia(codigoGuia, StringUtil.testaTamanhoString(StringUtil.limpaString(rs.getString("dtp_codamb"), new String[]{"-", "/", "\\", ".", ","}), 10)));
        } else {
            retorno.abrir(tagANS + ":procedimentos");
            retorno.abrir(tagANS + ":procedimento");
            retorno.escrever(tagANS + ":codigo", reg.addHashGuia(codigoGuia, StringUtil.testaTamanhoString(StringUtil.limpaString(rs.getString("dtp_codamb"), new String[]{"-", "/", "\\", ".", ","}), 10)));
            retorno.escrever(tagANS + ":tipoTabela", reg.addHashGuia(codigoGuia, rs.getString("tpe_tabelaans")));
        }
        if (nomeExames.containsKey(rs.getString("dtp_codamb"))) {
            String descricaoExame = nomeExames.get(rs.getString("dtp_codamb"));
            descricaoExame = descricaoExame.length() > 60 ? descricaoExame.substring(0, 59) : descricaoExame;
            retorno.escrever(tagANS + (isVersaoAcima30001 ? ":descricaoProcedimento" : ":descricao"), reg.addHashGuia(codigoGuia, StringUtil.removerAcentos(descricaoExame)));
        }
        retorno.fechar(tagANS + ":procedimento");
        if (!isVersaoAcima30001) {
            if (this.config.getBoolean("utilizarDataColeta")) {
                retorno.escrever(tagANS + ":data", reg.addHashGuia(codigoGuia, Funcoes.formataData("yyyy-MM-dd", rs.getTimestamp("exr_datamaterial") == null ? rs.getTimestamp("exr_data") : rs.getTimestamp("exr_datamaterial"))));
            } else {
                retorno.escrever(tagANS + ":data", reg.addHashGuia(codigoGuia, Funcoes.formataData("yyyy-MM-dd", rs.getTimestamp("exr_data"))));
            }
        }
        retorno.escrever(tagANS + (isVersaoAcima30001 ? ":quantidadeExecutada" : ":quantidadeRealizada"), reg.addHashGuia(codigoGuia, rs.getString("contagem")));
        retorno.escrever(tagANS + (isVersaoAcima30001 ? ":valorUnitario" : ":valor"), reg.addHashGuia(codigoGuia, Funcoes.limpaDecimal(Funcoes.formataDecimal(rs.getDouble("mediapreco")))));
        retorno.escrever(tagANS + ":valorTotal", reg.addHashGuia(codigoGuia, Funcoes.limpaDecimal(Funcoes.formataDecimal(rs.getDouble("total")))));
        retorno.fechar(tagANS + (isVersaoAcima30001 ? ":procedimentoExecutado" : ":procedimentos"));
    }

    private void escreverDiagnosticoAtendimento(String tagANS, DadosTiss reg, XMLStringBuilder retorno, String codigoGuia, String cid) throws XMLStringBuilderException {
        retorno.abrir(tagANS + ":diagnosticoAtendimento");
        retorno.abrir(tagANS + ":CID");
        retorno.escrever(tagANS + ":nomeTabela", reg.addHashGuia(codigoGuia, "CID-10"));
        if (this.config.getBoolean("enviarCID10SemMascara")) {
            cid = StringUtil.limpaString(cid, new String[]{",", ".", "/", "-"});
        }
        retorno.escrever(tagANS + ":codigoDiagnostico", reg.addHashGuia(codigoGuia, cid));
        retorno.fechar(tagANS + ":CID");
        retorno.fechar(tagANS + ":diagnosticoAtendimento");
    }

    private void escreverDadosAtendimento(String tagANS, DadosTiss reg, XMLStringBuilder retorno, ResultSet rs, String codigoGuia, Registro config) throws SQLException, XMLStringBuilderException {
        String descTipoAtendimento = rs.getString("sit_tipoatendimento");
        String descIndicadorAcidente = config.getValor("indicadorAcidente").toString();
        retorno.abrir(tagANS + ":dadosAtendimento");
        String codigoTipoAtendimento = config.getValor("tipoAtendimento").toString();
        if (codigoTipoAtendimento.equals(TipoAtendimento.TIPO_ATENDIMENTO_SITUACAO.getDescricao())) {
            codigoTipoAtendimento = !Funcoes.textoVazio(descTipoAtendimento) ? descTipoAtendimento : null;
            retorno.escrever(tagANS + ":tipoAtendimento", reg.addHashGuia(codigoGuia, codigoTipoAtendimento));
        } else {
            retorno.escrever(tagANS + ":tipoAtendimento", reg.addHashGuia(codigoGuia, TipoAtendimento.getCodigoPorTipoAtendimento(codigoTipoAtendimento)));
        }
        retorno.escrever(tagANS + ":indicacaoAcidente", reg.addHashGuia(codigoGuia, Tiss.getCodigoIndicadorAcidente(descIndicadorAcidente)));
        if (this.isVersaoAcima(VersaoTiss.V_4_00_00)) {
            String regimeAtendimento = rs.getString("sit_regimeatendimento");
            if (Funcoes.textoVazio(regimeAtendimento)) {
                regimeAtendimento = RegimeAtendimento.getRegimeAtendimentoPorCodigoEDescricao(config.getString("regimeAtendimento")).getCodigo();
            }
            retorno.escrever(tagANS + ":regimeAtendimento", reg.addHashGuia(codigoGuia, regimeAtendimento));
            boolean enviaSaudeOcupacional = Boolean.valueOf(config.getString("enviarSaudeOcupacional"));
            String saudeOcupacional = rs.getString("sit_saudeocupacional");
            if (this.isVersaoAcima(VersaoTiss.V_4_00_00) && enviaSaudeOcupacional && !Funcoes.textoVazio(saudeOcupacional)) {
                retorno.escrever(tagANS + ":saudeOcupacional", reg.addHashGuia(codigoGuia, saudeOcupacional));
            }
        }
        retorno.fechar(tagANS + ":dadosAtendimento");
    }

    private void escreverDadosExecutante(String tagANS, DadosTiss reg, XMLStringBuilder retorno, ResultSet rs, String codigoGuia, boolean versao30100_30200_30201) throws SQLException, XMLStringBuilderException {
        retorno.abrir(tagANS + ":dadosExecutante");
        if (!versao30100_30200_30201 && !Funcoes.textoVazio(this.config.getString("codigoPrestadorNaOperadora").toString())) {
            retorno.escrever(tagANS + ":codigonaOperadora", reg.addHashGuia(codigoGuia, StringUtil.limpaString(this.config.getString("codigoPrestadorNaOperadora").toString(), new String[]{",", ".", "/", "-"})));
        }
        if (versao30100_30200_30201) {
            retorno.abrir(tagANS + ":contratadoExecutante");
            if (this.config.getBoolean("naoUtilizarCNPJPrestador")) {
                retorno.escrever(tagANS + CODIGO_PRESTADOR_NA_OPERADORA, reg.addHashGuia(codigoGuia, this.config.getValor("codigoPrestadorNaOperadora").toString()));
            } else {
                String cnpjContratado = this.limpaCNPJ(this.config.getValor("cnpjPrestadorNaOperadora").toString());
                if (Funcoes.textoVazio(cnpjContratado)) {
                    cnpjContratado = this.limpaCNPJ(rs.getString("fil_cnpj"));
                }
                if (!Funcoes.textoVazio(cnpjContratado) && ValidaDoc.checkDoc(cnpjContratado, 7)) {
                    retorno.escrever(tagANS + ":cnpjContratado", reg.addHashGuia(codigoGuia, cnpjContratado));
                }
            }
            if (!this.isVersaoAcima(VersaoTiss.V_4_00_00)) {
                retorno.escrever(tagANS + ":nomeContratado", reg.addHashGuia(codigoGuia, StringUtil.removerAcentos(rs.getString("fil_razaosocial"))));
            }
            retorno.fechar(tagANS + ":contratadoExecutante");
        } else if (!this.isVersaoAcima(VersaoTiss.V_4_00_00)) {
            retorno.escrever(tagANS + ":nomeContratado", reg.addHashGuia(codigoGuia, StringUtil.removerAcentos(rs.getString("fil_razaosocial"))));
        }
        retorno.escrever(tagANS + ":CNES", reg.addHashGuia(codigoGuia, rs.getString("fil_cnes")));
        retorno.fechar(tagANS + ":dadosExecutante");
    }

    private void escreverDadosSolicitacao(String tagANS, DadosTiss reg, XMLStringBuilder retorno, ResultSet rs, String codigoGuia) throws SQLException, XMLStringBuilderException {
        retorno.abrir(tagANS + ":dadosSolicitacao");
        if (this.config.getBoolean("utilizarDataColeta")) {
            retorno.escrever(tagANS + ":dataSolicitacao", reg.addHashGuia(codigoGuia, Funcoes.formataData("yyyy-MM-dd", rs.getTimestamp("exr_datamaterial") == null ? rs.getTimestamp("exr_data") : rs.getTimestamp("exr_datamaterial"))));
        } else {
            retorno.escrever(tagANS + ":dataSolicitacao", reg.addHashGuia(codigoGuia, Funcoes.formataData("yyyy-MM-dd", rs.getTimestamp("exr_data"))));
        }
        retorno.escrever(tagANS + ":caraterAtendimento", reg.addHashGuia(codigoGuia, "1"));
        if (this.config.getBoolean("enviarIndicacaoClinica") && !Funcoes.textoVazio(rs.getString("req_dclinicos"))) {
            retorno.escrever(tagANS + ":indicacaoClinica", reg.addHashGuia(codigoGuia, rs.getString("req_dclinicos")));
        }
        boolean enviarIDCobEspecial = Boolean.valueOf(this.config.getString("enviarIdCoberturaEspecial"));
        String idCoberturaEspecial = rs.getString("sit_idcoberturaespecial");
        if (this.isVersaoAcima(VersaoTiss.V_4_00_00) && enviarIDCobEspecial && !Funcoes.textoVazio(idCoberturaEspecial)) {
            retorno.escrever(tagANS + ":indCobEspecial", reg.addHashGuia(codigoGuia, idCoberturaEspecial));
        }
        retorno.fechar(tagANS + ":dadosSolicitacao");
    }

    private void escreverPrestadorExecutante(String tagANS, DadosTiss reg, XMLStringBuilder retorno, ResultSet rs, String codigoGuia, boolean isVersaoAcima30001) throws SQLException, XMLStringBuilderException {
        if (!isVersaoAcima30001) {
            String cnpj;
            retorno.abrir(tagANS + ":prestadorExecutante");
            retorno.abrir(tagANS + ":identificacao");
            String string = cnpj = !DBUtil.campoNull(rs.getString("fil_cnpj")) ? StringUtil.limpaString(rs.getString("fil_cnpj"), new String[]{",", ".", "/", "-"}) : "";
            if (!Funcoes.textoVazio(cnpj) && this.config.getBoolean("adicionarCNPJOperadora")) {
                retorno.escrever(tagANS + CNPJ, reg.addHashGuia(codigoGuia, cnpj));
            } else {
                retorno.escrever(tagANS + CODIGO_PRESTADOR_NA_OPERADORA, reg.addHashGuia(codigoGuia, StringUtil.limpaString(this.config.getString("codigoPrestadorNaOperadora").toString(), new String[]{",", ".", "/", "-"})));
            }
            retorno.fechar(tagANS + ":identificacao");
            retorno.escrever(tagANS + ":nomeContratado", reg.addHashGuia(codigoGuia, this.trocaCaracteres(rs.getString("fil_razaosocial"))));
            retorno.escrever(tagANS + ":numeroCNES", reg.addHashGuia(codigoGuia, StringUtil.limpaString(StringUtil.testaTamanhoString(rs.getString("fil_cnes"), 7), new String[]{",", ".", "/", "-"})));
            if (!Funcoes.textoVazio(this.config.getValor("nomeExecutante").toString())) {
                retorno.abrir(tagANS + ":profissionalExecutanteCompl");
                retorno.escrever(tagANS + ":nomeExecutante", reg.addHashGuia(codigoGuia, this.config.getValor("nomeExecutante").toString()));
                retorno.abrir(tagANS + ":conselhoProfissional");
                retorno.escrever(tagANS + ":siglaConselho", reg.addHashGuia(codigoGuia, this.config.getValor("conselhoExecutante").toString()));
                retorno.escrever(tagANS + ":numeroConselho", reg.addHashGuia(codigoGuia, this.config.getValor("codigoExecutante").toString()));
                retorno.escrever(tagANS + ":ufConselho", reg.addHashGuia(codigoGuia, this.config.getValor("ufExecutante").toString()));
                retorno.fechar(tagANS + ":conselhoProfissional");
                retorno.fechar(tagANS + ":profissionalExecutanteCompl");
            }
            retorno.fechar(tagANS + ":prestadorExecutante");
        }
    }

    private void escreverDadosSolicitante(String tagANS, DadosTiss reg, Requisicao requisicao, XMLStringBuilder retorno, ResultSet rs, String codigoGuia, boolean isVersaoAcima30001) throws SQLException, XMLStringBuilderException {
        String x;
        String xmlOperadora = rs.getString("con_configsolicitadotiss");
        String operadora = StringUtil.getValor(xmlOperadora, "operadora");
        boolean isOperadoraItuverava = !Funcoes.textoVazio(operadora) && operadora.equalsIgnoreCase(String.valueOf(Operadoras.OPERADORA_UNIMED_ITUVERAVA.getCodigo()));
        retorno.abrir(tagANS + ":dadosSolicitante");
        boolean isVersaoAcima30200 = this.isVersaoAcima(VersaoTiss.V_3_02_00);
        boolean isVersaoAcima40000 = this.isVersaoAcima(VersaoTiss.V_4_00_00);
        boolean isVersaoAcima30500 = this.isVersaoAcima(VersaoTiss.V_3_05_00);
        retorno.abrir(tagANS + (isVersaoAcima30001 ? ":contratadoSolicitante" : ":contratado"));
        boolean ignorarCodigoOperadora = this.config.getBoolean("ignorarCodigoOperadoraMedico");
        boolean possuiCodigoOperadora = !DBUtil.campoNull(rs.getString("mec_codigooperadora")) && !Funcoes.textoVazio(rs.getString("mec_codigooperadora"));
        boolean isEnviarCodigoPrestadorPadrao = this.config.getBoolean("enviarCodigoPrestadorPadraoMedicoSolicitante");
        if (isVersaoAcima30200) {
            boolean utilizarCpfCnpjPadrao = this.config.getBoolean("utilizarCpfCnpjPadrao");
            String cpfCnpj = this.config.getString("cpfCnpj");
            String cpf = StringUtil.limpaString(rs.getString("med_cpf"), new String[]{",", ".", "/", "-"});
            if (!ignorarCodigoOperadora && (possuiCodigoOperadora || this.config.getBoolean("enviarCRM"))) {
                boolean isCnpj;
                String codigoMed = !possuiCodigoOperadora && this.config.getBoolean("enviarCRM") ? rs.getString("med_crm") : rs.getString("mec_codigooperadora");
                codigoMed = StringUtil.limpaString(codigoMed, new String[]{",", ".", "/", "-"});
                boolean bl = isCnpj = codigoMed.length() == 14;
                if (isCnpj) {
                    retorno.escrever(tagANS + ":cnpjContratado", reg.addHashGuia(codigoGuia, codigoMed));
                } else if (isOperadoraItuverava && !Funcoes.textoVazio(rs.getString("ent_razaosocial"))) {
                    retorno.escrever(tagANS + CODIGO_PRESTADOR_NA_OPERADORA, reg.addHashGuia(codigoGuia, rs.getString("ent_rgie")));
                } else if (isVersaoAcima30500 && isEnviarCodigoPrestadorPadrao) {
                    retorno.escrever(tagANS + CODIGO_PRESTADOR_NA_OPERADORA, reg.addHashGuia(codigoGuia, cpfCnpj));
                } else {
                    retorno.escrever(tagANS + CODIGO_PRESTADOR_NA_OPERADORA, reg.addHashGuia(codigoGuia, codigoMed));
                }
            } else if (utilizarCpfCnpjPadrao) {
                if (cpfCnpj != null && !cpfCnpj.isEmpty()) {
                    boolean isCnpj = cpfCnpj.length() == 14;
                    String tipo = isCnpj ? ":cnpjContratado" : ":cpfContratado";
                    retorno.escrever(tagANS + tipo, reg.addHashGuia(codigoGuia, cpfCnpj));
                } else {
                    retorno.escrever(tagANS + ":cpfContratado", "");
                }
            } else if (isVersaoAcima30500 && isEnviarCodigoPrestadorPadrao) {
                retorno.escrever(tagANS + CODIGO_PRESTADOR_NA_OPERADORA, reg.addHashGuia(codigoGuia, cpfCnpj));
            } else if (!Funcoes.textoVazio(cpf)) {
                boolean isCnpj = cpf.length() == 14;
                String tag = isCnpj ? ":cnpjContratado" : ":cpfContratado";
                retorno.escrever(tagANS + tag, reg.addHashGuia(codigoGuia, cpf));
            }
        } else if (!isVersaoAcima30001) {
            if (!ignorarCodigoOperadora && (possuiCodigoOperadora || this.config.getBoolean("enviarCRM"))) {
                retorno.abrir(tagANS + ":identificacao");
                String codigoMed = "";
                codigoMed = Funcoes.textoVazio(rs.getString("mec_codigooperadora")) && this.config.getBoolean("enviarCRM") ? rs.getString("med_crm") : rs.getString("mec_codigooperadora");
                boolean isCnpj = ValidaDoc.checkDoc(codigoMed, 7);
                codigoMed = StringUtil.limpaString(codigoMed, new String[]{",", ".", "/", "-"});
                if (isCnpj) {
                    retorno.escrever(tagANS + CNPJ, reg.addHashGuia(codigoGuia, codigoMed));
                } else if (isOperadoraItuverava && !Funcoes.textoVazio(rs.getString("ent_razaosocial"))) {
                    retorno.escrever(tagANS + CODIGO_PRESTADOR_NA_OPERADORA, reg.addHashGuia(codigoGuia, rs.getString("ent_rgie")));
                } else {
                    retorno.escrever(tagANS + CODIGO_PRESTADOR_NA_OPERADORA, reg.addHashGuia(codigoGuia, codigoMed));
                }
                retorno.fechar(tagANS + ":identificacao");
            } else if (!DBUtil.campoNull(rs.getString("med_cpf")) && !Funcoes.textoVazio(rs.getString("med_cpf"))) {
                retorno.abrir(tagANS + ":identificacao");
                retorno.escrever(tagANS + ":cpf", reg.addHashGuia(codigoGuia, StringUtil.limpaString(rs.getString("med_cpf"), new String[]{",", ".", "/", "-"})));
                retorno.fechar(tagANS + ":identificacao");
            } else {
                String conselho = rs.getString("med_conselho");
                VersaoTiss versaoTiss = VersaoTiss.getVersaoPorDescricao(this.config.getString(VERSAO_ARQUIVO));
                if (!this.verificaConselhoPermitido(versaoTiss, conselho)) {
                    conselho = Conselho.OUT.getSigla();
                }
                retorno.abrir(tagANS + ":identificacao");
                retorno.abrir(tagANS + ":conselhoProfissional");
                retorno.escrever(tagANS + ":siglaConselho", reg.addHashGuia(codigoGuia, conselho));
                retorno.escrever(tagANS + ":numeroConselho", reg.addHashGuia(codigoGuia, rs.getString("med_crm")));
                retorno.escrever(tagANS + ":ufConselho", reg.addHashGuia(codigoGuia, rs.getString("med_uf")));
                retorno.fechar(tagANS + ":conselhoProfissional");
                retorno.fechar(tagANS + ":identificacao");
            }
        } else {
            String cpf = StringUtil.limpaString(rs.getString("med_cpf"), new String[]{",", ".", "/", "-"});
            if (!Funcoes.textoVazio(cpf)) {
                boolean isCnpj = ValidaDoc.checkDoc(cpf, 7);
                String tag = isCnpj ? ":cnpjContratado" : ":cpfContratado";
                retorno.escrever(tagANS + tag, reg.addHashGuia(codigoGuia, cpf));
            } else {
                cpf = StringUtil.limpaString(rs.getString("med_cpf"), new String[]{",", ".", "/", "-"});
                if (!Funcoes.textoVazio(cpf)) {
                    boolean isCnpj = ValidaDoc.checkDoc(cpf, 7);
                    String tag = isCnpj ? ":cnpjContratado" : ":cpfContratado";
                    retorno.escrever(tagANS + tag, reg.addHashGuia(codigoGuia, cpf));
                } else {
                    String codigoMed = !possuiCodigoOperadora && this.config.getBoolean("enviarCRM") ? rs.getString("med_crm") : rs.getString("mec_codigooperadora");
                    boolean isCnpj = ValidaDoc.checkDoc(codigoMed, 7);
                    codigoMed = StringUtil.limpaString(codigoMed, new String[]{",", ".", "/", "-"});
                    if (isCnpj) {
                        retorno.escrever(tagANS + ":cnpjContratado", reg.addHashGuia(codigoGuia, codigoMed));
                    } else if (isOperadoraItuverava && !Funcoes.textoVazio(rs.getString("ent_razaosocial"))) {
                        retorno.escrever(tagANS + CODIGO_PRESTADOR_NA_OPERADORA, reg.addHashGuia(codigoGuia, rs.getString("ent_rgie")));
                    } else {
                        retorno.escrever(tagANS + CODIGO_PRESTADOR_NA_OPERADORA, reg.addHashGuia(codigoGuia, codigoMed));
                    }
                }
            }
        }
        if (!isVersaoAcima40000) {
            if (isOperadoraItuverava && !Funcoes.textoVazio(rs.getString("ent_razaosocial"))) {
                retorno.escrever(tagANS + ":nomeContratado", reg.addHashGuia(codigoGuia, this.trocaCaracteres(rs.getString("ent_razaosocial"))));
            } else {
                retorno.escrever(tagANS + ":nomeContratado", reg.addHashGuia(codigoGuia, this.trocaCaracteres(rs.getString("med_nome"))));
            }
        }
        retorno.fechar(tagANS + (isVersaoAcima30001 ? ":contratadoSolicitante" : ":contratado"));
        if (isVersaoAcima40000) {
            retorno.escrever(tagANS + ":nomeContratadoSolicitante", reg.addHashGuia(codigoGuia, this.trocaCaracteres(rs.getString("med_nome"))));
        }
        retorno.abrir(tagANS + (isVersaoAcima30001 ? ":profissionalSolicitante" : ":profissional"));
        String conselhoProfissional = rs.getString("med_conselho");
        VersaoTiss versaoTiss = VersaoTiss.getVersaoPorDescricao(this.config.getString(VERSAO_ARQUIVO));
        if (!this.verificaConselhoPermitido(versaoTiss, conselhoProfissional)) {
            conselhoProfissional = Conselho.OUT.getSigla();
        }
        retorno.escrever(tagANS + ":nomeProfissional", reg.addHashGuia(codigoGuia, this.trocaCaracteres(rs.getString("med_nome"))));
        if (!isVersaoAcima30001) {
            retorno.abrir(tagANS + ":conselhoProfissional");
            retorno.escrever(tagANS + ":siglaConselho", reg.addHashGuia(codigoGuia, conselhoProfissional));
            retorno.escrever(tagANS + ":numeroConselho", reg.addHashGuia(codigoGuia, rs.getString("med_crm")));
            retorno.escrever(tagANS + ":ufConselho", reg.addHashGuia(codigoGuia, rs.getString("med_uf")));
        } else {
            retorno.escrever(tagANS + ":conselhoProfissional", reg.addHashGuia(codigoGuia, Tiss.getCodigoTermoConselho(conselhoProfissional, versaoTiss)));
            retorno.escrever(tagANS + ":numeroConselhoProfissional", reg.addHashGuia(codigoGuia, rs.getString("med_crm")));
            retorno.escrever(tagANS + ":UF", reg.addHashGuia(codigoGuia, Tiss.getCodigoTermoUF(rs.getString("med_uf"))));
        }
        if (!isVersaoAcima30001) {
            retorno.fechar(tagANS + ":conselhoProfissional");
        }
        String cboPadraoConvenio = "";
        if (!Funcoes.textoVazio(this.config.getString("cbosPadrao"))) {
            cboPadraoConvenio = CBOS.getDescCBO((String)this.config.getString((String)"cbosPadrao")).codigo;
        }
        String cboMedico = StringUtil.getValor(StringUtil.getValor(rs.getString("med_cbo"), "cbo"), "codigo");
        String string = x = Funcoes.textoVazio(rs.getString("med_cbo")) && !Funcoes.textoVazio(this.config.getString("cbosPadrao")) ? cboPadraoConvenio : cboMedico;
        if (!isVersaoAcima30001 && !Funcoes.textoVazio(x) && this.config.getBoolean("removerPontoCBO")) {
            x = StringUtil.limpaString(x, new String[]{"."});
        }
        if (!x.equalsIgnoreCase("0000.00") || isVersaoAcima30001) {
            if (!(Funcoes.textoVazio(cboPadraoConvenio) && Funcoes.textoVazio(x) || !Tiss.validaCboValidoVersao3000(cboPadraoConvenio, x))) {
                String erro = String.format("Filial: %s Requisi\u00e7\u00e3o: %s Conv\u00eanio: %s CBOS do conv\u00eanio: %s CBOS do m\u00e9dico: %s ", requisicao.filial, requisicao.codigo, rs.getString("con_codigo"), cboPadraoConvenio, cboMedico);
                if (!reg.erros.contains(erro)) {
                    reg.erros.add(erro);
                }
            } else {
                retorno.escrever(tagANS + (isVersaoAcima30001 ? ":CBOS" : ":cbos"), reg.addHashGuia(codigoGuia, isVersaoAcima30001 ? Tiss.getCodigoCBO(x, this.config != null ? (!Funcoes.textoVazio(this.config.getString("cbosPadrao")) ? CBOS.getDescCBO((String)this.config.getString((String)"cbosPadrao")).codigo : x) : x, VersaoTiss.getVersaoPorDescricao(this.config.getString(VERSAO_ARQUIVO))) : x));
            }
        }
        retorno.fechar(tagANS + (isVersaoAcima30001 ? ":profissionalSolicitante" : ":profissional"));
        retorno.fechar(tagANS + ":dadosSolicitante");
    }

    private String getCbos(ResultSet rs) throws SQLException {
        String x = Funcoes.textoVazio(rs.getString("med_cbo")) && !Funcoes.textoVazio(this.config.getString("cbosPadrao")) ? CBOS.getDescCBO((String)this.config.getString((String)"cbosPadrao")).codigo : StringUtil.getValor(StringUtil.getValor(rs.getString("med_cbo"), "cbo"), "codigo");
        return x;
    }

    private void escreverDadosBeneficiario(String tagANS, DadosTiss reg, XMLStringBuilder retorno, ResultSet rs, String codigoGuia, String matricula, boolean isVersaoAcima30001) throws SQLException, XMLStringBuilderException {
        retorno.abrir(tagANS + ":dadosBeneficiario");
        retorno.escrever(tagANS + ":numeroCarteira", reg.addHashGuia(codigoGuia, matricula));
        if (!isVersaoAcima30001) {
            retorno.escrever(tagANS + ":nomeBeneficiario", reg.addHashGuia(codigoGuia, StringUtil.removerAcentos(rs.getString("pac_nome")).trim()));
            String nomePlano = !Funcoes.textoVazio(rs.getString("req_nomeplano")) ? rs.getString("req_nomeplano") : rs.getString("con_fantasia");
            retorno.escrever(tagANS + ":nomePlano", reg.addHashGuia(codigoGuia, StringUtil.testaTamanhoString(nomePlano, 40)));
            if (!DBUtil.campoNull(rs.getString("req_validadecarteira"))) {
                retorno.escrever(tagANS + ":validadeCarteira", reg.addHashGuia(codigoGuia, Funcoes.formataData("yyyy-MM-dd", rs.getDate("req_validadecarteira"))));
            }
            if (this.verificaVersaoTiss(VersaoTiss.V_2_02_03.getDescricao())) {
                if (!Funcoes.textoVazio(rs.getString("req_cartaosus"))) {
                    retorno.escrever(tagANS + ":numeroCNS", reg.addHashGuia(codigoGuia, rs.getString("req_cartaosus").trim()));
                } else if (this.config.getValor("cartaoSUS") != null && !Funcoes.textoVazio(this.config.getValor("cartaoSUS").toString())) {
                    retorno.escrever(tagANS + ":numeroCNS", reg.addHashGuia(codigoGuia, this.config.getValor("cartaoSUS").toString().trim()));
                }
            }
        } else {
            boolean isNeonato = rs.getBoolean("req_neonato");
            retorno.escrever(tagANS + ":atendimentoRN", reg.addHashGuia(codigoGuia, isNeonato ? "S" : "N"));
            if (!this.isVersaoAcima(VersaoTiss.V_4_00_00)) {
                retorno.escrever(tagANS + ":nomeBeneficiario", reg.addHashGuia(codigoGuia, StringUtil.removerAcentos(rs.getString("pac_nome").trim())));
                if (!Funcoes.textoVazio(rs.getString("req_cartaosus"))) {
                    retorno.escrever(tagANS + ":numeroCNS", reg.addHashGuia(codigoGuia, rs.getString("req_cartaosus").trim()));
                } else if (this.config.getValor("cartaoSUS") != null && !Funcoes.textoVazio(this.config.getValor("cartaoSUS").toString())) {
                    retorno.escrever(tagANS + ":numeroCNS", reg.addHashGuia(codigoGuia, this.config.getValor("cartaoSUS").toString().trim()));
                }
            }
        }
        retorno.fechar(tagANS + ":dadosBeneficiario");
    }

    private StringBuilder getSqlAutorizacao(Requisicao requisicao, ResultSet rsGuias) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("select distinct ex.exr_codautorizacao ");
        bui.append("      ,exr.exa_descricao ");
        bui.append("      ,exr.exa_codigo ");
        bui.append("      ,mco.mco_descricao ");
        bui.append("      ,ex.exr_dataautorizacao as dataAutorizacao ");
        bui.append("      ,ex.exr_datavalidadeautorizacao as validadeAutorizacao ");
        bui.append("from faturaexamerequisicao fe ");
        bui.append("left join examerequisicao ex on fe.fil_kodigo = ex.fil_codigo and fe.req_codigo = ex.req_codigo and fe.exa_codigo = ex.exa_codigo and fe.mco_codigo = ex.mco_codigo ");
        bui.append("left join exames exr on ex.fil_codigo = exr.fil_codigo and ex.exa_codigo = exr.exa_codigo ");
        bui.append("left join materialcoleta mco on ex.mco_codigo = mco.mco_codigo ");
        bui.append("where fe.fil_codigo = ").append(Variaveis.filialPadrao);
        bui.append(" and fe.fil_kodigo = ? ");
        bui.append(" and fe.fat_codigo = ? ");
        bui.append(" and fe.req_codigo = ? ");
        bui.append(" and (trim(ex.exr_codautorizacao) <> '' and ex.exr_codautorizacao is not null) ");
        bui.append(" and ex.exr_excluido = false ");
        if (!(rsGuias == null || rsGuias.getString("guia") == null || Funcoes.textoVazio(rsGuias.getString("guia")) || rsGuias.getString("guia").equalsIgnoreCase("-1") || requisicao.isRepasse)) {
            bui.append(" and ex.exr_guia = ? ");
        }
        bui.append(" order by 2 asc");
        return bui;
    }

    private StringBuilder getSqlRequisicoesFaturamento(Requisicao requisicao, boolean existeTipoAtendimento, ResultSet rsGuias) throws SQLException {
        StringBuilder bui = new StringBuilder();
        String exame = !this.config.getBoolean("ignorarCodigoExameAgrupamentoProcedimentos") ? ", ex.exa_codigo " : "";
        bui.append(" select a.fil_codigo, b.req_hora ").append(exame);
        if (requisicao.isRepasse) {
            bui.append("       ,COALESCE(b.req_guiarepasse, b.req_guia) as req_guia ");
            bui.append("       ,COALESCE(exg.exg_dataguia, ex.exr_dataguia, b.req_dataguia, b.req_datarequisicao) as dataGuia ");
            bui.append("\t\t\t ,COALESCE(exg.exg_validadeguia, ex.exr_validadeguia, b.req_validadeguia) as validadeGuia ");
            bui.append("       ,COALESCE(b.req_matricularepasse, b.req_matricula) as req_matricula ");
            bui.append("       ,COALESCE(b.req_validadecarteirarepasse,\tb.req_validadecarteira) as req_validadecarteira ");
            bui.append("       ,COALESCE(b.req_nomeplanorepasse, b.req_nomeplano) as req_nomeplano ");
            bui.append("       ,COALESCE(b.req_guiaprincipalrepasse, b.req_guiaprincipal) as req_guiaprincipal ");
        } else {
            bui.append("       ,b.req_guia ");
            bui.append("       ,COALESCE(exg.exg_dataguia, ex.exr_dataguia, b.req_dataguia, b.req_datarequisicao) as dataGuia ");
            bui.append("\t\t\t ,COALESCE(exg.exg_validadeguia, ex.exr_validadeguia, b.req_validadeguia) as validadeGuia ");
            bui.append("       ,b.req_matricula ");
            bui.append("       ,b.req_validadecarteira ");
            bui.append("       ,b.req_nomeplano ");
            bui.append("       ,b.req_guiaprincipal ");
        }
        bui.append("       ,coalesce(b.req_cartaosus, '') as req_cartaosus");
        bui.append("       ,c.pac_nome ");
        bui.append("       ,d.fil_razaosocial ");
        bui.append("       ,d.fil_cnes ");
        bui.append("       ,a.req_codigo ");
        bui.append("       ,e.con_codigo ");
        bui.append("       ,h.tpe_codigo ");
        bui.append("       ,f.tpe_tabelaans ");
        bui.append("       ,MIN(ex.exr_data) as exr_data ");
        bui.append("       ,MIN(ex.exr_datamaterial) as exr_datamaterial ");
        bui.append("       ,a.fil_kodigo ");
        bui.append("       ,med.med_conselho ");
        bui.append("       ,med.med_crm ");
        bui.append("       ,med.med_uf ");
        bui.append("       ,med.med_nome ");
        bui.append("       ,med.med_cpf ");
        bui.append("       ,h.con_fantasia ");
        bui.append("       ,coalesce(med.med_cbo, '') as med_cbo ");
        bui.append("       ,d.fil_cnpj ");
        bui.append("       ,avg(fe.fer_total) as mediapreco ");
        bui.append("       ,sum(fe.fer_total) as total ");
        bui.append("       ,medtiss.mec_codigooperadora ");
        bui.append("       ,med.med_crm ");
        bui.append("       ,exa.exa_servicotiss ");
        bui.append("       ,exa.exa_coddespesatiss ");
        bui.append("       ,exa.exa_undmedidatiss ");
        bui.append("       ,f.tpe_tabservicotiss ");
        bui.append(existeTipoAtendimento ? "       ,sit.sit_tipoatendimento " : "       ,'05' as sit_tipoatendimento ");
        bui.append("       ,sit.sit_regimeatendimento ");
        bui.append("       ,sit.sit_idcoberturaespecial ");
        bui.append("       ,sit.sit_saudeocupacional ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            bui.append("       ,coalesce(nullif(trim(replace(replace(dtm.dtm_codamb, '-', ''), '.', ''), ''), trim(replace(replace(det.dtp_codamb, '-', ''), '.', '')))) as dtp_codamb ");
            bui.append("       ,count(COALESCE(NULLIF(trim(dtm.dtm_codamb), ''), trim(det.dtp_codamb))) as contagem ");
        } else {
            bui.append("       ,trim((replace(replace(det.dtp_codamb, '-', ''), '.', ''))) as dtp_codamb ");
            bui.append("       ,count(det.dtp_codamb) as contagem ");
        }
        bui.append("\t\t\t\t ,b.req_neonato, ent.ent_razaosocial, ent.ent_rgie, h.con_configsolicitadotiss, b.req_dclinicos ");
        bui.append("   from faturarequisicao a ");
        bui.append("   left join faturaexamerequisicao fe on a.fil_codigo = fe.fil_codigo and a.fat_codigo = fe.fat_codigo and a.req_codigo = fe.req_codigo and a.fil_kodigo = fe.fil_kodigo ");
        bui.append("   left join examerequisicao ex on fe.fil_kodigo = ex.fil_codigo and fe.req_codigo = ex.req_codigo and fe.exa_codigo = ex.exa_codigo and fe.mco_codigo = ex.mco_codigo ");
        bui.append("   left join examematcoleta emc on ex.fil_codigo = emc.fil_codigo and ex.exa_codigo = emc.exa_codigo and ex.mco_codigo = emc.mco_codigo ");
        bui.append("   left join requisicao b on a.fil_kodigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        bui.append("   left join situacao sit on b.fil_codigo = sit.fil_codigo and b.sit_codigo = sit.sit_codigo ");
        bui.append("   left join paciente c on b.fil_codigo = c.fil_codigo and b.pac_codigo = c.pac_codigo ");
        bui.append("   left join filiais_postocoleta d on a.fil_codigo = d.fil_codigo ");
        bui.append("   left join fatura e on a.fil_codigo = e.fil_codigo and a.fat_codigo = e.fat_codigo ");
        bui.append("   left join convenios h on b.fil_codigo = h.fil_codigo and b.con_codigo = h.con_codigo ");
        bui.append("   left join tabelaprecoexames f on h.fil_codigo = f.fil_codigo and h.tpe_codigo = f.tpe_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            bui.append(" left join detalhetabelaprecometodologia dtm on d.fil_codigo = dtm.fil_codigo and h.tpe_codigo = dtm.tpe_codigo and fe.exa_codfilho = dtm.exa_codigo and fe.mco_codfilho = dtm.mco_codigo and ex.met_codigo = dtm.met_codigo ");
        }
        bui.append("   left join detalhetabelapreco det on d.fil_codigo = det.fil_codigo and h.tpe_codigo = det.tpe_codigo and fe.exa_codfilho = det.exa_codigo and fe.mco_codfilho = det.mco_codigo ");
        bui.append("   left join medico med on b.fil_codigo = med.fil_codigo and b.med_conselho = med.med_conselho and b.med_crm = med.med_crm and b.med_uf = med.med_uf ");
        bui.append("   left join examerequisicaoguiaagrupada exg on fe.fil_codigo = exg.fil_codigo and fe.exa_codigo = exg.exa_codigo and fe.mco_codigo = exg.mco_codigo and fe.exa_codfilho = exg.exa_codfilho and fe.mco_codfilho = exg.mco_codfilho and a.req_codigo = exg.req_codigo ");
        bui.append("   left join exames exa on ex.fil_codigo = exa.fil_codigo and ex.exa_codigo = exa.exa_codigo ");
        bui.append("   left join examesetor ese on exa.fil_codigo = ese.fil_codigo and exa.exa_codigo = ese.exa_codigo and ese.ese_default = true ");
        if (!requisicao.isRepasse) {
            bui.append("   left join medicoconveniotiss medtiss on b.fil_codigo = medtiss.fil_codigo and b.med_conselho = medtiss.med_conselho and b.med_crm = medtiss.med_crm and b.med_uf = medtiss.med_uf and b.con_codigo = medtiss.con_codigo ");
        } else {
            bui.append("   left join medicoconveniotiss medtiss on b.fil_codigo = medtiss.fil_codigo and b.med_conselho = medtiss.med_conselho and b.med_crm = medtiss.med_crm and b.med_uf = medtiss.med_uf and b.con_codrepasse = medtiss.con_codigo ");
        }
        bui.append("     left join entidade ent on b.fil_codigo = ent.fil_codigo and b.ent_codempresa = ent.ent_codigo ");
        bui.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
        bui.append("    and a.fil_kodigo = ? ");
        bui.append("    and a.fat_codigo = ? ");
        bui.append("    and a.req_codigo = ? ");
        if (!(rsGuias == null || rsGuias.getString("guia") == null || Funcoes.textoVazio(rsGuias.getString("guia")) || rsGuias.getString("guia").equalsIgnoreCase("-1") || requisicao.isRepasse)) {
            bui.append("  and (ex.exr_guia = ? or exg.exg_guia = ?) ");
        }
        bui.append("    and ex.exr_excluido = false ");
        bui.append("  group by a.fil_codigo, b.req_hora, b.req_guia,  c.pac_nome, d.fil_razaosocial, d.fil_cnes, a.req_codigo, a.fil_kodigo, d.fil_cnpj, ");
        bui.append("          med.med_conselho, med.med_crm, med.med_uf, med.med_nome, med.med_cpf, med.med_cbo, h.con_fantasia, dataGuia, b.req_datarequisicao, ");
        bui.append("          e.con_codigo, h.tpe_codigo, b.req_matricula, f.tpe_tabelaans, (replace(replace(det.dtp_codamb, '-', ''), '.', '')), medtiss.mec_codigooperadora, ");
        bui.append("          b.req_validadecarteira, b.req_nomeplano, b.req_guiaprincipal, b.req_guiarepasse, b.req_matricularepasse, ");
        bui.append("          b.req_validadecarteirarepasse, b.req_nomeplanorepasse, b.req_guiaprincipalrepasse, b.req_neonato, ");
        bui.append("\t\t\t\t\texg.exg_validadeguia, ex.exr_validadeguia, b.req_validadeguia, b.req_cartaosus, ");
        bui.append("\t\t\t\t\texa.exa_servicotiss, exa.exa_coddespesatiss, exa.exa_undmedidatiss, f.tpe_tabservicotiss, ent.ent_razaosocial, ent.ent_rgie, ");
        bui.append("\t\t\t\t\th.con_configsolicitadotiss, req_dclinicos, sit.sit_regimeatendimento, sit.sit_idcoberturaespecial, sit.sit_saudeocupacional  ").append(exame);
        if (existeTipoAtendimento) {
            bui.append(", sit.sit_tipoatendimento ");
        }
        if (ParametrosGerais.getPrecoMetodologia()) {
            bui.append(" , coalesce(nullif(trim(replace(replace(dtm.dtm_codamb, '-', ''), '.', ''), ''), trim(replace(replace(det.dtp_codamb, '-', ''), '.', '')))) ");
        }
        String orderBy = "";
        if (ParametrosGerais.getOrdemComprovante().equals("A")) {
            orderBy = " exa_servicotiss, MIN(exr_ordem) ";
        } else {
            if (ParametrosGerais.getOrdenarSetor()) {
                orderBy = " exa_servicotiss, MIN(set_codigo) ";
            }
            if (ParametrosGerais.getOrdemComprovante().equals("C")) {
                orderBy = orderBy + (Funcoes.textoVazio(orderBy) ? "" : ",") + " MIN(ex.exa_codigo) ";
            } else if (ParametrosGerais.getOrdemComprovante().equals("P")) {
                orderBy = orderBy + (Funcoes.textoVazio(orderBy) ? "" : ",") + " MIN(emc.emc_pagina), MIN(exr_ordem) ";
            }
        }
        if (!Funcoes.textoVazio(orderBy)) {
            bui.append(" order by ").append(orderBy);
        }
        return bui;
    }

    private StringBuilder getSqlGuias(int codigoFatura, Requisicao requisicao) {
        StringBuilder bufGuias = new StringBuilder();
        if (requisicao.isRepasse) {
            bufGuias.append(" select distinct COALESCE(NULLIF(b.req_guiarepasse, ''), NULLIF(ex.exr_guia, ''), NULLIF(exg.exg_guia, '')) as guia ");
        } else {
            bufGuias.append(" select distinct COALESCE(NULLIF(ex.exr_guia, ''), NULLIF(exg.exg_guia, '')) as guia ");
        }
        bufGuias.append("   from faturarequisicao a ");
        bufGuias.append("   left join faturaexamerequisicao fe on a.fil_codigo = fe.fil_codigo and a.fat_codigo = fe.fat_codigo and a.req_codigo = fe.req_codigo and a.fil_kodigo = fe.fil_kodigo ");
        bufGuias.append("   left join examerequisicao \t\t\tex on fe.fil_kodigo = ex.fil_codigo and fe.req_codigo = ex.req_codigo and fe.exa_codigo = ex.exa_codigo and fe.mco_codigo = ex.mco_codigo ");
        bufGuias.append("   left join requisicao \t\t\t\t\t\tb on a.fil_kodigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        bufGuias.append("   left join examerequisicaoguiaagrupada exg on fe.fil_kodigo = exg.fil_codigo and fe.exa_codigo = exg.exa_codigo and fe.mco_codigo = exg.mco_codigo and fe.exa_codfilho = exg.exa_codfilho and fe.mco_codfilho = exg.mco_codfilho and a.req_codigo = exg.req_codigo ");
        bufGuias.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
        bufGuias.append("    and a.fil_kodigo = ").append(requisicao.filial);
        bufGuias.append("    and a.fat_codigo = ").append(codigoFatura);
        bufGuias.append("    and a.req_codigo = ").append(requisicao.codigo);
        bufGuias.append("    and ex.exr_excluido = false ");
        bufGuias.append("  order by guia ");
        return bufGuias;
    }

    private HashMap<String, String> carregaAgrupaExames(Statement st, int codigoFatura, Requisicao requisicao) throws SQLException {
        StringBuilder bui = new StringBuilder();
        if (ParametrosGerais.getPrecoMetodologia()) {
            bui.append(" select coalesce(nullif(trim(replace(replace(dtm.dtm_codamb, '-', ''), '.', '')), ''), trim(replace(replace(det.dtp_codamb, '-', ''), '.', ''))) as dtp_codamb ");
        } else {
            bui.append(" select trim(replace(replace(det.dtp_codamb, '-', ''), '.', '')) as dtp_codamb ");
        }
        bui.append("       ,exames.exa_descricao ");
        bui.append("   from faturarequisicao a ");
        bui.append("   left join faturaexamerequisicao fe on a.fil_codigo = fe.fil_codigo and a.fat_codigo = fe.fat_codigo and a.req_codigo = fe.req_codigo and a.fil_kodigo = fe.fil_kodigo ");
        bui.append("   left join requisicao b on a.fil_kodigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        bui.append("   left join examerequisicao ex on fe.fil_kodigo = ex.fil_codigo and fe.req_codigo = ex.req_codigo and fe.exa_codigo = ex.exa_codigo and fe.mco_codigo = ex.mco_codigo ");
        bui.append("   left join convenios h on b.fil_codigo = h.fil_codigo and b.con_codigo = h.con_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            bui.append("   left join detalhetabelaprecometodologia dtm on b.fil_codigo = dtm.fil_codigo and h.tpe_codigo = dtm.tpe_codigo and fe.exa_codfilho = dtm.exa_codigo and fe.mco_codfilho = dtm.mco_codigo and ex.met_codigo = dtm.met_codigo ");
        }
        bui.append("   left join detalhetabelapreco det on b.fil_codigo = det.fil_codigo and h.tpe_codigo = det.tpe_codigo and fe.exa_codfilho = det.exa_codigo and fe.mco_codfilho = det.mco_codigo ");
        bui.append("   left join exames exames on a.fil_kodigo = exames.fil_codigo and fe.exa_codfilho = exames.exa_codigo ");
        bui.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
        bui.append("    and a.fil_kodigo =  ").append(requisicao.filial);
        bui.append("    and a.fat_codigo = ").append(codigoFatura);
        bui.append("    and a.req_codigo = ").append(requisicao.codigo);
        bui.append("    and ex.exr_excluido = false ");
        bui.append("    group by ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            bui.append("    coalesce(nullif(trim(replace(replace(dtm.dtm_codamb, '-', ''), '.', '')), ''), trim(replace(replace(det.dtp_codamb, '-', ''), '.', ''))), ");
            bui.append("    exames.exa_descricao ");
        } else {
            bui.append("    replace(replace(det.dtp_codamb, '-', ''), '.', ''), ");
            bui.append("    exames.exa_descricao ");
        }
        bui.append("  order by dtp_codamb, exames.exa_descricao ");
        ResultSet rsNomes = Conexao.executeQuery(st, bui);
        HashMap<String, String> nomeExames = new HashMap<String, String>();
        while (rsNomes.next()) {
            if (nomeExames.containsKey(rsNomes.getString("dtp_codamb"))) {
                String tmp = nomeExames.get(rsNomes.getString("dtp_codamb"));
                String original = rsNomes.getString("exa_descricao");
                if (tmp.length() <= original.length()) continue;
                nomeExames.put(rsNomes.getString("dtp_codamb"), original);
                continue;
            }
            nomeExames.put(rsNomes.getString("dtp_codamb"), rsNomes.getString("exa_descricao"));
        }
        return nomeExames;
    }

    public static String getCodigoIndicadorAcidente(String descIndicadorAcidente) {
        if (Funcoes.textoVazio(descIndicadorAcidente)) {
            return "9";
        }
        String[] lista = ConstantesGerais.INDICADOR_ACIDENTE;
        for (int i = 0; i < lista.length - 1; ++i) {
            if (!descIndicadorAcidente.equalsIgnoreCase(lista[i])) continue;
            return String.valueOf(i);
        }
        return "9";
    }

    public static String getCodigoCBO(String cbo, String cbosConvenio, VersaoTiss versaoTiss) {
        HashMap<String, String> lista = new HashMap<String, String>();
        Util.atualizaCodigoCbo(lista, versaoTiss);
        for (String a : lista.keySet()) {
            if (!cbo.trim().equals(a)) continue;
            return lista.get(a);
        }
        CBOS.CBO cbos = CBOS.getCBO(cbo);
        if (!(cbos == null || Funcoes.textoVazio(cbo) || Funcoes.textoVazio(cbosConvenio) || cbo.equals("0000.00") || cbosConvenio.equals("0000.00"))) {
            return cbos.toString().replaceAll("\\.", "");
        }
        if (!Funcoes.textoVazio(cbo) && !cbo.equals("0000.00")) {
            return cbo.replaceAll("\\.", "");
        }
        if (!Funcoes.textoVazio(cbo) && !cbo.equals("0000.00") && Funcoes.textoVazio(cbosConvenio)) {
            return lista.get(cbo);
        }
        if (Funcoes.textoVazio(cbo) && !Funcoes.textoVazio(cbosConvenio) && !cbosConvenio.equals("0000.00")) {
            String cboConv = lista.get(cbosConvenio);
            return Funcoes.textoVazio(cboConv) ? cbosConvenio.replaceAll("\\.", "") : cboConv;
        }
        if (!(Funcoes.textoVazio(cbo) || Funcoes.textoVazio(cbosConvenio) || cbo.equals("0000.00") || cbosConvenio.equals("0000.00"))) {
            return "999999";
        }
        if (!Funcoes.textoVazio(cbo) && !Funcoes.textoVazio(cbosConvenio) && cbo.equals("0000.00") && cbosConvenio.equals("0000.00")) {
            return "0000.00".replaceAll("\\.", "");
        }
        if (Funcoes.textoVazio(cbo) && Funcoes.textoVazio(cbosConvenio)) {
            return "999999";
        }
        return lista.get("2231.15");
    }

    public static String getCodigoTermoUF(String uf) {
        HashMap<String, String> lista = new HashMap<String, String>();
        lista.put("RO", "11");
        lista.put("SE", "28");
        lista.put("AC", "12");
        lista.put("BA", "29");
        lista.put("AM", "13");
        lista.put("MG", "31");
        lista.put("RR", "14");
        lista.put("ES", "32");
        lista.put("PA", "15");
        lista.put("RJ", "33");
        lista.put("AP", "16");
        lista.put("SP", "35");
        lista.put("TO", "17");
        lista.put("PR", "41");
        lista.put("MA", "21");
        lista.put("SC", "42");
        lista.put("PI", "22");
        lista.put("RS", "43");
        lista.put("CE", "23");
        lista.put("MS", "50");
        lista.put("RN", "24");
        lista.put("MT", "51");
        lista.put("PB", "25");
        lista.put("GO", "52");
        lista.put("PE", "26");
        lista.put("DF", "53");
        lista.put("AL", "27");
        lista.put("EX", "98");
        if (Funcoes.textoVazio(uf)) {
            return (String)lista.get("EX");
        }
        return (String)lista.get(uf);
    }

    public static String getCodigoTermoConselho(String conselho, VersaoTiss versaoTiss) {
        if (Funcoes.textoVazio(conselho)) {
            return String.valueOf(Conselho.OUT.getCodigo());
        }
        Conselho cons = null;
        for (Conselho c : Conselho.values()) {
            if (!conselho.equals(c.getSigla())) continue;
            cons = c;
            break;
        }
        if (cons != null) {
            if (versaoTiss.isVersaoMaior(VersaoTiss.V_4_00_00)) {
                return Funcoes.preencheZero(String.valueOf(cons.getCodigo()), 2);
            }
            if (cons.getCodigo() < Conselho.OUT.getCodigo()) {
                return Funcoes.preencheZero(String.valueOf(cons.getCodigo()), 2);
            }
        }
        return String.valueOf(Conselho.OUT.getCodigo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String pegaCodigoCid10(String filial, String requisicao) {
        String retorno;
        Statement st;
        block4: {
            st = Conexao.getStatement();
            retorno = "";
            try {
                StringBuilder buf = new StringBuilder("select c10_codigo from requisicaocid10 ");
                buf.append("where fil_codigo = ").append(filial);
                buf.append(" and req_codigo = ").append(requisicao);
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block4;
                retorno = rs.getString("c10_codigo");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Tiss (216)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    @Override
    public Registro parseXMLConfiguracao(String xml) {
        Registro r = new Registro();
        r.setValor("codigoPrestadorNaOperadora", StringUtil.getValor(xml, "codigoPrestadorNaOperadora"));
        r.setValor("cnpjPrestadorNaOperadora", StringUtil.getValor(xml, "cnpjPrestadorNaOperadora"));
        if (Funcoes.textoVazio(StringUtil.getValor(xml, "cnpjPrestadorNaOperadora")) && ValidaDoc.checkDoc(this.limpaCNPJ(StringUtil.getValor(xml, "codigoPrestadorNaOperadora")), 7)) {
            r.setValor("cnpjPrestadorNaOperadora", StringUtil.getValor(xml, "codigoPrestadorNaOperadora"));
        }
        r.setValor("registroANS", StringUtil.getValor(xml, "registroANS"));
        r.setValor("convenioRegistroANS", StringUtil.getValor(xml, "convenioRegistroANS"));
        r.setValor("nomeArquivoTiss", StringUtil.getValor(xml, "nomeArquivoTiss"));
        r.setValor("guiaAutomatica", StringUtil.getValor(xml, "guiaAutomatica").equalsIgnoreCase("1"));
        r.setValor("adicionarGuiaOperadora", StringUtil.getBoolean(xml, "adicionarGuiaOperadora"));
        r.setValor("adicionarCNPJOperadora", StringUtil.getBoolean(xml, "adicionarCNPJOperadora"));
        r.setValor("solicitarLote", StringUtil.getBoolean(xml, "solicitarLote"));
        r.setValor("repetirGuiaOperadora", StringUtil.getBoolean(xml, "repetirGuiaOperadora"));
        r.setValor("valorZeroGuiaPrincipal", StringUtil.getBoolean(xml, "valorZeroGuiaPrincipal"));
        r.setValor("tamanhoGuia", StringUtil.getValor(xml, "tamanhoGuia"));
        r.setValor("enviarCRM", StringUtil.getBoolean(xml, "enviarCRM"));
        r.setValor("enviarCID10SemMascara", StringUtil.getBoolean(xml, "enviarCID10SemMascara"));
        r.setValor("ignorarCodigoFilial", StringUtil.getBoolean(xml, "ignorarCodigoFilial"));
        r.setValor("ignorarMilissegundos", StringUtil.getBoolean(xml, "ignorarMilissegundos"));
        r.setValor("proibirGuiaRepetida", StringUtil.getBoolean(xml, "proibirGuiaRepetida"));
        r.setValor("utilizarSADTInternado", StringUtil.getBoolean(xml, "utilizarSADTInternado"));
        r.setValor("utilizarDataColeta", StringUtil.getBoolean(xml, "utilizarDataColeta"));
        r.setValor("ignorarCodigoOperadoraMedico", StringUtil.getBoolean(xml, "ignorarCodigoOperadoraMedico"));
        r.setValor("utilizarGuiaComoAutorizacao", StringUtil.getBoolean(xml, "utilizarGuiaComoAutorizacao"));
        r.setValor("limparCaracteresGuia", StringUtil.getBoolean(xml, "limparCaracteresGuia"));
        r.setValor("naoUtilizarCNPJPrestador", StringUtil.getBoolean(xml, "naoUtilizarCNPJPrestador"));
        r.setValor("enviarReducaoAcrescimo", StringUtil.getBoolean(xml, "enviarReducaoAcrescimo"));
        r.setValor("utilizarCpfCnpjPadrao", StringUtil.getBoolean(xml, "utilizarCpfCnpjPadrao"));
        r.setValor("cpfCnpj", StringUtil.getValor(xml, "cpfCnpj"));
        r.setValor("naoUtilizarGrauParticipacao", StringUtil.getBoolean(xml, "naoUtilizarGrauParticipacao"));
        r.setValor("assinarArquivoEletronico", StringUtil.getBoolean(xml, "assinarArquivoEletronico"));
        r.setValor("enviarCaracteresMatricula", StringUtil.getBoolean(xml, "enviarCaracteresMatricula"));
        r.setValor("enviarIndicacaoClinica", StringUtil.getBoolean(xml, "enviarIndicacaoClinica"));
        r.setValor("ignorarCodigoExameAgrupamentoProcedimentos", StringUtil.getBoolean(xml, "ignorarCodigoExameAgrupamentoProcedimentos"));
        r.setValor(VERSAO_ARQUIVO, VersaoTiss.V_2_02_01.getDescricao());
        r.setValor("ufExecutante", "PR");
        r.setValor("conselhoExecutante", "CRM");
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, VERSAO_ARQUIVO))) {
            r.setValor(VERSAO_ARQUIVO, StringUtil.getValor(xml, VERSAO_ARQUIVO));
        }
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, "ufExecutante"))) {
            r.setValor("ufExecutante", StringUtil.getValor(xml, "ufExecutante"));
        }
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, "conselhoExecutante"))) {
            r.setValor("conselhoExecutante", StringUtil.getValor(xml, "conselhoExecutante"));
        }
        r.setValor("nomeExecutante", StringUtil.getValor(xml, "nomeExecutante"));
        r.setValor("codigoExecutante", StringUtil.getValor(xml, "codigoExecutante"));
        r.setValor("cbosPadrao", StringUtil.getValor(xml, "cbosPadrao"));
        r.setValor("removerPontoCBO", StringUtil.getBoolean(xml, "removerPontoCBO"));
        r.setValor("cartaoSUS", StringUtil.getValor(xml, "cartaoSUS"));
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, "viaDeAcesso"))) {
            r.setValor("viaDeAcesso", StringUtil.getValor(xml, "viaDeAcesso"));
        }
        r.setValor("naoInformaTecnicaUtilizada", StringUtil.getBoolean(xml, "naoInformaTecnicaUtilizada"));
        r.setValor("naoUtilizaViaAcesso", StringUtil.getBoolean(xml, "naoUtilizaViaAcesso"));
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, "tipoAtendimento"))) {
            r.setValor("tipoAtendimento", StringUtil.getValor(xml, "tipoAtendimento"));
        } else {
            r.setValor("tipoAtendimento", "05");
        }
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, "indicadorAcidente"))) {
            r.setValor("indicadorAcidente", StringUtil.getValor(xml, "indicadorAcidente"));
        } else {
            r.setValor("indicadorAcidente", "09");
        }
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, "codificacaoArquivo"))) {
            r.setValor("codificacaoArquivo", StringUtil.getValor(xml, "codificacaoArquivo"));
        } else {
            r.setValor("codificacaoArquivo", FaturamentoEletronico.CODIFICACAO.ISO_8859_1.codificacao);
        }
        String sequencial = StringUtil.getValor(xml, "sequencialLote");
        r.setValor("sequencialLote", Funcoes.isNumeric(sequencial) ? Integer.parseInt(sequencial) : 0);
        String limite = StringUtil.getValor(xml, "limiteGuiasArquivo");
        r.setValor("limiteGuiasArquivo", Funcoes.isNumeric(limite) ? Integer.parseInt(limite) : 100);
        if (Funcoes.textoVazio(StringUtil.getValor(xml, "tamanhoMinimoGuia"))) {
            r.setValor("tamanhoMinimoGuia", 0);
        } else {
            r.setValor("tamanhoMinimoGuia", StringUtil.getValor(xml, "tamanhoMinimoGuia"));
        }
        if (Funcoes.textoVazio(StringUtil.getValor(xml, "grauParticipacaoExecutante"))) {
            r.setValor("grauParticipacaoExecutante", GrauParticipacao.CLINICO.getCodigo());
        } else {
            r.setValor("grauParticipacaoExecutante", StringUtil.getValor(xml, "grauParticipacaoExecutante"));
        }
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, "regimeAtendimento"))) {
            r.setValor("regimeAtendimento", StringUtil.getValor(xml, "regimeAtendimento"));
        }
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, "enviarIdCoberturaEspecial"))) {
            r.setValor("enviarIdCoberturaEspecial", StringUtil.getValor(xml, "enviarIdCoberturaEspecial"));
        }
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, "enviarSaudeOcupacional"))) {
            r.setValor("enviarSaudeOcupacional", StringUtil.getValor(xml, "enviarSaudeOcupacional"));
        }
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, "naoEnviarCpfCnpjPrestadorMedicoSolicitante"))) {
            r.setValor("naoEnviarCpfCnpjPrestadorMedicoSolicitante", StringUtil.getValor(xml, "naoEnviarCpfCnpjPrestadorMedicoSolicitante"));
        }
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, "enviarCodigoPrestadorPadraoMedicoSolicitante"))) {
            r.setValor("enviarCodigoPrestadorPadraoMedicoSolicitante", StringUtil.getBoolean(xml, "enviarCodigoPrestadorPadraoMedicoSolicitante"));
        }
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, "enviarHorarioProcedimentos"))) {
            r.setValor("enviarHorarioProcedimentos", StringUtil.getBoolean(xml, "enviarHorarioProcedimentos"));
        }
        return r;
    }

    private String registroToXML(Registro r) {
        VersaoTiss versaoTiss;
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("faturamentoEletronico");
        xml.escrever("protocolo", Tiss.getNomeProtocolo());
        xml.escrever("codigoPrestadorNaOperadora", r.getValor("codigoPrestadorNaOperadora").toString());
        xml.escrever("cnpjPrestadorNaOperadora", r.getValor("cnpjPrestadorNaOperadora").toString());
        xml.escrever("sequencialLote", r.getValor("sequencialLote").toString());
        xml.escrever("registroANS", r.getValor("registroANS").toString());
        xml.escrever("convenioRegistroANS", r.getValor("convenioRegistroANS").toString());
        xml.escrever("nomeArquivoTiss", r.getValor("nomeArquivoTiss").toString());
        xml.escrever("guiaAutomatica", r.getBoolean("guiaAutomatica") ? "1" : "0");
        xml.escrever("adicionarGuiaOperadora", r.getBoolean("adicionarGuiaOperadora") ? "True" : "False");
        xml.escrever("adicionarCNPJOperadora", r.getBoolean("adicionarCNPJOperadora") ? "True" : "False");
        xml.escrever("solicitarLote", r.getBoolean("solicitarLote") ? "True" : "False");
        xml.escrever("repetirGuiaOperadora", r.getBoolean("repetirGuiaOperadora") ? "True" : "False");
        xml.escrever("valorZeroGuiaPrincipal", r.getBoolean("valorZeroGuiaPrincipal") ? "True" : "False");
        xml.escrever("enviarCRM", r.getBoolean("enviarCRM") ? "True" : "False");
        xml.escrever("enviarCID10SemMascara", r.getBoolean("enviarCID10SemMascara") ? "True" : "False");
        xml.escrever("ignorarCodigoFilial", r.getBoolean("ignorarCodigoFilial") ? "True" : "False");
        xml.escrever("ignorarMilissegundos", r.getBoolean("ignorarMilissegundos") ? "True" : "False");
        xml.escrever(VERSAO_ARQUIVO, r.getValor(VERSAO_ARQUIVO).toString());
        xml.escrever("ufExecutante", r.getValor("ufExecutante").toString());
        xml.escrever("indicadorAcidente", r.getValor("indicadorAcidente").toString());
        xml.escrever("tipoAtendimento", r.getValor("tipoAtendimento").toString());
        xml.escrever("conselhoExecutante", r.getValor("conselhoExecutante").toString());
        xml.escrever("nomeExecutante", r.getValor("nomeExecutante").toString());
        xml.escrever("codigoExecutante", r.getValor("codigoExecutante").toString());
        xml.escrever("tamanhoGuia", r.getValor("tamanhoGuia").toString());
        xml.escrever("codificacaoArquivo", r.getValor("codificacaoArquivo") == null ? FaturamentoEletronico.CODIFICACAO.ISO_8859_1.toString() : r.getValor("codificacaoArquivo").toString());
        xml.escrever("limiteGuiasArquivo", r.getValor("limiteGuiasArquivo").toString());
        xml.escrever("proibirGuiaRepetida", r.getBoolean("proibirGuiaRepetida") ? "True" : "False");
        xml.escrever("tamanhoMinimoGuia", r.getValor("tamanhoMinimoGuia").toString());
        xml.escrever("utilizarSADTInternado", r.getBoolean("utilizarSADTInternado") ? "True" : "False");
        xml.escrever("utilizarDataColeta", r.getBoolean("utilizarDataColeta") ? "True" : "False");
        xml.escrever("ignorarCodigoOperadoraMedico", r.getBoolean("ignorarCodigoOperadoraMedico") ? "True" : "False");
        xml.escrever("utilizarGuiaComoAutorizacao", r.getBoolean("utilizarGuiaComoAutorizacao") ? "True" : "False");
        xml.escrever("limparCaracteresGuia", r.getBoolean("limparCaracteresGuia") ? "True" : "False");
        xml.escrever("naoUtilizarCNPJPrestador", r.getBoolean("naoUtilizarCNPJPrestador") ? "True" : "False");
        xml.escrever("enviarReducaoAcrescimo", r.getBoolean("enviarReducaoAcrescimo") ? "True" : "False");
        xml.escrever("removerPontoCBO", r.getBoolean("removerPontoCBO") ? "True" : "False");
        xml.escrever("cbosPadrao", r.getValor("cbosPadrao").toString());
        xml.escrever("cartaoSUS", r.getValor("cartaoSUS").toString());
        xml.escrever("grauParticipacaoExecutante", r.getValor("grauParticipacaoExecutante").toString());
        xml.escrever("utilizarCpfCnpjPadrao", r.getBoolean("utilizarCpfCnpjPadrao") ? "True" : "False");
        xml.escrever("cpfCnpj", r.getValor("cpfCnpj").toString());
        xml.escrever("naoUtilizarGrauParticipacao", r.getBoolean("naoUtilizarGrauParticipacao") ? "True" : "False");
        xml.escrever("assinarArquivoEletronico", r.getBoolean("assinarArquivoEletronico") ? "True" : "False");
        xml.escrever("enviarCaracteresMatricula", r.getBoolean("enviarCaracteresMatricula") ? "True" : "False");
        xml.escrever("naoInformaTecnicaUtilizada", r.getBoolean("naoInformaTecnicaUtilizada") ? "True" : "False");
        xml.escrever("naoUtilizaViaAcesso", r.getBoolean("naoUtilizaViaAcesso") ? "True" : "False");
        xml.escrever("viaDeAcesso", r.getValor("viaDeAcesso") != null ? r.getValor("viaDeAcesso").toString() : "");
        xml.escrever("enviarIndicacaoClinica", r.getBoolean("enviarIndicacaoClinica") ? "True" : "False");
        xml.escrever("ignorarCodigoExameAgrupamentoProcedimentos", r.getBoolean("ignorarCodigoExameAgrupamentoProcedimentos") ? "True" : "False");
        if (!Funcoes.textoVazio(r.getString("naoEnviarCpfCnpjPrestadorMedicoSolicitante"))) {
            xml.escrever("naoEnviarCpfCnpjPrestadorMedicoSolicitante", r.getString("naoEnviarCpfCnpjPrestadorMedicoSolicitante"));
        }
        if (!Funcoes.textoVazio(r.getString("enviarCodigoPrestadorPadraoMedicoSolicitante"))) {
            xml.escrever("enviarCodigoPrestadorPadraoMedicoSolicitante", r.getBoolean("enviarCodigoPrestadorPadraoMedicoSolicitante") ? "True" : "False");
        }
        if ((versaoTiss = VersaoTiss.getVersaoPorDescricao(r.getString(VERSAO_ARQUIVO))).isVersaoMaior(VersaoTiss.V_4_00_00)) {
            xml.escrever("regimeAtendimento", r.getString("regimeAtendimento"));
            xml.escrever("enviarIdCoberturaEspecial", r.getString("enviarIdCoberturaEspecial"));
            xml.escrever("enviarSaudeOcupacional", r.getString("enviarSaudeOcupacional"));
        }
        if (!Funcoes.textoVazio(r.getString("enviarHorarioProcedimentos"))) {
            xml.escrever("enviarHorarioProcedimentos", r.getBoolean("enviarHorarioProcedimentos") ? "True" : "False");
        }
        try {
            xml.fechar("faturamentoEletronico");
        }
        catch (XMLStringBuilderException e) {
            e.printStackTrace();
        }
        return xml.getXML();
    }

    private String trocaCaracteres(String texto) {
        StringBuilder retorno = new StringBuilder("");
        for (char c : texto.toCharArray()) {
            if (c == '&') {
                retorno.append("e");
                continue;
            }
            retorno.append(c);
        }
        return retorno.toString();
    }

    @Override
    public boolean solicitarDiretorioNoInicio() {
        return false;
    }

    @Override
    public String[] situacoesPermitidasExame(String xml) {
        return null;
    }

    @Override
    public boolean validarCasasDecimais() {
        return true;
    }

    @Override
    public String getCodificacaoArquivo() {
        if (this.config != null) {
            return FaturamentoEletronico.CODIFICACAO.getCodificacao((String)this.config.getValor((String)"codificacaoArquivo").toString()).codificacao;
        }
        return FaturamentoEletronico.CODIFICACAO.ISO_8859_1.codificacao;
    }

    @Override
    public void verificaErrosFatura(ArrayList<DadosFaturamento> requisicoes, Registro configuracaoConvenio) {
        HashMap<String, ArrayList> listaGuiasRepetidas = new HashMap<String, ArrayList>();
        if (requisicoes != null && requisicoes.size() > 0 && configuracaoConvenio != null) {
            for (int k = 0; k < requisicoes.size(); ++k) {
                DadosFaturamento requisicaoFaturada = requisicoes.get(k);
                if (requisicaoFaturada == null) continue;
                requisicaoFaturada.clearProblemas();
                if (!requisicaoFaturada.getFaturar()) continue;
                StringBuilder buf = new StringBuilder();
                int tamanhoMinimoGuia = Integer.parseInt(configuracaoConvenio.getString("tamanhoMinimoGuia"));
                VersaoTiss versaoTiss = VersaoTiss.getVersaoPorDescricao(configuracaoConvenio.getString(VERSAO_ARQUIVO));
                boolean versaoAcima30001 = versaoTiss.isVersaoMaior(VersaoTiss.V_3_00_01);
                if (versaoAcima30001) {
                    if (Funcoes.textoVazio(StringUtil.limpaString(configuracaoConvenio.getValor("cnpjPrestadorNaOperadora").toString(), new String[]{",", ".", "/", "-"})) && Funcoes.textoVazio(requisicaoFaturada.getCnpjFilial()) && !ValidaDoc.checkDoc(requisicaoFaturada.getCnpjFilial(), 7)) {
                        requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.CNPJ_CODIGO_PRESTADOR_OPERADORA, null, null));
                    }
                } else if (configuracaoConvenio.getBoolean("adicionarCNPJOperadora")) {
                    if (Funcoes.textoVazio(requisicaoFaturada.getCnpjFilial()) || !ValidaDoc.checkDoc(requisicaoFaturada.getCnpjFilial(), 7)) {
                        requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.CNPJ_CODIGO_PRESTADOR_OPERADORA, null, null));
                    }
                } else if (Funcoes.textoVazio(StringUtil.limpaString(configuracaoConvenio.getValor("cnpjPrestadorNaOperadora").toString(), new String[]{",", ".", "/", "-"})) && Funcoes.textoVazio(configuracaoConvenio.getValor("codigoPrestadorNaOperadora").toString())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.CNPJ_CODIGO_PRESTADOR_OPERADORA, null, null));
                }
                if (Funcoes.textoVazio(configuracaoConvenio.getValor("convenioRegistroANS").toString())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.DESTINO, null, null));
                }
                if (Funcoes.textoVazio(configuracaoConvenio.getValor("registroANS").toString())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.IDENTIFICACAO_FONTE_PAGADORA, null, null));
                }
                String guiaAnterior = null;
                for (int i = 0; i < requisicaoFaturada.getExamesCount(); ++i) {
                    ArrayList lista;
                    DadosExameFaturamento exame = requisicaoFaturada.getExame(i);
                    if (!exame.getFaturar()) continue;
                    String nomeExame = "\"" + exame.getNomeExame() + "\".";
                    String codigoExame = exame.getCodigoExame();
                    String codigoGuia = exame.getCodigoGuia();
                    if (codigoGuia == null || Funcoes.textoVazio(codigoGuia)) {
                        if (configuracaoConvenio.getBoolean("guiaAutomatica")) {
                            codigoGuia = configuracaoConvenio.getBoolean("ignorarCodigoFilial") ? Funcoes.preencheZero(requisicaoFaturada.getRequisicao(), 8) : Funcoes.preencheZero(requisicaoFaturada.getCodigoFilial(), 2) + Funcoes.preencheZero(requisicaoFaturada.getRequisicao(), 8);
                            exame.setDeveGuia(false);
                            exame.setCodigoGuia(codigoGuia);
                        } else {
                            requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.NUMERO_GUIA_PRESTADOR, nomeExame, exame));
                        }
                    }
                    if (exame.getDataGuia() == null) {
                        requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.DATA_EMISSAO_GUIA, nomeExame, exame));
                    }
                    if (exame.getCodigoAMB() == null || Funcoes.textoVazio(exame.getCodigoAMB())) {
                        requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.PROCEDIMENTO_AMB, nomeExame, exame));
                    }
                    if (exame.getDataExame() == null) {
                        requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.PROCEDIMENTO_DATA, nomeExame, exame));
                    }
                    if (exame.getValorTotalExame() == null) {
                        requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.VALOR_SERVICO_EXECUTADO, nomeExame, exame));
                    }
                    if (versaoAcima30001 && !Funcoes.textoVazio(exame.getCodigoAutorizacao()) && exame.getDataAutorizacao() == null) {
                        requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.DATA_AUTORIZACAO_NAO_INFORMADA, nomeExame, exame));
                    }
                    if (requisicaoFaturada.getTipoTabela() == null || requisicaoFaturada.getTipoTabela().equals((Object)TabelaANS.TiposTabela.Tipo_NAO_CONFIGURADO)) {
                        requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.PROCEDIMENTO_TABELA, nomeExame, exame));
                    }
                    if (exame.getCodigoGuia() == null || Funcoes.textoVazio(exame.getCodigoGuia())) continue;
                    String guia = exame.getCodigoGuia();
                    if (tamanhoMinimoGuia > 0 && !guia.equalsIgnoreCase(guiaAnterior)) {
                        guiaAnterior = guia;
                        if (guia.length() < tamanhoMinimoGuia) {
                            requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.GUIA_TAMANHO_MINIMO, " - Tam. m\u00ednimo = " + tamanhoMinimoGuia + ".", exame));
                        }
                    }
                    if (listaGuiasRepetidas.containsKey(guia)) {
                        lista = (ArrayList)listaGuiasRepetidas.get(guia);
                        lista.add(requisicaoFaturada);
                        continue;
                    }
                    lista = new ArrayList<DadosFaturamento>(){

                        @Override
                        public boolean add(DadosFaturamento o) {
                            if (!this.contains(o)) {
                                return super.add(o);
                            }
                            return false;
                        }
                    };
                    lista.add(requisicaoFaturada);
                    listaGuiasRepetidas.put(guia, lista);
                }
                if (requisicaoFaturada.getMatricula() == null || Funcoes.textoVazio(requisicaoFaturada.getMatricula())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.BENEFICIARIO_CARTEIRINHA, null, null));
                }
                if (requisicaoFaturada.getNomePaciente() == null || Funcoes.textoVazio(requisicaoFaturada.getNomePaciente())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.BENEFICIARIO_NOME_BENEFICIARIO, null, null));
                }
                if ((requisicaoFaturada.getNomePlano() == null || Funcoes.textoVazio(requisicaoFaturada.getNomePlano())) && (requisicaoFaturada.getConvenioFantasia() == null || Funcoes.textoVazio(requisicaoFaturada.getConvenioFantasia()))) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.BENEFICIARIO_PLANO, null, null));
                }
                boolean crmNaoInformado = false;
                if (Funcoes.textoVazio(requisicaoFaturada.getConselhoMedico())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.SOLICITANTE_CONSELHO, null, null));
                    crmNaoInformado = true;
                }
                if (Funcoes.textoVazio(requisicaoFaturada.getCRMMedico())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.SOLICITANTE_NUMERO, null, null));
                    crmNaoInformado = true;
                }
                if (Funcoes.textoVazio(requisicaoFaturada.getUFMedico())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.SOLICITANTE_UF, null, null));
                    crmNaoInformado = true;
                }
                if (Funcoes.textoVazio(requisicaoFaturada.getNomeMedico())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.SOLICITANTE_NOME, null, null));
                }
                boolean checkUtilizarCpfCnpjPadrao = false;
                boolean enviarCodigoPrestadorPadraoParaMedicoSolicitante = false;
                if (versaoTiss.isVersaoMaior(VersaoTiss.V_3_02_00) && Funcoes.textoVazio(requisicaoFaturada.getCodigoMedicoOperadora()) && !configuracaoConvenio.getBoolean("enviarCRM") && (requisicaoFaturada.getCpfMedico() == null || Funcoes.textoVazio(requisicaoFaturada.getCpfMedico()))) {
                    checkUtilizarCpfCnpjPadrao = (Boolean)configuracaoConvenio.getValor("utilizarCpfCnpjPadrao");
                    if (!Funcoes.objectIsNull(configuracaoConvenio.getValor("enviarCodigoPrestadorPadraoMedicoSolicitante"))) {
                        enviarCodigoPrestadorPadraoParaMedicoSolicitante = (Boolean)configuracaoConvenio.getValor("enviarCodigoPrestadorPadraoMedicoSolicitante");
                    }
                }
                if (versaoTiss.isVersaoMaior(VersaoTiss.V_3_00_01)) {
                    if (versaoTiss.isVersaoMaior(VersaoTiss.V_3_05_00)) {
                        if (!(!Funcoes.textoVazio(requisicaoFaturada.getCodigoMedicoOperadora()) || configuracaoConvenio.getBoolean("enviarCRM") || requisicaoFaturada.getCpfMedico() != null && !Funcoes.textoVazio(requisicaoFaturada.getCpfMedico()) || checkUtilizarCpfCnpjPadrao || enviarCodigoPrestadorPadraoParaMedicoSolicitante)) {
                            requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.SOLICITANTE_CODIGO_OPERADORA_CPF, null, null));
                        }
                    } else if (Funcoes.textoVazio(requisicaoFaturada.getCodigoMedicoOperadora()) && !configuracaoConvenio.getBoolean("enviarCRM") && (requisicaoFaturada.getCpfMedico() == null || Funcoes.textoVazio(requisicaoFaturada.getCpfMedico())) && !checkUtilizarCpfCnpjPadrao) {
                        requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.SOLICITANTE_CODIGO_OPERADORA_CPF, null, null));
                    }
                } else if (Funcoes.textoVazio(requisicaoFaturada.getCodigoMedicoOperadora()) && configuracaoConvenio.getBoolean("enviarCRM") && crmNaoInformado) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.SOLICITANTE_CODIGO_OPERADORA_CRM, null, null));
                } else if ((requisicaoFaturada.getCpfMedico() == null || Funcoes.textoVazio(requisicaoFaturada.getCpfMedico())) && crmNaoInformado) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.SOLICITANTE_CODIGO_OPERADORA_CRM, null, null));
                }
                if (requisicaoFaturada.getRazaoSocialFilial() == null || Funcoes.textoVazio(requisicaoFaturada.getRazaoSocialFilial())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.EXECUTANTE_NOME, null, null));
                }
                if ((configuracaoConvenio.getString(VERSAO_ARQUIVO).equals(VersaoTiss.V_3_00_01.getDescricao()) || configuracaoConvenio.getString(VERSAO_ARQUIVO).equals(VersaoTiss.V_3_01_00.getDescricao()) || configuracaoConvenio.getString(VERSAO_ARQUIVO).equals(VersaoTiss.V_3_02_00.getDescricao()) || configuracaoConvenio.getString(VERSAO_ARQUIVO).equals(VersaoTiss.V_3_02_01.getDescricao()) || configuracaoConvenio.getString(VERSAO_ARQUIVO).equals(VersaoTiss.V_3_02_02.getDescricao())) && (requisicaoFaturada.getCodigoCnesExecutante() == null || Funcoes.textoVazio(requisicaoFaturada.getCodigoCnesExecutante()))) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.CNES_FILIAL_EXECUTANTE, null, null));
                }
                if (requisicaoFaturada.getValorTotal() != null) continue;
                requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.VALOR_TOTAL_GERAL, null, null));
            }
        }
        if (configuracaoConvenio.getValor("proibirGuiaRepetida") != null && configuracaoConvenio.getBoolean("proibirGuiaRepetida")) {
            Set guias = listaGuiasRepetidas.keySet();
            for (String guia : guias) {
                ArrayList lista = (ArrayList)listaGuiasRepetidas.get(guia);
                if (lista.size() <= 1) continue;
                for (int i = 0; i < lista.size(); ++i) {
                    DadosFaturamento requisicao = (DadosFaturamento)lista.get(i);
                    if (requisicao == null) continue;
                    StringBuilder buf = new StringBuilder();
                    for (int j = 0; j < lista.size(); ++j) {
                        if (j == i) continue;
                        if (buf.length() > 0) {
                            buf.append(", ");
                        }
                        DadosFaturamento reqAux = (DadosFaturamento)lista.get(j);
                        buf.append("(Fil.: ").append(reqAux.getCodigoFilial()).append(", Req: ").append(reqAux.getRequisicao()).append(")");
                    }
                    requisicao.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.GUIA_REPETIDA, buf.toString(), null));
                }
            }
        }
    }

    @Override
    public void preencheValoresCampos(DadosFaturamento requisicao, Registro configuracaoEletronico, String guia) {
        String codigo;
        String cbo;
        GuiaVirtual.guia.setValor(guia);
        GuiaVirtual.registroAns.setValor(configuracaoEletronico.getValor("registroANS").toString());
        GuiaVirtual.registroAnsDestino.setValor(configuracaoEletronico.getValor("convenioRegistroANS").toString());
        if (requisicao.getGuiaPrincipal() != null) {
            GuiaVirtual.numeroGuiaPrincipal.setValor(requisicao.getGuiaPrincipal());
        }
        if (requisicao.getMatricula() != null) {
            GuiaVirtual.numeroCarteirinha.setValor(requisicao.getMatricula());
        }
        if (requisicao.getNomePlano() != null && !Funcoes.textoVazio(requisicao.getNomePlano())) {
            GuiaVirtual.plano.setValor(requisicao.getNomePlano());
        } else if (requisicao.getConvenioFantasia() != null) {
            GuiaVirtual.plano.setValor(requisicao.getConvenioFantasia());
        }
        if (requisicao.getValidadeCarteira() != null) {
            GuiaVirtual.validadeCarteirinha.setValor(Funcoes.formataData("dd/MM/yyyy", requisicao.getValidadeCarteira()));
        }
        if (requisicao.getNomePaciente() != null) {
            GuiaVirtual.nome.setValor(requisicao.getNomePaciente());
        }
        if (requisicao.getCpfMedico() != null && !Funcoes.textoVazio(requisicao.getCpfMedico())) {
            GuiaVirtual.codigoOperadoraSolicitante.setValor(requisicao.getCpfMedico());
        } else if (requisicao.getCodigoMedicoOperadora() != null && !Funcoes.textoVazio(requisicao.getCodigoMedicoOperadora())) {
            GuiaVirtual.codigoOperadoraSolicitante.setValor(requisicao.getCodigoMedicoOperadora());
        }
        GuiaVirtual.nomeContratadoSolicitante.setValor(requisicao.getNomeMedico());
        GuiaVirtual.nomeProfissionalSolicitante.setValor(requisicao.getNomeMedico());
        GuiaVirtual.conselhoProfissionalSolicitante.setValor(requisicao.getConselhoMedico());
        GuiaVirtual.numeroConselhoProfissionalSolicitante.setValor(requisicao.getCRMMedico());
        GuiaVirtual.ufProfissionalSolicitante.setValor(requisicao.getUFMedico());
        if (!(requisicao.getXmlCbo() == null || Funcoes.textoVazio(requisicao.getXmlCbo()) || (cbo = StringUtil.getValor(requisicao.getXmlCbo(), "cbo")) == null || Funcoes.textoVazio(cbo) || (codigo = StringUtil.getValor(cbo, "codigo")) == null || Funcoes.textoVazio(codigo))) {
            GuiaVirtual.codigoCBOS.setValor(codigo);
        }
        GuiaVirtual.dataHoraSolicitacao.setValor(Funcoes.formataData("dd/MM/yyyy", requisicao.getDataRequisicao()) + " " + Funcoes.formataData("HH:mm", requisicao.getHoraRequisicao()));
        GuiaVirtual.cid10.setValor(requisicao.getCid10());
        VersaoTiss versaoTiss = VersaoTiss.getVersaoPorDescricao(configuracaoEletronico.getString(VERSAO_ARQUIVO));
        boolean versaoAcima30001 = versaoTiss.isVersaoMaior(VersaoTiss.V_3_00_01);
        if (versaoAcima30001) {
            if (!Funcoes.textoVazio(StringUtil.limpaString(configuracaoEletronico.getValor("cnpjPrestadorNaOperadora").toString(), new String[]{",", ".", "/", "-"}))) {
                GuiaVirtual.codigoOperadoraExecutante.setValor(StringUtil.limpaString(configuracaoEletronico.getValor("cnpjPrestadorNaOperadora").toString(), new String[]{",", ".", "/", "-"}));
            } else if (!Funcoes.textoVazio(requisicao.getCnpjFilial()) && ValidaDoc.checkDoc(requisicao.getCnpjFilial(), 7)) {
                GuiaVirtual.codigoOperadoraExecutante.setValor(requisicao.getCnpjFilial());
            }
        } else if (configuracaoEletronico.getBoolean("adicionarCNPJOperadora")) {
            if (!Funcoes.textoVazio(requisicao.getCnpjFilial()) && ValidaDoc.checkDoc(requisicao.getCnpjFilial(), 7)) {
                GuiaVirtual.codigoOperadoraExecutante.setValor(requisicao.getCnpjFilial());
            }
        } else if (!Funcoes.textoVazio(StringUtil.limpaString(configuracaoEletronico.getValor("cnpjPrestadorNaOperadora").toString(), new String[]{",", ".", "/", "-"})) && Funcoes.textoVazio(configuracaoEletronico.getValor("codigoPrestadorNaOperadora").toString())) {
            GuiaVirtual.codigoOperadoraExecutante.setValor(StringUtil.limpaString(configuracaoEletronico.getString("cnpjPrestadorNaOperadora").toString(), new String[]{",", ".", "/", "-"}));
        } else if (Funcoes.textoVazio(StringUtil.limpaString(configuracaoEletronico.getValor("cnpjPrestadorNaOperadora").toString(), new String[]{",", ".", "/", "-"})) && !Funcoes.textoVazio(configuracaoEletronico.getValor("codigoPrestadorNaOperadora").toString())) {
            GuiaVirtual.codigoOperadoraExecutante.setValor(StringUtil.limpaString(configuracaoEletronico.getString("codigoPrestadorNaOperadora").toString(), new String[]{",", ".", "/", "-"}));
        }
        if (requisicao.getRazaoSocialFilial() != null) {
            GuiaVirtual.nomeContratadoExecutante.setValor(requisicao.getRazaoSocialFilial());
        }
        try {
            FilialBean filial = (FilialBean)new FilialService().get(String.valueOf(requisicao.getCodigoFilial()));
            if (filial != null) {
                String aux = "";
                if (filial.getEndereco() != null) {
                    aux = aux + filial.getEndereco();
                }
                if (filial.getComplemento() != null) {
                    aux = aux + filial.getComplemento();
                }
                GuiaVirtual.logradouroNumeroComplemento.setValor(aux);
                if (filial.getCep() != null) {
                    GuiaVirtual.cep.setValor(filial.getCep());
                }
                if (GuiaVirtual.codigoCnesExecutante.getValor() == null && filial.getCnes() != null) {
                    GuiaVirtual.codigoCnesExecutante.setValor(filial.getCnes());
                }
                if (filial.getCidade() != null) {
                    if (filial.getCidade().getNome() != null) {
                        GuiaVirtual.municipio.setValor(filial.getCidade().getNome());
                    }
                    if (filial.getCidade().getUf() != null) {
                        GuiaVirtual.ufExecutante.setValor(filial.getCidade().getUf().toUpperCase());
                    }
                    if (filial.getCidade().getCodigoIbge() != null) {
                        GuiaVirtual.codigoIbge.setValor(filial.getCidade().getCodigoIbge().toString());
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar dados da filial.\nAlguns dados n\u00e3o estar\u00e3o dispon\u00edveis.\n" + e.getMessage(), e.getStackTrace());
        }
        if (configuracaoEletronico.getBoolean("utilizarSADTInternado")) {
            GuiaVirtual.tipoAtendimento.setValor((Object)GuiaVirtual.TipoAtendimento.SADT_INTERNADO);
            GuiaVirtual.tipoSaida.setValor((Object)GuiaVirtual.TipoSaida.INTERNACAO);
        } else {
            GuiaVirtual.tipoAtendimento.setValor((Object)GuiaVirtual.TipoAtendimento.EXAME);
            GuiaVirtual.tipoSaida.setValor((Object)GuiaVirtual.TipoSaida.REFERENCIA);
        }
        GuiaVirtual.totalProcedimento.setValor(requisicao.getValorTotal().toString());
        GuiaVirtual.totalGeralGuia.setValor(Funcoes.formataDecimal(requisicao.getValorTotal().doubleValue()));
    }

    @Override
    public void preencheValoresTabelas(DadosFaturamento requisicao, String guia) {
        if (requisicao != null) {
            Object[] linha;
            GuiaVirtual.procedimentos1.clear();
            GuiaVirtual.procedimentos2.clear();
            boolean isAgruparAmb = requisicao.getAgruparAmb();
            LinkedHashMap<String, Object[]> listaExames = new LinkedHashMap<String, Object[]>();
            for (int i = 0; i < requisicao.getExamesCount(); ++i) {
                DadosExameFaturamento exame = requisicao.getExame(i);
                if (exame == null || exame.getCodigoGuia() != null && !Funcoes.textoVazio(exame.getCodigoGuia()) && !exame.getCodigoGuia().equalsIgnoreCase(guia)) continue;
                if (exame.getDataGuia() != null) {
                    GuiaVirtual.dataEmissaoGuia.setValor(Funcoes.formataData("dd/MM/yyyy", exame.getDataGuia()));
                }
                if (isAgruparAmb) {
                    Object obj = null;
                    Object v = listaExames.get(exame.getCodigoAMB());
                    obj = v;
                    if (v != null) {
                        if (obj instanceof Object[] && (linha = (Object[])obj) != null) {
                            linha[2] = linha[2] + ", " + exame.getNomeExame();
                            linha[3] = Integer.parseInt(linha[3].toString()) + 1;
                            linha[4] = (Double)linha[4] + exame.getValorTotalExame().doubleValue();
                            linha[5] = ArraysUtil.concatenar((DadosExameFaturamento[])linha[5], new DadosExameFaturamento[]{exame});
                        }
                    } else {
                        listaExames.put(exame.getCodigoAMB(), new Object[]{exame.getDataExame(), requisicao.getTipoTabela(), exame.getNomeExame(), 1, exame.getValorTotalExame().doubleValue(), new DadosExameFaturamento[]{exame}});
                    }
                } else {
                    GuiaVirtual.procedimentos1.addLinha(new Object[]{requisicao.getTipoTabela(), exame.getCodigoAMB(), exame.getNomeExame(), 1, 1, new DadosExameFaturamento[]{exame}});
                    GuiaVirtual.procedimentos2.addLinha(new Object[]{exame.getDataExame(), requisicao.getTipoTabela(), exame.getCodigoAMB(), exame.getNomeExame(), 1, Funcoes.formataDecimal(exame.getValorTotalExame().doubleValue()), Funcoes.formataDecimal(exame.getValorTotalExame().doubleValue()), new DadosExameFaturamento[]{exame}});
                }
                if (GuiaVirtual.senha.getValor() != null || exame.getCodigoAutorizacao() == null || Funcoes.textoVazio(exame.getCodigoAutorizacao())) continue;
                GuiaVirtual.senha.setValor(exame.getCodigoAutorizacao());
                if (exame.getDataAutorizacao() != null) {
                    GuiaVirtual.dataAutorizacao.setValor(Funcoes.formataData("dd/MM/yyyy", exame.getDataAutorizacao()));
                }
                if (exame.getValidadeAutorizacao() == null) continue;
                GuiaVirtual.validadeSenha.setValor(Funcoes.formataData("dd/MM/yyyy", exame.getValidadeAutorizacao()));
            }
            if (isAgruparAmb && listaExames.size() > 0) {
                Set ambs = listaExames.keySet();
                Iterator itAmbs = ambs.iterator();
                while (itAmbs.hasNext()) {
                    String amb = ((String)itAmbs.next()).toString();
                    linha = (Object[])listaExames.get(amb);
                    if (linha == null) continue;
                    GuiaVirtual.procedimentos1.addLinha(new Object[]{linha[1], amb, linha[2], linha[3], linha[3], linha[5]});
                    GuiaVirtual.procedimentos2.addLinha(new Object[]{linha[0], linha[1], amb, linha[2], linha[3], Funcoes.formataDecimal((Double)linha[4] / (double)((Integer)linha[3]).intValue()), Funcoes.formataDecimal((Double)linha[4]), linha[5]});
                }
            }
        }
    }

    @Override
    public void getValoresPreenchidos(DadosFaturamento requisicao, ArrayList<DadosExameFaturamento> exames, Registro configuracaoEletronico) {
        configuracaoEletronico.setValor("registroANS", GuiaVirtual.registroAns.getValor() == null ? "" : GuiaVirtual.registroAns.getValor().toString());
        configuracaoEletronico.setValor("convenioRegistroANS", GuiaVirtual.registroAnsDestino.getValor() == null ? "" : GuiaVirtual.registroAnsDestino.getValor().toString());
        requisicao.setGuiaPrincipal(GuiaVirtual.numeroGuiaPrincipal.getValor() == null ? null : GuiaVirtual.numeroGuiaPrincipal.getValor().toString());
        requisicao.setMatricula(GuiaVirtual.numeroCarteirinha.getValor() == null ? null : GuiaVirtual.numeroCarteirinha.getValor().toString());
        requisicao.setNomePlano(GuiaVirtual.plano.getValor() == null ? null : GuiaVirtual.plano.getValor().toString());
        requisicao.setValidadeCarteira(GuiaVirtual.validadeCarteirinha.getValor() == null ? null : Funcoes.getData("dd/MM/yyyy", GuiaVirtual.validadeCarteirinha.getValor().toString()));
        requisicao.setNomePaciente(GuiaVirtual.nome.getValor() == null ? null : GuiaVirtual.nome.getValor().toString());
        requisicao.setNomeMedico(GuiaVirtual.nomeContratadoSolicitante.getValor() == null ? null : GuiaVirtual.nomeContratadoSolicitante.getValor().toString());
        requisicao.setConselhoMedico(GuiaVirtual.conselhoProfissionalSolicitante.getValor() == null ? null : GuiaVirtual.conselhoProfissionalSolicitante.getValor().toString());
        requisicao.setCRMMedico(GuiaVirtual.numeroConselhoProfissionalSolicitante.getValor() == null ? null : GuiaVirtual.numeroConselhoProfissionalSolicitante.getValor().toString());
        requisicao.setUFMedico(GuiaVirtual.ufProfissionalSolicitante.getValor() == null ? null : GuiaVirtual.ufProfissionalSolicitante.getValor().toString());
        requisicao.setCid10(GuiaVirtual.cid10.getValor() == null ? null : GuiaVirtual.cid10.getValor().toString());
        requisicao.setRazaoSocialFilial(GuiaVirtual.nomeContratadoExecutante.getValor() == null ? null : GuiaVirtual.nomeContratadoExecutante.getValor().toString());
        requisicao.setCodigoCnesExecutante(GuiaVirtual.codigoCnesExecutante.getValor() == null ? null : GuiaVirtual.codigoCnesExecutante.getValor().toString());
        if (GuiaVirtual.codigoOperadoraSolicitante.getValor() != null) {
            String codigo = GuiaVirtual.codigoOperadoraSolicitante.getValor().toString();
            if (ValidaDoc.checkDoc(codigo, 8) || ValidaDoc.checkDoc(codigo, 7)) {
                requisicao.setCpfMedico(codigo);
            } else {
                requisicao.setCodigoMedicoOperadora(codigo);
            }
        } else {
            requisicao.setCodigoMedicoOperadora(null);
            requisicao.setCpfMedico(null);
        }
        CBOS.CBO cbo = CBOS.getCBO(GuiaVirtual.codigoCBOS.getValor().toString());
        if (cbo != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("<cbo>");
            buf.append("<codigo>").append(cbo.codigo).append("</codigo>");
            buf.append("<descricao>").append(cbo.descricao).append("</descricao>");
            buf.append("</cbo>");
            requisicao.setXmlCbo(buf.toString());
        }
        if (GuiaVirtual.dataHoraSolicitacao.getValor() != null) {
            String dataAux = GuiaVirtual.dataHoraSolicitacao.getValor().toString() + ":00";
            Date data = Funcoes.getData("dd/MM/yyyy HH:mm:ss", dataAux);
            requisicao.setDataRequisicao(data);
            requisicao.setHoraRequisicao(Time.valueOf(dataAux.substring(11)));
        }
        if (GuiaVirtual.codigoOperadoraExecutante.getValor() != null) {
            String codigo = GuiaVirtual.codigoOperadoraExecutante.getValor().toString();
            if (configuracaoEletronico.getBoolean("adicionarCNPJOperadora") && ValidaDoc.checkDoc(codigo, 7)) {
                requisicao.setCnpjFilial(codigo);
            } else if (ValidaDoc.checkDoc(codigo, 7)) {
                configuracaoEletronico.setValor("cnpjPrestadorNaOperadora", codigo);
                if (Funcoes.textoVazio(this.limpaCNPJ(requisicao.getCnpjFilial()))) {
                    requisicao.setCnpjFilial(codigo);
                }
            } else {
                configuracaoEletronico.setValor("codigoPrestadorNaOperadora", codigo);
            }
        } else if (configuracaoEletronico.getBoolean("adicionarCNPJOperadora")) {
            requisicao.setCnpjFilial(null);
        } else {
            configuracaoEletronico.setValor("codigoPrestadorNaOperadora", "");
            configuracaoEletronico.setValor("cnpjPrestadorNaOperadora", "");
        }
        if (exames != null) {
            boolean todasGuiasPreenchidas = true;
            for (int i = 0; i < exames.size(); ++i) {
                DadosExameFaturamento exame = exames.get(i);
                if (exame == null) continue;
                String guia = GuiaVirtual.guia.getValor() == null ? "" : GuiaVirtual.guia.getValor().toString();
                exame.setCodigoGuia(guia);
                if (!Funcoes.textoVazio(guia)) {
                    exame.setDeveGuia(false);
                } else {
                    todasGuiasPreenchidas = false;
                }
                if (exame.getDataGuia() == null || Funcoes.textoVazio(exame.getDataGuia().toString())) {
                    exame.setDataGuia(GuiaVirtual.dataEmissaoGuia.getValor() == null ? null : Funcoes.getData("dd/MM/yyyy", GuiaVirtual.dataEmissaoGuia.getValor().toString()));
                }
                if (Funcoes.textoVazio(exame.getCodigoAutorizacao())) {
                    exame.setCodigoAutorizacao(GuiaVirtual.senha.getValor() == null ? null : GuiaVirtual.senha.getValor().toString());
                }
                if (exame.getDataAutorizacao() == null || Funcoes.textoVazio(exame.getDataAutorizacao().toString())) {
                    exame.setDataAutorizacao(GuiaVirtual.dataAutorizacao.getValor() == null ? null : Funcoes.getData("dd/MM/yyyy", GuiaVirtual.dataAutorizacao.getValor().toString()));
                }
                if (exame.getValidadeAutorizacao() != null && !Funcoes.textoVazio(exame.getValidadeAutorizacao().toString())) continue;
                exame.setValidadeAutorizacao(GuiaVirtual.validadeSenha.getValor() == null ? null : Funcoes.getData("dd/MM/yyyy", GuiaVirtual.validadeSenha.getValor().toString()));
            }
            if (todasGuiasPreenchidas) {
                requisicao.setDeveGuia(false);
            }
        }
    }

    @Override
    public ArrayList<GuiaVirtual.Campo> getCamposObrigatorios(String versao) {
        ArrayList<GuiaVirtual.Campo> campos = new ArrayList<GuiaVirtual.Campo>();
        campos.add(GuiaVirtual.registroAns);
        campos.add(GuiaVirtual.dataEmissaoGuia);
        campos.add(GuiaVirtual.guia);
        campos.add(GuiaVirtual.numeroCarteirinha);
        campos.add(GuiaVirtual.plano);
        campos.add(GuiaVirtual.nome);
        campos.add(GuiaVirtual.codigoOperadoraSolicitante);
        campos.add(GuiaVirtual.nomeContratadoSolicitante);
        campos.add(GuiaVirtual.registroAnsDestino);
        campos.add(GuiaVirtual.conselhoProfissionalSolicitante);
        campos.add(GuiaVirtual.numeroConselhoProfissionalSolicitante);
        campos.add(GuiaVirtual.ufProfissionalSolicitante);
        campos.add(GuiaVirtual.caraterSolicitacao);
        campos.add(GuiaVirtual.codigoOperadoraExecutante);
        campos.add(GuiaVirtual.nomeContratadoExecutante);
        campos.add(GuiaVirtual.tipoAtendimento);
        campos.add(GuiaVirtual.tipoSaida);
        if (versao.equalsIgnoreCase(VersaoTiss.V_3_00_01.getDescricao()) || versao.equalsIgnoreCase(VersaoTiss.V_3_01_00.getDescricao()) || versao.equalsIgnoreCase(VersaoTiss.V_3_02_00.getDescricao()) || versao.equalsIgnoreCase(VersaoTiss.V_3_02_01.getDescricao()) || versao.equalsIgnoreCase(VersaoTiss.V_3_02_02.getDescricao())) {
            campos.add(GuiaVirtual.codigoCnesExecutante);
            campos.add(GuiaVirtual.dataAutorizacao);
        }
        return campos;
    }

    @Override
    public int[] getColunasObrigatoriasSolicitados() {
        return new int[]{0, 1, 2, 3, 4};
    }

    @Override
    public int[] getColunasObrigatoriasExecutados() {
        return new int[]{0, 1, 2, 3, 4};
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampo> getCamposIncorretos(DadosFaturamento requisicao, String guia) {
        ArrayList<AbstractFaturamentoEletronico.ErroCampo> lista = new ArrayList<AbstractFaturamentoEletronico.ErroCampo>();
        for (int i = 0; i < requisicao.getListaProblemas().size(); ++i) {
            DetalhamentoErroFaturamento erro = requisicao.getListaProblemas().get(i);
            if (erro.getErro().getCodigoErro() == ErrosFaturamento.NUMERO_GUIA_PRESTADOR.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.guia, erro));
            }
            if (guia == null) {
                guia = "";
            }
            if (erro.getGuia() == null && erro.isExame()) {
                erro.getExame().setCodigoGuia("");
            }
            if (erro.isExame() && (!erro.isExame() || !erro.getGuia().trim().equalsIgnoreCase(guia.trim()))) continue;
            int codigoErro = erro.getErro().getCodigoErro();
            if (codigoErro == ErrosFaturamento.BENEFICIARIO_CARTEIRINHA.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.numeroCarteirinha, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.BENEFICIARIO_NOME_BENEFICIARIO.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.nome, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.BENEFICIARIO_PLANO.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.plano, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.SOLICITANTE_CODIGO_OPERADORA_CRM.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.codigoOperadoraSolicitante, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.DATA_EMISSAO_GUIA.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.dataEmissaoGuia, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.DESTINO.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.registroAnsDestino, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.CNPJ_CODIGO_PRESTADOR_OPERADORA.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.codigoOperadoraExecutante, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.EXECUTANTE_NOME.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.nomeContratadoExecutante, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.GUIA_REPETIDA.getCodigoErro() || codigoErro == ErrosFaturamento.GUIA_TAMANHO_MINIMO.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.guia, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.IDENTIFICACAO_FONTE_PAGADORA.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.registroAns, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.SOLICITANTE_CODIGO_OPERADORA_CRM.getCodigoErro() || codigoErro == ErrosFaturamento.SOLICITANTE_CODIGO_OPERADORA_CPF.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.codigoOperadoraSolicitante, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.SOLICITANTE_CONSELHO.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.conselhoProfissionalSolicitante, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.SOLICITANTE_NOME.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.nomeContratadoSolicitante, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.SOLICITANTE_NUMERO.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.numeroConselhoProfissionalSolicitante, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.SOLICITANTE_UF.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.ufProfissionalSolicitante, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.VALOR_SERVICO_EXECUTADO.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.totalProcedimento, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.VALOR_TOTAL_GERAL.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.totalGeralGuia, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.CNES_FILIAL_EXECUTANTE.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.codigoCnesExecutante, erro));
                continue;
            }
            if (codigoErro != ErrosFaturamento.DATA_AUTORIZACAO_NAO_INFORMADA.getCodigoErro()) continue;
            lista.add(new AbstractFaturamentoEletronico.ErroCampo(GuiaVirtual.dataAutorizacao, erro));
        }
        return lista.size() > 0 ? lista : null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasSolicitados(DadosFaturamento requisicao, String guia) {
        ArrayList<AbstractFaturamentoEletronico.ErroExame> lista = new ArrayList<AbstractFaturamentoEletronico.ErroExame>();
        for (int i = 0; i < requisicao.getListaProblemas().size(); ++i) {
            DetalhamentoErroFaturamento erro = requisicao.getListaProblemas().get(i);
            if (erro.isExame() && (!erro.isExame() || !erro.getGuia().equalsIgnoreCase(guia))) continue;
            int codigoErro = erro.getErro().getCodigoErro();
            DadosExameFaturamento exame = erro.getExame();
            if (codigoErro == ErrosFaturamento.PROCEDIMENTO_AMB.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroExame(exame, 1, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.PROCEDIMENTO_QUANTIDADE.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroExame(exame, 3, erro));
                lista.add(new AbstractFaturamentoEletronico.ErroExame(exame, 4, erro));
                continue;
            }
            if (codigoErro != ErrosFaturamento.PROCEDIMENTO_TABELA.getCodigoErro()) continue;
            lista.add(new AbstractFaturamentoEletronico.ErroExame(exame, 0, erro));
        }
        return lista.size() > 0 ? lista : null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasExecutados(DadosFaturamento requisicao, String guia) {
        ArrayList<AbstractFaturamentoEletronico.ErroExame> lista = new ArrayList<AbstractFaturamentoEletronico.ErroExame>();
        for (int i = 0; i < requisicao.getListaProblemas().size(); ++i) {
            DetalhamentoErroFaturamento erro = requisicao.getListaProblemas().get(i);
            if (erro.isExame() && (!erro.isExame() || !erro.getGuia().equalsIgnoreCase(guia))) continue;
            int codigoErro = erro.getErro().getCodigoErro();
            DadosExameFaturamento exame = erro.getExame();
            if (codigoErro == ErrosFaturamento.PROCEDIMENTO_AMB.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroExame(exame, 2, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.PROCEDIMENTO_DATA.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroExame(exame, 0, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.PROCEDIMENTO_QUANTIDADE.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroExame(exame, 4, erro));
                continue;
            }
            if (codigoErro != ErrosFaturamento.PROCEDIMENTO_TABELA.getCodigoErro()) continue;
            lista.add(new AbstractFaturamentoEletronico.ErroExame(exame, 1, erro));
        }
        return lista.size() > 0 ? lista : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean gravaAlteracoes(DadosFaturamento requisicao, String guia, Registro configuracao) {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        try {
            if (requisicao.getCodigoFilial() > 0) {
                buf.setLength(0);
                buf.append(" update filiais_postocoleta ");
                buf.append("    set fil_razaosocial = ").append(requisicao.getRazaoSocialFilial() == null ? "null " : "'" + requisicao.getRazaoSocialFilial() + "' ");
                buf.append("       ,fil_cnpj = ").append(requisicao.getCnpjFilial() == null ? "null " : "'" + requisicao.getCnpjFilial() + "' ");
                buf.append("       ,fil_cnes = '").append(requisicao.getCodigoCnesExecutante()).append("' ");
                buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, buf.toString());
            }
            if (requisicao.getCodigoFilial() > 0 && requisicao.getCodigoConvenio() > 0) {
                buf.setLength(0);
                buf.append(" update convenios ");
                buf.append("    set con_faturaeletronica = '").append(this.registroToXML(configuracao)).append("' ");
                buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                buf.append("    and con_codigo = ").append(requisicao.getCodigoConvenio());
                Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, buf.toString());
            }
            if (!(requisicao.getCodigoFilial() <= 0 || requisicao.getCRMMedico() == null || Funcoes.textoVazio(requisicao.getCRMMedico()) || requisicao.getConselhoMedico() == null || Funcoes.textoVazio(requisicao.getConselhoMedico()) || requisicao.getUFMedico() == null || Funcoes.textoVazio(requisicao.getUFMedico()))) {
                buf.setLength(0);
                buf.append(" update medico ");
                buf.append("    set med_nome = ").append(requisicao.getNomeMedico() == null ? "null " : "'" + requisicao.getNomeMedico() + "' ");
                buf.append("       ,med_cbo = ").append(requisicao.getXmlCbo() == null ? "null " : "'" + requisicao.getXmlCbo() + "' ");
                buf.append("       ,med_cpf = ").append(requisicao.getCpfMedico() == null ? "null " : "'" + requisicao.getCpfMedico() + "' ");
                buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                buf.append("    and med_crm = '").append(requisicao.getCRMMedico()).append("' ");
                buf.append("    and med_conselho = '").append(requisicao.getConselhoMedico()).append("' ");
                buf.append("    and med_uf = '").append(requisicao.getUFMedico()).append("' ");
                Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, buf.toString());
                if (requisicao.getCodigoMedicoOperadora() != null && !Funcoes.textoVazio(requisicao.getCodigoMedicoOperadora()) && requisicao.getCodigoConvenio() > 0) {
                    buf.setLength(0);
                    buf.append(" update medicoconveniotiss ");
                    buf.append("    set mec_codigooperadora = ").append(requisicao.getCodigoMedicoOperadora());
                    buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                    buf.append("    and med_crm = '").append(requisicao.getCRMMedico()).append("' ");
                    buf.append("    and med_conselho = '").append(requisicao.getConselhoMedico()).append("' ");
                    buf.append("    and med_uf = '").append(requisicao.getUFMedico()).append("' ");
                    buf.append("    and con_codigo = ").append(requisicao.getCodigoConvenio());
                    if (Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, buf.toString()) == 0) {
                        buf.setLength(0);
                        buf.append(" insert into medicoconveniotiss (");
                        buf.append("             fil_codigo ");
                        buf.append("            ,med_conselho ");
                        buf.append("            ,med_crm ");
                        buf.append("            ,med_uf ");
                        buf.append("            ,con_codigo ");
                        buf.append("            ,mec_codigooperadora) ");
                        buf.append("      values ( ");
                        buf.append("           ").append(requisicao.getCodigoFilial());
                        buf.append("           ,'").append(requisicao.getConselhoMedico()).append("' ");
                        buf.append("           ,'").append(requisicao.getCRMMedico()).append("' ");
                        buf.append("           ,'").append(requisicao.getUFMedico()).append("' ");
                        buf.append("           ,").append(requisicao.getCodigoConvenio());
                        buf.append("           ,'").append(requisicao.getCodigoMedicoOperadora()).append("') ");
                        Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, buf.toString());
                    }
                }
            }
            if (requisicao.getCodigoFilial() > 0 && requisicao.getRequisicao() > 0) {
                buf.setLength(0);
                if (!requisicao.getConvenioRepasse()) {
                    buf.append(" update requisicao ");
                    buf.append("    set req_guiaprincipal = ").append(requisicao.getGuiaPrincipal() == null ? "null " : "'" + requisicao.getGuiaPrincipal() + "' ");
                    buf.append("       ,req_matricula = ").append(requisicao.getMatricula() == null ? "null " : "'" + requisicao.getMatricula() + "' ");
                    buf.append("       ,req_data = ").append(requisicao.getDataRequisicao() == null ? "null " : "'" + Funcoes.formataData("yyyy-MM-dd", requisicao.getDataRequisicao()) + "' ");
                    buf.append("       ,req_hora = ").append(requisicao.getHoraRequisicao() == null ? "null " : "'" + Funcoes.formataData("HH:mm", requisicao.getHoraRequisicao()) + "' ");
                    buf.append("       ,req_deveguia = ").append(requisicao.getDeveGuia() ? " true " : "false ");
                    if (requisicao.getNomePlano() != null && !Funcoes.textoVazio(requisicao.getNomePlano())) {
                        buf.append("       ,req_nomeplano = ").append("'" + requisicao.getNomePlano() + "' ");
                    } else if (requisicao.getFantasiaConvenioPrincipal() != null) {
                        buf.append("       ,req_nomeplano = ").append("'" + requisicao.getFantasiaConvenioPrincipal() + "' ");
                    }
                    buf.append("       ,req_validadecarteira = ").append(requisicao.getValidadeCarteira() == null ? "null " : "'" + Funcoes.formataData("yyyy-MM-dd", requisicao.getValidadeCarteira()) + "' ");
                    buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                    buf.append("    and req_codigo = ").append(requisicao.getRequisicao());
                } else {
                    buf.append(" update requisicao ");
                    buf.append("    set req_guiaprincipalrepasse = ").append(requisicao.getGuiaPrincipal() == null ? "null " : "'" + requisicao.getGuiaPrincipal() + "' ");
                    buf.append("       ,req_matricularepasse = ").append(requisicao.getMatricula() == null ? "null " : "'" + requisicao.getMatricula() + "' ");
                    buf.append("       ,req_validadecarteirarepasse = ").append(requisicao.getValidadeCarteira() == null ? "null " : "'" + Funcoes.formataData("yyyy-MM-dd", requisicao.getValidadeCarteira()) + "' ");
                    buf.append("       ,req_guiarepasse = ").append(requisicao.getExame(0).getCodigoGuia() == null ? "null " : "'" + requisicao.getExame(0).getCodigoGuia() + "' ");
                    buf.append("       ,req_dataguia = ").append(requisicao.getExame(0).getDataGuia() == null ? "null " : "'" + Funcoes.formataData("yyyy-MM-dd", requisicao.getExame(0).getDataGuia()) + "' ");
                    buf.append("       ,req_deveguiarepasse = ").append(requisicao.getDeveGuia() ? " true " : "false ");
                    if (requisicao.getNomePlano() != null && !Funcoes.textoVazio(requisicao.getNomePlano())) {
                        buf.append("       ,req_nomeplanorepasse = ").append("'" + requisicao.getNomePlano() + "' ");
                    } else if (requisicao.getConvenioFantasia() != null) {
                        buf.append("       ,req_nomeplanorepasse = ").append("'" + requisicao.getConvenioFantasia() + "' ");
                    }
                    buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                    buf.append("    and req_codigo = ").append(requisicao.getRequisicao());
                }
                Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, buf.toString());
            }
            if (requisicao.getCodigoFilial() > 0 && requisicao.getCodigoPaciente() > 0) {
                buf.setLength(0);
                buf.append(" update paciente ");
                buf.append("    set pac_nome = '").append(StringUtil.textoDB(requisicao.getNomePaciente())).append("' ");
                buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                buf.append("    and pac_codigo = ").append(requisicao.getCodigoPaciente());
                Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, buf.toString());
            }
            if (requisicao.getCid10() != null && !Funcoes.textoVazio(requisicao.getCid10())) {
                int i;
                ArrayList<String> cid10 = new ArrayList<String>();
                StringTokenizer tokenizer = new StringTokenizer(requisicao.getCid10(), ",");
                while (tokenizer.hasMoreTokens()) {
                    cid10.add(tokenizer.nextToken().trim().toUpperCase());
                }
                buf.setLength(0);
                buf.append(" select c10_codigo as codigo ");
                buf.append("   from requisicaocid10 ");
                buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                buf.append("    and req_codigo = ").append(requisicao.getRequisicao());
                buf.append("    and c10_codigo not in (");
                for (i = 0; i < cid10.size(); ++i) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    buf.append("'").append(cid10.get(i)).append("'");
                }
                buf.append(") ");
                rs = Conexao.executeQuery(st, buf.toString());
                while (rs.next()) {
                    buf.setLength(0);
                    buf.append(" delete from requisicaocid10 ");
                    buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                    buf.append("    and req_codigo = ").append(requisicao.getRequisicao());
                    buf.append("    and c10_codigo = '").append(rs.getString("codigo")).append("' ");
                    Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, buf.toString());
                }
                for (i = 0; i < cid10.size(); ++i) {
                    buf.setLength(0);
                    buf.append(" select count(1) as qtde ");
                    buf.append("   from requisicaocid10 ");
                    buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                    buf.append("    and req_codigo = ").append(requisicao.getRequisicao());
                    buf.append("    and c10_codigo = '").append(cid10.get(i)).append("' ");
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (!rs.next() || rs.getInt("qtde") != 0) continue;
                    buf.setLength(0);
                    buf.append(" insert into requisicaocid10 (");
                    buf.append("             fil_codigo ");
                    buf.append("            ,req_codigo ");
                    buf.append("            ,c10_codigo ");
                    buf.append("            ,usr_codigo ");
                    buf.append("            ,rci_datahora) ");
                    buf.append("      values (");
                    buf.append("           ").append(requisicao.getCodigoFilial());
                    buf.append("           ,").append(requisicao.getRequisicao());
                    buf.append("           ,'").append(cid10.get(i)).append("' ");
                    buf.append("           ,'").append(Variaveis.login).append("' ");
                    buf.append("           ,'").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("') ");
                    Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, buf.toString());
                }
            }
            if (requisicao.getCodigoFilial() > 0 && requisicao.getCodigoTabelaPreco() > 0) {
                buf.setLength(0);
                buf.append(" update tabelaprecoexames ");
                buf.append("    set tpe_tabelaans = ").append(requisicao.getTipoTabela() == null ? "null " : "'" + requisicao.getTipoTabela().codigo + "' ");
                buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                buf.append("    and tpe_codigo = ").append(requisicao.getCodigoTabelaPreco());
                Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, buf.toString());
            }
            String codigoGuiaAux = null;
            if (configuracao.getBoolean("guiaAutomatica")) {
                codigoGuiaAux = configuracao.getBoolean("ignorarCodigoFilial") ? Funcoes.preencheZero(requisicao.getRequisicao(), 8) : Funcoes.preencheZero(requisicao.getCodigoFilial(), 2) + Funcoes.preencheZero(requisicao.getRequisicao(), 8);
            }
            if (!requisicao.getConvenioRepasse()) {
                for (int i = 0; i < requisicao.getExamesCount(); ++i) {
                    DadosExameFaturamento exame = requisicao.getExame(i);
                    buf.setLength(0);
                    buf.append(" update examerequisicao ");
                    buf.append("    set exr_validadeguia = ").append(exame.getValidadeGuia() == null ? "null " : "'" + Funcoes.formataData("yyyy-MM-dd", exame.getValidadeGuia()) + "' ");
                    if (codigoGuiaAux != null && codigoGuiaAux.equalsIgnoreCase(guia)) {
                        buf.append("       ,exr_guia = null ");
                    } else {
                        buf.append("       ,exr_guia = ").append(exame.getCodigoGuia() == null || !exame.getExamePai().getCodigo().equals(exame.getCodigoExame()) ? "null " : "'" + exame.getCodigoGuia() + "' ");
                    }
                    buf.append("       ,exr_dataguia = ").append(exame.getDataGuia() == null ? "null " : "'" + Funcoes.formataData("yyyy-MM-dd", exame.getDataGuia()) + "' ");
                    buf.append("       ,exr_codautorizacao = ").append(exame.getCodigoAutorizacao() == null ? "null " : "'" + exame.getCodigoAutorizacao() + "' ");
                    buf.append("       ,exr_dataautorizacao = ").append(exame.getDataAutorizacao() == null ? "null " : "'" + Funcoes.formataData("yyyy-MM-dd", exame.getDataAutorizacao()) + "' ");
                    buf.append("       ,exr_datavalidadeautorizacao = ").append(exame.getValidadeAutorizacao() == null ? "null " : "'" + Funcoes.formataData("yyyy-MM-dd", exame.getValidadeAutorizacao()) + "' ");
                    buf.append("       ,exr_deveguia = (exr_deveguia AND ").append(exame.getCodigoGuia() == null ? "true" : "false").append(") ");
                    buf.append("       ,exr_data = ").append(exame.getDataExame() == null ? "null " : "'" + Funcoes.formataData("yyyy-MM-dd", exame.getDataExame()) + " " + Funcoes.formataHora(requisicao.getHoraRequisicao(), false) + "' ");
                    buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                    buf.append("    and req_codigo = ").append(requisicao.getRequisicao());
                    if (exame.getExamePai().getCodigo().equals(exame.getCodigoExame())) {
                        buf.append("    and exa_codigo = '").append(exame.getCodigoExame()).append("' ");
                        buf.append("    and mco_codigo = ").append(exame.getCodigoMaterial());
                    } else {
                        buf.append("    and exa_codigo = '").append(exame.getExamePai().getCodigo()).append("' ");
                        buf.append("    and mco_codigo = ").append(exame.getExamePai().getMaterial());
                    }
                    Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, buf.toString());
                    if (!exame.getExamePai().getCodigo().equals(exame.getCodigoExame())) {
                        buf.setLength(0);
                        buf.append(" update examerequisicaoguiaagrupada ");
                        buf.append("    set exg_validadeguia = ").append(exame.getValidadeGuia() == null ? "null " : "'" + Funcoes.formataData("yyyy-MM-dd", exame.getValidadeGuia()) + "' ");
                        buf.append("       ,exg_guia = ").append(exame.getCodigoGuia() == null ? "null " : "'" + exame.getCodigoGuia() + "' ");
                        buf.append("       ,exg_dataguia = ").append(exame.getDataGuia() == null ? "null " : "'" + Funcoes.formataData("yyyy-MM-dd", exame.getDataGuia()) + "' ");
                        buf.append("       ,exg_deveguia = (exg_deveguia AND ").append(exame.getCodigoGuia() == null ? "true" : "false").append(") ");
                        buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                        buf.append("    and req_codigo = ").append(requisicao.getRequisicao());
                        buf.append("    and exa_codigo = '").append(exame.getExamePai().getCodigo()).append("' ");
                        buf.append("    and mco_codigo = ").append(exame.getExamePai().getMaterial());
                        buf.append("    and exa_codfilho = '").append(exame.getCodigoExame()).append("' ");
                        buf.append("    and mco_codfilho = ").append(exame.getCodigoMaterial());
                        Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, buf.toString());
                    }
                    buf.setLength(0);
                    if (ParametrosGerais.getPrecoMetodologia()) {
                        buf.append(" update detalhetabelaprecometodologia ");
                        buf.append("    set dtm_codamb = ").append(exame.getCodigoAMB() == null ? "null " : "'" + exame.getCodigoAMB() + "' ");
                        buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                        buf.append("    and exa_codigo = '").append(exame.getCodigoExame()).append("' ");
                        buf.append("    and mco_codigo = ").append(exame.getCodigoMaterial());
                        buf.append("    and met_codigo = ").append(exame.getCodigoMetodologia());
                        buf.append("    and tpe_codigo = ").append(requisicao.getCodigoTabelaPreco());
                    } else {
                        buf.append(" update detalhetabelapreco ");
                        buf.append("    set dtp_codamb = ").append(exame.getCodigoAMB() == null ? "null " : "'" + exame.getCodigoAMB() + "' ");
                        buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                        buf.append("    and exa_codigo = '").append(exame.getCodigoExame()).append("' ");
                        buf.append("    and mco_codigo = ").append(exame.getCodigoMaterial());
                        buf.append("    and tpe_codigo = ").append(requisicao.getCodigoTabelaPreco());
                    }
                    Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, buf.toString());
                }
            }
            Conexao.arquivaSQL();
            if (st == null) return true;
        }
        catch (Exception e) {
            boolean bl;
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel atualizar dados da guia: \"" + guia + "\".\n" + e.getMessage(), e.getStackTrace());
                bl = false;
                if (st == null) return bl;
            }
            catch (Throwable throwable) {
                if (st == null) throw throwable;
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        Conexao.fecharStatement(st);
        return true;
    }

    @Override
    public void aplicarModificacoesGerais(ArrayList<DadosFaturamento> requisicoes, DadosFaturamento requisicao, DadosFaturamento requisicaoModificada, Registro configuracaoEletronico, Registro configuracaoEletronicoModificada) {
        if (requisicoes == null || requisicao == null || requisicaoModificada == null || configuracaoEletronico == null || configuracaoEletronicoModificada == null) {
            return;
        }
        Set<String> chaves = configuracaoEletronico.getKeySet();
        for (String chave : chaves) {
            Object valor = configuracaoEletronicoModificada.getValor(chave);
            if (chave.equalsIgnoreCase("cnpjPrestadorNaOperadora")) {
                if (configuracaoEletronico.getBoolean("adicionarCNPJOperadora") || ValidaDoc.checkDoc(valor.toString(), 7)) continue;
                configuracaoEletronico.setValor(chave, valor);
                continue;
            }
            configuracaoEletronico.setValor(chave, valor);
        }
        for (int i = 0; i < requisicoes.size(); ++i) {
            DadosFaturamento requisicaoAux = requisicoes.get(i);
            if (requisicaoAux == requisicaoModificada) continue;
            if (requisicao.getCodigoPaciente() == requisicaoAux.getCodigoPaciente()) {
                requisicaoAux.setNomePaciente(requisicaoModificada.getNomePaciente());
            }
            if (requisicao.getCRMMedico().equalsIgnoreCase(requisicaoAux.getCRMMedico()) && requisicao.getConselhoMedico().equalsIgnoreCase(requisicaoAux.getConselhoMedico()) && requisicao.getUFMedico().equalsIgnoreCase(requisicaoAux.getUFMedico())) {
                requisicaoAux.setNomeMedico(requisicaoModificada.getNomeMedico());
                requisicaoAux.setConselhoMedico(requisicaoModificada.getConselhoMedico());
                requisicaoAux.setCRMMedico(requisicaoModificada.getCRMMedico());
                requisicaoAux.setUFMedico(requisicaoModificada.getUFMedico());
                requisicaoAux.setCpfMedico(requisicaoModificada.getCpfMedico());
                requisicaoAux.setCodigoMedicoOperadora(requisicaoModificada.getCodigoMedicoOperadora());
                requisicaoAux.setXmlCbo(requisicaoModificada.getXmlCbo());
            }
            if (requisicao.getCodigoFilial() == requisicaoAux.getCodigoFilial()) {
                requisicaoAux.setRazaoSocialFilial(requisicaoModificada.getRazaoSocialFilial());
                requisicaoAux.setCnpjFilial(requisicaoModificada.getCnpjFilial());
                requisicaoAux.setCodigoCnesExecutante(requisicaoModificada.getCodigoCnesExecutante());
            }
            if (requisicao.getCodigoConvenio() == requisicaoAux.getCodigoConvenio()) {
                requisicaoAux.setTipoTabela(requisicaoModificada.getTipoTabela());
            }
            block2: for (int j = 0; j < requisicaoAux.getExamesCount(); ++j) {
                DadosExameFaturamento exame = requisicaoAux.getExame(j);
                if (exame == null) continue;
                for (int k = 0; k < requisicaoModificada.getExamesCount(); ++k) {
                    DadosExameFaturamento exameModificado = requisicaoModificada.getExame(k);
                    if (!exameModificado.getCodigoExame().equalsIgnoreCase(exame.getCodigoExame()) || exameModificado.getCodigoMaterial() != exame.getCodigoMaterial() || requisicao.getCodigoConvenio() != requisicaoAux.getCodigoConvenio() || requisicao.getCodigoTabelaPreco() != requisicaoAux.getCodigoTabelaPreco()) continue;
                    exame.setCodigoAMB(exameModificado.getCodigoAMB());
                    continue block2;
                }
            }
        }
    }

    private String limpaCNPJ(String cnpj) {
        return StringUtil.limpaString(cnpj, new String[]{",", ".", "/", "-"});
    }

    @Override
    public Object[] getListaDadosAdicionais() {
        return null;
    }

    @Override
    public void setListaDadosAdicionais(Object[] listaDadosAdicionais) {
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampoBPA> getCamposIncorretosBPA(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<JanelaConfiguracaoFaturamentoBPA.CampoBPA> getCamposObrigatoriosBPA() {
        return null;
    }
}

