/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

public class SolicitarStatusAutorizacaoAPI {
    private static final String CODIGOSOLICITACAO = "codigo_solicitacao";
    private static final String SEQUENCIAITEM = "sequencia_item";
    private static final String SITUACAO = "situacao";
    private static final String CODIGOSERVICO = "codigo_servico";
    private static final String DESCRICAOSERVICO = "descricao_servico";
    private static final String QUANTIDADESOLICITADA = "quantidade_solicitada";
    private static final String QUANTIDADEAUTORIZADA = "quantidade_autorizada";
    private List<RetornoSolicitacao> listaRetorno = new ArrayList<RetornoSolicitacao>();

    public void solicitarStatusAutorizacao(String endereco) throws IOException {
        URL url = new URL(endereco);
        URLConnection conn = url.openConnection();
        BufferedReader buffer = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String retorno = buffer.readLine();
        if (retorno != null) {
            String[] itens = retorno.split(",");
            RetornoSolicitacao retornoSolicitacao = new RetornoSolicitacao();
            for (int i = 0; i < itens.length; ++i) {
                String valor = itens[i];
                if (valor.contains(CODIGOSOLICITACAO)) {
                    retornoSolicitacao.setCodigo_solicitacao(valor.substring(valor.indexOf(":") + 1, valor.length()));
                }
                if (valor.contains(SEQUENCIAITEM)) {
                    retornoSolicitacao.setSequencia_item(valor.substring(valor.indexOf(":") + 1, valor.length()));
                }
                if (valor.contains(SITUACAO)) {
                    retornoSolicitacao.setSituacao(valor.substring(valor.indexOf(":") + 1, valor.length()));
                }
                if (valor.contains(CODIGOSERVICO)) {
                    retornoSolicitacao.setCodigo_servico(valor.substring(valor.indexOf(":") + 1, valor.length()));
                }
                if (valor.contains(DESCRICAOSERVICO)) {
                    retornoSolicitacao.setDescricao_servico(valor.substring(valor.indexOf(":") + 1, valor.length()));
                }
                if (valor.contains(QUANTIDADESOLICITADA)) {
                    retornoSolicitacao.setQuantidade_solicitada(valor.substring(valor.indexOf(":") + 1, valor.length()));
                }
                if (!valor.contains(QUANTIDADEAUTORIZADA)) continue;
                retornoSolicitacao.setQuantidade_autorizada(valor.substring(valor.indexOf(":") + 1, valor.length()));
                this.listaRetorno.add(retornoSolicitacao);
                retornoSolicitacao = new RetornoSolicitacao();
            }
        }
    }

    public List<RetornoSolicitacao> getListaRetorno() {
        return this.listaRetorno;
    }

    public void setListaRetorno(List<RetornoSolicitacao> listaRetorno) {
        this.listaRetorno = listaRetorno;
    }

    public class RetornoSolicitacao {
        private String codigo_solicitacao;
        private String sequencia_item;
        private String situacao;
        private String codigo_servico;
        private String descricao_servico;
        private String quantidade_solicitada;
        private String quantidade_autorizada;

        public String getCodigo_solicitacao() {
            return this.codigo_solicitacao;
        }

        public void setCodigo_solicitacao(String codigo_solicitacao) {
            this.codigo_solicitacao = codigo_solicitacao;
        }

        public String getSequencia_item() {
            return this.sequencia_item;
        }

        public void setSequencia_item(String sequencia_item) {
            this.sequencia_item = sequencia_item;
        }

        public String getCodigo_servico() {
            return this.codigo_servico;
        }

        public void setCodigo_servico(String codigo_servico) {
            this.codigo_servico = codigo_servico;
        }

        public String getDescricao_servico() {
            return this.descricao_servico;
        }

        public void setDescricao_servico(String descricao_servico) {
            this.descricao_servico = descricao_servico;
        }

        public String getQuantidade_solicitada() {
            return this.quantidade_solicitada;
        }

        public void setQuantidade_solicitada(String quantidade_solicitada) {
            this.quantidade_solicitada = quantidade_solicitada;
        }

        public String getQuantidade_autorizada() {
            return this.quantidade_autorizada;
        }

        public void setQuantidade_autorizada(String quantidade_autorizada) {
            this.quantidade_autorizada = quantidade_autorizada;
        }

        public String getSituacao() {
            return this.situacao;
        }

        public void setSituacao(String situacao) {
            this.situacao = situacao;
        }
    }
}

