/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import br.gov.ans.www.padroes.tiss.schemas.Dm_simNao;
import br.gov.ans.www.padroes.tiss.schemas.Dm_tipoTransacao;
import jalis.comum.dados.DadosExames;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.TissWS;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class SolicitacaoProcedimentoXML
extends TissWS {
    private static final String CARATER_ATENDIMENTO = "1";
    private static final String TAG_BODY = "soapenv:Body";
    private static final String TAG_CABECALHO = "cabecalho";
    private static final String TAG_IDENTIFICACAO_TRANSACAO = "identificacaoTransacao";
    private static final String TAG_TIPO_TRANSACAO = "tipoTransacao";
    private static final String TAG_SEQUENCIAL_TRANSACAO = "sequencialTransacao";
    private static final String TAG_DATA_REGISTRO_TRANSACAO = "dataRegistroTransacao";
    private static final String TAG_HORA_REGISTRO_TRANSACAO = "horaRegistroTransacao";
    private static final String TAG_ORIGEM = "origem";
    private static final String TAG_IDENTIFICACAO_PRESTADOR = "identificacaoPrestador";
    private static final String TAG_CODIGO_PRESTADOR_NA_OPERADORA = "codigoPrestadorNaOperadora";
    private static final String TAG_DESTINO = "destino";
    private static final String TAG_REGISTRO_ANS = "registroANS";
    private static final String TAG_PADRAO = "Padrao";
    private static final String TAG_LOGIN_SENHA_PRESTADOR = "loginSenhaPrestador";
    private static final String TAG_LOGIN_PRESTADOR = "loginPrestador";
    private static final String TAG_SENHA_PRESTADOR = "senhaPrestador";
    private static final String TAG_SOLICITACAO_PROCEDIMENTO = "solicitacaoProcedimento";
    private static final String TAG_SOLICITACAO_SPSADT = "solicitacaoSP-SADT";
    private static final String TAG_CABECALHO_SOLICITACAO = "cabecalhoSolicitacao";
    private static final String TAG_NUMERO_GUIA_PRESTADOR = "numeroGuiaPrestador";
    private static final String TAG_DADOS_BENEFICIARIO = "dadosBeneficiario";
    private static final String TAG_NUMERO_CARTEIRA = "numeroCarteira";
    private static final String TAG_ATENDIMENTO_RN = "atendimentoRN";
    private static final String TAG_NOME_BENEFICIARIO = "nomeBeneficiario";
    private static final String TAG_DADOS_SOLICITANTE = "dadosSolicitante";
    private static final String TAG_CONTRATADO_SOLICITANTE = "contratadoSolicitante";
    private static final String TAG_NOME_CONTRATADO = "nomeContratado";
    private static final String TAG_PROFISSIONAL_SOCILITANTE = "profissionalSolicitante";
    private static final String TAG_NOME_PROFISSIONAL = "nomeProfissional";
    private static final String TAG_CONSELHO_PROFISSIONAL = "conselhoProfissional";
    private static final String TAG_NUMERO_CONSELHO_PROFISSIONAL = "numeroConselhoProfissional";
    private static final String TAG_UF = "UF";
    private static final String TAG_CBOS = "CBOS";
    private static final String TAG_CARATER_ATENDIMENTO = "caraterAtendimento";
    private static final String TAG_DATA_SOLICITACAO = "dataSolicitacao";
    private static final String TAG_PROCEDIMENTOS_SOLICITADOS = "procedimentosSolicitados";
    private static final String TAG_PROCEDIMENTO = "procedimento";
    private static final String TAG_CODIGO_TABELA = "codigoTabela";
    private static final String TAG_CODIGO_PROCEDIMENTO = "codigoProcedimento";
    private static final String TAG_DESCRICAO_PROCEDIMENTO = "descricaoProcedimento";
    private static final String TAG_QUANTIDADE_SOLICITADA = "quantidadeSolicitada";
    private static final String TAG_DADOS_EXECUTANTE = "dadosExecutante";
    private static final String TAG_CODIGO_NA_OPERAORA = "codigonaOperadora";
    private static final String TAG_CNES = "CNES";
    private static final String TAG_HASH = "hash";
    private static final String TAG_AUTORIZACAO_PROCEDIMENTO = "ans:autorizacaoProcedimento";
    private static final String TAG_AUTORIZACAO_SERVICO = "ans:autorizacaoServico";
    private static final String TAG_DADOS_AUTORIZACAO = "ans:dadosAutorizacao";
    private static final String TAG_SENHA = "ans:senha";
    private static final String TAG_VALIDADE_SENHA = "ans:dataValidadeSenha";
    private static final String TAG_STATUS_AUTORIZACAO = "ans:statusSolicitacao";
    private static final String TAG_MOTIVOS_NEGATIVA = "ans:motivosNegativa";
    private static final String TAG_MOTIVO_NEGATIVA = "ans:motivoNegativa";
    private static final String TAG_NUMERO_GUIA_OPERADORA = "numeroGuiaOperadora";
    private static final String TAG_DATA_AUTORIZACAO = "ans:dataAutorizacao";
    private static final String TAG_DATA_VALIDADE = "ans:dataValidadeSenha";
    private static final String TAG_MENSAGEM_ERRO = "ans:mensagemErro";
    private static final String TAG_CODIGO_GLOSA = "ans:codigoGlosa";
    private static final String TAG_DESCRICAO_GLOSA = "ans:descricaoGlosa";
    private String padrao = null;
    private String sequencialTransacao = null;
    private String dataRegistroTransacao = null;
    private String horaRegistroTransacao = null;
    private String codigoPrestadorNaOperadora = null;
    private String registroANS = null;
    private String dataSolicitacao = "";
    private String codigoNaOperadora = null;
    private String CNES = null;
    private String nomeContratado = null;
    private String codigoTabela = null;
    private String nomeProfissional = null;
    private String conselhoProfissional = null;
    private String numeroConselhoProfissional = null;
    private String UF = null;
    private String CBOS = null;
    private String numeroGuiaPrestador = null;
    private String numeroCarteira = null;
    private String nomeBeneficiario = null;
    private String address = null;
    private String nomeContratadoExecutante = null;
    private ArrayList<DadosExames> listaExames = new ArrayList();
    private String login = "";
    private String senha = "";

    public String enviarSolicitacaoXML() throws Exception {
        String requestSoap = this.getXML();
        SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection soapConnection = soapConnectionFactory.createConnection();
        String url = this.getAddress();
        MimeHeaders headers = new MimeHeaders();
        headers.addHeader("Content-Type", "text/xml");
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage msg = messageFactory.createMessage(headers, (InputStream)new ByteArrayInputStream(requestSoap.getBytes()));
        try {
            SOAPMessage soapResponse = soapConnection.call(msg, (Object)url);
            Document xmlRespostaARequisicao = soapResponse.getSOAPBody().getOwnerDocument();
            return SolicitacaoProcedimentoXML.converteXMLParaString(xmlRespostaARequisicao, 0);
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter conex\u00e3o com a operadora.", 1);
            return "";
        }
    }

    public static String converteXMLParaString(Document xml, int espacosIdentacao) {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            transfac.setAttribute("indent-number", new Integer(espacosIdentacao));
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(xml);
            trans.transform(source, result);
            String xmlString = sw.toString();
            return xmlString;
        }
        catch (TransformerException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    private String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.escrever("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns=\"http://www.ans.gov.br/padroes/tiss/schemas\" xmlns:ans=\"http://www.ans.gov.br/padroes/tiss/schemas\" xmlns:xd=\"http://www.w3.org/2000/09/xmldsig#\">");
            xml.abrir(SolicitacaoProcedimentoXML.getTagBody());
            xml.abrir("solicitacaoProcedimentoWS");
            this.montaCabecalhoSolicitacao(xml);
            this.montaSolicitacaoProcedimento(xml);
            xml.escrever(SolicitacaoProcedimentoXML.getTagHash(), this.calculaHash());
            xml.fechar("solicitacaoProcedimentoWS");
            xml.fechar(SolicitacaoProcedimentoXML.getTagBody());
            xml.escrever("</soapenv:Envelope>");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return xml.getXML();
    }

    public XMLStringBuilder montaCabecalhoSolicitacao(XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(SolicitacaoProcedimentoXML.getTagCabecalho());
        xml.abrir(SolicitacaoProcedimentoXML.getTagIdentificacaoTransacao());
        xml.escrever(SolicitacaoProcedimentoXML.getTagTipoTransacao(), Dm_tipoTransacao.SOLICITACAO_PROCEDIMENTOS.toString());
        xml.escrever(SolicitacaoProcedimentoXML.getTagSequencialTransacao(), this.getSequencialTransacao());
        xml.escrever(SolicitacaoProcedimentoXML.getTagDataRegistroTransacao(), this.getDataRegistroTransacao());
        xml.escrever(SolicitacaoProcedimentoXML.getTagHoraRegistroTransacao(), this.getHoraRegistroTransacao());
        xml.fechar(SolicitacaoProcedimentoXML.getTagIdentificacaoTransacao());
        xml.abrir(SolicitacaoProcedimentoXML.getTagOrigem());
        xml.abrir(SolicitacaoProcedimentoXML.getTagIdentificacaoPrestador());
        xml.escrever(SolicitacaoProcedimentoXML.getTagCodigoPrestadorNaOperadora(), this.getCodigoPrestadorNaOperadora());
        xml.fechar(SolicitacaoProcedimentoXML.getTagIdentificacaoPrestador());
        xml.fechar(SolicitacaoProcedimentoXML.getTagOrigem());
        xml.abrir(SolicitacaoProcedimentoXML.getTagDestino());
        xml.escrever(SolicitacaoProcedimentoXML.getTagRegistroAns(), this.getRegistroANS());
        xml.fechar(SolicitacaoProcedimentoXML.getTagDestino());
        xml.escrever(SolicitacaoProcedimentoXML.getTagPadrao(), this.getPadrao());
        xml.abrir(SolicitacaoProcedimentoXML.getTagLoginSenhaPrestador());
        xml.escrever(SolicitacaoProcedimentoXML.getTagLoginPrestador(), this.getLogin());
        xml.escrever(SolicitacaoProcedimentoXML.getTagSenhaPrestador(), this.getSenha());
        xml.fechar(SolicitacaoProcedimentoXML.getTagLoginSenhaPrestador());
        xml.fechar(SolicitacaoProcedimentoXML.getTagCabecalho());
        return xml;
    }

    private XMLStringBuilder montaSolicitacaoProcedimento(XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(SolicitacaoProcedimentoXML.getTagSolicitacaoProcedimento());
        xml.abrir(SolicitacaoProcedimentoXML.getTagSolicitacaoSpsadt());
        xml.abrir(SolicitacaoProcedimentoXML.getTagCabecalhoSolicitacao());
        xml.escrever(SolicitacaoProcedimentoXML.getTagRegistroAns(), this.getRegistroANS());
        xml.escrever(SolicitacaoProcedimentoXML.getTagNumeroGuiaPrestador(), this.getNumeroGuiaPrestador());
        xml.fechar(SolicitacaoProcedimentoXML.getTagCabecalhoSolicitacao());
        xml.abrir(SolicitacaoProcedimentoXML.getTagDadosBeneficiario());
        xml.escrever(SolicitacaoProcedimentoXML.getTagNumeroCarteira(), this.getNumeroCarteira());
        xml.escrever(SolicitacaoProcedimentoXML.getTagAtendimentoRn(), Dm_simNao.N.toString());
        xml.escrever(SolicitacaoProcedimentoXML.getTagNomeBeneficiario(), this.getNomeBeneficiario());
        xml.fechar(SolicitacaoProcedimentoXML.getTagDadosBeneficiario());
        xml.abrir(SolicitacaoProcedimentoXML.getTagDadosSolicitante());
        xml.abrir(SolicitacaoProcedimentoXML.getTagContratadoSolicitante());
        xml.escrever(SolicitacaoProcedimentoXML.getTagCodigoPrestadorNaOperadora(), this.getCodigoPrestadorNaOperadora());
        xml.escrever(SolicitacaoProcedimentoXML.getTagNomeContratado(), this.getNomeContratado());
        xml.fechar(SolicitacaoProcedimentoXML.getTagContratadoSolicitante());
        xml.abrir(SolicitacaoProcedimentoXML.getTagProfissionalSocilitante());
        xml.escrever(SolicitacaoProcedimentoXML.getTagNomeProfissional(), this.getNomeProfissional());
        xml.escrever(SolicitacaoProcedimentoXML.getTagConselhoProfissional(), this.getConselhoProfissional());
        xml.escrever(SolicitacaoProcedimentoXML.getTagNumeroConselhoProfissional(), this.getNumeroConselhoProfissional());
        xml.escrever(SolicitacaoProcedimentoXML.getTagUf(), this.getUF());
        xml.escrever(SolicitacaoProcedimentoXML.getTagCbos(), this.getCBOS());
        xml.fechar(SolicitacaoProcedimentoXML.getTagProfissionalSocilitante());
        xml.fechar(SolicitacaoProcedimentoXML.getTagDadosSolicitante());
        xml.escrever(SolicitacaoProcedimentoXML.getTagCaraterAtendimento(), CARATER_ATENDIMENTO);
        xml.escrever(SolicitacaoProcedimentoXML.getTagDataSolicitacao(), this.getDataSolicitacao());
        xml.abrir(SolicitacaoProcedimentoXML.getTagProcedimentosSolicitados());
        this.montaProcedimentosSolicitados(xml);
        xml.fechar(SolicitacaoProcedimentoXML.getTagProcedimentosSolicitados());
        xml.abrir(SolicitacaoProcedimentoXML.getTagDadosExecutante());
        xml.escrever(SolicitacaoProcedimentoXML.getTagCodigoNaOperaora(), this.getCodigoNaOperadora());
        xml.escrever(SolicitacaoProcedimentoXML.getTagNomeContratado(), this.getNomeContratado());
        xml.escrever(SolicitacaoProcedimentoXML.getTagCnes(), this.getCNES());
        xml.fechar(SolicitacaoProcedimentoXML.getTagDadosExecutante());
        xml.fechar(SolicitacaoProcedimentoXML.getTagSolicitacaoSpsadt());
        xml.fechar(SolicitacaoProcedimentoXML.getTagSolicitacaoProcedimento());
        return xml;
    }

    private XMLStringBuilder montaProcedimentosSolicitados(XMLStringBuilder xml) throws XMLStringBuilderException {
        ArrayList<DadosExames> listaExames = this.getListaExames();
        if (listaExames == null || listaExames.size() == 0) {
            return xml;
        }
        for (int i = 0; i < listaExames.size(); ++i) {
            String codigoProcedimento = listaExames.get(i).getCodigoAMBTabelaPreco();
            String descricaoProcedimento = listaExames.get(i).getDescricao();
            String quantidadeSolicitada = String.valueOf(listaExames.get(i).getQuantidadeExame());
            xml.abrir(SolicitacaoProcedimentoXML.getTagProcedimento());
            xml.escrever(SolicitacaoProcedimentoXML.getTagCodigoTabela(), this.getCodigoTabela());
            xml.escrever(SolicitacaoProcedimentoXML.getTagCodigoProcedimento(), StringUtil.limpaString(codigoProcedimento, new String[]{".", "-"}));
            xml.escrever(SolicitacaoProcedimentoXML.getTagDescricaoProcedimento(), descricaoProcedimento);
            xml.fechar(SolicitacaoProcedimentoXML.getTagProcedimento());
            xml.escrever(SolicitacaoProcedimentoXML.getTagQuantidadeSolicitada(), quantidadeSolicitada);
        }
        return xml;
    }

    public String getPadrao() {
        return this.padrao;
    }

    public void setPadrao(String padrao) {
        this.padrao = padrao;
    }

    public String getSequencialTransacao() {
        return this.sequencialTransacao;
    }

    public void setSequencialTransacao(String sequencialTransacao) {
        this.sequencialTransacao = sequencialTransacao;
    }

    public String getDataRegistroTransacao() {
        return this.dataRegistroTransacao;
    }

    public void setDataRegistroTransacao(String dataRegistroTransacao) {
        this.dataRegistroTransacao = dataRegistroTransacao;
    }

    public String getHoraRegistroTransacao() {
        return this.horaRegistroTransacao;
    }

    public void setHoraRegistroTransacao(String horaRegistroTransacao) {
        this.horaRegistroTransacao = horaRegistroTransacao;
    }

    public String getCodigoPrestadorNaOperadora() {
        return this.codigoPrestadorNaOperadora;
    }

    public void setCodigoPrestadorNaOperadora(String codigoPrestadorNaOperadora) {
        this.codigoPrestadorNaOperadora = codigoPrestadorNaOperadora;
    }

    public String getRegistroANS() {
        return this.registroANS;
    }

    public void setRegistroANS(String registroANS) {
        this.registroANS = registroANS;
    }

    public String getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    public void setDataSolicitacao(String dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    public String getCodigoNaOperadora() {
        return this.codigoNaOperadora;
    }

    public void setCodigoNaOperadora(String codigoNaOperadora) {
        this.codigoNaOperadora = codigoNaOperadora;
    }

    public String getCNES() {
        return this.CNES;
    }

    public void setCNES(String CNES) {
        this.CNES = CNES;
    }

    public String getNomeContratado() {
        return this.nomeContratado;
    }

    public void setNomeContratado(String nomeContratado) {
        this.nomeContratado = nomeContratado;
    }

    public ArrayList<DadosExames> getListaExames() {
        return this.listaExames;
    }

    public void setListaExames(ArrayList<DadosExames> listaExames) {
        this.listaExames = listaExames;
    }

    public String getCodigoTabela() {
        return this.codigoTabela;
    }

    public void setCodigoTabela(String codigoTabela) {
        this.codigoTabela = codigoTabela;
    }

    public String getNomeProfissional() {
        return this.nomeProfissional;
    }

    public void setNomeProfissional(String nomeProfissional) {
        this.nomeProfissional = nomeProfissional;
    }

    public String getConselhoProfissional() {
        return this.conselhoProfissional;
    }

    public void setConselhoProfissional(String conselhoProfissional) {
        this.conselhoProfissional = conselhoProfissional;
    }

    public String getNumeroConselhoProfissional() {
        return this.numeroConselhoProfissional;
    }

    public void setNumeroConselhoProfissional(String numeroConselhoProfissional) {
        this.numeroConselhoProfissional = numeroConselhoProfissional;
    }

    public String getUF() {
        return this.UF;
    }

    public void setUF(String UF) {
        this.UF = UF;
    }

    public String getCBOS() {
        return this.CBOS;
    }

    public void setCBOS(String CBOS2) {
        this.CBOS = CBOS2;
    }

    public String getNumeroGuiaPrestador() {
        return this.numeroGuiaPrestador;
    }

    public void setNumeroGuiaPrestador(String numeroGuiaPrestador) {
        this.numeroGuiaPrestador = numeroGuiaPrestador;
    }

    public String getNumeroCarteira() {
        return this.numeroCarteira;
    }

    public void setNumeroCarteira(String numeroCarteira) {
        this.numeroCarteira = numeroCarteira;
    }

    public String getNomeBeneficiario() {
        return this.nomeBeneficiario;
    }

    public void setNomeBeneficiario(String nomeBeneficiario) {
        this.nomeBeneficiario = nomeBeneficiario;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getNomeContratadoExecutante() {
        return this.nomeContratadoExecutante;
    }

    public void setNomeContratadoExecutante(String nomeContratadoExecutante) {
        this.nomeContratadoExecutante = nomeContratadoExecutante;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public static String getTagBody() {
        return TAG_BODY;
    }

    public static String getTagCabecalho() {
        return TAG_CABECALHO;
    }

    public static String getTagIdentificacaoTransacao() {
        return TAG_IDENTIFICACAO_TRANSACAO;
    }

    public static String getTagTipoTransacao() {
        return TAG_TIPO_TRANSACAO;
    }

    public static String getTagSequencialTransacao() {
        return TAG_SEQUENCIAL_TRANSACAO;
    }

    public static String getTagDataRegistroTransacao() {
        return TAG_DATA_REGISTRO_TRANSACAO;
    }

    public static String getTagHoraRegistroTransacao() {
        return TAG_HORA_REGISTRO_TRANSACAO;
    }

    public static String getTagOrigem() {
        return TAG_ORIGEM;
    }

    public static String getTagIdentificacaoPrestador() {
        return TAG_IDENTIFICACAO_PRESTADOR;
    }

    public static String getTagCodigoPrestadorNaOperadora() {
        return TAG_CODIGO_PRESTADOR_NA_OPERADORA;
    }

    public static String getTagDestino() {
        return TAG_DESTINO;
    }

    public static String getTagRegistroAns() {
        return TAG_REGISTRO_ANS;
    }

    public static String getTagPadrao() {
        return TAG_PADRAO;
    }

    public static String getTagLoginSenhaPrestador() {
        return TAG_LOGIN_SENHA_PRESTADOR;
    }

    public static String getTagLoginPrestador() {
        return TAG_LOGIN_PRESTADOR;
    }

    public static String getTagSenhaPrestador() {
        return TAG_SENHA_PRESTADOR;
    }

    public static String getTagSolicitacaoProcedimento() {
        return TAG_SOLICITACAO_PROCEDIMENTO;
    }

    public static String getTagSolicitacaoSpsadt() {
        return TAG_SOLICITACAO_SPSADT;
    }

    public static String getTagCabecalhoSolicitacao() {
        return TAG_CABECALHO_SOLICITACAO;
    }

    public static String getTagNumeroGuiaPrestador() {
        return TAG_NUMERO_GUIA_PRESTADOR;
    }

    public static String getTagDadosBeneficiario() {
        return TAG_DADOS_BENEFICIARIO;
    }

    public static String getTagNumeroCarteira() {
        return TAG_NUMERO_CARTEIRA;
    }

    public static String getTagAtendimentoRn() {
        return TAG_ATENDIMENTO_RN;
    }

    public static String getTagNomeBeneficiario() {
        return TAG_NOME_BENEFICIARIO;
    }

    public static String getTagDadosSolicitante() {
        return TAG_DADOS_SOLICITANTE;
    }

    public static String getTagContratadoSolicitante() {
        return TAG_CONTRATADO_SOLICITANTE;
    }

    public static String getTagNomeContratado() {
        return TAG_NOME_CONTRATADO;
    }

    public static String getTagProfissionalSocilitante() {
        return TAG_PROFISSIONAL_SOCILITANTE;
    }

    public static String getTagNomeProfissional() {
        return TAG_NOME_PROFISSIONAL;
    }

    public static String getTagConselhoProfissional() {
        return TAG_CONSELHO_PROFISSIONAL;
    }

    public static String getTagNumeroConselhoProfissional() {
        return TAG_NUMERO_CONSELHO_PROFISSIONAL;
    }

    public static String getTagUf() {
        return TAG_UF;
    }

    public static String getTagCbos() {
        return TAG_CBOS;
    }

    public static String getTagCaraterAtendimento() {
        return TAG_CARATER_ATENDIMENTO;
    }

    public static String getTagDataSolicitacao() {
        return TAG_DATA_SOLICITACAO;
    }

    public static String getTagProcedimentosSolicitados() {
        return TAG_PROCEDIMENTOS_SOLICITADOS;
    }

    public static String getTagProcedimento() {
        return TAG_PROCEDIMENTO;
    }

    public static String getTagCodigoTabela() {
        return TAG_CODIGO_TABELA;
    }

    public static String getTagCodigoProcedimento() {
        return TAG_CODIGO_PROCEDIMENTO;
    }

    public static String getTagDescricaoProcedimento() {
        return TAG_DESCRICAO_PROCEDIMENTO;
    }

    public static String getTagQuantidadeSolicitada() {
        return TAG_QUANTIDADE_SOLICITADA;
    }

    public static String getTagDadosExecutante() {
        return TAG_DADOS_EXECUTANTE;
    }

    public static String getTagCodigoNaOperaora() {
        return TAG_CODIGO_NA_OPERAORA;
    }

    public static String getTagCnes() {
        return TAG_CNES;
    }

    public static String getTagHash() {
        return TAG_HASH;
    }

    public static String getTagAutorizacaoServico() {
        return TAG_AUTORIZACAO_SERVICO;
    }

    public static String getTagNumeroguiaoperadora() {
        return TAG_NUMERO_GUIA_OPERADORA;
    }

    public static String getTagDataAutorizacao() {
        return TAG_DATA_AUTORIZACAO;
    }

    public static String getTagDataValidade() {
        return "ans:dataValidadeSenha";
    }

    public static String getTagAutorizacaoProcedimento() {
        return TAG_AUTORIZACAO_PROCEDIMENTO;
    }

    public static String getTagMensagemErro() {
        return TAG_MENSAGEM_ERRO;
    }

    public static String getTagCodigoGlosa() {
        return TAG_CODIGO_GLOSA;
    }

    public static String getTagDescricaoGlosa() {
        return TAG_DESCRICAO_GLOSA;
    }

    public static String getTagDadosAutorizacao() {
        return TAG_DADOS_AUTORIZACAO;
    }

    public static String getTagSenha() {
        return TAG_SENHA;
    }

    public static String getTagValidadeSenha() {
        return "ans:dataValidadeSenha";
    }

    public static String getTagStatusAutorizacao() {
        return TAG_STATUS_AUTORIZACAO;
    }

    public static String getTagNumeroGuiaOperadora() {
        return TAG_NUMERO_GUIA_OPERADORA;
    }

    public static String getTagMotivoNegativa() {
        return TAG_MOTIVO_NEGATIVA;
    }

    public static String getTagMotivosNegativa() {
        return TAG_MOTIVOS_NEGATIVA;
    }
}

