/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import br.com.unimeduberaba.tiss.v30301.AutorizacaoProcedimento;
import br.com.unimeduberaba.tiss.v30301.Beneficiario;
import br.com.unimeduberaba.tiss.v30301.Cabecalho;
import br.com.unimeduberaba.tiss.v30301.CabecalhoSolicitacao;
import br.com.unimeduberaba.tiss.v30301.Contratado;
import br.com.unimeduberaba.tiss.v30301.Destino;
import br.com.unimeduberaba.tiss.v30301.Executante;
import br.com.unimeduberaba.tiss.v30301.Identificacao;
import br.com.unimeduberaba.tiss.v30301.IdentificacaoSolicitacao;
import br.com.unimeduberaba.tiss.v30301.Internacao;
import br.com.unimeduberaba.tiss.v30301.Login;
import br.com.unimeduberaba.tiss.v30301.Origem;
import br.com.unimeduberaba.tiss.v30301.Prestador;
import br.com.unimeduberaba.tiss.v30301.Procedimento;
import br.com.unimeduberaba.tiss.v30301.Procedimentos;
import br.com.unimeduberaba.tiss.v30301.Profissional;
import br.com.unimeduberaba.tiss.v30301.Prorogacao;
import br.com.unimeduberaba.tiss.v30301.Sadt;
import br.com.unimeduberaba.tiss.v30301.SituacaoAutorizacao;
import br.com.unimeduberaba.tiss.v30301.SolicitacaoProcedimento;
import br.com.unimeduberaba.tiss.v30301.SolicitacaoProcedimento30301PortBindingStub;
import br.com.unimeduberaba.tiss.v30301.SolicitacaoStatusAutorizacao30301PortBindingStub;
import br.com.unimeduberaba.tiss.v30301.Solicitante;
import br.com.unimeduberaba.tiss.v30301.StatusAutorizacao;
import br.com.unimeduberaba.tiss.v30301.TipoTransacao;
import jalis.comum.dados.DadosExames;
import jalis.laboratorio.util.faturamento.eletronico.SolicitacaoAutorizacao;
import jalis.util.StringUtil;
import java.net.URL;
import java.util.ArrayList;

public class SolicitacaoProcedimentoUberaba
extends SolicitacaoAutorizacao {
    private static final String CARATER_ATENDIMENTO = "1";

    public SolicitacaoProcedimentoUberaba() {
    }

    public SolicitacaoProcedimentoUberaba(String codigoPrestadorNaOperadora, String sequencialTransacao, String dataRegistroTransacao, String horaRegistroTransacao, String registroANS, String numeroCarteira, String nomeBeneficiario, String nomeProfissional, String conselhoProfissional, String numeroConselhoProfissional, String uf, String cbos, String nomeContratado, String nomeContratadoExecutante, String numeroGuiaPrestador, String numeroGuiaPrincipal, String padrao, String dataSolicitacao, String codigoNaOperadora, String cnes, String codigoTabela, ArrayList<DadosExames> listaExames, String login, String senha) {
        this.setCodigoPrestadorNaOperadora(codigoPrestadorNaOperadora);
        this.setSequencialTransacao(sequencialTransacao);
        this.setDataRegistroTransacao(dataRegistroTransacao);
        this.setHoraRegistroTransacao(horaRegistroTransacao);
        this.setRegistroANS(registroANS);
        this.setNumeroCarteira(numeroCarteira);
        this.setNomeBeneficiario(nomeBeneficiario);
        this.setNomeProfissional(nomeProfissional);
        this.setConselhoProfissional(conselhoProfissional);
        this.setNumeroConselhoProfissional(numeroConselhoProfissional);
        this.setUF(uf);
        this.setCBOS(cbos);
        this.setNomeContratado(nomeContratado);
        this.setNomeContratadoExecutante(nomeContratadoExecutante);
        this.setNumeroGuiaPrestador(numeroGuiaPrestador);
        this.setNumeroGuiaPrincipal(numeroGuiaPrincipal);
        this.setPadrao(padrao);
        this.setDataSolicitacao(dataSolicitacao);
        this.setCodigoNaOperadora(codigoNaOperadora);
        this.setCNES(cnes);
        this.setCodigoTabela(codigoTabela);
        this.setListaExames(listaExames);
        this.setLogin(login);
        this.setSenha(senha);
    }

    public Cabecalho montaCabecalhoTransacao() {
        Identificacao identificacaoTransacao = this.montaCabecalhoIdentificacaoTransacao();
        String falhaNegocio = null;
        Origem origem = this.montaOrigem();
        Destino destino = this.montaDestino();
        String padrao = this.getPadrao();
        Login loginSenhaPrestador = this.montaLoginSenhaPrestador();
        return new Cabecalho(identificacaoTransacao, falhaNegocio, origem, destino, padrao, loginSenhaPrestador);
    }

    public Cabecalho montaCabecalhoTransacaoAutorizacao() {
        Identificacao identificacaoTransacao = this.montaCabecalhoIdentificacaoTransacaoAutorizacao();
        String falhaNegocio = null;
        Origem origem = this.montaOrigem();
        Destino destino = this.montaDestino();
        String padrao = this.getPadrao();
        Login loginSenhaPrestador = this.montaLoginSenhaPrestador();
        return new Cabecalho(identificacaoTransacao, falhaNegocio, origem, destino, padrao, loginSenhaPrestador);
    }

    private Identificacao montaCabecalhoIdentificacaoTransacao() {
        TipoTransacao.SOLICITACAO_PROCEDIMENTOS.toString();
        return new Identificacao(TipoTransacao.SOLICITACAO_PROCEDIMENTOS, this.getSequencialTransacao(), this.getDataRegistroTransacao(), this.getHoraRegistroTransacao());
    }

    private Identificacao montaCabecalhoIdentificacaoTransacaoAutorizacao() {
        TipoTransacao.SOLICITA_STATUS_AUTORIZACAO.toString();
        return new Identificacao(TipoTransacao.SOLICITA_STATUS_AUTORIZACAO, this.getSequencialTransacao(), this.getDataRegistroTransacao(), this.getHoraRegistroTransacao());
    }

    private Origem montaOrigem() {
        Prestador identificacaoPrestador = new Prestador();
        identificacaoPrestador.setCodigoPrestadorNaOperadora(this.getCodigoPrestadorNaOperadora());
        return new Origem(identificacaoPrestador, null);
    }

    private Destino montaDestino() {
        Prestador identificacao = null;
        String regANS = this.getRegistroANS();
        return new Destino(identificacao, regANS);
    }

    private Login montaLoginSenhaPrestador() {
        String loginPrestador = this.getLogin();
        String senhaPrestador = this.getSenha();
        return new Login(loginPrestador, senhaPrestador);
    }

    private SolicitacaoProcedimento montaSolicitacaoProcedimento() {
        Sadt solicitacaoSPSADT = this.montaSolicitacaoSPSADT();
        Internacao solicitacaoInternacao = null;
        Prorogacao solicitacaoProrrogacao = null;
        return new SolicitacaoProcedimento(solicitacaoSPSADT, solicitacaoInternacao, solicitacaoProrrogacao);
    }

    private Sadt montaSolicitacaoSPSADT() {
        CabecalhoSolicitacao cabecalhoSolicitacao = this.montaCabecalhoSolicitacao();
        String numeroGuiaPrincipal = this.getNumeroGuiaPrincipal();
        Beneficiario dadosBeneficiario = this.montaBeneficiarioDados();
        Solicitante dadosSolicitante = this.montaDadosSolicitante();
        String caraterAtendimento = CARATER_ATENDIMENTO;
        String dtSolicitacao = this.getDataSolicitacao();
        String indicacaoClinica = null;
        Procedimentos[] procedimentosSolicitados = this.montaProcedimentosSolicitados();
        Executante dadosExecutante = this.montaDadosExecutante();
        String observacao = null;
        return new Sadt(cabecalhoSolicitacao, numeroGuiaPrincipal, dadosBeneficiario, dadosSolicitante, caraterAtendimento, dtSolicitacao, indicacaoClinica, procedimentosSolicitados, dadosExecutante, observacao);
    }

    private Executante montaDadosExecutante() {
        String codigoNaOperadora = this.getCodigoPrestadorNaOperadora();
        String nome = this.getNomeContratadoExecutante();
        String cnes = this.getCNES();
        return new Executante(codigoNaOperadora, nome, cnes);
    }

    private Procedimentos[] montaProcedimentosSolicitados() {
        ArrayList<DadosExames> listaExames = this.getListaExames();
        if (listaExames == null || listaExames.size() == 0) {
            return null;
        }
        Procedimentos[] listaProcedimentos = new Procedimentos[listaExames.size()];
        for (int i = 0; i < listaExames.size(); ++i) {
            String codigoProcedimento = listaExames.get(i).getCodigoAMBTabelaPreco();
            String descricaoProcedimento = listaExames.get(i).getDescricao();
            String qtde = String.valueOf(listaExames.get(i).getQuantidadeExame());
            Integer quantidadeSolicitada = new Integer(qtde);
            Procedimento procedimento = this.montaProcedimento(this.getCodigoTabela(), codigoProcedimento, descricaoProcedimento);
            listaProcedimentos[i] = new Procedimentos(procedimento, quantidadeSolicitada.intValue());
        }
        return listaProcedimentos;
    }

    private Procedimento montaProcedimento(String codigoTabela, String codigoProcedimento, String descricaoProcedimento) {
        codigoProcedimento = StringUtil.limpaString(codigoProcedimento, new String[]{".", "-"});
        return new Procedimento(codigoTabela, codigoProcedimento, descricaoProcedimento);
    }

    private Solicitante montaDadosSolicitante() {
        Contratado contratadoSolicitante = this.montaContratadoSolicitante();
        Profissional profissionalSolicitante = this.montaProfissionalSolicitante();
        return new Solicitante(contratadoSolicitante, profissionalSolicitante);
    }

    private Profissional montaProfissionalSolicitante() {
        String nomeProf = this.getNomeProfissional();
        String conselhoProf = this.getConselhoProfissional();
        String numeroConselhoProf = this.getNumeroConselhoProfissional();
        String uf = this.getUF();
        String cBOS = this.getCBOS();
        return new Profissional(nomeProf, conselhoProf, numeroConselhoProf, uf, cBOS);
    }

    private Contratado montaContratadoSolicitante() {
        String codPrestadorNaOperadora = this.getCodigoPrestadorNaOperadora();
        String cpfContratado = null;
        String cnpjContratado = null;
        String nomeContrata = this.getNomeContratado();
        return new Contratado(codPrestadorNaOperadora, cpfContratado, cnpjContratado, nomeContrata);
    }

    private CabecalhoSolicitacao montaCabecalhoSolicitacao() {
        String regANS = this.getRegistroANS();
        String numeroGuiaPrest = this.getNumeroGuiaPrestador();
        return new CabecalhoSolicitacao(regANS, numeroGuiaPrest);
    }

    private Beneficiario montaBeneficiarioDados() {
        String numCarteira = this.getNumeroCarteira();
        String atendimentoRN = "N";
        String nomeBenef = this.getNomeBeneficiario();
        String numeroCNS = null;
        return new Beneficiario(numCarteira, atendimentoRN, nomeBenef, numeroCNS);
    }

    @Override
    public Object enviarSolicitacao() throws Exception {
        SolicitacaoProcedimento30301PortBindingStub proxy = new SolicitacaoProcedimento30301PortBindingStub(new URL(this.getAddress()), null);
        Cabecalho cabecalho = this.montaCabecalhoTransacao();
        SolicitacaoProcedimento solicitacaoProcedimento = this.montaSolicitacaoProcedimento();
        AutorizacaoProcedimento autorizacao = proxy.solicitacaoProcedimentoWS(cabecalho, solicitacaoProcedimento, this.calculaHash());
        return autorizacao;
    }

    @Override
    public Object enviarAutorizacao() throws Exception {
        Cabecalho cabecalhoAutorizacao = this.montaCabecalhoTransacaoAutorizacao();
        StatusAutorizacao solicitacaoStatusAutorizacao = this.montaSolicitacaoStatusAutorizacao();
        SolicitacaoStatusAutorizacao30301PortBindingStub proxyAutorizacao = new SolicitacaoStatusAutorizacao30301PortBindingStub(new URL(this.getAddressAutorizacao()), null);
        SituacaoAutorizacao autorizacaoPrestador = proxyAutorizacao.solicitacaoStatusAutorizacaoWS(cabecalhoAutorizacao, solicitacaoStatusAutorizacao, this.calculaHash());
        return autorizacaoPrestador;
    }

    private StatusAutorizacao montaSolicitacaoStatusAutorizacao() {
        IdentificacaoSolicitacao identificacaoSolicitacao = new IdentificacaoSolicitacao(this.registroANS, this.getNumeroGuiaPrestador());
        Beneficiario dadosBeneficiario = this.montaBeneficiarioDados();
        Contratado dadosContratado = this.montaContratadoSolicitante();
        return new StatusAutorizacao(identificacaoSolicitacao, dadosBeneficiario, dadosContratado);
    }
}

