/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import br.gov.ans.www.padroes.tiss.schemas.AutorizacaoProcedimentoWS;
import br.gov.ans.www.padroes.tiss.schemas.CabecalhoTransacao;
import br.gov.ans.www.padroes.tiss.schemas.CabecalhoTransacaoDestino;
import br.gov.ans.www.padroes.tiss.schemas.CabecalhoTransacaoIdentificacaoTransacao;
import br.gov.ans.www.padroes.tiss.schemas.CabecalhoTransacaoOrigem;
import br.gov.ans.www.padroes.tiss.schemas.CabecalhoTransacaoOrigemIdentificacaoPrestador;
import br.gov.ans.www.padroes.tiss.schemas.Ct_beneficiarioDados;
import br.gov.ans.www.padroes.tiss.schemas.Ct_contratadoDados;
import br.gov.ans.www.padroes.tiss.schemas.Ct_contratadoProfissionalDados;
import br.gov.ans.www.padroes.tiss.schemas.Ct_guiaCabecalho;
import br.gov.ans.www.padroes.tiss.schemas.Ct_loginSenha;
import br.gov.ans.www.padroes.tiss.schemas.Ct_procedimentoDados;
import br.gov.ans.www.padroes.tiss.schemas.Ct_solicitacaoProcedimento;
import br.gov.ans.www.padroes.tiss.schemas.Ctm_spSadtSolicitacaoGuia;
import br.gov.ans.www.padroes.tiss.schemas.Ctm_spSadtSolicitacaoGuiaDadosExecutante;
import br.gov.ans.www.padroes.tiss.schemas.Ctm_spSadtSolicitacaoGuiaDadosSolicitante;
import br.gov.ans.www.padroes.tiss.schemas.Ctm_spSadtSolicitacaoGuiaProcedimentosSolicitados;
import br.gov.ans.www.padroes.tiss.schemas.Dm_simNao;
import br.gov.ans.www.padroes.tiss.schemas.Dm_tipoTransacao;
import br.gov.ans.www.padroes.tiss.schemas.SolicitacaoProcedimentoWS;
import br.gov.ans.www.tiss.ws.tipos.tisssolicitacaoprocedimento.v40100.TissSolicitacaoProcedimentoLocator;
import br.gov.ans.www.tiss.ws.tipos.tisssolicitacaoprocedimento.v40100.TissSolicitacaoProcedimento_PortType;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import jalis.comum.dados.DadosExames;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.TissWS;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class SolicitacaoProcedimento
extends TissWS {
    private static final String CARATER_ATENDIMENTO = "1";
    private String padrao = null;
    private String sequencialTransacao = null;
    private String dataRegistroTransacao = null;
    private String horaRegistroTransacao = null;
    private String codigoPrestadorNaOperadora = null;
    private String registroANS = null;
    private String dataSolicitacao = "";
    private String codigoNaOperadora = null;
    private String cnes = null;
    private String nomeContratado = null;
    private String codigoTabela = null;
    private String nomeProfissional = null;
    private String conselhoProfissional = null;
    private String numeroConselhoProfissional = null;
    private String uf = null;
    private String cbos = null;
    private String numeroGuiaPrestador = null;
    private String numeroCarteira = null;
    private String nomeBeneficiario = null;
    private String address = null;
    private String nomeContratadoExecutante = null;
    private ArrayList<DadosExames> listaExames = new ArrayList();
    private String login = "";
    private String senha = "";
    private Boolean recemNascido;
    private String indicacaoClinica = "";

    public CabecalhoTransacao montaCabecalhoTransacao() throws DatatypeConfigurationException {
        CabecalhoTransacaoIdentificacaoTransacao identificacaoTransacao = this.montaCabecalhoIdentificacaoTransacao();
        CabecalhoTransacaoOrigem origem = this.montaOrigem();
        CabecalhoTransacaoDestino destino = this.montaDestino();
        String padrao = this.addHash(this.getPadrao());
        CabecalhoTransacao cabecalhoTransacao = new CabecalhoTransacao();
        cabecalhoTransacao.setIdentificacaoTransacao(identificacaoTransacao);
        cabecalhoTransacao.setOrigem(origem);
        cabecalhoTransacao.setDestino(destino);
        cabecalhoTransacao.setPadrao(padrao);
        if (!Funcoes.textoVazio(this.login) && !Funcoes.textoVazio(this.senha)) {
            cabecalhoTransacao.setLoginSenhaPrestador(this.montaLoginSenhaPrestador());
        }
        return cabecalhoTransacao;
    }

    private CabecalhoTransacaoIdentificacaoTransacao montaCabecalhoIdentificacaoTransacao() {
        CabecalhoTransacaoIdentificacaoTransacao identificacaoTransacao = new CabecalhoTransacaoIdentificacaoTransacao();
        this.addHash(Dm_tipoTransacao.SOLICITACAO_PROCEDIMENTOS.toString());
        identificacaoTransacao.setTipoTransacao(Dm_tipoTransacao.SOLICITACAO_PROCEDIMENTOS);
        identificacaoTransacao.setSequencialTransacao(this.addHash(this.getSequencialTransacao()));
        identificacaoTransacao.setDataRegistroTransacao(this.addHash(this.getDataRegistroTransacao()));
        identificacaoTransacao.setHoraRegistroTransacao(this.addHash(this.getHoraRegistroTransacao()));
        return identificacaoTransacao;
    }

    private CabecalhoTransacaoOrigem montaOrigem() {
        CabecalhoTransacaoOrigemIdentificacaoPrestador identificacaoPrestador = new CabecalhoTransacaoOrigemIdentificacaoPrestador();
        identificacaoPrestador.setCodigoPrestadorNaOperadora(this.addHash(this.getCodigoPrestadorNaOperadora()));
        CabecalhoTransacaoOrigem origem = new CabecalhoTransacaoOrigem();
        origem.setIdentificacaoPrestador(identificacaoPrestador);
        return origem;
    }

    private CabecalhoTransacaoDestino montaDestino() {
        String regANS = this.addHash(this.getRegistroANS());
        CabecalhoTransacaoDestino destino = new CabecalhoTransacaoDestino();
        destino.setRegistroANS(regANS);
        return destino;
    }

    private Ct_loginSenha montaLoginSenhaPrestador() {
        Ct_loginSenha loginUnimed = new Ct_loginSenha();
        loginUnimed.setLoginPrestador(this.login);
        loginUnimed.setSenhaPrestador(this.senha);
        return loginUnimed;
    }

    private Ct_solicitacaoProcedimento montaSolicitacaoProcedimento() {
        Ctm_spSadtSolicitacaoGuia solicitacaoSPSADT = this.montaSolicitacaoSPSADT();
        Ct_solicitacaoProcedimento solicitacaoProcedimento = new Ct_solicitacaoProcedimento();
        solicitacaoProcedimento.setSolicitacaoSPSADT(solicitacaoSPSADT);
        return solicitacaoProcedimento;
    }

    private Ctm_spSadtSolicitacaoGuia montaSolicitacaoSPSADT() {
        Ct_guiaCabecalho cabecalhoSolicitacao = this.montaCabecalhoSolicitacao();
        String tipoEtapaAutorizacao = this.addHash("2");
        Ct_beneficiarioDados dadosBeneficiario = this.montaBeneficiarioDados();
        Ctm_spSadtSolicitacaoGuiaDadosSolicitante dadosSolicitante = this.montaDadosSolicitante();
        String caraterAtendimento = this.addHash(CARATER_ATENDIMENTO);
        Ctm_spSadtSolicitacaoGuia ctmSpSadtGuia = new Ctm_spSadtSolicitacaoGuia();
        String dataSolicitacao = this.addHash(this.getDataSolicitacao());
        this.montaProcedimentosSolicitados(ctmSpSadtGuia);
        Ctm_spSadtSolicitacaoGuiaDadosExecutante dadosExecutante = this.montaDadosExecutante();
        ctmSpSadtGuia.setCabecalhoSolicitacao(cabecalhoSolicitacao);
        ctmSpSadtGuia.setDadosBeneficiario(dadosBeneficiario);
        ctmSpSadtGuia.setDadosSolicitante(dadosSolicitante);
        ctmSpSadtGuia.setCaraterAtendimento(caraterAtendimento);
        ctmSpSadtGuia.setDataSolicitacao(dataSolicitacao);
        ctmSpSadtGuia.setDadosExecutante(dadosExecutante);
        ctmSpSadtGuia.setTipoEtapaAutorizacao(tipoEtapaAutorizacao);
        return ctmSpSadtGuia;
    }

    private Ctm_spSadtSolicitacaoGuiaDadosExecutante montaDadosExecutante() {
        String codigoNaOperadora = this.addHash(this.getCodigoPrestadorNaOperadora());
        String cnes = this.addHash(this.getCNES());
        Ctm_spSadtSolicitacaoGuiaDadosExecutante dadosExecutante = new Ctm_spSadtSolicitacaoGuiaDadosExecutante();
        dadosExecutante.setCodigonaOperadora(codigoNaOperadora);
        dadosExecutante.setCNES(cnes);
        return dadosExecutante;
    }

    private void montaProcedimentosSolicitados(Ctm_spSadtSolicitacaoGuia ctmSpSadtGuia) {
        ArrayList<DadosExames> listaExames = this.getListaExames();
        if (listaExames == null || listaExames.isEmpty()) {
            return;
        }
        ctmSpSadtGuia.setProcedimentosSolicitados(new Ctm_spSadtSolicitacaoGuiaProcedimentosSolicitados[listaExames.size()]);
        for (int i = 0; i < listaExames.size(); ++i) {
            String codigoProcedimento = listaExames.get(i).getCodigoAMBTabelaPreco();
            String descricaoProcedimento = listaExames.get(i).getDescricao();
            String qtde = String.valueOf(listaExames.get(i).getQuantidadeExame());
            BigInteger quantidadeSolicitada = new BigInteger(qtde);
            Ct_procedimentoDados procedimento = this.montaProcedimento(this.getCodigoTabela(), codigoProcedimento, descricaoProcedimento);
            this.addHash(qtde);
            Ctm_spSadtSolicitacaoGuiaProcedimentosSolicitados procedimentoSolicitado = new Ctm_spSadtSolicitacaoGuiaProcedimentosSolicitados();
            procedimentoSolicitado.setProcedimento(procedimento);
            procedimentoSolicitado.setQuantidadeSolicitada(quantidadeSolicitada);
            ctmSpSadtGuia.setProcedimentosSolicitados(i, procedimentoSolicitado);
        }
    }

    private Ct_procedimentoDados montaProcedimento(String codigoTabela, String codigoProcedimento, String descricaoProcedimento) {
        Ct_procedimentoDados dadosProcedimentos = new Ct_procedimentoDados();
        dadosProcedimentos.setCodigoTabela(this.addHash(codigoTabela));
        dadosProcedimentos.setCodigoProcedimento(this.addHash(StringUtil.limpaString(codigoProcedimento, new String[]{".", "-"})));
        dadosProcedimentos.setDescricaoProcedimento(this.addHash(descricaoProcedimento));
        return dadosProcedimentos;
    }

    private Ctm_spSadtSolicitacaoGuiaDadosSolicitante montaDadosSolicitante() {
        Ct_contratadoDados contratadoSolicitante = this.montaContratadoSolicitante();
        Ctm_spSadtSolicitacaoGuiaDadosSolicitante dadosSolicitante = new Ctm_spSadtSolicitacaoGuiaDadosSolicitante();
        dadosSolicitante.setContratadoSolicitante(contratadoSolicitante);
        dadosSolicitante.setNomeContratadoSolicitante(this.addHash(this.getNomeContratadoExecutante()));
        Ct_contratadoProfissionalDados profissionalSolicitante = this.montaProfissionalSolicitante();
        dadosSolicitante.setProfissionalSolicitante(profissionalSolicitante);
        return dadosSolicitante;
    }

    private Ct_contratadoProfissionalDados montaProfissionalSolicitante() {
        String nomeProf = this.addHash(this.getNomeProfissional());
        String conselhoProf = this.addHash(this.getConselhoProfissional());
        String numeroConselhoProf = this.addHash(this.getNumeroConselhoProfissional());
        String uf = this.addHash(this.getUF());
        String cBOS = this.addHash(this.getCBOS());
        Ct_contratadoProfissionalDados contratadoProfissional = new Ct_contratadoProfissionalDados();
        contratadoProfissional.setNomeProfissional(nomeProf);
        contratadoProfissional.setConselhoProfissional(conselhoProf);
        contratadoProfissional.setNumeroConselhoProfissional(numeroConselhoProf);
        contratadoProfissional.setUF(uf);
        contratadoProfissional.setCBOS(cBOS);
        return contratadoProfissional;
    }

    private Ct_contratadoDados montaContratadoSolicitante() {
        String codPrestadorNaOperadora = this.addHash(this.getCodigoPrestadorNaOperadora());
        Ct_contratadoDados contatadoDados = new Ct_contratadoDados();
        contatadoDados.setCodigoPrestadorNaOperadora(codPrestadorNaOperadora);
        return contatadoDados;
    }

    private Ct_guiaCabecalho montaCabecalhoSolicitacao() {
        String regANS = this.addHash(this.getRegistroANS());
        String numeroGuiaPrest = this.addHash(this.getNumeroGuiaPrestador());
        Ct_guiaCabecalho cabecalhoGuia = new Ct_guiaCabecalho();
        cabecalhoGuia.setRegistroANS(regANS);
        cabecalhoGuia.setNumeroGuiaPrestador(numeroGuiaPrest);
        return cabecalhoGuia;
    }

    private Ct_beneficiarioDados montaBeneficiarioDados() {
        String numCarteira = this.addHash(this.getNumeroCarteira());
        this.addHash(Dm_simNao.N.toString());
        Dm_simNao atendimentoRN = Dm_simNao.N;
        Ct_beneficiarioDados beneficiario = new Ct_beneficiarioDados();
        beneficiario.setNumeroCarteira(numCarteira);
        beneficiario.setAtendimentoRN(atendimentoRN);
        return beneficiario;
    }

    private SolicitacaoProcedimentoWS montaMensagemCompleta() throws NoSuchAlgorithmException, DatatypeConfigurationException {
        CabecalhoTransacao cabecalho = this.montaCabecalhoTransacao();
        Ct_solicitacaoProcedimento solicitacaoProcedimento = this.montaSolicitacaoProcedimento();
        SolicitacaoProcedimentoWS solicitaProcedimentoWS = new SolicitacaoProcedimentoWS();
        solicitaProcedimentoWS.setCabecalho(cabecalho);
        solicitaProcedimentoWS.setSolicitacaoProcedimento(solicitacaoProcedimento);
        solicitaProcedimentoWS.setHash(this.calculaHash());
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        return solicitaProcedimentoWS;
    }

    public AutorizacaoProcedimentoWS enviarSolicitacao() throws Exception {
        TissSolicitacaoProcedimentoLocator proxy = new TissSolicitacaoProcedimentoLocator();
        TissSolicitacaoProcedimento_PortType port = proxy.gettissSolicitacaoProcedimento_Port();
        return port.tissSolicitacaoProcedimento_Operation(this.montaMensagemCompleta());
    }

    private XMLGregorianCalendar converterDataEmXMLGregorianCalendar(String data) throws DatatypeConfigurationException {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = df.parse(data);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            XMLGregorianCalendar xmlDate3 = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(10), cal.get(12), cal.get(13), Integer.MIN_VALUE, Integer.MIN_VALUE);
            return xmlDate3;
        }
        catch (ParseException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    public String getPadrao() {
        return this.padrao;
    }

    public void setPadrao(String padrao) {
        this.padrao = padrao;
    }

    public String getSequencialTransacao() {
        return this.sequencialTransacao;
    }

    public void setSequencialTransacao(String sequencialTransacao) {
        this.sequencialTransacao = sequencialTransacao;
    }

    public String getDataRegistroTransacao() {
        return this.dataRegistroTransacao;
    }

    public void setDataRegistroTransacao(String dataRegistroTransacao) {
        this.dataRegistroTransacao = dataRegistroTransacao;
    }

    public String getHoraRegistroTransacao() {
        return this.horaRegistroTransacao;
    }

    public void setHoraRegistroTransacao(String horaRegistroTransacao) {
        this.horaRegistroTransacao = horaRegistroTransacao;
    }

    public String getCodigoPrestadorNaOperadora() {
        return this.codigoPrestadorNaOperadora;
    }

    public void setCodigoPrestadorNaOperadora(String codigoPrestadorNaOperadora) {
        this.codigoPrestadorNaOperadora = codigoPrestadorNaOperadora;
    }

    public String getRegistroANS() {
        return this.registroANS;
    }

    public void setRegistroANS(String registroANS) {
        this.registroANS = registroANS;
    }

    public String getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    public void setDataSolicitacao(String dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    public String getCodigoNaOperadora() {
        return this.codigoNaOperadora;
    }

    public void setCodigoNaOperadora(String codigoNaOperadora) {
        this.codigoNaOperadora = codigoNaOperadora;
    }

    public String getCNES() {
        return this.cnes;
    }

    public void setCNES(String CNES) {
        this.cnes = CNES;
    }

    public String getNomeContratado() {
        return this.nomeContratado;
    }

    public void setNomeContratado(String nomeContratado) {
        this.nomeContratado = nomeContratado;
    }

    public ArrayList<DadosExames> getListaExames() {
        return this.listaExames;
    }

    public void setListaExames(ArrayList<DadosExames> listaExames) {
        this.listaExames = listaExames;
    }

    public String getCodigoTabela() {
        return this.codigoTabela;
    }

    public void setCodigoTabela(String codigoTabela) {
        this.codigoTabela = codigoTabela;
    }

    public String getNomeProfissional() {
        return this.nomeProfissional;
    }

    public void setNomeProfissional(String nomeProfissional) {
        this.nomeProfissional = nomeProfissional;
    }

    public String getConselhoProfissional() {
        return this.conselhoProfissional;
    }

    public void setConselhoProfissional(String conselhoProfissional) {
        this.conselhoProfissional = conselhoProfissional;
    }

    public String getNumeroConselhoProfissional() {
        return this.numeroConselhoProfissional;
    }

    public void setNumeroConselhoProfissional(String numeroConselhoProfissional) {
        this.numeroConselhoProfissional = numeroConselhoProfissional;
    }

    public String getUF() {
        return this.uf;
    }

    public void setUF(String UF) {
        this.uf = UF;
    }

    public String getCBOS() {
        return this.cbos;
    }

    public void setCBOS(String CBOS2) {
        this.cbos = CBOS2;
    }

    public String getNumeroGuiaPrestador() {
        return this.numeroGuiaPrestador;
    }

    public void setNumeroGuiaPrestador(String numeroGuiaPrestador) {
        this.numeroGuiaPrestador = numeroGuiaPrestador;
    }

    public String getNumeroCarteira() {
        return this.numeroCarteira;
    }

    public void setNumeroCarteira(String numeroCarteira) {
        this.numeroCarteira = numeroCarteira;
    }

    public String getNomeBeneficiario() {
        return this.nomeBeneficiario;
    }

    public void setNomeBeneficiario(String nomeBeneficiario) {
        this.nomeBeneficiario = nomeBeneficiario;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getNomeContratadoExecutante() {
        return this.nomeContratadoExecutante;
    }

    public void setNomeContratadoExecutante(String nomeContratadoExecutante) {
        this.nomeContratadoExecutante = nomeContratadoExecutante;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public Boolean isRecemNascido() {
        return this.recemNascido;
    }

    public void setRecemNascido(Boolean recemNascido) {
        this.recemNascido = recemNascido;
    }

    public String getIndicacaoClinica() {
        return this.indicacaoClinica;
    }

    public void setIndicacaoClinica(String indicacaoClinica) {
        this.indicacaoClinica = indicacaoClinica;
    }
}

