/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import br.gov.ans.www.padroes.tiss.schemas.Dm_simNao;
import br.gov.ans.www.padroes.tiss.schemas.Dm_tipoTransacao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.TissWS;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class SolicitaStatusAutorizacaoSguCard
extends TissWS {
    private static final String CARATER_ATENDIMENTO = "1";
    private static final String TAG_BODY = "SOAP-ENV:Body";
    private static final String TAG_CABECALHO = "ns3:cabecalho";
    private static final String TAG_IDENTIFICACAO_TRANSACAO = "ns3:identificacaoTransacao";
    private static final String TAG_TIPO_TRANSACAO = "ns3:tipoTransacao";
    private static final String TAG_SEQUENCIAL_TRANSACAO = "ns3:sequencialTransacao";
    private static final String TAG_DATA_REGISTRO_TRANSACAO = "ns3:dataRegistroTransacao";
    private static final String TAG_HORA_REGISTRO_TRANSACAO = "ns3:horaRegistroTransacao";
    private static final String TAG_ORIGEM = "ns3:origem";
    private static final String TAG_IDENTIFICACAO_PRESTADOR = "ns3:identificacaoPrestador";
    private static final String TAG_CODIGO_PRESTADOR_NA_OPERADORA = "ns3:codigoPrestadorNaOperadora";
    private static final String TAG_DESTINO = "ns3:destino";
    private static final String TAG_REGISTRO_ANS = "ns3:registroANS";
    private static final String TAG_PADRAO = "ns3:Padrao";
    private static final String TAG_LOGIN_SENHA_PRESTADOR = "ns3:loginSenhaPrestador";
    private static final String TAG_LOGIN_PRESTADOR = "ns3:loginPrestador";
    private static final String TAG_SENHA_PRESTADOR = "ns3:senhaPrestador";
    private static final String TAG_NUMERO_GUIA_PRESTADOR = "ns3:numeroGuiaPrestador";
    private static final String TAG_DADOS_BENEFICIARIO = "ns3:dadosBeneficiario";
    private static final String TAG_NUMERO_CARTEIRA = "ns3:numeroCarteira";
    private static final String TAG_ATENDIMENTO_RN = "ns3:atendimentoRN";
    private static final String TAG_NOME_BENEFICIARIO = "ns3:nomeBeneficiario";
    private static final String TAG_DADOS_SOLICITANTE = "ns3:dadosSolicitante";
    private static final String TAG_CONTRATADO_SOLICITANTE = "ns3:contratadoSolicitante";
    private static final String TAG_NOME_CONTRATADO = "ns3:nomeContratado";
    private static final String TAG_CODIGO_NA_OPERAORA = "ns3:codigonaOperadora";
    private static final String TAG_HASH = "ns3:hash";
    private static final String TAG_CNPJ = "ns3:CNPJ";
    private static final String TAG_SOLICITACAO_STATUS_AUTORIZACAO = "ns3:solicitacaoStatusAutorizacao";
    private static final String TAG_IDENTIFICACAO_SOLICITACAO = "ns3:identificacaoSolicitacao";
    private static final String TAG_DADOS_CONTRATADO = "ns3:dadosContratado";
    private static final String TAG_SITUACAO_AUTORIZACAO = "ns3:situacaoAutorizacao";
    private static final String TAG_AUTORIZACAO_INTERNACAO = "ns3:autorizacaoInternacao";
    private static final String TAG_AUTORIZACAO_SERVICOS = "ns3:autorizacaoDosServicos";
    private static final String TAG_DADOS_AUTORIZACAO = "ns3:dadosAutorizacao";
    private static final String TAG_NUMERO_GUIA_OPERADORA = "ns3:numeroGuiaOperadora";
    private static final String TAG_DATA_AUTORIZACAO = "ns3:dataAutorizacao";
    private static final String TAG_SENHA = "ns3:senha";
    private static final String TAG_DATA_VALIDADE_SENHA = "ns3:dataValidadeSenha";
    private static final String TAG_STATUS_SOLICITACAO = "ns3:statusSolicitacao";
    private static final String TAG_SERVICOS_AUTORIZADOS = "ns3:servicosAutorizados";
    private static final String TAG_SERVICO_AUTORIZADO = "ns3:servicoAutorizado";
    private static final String TAG_PROCEDIMENTO = "ns3:procedimento";
    private static final String TAG_CODIGO_TABELA = "ns3:codigoTabela";
    private static final String TAG_CODIGO_PROCEDIMENTO = "ns3:codigoProcedimento";
    private static final String TAG_DESCRICAO_PROCEDIMENTO = "ns3:descricaoProcedimento";
    private static final String TAG_QUANTIDADE_SOLICITADA = "ns3:quantidadeSolicitada";
    private static final String TAG_QUANTIDADE_AUTORIZADA = "ns3:quantidadeAutorizada";
    private static final String TAG_VALOR_SOLICITADO = "ns3:valorSolicitado";
    private static final String TAG_MOTIVOS_NEGATIVA = "ns3:motivosNegativa";
    private static final String TAG_MOTIVO_NEGATIVA = "ns3:motivoNegativa";
    private static final String TAG_CODIGO_GLOSA = "ns3:codigoGlosa";
    private static final String TAG_DESCRICAO_GLOSA = "ns3:descricaoGlosa";
    private static final String TAG_MENSAGEM_ERRO = "ns3:mensagemErro";
    private String padrao = null;
    private String sequencialTransacao = null;
    private String dataRegistroTransacao = null;
    private String horaRegistroTransacao = null;
    private String codigoPrestadorNaOperadora = null;
    private String registroANS = null;
    private String codigoNaOperadora = null;
    private String nomeContratado = null;
    private String numeroGuiaPrestador = null;
    private String numeroCarteira = null;
    private String nomeBeneficiario = null;
    private String address = null;
    private String login = "";
    private String senha = "";
    private String cnpj = "";
    private Boolean recemNascido;

    public String enviarSolicitacaoStatusAutorizacaoXML() throws Exception {
        String requestSoap = this.getXMLAutorizacao();
        SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection soapConnection = soapConnectionFactory.createConnection();
        String url = this.getAddress();
        MimeHeaders headers = new MimeHeaders();
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage msg = messageFactory.createMessage(headers, (InputStream)new ByteArrayInputStream(requestSoap.getBytes()));
        try {
            SOAPMessage soapResponse = soapConnection.call(msg, (Object)url);
            Document xmlRespostaARequisicao = soapResponse.getSOAPBody().getOwnerDocument();
            return SolicitaStatusAutorizacaoSguCard.converteXMLParaString(xmlRespostaARequisicao, 0);
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter conex\u00e3o com a operadora.", 1);
            return "";
        }
    }

    public static String converteXMLParaString(Document xml, int espacosIdentacao) {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            transfac.setAttribute("indent-number", new Integer(espacosIdentacao));
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(xml);
            trans.transform(source, result);
            String xmlString = sw.toString();
            return xmlString;
        }
        catch (TransformerException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    private String getXMLAutorizacao() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.escrever("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\">");
            xml.escrever("<SOAP-ENV:Header/>");
            xml.abrir(SolicitaStatusAutorizacaoSguCard.getTagBody());
            xml.escrever("<ns3:solicitacaoStatusAutorizacaoWS xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:ns3=\"http://www.ans.gov.br/padroes/tiss/schemas\">");
            this.montaCabecalhoSolicitacaoStatusAutorizacao(xml);
            this.montaSolicitacaoStatusAutorizacao(xml);
            xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagHash(), this.calculaHash());
            xml.escrever("</ns3:solicitacaoStatusAutorizacaoWS>");
            xml.fechar(SolicitaStatusAutorizacaoSguCard.getTagBody());
            xml.escrever("</SOAP-ENV:Envelope>");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return xml.getXML();
    }

    public XMLStringBuilder montaCabecalhoSolicitacaoStatusAutorizacao(XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(SolicitaStatusAutorizacaoSguCard.getTagCabecalho());
        xml.abrir(SolicitaStatusAutorizacaoSguCard.getTagIdentificacaoTransacao());
        xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagTipoTransacao(), Dm_tipoTransacao.SOLICITA_STATUS_AUTORIZACAO.toString());
        xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagSequencialTransacao(), this.getSequencialTransacao());
        xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagDataRegistroTransacao(), this.getDataRegistroTransacao());
        xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagHoraRegistroTransacao(), this.getHoraRegistroTransacao());
        xml.fechar(SolicitaStatusAutorizacaoSguCard.getTagIdentificacaoTransacao());
        xml.abrir(SolicitaStatusAutorizacaoSguCard.getTagOrigem());
        xml.abrir(SolicitaStatusAutorizacaoSguCard.getTagIdentificacaoPrestador());
        xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagCodigoPrestadorNaOperadora(), this.getCodigoPrestadorNaOperadora());
        xml.fechar(SolicitaStatusAutorizacaoSguCard.getTagIdentificacaoPrestador());
        xml.fechar(SolicitaStatusAutorizacaoSguCard.getTagOrigem());
        xml.abrir(SolicitaStatusAutorizacaoSguCard.getTagDestino());
        xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagRegistroAns(), this.getRegistroANS());
        xml.fechar(SolicitaStatusAutorizacaoSguCard.getTagDestino());
        xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagPadrao(), this.getPadrao());
        xml.abrir(SolicitaStatusAutorizacaoSguCard.getTagLoginSenhaPrestador());
        xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagLoginPrestador(), this.getLogin());
        xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagSenhaPrestador(), this.getSenha());
        xml.fechar(SolicitaStatusAutorizacaoSguCard.getTagLoginSenhaPrestador());
        xml.fechar(SolicitaStatusAutorizacaoSguCard.getTagCabecalho());
        return xml;
    }

    private XMLStringBuilder montaSolicitacaoStatusAutorizacao(XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(SolicitaStatusAutorizacaoSguCard.getTagSolicitacaoStatusAutorizacao());
        xml.abrir(SolicitaStatusAutorizacaoSguCard.getTagIdentificacaoSolicitacao());
        xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagRegistroAns(), this.getRegistroANS());
        xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagNumeroGuiaPrestador(), this.getNumeroGuiaPrestador());
        xml.fechar(SolicitaStatusAutorizacaoSguCard.getTagIdentificacaoSolicitacao());
        xml.abrir(SolicitaStatusAutorizacaoSguCard.getTagDadosBeneficiario());
        xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagNumeroCarteira(), this.getNumeroCarteira());
        xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagAtendimentoRn(), this.isRecemNascido() != false ? Dm_simNao.S.toString() : Dm_simNao.N.toString());
        xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagNomeBeneficiario(), this.getNomeBeneficiario());
        xml.fechar(SolicitaStatusAutorizacaoSguCard.getTagDadosBeneficiario());
        xml.abrir(SolicitaStatusAutorizacaoSguCard.getTagDadosContratado());
        xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagCodigoPrestadorNaOperadora(), this.getCodigoPrestadorNaOperadora());
        xml.escrever(SolicitaStatusAutorizacaoSguCard.getTagNomeContratado(), this.getNomeContratado());
        xml.fechar(SolicitaStatusAutorizacaoSguCard.getTagDadosContratado());
        xml.fechar(SolicitaStatusAutorizacaoSguCard.getTagSolicitacaoStatusAutorizacao());
        return xml;
    }

    public String getPadrao() {
        return this.padrao;
    }

    public void setPadrao(String padrao) {
        this.padrao = padrao;
    }

    public String getSequencialTransacao() {
        return this.sequencialTransacao;
    }

    public void setSequencialTransacao(String sequencialTransacao) {
        this.sequencialTransacao = sequencialTransacao;
    }

    public String getDataRegistroTransacao() {
        return this.dataRegistroTransacao;
    }

    public void setDataRegistroTransacao(String dataRegistroTransacao) {
        this.dataRegistroTransacao = dataRegistroTransacao;
    }

    public String getHoraRegistroTransacao() {
        return this.horaRegistroTransacao;
    }

    public void setHoraRegistroTransacao(String horaRegistroTransacao) {
        this.horaRegistroTransacao = horaRegistroTransacao;
    }

    public String getCodigoPrestadorNaOperadora() {
        return this.codigoPrestadorNaOperadora;
    }

    public void setCodigoPrestadorNaOperadora(String codigoPrestadorNaOperadora) {
        this.codigoPrestadorNaOperadora = codigoPrestadorNaOperadora;
    }

    public String getRegistroANS() {
        return this.registroANS;
    }

    public void setRegistroANS(String registroANS) {
        this.registroANS = registroANS;
    }

    public String getCodigoNaOperadora() {
        return this.codigoNaOperadora;
    }

    public void setCodigoNaOperadora(String codigoNaOperadora) {
        this.codigoNaOperadora = codigoNaOperadora;
    }

    public String getNomeContratado() {
        return this.nomeContratado;
    }

    public void setNomeContratado(String nomeContratado) {
        this.nomeContratado = nomeContratado;
    }

    public String getNumeroGuiaPrestador() {
        return this.numeroGuiaPrestador;
    }

    public void setNumeroGuiaPrestador(String numeroGuiaPrestador) {
        this.numeroGuiaPrestador = numeroGuiaPrestador;
    }

    public String getNumeroCarteira() {
        return this.numeroCarteira;
    }

    public void setNumeroCarteira(String numeroCarteira) {
        this.numeroCarteira = numeroCarteira;
    }

    public String getNomeBeneficiario() {
        return this.nomeBeneficiario;
    }

    public void setNomeBeneficiario(String nomeBeneficiario) {
        this.nomeBeneficiario = nomeBeneficiario;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public Boolean isRecemNascido() {
        return this.recemNascido;
    }

    public void setRecemNascido(Boolean recemNascido) {
        this.recemNascido = recemNascido;
    }

    public static String getTagBody() {
        return TAG_BODY;
    }

    public static String getTagCabecalho() {
        return TAG_CABECALHO;
    }

    public static String getTagIdentificacaoTransacao() {
        return TAG_IDENTIFICACAO_TRANSACAO;
    }

    public static String getTagTipoTransacao() {
        return TAG_TIPO_TRANSACAO;
    }

    public static String getTagSequencialTransacao() {
        return TAG_SEQUENCIAL_TRANSACAO;
    }

    public static String getTagDataRegistroTransacao() {
        return TAG_DATA_REGISTRO_TRANSACAO;
    }

    public static String getTagHoraRegistroTransacao() {
        return TAG_HORA_REGISTRO_TRANSACAO;
    }

    public static String getTagOrigem() {
        return TAG_ORIGEM;
    }

    public static String getTagIdentificacaoPrestador() {
        return TAG_IDENTIFICACAO_PRESTADOR;
    }

    public static String getTagCodigoPrestadorNaOperadora() {
        return TAG_CODIGO_PRESTADOR_NA_OPERADORA;
    }

    public static String getTagDestino() {
        return TAG_DESTINO;
    }

    public static String getTagRegistroAns() {
        return TAG_REGISTRO_ANS;
    }

    public static String getTagPadrao() {
        return TAG_PADRAO;
    }

    public static String getTagLoginSenhaPrestador() {
        return TAG_LOGIN_SENHA_PRESTADOR;
    }

    public static String getTagLoginPrestador() {
        return TAG_LOGIN_PRESTADOR;
    }

    public static String getTagSenhaPrestador() {
        return TAG_SENHA_PRESTADOR;
    }

    public static String getTagNumeroGuiaPrestador() {
        return TAG_NUMERO_GUIA_PRESTADOR;
    }

    public static String getTagDadosBeneficiario() {
        return TAG_DADOS_BENEFICIARIO;
    }

    public static String getTagNumeroCarteira() {
        return TAG_NUMERO_CARTEIRA;
    }

    public static String getTagAtendimentoRn() {
        return TAG_ATENDIMENTO_RN;
    }

    public static String getTagNomeBeneficiario() {
        return TAG_NOME_BENEFICIARIO;
    }

    public static String getTagDadosSolicitante() {
        return TAG_DADOS_SOLICITANTE;
    }

    public static String getTagContratadoSolicitante() {
        return TAG_CONTRATADO_SOLICITANTE;
    }

    public static String getTagNomeContratado() {
        return TAG_NOME_CONTRATADO;
    }

    public static String getTagCodigoNaOperaora() {
        return TAG_CODIGO_NA_OPERAORA;
    }

    public static String getTagHash() {
        return TAG_HASH;
    }

    public static String getTagCnpj() {
        return TAG_CNPJ;
    }

    public static String getTagSolicitacaoStatusAutorizacao() {
        return TAG_SOLICITACAO_STATUS_AUTORIZACAO;
    }

    public static String getTagIdentificacaoSolicitacao() {
        return TAG_IDENTIFICACAO_SOLICITACAO;
    }

    public static String getTagDadosContratado() {
        return TAG_DADOS_CONTRATADO;
    }

    public static String getTagSituacaoAutorizacao() {
        return TAG_SITUACAO_AUTORIZACAO;
    }

    public static String getTagAutorizacaoInternacao() {
        return TAG_AUTORIZACAO_INTERNACAO;
    }

    public static String getTagAutorizacaoServicos() {
        return TAG_AUTORIZACAO_SERVICOS;
    }

    public static String getTagDadosAutorizacao() {
        return TAG_DADOS_AUTORIZACAO;
    }

    public static String getTagNumeroGuiaOperadora() {
        return TAG_NUMERO_GUIA_OPERADORA;
    }

    public static String getTagDataAutorizacao() {
        return TAG_DATA_AUTORIZACAO;
    }

    public static String getTagSenha() {
        return TAG_SENHA;
    }

    public static String getTagDataValidadeSenha() {
        return TAG_DATA_VALIDADE_SENHA;
    }

    public static String getTagStatusSolicitacao() {
        return TAG_STATUS_SOLICITACAO;
    }

    public static String getTagServicosAutorizados() {
        return TAG_SERVICOS_AUTORIZADOS;
    }

    public static String getTagServicoAutorizado() {
        return TAG_SERVICO_AUTORIZADO;
    }

    public static String getTagProcedimento() {
        return TAG_PROCEDIMENTO;
    }

    public static String getTagCodigoTabela() {
        return TAG_CODIGO_TABELA;
    }

    public static String getTagCodigoProcedimento() {
        return TAG_CODIGO_PROCEDIMENTO;
    }

    public static String getTagDescricaoProcedimento() {
        return TAG_DESCRICAO_PROCEDIMENTO;
    }

    public static String getTagQuantidadeSolicitada() {
        return TAG_QUANTIDADE_SOLICITADA;
    }

    public static String getTagQuantidadeAutorizada() {
        return TAG_QUANTIDADE_AUTORIZADA;
    }

    public static String getTagValorSolicitado() {
        return TAG_VALOR_SOLICITADO;
    }

    public static String getTagMotivosNegativa() {
        return TAG_MOTIVOS_NEGATIVA;
    }

    public static String getTagMotivoNegativa() {
        return TAG_MOTIVO_NEGATIVA;
    }

    public static String getTagCodigoGlosa() {
        return TAG_CODIGO_GLOSA;
    }

    public static String getTagDescricaoGlosa() {
        return TAG_DESCRICAO_GLOSA;
    }

    public static String getTagMensagemErro() {
        return TAG_MENSAGEM_ERRO;
    }
}

