/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ArquivoFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.GuiaVirtual;
import jalis.laboratorio.util.faturamento.eletronico.JanelaConfiguracaoFaturamentoBPA;
import jalis.util.Funcoes;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.excel.EscreverArquivoXls;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class SantaCasaMiguelopolis
extends AbstractFaturamentoEletronico
implements FaturamentoEletronico {
    @Override
    public void verificaErrosFatura(ArrayList<DadosFaturamento> requisicoes, Registro configuracaoConvenio) {
    }

    @Override
    public ArrayList<GuiaVirtual.Campo> getCamposObrigatorios(String versao) {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasSolicitados() {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasExecutados() {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampo> getCamposIncorretos(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampoBPA> getCamposIncorretosBPA(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<JanelaConfiguracaoFaturamentoBPA.CampoBPA> getCamposObrigatoriosBPA() {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasSolicitados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasExecutados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public Registro parseXMLConfiguracao(String xml) {
        return null;
    }

    @Override
    public boolean gravaAlteracoes(DadosFaturamento requisicao, String guia, Registro configuracao) {
        return false;
    }

    @Override
    public void preencheValoresCampos(DadosFaturamento requisicao, Registro configuracaoEletronico, String guia) {
    }

    @Override
    public void preencheValoresTabelas(DadosFaturamento requisicao, String guia) {
    }

    @Override
    public void getValoresPreenchidos(DadosFaturamento requisicao, ArrayList<DadosExameFaturamento> exames, Registro configuracaoEletronico) {
    }

    @Override
    public void aplicarModificacoesGerais(ArrayList<DadosFaturamento> requisicoes, DadosFaturamento requisicao, DadosFaturamento requisicaoModificada, Registro configuracaoEletronico, Registro configuracaoEletronicoModificada) {
    }

    @Override
    public Object[] getListaDadosAdicionais() {
        return null;
    }

    @Override
    public void setListaDadosAdicionais(Object[] listaDadosAdicionais) {
    }

    @Override
    public ArrayList<ArquivoFaturamentoEletronico> criarArquivo(Object owner, int codigoFatura, String codigoConvenio, String diretorioArquivos) {
        String nomeArquivo = this.exportarPlanilha(codigoFatura, codigoConvenio);
        ArrayList<ArquivoFaturamentoEletronico> arquivo = new ArrayList<ArquivoFaturamentoEletronico>();
        arquivo.add(new ArquivoFaturamentoEletronico(nomeArquivo, ""));
        return arquivo;
    }

    private String getNomeArquivo(String codigoFilial, int codigoFatura) {
        String nome = "";
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        sql.append("select fat_dtinicio as dataInicioFat,");
        sql.append(" fat_dtfim as dataFimFat");
        sql.append(" from fatura fat");
        sql.append(" where fil_codigo = ").append(codigoFilial);
        sql.append(" and fat_codigo = ").append(codigoFatura);
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                String dataInicialFat = Funcoes.formataData("ddMMyyyy", rs.getDate("dataInicioFat"));
                String dataFinalFat = Funcoes.formataData("ddMMyyyy", rs.getDate("dataFimFat"));
                nome = "santacasa_" + dataInicialFat + "-" + dataFinalFat;
            }
            rs.close();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return nome;
    }

    private String exportarPlanilha(int codigoFatura, String codigoConvenio) {
        JFileChooser chooser = new JFileChooser();
        String extensaoXLS = "Arquivo de Faturamento (.xls)";
        String extensaoXLSX = "Arquivo de Faturamento (.xlsx)";
        String nomeArquivo = "";
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter(extensaoXLSX, "xlsx"));
        chooser.setFileFilter(ComponenteFactory.novoFileFilter(extensaoXLS, "xls"));
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(new File(this.getNomeArquivo(Variaveis.filialPadrao, codigoFatura)));
        if (chooser.showSaveDialog(chooser) == 0) {
            String extensao = chooser.getFileFilter().getDescription().equals(extensaoXLS) ? ".xls" : ".xlsx";
            nomeArquivo = chooser.getSelectedFile().getAbsolutePath() + extensao;
            EscreverArquivoXls xls = new EscreverArquivoXls();
            try {
                int plan = xls.addAba("Planilha 1");
                int linha = 0;
                Statement st = Conexao.getStatement();
                List<Registro> retornoSQL = this.pegaDadosFatura(st, Variaveis.filialPadrao, codigoFatura);
                if (!retornoSQL.isEmpty()) {
                    Object[] cabecalho = new Object[]{"Codigo Paciente", "Nome Paciente", "Sexo", "Data de Nascimento", "Cartao SUS", "Codigo Procedimento", "Descricao Procedimento", "Valor Exame", "Data Coleta", "Hora Coleta", "Crm do medico", "Nome do Medico"};
                    xls.setLinha(plan, linha++, cabecalho);
                    for (Registro reg : retornoSQL) {
                        String cartaoSUS = Funcoes.textoVazio(reg.getString("cartaosuspac")) ? reg.getString("cartaosusreq") : reg.getString("cartaosuspac");
                        String dataColeta = Funcoes.formataData(reg.getDate("dataprocedimento"));
                        String horaColeta = Funcoes.formataHora(reg.getDate("dataprocedimento"), false);
                        Object[] cel = new Object[]{reg.getValor("codigopaciente"), reg.getValor("nomepaciente"), reg.getValor("sexopaciente"), reg.getValor("dataaniversariopaciente"), cartaoSUS, reg.getValor("codamb"), reg.getValor("descricaoprocedimento"), Funcoes.formataDecimal(Double.valueOf(reg.getString("valortotal"))), dataColeta, horaColeta, reg.getValor("crmmedico"), reg.getValor("nomemedico")};
                        xls.setLinha(plan, linha++, cel);
                    }
                    xls.escreverArquivo(nomeArquivo);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
        return nomeArquivo;
    }

    private List<Registro> pegaDadosFatura(Statement st, String filial, int codigoFatura) throws SQLException {
        ArrayList<Registro> retornoRs = new ArrayList<Registro>();
        boolean isPrecoMetodologia = ParametrosGerais.getPrecoMetodologia();
        StringBuilder sql = new StringBuilder();
        sql.append(" select p.pac_codigo as codigoPaciente,");
        sql.append(" \tp.pac_nome as nomePaciente,");
        sql.append(" case ");
        sql.append(" when p.pac_sexo = 'F' then 'Feminino' ");
        sql.append(" else 'Masculino'\t");
        sql.append(" end as sexoPaciente, ");
        sql.append(" to_char(p.pac_datanasc, 'DD/MM/YYYY')  as dataAniversarioPaciente,\t");
        sql.append(" \tp.pac_cartaosus as cartaoSUSpac,");
        sql.append(" \tcoalesce(r.req_cartaosus, '') as cartaoSUSreq,");
        sql.append(isPrecoMetodologia ? " \tc.dtm_codamb as codAMB," : " \tc.dtp_codamb as codAMB,");
        sql.append(" \tb.exa_descricao as descricaoProcedimento,");
        sql.append(" \tcoalesce(a.fer_total, 0) as valorTotal,");
        sql.append(" \td.exr_datamaterial as dataProcedimento,");
        sql.append(" \tm.med_crm as crmMedico,");
        sql.append(" \tm.med_nome as nomeMedico,");
        sql.append(" \tcoalesce(a.fer_totalmateriais, 0) as valorTotalMaterial,");
        sql.append("\tfat.fat_dtinicio as dataInicioFat, fat.fat_dtfim as dataInicioFat");
        sql.append(" from faturaexamerequisicao a");
        sql.append(" inner join fatura fat on a.fil_codigo = fat.fil_codigo");
        sql.append(" \tand a.fat_codigo = fat.fat_codigo");
        sql.append(" inner join exames b on a.fil_kodigo = b.fil_codigo");
        sql.append(" \tand a.exa_codfilho = b.exa_codigo");
        sql.append(" inner join examerequisicao d on a.fil_kodigo = d.fil_codigo");
        sql.append(" \tand a.req_codigo = d.req_codigo");
        sql.append(" \tand a.exa_codigo = d.exa_codigo");
        sql.append(" \tand a.mco_codigo = d.mco_codigo");
        sql.append(" inner join requisicao r on a.fil_codigo = r.fil_codigo");
        sql.append(" \tand a.req_codigo = r.req_codigo");
        sql.append(" inner join convenios con on r.fil_codigo = con.fil_codigo");
        sql.append(" \tand r.con_codigo = con.con_codigo");
        if (isPrecoMetodologia) {
            sql.append(" inner join detalhetabelaprecometodologia c on a.fil_kodigo = c.fil_codigo");
            sql.append(" \tand a.exa_codfilho = c.exa_codigo");
            sql.append(" \tand a.mco_codfilho = c.mco_codigo");
            sql.append(" \tand d.met_codigo = c.met_codigo");
            sql.append(" \tand con.tpe_codigo = c.tpe_codigo");
        } else {
            sql.append(" inner join detalhetabelapreco c on a.fil_kodigo = c.fil_codigo ");
            sql.append(" and a.exa_codfilho = c.exa_codigo ");
            sql.append(" and a.mco_codfilho = c.mco_codigo ");
            sql.append(" and con.tpe_codigo = c.tpe_codigo");
        }
        sql.append(" inner join paciente p on r.pac_codigo = p.pac_codigo");
        sql.append(" \tand r.fil_codigo = p.fil_codigo");
        sql.append(" inner join medico m on r.med_crm = m.med_crm");
        sql.append(" \tand r.med_uf = m.med_uf");
        sql.append(" \tand r.med_conselho = m.med_conselho");
        sql.append(" \tand r.fil_codigo = m.fil_codigo");
        sql.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" \tand a.fil_kodigo = ").append(filial);
        sql.append(" \tand a.fat_codigo = ").append(codigoFatura);
        sql.append(" \tand fat.fat_datacancelamento is null");
        sql.append(" \tand d.exr_excluido = false");
        sql.append(" group by a.exa_codigo, b.exa_descricao,");
        sql.append(isPrecoMetodologia ? " c.dtm_codamb," : " c.dtp_codamb,");
        sql.append(" \tp.pac_codigo, p.pac_nome, p.pac_sexo, p.pac_datanasc, p.pac_cartaosus, r.req_cartaosus, d.exr_datamaterial,");
        sql.append(" \tm.med_crm, m.med_nome, r.req_codigo, r.fil_codigo, a.fer_total, a.fer_totalmateriais, fat.fat_dtinicio, fat.fat_dtfim");
        sql.append(" \torder by cartaoSUSreq, r.pac_codigo");
        ResultSet rs = st.executeQuery(sql.toString());
        while (rs.next()) {
            retornoRs.add(new Registro(rs));
        }
        rs.close();
        return retornoRs;
    }

    public static String getNomeProtocolo() {
        return "Santa Casa Miguel\u00f3polis";
    }

    @Override
    public String configurar(JFrame parent, String xml) {
        return this.criaXML();
    }

    private String criaXML() {
        StringBuilder buf = new StringBuilder("<faturamentoEletronico>");
        buf.append("<protocolo>").append(SantaCasaMiguelopolis.getNomeProtocolo()).append("</protocolo>");
        buf.append("</faturamentoEletronico>");
        return buf.toString();
    }

    @Override
    public boolean solicitarDiretorioNoInicio() {
        return false;
    }

    @Override
    public String[] situacoesPermitidasExame(String xml) {
        return null;
    }

    @Override
    public boolean validarCasasDecimais() {
        return true;
    }

    @Override
    public String getCodificacaoArquivo() {
        return null;
    }
}

