/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ArquivoFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ConfigurarSUSPelotas;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.GuiaVirtual;
import jalis.laboratorio.util.faturamento.eletronico.JanelaConfiguracaoFaturamentoBPA;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JFrame;

public class SUSPelotas
extends AbstractFaturamentoEletronico
implements FaturamentoEletronico {
    @Override
    public String configurar(JFrame parent, String xml) {
        String retorno = xml;
        ConfigurarSUSPelotas conf = new ConfigurarSUSPelotas(parent);
        conf.setXML(this.parseDadosXML(xml));
        conf.setVisible(true);
        if (conf.ok()) {
            Registro r = new Registro();
            r.setValor("conselhoExecutante", conf.getConselhoExecutante());
            r.setValor("cboExecutante", conf.getCBOExecutante());
            retorno = this.criaXML(r);
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<ArquivoFaturamentoEletronico> criarArquivo(Object owner, int codigoFatura, String codigoConvenio, String diretorioArquivos) {
        ArrayList<ArquivoFaturamentoEletronico> arquivo;
        Statement st2;
        Statement st;
        block17: {
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            arquivo = null;
            try {
                StringBuilder buf = new StringBuilder();
                StringBuilder linhasArquivo = new StringBuilder();
                Registro regConvenio = null;
                buf.setLength(0);
                buf.append("select a.con_codigo, a.con_razao, a.tpe_codigo, a.con_faturaeletronica from convenios a ");
                buf.append("where a.fil_codigo = ");
                buf.append(Variaveis.filialPadrao);
                buf.append(" and a.con_codigo = ");
                buf.append(codigoConvenio);
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (rs.next()) {
                    regConvenio = new Registro(rs);
                }
                Registro regXML = this.parseDadosXML(regConvenio.getString("con_faturaeletronica"));
                buf.setLength(0);
                buf.append("select count(e.exa_codigo) as contagem ");
                buf.append("      ,b.fil_codigo ");
                buf.append("      ,b.req_dtfatura ");
                buf.append("      ,c.pac_nome ");
                buf.append("      ,c.pac_datanasc ");
                buf.append("      ,b.req_data ");
                buf.append("      ,b.med_crm ");
                buf.append("      ,exm.exa_descricao ");
                buf.append("      ,c.pac_codigo ");
                buf.append("      ,c.pac_sexo ");
                buf.append("      ,c.pac_mae ");
                buf.append("      ,c.pac_endereco ");
                buf.append("      ,c.pac_numeroendereco ");
                buf.append("      ,c.pac_fone ");
                buf.append("      ,ba.bai_descricao ");
                buf.append("      ,c.pac_cep ");
                buf.append("      ,c.pac_cpf ");
                buf.append("      ,b.req_matricula ");
                buf.append("      ,b.req_codigo ");
                buf.append("      ,e.fer_ordem ");
                buf.append("      ,exr.exr_datadigita ");
                buf.append("      ,cid.cid_codigoibge ");
                buf.append("      ,fil.fil_cnes ");
                buf.append("      ,b.uns_codigo ");
                if (ParametrosGerais.getPrecoMetodologia()) {
                    buf.append("      ,n.dtm_codamb as dtp_codamb ");
                } else {
                    buf.append("      ,n.dtp_codamb ");
                }
                buf.append("  from faturarequisicao a ");
                buf.append("  left join faturaexamerequisicao e on a.fil_codigo = e.fil_codigo and a.fil_kodigo = e.fil_kodigo and a.fat_codigo = e.fat_codigo and a.req_codigo = e.req_codigo ");
                buf.append("  left join requisicao b on a.fil_kodigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
                buf.append("  left join paciente c on b.fil_codigo = c.fil_codigo and b.pac_codigo = c.pac_codigo ");
                buf.append("  left join fatura fat on a.fil_codigo = fat.fil_codigo and a.fat_codigo = fat.fat_codigo ");
                buf.append("  left join exames exm on e.fil_kodigo = exm.fil_codigo and e.exa_codigo = exm.exa_codigo ");
                buf.append("  left join convenios con on b.fil_codigo = con.fil_codigo and b.con_codigo = con.con_codigo ");
                buf.append("  left join bairro ba on c.fil_codigo = ba.fil_codigo and c.bai_codigo = ba.bai_codigo ");
                buf.append("  left join examerequisicao exr on b.fil_codigo = exr.fil_codigo and b.req_codigo = exr.req_codigo and e.exa_codigo = exr.exa_codigo and e.mco_codigo = exr.mco_codigo ");
                buf.append("  left join cidades cid on c.fil_codigo = cid.fil_codigo and c.cid_codigo = cid.cid_codigo ");
                buf.append("  left join filiais_postocoleta fil on b.fil_codigo = fil.fil_codigo ");
                if (ParametrosGerais.getPrecoMetodologia()) {
                    buf.append("  left join detalhetabelaprecometodologia n on e.fil_codigo = n.fil_codigo and e.exa_codfilho = n.exa_codigo and e.mco_codfilho = n.mco_codigo and con.tpe_codigo = n.tpe_codigo and exr.met_codigo = n.met_codigo ");
                } else {
                    buf.append("  left join detalhetabelapreco n on e.fil_codigo = n.fil_codigo and e.exa_codfilho = n.exa_codigo and e.mco_codfilho = n.mco_codigo and con.tpe_codigo = n.tpe_codigo ");
                }
                buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("   and a.fat_codigo = ").append(codigoFatura);
                buf.append("   and fat.fat_datacancelamento is null ");
                buf.append("   and b.req_excluida = false ");
                buf.append(" group by b.fil_codigo ");
                buf.append("         ,b.req_dtfatura ");
                buf.append("         ,c.pac_nome ");
                buf.append("         ,c.pac_datanasc ");
                buf.append("         ,b.req_data ");
                buf.append("         ,b.med_crm ");
                buf.append("         ,exm.exa_descricao ");
                buf.append("         ,dtp_codamb ");
                buf.append("         ,c.pac_codigo ");
                buf.append("         ,c.pac_sexo ");
                buf.append("         ,c.pac_mae ");
                buf.append("         ,c.pac_endereco ");
                buf.append("         ,c.pac_numeroendereco ");
                buf.append("         ,c.pac_fone ");
                buf.append("         ,ba.bai_descricao ");
                buf.append("         ,c.pac_cep ");
                buf.append("         ,c.pac_cpf ");
                buf.append("         ,b.req_matricula ");
                buf.append("         ,b.req_codigo ");
                buf.append("         ,e.fer_ordem ");
                buf.append("         ,exr.exr_datadigita ");
                buf.append("         ,cid.cid_codigoibge ");
                buf.append("         ,fil.fil_cnes ");
                buf.append("         ,b.uns_codigo ");
                buf.append(" order by b.fil_codigo ");
                buf.append("         ,b.req_codigo ");
                buf.append("         ,e.fer_ordem ");
                rs = Conexao.executeQuery(st, buf);
                while (rs.next()) {
                    linhasArquivo.append(StringUtil.preencheString(rs.getString("fil_cnes"), 7, '0', 1));
                    linhasArquivo.append(StringUtil.preencheString(rs.getString("pac_codigo"), 10, '0', 1));
                    linhasArquivo.append(StringUtil.preencheString(StringUtil.testaTamanhoString(StringUtil.removerAcentos(rs.getString("pac_nome")), 50), 50, ' ', 0));
                    if (!DBUtil.campoNull(rs.getString("pac_datanasc"))) {
                        linhasArquivo.append(Funcoes.formataData("dd/MM/yyyy", rs.getDate("pac_datanasc")));
                    } else {
                        linhasArquivo.append("00/00/0000");
                    }
                    linhasArquivo.append(rs.getString("pac_sexo"));
                    linhasArquivo.append("99");
                    linhasArquivo.append(StringUtil.preencheString(StringUtil.testaTamanhoString(StringUtil.removerAcentos(rs.getString("pac_mae")), 50), 50, ' ', 0));
                    linhasArquivo.append(StringUtil.preencheString(StringUtil.testaTamanhoString(StringUtil.removerAcentos(Funcoes.textoVazio(rs.getString("pac_numeroendereco")) ? rs.getString("pac_endereco") : rs.getString("pac_endereco").trim() + ", " + rs.getString("pac_numeroendereco")), 40), 40, ' ', 0));
                    linhasArquivo.append(StringUtil.preencheString(StringUtil.testaTamanhoString(StringUtil.removerAcentos(rs.getString("pac_fone")), 20), 20, ' ', 0));
                    linhasArquivo.append(StringUtil.preencheString(StringUtil.testaTamanhoString(!DBUtil.campoNull(rs.getString("bai_descricao")) ? StringUtil.removerAcentos(rs.getString("bai_descricao")) : "", 20), 20, ' ', 0));
                    if (!DBUtil.campoNull(rs.getString("cid_codigoibge"))) {
                        linhasArquivo.append(StringUtil.preencheString(rs.getString("cid_codigoibge"), 7, '0', 1));
                    } else {
                        linhasArquivo.append(StringUtil.preencheString("0", 7, '0', 1));
                    }
                    linhasArquivo.append(StringUtil.preencheString(StringUtil.testaTamanhoString(StringUtil.limpaString(rs.getString("pac_cep"), new String[]{"-"}), 8), 8, ' ', 0));
                    linhasArquivo.append(StringUtil.preencheString(StringUtil.testaTamanhoString(StringUtil.limpaString(rs.getString("pac_cpf"), new String[]{"-", ".", ",", "/"}), 11), 11, ' ', 0));
                    linhasArquivo.append(StringUtil.preencheString(StringUtil.testaTamanhoString(StringUtil.limpaString(rs.getString("req_matricula"), new String[]{"-", ".", ",", "/"}), 15), 15, ' ', 0));
                    linhasArquivo.append(StringUtil.preencheString(rs.getString("req_codigo"), 10, '0', 1));
                    linhasArquivo.append(StringUtil.preencheString(String.valueOf(rs.getInt("fer_ordem") + 1), 10, '0', 1));
                    linhasArquivo.append(Funcoes.formataData("dd/MM/yyyy", rs.getDate("req_data")));
                    linhasArquivo.append(Funcoes.formataData("dd/MM/yyyy", rs.getDate("req_data")));
                    linhasArquivo.append(Funcoes.formataData("dd/MM/yyyy", rs.getDate("req_data")));
                    linhasArquivo.append(StringUtil.preencheString(rs.getString("med_crm"), 7, '0', 1));
                    linhasArquivo.append(StringUtil.preencheString(DBUtil.campoNull(rs.getString("uns_codigo")) ? "" : rs.getString("uns_codigo"), 7, '0', 1));
                    linhasArquivo.append(StringUtil.preencheString(StringUtil.testaTamanhoString(StringUtil.limpaString(rs.getString("dtp_codamb"), new String[]{"/", ".", ",", "-"}), 10), 10, ' ', 0));
                    linhasArquivo.append(StringUtil.preencheString(rs.getString("contagem"), 5, '0', 1));
                    linhasArquivo.append(StringUtil.preencheString(regXML.getString("conselhoExecutante"), 7, '0', 1));
                    linhasArquivo.append(StringUtil.preencheString(regXML.getString("cboExecutante"), 6, '0', 1));
                    buf.setLength(0);
                    buf.append("select c10_codigo from requisicaocid10 where fil_codigo = ");
                    buf.append(rs.getString("fil_codigo"));
                    buf.append(" and req_codigo = ").append(rs.getString("req_codigo"));
                    buf.append(" limit 1 ");
                    ResultSet rsCid = Conexao.executeQuery(st2, buf);
                    String cid10 = "";
                    if (rsCid.next() && !DBUtil.campoNull(rsCid.getString(1))) {
                        cid10 = rsCid.getString(1);
                    }
                    linhasArquivo.append(StringUtil.preencheString(cid10, 6, '0', 1));
                    linhasArquivo.append("N");
                    linhasArquivo.append(StringUtil.preencheString("", 10, '0', 1));
                    linhasArquivo.append(Funcoes.formataData("dd/MM/yyyy", new Date()));
                    linhasArquivo.append(StringUtil.preencheString("", 200, ' ', 1));
                    linhasArquivo.append("\n");
                }
                if (linhasArquivo.length() <= 0) break block17;
                StringBuilder nomeArquivo = new StringBuilder();
                nomeArquivo.append("SUS");
                nomeArquivo.append(Funcoes.preencheVazio(String.valueOf(codigoFatura), "0", 5, 1));
                arquivo = new ArrayList<ArquivoFaturamentoEletronico>();
                arquivo.add(new ArquivoFaturamentoEletronico(nomeArquivo.toString(), linhasArquivo.toString()));
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "SUSPelotas: 122");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        return arquivo;
    }

    @Override
    public String[] situacoesPermitidasExame(String xml) {
        return null;
    }

    @Override
    public boolean solicitarDiretorioNoInicio() {
        return true;
    }

    public static String getNomeProtocolo() {
        return "SUS (Pelotas-RS)";
    }

    public static String getExtensaoArquivo() {
        return "txt";
    }

    private Registro parseDadosXML(String xml) {
        if (xml == null || Funcoes.textoVazio(xml)) {
            return null;
        }
        Registro reg = new Registro();
        reg.setValor("protocolo", SUSPelotas.getNomeProtocolo());
        reg.setValor("conselhoExecutante", StringUtil.getValor(xml, "conselhoExecutante"));
        reg.setValor("cboExecutante", StringUtil.getValor(xml, "cboExecutante"));
        return reg;
    }

    private String criaXML(Registro r) {
        if (r == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder("<faturamentoEletronico>");
        buf.append("<protocolo>").append(SUSPelotas.getNomeProtocolo()).append("</protocolo>");
        buf.append("<conselhoExecutante>").append(r.getString("conselhoExecutante")).append("</conselhoExecutante>");
        buf.append("<cboExecutante>").append(r.getString("cboExecutante")).append("</cboExecutante>");
        buf.append("</faturamentoEletronico>");
        return buf.toString();
    }

    @Override
    public boolean validarCasasDecimais() {
        return true;
    }

    @Override
    public String getCodificacaoArquivo() {
        return FaturamentoEletronico.CODIFICACAO.ISO_8859_1.codificacao;
    }

    @Override
    public void verificaErrosFatura(ArrayList<DadosFaturamento> requisicoes, Registro configuracaoConvenio0) {
    }

    @Override
    public ArrayList<GuiaVirtual.Campo> getCamposObrigatorios(String versao) {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasSolicitados() {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasExecutados() {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampo> getCamposIncorretos(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasSolicitados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasExecutados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public Registro parseXMLConfiguracao(String xml) {
        return null;
    }

    @Override
    public boolean gravaAlteracoes(DadosFaturamento requisicao, String guia, Registro configuracao) {
        return false;
    }

    @Override
    public void preencheValoresCampos(DadosFaturamento requisicao, Registro configuracaoEletronico, String guia) {
    }

    @Override
    public void preencheValoresTabelas(DadosFaturamento requisicao, String guia) {
    }

    @Override
    public void getValoresPreenchidos(DadosFaturamento requisicao, ArrayList<DadosExameFaturamento> exames, Registro configuracaoEletronico) {
    }

    @Override
    public void aplicarModificacoesGerais(ArrayList<DadosFaturamento> requisicoes, DadosFaturamento requisicao, DadosFaturamento requisicaoModificada, Registro configuracaoEletronico, Registro configuracaoEletronicoModificada) {
    }

    @Override
    public Object[] getListaDadosAdicionais() {
        return null;
    }

    @Override
    public void setListaDadosAdicionais(Object[] listaDadosAdicionais) {
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampoBPA> getCamposIncorretosBPA(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<JanelaConfiguracaoFaturamentoBPA.CampoBPA> getCamposObrigatoriosBPA() {
        return null;
    }
}

