/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.impressao.ImpressaoUtil;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ArquivoFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.Campos;
import jalis.laboratorio.util.faturamento.eletronico.ConfigurarSLine;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.GuiaVirtual;
import jalis.laboratorio.util.faturamento.eletronico.JanelaConfiguracaoFaturamentoBPA;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class SLine
extends AbstractFaturamentoEletronico
implements FaturamentoEletronico {
    private StringBuilder conteudo = new StringBuilder();
    private Registro config = null;
    private static final Campos SL_TIPO = new Campos(2, true, true, false, "SL_TIPO");
    private static final Campos SL_TITULO = new Campos(70, true, true, false, "SL_TITULO");
    private static final Campos SL_SN = new Campos(1, true, true, false, "SL_SN");
    private static final Campos SL_CHAVE = new Campos(20, true, true, true, "SL_CHAVE");
    private static final Campos SL_SENHA = new Campos(8, true, false, true, "SL_SENHA");
    private static final Campos SL_COD_DOC = new Campos(20, true, true, true, "SL_COD_DOC");
    private static final Campos SL_FORMATO = new Campos(5, true, true, false, "SL_FORMATO");
    private static final Campos SL_CHAVE_ADICIONAL = new Campos(0, false, false, false, "SL_CHAVE_ADICIONAL");
    private static final Campos SL_DATA_REALIZACAO = new Campos(19, false, true, false, "SL_DATA_REALIZACAO");
    private static final Campos SL_SMS = new Campos(0, false, false, false, "SL_SMS");
    private static final Campos SL_OPER = new Campos(0, true, false, false, "SL_OPER");
    private static final Campos SL_TEXTO = new Campos(0, true, false, false, "SL_TEXTO");
    private static final Campos SL_OPER_REGANS = new Campos(6, true, true, true, "OPER_REGANS");
    private static final Campos SL_OPER_NUMCARTEIRA = new Campos(17, true, true, true, "OPER_NUMCARTEIRA");
    private static final Campos SL_OPER_NUMGUIA = new Campos(20, true, true, true, "OPER_NUMGUIA");
    private static final Campos SL_OPER_EXAME = new Campos(0, true, true, true, "OPER_EXAME");
    private static final int ALTURA_PAGINA = 160;
    PreparedStatement psResultado = null;
    PreparedStatement psExames = null;

    public SLine() {
        String[] situacoes = this.situacoesPermitidasExame(null);
        StringBuilder buf = new StringBuilder();
        buf.append(" select req.req_codigo as codigoRequisicao ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_datanasc as dataNascimentoPaciente ");
        buf.append("       ,con.con_razao as razaoSocialConvenio ");
        buf.append("       ,med.med_nome as nomeMedico ");
        buf.append("       ,pac.pac_chavesline as chavePermanentePaciente ");
        buf.append("       ,MAX(exr.exr_datadigita) as dataRealizacao ");
        buf.append("       ,pac.pac_celular as celularPaciente ");
        buf.append("       ,COUNT(exr.fil_codigo) as qtdeExamesRealizados ");
        buf.append("       ,req.req_matricula as matricula ");
        buf.append("   from faturarequisicao fre ");
        buf.append("   join fatura           fat on fre.fil_codigo = fat.fil_codigo and fre.fat_codigo = fat.fat_codigo ");
        buf.append("   join requisicao       req on fre.fil_kodigo = req.fil_codigo and fre.req_codigo = req.req_codigo ");
        buf.append("   join convenios        con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("   join paciente         pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join medico           med on req.fil_codigo = med.fil_codigo and req.med_crm    = med.med_crm    and req.med_conselho = med.med_conselho and req.med_uf = med.med_uf ");
        buf.append("   left join examerequisicao  exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("  where fre.fil_codigo = ? ");
        buf.append("    and fre.fat_codigo = ? ");
        buf.append("    and fat.fat_datacancelamento IS NULL ");
        buf.append("    and NOT req.req_excluida ");
        buf.append("    and exr.exr_dataexcluido IS NULL ");
        buf.append("    and exr.exr_situacao IN (");
        for (int i = 0; i < situacoes.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(" '").append(situacoes[i]).append("' ");
        }
        buf.append(" ) ");
        buf.append("  group by req.req_codigo ");
        buf.append("          ,pac.pac_nome ");
        buf.append("          ,pac.pac_chavesline ");
        buf.append("          ,pac.pac_celular ");
        buf.append("          ,req.req_matricula ");
        buf.append("          ,pac.pac_datanasc ");
        buf.append("          ,con.con_razao ");
        buf.append("          ,med.med_nome ");
        this.psResultado = Conexao.getPreparedStatement(buf.toString());
    }

    public ArrayList<ArquivoFaturamentoEletronico> gerarArquivo(Object owner, int codigoFatura) throws Exception {
        this.psResultado.setInt(1, Integer.parseInt(Variaveis.filialPadrao));
        this.psResultado.setInt(2, codigoFatura);
        ResultSet rs = this.psResultado.executeQuery();
        return this.gerarArquivo(owner, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ArquivoFaturamentoEletronico> gerarArquivoSemFatura(Object owner, String codigosRequisicoes, String codigoConvenio, String xmlConfiguracao) throws Exception {
        ArrayList<ArquivoFaturamentoEletronico> arrayList;
        String[] situacoes = this.situacoesPermitidasExame(null);
        StringBuilder buf = new StringBuilder();
        buf.append(" select req.req_codigo as codigoRequisicao ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_datanasc as dataNascimentoPaciente ");
        buf.append("       ,con.con_razao as razaoSocialConvenio ");
        buf.append("       ,med.med_nome as nomeMedico ");
        buf.append("       ,pac.pac_chavesline as chavePermanentePaciente ");
        buf.append("       ,MAX(exr.exr_datadigita) as dataRealizacao ");
        buf.append("       ,pac.pac_celular as celularPaciente ");
        buf.append("       ,COUNT(exr.fil_codigo) as qtdeExamesRealizados ");
        buf.append("       ,req.req_matricula as matricula ");
        buf.append("   from requisicao       req ");
        buf.append("   join convenios        con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("   join paciente         pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join medico           med on req.fil_codigo = med.fil_codigo and req.med_crm    = med.med_crm    and req.med_conselho = med.med_conselho and req.med_uf = med.med_uf ");
        buf.append("   left join examerequisicao  exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("  where req.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and req.req_codigo IN (").append(codigosRequisicoes).append(") ");
        buf.append("    and NOT req.req_excluida ");
        buf.append("    and NOT exr.exr_excluido ");
        buf.append("    and exr.exr_situacao IN (");
        for (int i = 0; i < situacoes.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(" '").append(situacoes[i]).append("' ");
        }
        buf.append(" ) ");
        buf.append("  group by req.req_codigo ");
        buf.append("          ,pac.pac_nome ");
        buf.append("          ,pac.pac_chavesline ");
        buf.append("          ,pac.pac_celular ");
        buf.append("          ,req.req_matricula ");
        buf.append("          ,pac.pac_datanasc ");
        buf.append("          ,con.con_razao ");
        buf.append("          ,med.med_nome ");
        Statement st = Conexao.getStatement();
        try {
            this.config = this.parseXMLConfiguracao(xmlConfiguracao);
            this.config.setValor("con_codigo", codigoConvenio);
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            arrayList = this.gerarArquivo(owner, rs);
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return arrayList;
    }

    private ArrayList<ArquivoFaturamentoEletronico> gerarArquivo(Object owner, ResultSet rs) throws Exception {
        ArrayList<ArquivoFaturamentoEletronico> retorno = new ArrayList<ArquivoFaturamentoEletronico>();
        SplashMensagem splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
        boolean enviarComoOperadora = this.config.getBoolean("enviarComoOperadora");
        String path = null;
        JFileChooser file = ComponenteFactory.novoJFileChooser();
        file.setFileSelectionMode(1);
        if (file.showSaveDialog(null) == 0) {
            path = file.getSelectedFile().getAbsolutePath();
        }
        if (!Funcoes.textoVazio(path)) {
            splash.mostrar("Aguarde... Gerando arquivos.");
            if (rs != null && rs.next()) {
                do {
                    this.conteudo.setLength(0);
                    this.conteudo.append("<?xml version=\"1.0\" encoding=\"iso-8859-1\" ?>");
                    this.conteudo.append("<S_LINE>");
                    this.conteudo.append(this.getValor(SL_TIPO, this.config.getValor("tipoDocumento").toString()));
                    this.conteudo.append(this.getValor(SL_TITULO, this.getTituloDocumento(rs.getString("codigoRequisicao"), rs.getString("nomePaciente"))));
                    this.conteudo.append(this.getValor(SL_SN, this.getTipoDestinatarioPrincipal(rs.getString("chavePermanentePaciente"), enviarComoOperadora)));
                    if (!enviarComoOperadora) {
                        this.conteudo.append(this.getValor(SL_CHAVE, this.getChaveDestinatarioPrincipal(rs.getString("chavePermanentePaciente"))));
                        this.conteudo.append(this.getValor(SL_SENHA, this.getSenha(rs.getString("chavePermanentePaciente"))));
                    } else {
                        this.conteudo.append("<SL_CHAVE></SL_CHAVE>");
                        this.conteudo.append("<SL_SENHA></SL_SENHA>");
                    }
                    this.conteudo.append(this.getValor(SL_COD_DOC, rs.getString("codigoRequisicao")));
                    this.conteudo.append(this.getValor(SL_FORMATO, FormatoArquivo.TEXTO_HTML.codigo));
                    this.conteudo.append(this.getValor(SL_CHAVE_ADICIONAL, null));
                    this.conteudo.append(this.getValor(SL_DATA_REALIZACAO, this.getDataRealizacao(rs.getDate("dataRealizacao"))));
                    this.conteudo.append(this.getValor(SL_SMS, this.getSms(rs.getString("celularPaciente"))));
                    ResultSet rsExames = this.pegaResultadosExames(Variaveis.filialPadrao, rs.getString("codigoRequisicao"));
                    this.conteudo.append(this.getValor(SL_OPER, this.getOper(rs.getString("codigoRequisicao"), rs.getString("matricula"), rsExames)));
                    this.conteudo.append(this.getValor(SL_TEXTO, this.getResultado(rs.getString("codigoRequisicao"), rs.getString("nomePaciente"), rs.getString("razaoSocialConvenio"), Funcoes.calculaIdade(Funcoes.formataData(rs.getDate("dataNascimentoPaciente"))), rs.getString("nomeMedico"), rsExames)));
                    this.conteudo.append("</S_LINE>");
                    String nomeArquivo = "";
                    int auxTituloDocumento = Integer.valueOf(this.config.getValor("tituloDocumento").toString());
                    if (auxTituloDocumento == ConfigurarSLine.TituloDocumento.IDENTIFICACAO.codigo) {
                        nomeArquivo = rs.getString("codigoRequisicao");
                    } else if (auxTituloDocumento == ConfigurarSLine.TituloDocumento.IDENTIFICACAO_E_NOME.codigo) {
                        nomeArquivo = rs.getString("codigoRequisicao") + " - " + rs.getString("nomePaciente");
                    } else if (auxTituloDocumento == ConfigurarSLine.TituloDocumento.NOME_E_IDENTIFICACAO.codigo) {
                        nomeArquivo = rs.getString("nomePaciente") + " - " + rs.getString("codigoRequisicao");
                    } else if (auxTituloDocumento == ConfigurarSLine.TituloDocumento.NOME.codigo) {
                        nomeArquivo = rs.getString("nomePaciente");
                    }
                    ArquivoFaturamentoEletronico arquivo = new ArquivoFaturamentoEletronico(nomeArquivo.toString(), this.conteudo.toString());
                    retorno.add(new ArquivoFaturamentoEletronico(nomeArquivo.toString(), this.conteudo.toString()));
                    String extensao = SLine.getExtensaoArquivo();
                    String arquivoNome = path + "/" + arquivo.getNome() + (extensao == null ? "" : "." + extensao);
                    StringUtil.escreverArquivoTexto(arquivoNome, arquivo.getXML(), this.getCodificacaoArquivo());
                } while (rs.next());
            }
            splash.apagar();
            if (retorno != null && !retorno.isEmpty()) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Arquivo(s) criado(s) com sucesso.", 2);
            }
        }
        return retorno;
    }

    private ResultSet pegaResultadosExames(String filialPadrao, String codigoRequisicao) {
        String[] situacoes = this.situacoesPermitidasExame(null);
        StringBuilder buf = new StringBuilder();
        buf.append(" select pegaResultadoExame(exr.fil_codigo, exr.req_codigo, exr.exa_codigo, exr.mco_codigo) as resultado ");
        buf.append("       ,exr.exa_codigo as codigoExame ");
        buf.append("       ,exr.mco_codigo as codigomaterial ");
        buf.append("       ,exr.exr_guia as guia ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("       ,dtm.dtm_codamb as amb ");
        } else {
            buf.append("       ,dtp.dtp_codamb as amb ");
        }
        buf.append("   from requisicao         req ");
        buf.append("   join examerequisicao    exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("   join examematcoleta     emc on req.fil_codigo = emc.fil_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
        buf.append("   join convenios          con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("   join detalhetabelaprecometodologia dtm on exr.fil_codigo = dtm.fil_codigo and exr.exa_codigo = dtm.exa_codigo and exr.mco_codigo = dtm.mco_codigo and con.tpe_codigo = dtm.tpe_codigo and exr.met_codigo = dtm.met_codigo ");
        } else {
            buf.append("   join detalhetabelapreco dtp on exr.fil_codigo = dtp.fil_codigo and exr.exa_codigo = dtp.exa_codigo and exr.mco_codigo = dtp.mco_codigo and con.tpe_codigo = dtp.tpe_codigo ");
        }
        buf.append("  where req.fil_codigo = ").append(filialPadrao);
        buf.append("    and req.req_codigo = ").append(codigoRequisicao);
        buf.append("    and NOT req.req_excluida ");
        buf.append("    and exr.exr_dataexcluido IS NULL ");
        buf.append("    and exr.exr_situacao IN (");
        for (int i = 0; i < situacoes.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(" '").append(situacoes[i]).append("' ");
        }
        buf.append(" ) ");
        buf.append("  order by exr.exr_guia ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            return rs;
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar resultados." + e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    private String getOper(String codigoRequisicao, String numeroCarteira, ResultSet rsExames) {
        if (codigoRequisicao == null || Funcoes.textoVazio(codigoRequisicao)) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        try {
            buf.append(this.getValor(SL_OPER_REGANS, this.config.getValor("registroAns").toString()));
            buf.append(this.getValor(SL_OPER_NUMCARTEIRA, numeroCarteira));
            String guiaAnterior = null;
            while (rsExames.next()) {
                String guia = rsExames.getString("guia");
                if (!guia.equalsIgnoreCase(guiaAnterior)) {
                    if (guiaAnterior != null) {
                        buf.append("</").append(SLine.SL_OPER_NUMGUIA.tag).append(">");
                    }
                    buf.append("<").append(SLine.SL_OPER_NUMGUIA.tag).append(">").append(this.criptografar(guia));
                    guiaAnterior = guia;
                }
                buf.append(this.getValor(SL_OPER_EXAME, StringUtil.limpaString(rsExames.getString("amb"), new String[]{"-", "."})));
            }
            buf.append("</").append(SLine.SL_OPER_NUMGUIA.tag).append(">");
        }
        catch (Exception e) {
            return null;
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getResultado(String codigoRequisicao, String nomePaciente, String descricaoConvenio, String idadePaciente, String nomeMedico, ResultSet rsExames) {
        String string;
        Statement st;
        block10: {
            if (codigoRequisicao == null || Funcoes.textoVazio(codigoRequisicao)) {
                return null;
            }
            StringBuilder resultadoHTML = new StringBuilder();
            st = Conexao.getStatement();
            try {
                resultadoHTML.append("<table width=100% cellspacing=2 align=left>");
                resultadoHTML.append("<tr>");
                resultadoHTML.append("<td width=80><b>Paciente:</b></td><td>").append(nomePaciente).append("</td><td width=20><b>Idade:</b></td><td width=80>").append(idadePaciente).append("</td>");
                resultadoHTML.append("</tr>");
                resultadoHTML.append("<tr>");
                resultadoHTML.append("<td><b>Conv\u00eanio:</b></td><td colspan=3>").append(descricaoConvenio).append("</td>");
                resultadoHTML.append("</tr>");
                resultadoHTML.append("<tr>");
                resultadoHTML.append("<td><b>M\u00e9dico:</b></td><td colspan=3>").append(nomeMedico).append("</td>");
                resultadoHTML.append("</tr>");
                resultadoHTML.append("</table>");
                resultadoHTML.append("<div style='clear:both; margin-bottom:20px'></div>");
                int tamanho = 0;
                rsExames.beforeFirst();
                while (rsExames.next()) {
                    String xmlResultado = rsExames.getString("resultado");
                    if (xmlResultado == null || Funcoes.textoVazio(xmlResultado)) {
                        string = null;
                        break block10;
                    }
                    int tamanhoAux = new Float(ScreenUtil.getMilimetros(ImpressaoUtil.alturaResultado(xmlResultado))).intValue();
                    Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st, Variaveis.filialPadrao, codigoRequisicao, rsExames.getString("codigoExame"), rsExames.getString("codigoMaterial"), xmlResultado, true, false);
                    String aux = (String)mapa.get("laudo");
                    aux = aux.replace("?>", "");
                    aux = aux.replace("<?", "");
                    if (tamanho + tamanhoAux > 160) {
                        tamanho = 0;
                        resultadoHTML.append("\n<br style='page-break-before:always;'>\n");
                    } else {
                        tamanho += tamanhoAux;
                    }
                    resultadoHTML.append("<div style='clear:both; display:block; border-top:1px solid black; margin-top:10px'>");
                    resultadoHTML.append(aux);
                    resultadoHTML.append("</div>");
                }
            }
            catch (Exception e) {
                String string2;
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gerar HTML dos resultados." + e.getMessage(), e.getStackTrace());
                    string2 = null;
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
                return string2;
            }
            Conexao.fecharStatement(st);
            StringBuilder buf = new StringBuilder();
            buf.append("<![CDATA[").append((CharSequence)resultadoHTML).append("]]>");
            return buf.toString();
        }
        Conexao.fecharStatement(st);
        return string;
    }

    private String getSms(String celular) {
        if (celular == null || celular.length() != 13) {
            return null;
        }
        try {
            int ddd = Integer.parseInt(celular.substring(1, 3));
            int numero = Integer.parseInt(celular.substring(4, 13).replaceAll("-", ""));
            String mensagem = this.config.getValor("mensagemSms").toString();
            if (mensagem == null || Funcoes.textoVazio(mensagem)) {
                return null;
            }
            mensagem = StringUtil.removerAcentos(mensagem);
            mensagem = this.substring(mensagem, 122);
            StringBuilder buf = new StringBuilder();
            buf.append("<SMS_NUM>").append(ddd).append(numero).append("</SMS_NUM>");
            buf.append("<SMS_MSG><![CDATA[").append(mensagem).append("]]></SMS_MSG>");
            return buf.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getDataRealizacao(Date dataRealizacao) {
        if (dataRealizacao == null) {
            return null;
        }
        int auxOpcaoEnvio = Integer.valueOf(this.config.getValor("opcaoEnvio").toString());
        if (auxOpcaoEnvio == ConfigurarSLine.OpcaoEnvio.NOVO_DOCUMENTO.codigo) {
            return Funcoes.formataData("yyyy-MM-dd", dataRealizacao) + "T" + Funcoes.formataData("HH:mm:ss", dataRealizacao);
        }
        if (auxOpcaoEnvio == ConfigurarSLine.OpcaoEnvio.REENVIO_SOLICITACAO_USUARIO.codigo) {
            return Funcoes.formataData("yyyy-MM-dd", dataRealizacao) + "T" + Funcoes.formataData("HH:mm:ss", dataRealizacao);
        }
        return null;
    }

    private String getSenha(String tipoDestinatario) {
        if (tipoDestinatario == null || tipoDestinatario.equalsIgnoreCase(TipoDestinatarioPrincipal.CHAVE_TEMPORARIA.codigo)) {
            return Funcoes.gerarSenha(8);
        }
        return null;
    }

    private String getChaveDestinatarioPrincipal(String chavePermanentePaciente) {
        if (chavePermanentePaciente == null || Funcoes.textoVazio(chavePermanentePaciente)) {
            String idInstalacao = this.config.getValor("identificadorInstalacao").toString();
            String senha = Funcoes.gerarSenha(8);
            return idInstalacao + senha;
        }
        return chavePermanentePaciente;
    }

    private String getTipoDestinatarioPrincipal(String chavePermanentePaciente, boolean enviarComoOperadora) {
        if (enviarComoOperadora) {
            return TipoDestinatarioPrincipal.SOMENTE_OPERADORA.codigo;
        }
        if (chavePermanentePaciente == null || Funcoes.textoVazio(chavePermanentePaciente)) {
            return TipoDestinatarioPrincipal.CHAVE_TEMPORARIA.codigo;
        }
        return TipoDestinatarioPrincipal.CHAVE_PERMANENTE.codigo;
    }

    private String getTituloDocumento(String codigoRequisicao, String nomePaciente) {
        String retorno;
        int tituloDocumento = Integer.valueOf(this.config.getValor("tituloDocumento").toString());
        if (tituloDocumento == -1) {
            return null;
        }
        if (tituloDocumento == ConfigurarSLine.TituloDocumento.IDENTIFICACAO_E_NOME.codigo) {
            retorno = codigoRequisicao + " - " + nomePaciente;
        } else if (tituloDocumento == ConfigurarSLine.TituloDocumento.NOME_E_IDENTIFICACAO.codigo) {
            retorno = nomePaciente + " - " + codigoRequisicao;
        } else if (tituloDocumento == ConfigurarSLine.TituloDocumento.NOME.codigo) {
            retorno = nomePaciente;
        } else if (tituloDocumento == ConfigurarSLine.TituloDocumento.IDENTIFICACAO.codigo) {
            retorno = codigoRequisicao;
        } else {
            return null;
        }
        return retorno;
    }

    private String substring(String str, int tamanho) {
        return str.substring(0, str.length() > tamanho ? tamanho : str.length());
    }

    private String getValor(Campos campo, String valor) throws Exception {
        if (campo == null) {
            throw new Exception("Campo n\u00e3o informado.");
        }
        if (!campo.conteudoObrigatorio && !campo.tagObrigatoria) {
            return "";
        }
        if (valor == null && campo.conteudoObrigatorio && !campo.tagObrigatoria) {
            return "";
        }
        if (valor == null && !campo.conteudoObrigatorio && campo.tagObrigatoria) {
            return "<" + campo.tag + "></" + campo.tag + ">";
        }
        if (valor != null || !campo.conteudoObrigatorio || !campo.tagObrigatoria) {
            if (valor != null && campo.criptografado) {
                return "<" + campo.tag + ">" + this.criptografar(campo.tamanho > 0 ? this.substring(valor, campo.tamanho) : valor) + "</" + campo.tag + ">";
            }
            return "<" + campo.tag + ">" + (campo.tamanho > 0 ? this.substring(valor, campo.tamanho) : valor) + "</" + campo.tag + ">";
        }
        new Exception("O conte\u00fado do campo deve ser preenchido. TAG: " + campo.tag + ".");
        return null;
    }

    private String criptografar(String valor) {
        ActiveXComponent sC = new ActiveXComponent("SLineCripto.cSLineCripto");
        Dispatch sControl = sC.getObject();
        Variant v = Dispatch.call((Dispatch)sControl, (String)"GeraCripto", (Object)valor, (Object)new Variant());
        if (v == null) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "A informa\u00e7\u00e3o n\u00e3o p\u00f4de ser criptografada.\n", null);
            return null;
        }
        return v.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<ArquivoFaturamentoEletronico> criarArquivo(Object owner, int codigoFatura, String codigoConvenio, String diretorioArquivos) {
        ArrayList<ArquivoFaturamentoEletronico> retorno;
        Statement st;
        block7: {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            retorno = new ArrayList<ArquivoFaturamentoEletronico>();
            try {
                buf.append(" select fat.con_codigo  ");
                buf.append("       ,con.con_faturaeletronica ");
                buf.append("   from fatura    fat ");
                buf.append("   join convenios con on fat.fil_codigo = con.fil_codigo and fat.con_codigo = con.con_codigo ");
                buf.append("  where fat.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and fat.fat_codigo = ").append(codigoFatura);
                buf.append("    and fat.fat_datacancelamento is null ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (rs.next()) {
                    this.config = this.parseXMLConfiguracao(rs.getString("con_faturaeletronica"));
                    this.config.setValor("con_codigo", rs.getString("con_codigo"));
                }
                if (this.config == null) break block7;
                retorno = this.gerarArquivo(owner, codigoFatura);
            }
            catch (Exception ex) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private String registroToXML(Registro r) {
        StringBuilder buf = new StringBuilder("<faturamentoEletronico>");
        buf.append("<protocolo>").append(SLine.getNomeProtocolo()).append("</protocolo>");
        buf.append(StringUtil.getTag("registroAns", r.getValor("registroAns").toString()));
        buf.append(StringUtil.getTag("tipoDocumento", r.getValor("tipoDocumento").toString()));
        buf.append(StringUtil.getTag("tituloDocumento", r.getValor("tituloDocumento").toString()));
        buf.append(StringUtil.getTag("identificadorInstalacao", r.getValor("identificadorInstalacao").toString()));
        buf.append(StringUtil.getTag("opcaoEnvio", r.getValor("opcaoEnvio").toString()));
        buf.append(StringUtil.getTag("enviarSms", r.getValor("enviarSms").toString()));
        buf.append(StringUtil.getTag("mensagemSms", r.getValor("mensagemSms").toString()));
        buf.append("</faturamentoEletronico>");
        return buf.toString();
    }

    @Override
    public String configurar(JFrame parent, String xml) {
        String retorno = xml;
        ConfigurarSLine conf = new ConfigurarSLine(parent);
        conf.setXML(xml);
        conf.setVisible(true);
        if (conf.ok()) {
            retorno = conf.getXML();
            this.config = this.parseXMLConfiguracao(retorno);
        }
        return retorno;
    }

    @Override
    public boolean solicitarDiretorioNoInicio() {
        return true;
    }

    @Override
    public String[] situacoesPermitidasExame(String xml) {
        return new String[]{"L", "C", "I", "E"};
    }

    @Override
    public boolean validarCasasDecimais() {
        return true;
    }

    public static String getNomeProtocolo() {
        return "SLine";
    }

    @Override
    public Registro parseXMLConfiguracao(String xml) {
        Registro r = new Registro();
        r.setValor("registroAns", StringUtil.getValor(xml, "registroAns"));
        r.setValor("enviarSms", StringUtil.getValor(xml, "enviarSms"));
        r.setValor("identificadorInstalacao", StringUtil.getValor(xml, "identificadorInstalacao"));
        r.setValor("mensagemSms", StringUtil.getValor(xml, "mensagemSms"));
        r.setValor("opcaoEnvio", StringUtil.getValor(xml, "opcaoEnvio"));
        r.setValor("tipoDocumento", StringUtil.getValor(xml, "tipoDocumento"));
        r.setValor("tituloDocumento", StringUtil.getValor(xml, "tituloDocumento"));
        r.setValor("enviarComoOperadora", StringUtil.getBoolean(xml, "enviarComoOperadora"));
        return r;
    }

    @Override
    public String getCodificacaoArquivo() {
        return FaturamentoEletronico.CODIFICACAO.ISO_8859_1.codificacao;
    }

    @Override
    public void verificaErrosFatura(ArrayList<DadosFaturamento> requisicoes, Registro configuracaoConvenio0) {
    }

    @Override
    public ArrayList<GuiaVirtual.Campo> getCamposObrigatorios(String versao) {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasSolicitados() {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasExecutados() {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampo> getCamposIncorretos(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasSolicitados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasExecutados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public boolean gravaAlteracoes(DadosFaturamento requisicao, String guia, Registro configuracao) {
        return false;
    }

    @Override
    public void preencheValoresCampos(DadosFaturamento requisicao, Registro configuracaoEletronico, String guia) {
    }

    @Override
    public void preencheValoresTabelas(DadosFaturamento requisicao, String guia) {
    }

    @Override
    public void getValoresPreenchidos(DadosFaturamento requisicao, ArrayList<DadosExameFaturamento> exames, Registro configuracaoEletronico) {
    }

    @Override
    public void aplicarModificacoesGerais(ArrayList<DadosFaturamento> requisicoes, DadosFaturamento requisicao, DadosFaturamento requisicaoModificada, Registro configuracaoEletronico, Registro configuracaoEletronicoModificada) {
    }

    @Override
    public Object[] getListaDadosAdicionais() {
        return null;
    }

    @Override
    public void setListaDadosAdicionais(Object[] listaDadosAdicionais) {
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampoBPA> getCamposIncorretosBPA(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<JanelaConfiguracaoFaturamentoBPA.CampoBPA> getCamposObrigatoriosBPA() {
        return null;
    }

    private static enum FormatoArquivo {
        TEXTO_HTML("HTML"),
        PDF("PDF");

        private String codigo;

        private FormatoArquivo(String codigo) {
            this.codigo = codigo;
        }
    }

    private static enum TipoDestinatarioPrincipal {
        CHAVE_TEMPORARIA("N"),
        CHAVE_PERMANENTE("S"),
        SOMENTE_OPERADORA("O");

        private String codigo;

        private TipoDestinatarioPrincipal(String codigo) {
            this.codigo = codigo;
        }
    }
}

