/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ArquivoFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.GuiaVirtual;
import jalis.laboratorio.util.faturamento.eletronico.JanelaConfiguracaoFaturamentoBPA;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Resuline
extends AbstractFaturamentoEletronico
implements FaturamentoEletronico {
    private static final String TAG_DATA = "DATA";
    private static final String TAG_GUIA = "GUIA";
    private static final String TAG_BENEFICIARIO = "BENEFICIARIO";
    private static final String TAG_PROCEDIMENTOS = "PROCEDIMENTOS";
    private static final String TAG_RESULTADO = "RESULTADO";
    private static final String TAG_NOME_ANEXO = "NOMEANEXO";
    private static final String TAG_ANEXO = "ANEXO";
    private static final String TAG_PROCEDIMENTO = "PROCEDIMENTO";
    private static final String PATHFILERESULTADO = "pathfileresultado";
    private Registro config = null;
    private Set<String> filtroMsg = new HashSet<String>();
    PreparedStatement psResultado = null;

    public Resuline() {
        String[] situacoes = this.situacoesPermitidasExame(null);
        StringBuilder buf = new StringBuilder();
        buf.append(" select req.fil_codigo as filial ");
        buf.append("       ,req.req_codigo as requisicao ");
        buf.append("       ,exr.exr_guia as guia ");
        buf.append("       ,exr.exa_codigo as exame ");
        buf.append("       ,exr.mco_codigo as material ");
        buf.append("       ,req.req_matricula as matricula ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("       ,dtm.dtm_codamb as procedimento ");
        } else {
            buf.append("       ,dtp.dtp_codamb as procedimento ");
        }
        buf.append("   from faturarequisicao fre ");
        buf.append("   join fatura           fat on fre.fil_codigo = fat.fil_codigo and fre.fat_codigo = fat.fat_codigo ");
        buf.append("   join requisicao       req on fre.fil_kodigo = req.fil_codigo and fre.req_codigo = req.req_codigo ");
        buf.append("   join convenios        con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("   join examerequisicao  exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("   left join detalhetabelaprecometodologia dtm on exr.fil_codigo = dtm.fil_codigo and exr.exa_codigo = dtm.exa_codigo and exr.mco_codigo = dtm.mco_codigo and con.tpe_codigo = dtm.tpe_codigo and exr.met_codigo = dtm.met_codigo ");
        } else {
            buf.append("   left join detalhetabelapreco dtp on exr.fil_codigo = dtp.fil_codigo and exr.exa_codigo = dtp.exa_codigo and exr.mco_codigo = dtp.mco_codigo and con.tpe_codigo = dtp.tpe_codigo ");
        }
        buf.append("  where fre.fil_codigo = ? ");
        buf.append("    and fre.fat_codigo = ? ");
        buf.append("    and fat.fat_datacancelamento IS NULL ");
        buf.append("    and NOT req.req_excluida ");
        buf.append("    and exr.exr_dataexcluido IS NULL ");
        buf.append("    and exr.exr_situacao IN (");
        for (int i = 0; i < situacoes.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(" '").append(situacoes[i]).append("' ");
        }
        buf.append(") ");
        buf.append("  order by req.fil_codigo ");
        buf.append("          ,req.req_codigo ");
        buf.append("          ,exr.exr_guia ");
        buf.append("          ,req.req_matricula ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("       ,dtm.dtm_codamb ");
        } else {
            buf.append("       ,dtp.dtp_codamb ");
        }
        buf.append("         ,exr.exa_codigo ");
        this.psResultado = Conexao.getPreparedStatement(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<ArquivoFaturamentoEletronico> criarArquivo(Object owner, int codigoFatura, String codigoConvenio, String diretorioArquivos) {
        ArrayList<ArquivoFaturamentoEletronico> retorno;
        Statement st;
        block7: {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            retorno = new ArrayList<ArquivoFaturamentoEletronico>();
            try {
                buf.append(" select fat.con_codigo  ");
                buf.append("       ,con.con_faturaeletronica ");
                buf.append("   from fatura    fat ");
                buf.append("   join convenios con on fat.fil_codigo = con.fil_codigo and fat.con_codigo = con.con_codigo ");
                buf.append("  where fat.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and fat.fat_codigo = ").append(codigoFatura);
                buf.append("    and fat.fat_datacancelamento is null ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (rs.next()) {
                    this.config = this.parseXMLConfiguracao(rs.getString("con_faturaeletronica"));
                    this.config.setValor("con_codigo", rs.getString("con_codigo"));
                }
                if (this.config == null) break block7;
                retorno = this.gerarArquivo(owner, codigoFatura);
            }
            catch (Exception ex) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ArquivoFaturamentoEletronico> gerarArquivo(Object owner, int codigoFatura) {
        ArrayList<ArquivoFaturamentoEletronico> arrayList;
        Statement st = Conexao.getStatement();
        try {
            ArrayList<ArquivoFaturamentoEletronico> retornoResultados = new ArrayList<ArquivoFaturamentoEletronico>();
            HashSet<String> chave = new HashSet<String>();
            this.psResultado.setInt(1, Integer.parseInt(Variaveis.filialPadrao));
            this.psResultado.setInt(2, codigoFatura);
            ResultSet rsFatura = this.psResultado.executeQuery();
            while (rsFatura.next()) {
                StringBuilder buf = this.getSql(rsFatura.getString("requisicao"), this.situacoesPermitidasExame(null), false, null);
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) continue;
                do {
                    if (!Funcoes.textoVazio(rs.getString("guia"))) {
                        String key = rs.getString("guia") + rs.getString("requisicao");
                        if (!chave.contains(key)) {
                            StringBuilder bufQtd = this.getSql(rs.getString("requisicao"), this.situacoesPermitidasExame(null), true, rs.getString("guia"));
                            ResultSet resultSetQtd = Conexao.executeQuery(Conexao.getStatement(), bufQtd.toString());
                            StringBuilder bufDados = this.getSql(rs.getString("requisicao"), this.situacoesPermitidasExame(null), false, rs.getString("guia"));
                            ResultSet dados = Conexao.executeQuery(Conexao.getStatement(), bufDados.toString());
                            retornoResultados.addAll(this.gerarArquivo(owner, dados, resultSetQtd.next() ? resultSetQtd.getInt("quantidade") : 0, false));
                        }
                        chave.add(key);
                        continue;
                    }
                    this.filtroMsg.add("O n\u00famero da guia para a requisi\u00e7\u00e3o " + rs.getString("requisicao") + " do exame " + rs.getString("exame") + " do material " + rs.getString("material") + " n\u00e3o foi informado.");
                } while (rs.next());
            }
            if (!this.filtroMsg.isEmpty()) {
                MostraErrosIntegracaoResuline errosIntegracaoResuline = new MostraErrosIntegracaoResuline((JFrame)owner, this.filtroMsg);
                errosIntegracaoResuline.setVisible(true);
            }
            arrayList = retornoResultados;
        }
        catch (Exception e) {
            ArrayList<ArquivoFaturamentoEletronico> arrayList2;
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gerar o faturamento eletr\u00f4nico.\n" + e.getMessage(), e.getStackTrace());
                arrayList2 = null;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return arrayList2;
        }
        Conexao.fecharStatement(st);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean gerarArquivoSemFatura(Object owner, String codigosRequisicoes, String codigoConvenio, String xmlConfiguracao) throws Exception {
        String[] situacoes = this.situacoesPermitidasExame(null);
        this.config = this.parseXMLConfiguracao(xmlConfiguracao);
        this.config.setValor("con_codigo", codigoConvenio);
        HashSet<String> chave = new HashSet<String>();
        Statement st = Conexao.getStatement();
        try {
            for (String requisicao : codigosRequisicoes.split("\\,")) {
                StringBuilder buf = this.getSql(requisicao, situacoes, false, null);
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) continue;
                do {
                    String key;
                    if (!chave.contains(key = rs.getString("guia") + rs.getString("requisicao"))) {
                        StringBuilder bufQtd = this.getSql(requisicao, situacoes, true, rs.getString("guia"));
                        ResultSet resultSetQtd = Conexao.executeQuery(Conexao.getStatement(), bufQtd.toString());
                        StringBuilder bufDados = this.getSql(requisicao, situacoes, false, rs.getString("guia"));
                        ResultSet dados = Conexao.executeQuery(Conexao.getStatement(), bufDados.toString());
                        this.gerarArquivo(owner, dados, resultSetQtd.next() ? resultSetQtd.getInt("quantidade") : 0, true);
                    }
                    chave.add(key);
                } while (rs.next());
            }
            if (!this.filtroMsg.isEmpty()) {
                MostraErrosIntegracaoResuline errosIntegracaoResuline = new MostraErrosIntegracaoResuline((JFrame)owner, this.filtroMsg);
                errosIntegracaoResuline.setVisible(true);
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return this.filtroMsg.isEmpty();
    }

    @Override
    public String configurar(JFrame parent, String xml) {
        String retorno = xml;
        Configurar conf = new Configurar(parent);
        conf.setXML(this.parseDadosXML(xml));
        conf.setVisible(true);
        if (conf.ok()) {
            Registro r = new Registro();
            r.setValor(PATHFILERESULTADO, conf.getPathFileResultado());
            retorno = this.criaXML(r);
        }
        return retorno;
    }

    private String criaXML(Registro r) {
        if (r == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder("<faturamentoEletronico>");
        buf.append("<protocolo>").append(Resuline.getNomeProtocolo()).append("</protocolo>");
        buf.append("<").append(PATHFILERESULTADO).append(">").append(r.getValor(PATHFILERESULTADO).toString()).append("</").append(PATHFILERESULTADO).append(">");
        buf.append("</faturamentoEletronico>");
        return buf.toString();
    }

    private Registro parseDadosXML(String xml) {
        if (xml == null || Funcoes.textoVazio(xml)) {
            return null;
        }
        Registro reg = new Registro();
        reg.setValor("protocolo", Resuline.getNomeProtocolo());
        reg.setValor(PATHFILERESULTADO, StringUtil.getValor(xml, PATHFILERESULTADO));
        return reg;
    }

    private StringBuilder getSql(String codigosRequisicoes, String[] situacoes, boolean obterTotal, String guia) {
        StringBuilder buf = new StringBuilder();
        if (obterTotal) {
            buf.append("select count(1) as quantidade ");
        } else {
            buf.append("select a.fil_codigo as filial ");
            buf.append("      ,req.req_codigo AS requisicao ");
            buf.append("      ,a.exr_guia as guia ");
            buf.append("      ,req.req_matricula as matricula ");
            buf.append("      ,a.exa_codigo as exame ");
            buf.append("      ,a.mco_codigo as material ");
            if (ParametrosGerais.getPrecoMetodologia()) {
                buf.append("      ,dtm.dtm_codamb as procedimento ");
            } else {
                buf.append("      ,dtp.dtp_codamb as procedimento ");
            }
        }
        buf.append("  FROM examerequisicao AS a ");
        buf.append("  JOIN requisicao req ON a.req_codigo = req.req_codigo AND a.fil_codigo = req.fil_codigo ");
        buf.append("  JOIN convenios con ON req.con_codigo = con.con_codigo AND req.fil_codigo = con.fil_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("  LEFT JOIN detalhetabelaprecometodologia dtm on a.fil_codigo = dtm.fil_codigo and con.tpe_codigo = dtm.tpe_codigo and a.exa_codigo = dtm.exa_codigo and a.mco_codigo = dtm.mco_codigo and a.met_codigo = dtm.met_codigo ");
        } else {
            buf.append("  LEFT JOIN detalhetabelapreco dtp ON con.fil_codigo = dtp.fil_codigo  AND con.tpe_codigo = dtp.tpe_codigo AND a.exa_codigo = dtp.exa_codigo AND a.mco_codigo = dtp.mco_codigo ");
        }
        buf.append("  where req.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and req.req_codigo IN (").append(codigosRequisicoes).append(") ");
        buf.append("    and NOT req.req_excluida ");
        buf.append("    and NOT a.exr_excluido ");
        buf.append("    and a.exr_situacao IN (");
        for (int i = 0; i < situacoes.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(" '").append(situacoes[i]).append("' ");
        }
        buf.append(" ) ");
        if (!Funcoes.textoVazio(guia)) {
            buf.append(" and a.exr_guia ='").append(guia).append("' ");
        }
        if (!obterTotal) {
            buf.append("  group by a.fil_codigo ");
            buf.append("          ,req.req_codigo ");
            buf.append("          ,a.exr_guia ");
            buf.append("          ,req.req_matricula ");
            if (ParametrosGerais.getPrecoMetodologia()) {
                buf.append("          ,dtm.dtm_codamb ");
            } else {
                buf.append("          ,dtp.dtp_codamb ");
            }
            buf.append("          ,a.exa_codigo ");
            buf.append("          ,a.mco_codigo ");
            buf.append("  order by a.fil_codigo ");
            buf.append("          ,req.req_codigo ");
            buf.append("          ,a.exr_guia ");
            buf.append("          ,req.req_matricula ");
            if (ParametrosGerais.getPrecoMetodologia()) {
                buf.append("          ,dtm.dtm_codamb ");
            } else {
                buf.append("          ,dtp.dtp_codamb ");
            }
            buf.append("          ,a.exa_codigo ");
        }
        return buf;
    }

    private ArrayList<ArquivoFaturamentoEletronico> gerarArquivo(Object owner, ResultSet rs, int quantidadeExames, boolean criarArquivo) throws Exception {
        ArrayList<ArquivoFaturamentoEletronico> listaArquivos = criarArquivo ? null : new ArrayList<ArquivoFaturamentoEletronico>();
        HashSet<String> setChave = new HashSet<String>();
        XMLStringBuilder xmlStringBuilder = new XMLStringBuilder();
        String chaveTemp = "";
        String reqTemp = "";
        String filTemp = "";
        LinkedList<String> exames = new LinkedList<String>();
        LinkedList<String> materiais = new LinkedList<String>();
        if (rs.next()) {
            do {
                String chave;
                if (Funcoes.textoVazio(chave = rs.getString("guia") + "_" + rs.getString("requisicao")) || !this.permiteGerar(rs)) continue;
                boolean ultimaGuia = rs.isLast();
                if (setChave.contains(chaveTemp) && !chaveTemp.equals(chave) || ultimaGuia && quantidadeExames > 1) {
                    String nomeArquivos = chaveTemp;
                    if (ultimaGuia) {
                        xmlStringBuilder.escrever(TAG_PROCEDIMENTO, this.limparString(rs.getString("procedimento")));
                        exames.add(rs.getString("exame"));
                        materiais.add(rs.getString("material"));
                    }
                    xmlStringBuilder.fechar(TAG_PROCEDIMENTO);
                    xmlStringBuilder.abrir(TAG_ANEXO);
                    xmlStringBuilder.escrever(TAG_NOME_ANEXO, nomeArquivos + ".pdf");
                    xmlStringBuilder.fechar(TAG_ANEXO);
                    xmlStringBuilder.fechar(TAG_RESULTADO);
                    RetornoImpressaoResultados pdf = ImpressaoResultados.imprimirExames(null, null, filTemp, reqTemp, true, true, null, this.processaLinkedList(exames), this.processaLinkedList(materiais), true, this.config.getValor(PATHFILERESULTADO) + nomeArquivos + ".pdf", true, false, null, false, null, false, false);
                    if (criarArquivo) {
                        StringUtil.escreverArquivoTexto(this.config.getValor(PATHFILERESULTADO) + nomeArquivos + "." + Resuline.getExtensaoArquivo(), xmlStringBuilder.getXML(), new Resuline().getCodificacaoArquivo());
                        this.escrevePdfResultado(pdf.getResultadoPdfWeb(), this.config.getValor(PATHFILERESULTADO) + nomeArquivos + ".pdf");
                    } else {
                        listaArquivos.add(new ArquivoFaturamentoEletronico(this.config.getValor(PATHFILERESULTADO) + nomeArquivos + "." + Resuline.getExtensaoArquivo(), xmlStringBuilder.getXML()));
                        listaArquivos.add(new ArquivoFaturamentoEletronico(this.config.getValor(PATHFILERESULTADO) + nomeArquivos + ".pdf", pdf.getResultadoPdfWeb()));
                    }
                    xmlStringBuilder = new XMLStringBuilder();
                    exames.clear();
                    materiais.clear();
                } else if (ultimaGuia && quantidadeExames == 1) {
                    xmlStringBuilder.escreveHeader("1.0", "ISO8859-1");
                    xmlStringBuilder.abrir(TAG_RESULTADO);
                    xmlStringBuilder.escrever(TAG_DATA, Funcoes.formataData("yyyyMMddHHmmss", Calendar.getInstance().getTime()));
                    xmlStringBuilder.escrever(TAG_GUIA, Funcoes.preencheZero(this.limparString(rs.getString("guia")), 18));
                    xmlStringBuilder.escrever(TAG_BENEFICIARIO, Funcoes.preencheZero(this.limparString(rs.getString("matricula")), 17));
                    xmlStringBuilder.abrir(TAG_PROCEDIMENTOS);
                    exames.add(rs.getString("exame"));
                    materiais.add(rs.getString("material"));
                    xmlStringBuilder.escrever(TAG_PROCEDIMENTO, this.limparString(rs.getString("procedimento")));
                    xmlStringBuilder.fechar(TAG_PROCEDIMENTOS);
                    xmlStringBuilder.abrir(TAG_ANEXO);
                    xmlStringBuilder.escrever(TAG_NOME_ANEXO, chave + ".pdf");
                    xmlStringBuilder.fechar(TAG_ANEXO);
                    xmlStringBuilder.fechar(TAG_RESULTADO);
                    RetornoImpressaoResultados pdf = ImpressaoResultados.imprimirExames(null, null, rs.getString("filial"), rs.getString("requisicao"), true, true, null, this.processaLinkedList(exames), this.processaLinkedList(materiais), true, this.config.getValor(PATHFILERESULTADO) + chave + ".pdf", true, false, null, false, null, false, false);
                    if (criarArquivo) {
                        StringUtil.escreverArquivoTexto(this.config.getValor(PATHFILERESULTADO) + chave + "." + Resuline.getExtensaoArquivo(), xmlStringBuilder.getXML(), new Resuline().getCodificacaoArquivo());
                        this.escrevePdfResultado(pdf.getResultadoPdfWeb(), this.config.getValor(PATHFILERESULTADO) + chave + ".pdf");
                    } else {
                        listaArquivos.add(new ArquivoFaturamentoEletronico(this.config.getValor(PATHFILERESULTADO) + chave + "." + Resuline.getExtensaoArquivo(), xmlStringBuilder.getXML()));
                        listaArquivos.add(new ArquivoFaturamentoEletronico(this.config.getValor(PATHFILERESULTADO) + chave + ".pdf", pdf.getResultadoPdfWeb()));
                    }
                    xmlStringBuilder = new XMLStringBuilder();
                    exames.clear();
                }
                if (!setChave.contains(chave) && quantidadeExames > 1 && !ultimaGuia) {
                    xmlStringBuilder.escreveHeader("1.0", "ISO8859-1");
                    xmlStringBuilder.abrir(TAG_RESULTADO);
                    xmlStringBuilder.escrever(TAG_DATA, Funcoes.formataData("yyyyMMddHHmmss", Calendar.getInstance().getTime()));
                    xmlStringBuilder.escrever(TAG_GUIA, Funcoes.preencheZero(this.limparString(rs.getString("guia")), 18));
                    xmlStringBuilder.escrever(TAG_BENEFICIARIO, Funcoes.preencheZero(this.limparString(rs.getString("matricula")), 17));
                    xmlStringBuilder.abrir(TAG_PROCEDIMENTOS);
                    exames.add(rs.getString("exame"));
                    materiais.add(rs.getString("material"));
                    xmlStringBuilder.escrever(TAG_PROCEDIMENTO, this.limparString(rs.getString("procedimento")));
                } else if (setChave.contains(chave) && chaveTemp.equals(chave) && quantidadeExames > 1 && !ultimaGuia) {
                    exames.add(rs.getString("exame"));
                    materiais.add(rs.getString("material"));
                    xmlStringBuilder.escrever(TAG_PROCEDIMENTO, this.limparString(rs.getString("procedimento")));
                }
                setChave.add(chave);
                chaveTemp = chave;
                reqTemp = rs.getString("requisicao");
                filTemp = rs.getString("filial");
            } while (rs.next());
        } else {
            Funcoes.mensagem((JFrame)owner, "N\u00e3o existem dados para exportar.", 2);
        }
        return listaArquivos;
    }

    private String limparString(String valor) {
        return StringUtil.limpaString(valor, new String[]{".", "/", "\"", "-", "_", "+", ",", "*"});
    }

    private boolean permiteGerar(ResultSet rs) throws SQLException {
        StringBuilder erros = new StringBuilder();
        boolean permite = true;
        if (rs.getString("guia") == null || rs.getString("guia").isEmpty()) {
            erros.setLength(0);
            erros.append("H\u00e1 n\u00fameros de guias n\u00e3o informados na requisi\u00e7\u00e3o ").append(rs.getString("requisicao")).append(".\n");
            this.filtroMsg.add(erros.toString());
            permite = false;
        } else {
            String guia = StringUtil.limpaString(rs.getString("guia"), new String[]{".", "/", "\"", "-", "_", "+", ",", "*"});
            if (!Funcoes.isNumeric(guia)) {
                erros.setLength(0);
                erros.append("O n\u00famero da guia da requisi\u00e7\u00e3o ").append(rs.getString("requisicao")).append(" n\u00e3o cont\u00e9m apenas n\u00fameros, guia:").append(rs.getString("guia")).append(".\n");
                this.filtroMsg.add(erros.toString());
                permite = false;
            } else if (guia.length() > 18) {
                erros.setLength(0);
                erros.append("O n\u00famero da guia da requisi\u00e7\u00e3o ").append(rs.getString("requisicao")).append(" ultrapassa o limite de 18 d\u00edgitos, guia:").append(rs.getString("guia")).append(".\n");
                this.filtroMsg.add(erros.toString());
                permite = false;
            }
        }
        if (rs.getString("matricula") == null || rs.getString("matricula").isEmpty()) {
            erros.setLength(0);
            erros.append("O n\u00famero da matr\u00edcula da requisi\u00e7\u00e3o ").append(rs.getString("requisicao")).append(" n\u00e3o foi informado.").append("\n");
            this.filtroMsg.add(erros.toString());
            permite = false;
        } else {
            String matricula = StringUtil.limpaString(rs.getString("matricula"), new String[]{".", "/", "\"", "-", "_", "+", ",", "*"});
            if (!Funcoes.isNumeric(matricula)) {
                erros.setLength(0);
                erros.append("O n\u00famero da matr\u00edcula da requisi\u00e7\u00e3o ").append(rs.getString("requisicao")).append(" n\u00e3o cont\u00e9m apenas n\u00fameros, matr\u00edcula:").append(rs.getString("matricula")).append(".\n");
                this.filtroMsg.add(erros.toString());
                permite = false;
            } else if (matricula.length() > 17) {
                erros.setLength(0);
                erros.append("O n\u00famero da matr\u00edcula da requisi\u00e7\u00e3o ").append(rs.getString("requisicao")).append(" ultrapassa a quantidade de 17 d\u00edgitos, matr\u00edcula:").append(rs.getString("matricula")).append(".\n");
                this.filtroMsg.add(erros.toString());
                permite = false;
            }
        }
        if (rs.getString("procedimento") == null || rs.getString("procedimento").isEmpty()) {
            erros.setLength(0);
            erros.append("O c\u00f3digo AMB do exame ").append(rs.getString("exame")).append(" do material ").append(rs.getString("material")).append(" da requisi\u00e7\u00e3o ").append(rs.getString("requisicao")).append(" n\u00e3o foi informado para a tabela de pre\u00e7o do conv\u00eanio.").append("\n");
            this.filtroMsg.add(erros.toString());
            permite = false;
        } else {
            String procedimento = StringUtil.limpaString(rs.getString("procedimento"), new String[]{".", "/", "\"", "-", "_", "+", ",", "*"});
            if (!Funcoes.isNumeric(procedimento)) {
                erros.setLength(0);
                erros.append("O c\u00f3digo AMB do exame ").append(rs.getString("exame")).append(" do material ").append(rs.getString("material")).append(" da requisi\u00e7\u00e3o ").append(rs.getString("requisicao")).append(" n\u00e3o cont\u00e9m apenas n\u00fameros, c\u00f3digo: ").append(rs.getString("procedimento") == null ? "N\u00e3o informado." : rs.getString("procedimento")).append(".\n");
                this.filtroMsg.add(erros.toString());
                permite = false;
            } else if (procedimento.length() > 16) {
                erros.setLength(0);
                erros.append("O c\u00f3digo AMB do exame ").append(rs.getString("exame")).append(" do material ").append(rs.getString("material")).append(" da requisi\u00e7\u00e3o ").append(rs.getString("requisicao")).append(" ultrapassa o limite de 16 d\u00edgitos, c\u00f3digo: ").append(rs.getString("procedimento") == null ? "N\u00e3o informado." : rs.getString("procedimento")).append(".\n");
                this.filtroMsg.add(erros.toString());
                permite = false;
            }
        }
        return permite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void escrevePdfResultado(byte[] resultadoPdfWeb, String filePdf) throws IOException {
        File file = new File(filePdf);
        try (FileOutputStream fileWriter = null;){
            fileWriter = new FileOutputStream(file);
            fileWriter.write(resultadoPdfWeb);
        }
        System.gc();
    }

    private String[] processaLinkedList(LinkedList<String> dados) {
        if (dados != null) {
            String[] retorno = new String[dados.size()];
            for (int i = 0; i < retorno.length; ++i) {
                retorno[i] = dados.get(i);
            }
            return retorno;
        }
        return null;
    }

    @Override
    public boolean solicitarDiretorioNoInicio() {
        return false;
    }

    @Override
    public String[] situacoesPermitidasExame(String xml) {
        return new String[]{"C", "I", "E"};
    }

    @Override
    public boolean validarCasasDecimais() {
        return true;
    }

    @Override
    public String getCodificacaoArquivo() {
        return FaturamentoEletronico.CODIFICACAO.ISO_8859_1.codificacao;
    }

    @Override
    public void verificaErrosFatura(ArrayList<DadosFaturamento> requisicoes, Registro configuracaoConvenio) {
    }

    @Override
    public ArrayList<GuiaVirtual.Campo> getCamposObrigatorios(String versao) {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasSolicitados() {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasExecutados() {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampo> getCamposIncorretos(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasSolicitados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasExecutados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public Registro parseXMLConfiguracao(String xml) {
        Registro registro = new Registro();
        registro.setValor(PATHFILERESULTADO, StringUtil.getValor(xml, PATHFILERESULTADO));
        return registro;
    }

    @Override
    public boolean gravaAlteracoes(DadosFaturamento requisicao, String guia, Registro configuracao) {
        return false;
    }

    @Override
    public void preencheValoresCampos(DadosFaturamento requisicao, Registro configuracaoEletronico, String guia) {
    }

    @Override
    public void preencheValoresTabelas(DadosFaturamento requisicao, String guia) {
    }

    @Override
    public void getValoresPreenchidos(DadosFaturamento requisicao, ArrayList<DadosExameFaturamento> exames, Registro configuracaoEletronico) {
    }

    @Override
    public void aplicarModificacoesGerais(ArrayList<DadosFaturamento> requisicoes, DadosFaturamento requisicao, DadosFaturamento requisicaoModificada, Registro configuracaoEletronico, Registro configuracaoEletronicoModificada) {
    }

    public static String getNomeProtocolo() {
        return "Resuline";
    }

    @Override
    public Object[] getListaDadosAdicionais() {
        return null;
    }

    @Override
    public void setListaDadosAdicionais(Object[] listaDadosAdicionais) {
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampoBPA> getCamposIncorretosBPA(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<JanelaConfiguracaoFaturamentoBPA.CampoBPA> getCamposObrigatoriosBPA() {
        return null;
    }

    class MostraErrosIntegracaoResuline
    extends JDialog
    implements ActionListener {
        private JButton buttonOk;
        private JTextArea textErros;
        private JScrollPane scrollErros;

        public MostraErrosIntegracaoResuline(JFrame owner, Set<String> erros) {
            super((Frame)owner, "Erros integra\u00e7\u00e3o Resuline");
            this.buttonOk = ComponenteFactory.novoJButton("Ok", 'K', this, null, null);
            this.textErros = new JTextArea(new TTextAreaDocument(50000));
            this.scrollErros = new JScrollPane(this.textErros);
            this.setSize(new Dimension(710, 500));
            this.setLocationRelativeTo(owner);
            this.setModal(true);
            this.setResizable(false);
            JPanel panelCentro = new JPanel(new GridBagLayout());
            this.setLayout(new BorderLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 17;
            c.anchor = 17;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridheight = 1;
            c.gridwidth = 1;
            StringBuilder saida = new StringBuilder();
            saida.append("Os seguintes itens apresentaram problemas e n\u00e3o foram inclu\u00eddos nos arquivos de exporta\u00e7\u00e3o:\n");
            saida.append("-------------------------------------------------------------------------------\n\n");
            for (String erro : erros) {
                saida.append(erro.trim()).append("\n");
            }
            this.textErros.setPreferredSize(new Dimension(600, 350));
            this.textErros.setMinimumSize(new Dimension(600, 350));
            this.textErros.setEditable(false);
            this.textErros.setText(saida.toString());
            this.scrollErros.setMinimumSize(new Dimension(400, 350));
            this.scrollErros.setPreferredSize(new Dimension(400, 350));
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridheight = 1;
            c.gridwidth = 0;
            panelCentro.add((Component)this.scrollErros, c);
            c.weightx = 0.0;
            c.weighty = 0.0;
            JPanel panelBotoes = new JPanel(new FlowLayout(2));
            panelBotoes.add(this.buttonOk);
            c.anchor = 13;
            ++c.gridy;
            panelCentro.add((Component)panelBotoes, c);
            this.add(panelCentro);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.buttonOk) {
                this.setVisible(false);
            }
        }
    }

    class Configurar
    extends JDialog
    implements ActionListener {
        private JButton buttonSalvar;
        private JButton buttonCancelar;
        private TTextField textPathIntegracao;
        private JButton buttonPathIntegracao;
        private JFileChooser file;
        private boolean ok;

        public Configurar(JFrame owner) {
            super((Frame)owner, "Configurando Resuline");
            this.buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this, null, null);
            this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
            this.textPathIntegracao = new TTextField(100);
            this.buttonPathIntegracao = ComponenteFactory.novoJButton(this, true);
            this.file = ComponenteFactory.novoJFileChooser();
            this.ok = false;
            this.setSize(new Dimension(400, 95));
            this.setLocationRelativeTo(owner);
            this.setModal(true);
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            JPanel panelCentro = new JPanel(new GridBagLayout());
            this.setLayout(new BorderLayout());
            this.file.setFileSelectionMode(1);
            this.textPathIntegracao.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String separador = System.getProperty("file.separator");
                    if (!Funcoes.textoVazio(Configurar.this.textPathIntegracao) && !Configurar.this.textPathIntegracao.getText().endsWith(separador)) {
                        Configurar.this.textPathIntegracao.setText(Configurar.this.textPathIntegracao.getText() + separador);
                    }
                }
            });
            this.textPathIntegracao.setEnabled(false);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 17;
            c.anchor = 17;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.insets = new Insets(1, 1, 0, 0);
            JLabel jLabel = new JLabel("Caminho de resultados:");
            jLabel.setPreferredSize(new Dimension(150, 20));
            panelCentro.add((Component)jLabel, c);
            c.fill = 2;
            ++c.gridx;
            c.weightx = 1.0;
            panelCentro.add((Component)this.textPathIntegracao, c);
            c.weightx = 0.0;
            this.buttonPathIntegracao.setPreferredSize(new Dimension(20, 20));
            this.buttonPathIntegracao.setMinimumSize(new Dimension(20, 20));
            c.fill = 17;
            ++c.gridx;
            c.weightx = 0.0;
            c.insets = new Insets(1, 1, 0, 1);
            panelCentro.add((Component)this.buttonPathIntegracao, c);
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridheight = 1;
            c.gridwidth = 3;
            ++c.gridy;
            c.gridx = 0;
            c.fill = 1;
            panelCentro.add((Component)new JLabel(), c);
            JPanel panelBotoes = new JPanel(new FlowLayout(2));
            panelBotoes.add(this.buttonSalvar);
            panelBotoes.add(this.buttonCancelar);
            c.anchor = 17;
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridheight = 1;
            c.gridwidth = 3;
            c.gridx = 0;
            c.fill = 2;
            panelCentro.add((Component)panelBotoes, c);
            this.add(panelCentro);
        }

        public String getPathFileResultado() {
            String path = this.textPathIntegracao.getText();
            path = path.replaceAll("\\\\", "\u00a2");
            path = path.replaceAll("\u00a2+", "\\\\");
            return path;
        }

        private void buscarPath() {
            JFileChooser file = ComponenteFactory.novoJFileChooser("Diret\u00f3rio de integra\u00e7\u00e3o");
            if (!Funcoes.textoVazio(this.textPathIntegracao.getText()) && Funcoes.diretorioExiste(this.textPathIntegracao.getText())) {
                file.setCurrentDirectory(new File(this.textPathIntegracao.getText()));
            }
            file.setFileSelectionMode(1);
            if (file.showOpenDialog(this) == 0) {
                String path = file.getSelectedFile().getAbsolutePath();
                String separador = System.getProperty("file.separator");
                if (!Funcoes.textoVazio(path) && !path.endsWith(separador)) {
                    path = path + separador;
                }
                this.textPathIntegracao.setText(path);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.buttonSalvar) {
                if (Funcoes.textoVazio(this.textPathIntegracao.getText())) {
                    Funcoes.mensagem(this, "Informe o caminho dos resultados.", 2);
                    ScreenUtil.requisitarFoco(this.buttonPathIntegracao);
                    return;
                }
                String separador = System.getProperty("file.separator");
                if (!Funcoes.textoVazio(this.textPathIntegracao) && !this.textPathIntegracao.getText().endsWith(separador)) {
                    this.textPathIntegracao.setText(this.textPathIntegracao.getText() + separador);
                }
                this.ok = true;
                this.setVisible(false);
            } else if (e.getSource() == this.buttonPathIntegracao) {
                this.buscarPath();
            } else {
                this.setVisible(false);
            }
        }

        public boolean ok() {
            return this.ok;
        }

        public void setXML(Registro r) {
            String path;
            if (r != null && !Funcoes.textoVazio(path = r.getString(Resuline.PATHFILERESULTADO))) {
                path = path.replace("\\\\", "\\");
                this.textPathIntegracao.setText(path);
            }
        }
    }
}

