/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ArquivoFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ConfigurarPlanserv;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.GuiaVirtual;
import jalis.laboratorio.util.faturamento.eletronico.JanelaConfiguracaoFaturamentoBPA;
import jalis.util.ConvenioUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Time;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class Planserv
extends AbstractFaturamentoEletronico
implements FaturamentoEletronico {
    Registro config = null;
    StringBuilder conteudo = new StringBuilder();
    private int contador = 1;
    private int contadorItem = 1;
    private int contadorConta = 1;
    private BigDecimal somatorioItens = BigDecimal.ZERO;
    private BigDecimal somatorioContas = BigDecimal.ZERO;
    private static final String[] CARACTERES_PROIBIDOS = new String[]{",", ".", "/", "-"};
    private int casasDecimais = 2;
    private RoundingMode arredondamento = RoundingMode.HALF_UP;
    private static final String SERVICO = "TSCM";
    private ArrayList<String> examesSemAmb = new ArrayList();
    private final Campos HEADER_SERVICO = new Campos(1, 4, "S");
    private final Campos HEADER_CODIGO_REGISTRO = new Campos(5, 5, "N");
    private final Campos HEADER_FILLER1 = new Campos(6, 28, "N");
    private final Campos HEADER_CODIGO_CONVENIO = new Campos(29, 33, "N");
    private final Campos HEADER_NOME_CONVENIO = new Campos(34, 63, "S", false);
    private final Campos HEADER_TIPO_PRESTADOR = new Campos(64, 64, "S");
    private final Campos HEADER_CODIGO_OPERADORA = new Campos(65, 76, "S");
    private final Campos HEADER_FILLER2 = new Campos(77, 78, "S");
    private final Campos HEADER_NOME_PRESTADOR = new Campos(79, 118, "S", false);
    private final Campos HEADER_DATA_GERACAO = new Campos(119, 126, "D");
    private final Campos HEADER_NUMERO_REMESSA = new Campos(127, 131, "N");
    private final Campos HEADER_VERSAO_LAYOUT = new Campos(132, 132, "S");
    private final Campos HEADER_FILLER3 = new Campos(133, 294, "S");
    private final Campos HEADER_NUMERO_REGISTRO = new Campos(295, 300, "N");
    private final Campos CONTA_SERVICO = new Campos(1, 4, "S");
    private final Campos CONTA_CODIGO_REGISTRO = new Campos(5, 5, "N");
    private final Campos CONTA_FILLER1 = new Campos(6, 14, "N");
    private final Campos CONTA_NUMERO_DOCUMENTO = new Campos(15, 24, "S");
    private final Campos CONTA_FILLER2 = new Campos(25, 26, "S");
    private final Campos CONTA_NUMERO_PARCELA = new Campos(27, 28, "N");
    private final Campos CONTA_CODIGO_PLANO = new Campos(29, 31, "S");
    private final Campos CONTA_CODIGO_BENEFICIARIO = new Campos(32, 49, "S");
    private final Campos CONTA_SENHA_AUTORIZACAO = new Campos(50, 59, "N");
    private final Campos CONTA_CODIGO_ACOMODACAO = new Campos(60, 60, "N");
    private final Campos CONTA_DATA_ENTRADA = new Campos(61, 68, "D");
    private final Campos CONTA_HORA_ENTRADA = new Campos(69, 72, "H");
    private final Campos CONTA_DATA_SAIDA = new Campos(73, 80, "D");
    private final Campos CONTA_HORA_SAIDA = new Campos(81, 84, "H");
    private final Campos CONTA_DATA_INICIO_COBRANCA = new Campos(85, 92, "D");
    private final Campos CONTA_DATA_FIM_COBRANCA = new Campos(93, 100, "D");
    private final Campos CONTA_CODIGO_ATENDIMENTO = new Campos(101, 101, "S");
    private final Campos CONTA_CODIGO_CID = new Campos(102, 107, "S");
    private final Campos CONTA_CODIGO_SERVICO_PRINCIPAL = new Campos(108, 115, "S");
    private final Campos CONTA_CRM_RESPONSAVEL = new Campos(116, 123, "N");
    private final Campos CONTA_UF_CRM = new Campos(124, 125, "S");
    private final Campos CONTA_CRM_SOLICITANTE = new Campos(126, 133, "N");
    private final Campos CONTA_UF_CRM_SOLICITANTE = new Campos(134, 135, "S");
    private final Campos CONTA_TIPO_ALTA = new Campos(136, 136, "N");
    private final Campos CONTA_INDICA_PN = new Campos(137, 137, "B");
    private final Campos CONTA_DATA_SOLICITACAO = new Campos(138, 145, "D");
    private final Campos CONTA_TIPO_PARTO = new Campos(146, 146, "S");
    private final Campos CONTA_TIPO_RECEM_NASCIDO = new Campos(147, 147, "S");
    private final Campos CONTA_TIPO_PACIENTE = new Campos(148, 149, "S");
    private final Campos CONTA_INDICA_CARATER = new Campos(150, 150, "S");
    private final Campos CONTA_CODIGO_LOCAL_EXECUCAO = new Campos(151, 165, "S");
    private final Campos CONTA_NUMERO_NR = new Campos(166, 177, "S");
    private final Campos CONTA_BIOMETRIA = new Campos(178, 187, "S");
    private final Campos CONTA_HORA_INICIO_PERIODO = new Campos(188, 191, "H");
    private final Campos CONTA_HORA_FIM_PERIODO = new Campos(192, 195, "H");
    private final Campos CONTA_CODIGO_EMPRESA_AUDITORIA = new Campos(196, 197, "N");
    private final Campos CONTA_NUMERO_RAT = new Campos(198, 207, "S");
    private final Campos CONTA_FILLER3 = new Campos(208, 274, "S");
    private final Campos CONTA_LIVRE = new Campos(275, 294, "S", false);
    private final Campos CONTA_NUMERO_REGISTRO = new Campos(295, 300, "N");
    private final Campos ITEM_SERVICO = new Campos(1, 4, "S");
    private final Campos ITEM_CODIGO_REGISTRO = new Campos(5, 5, "N");
    private final Campos ITEM_FILLER1 = new Campos(6, 14, "N");
    private final Campos ITEM_NUMERO_DOCUMENTO = new Campos(15, 24, "S");
    private final Campos ITEM_FILLER2 = new Campos(25, 26, "S");
    private final Campos ITEM_NUMERO_PARCELA = new Campos(27, 28, "N");
    private final Campos ITEM_NUMERO_ITEM = new Campos(29, 33, "N");
    private final Campos ITEM_CODIGO_SERVICO = new Campos(34, 41, "N");
    private final Campos ITEM_NOME_SERVICO = new Campos(42, 91, "S", false);
    private final Campos ITEM_EMERGENCIA = new Campos(92, 92, "B");
    private final Campos ITEM_DHE = new Campos(93, 93, "B");
    private final Campos ITEM_DATA_REALIZACAO = new Campos(94, 101, "D");
    private final Campos ITEM_CODIGO_POSICAO = new Campos(102, 102, "N");
    private final Campos ITEM_QUANTIDADE_EXECUTADA = new Campos(103, 107, "N");
    private final Campos ITEM_VALOR_ITEM = new Campos(108, 122, "N");
    private final Campos ITEM_CIRURGIA_MULTIPLA_RADIOLOGIA = new Campos(123, 125, "N");
    private final Campos ITEM_CRM_RESPONSAVEL = new Campos(126, 133, "N");
    private final Campos ITEM_UF_CRM = new Campos(134, 135, "S");
    private final Campos ITEM_INDICADOR_UTI = new Campos(136, 136, "B");
    private final Campos ITEM_ESPECIALIDADE_CONSULTA_VISITA = new Campos(137, 138, "N");
    private final Campos ITEM_VALOR_FILME = new Campos(139, 153, "N");
    private final Campos ITEM_VALOR_PROCEDIMENTO = new Campos(154, 168, "N");
    private final Campos ITEM_VALOR_CUSTO_ADMINISTRACAO = new Campos(169, 183, "N");
    private final Campos ITEM_FILLER3 = new Campos(184, 274, "S");
    private final Campos ITEM_LIVRE = new Campos(275, 294, "S", false);
    private final Campos ITEM_NUMERO_REGISTRO = new Campos(295, 300, "N");
    private final Campos TOTAL_SERVICO = new Campos(1, 4, "S");
    private final Campos TOTAL_CODIGO_REGISTRO = new Campos(5, 5, "N");
    private final Campos TOTAL_FILLER1 = new Campos(6, 14, "N");
    private final Campos TOTAL_NUMERO_DOCUMENTO = new Campos(15, 24, "S");
    private final Campos TOTAL_FILLER2 = new Campos(25, 26, "S");
    private final Campos TOTAL_NUMERO_PARCELA = new Campos(27, 28, "N");
    private final Campos TOTAL_QUANTIDADE_ITENS = new Campos(29, 33, "N");
    private final Campos TOTAL_VALOR_CONTA = new Campos(34, 48, "N");
    private final Campos TOTAL_NOME_BENEFICIARIO = new Campos(49, 88, "S", false);
    private final Campos TOTAL_QUANTIDADE_MATERIAL_MEDICAMENTO = new Campos(89, 93, "N");
    private final Campos TOTAL_FILLER3 = new Campos(94, 274, "S");
    private final Campos TOTAL_LIVRE = new Campos(275, 294, "S", false);
    private final Campos TOTAL_NUMERO_REGISTRO = new Campos(295, 300, "N");
    private final Campos TRAILLER_SERVICO = new Campos(1, 4, "S");
    private final Campos TRAILLER_CODIGO_REGISTRO = new Campos(5, 5, "N");
    private final Campos TRAILLER_FILLER1 = new Campos(6, 28, "N");
    private final Campos TRAILLER_QUANTIDADE_CONTAS = new Campos(29, 33, "N");
    private final Campos TRAILLER_VALOR_CONTAS = new Campos(34, 48, "N");
    private final Campos TRAILLER_FILLER2 = new Campos(49, 294, "S");
    private final Campos TRAILLER_NUMERO_REGISTRO = new Campos(295, 300, "N");
    private PreparedStatement psFatura = null;
    private PreparedStatement psRequisicao = null;
    private PreparedStatement psExame = null;

    public Planserv() {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fre.req_codigo ");
        buf.append("       ,fre.fil_kodigo as fil_codigo ");
        buf.append("   from faturarequisicao fre ");
        buf.append("   join fatura           fat on fre.fil_codigo = fat.fil_codigo and fre.fat_codigo = fat.fat_codigo ");
        buf.append("   join requisicao       req on fre.fil_kodigo = req.fil_codigo and fre.req_codigo = req.req_codigo ");
        buf.append("  where fre.fil_codigo = ? ");
        buf.append("    and fre.fat_codigo = ? ");
        buf.append("    and fat.fat_datacancelamento is null ");
        buf.append("    and not req.req_excluida ");
        this.psFatura = Conexao.getPreparedStatement(buf.toString());
        buf.setLength(0);
        buf.append(" select req.req_codigo ");
        buf.append("       ,req.req_data ");
        buf.append("       ,req.req_hora ");
        buf.append("       ,req.med_crm ");
        buf.append("       ,req.med_uf ");
        buf.append("       ,pac.pac_nome ");
        buf.append("       ,req.req_matricula ");
        buf.append("       ,req.req_guia ");
        buf.append("       ,(select c10.c10_codigo ");
        buf.append("           from requisicaocid10 c10 ");
        buf.append("          where req.fil_codigo = c10.fil_codigo ");
        buf.append("            and req.req_codigo = c10.req_codigo ");
        buf.append("          limit 1) as cid10 ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("       ,(select dtm.dtm_codamb as dtp_codamb ");
            buf.append("           from detalhetabelaprecometodologia dtm ");
            buf.append("           join convenios con on con.fil_codigo = dtm.fil_codigo and con.tpe_codigo = dtm.tpe_codigo ");
            buf.append("           join examerequisicao exr on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo and exr.exa_codigo = dtm.exa_codigo and exr.mco_codigo = dtm.mco_codigo and dtm.met_codigo = exr.met_codigo ");
            buf.append("          where req.fil_codigo = con.fil_codigo ");
            buf.append("            and req.con_codigo = con.con_codigo limit 1) as ambprincipal ");
        } else {
            buf.append("       ,(select dtp.dtp_codamb ");
            buf.append("           from detalhetabelapreco dtp ");
            buf.append("           join convenios con on con.fil_codigo = dtp.fil_codigo and con.tpe_codigo = dtp.tpe_codigo ");
            buf.append("           join examerequisicao exr on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo and exr.exa_codigo = dtp.exa_codigo and exr.mco_codigo = dtp.mco_codigo ");
            buf.append("          where req.fil_codigo = con.fil_codigo ");
            buf.append("            and req.con_codigo = con.con_codigo limit 1) as ambprincipal ");
        }
        buf.append("   from requisicao req ");
        buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("  where req.fil_codigo = ? ");
        buf.append("    and req.req_codigo = ? ");
        buf.append("    and not req.req_excluida ");
        this.psRequisicao = Conexao.getPreparedStatement(buf.toString());
        buf.setLength(0);
        buf.append(" select req.req_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("       ,dtm.dtm_codamb as dtp_codamb ");
        } else {
            buf.append("       ,det.dtp_codamb ");
        }
        buf.append("       ,exa.exa_descricao ");
        buf.append("       ,exa.exa_codigo ");
        buf.append("       ,req.req_data ");
        buf.append("       ,fer.fer_total ");
        buf.append("   from faturarequisicao fre ");
        buf.append("   join faturaexamerequisicao fer on fre.fil_codigo = fer.fil_codigo and fre.fat_codigo = fer.fat_codigo and fre.req_codigo = fer.req_codigo and fre.fil_kodigo = fer.fil_kodigo ");
        buf.append("   join requisicao req on fre.fil_kodigo = req.fil_codigo and fre.req_codigo = req.req_codigo ");
        buf.append("   join examerequisicao exr on fer.fil_kodigo = exr.fil_codigo and fer.req_codigo = exr.req_codigo and fer.exa_codigo = exr.exa_codigo and fer.mco_codigo = exr.mco_codigo ");
        buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("   join detalhetabelaprecometodologia dtm on req.fil_codigo = dtm.fil_codigo and con.tpe_codigo = dtm.tpe_codigo and fer.exa_codfilho = dtm.exa_codigo and fer.mco_codfilho = dtm.mco_codigo and exr.met_codigo = dtm.met_codigo ");
        } else {
            buf.append("   join detalhetabelapreco det on req.fil_codigo = det.fil_codigo and con.tpe_codigo = det.tpe_codigo and fer.exa_codfilho = det.exa_codigo and fer.mco_codfilho = det.mco_codigo ");
        }
        buf.append("   join exames exa on fre.fil_kodigo = exa.fil_codigo and fer.exa_codfilho = exa.exa_codigo ");
        buf.append("  where fre.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and fre.fil_kodigo = ? ");
        buf.append("    and fre.req_codigo = ? ");
        buf.append("    and fre.fat_codigo = ? ");
        buf.append("    and exr.exr_excluido = false ");
        this.psExame = Conexao.getPreparedStatement(buf.toString());
    }

    private String substring(String str, int tamanho) {
        return str.substring(0, str.length() > tamanho ? tamanho : str.length());
    }

    private String getValor(Object valor, Campos campo) throws Exception {
        if (campo == null) {
            throw new Exception("Campo n\u00e3o informado.");
        }
        if (valor == null) {
            if (campo.tipo.equalsIgnoreCase("N") || campo.tipo.equalsIgnoreCase("H")) {
                return Funcoes.preencheZero(0, campo.tamanho);
            }
            return Funcoes.preencheVazio(" ", campo.tamanho, 1);
        }
        if (campo.tipo.equalsIgnoreCase("N")) {
            if (valor instanceof Integer || valor instanceof Double || valor instanceof BigDecimal) {
                String aux = StringUtil.limpaString(valor.toString(), CARACTERES_PROIBIDOS);
                return this.substring(Funcoes.preencheZero(aux, campo.tamanho), campo.tamanho);
            }
            throw new Exception("Valor inteiro incorreto");
        }
        if (campo.tipo.equalsIgnoreCase("S")) {
            if (valor instanceof String) {
                valor = StringUtil.limpaString(valor.toString(), CARACTERES_PROIBIDOS);
                return this.substring(Funcoes.preencheVazio(valor.toString(), campo.tamanho, 2), campo.tamanho);
            }
            throw new Exception("Valor 'string' incorreto");
        }
        if (campo.tipo.equalsIgnoreCase("D")) {
            if (valor instanceof Date) {
                return this.substring(Funcoes.formataData("ddMMyyyy", (Date)valor), campo.tamanho);
            }
            throw new Exception("Valor data incorreto");
        }
        if (campo.tipo.equalsIgnoreCase("H")) {
            if (valor instanceof Date) {
                return this.substring(Funcoes.formataData("HHmm", (Date)valor), campo.tamanho);
            }
            if (valor instanceof Time) {
                return this.substring(Funcoes.formataData("HHmm", (Time)valor), campo.tamanho);
            }
            throw new Exception("Valor hora incorreto");
        }
        if (campo.tipo.equalsIgnoreCase("B")) {
            if (valor instanceof Boolean) {
                return this.substring((Boolean)valor != false ? "S" : "N", campo.tamanho);
            }
            throw new Exception("Varlo 'SIM/N\u00c3O' incorreto");
        }
        throw new Exception("Tipo de dados desconhecido.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<ArquivoFaturamentoEletronico> criarArquivo(Object owner, int codigoFatura, String codigoConvenio, String diretorioArquivos) {
        ArrayList<ArquivoFaturamentoEletronico> retorno;
        Statement st;
        block7: {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            retorno = new ArrayList<ArquivoFaturamentoEletronico>();
            try {
                buf.append(" select fat.con_codigo  ");
                buf.append("       ,con.con_faturaeletronica ");
                buf.append("   from fatura    fat ");
                buf.append("   join convenios con on fat.fil_codigo = con.fil_codigo and fat.con_codigo = con.con_codigo ");
                buf.append("  where fat.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and fat.fat_codigo = ").append(codigoFatura);
                buf.append("    and fat.fat_datacancelamento is null ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (rs.next()) {
                    this.config = this.parseXMLConfiguracao(rs.getString("con_faturaeletronica"));
                    this.config.setValor("con_codigo", rs.getString("con_codigo"));
                }
                if (this.config == null) break block7;
                retorno = this.gerarArquivo(owner, st, codigoFatura, codigoConvenio);
                buf.delete(0, buf.length());
                buf.append(" update convenios ");
                buf.append("    set con_faturaeletronica = '").append(StringUtil.textoDB(this.registroToXML(this.config))).append("' ");
                buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and con_codigo = ").append(this.config.getValor("con_codigo"));
                Conexao.execute(Variaveis.filialPadrao, st, buf);
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private ArrayList<ArquivoFaturamentoEletronico> gerarArquivo(Object parent, Statement st, int codigoFatura, String codigoConvenio) throws Exception {
        if (this.config == null) {
            throw new Exception("XML de configura\u00e7\u00e3o n\u00e3o informado");
        }
        this.escreveHeader();
        this.psFatura.setInt(1, Integer.parseInt(Variaveis.filialPadrao));
        this.psFatura.setInt(2, codigoFatura);
        ResultSet rsFatura = this.psFatura.executeQuery();
        while (rsFatura.next()) {
            DadosConvenios dadosConvenios = ConvenioUtil.getDadosConvenios(rsFatura.getString("fil_codigo"), Integer.parseInt(codigoConvenio));
            if (!Funcoes.objectIsNull(dadosConvenios) && dadosConvenios.getConvenioUtilizarCasasDecimais()) {
                this.casasDecimais = dadosConvenios.getConvenioCasasPrecoExame();
                this.arredondamento = dadosConvenios.getConvenioTipoArredondamentoPrecoRoundingMode();
            }
            this.psRequisicao.setInt(1, rsFatura.getInt("fil_codigo"));
            this.psRequisicao.setInt(2, rsFatura.getInt("req_codigo"));
            ResultSet rsRequisicao = this.psRequisicao.executeQuery();
            while (rsRequisicao.next()) {
                this.escreveCabecalhoConta(rsRequisicao);
                this.psExame.setInt(1, rsFatura.getInt("fil_codigo"));
                this.psExame.setInt(2, rsFatura.getInt("req_codigo"));
                this.psExame.setInt(3, codigoFatura);
                ResultSet rsExame = this.psExame.executeQuery();
                while (rsExame.next()) {
                    this.escreveItemConta(rsExame);
                }
                this.escreveTotalConta(rsRequisicao);
            }
        }
        this.escreveTraillerRemessa();
        int aux = (Integer)this.config.getValor("sequencialArquivo");
        aux = aux <= 0 ? 1 : aux;
        StringBuilder nomeArquivo = new StringBuilder();
        nomeArquivo.append("PL");
        nomeArquivo.append(this.config.getValor("codigoPrestadorOperadora"));
        nomeArquivo.append("_");
        nomeArquivo.append(Funcoes.formataData("ddMMyy", new java.util.Date()));
        nomeArquivo.append("_");
        nomeArquivo.append(aux);
        ArrayList<ArquivoFaturamentoEletronico> retorno = new ArrayList<ArquivoFaturamentoEletronico>();
        retorno.add(new ArquivoFaturamentoEletronico(nomeArquivo.toString(), this.conteudo.toString()));
        int numeroRemessa = (Integer)this.config.getValor("numeroRemessa");
        this.config.setValor("numeroRemessa", ++numeroRemessa);
        this.config.setValor("sequencialArquivo", ++aux);
        if (this.examesSemAmb.isEmpty()) {
            return retorno;
        }
        Funcoes.mensagem(Laboratorio.getInstancia(), "Existe exames sem o codigo AMB, informado \t ou c\u00f3digo AMB incorreto \n" + this.examesSemAmb.toString(), 2);
        return null;
    }

    private void escreveHeader() throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es do faturamento eletr\u00f4nico n\u00e3o foram carregadas.", 2);
            return;
        }
        if (((String)this.config.getValor("versao")).equalsIgnoreCase(String.valueOf(2))) {
            StringBuilder aux = new StringBuilder();
            aux.append(this.getValor(SERVICO, this.HEADER_SERVICO));
            aux.append(this.getValor(TipoRegistro.HEADER.codigo, this.HEADER_CODIGO_REGISTRO));
            aux.append(this.getValor(null, this.HEADER_FILLER1));
            aux.append(this.getValor(null, this.HEADER_CODIGO_CONVENIO));
            aux.append(this.getValor("PLANSERV", this.HEADER_NOME_CONVENIO));
            aux.append(this.getValor(this.config.getValor("tipoPrestador"), this.HEADER_TIPO_PRESTADOR));
            aux.append(this.getValor(this.config.getValor("codigoPrestadorOperadora"), this.HEADER_CODIGO_OPERADORA));
            aux.append(this.getValor(null, this.HEADER_FILLER2));
            aux.append(this.getValor((String)this.config.getValor("nomePrestador"), this.HEADER_NOME_PRESTADOR));
            aux.append(this.getValor(new Date(new java.util.Date().getTime()), this.HEADER_DATA_GERACAO));
            aux.append(this.getValor(this.config.getValor("numeroRemessa"), this.HEADER_NUMERO_REMESSA));
            aux.append(this.getValor(this.config.getValor("versao"), this.HEADER_VERSAO_LAYOUT));
            aux.append(this.getValor(null, this.HEADER_FILLER3));
            aux.append(this.getValor(this.contador++, this.HEADER_NUMERO_REGISTRO));
            this.conteudo.append((CharSequence)aux);
        }
        this.conteudo.append("\n");
    }

    private void escreveCabecalhoConta(ResultSet rs) throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es do faturamento eletr\u00f4nico n\u00e3o foram carregadas.", 2);
            return;
        }
        if (((String)this.config.getValor("versao")).equalsIgnoreCase(String.valueOf(2))) {
            this.contadorItem = 1;
            this.somatorioItens = BigDecimal.ZERO;
            StringBuilder aux = new StringBuilder();
            aux.append(this.getValor(SERVICO, this.CONTA_SERVICO));
            aux.append(this.getValor(TipoRegistro.CABECALHO_CONTA.codigo, this.CONTA_CODIGO_REGISTRO));
            aux.append(this.getValor(null, this.CONTA_FILLER1));
            aux.append(this.getValor(rs.getString("req_codigo"), this.CONTA_NUMERO_DOCUMENTO));
            aux.append(this.getValor(null, this.CONTA_FILLER2));
            aux.append(this.getValor(1, this.CONTA_NUMERO_PARCELA));
            aux.append(this.getValor(null, this.CONTA_CODIGO_PLANO));
            String matricula = StringUtil.limpaString(rs.getString("req_matricula") == null || Funcoes.textoVazio(rs.getString("req_matricula")) ? "0" : rs.getString("req_matricula"), CARACTERES_PROIBIDOS);
            aux.append(this.getValor(matricula, this.CONTA_CODIGO_BENEFICIARIO));
            aux.append(this.getValor(null, this.CONTA_SENHA_AUTORIZACAO));
            aux.append(this.getValor(null, this.CONTA_CODIGO_ACOMODACAO));
            aux.append(this.getValor(rs.getDate("req_data"), this.CONTA_DATA_ENTRADA));
            aux.append(this.getValor(rs.getTime("req_hora"), this.CONTA_HORA_ENTRADA));
            aux.append(this.getValor(rs.getDate("req_data"), this.CONTA_DATA_SAIDA));
            aux.append(this.getValor(rs.getTime("req_hora"), this.CONTA_HORA_SAIDA));
            aux.append(this.getValor(rs.getDate("req_data"), this.CONTA_DATA_INICIO_COBRANCA));
            aux.append(this.getValor(rs.getDate("req_data"), this.CONTA_DATA_FIM_COBRANCA));
            aux.append(this.getValor(TipoAtendimento.SADT.codigo, this.CONTA_CODIGO_ATENDIMENTO));
            aux.append(this.getValor(rs.getString("cid10"), this.CONTA_CODIGO_CID));
            aux.append(this.getValor(rs.getString("ambprincipal"), this.CONTA_CODIGO_SERVICO_PRINCIPAL));
            aux.append(this.getValor(Integer.parseInt((String)this.config.getValor("crmResponsavel")), this.CONTA_CRM_RESPONSAVEL));
            aux.append(this.getValor((String)this.config.getValor("ufCRMResponsavel"), this.CONTA_UF_CRM));
            aux.append(this.getValor(rs.getInt("med_crm"), this.CONTA_CRM_SOLICITANTE));
            aux.append(this.getValor(rs.getString("med_uf"), this.CONTA_UF_CRM_SOLICITANTE));
            aux.append(this.getValor(null, this.CONTA_TIPO_ALTA));
            aux.append(this.getValor(false, this.CONTA_INDICA_PN));
            aux.append(this.getValor(rs.getDate("req_data"), this.CONTA_DATA_SOLICITACAO));
            aux.append(this.getValor(null, this.CONTA_TIPO_PARTO));
            aux.append(this.getValor(null, this.CONTA_TIPO_RECEM_NASCIDO));
            aux.append(this.getValor(String.valueOf(TipoPaciente.MEDICINA_ASSISTENCIAL.codigo), this.CONTA_TIPO_PACIENTE));
            aux.append(this.getValor(String.valueOf(TipoCarater.NAO_INFORMADO.codigo), this.CONTA_INDICA_CARATER));
            aux.append(this.getValor(null, this.CONTA_CODIGO_LOCAL_EXECUCAO));
            aux.append(this.getValor(null, this.CONTA_NUMERO_NR));
            if (((String)this.config.getValor("guiaComoBiometria")).equalsIgnoreCase("T")) {
                aux.append(this.getValor(rs.getString("req_guia"), this.CONTA_BIOMETRIA));
            } else {
                aux.append(this.getValor(null, this.CONTA_BIOMETRIA));
            }
            aux.append(this.getValor(rs.getTime("req_hora"), this.CONTA_HORA_INICIO_PERIODO));
            aux.append(this.getValor(rs.getTime("req_hora"), this.CONTA_HORA_FIM_PERIODO));
            aux.append(this.getValor(Integer.parseInt(this.config.getValor("codigoEmpresaAuditoria").toString()), this.CONTA_CODIGO_EMPRESA_AUDITORIA));
            aux.append(this.getValor((String)this.config.getValor("numeroRat"), this.CONTA_NUMERO_RAT));
            aux.append(this.getValor(null, this.CONTA_FILLER3));
            aux.append(this.getValor(null, this.CONTA_LIVRE));
            aux.append(this.getValor(this.contador++, this.CONTA_NUMERO_REGISTRO));
            this.conteudo.append((CharSequence)aux);
            ++this.contadorConta;
        }
        this.conteudo.append("\n");
    }

    private void escreveItemConta(ResultSet rs) throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es do faturamento eletr\u00f4nico n\u00e3o foram carregadas.", 2);
            return;
        }
        if (((String)this.config.getValor("versao")).equalsIgnoreCase(String.valueOf(2))) {
            BigDecimal valorItem = rs.getBigDecimal("fer_total");
            this.somatorioItens = this.somatorioItens.add(valorItem);
            valorItem = valorItem.setScale(this.casasDecimais, this.arredondamento);
            StringBuilder aux = new StringBuilder();
            aux.append(this.getValor(SERVICO, this.ITEM_SERVICO));
            aux.append(this.getValor(TipoRegistro.ITEM_CONTA.codigo, this.ITEM_CODIGO_REGISTRO));
            aux.append(this.getValor(null, this.ITEM_FILLER1));
            aux.append(this.getValor(rs.getString("req_codigo"), this.ITEM_NUMERO_DOCUMENTO));
            aux.append(this.getValor(null, this.ITEM_FILLER2));
            aux.append(this.getValor(1, this.ITEM_NUMERO_PARCELA));
            aux.append(this.getValor(this.contadorItem++, this.ITEM_NUMERO_ITEM));
            String amb = StringUtil.limpaString(rs.getString("dtp_codamb"), CARACTERES_PROIBIDOS).trim();
            if (Funcoes.textoVazio(amb) || !Funcoes.isNumeric(amb)) {
                if (!this.examesSemAmb.contains(rs.getString("exa_codigo"))) {
                    this.examesSemAmb.add(rs.getString("exa_codigo"));
                }
                return;
            }
            aux.append(this.getValor(Integer.parseInt(amb), this.ITEM_CODIGO_SERVICO));
            aux.append(this.getValor(rs.getString("exa_descricao"), this.ITEM_NOME_SERVICO));
            aux.append(this.getValor(false, this.ITEM_EMERGENCIA));
            aux.append(this.getValor(false, this.ITEM_DHE));
            aux.append(this.getValor(rs.getDate("req_data"), this.ITEM_DATA_REALIZACAO));
            aux.append(this.getValor(TipoProfissional.CIRURGIAO_CLINICO.codigo, this.ITEM_CODIGO_POSICAO));
            aux.append(this.getValor(1, this.ITEM_QUANTIDADE_EXECUTADA));
            aux.append(this.getValor(valorItem, this.ITEM_VALOR_ITEM));
            aux.append(this.getValor(null, this.ITEM_CIRURGIA_MULTIPLA_RADIOLOGIA));
            aux.append(this.getValor(Integer.parseInt((String)this.config.getValor("crmResponsavel")), this.ITEM_CRM_RESPONSAVEL));
            aux.append(this.getValor((String)this.config.getValor("ufCRMResponsavel"), this.ITEM_UF_CRM));
            aux.append(this.getValor(false, this.ITEM_INDICADOR_UTI));
            aux.append(this.getValor(Integer.parseInt((String)this.config.getValor("codigoEspecialidade")), this.ITEM_ESPECIALIDADE_CONSULTA_VISITA));
            aux.append(this.getValor(null, this.ITEM_VALOR_FILME));
            aux.append(this.getValor(valorItem, this.ITEM_VALOR_PROCEDIMENTO));
            aux.append(this.getValor(null, this.ITEM_VALOR_CUSTO_ADMINISTRACAO));
            aux.append(this.getValor(null, this.ITEM_FILLER3));
            aux.append(this.getValor(null, this.ITEM_LIVRE));
            aux.append(this.getValor(this.contador++, this.ITEM_NUMERO_REGISTRO));
            this.conteudo.append((CharSequence)aux);
        }
        this.conteudo.append("\n");
    }

    private void escreveTotalConta(ResultSet rs) throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es do faturamento eletr\u00f4nico n\u00e3o foram carregadas.", 2);
            return;
        }
        if (((String)this.config.getValor("versao")).equalsIgnoreCase(String.valueOf(2))) {
            this.somatorioContas = this.somatorioContas.add(this.somatorioItens);
            this.somatorioItens = this.somatorioItens.setScale(this.casasDecimais, this.arredondamento);
            StringBuilder aux = new StringBuilder();
            aux.append(this.getValor(SERVICO, this.TOTAL_SERVICO));
            aux.append(this.getValor(TipoRegistro.TOTAL_CONTA.codigo, this.TOTAL_CODIGO_REGISTRO));
            aux.append(this.getValor(null, this.TOTAL_FILLER1));
            aux.append(this.getValor(rs.getString("req_codigo"), this.TOTAL_NUMERO_DOCUMENTO));
            aux.append(this.getValor(null, this.TOTAL_FILLER2));
            aux.append(this.getValor(1, this.TOTAL_NUMERO_PARCELA));
            aux.append(this.getValor(--this.contadorItem, this.TOTAL_QUANTIDADE_ITENS));
            aux.append(this.getValor(this.somatorioItens, this.TOTAL_VALOR_CONTA));
            aux.append(this.getValor(rs.getString("pac_nome"), this.TOTAL_NOME_BENEFICIARIO));
            aux.append(this.getValor(null, this.TOTAL_QUANTIDADE_MATERIAL_MEDICAMENTO));
            aux.append(this.getValor(null, this.TOTAL_FILLER3));
            aux.append(this.getValor(null, this.TOTAL_LIVRE));
            aux.append(this.getValor(this.contador++, this.TOTAL_NUMERO_REGISTRO));
            this.conteudo.append((CharSequence)aux);
        }
        this.conteudo.append("\n");
    }

    private void escreveTraillerRemessa() throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es do faturamento eletr\u00f4nico n\u00e3o foram carregadas.", 2);
            return;
        }
        if (((String)this.config.getValor("versao")).equalsIgnoreCase(String.valueOf(2))) {
            this.somatorioContas = this.somatorioContas.setScale(this.casasDecimais, this.arredondamento);
            StringBuilder aux = new StringBuilder();
            aux.append(this.getValor(SERVICO, this.TRAILLER_SERVICO));
            aux.append(this.getValor(TipoRegistro.TRAILLER_REMESSA.codigo, this.TRAILLER_CODIGO_REGISTRO));
            aux.append(this.getValor(null, this.TRAILLER_FILLER1));
            aux.append(this.getValor(--this.contadorConta, this.TRAILLER_QUANTIDADE_CONTAS));
            aux.append(this.getValor(this.somatorioContas, this.TRAILLER_VALOR_CONTAS));
            aux.append(this.getValor(null, this.TRAILLER_FILLER2));
            aux.append(this.getValor(this.contador, this.TRAILLER_NUMERO_REGISTRO));
            this.conteudo.append((CharSequence)aux);
        }
    }

    @Override
    public Registro parseXMLConfiguracao(String xml) {
        Registro r = new Registro();
        r.setValor("codigoPrestadorOperadora", StringUtil.getValor(xml, "codigoPrestadorOperadora"));
        r.setValor("nomePrestador", StringUtil.getValor(xml, "nomePrestador"));
        r.setValor("tipoPrestador", StringUtil.getValor(xml, "tipoPrestador"));
        r.setValor("codigoEspecialidade", StringUtil.getValor(xml, "codigoEspecialidade"));
        r.setValor("crmResponsavel", StringUtil.getValor(xml, "crmResponsavel"));
        r.setValor("ufCRMResponsavel", StringUtil.getValor(xml, "ufCRMResponsavel"));
        r.setValor("versao", StringUtil.getValor(xml, "versao"));
        r.setValor("codigoEmpresaAuditoria", StringUtil.getValor(xml, "codigoEmpresaAuditoria"));
        r.setValor("numeroRat", StringUtil.getValor(xml, "numeroRat"));
        r.setValor("guiaComoBiometria", StringUtil.getValor(xml, "guiaComoBiometria"));
        String sequencialArquivo = StringUtil.getValor(xml, "sequencialArquivo");
        r.setValor("sequencialArquivo", Funcoes.isNumeric(sequencialArquivo) ? Integer.parseInt(sequencialArquivo) : 0);
        String sequencial = StringUtil.getValor(xml, "numeroRemessa");
        r.setValor("numeroRemessa", Funcoes.isNumeric(sequencial) ? Integer.parseInt(sequencial) : 0);
        return r;
    }

    private String registroToXML(Registro r) {
        StringBuilder buf = new StringBuilder("<faturamentoEletronico>");
        buf.append("<protocolo>").append(Planserv.getNomeProtocolo()).append("</protocolo>");
        buf.append(StringUtil.getTag("codigoPrestadorOperadora", r.getValor("codigoPrestadorOperadora").toString()));
        buf.append(StringUtil.getTag("nomePrestador", r.getValor("nomePrestador").toString()));
        buf.append(StringUtil.getTag("tipoPrestador", r.getValor("tipoPrestador").toString()));
        buf.append(StringUtil.getTag("numeroRemessa", r.getValor("numeroRemessa").toString()));
        buf.append(StringUtil.getTag("codigoEspecialidade", r.getValor("codigoEspecialidade").toString()));
        buf.append(StringUtil.getTag("crmResponsavel", r.getValor("crmResponsavel").toString()));
        buf.append(StringUtil.getTag("ufCRMResponsavel", r.getValor("ufCRMResponsavel").toString()));
        buf.append(StringUtil.getTag("versao", r.getValor("versao").toString()));
        buf.append(StringUtil.getTag("sequencialArquivo", r.getValor("sequencialArquivo").toString()));
        buf.append(StringUtil.getTag("codigoEmpresaAuditoria", r.getValor("codigoEmpresaAuditoria").toString()));
        buf.append(StringUtil.getTag("numeroRat", r.getValor("numeroRat").toString()));
        buf.append(StringUtil.getTag("guiaComoBiometria", r.getValor("guiaComoBiometria").toString()));
        buf.append("</faturamentoEletronico>");
        return buf.toString();
    }

    public String configurar(JDialog parent, String xml) {
        String retorno = xml;
        ConfigurarPlanserv conf = new ConfigurarPlanserv(parent);
        conf.setXML(xml);
        conf.setVisible(true);
        if (conf.ok()) {
            retorno = conf.getXML();
            this.config = this.parseXMLConfiguracao(retorno);
        }
        return retorno;
    }

    @Override
    public String configurar(JFrame parent, String xml) {
        String retorno = xml;
        ConfigurarPlanserv conf = new ConfigurarPlanserv(parent);
        conf.setXML(xml);
        conf.setVisible(true);
        if (conf.ok()) {
            retorno = conf.getXML();
            this.config = this.parseXMLConfiguracao(retorno);
        }
        return retorno;
    }

    @Override
    public boolean solicitarDiretorioNoInicio() {
        return true;
    }

    @Override
    public String[] situacoesPermitidasExame(String xml) {
        return null;
    }

    @Override
    public boolean validarCasasDecimais() {
        return true;
    }

    public static String getNomeProtocolo() {
        return "Planserv";
    }

    public static String getExtensaoArquivo() {
        return "txt";
    }

    @Override
    public String getCodificacaoArquivo() {
        return FaturamentoEletronico.CODIFICACAO.ISO_8859_1.codificacao;
    }

    @Override
    public void verificaErrosFatura(ArrayList<DadosFaturamento> requisicoes, Registro configuracaoConvenio0) {
    }

    @Override
    public ArrayList<GuiaVirtual.Campo> getCamposObrigatorios(String versao) {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasSolicitados() {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasExecutados() {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampo> getCamposIncorretos(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasSolicitados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasExecutados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public boolean gravaAlteracoes(DadosFaturamento requisicao, String guia, Registro configuracao) {
        return false;
    }

    @Override
    public void preencheValoresCampos(DadosFaturamento requisicao, Registro configuracaoEletronico, String guia) {
    }

    @Override
    public void preencheValoresTabelas(DadosFaturamento requisicao, String guia) {
    }

    @Override
    public void getValoresPreenchidos(DadosFaturamento requisicao, ArrayList<DadosExameFaturamento> exames, Registro configuracaoEletronico) {
    }

    @Override
    public void aplicarModificacoesGerais(ArrayList<DadosFaturamento> requisicoes, DadosFaturamento requisicao, DadosFaturamento requisicaoModificada, Registro configuracaoEletronico, Registro configuracaoEletronicoModificada) {
    }

    @Override
    public Object[] getListaDadosAdicionais() {
        return null;
    }

    @Override
    public void setListaDadosAdicionais(Object[] listaDadosAdicionais) {
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampoBPA> getCamposIncorretosBPA(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<JanelaConfiguracaoFaturamentoBPA.CampoBPA> getCamposObrigatoriosBPA() {
        return null;
    }

    class Campos {
        public static final String TIPO_STRING = "S";
        public static final String TIPO_NUMERO = "N";
        public static final String TIPO_DATA = "D";
        public static final String TIPO_BOOLEAN = "B";
        public static final String TIPO_HORA = "H";
        int posIni = -1;
        int posFim = -1;
        int tamanho = -1;
        String tipo = "S";
        boolean limparValor = true;

        public Campos(int posicaoInicial, int posicaoFinal, String tipo) {
            this.posIni = posicaoInicial;
            this.posFim = posicaoFinal;
            this.tamanho = posicaoFinal - posicaoInicial + 1;
            this.tipo = tipo;
        }

        public Campos(int posicaoInicial, int posicaoFinal, String tipo, boolean limparValor) {
            this.posIni = posicaoInicial;
            this.posFim = posicaoFinal;
            this.tamanho = posicaoFinal - posicaoInicial + 1;
            this.tipo = tipo;
            this.limparValor = limparValor;
        }
    }

    private static enum TipoPaciente {
        MEDICINA_ASSISTENCIAL(1),
        SAUDE_OCUPACIONAL_ADMISSIONAL(2),
        SAUDE_OCUPACIONAL_PERIODICA(3),
        SAUDE_OCUPACIONAL_RETORNO_TRABALHO(4),
        SAUDE_OCUPACIONAL_MUDANCA_FUNCAO(5),
        SAUDE_OCUPACIONAL_DEMISSIONAL(6),
        SAUDE_OCUPACIONAL_SERVICOS_ADMISSIONAIS(7),
        SAUDE_OCUPACIONAL_SERVICOS_PERIODICOS(8);

        public int codigo;

        private TipoPaciente(int codigo) {
            this.codigo = codigo;
        }
    }

    private static enum TipoProfissional {
        CIRURGIAO_CLINICO(0),
        PRIMEIRO_AUXILIAR(1),
        SEGUNDO_AUXILIAR(2),
        TERCEIRO_AUXILIAR(3),
        ANESTESIOLOGISTA(5),
        CONSULTOR(6);

        public int codigo;

        private TipoProfissional(int codigo) {
            this.codigo = codigo;
        }
    }

    private static enum TipoAtendimento {
        DOMICILIAR("A"),
        REMOCAO("B"),
        TRATAMENTO_SERIADO("C"),
        SADT("D"),
        AMBULATORIAL_CLINICO("E"),
        AMBULATORIAL_CIRURGICO("F"),
        AMBULATORIAL_OBSTETRICO("G"),
        INTERNACAO_CLINICA("H"),
        INTERNACAO_CIRURGICA("I"),
        INTERNACAO_OBSTETRICA("J"),
        INTERNACAO_SADT("S"),
        HOSPITAL_DIA_CIRURGICO("K"),
        HOSPITAL_DIA_CLINICO("L"),
        HOSPITAL_DIA_OBSTETRICO("M"),
        PRONTO_SOCORRO("N"),
        CONSULTA("P"),
        SUPORTE_MEDICAMENTOSO("T");

        public final String codigo;

        private TipoAtendimento(String codigo) {
            this.codigo = codigo;
        }
    }

    private static enum TipoCarater {
        NAO_INFORMADO(0),
        ACIDENTE_TRABALHO(1),
        ACIDENTE_TRANSITO(2),
        ACIDENTE_OUTROS(3),
        EMERGENCIA(4),
        URGENCIA(5),
        ELETIVA_PROGRAMADA_ROTINA(9);

        public final int codigo;

        private TipoCarater(int codigo) {
            this.codigo = codigo;
        }
    }

    private static enum TipoRegistro {
        HEADER(0),
        CABECALHO_CONTA(1),
        ITEM_CONTA(2),
        DETALHE_MATERIAL_MEDICAMENTOS(3),
        TOTAL_CONTA(4),
        TRAILLER_REMESSA(9);

        public final int codigo;

        private TipoRegistro(int codigo) {
            this.codigo = codigo;
        }
    }
}

