/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DetalhamentoErroFaturamento;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.GuiaVirtual;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.tabela.Registro;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class JanelaProblemasFaturamentoEletronico
extends JDialog
implements ActionListener {
    private final int WIDTH_JANELA = 450;
    private final int HEIGHT_JANELA = 500;
    private JScrollPane scrollArvore = new JScrollPane();
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonCorrigir = new JButton("Corrigir");
    private JButton buttonFechar = new JButton("Fechar");
    private ArrayList<DadosFaturamento> requisicoes = null;
    private Registro configuracaoEletronico = null;
    private AbstractFaturamentoEletronico faturamentoEletronico = null;
    private boolean haProblemas = false;
    private boolean acessoAlterarTodosCampos = false;
    private String versao = null;
    private DefaultMutableTreeNode noRaiz = new DefaultMutableTreeNode();
    private JTree treeRequisicoes = new JTree(this.noRaiz){

        @Override
        protected void setExpandedState(TreePath path, boolean state) {
            if (state) {
                super.setExpandedState(path, state);
            }
        }

        @Override
        public void setSelectionPath(TreePath path) {
            if (path != null) {
                super.clearSelection();
                Object[] objs = path.getPath();
                boolean isGuia = true;
                if (((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof DetalhamentoErroFaturamento) {
                    if (((DetalhamentoErroFaturamento)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()).getGuia() == null) {
                        isGuia = false;
                    }
                } else if (((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof DadosFaturamento) {
                    isGuia = false;
                }
                for (int i = 0; i < objs.length; ++i) {
                    DefaultMutableTreeNode obj = (DefaultMutableTreeNode)objs[i];
                    if (obj.isRoot() || obj.isLeaf()) continue;
                    Object[] nos = ((DefaultTreeModel)JanelaProblemasFaturamentoEletronico.this.treeRequisicoes.getModel()).getPathToRoot(obj);
                    super.addSelectionPath(new TreePath(nos));
                    boolean primeiraGuiaSelecionada = false;
                    for (int j = 0; j < obj.getChildCount(); ++j) {
                        DefaultMutableTreeNode obj2 = (DefaultMutableTreeNode)obj.getChildAt(j);
                        if (obj2.getChildCount() == 0) {
                            nos = ((DefaultTreeModel)JanelaProblemasFaturamentoEletronico.this.treeRequisicoes.getModel()).getPathToRoot(obj2);
                            super.addSelectionPath(new TreePath(nos));
                            continue;
                        }
                        if (isGuia || primeiraGuiaSelecionada) continue;
                        primeiraGuiaSelecionada = true;
                        nos = ((DefaultTreeModel)JanelaProblemasFaturamentoEletronico.this.treeRequisicoes.getModel()).getPathToRoot(obj2);
                        super.addSelectionPath(new TreePath(nos));
                        for (int k = 0; k < obj2.getChildCount(); ++k) {
                            DefaultMutableTreeNode obj3 = (DefaultMutableTreeNode)obj2.getChildAt(k);
                            nos = ((DefaultTreeModel)JanelaProblemasFaturamentoEletronico.this.treeRequisicoes.getModel()).getPathToRoot(obj3);
                            super.addSelectionPath(new TreePath(nos));
                        }
                    }
                }
            }
        }

        @Override
        public void removeSelectionPath(TreePath path) {
        }

        @Override
        public void addSelectionPath(TreePath path) {
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
        }
    };

    public JanelaProblemasFaturamentoEletronico(Window owner, boolean acessoAlterarTodosCampos, String versao) {
        super(owner);
        this.acessoAlterarTodosCampos = acessoAlterarTodosCampos;
        this.versao = versao;
        this.setSize(new Dimension(450, 500));
        this.setTitle("Problemas de Gera\u00e7\u00e3o do Faturamento Eletr\u00f4nico");
        this.setModal(true);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.setDefaultCloseOperation(0);
        this.montaTela();
    }

    private void montaTela() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.scrollArvore, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        this.add((Component)this.panelBotoes, c);
        this.scrollArvore.setViewportView(this.treeRequisicoes);
        this.treeRequisicoes.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                String guia;
                if (e.getClickCount() == 2 && (guia = JanelaProblemasFaturamentoEletronico.this.getGuiaSelecionada()) != null) {
                    JanelaProblemasFaturamentoEletronico.this.acaoCorrigir(guia, JanelaProblemasFaturamentoEletronico.this.versao);
                }
            }
        });
        this.buttonFechar.setMnemonic('F');
        this.buttonFechar.addActionListener(this);
        this.buttonCorrigir.setMnemonic('C');
        this.buttonCorrigir.addActionListener(this);
        this.panelBotoes.add(this.buttonCorrigir);
        this.panelBotoes.add(this.buttonFechar);
    }

    private String getGuiaSelecionada() {
        TreePath[] caminhos = this.treeRequisicoes.getSelectionPaths();
        DadosFaturamento dadosFaturamento = null;
        if (caminhos != null) {
            for (int i = 0; i < caminhos.length; ++i) {
                Object[] nos;
                TreePath caminho = caminhos[i];
                if (caminho == null || (nos = caminho.getPath()) == null) continue;
                for (int j = 0; j < nos.length; ++j) {
                    Object no = nos[j];
                    if (!(no instanceof DefaultMutableTreeNode) || ((DefaultMutableTreeNode)no).isLeaf() || ((DefaultMutableTreeNode)no).getUserObject() == null) continue;
                    if (!(((DefaultMutableTreeNode)no).getUserObject() instanceof DadosFaturamento)) {
                        return ((DefaultMutableTreeNode)no).getUserObject().toString();
                    }
                    dadosFaturamento = (DadosFaturamento)((DefaultMutableTreeNode)no).getUserObject();
                }
            }
        }
        if (dadosFaturamento != null && dadosFaturamento.getExames() != null && dadosFaturamento.getExames().size() > 0) {
            return dadosFaturamento.getExame(0).getCodigoGuia();
        }
        return null;
    }

    private void acaoCorrigir(String guia, String versao) {
        DadosFaturamento requisicao;
        DefaultMutableTreeNode no;
        Object aux = this.treeRequisicoes.getSelectionPath().getLastPathComponent();
        if (aux instanceof DefaultMutableTreeNode && (no = (DefaultMutableTreeNode)aux).getUserObject() instanceof DadosFaturamento && (requisicao = (DadosFaturamento)no.getUserObject()) != null) {
            this.invocaGuiaVirtual(requisicao, guia, no, versao);
        }
    }

    private void invocaGuiaVirtual(DadosFaturamento requisicao, String guiaSelecionada, DefaultMutableTreeNode no, String versao) {
        Registro configuracaoEletronicoAux = this.configuracaoEletronico.clone();
        GuiaVirtual guia = new GuiaVirtual((Window)this, this.faturamentoEletronico, this.acessoAlterarTodosCampos, configuracaoEletronicoAux);
        DadosFaturamento requisicaoAux = requisicao.clone();
        ArrayList<DadosFaturamento> lista = new ArrayList<DadosFaturamento>();
        lista.add(requisicaoAux);
        this.faturamentoEletronico.verificaErrosFatura(lista, configuracaoEletronicoAux);
        guia.preencheValores(requisicaoAux, configuracaoEletronicoAux, guiaSelecionada);
        guia.setCamposObrigatorios(this.faturamentoEletronico.getCamposObrigatorios(versao), this.faturamentoEletronico.getColunasObrigatoriasSolicitados(), this.faturamentoEletronico.getColunasObrigatoriasExecutados());
        guia.setCamposIncorretos(this.faturamentoEletronico.getCamposIncorretos(requisicaoAux, guiaSelecionada), this.faturamentoEletronico.getColunasIncorretasSolicitados(requisicaoAux, guiaSelecionada), this.faturamentoEletronico.getColunasIncorretasExecutados(requisicaoAux, guiaSelecionada));
        guia.setVisible(true);
        if (guia.isOk() && this.faturamentoEletronico.gravaAlteracoes(requisicaoAux, guiaSelecionada, configuracaoEletronicoAux)) {
            this.requisicoes.set(this.requisicoes.indexOf(requisicao), requisicaoAux);
            no.setUserObject(requisicaoAux);
            this.faturamentoEletronico.aplicarModificacoesGerais(this.requisicoes, requisicao, requisicaoAux, this.configuracaoEletronico, configuracaoEletronicoAux);
            this.faturamentoEletronico.verificaErrosFatura(this.requisicoes, this.configuracaoEletronico);
            if (!this.haErrosRequisicoes(this.requisicoes)) {
                Funcoes.mensagem(this, "Todos os problemas foram corrigidos.", 5);
                this.haProblemas = false;
                this.setVisible(false);
            } else {
                this.preencheValores(this.requisicoes, this.configuracaoEletronico, this.faturamentoEletronico);
            }
        }
    }

    private boolean haErrosRequisicoes(ArrayList<DadosFaturamento> requisicoes) {
        if (requisicoes != null) {
            for (int i = 0; i < requisicoes.size(); ++i) {
                if (!requisicoes.get(i).haProblemas()) continue;
                return true;
            }
        }
        return false;
    }

    public void preencheValores(ArrayList<DadosFaturamento> requisicoes, Registro configuracaoEletronico, AbstractFaturamentoEletronico faturamentoEletronico) {
        int i;
        while (this.noRaiz.getChildCount() > 0) {
            ((DefaultTreeModel)this.treeRequisicoes.getModel()).removeNodeFromParent((MutableTreeNode)this.noRaiz.getChildAt(0));
        }
        if (requisicoes != null && configuracaoEletronico != null && faturamentoEletronico != null) {
            this.requisicoes = requisicoes;
            this.configuracaoEletronico = configuracaoEletronico;
            this.faturamentoEletronico = faturamentoEletronico;
            for (i = 0; i < requisicoes.size(); ++i) {
                int j;
                DadosFaturamento requisicao = requisicoes.get(i);
                ArrayList<DetalhamentoErroFaturamento> listaProblemas = requisicao.getListaProblemas();
                if (listaProblemas == null || listaProblemas.size() == 0) continue;
                DefaultMutableTreeNode noRequisicao = new DefaultMutableTreeNode(requisicao);
                this.noRaiz.add(noRequisicao);
                ArrayList<String> listaGuias = new ArrayList<String>();
                for (j = 0; j < listaProblemas.size(); ++j) {
                    String guia;
                    DetalhamentoErroFaturamento erro = listaProblemas.get(j);
                    String string = guia = (erro.getGuia() == null || Funcoes.textoVazio(erro.getGuia())) && erro.isExame() ? " " : erro.getGuia();
                    if (guia != null && !listaGuias.contains(guia)) {
                        listaGuias.add(guia);
                    }
                    if (erro.isExame()) continue;
                    DefaultMutableTreeNode noSemGuia = new DefaultMutableTreeNode(erro);
                    noSemGuia.setAllowsChildren(false);
                    noRequisicao.add(noSemGuia);
                }
                for (j = 0; j < listaGuias.size(); ++j) {
                    String guia = (String)listaGuias.get(j);
                    DefaultMutableTreeNode noGuia = new DefaultMutableTreeNode(guia);
                    for (int k = 0; k < listaProblemas.size(); ++k) {
                        String guiaAux;
                        DetalhamentoErroFaturamento erro = listaProblemas.get(k);
                        String string = guiaAux = (erro.getGuia() == null || Funcoes.textoVazio(erro.getGuia())) && erro.isExame() ? " " : erro.getGuia();
                        if (!erro.isExame() || !guia.equalsIgnoreCase(guiaAux)) continue;
                        DefaultMutableTreeNode no = new DefaultMutableTreeNode(erro);
                        no.setAllowsChildren(false);
                        noGuia.add(no);
                    }
                    if (noGuia.getChildCount() <= 0) continue;
                    noRequisicao.add(noGuia);
                }
            }
        }
        ((DefaultTreeModel)this.treeRequisicoes.getModel()).reload();
        for (i = 0; i < this.treeRequisicoes.getRowCount(); ++i) {
            this.treeRequisicoes.expandRow(i);
        }
        this.treeRequisicoes.setRootVisible(false);
        this.treeRequisicoes.setCellRenderer(new Renderer());
        this.treeRequisicoes.getSelectionModel().setSelectionMode(4);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCorrigir) {
            String guia = this.getGuiaSelecionada();
            if (guia != null) {
                this.acaoCorrigir(guia, this.versao);
            }
        } else if (e.getSource() == this.buttonFechar) {
            this.haProblemas = true;
            this.setVisible(false);
        }
    }

    public boolean haProblemas() {
        return this.haProblemas;
    }

    public ArrayList<DadosFaturamento> getRequisicoes() {
        return this.requisicoes;
    }

    class Renderer
    implements TreeCellRenderer {
        Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Color selecionado = UIManager.getColor("Tree.selectionBackground");
            JLabel label = new JLabel();
            label.setOpaque(selected);
            if (selected) {
                label.setBackground(selecionado);
            }
            if (leaf) {
                label.setText(value.toString());
                label.setIcon(ImagemUtils.carregaImagemJalis("error.png"));
                Dimension original = label.getPreferredSize();
                original.height += 2;
                label.setPreferredSize(original);
            } else if (value != null && !(((DefaultMutableTreeNode)value).getUserObject() instanceof DadosFaturamento)) {
                if (value == null || value.toString() == null || value.toString().equalsIgnoreCase(" ")) {
                    label.setText("GUIA N\u00c3O INFORMADA");
                    label.setIcon(ImagemUtils.carregaImagemJalis("error.png"));
                } else {
                    label.setText("Guia: " + value.toString());
                }
                label.setVerticalAlignment(3);
                Dimension original = label.getPreferredSize();
                original.height += 5;
                label.setPreferredSize(original);
            } else {
                if (value != null) {
                    label.setText(" " + value.toString());
                }
                label.setVerticalAlignment(3);
                Dimension original = label.getPreferredSize();
                if (row > 0) {
                    original.height += 10;
                }
                label.setPreferredSize(original);
                label.setSize(original);
            }
            return label;
        }
    }
}

