/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DetalhamentoErroFaturamento;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.util.RacaCorPaciente;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.BPA;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.ValidaDoc;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class JanelaConfiguracaoFaturamentoBPA
extends JDialog
implements ActionListener,
WindowListener {
    private final int LARGURA_GUIA = 620;
    private final int ALTURA_GUIA = 460;
    private final int ALTURA_LINHA = 33;
    private final int CONSTANTE_LARGURA = 25;
    private final int ALTURA_LINHA_TABELA = 15;
    private final float TAMANHO_FONTE_ROTULO = 11.0f;
    private final float TAMANHO_FONTE_INTERNA = 10.0f;
    private final float TAMANHO_FONTE_CABECALHO = 11.0f;
    private final float TAMANHO_FONTE_AGRUPAMENTO = 11.0f;
    private final float TAMANHO_FONTE_TABELA = 11.0f;
    private final int INSET_TOP_PAINEL = 0;
    private final int INSET_LEFT_PAINEL = 20;
    private final int INSET_BOTTOM_PAINEL = 0;
    private final int INSET_RIGHT_PAINEL = 20;
    private final int INSET_TOP_AGRUPAMENTO = 2;
    private final int INSET_LEFT_AGRUPAMENTO = 1;
    private final int INSET_BOTTOM_AGRUPAMENTO = 0;
    private final int INSET_RIGHT_AGRUPAMENTO = 0;
    private final int INSET_TOP_CAMPOS = 0;
    private final int INSET_LEFT_CAMPOS = 1;
    private final int INSET_BOTTOM_CAMPOS = 0;
    private final int INSET_RIGHT_CAMPOS = 0;
    private final int INSET_TOP_TABELAS = 0;
    private final int INSET_LEFT_TABELAS = 3;
    private final int INSET_BOTTOM_TABELAS = 0;
    private final int INSET_RIGHT_TABELAS = 1;
    private final Color COR_OBRIGATORIOS = Color.BLUE;
    private final Color COR_INCORRETOS = Color.RED;
    private final Color COR_FONTE_CAMPOS = Color.BLACK;
    public static final int CAMPO_DATA = 0;
    public static final int CAMPO_TABELA = 1;
    public static final int CAMPO_DESCRICAO = 2;
    public static final int CAMPO_QUANTIDADE = 3;
    public static final int CAMPO_VALOR_UNITARIO = 4;
    public static final int CAMPO_OBJETOS = 5;
    public static final int SOLICITADOS_TABELA = 0;
    public static final int SOLICITADOS_COD_PROCEDIMENTO = 1;
    public static final int SOLICITADOS_INDIVIDUALIZADO = 2;
    public static final int SOLICITADOS_CONSOLIDADO = 3;
    public static final int SOLICITADOS_OBJETOS = 4;
    public static final int EXECUTADOS_DATA = 0;
    public static final int EXECUTADOS_TABELA = 1;
    public static final int EXECUTADOS_COD_PROCEDIMENTO = 2;
    public static final int EXECUTADOS_DESC_PROCEDIMENTO = 3;
    public static final int EXECUTADOS_QUANTIDADE = 4;
    public static final int EXECUTADOS_VALOR_UNITARIO = 5;
    public static final int EXECUTADOS_VALOR_TOTAL = 6;
    public static final int EXECUTADOS_OBJETOS = 7;
    public static final int TIPO_TABELA_SOLICITADOS = 0;
    public static final int TIPO_TABELA_EXECUTADOS = 1;
    private DadosFaturamento requisicaoAux = null;
    private String guiaAux = null;
    private Registro configuracaoAux = null;
    private boolean isOk = false;
    private CampoBPA primeiroCampoIncorreto = null;
    boolean acessoAlterarTodosCampos = false;
    public static CampoTexto codigoConvenio = null;
    public static CampoTexto descricaoConvenio = null;
    public static CampoTexto codigoCNES = null;
    public static CampoTexto cnpjResponsavel = null;
    public static CampoTexto nomdeDestino = null;
    public static CampoCombo caraterAtendimento = null;
    public static CampoTexto cnsProfissional = null;
    public static CampoTexto codigoCid10Convenio = null;
    public static CampoTexto nomeOrgaoOrigem = null;
    public static CampoTexto siglaOrgaoOrigem = null;
    public static CampoTexto orgaoDestino = null;
    public static CampoTexto cboExecutante = null;
    public static CampoTexto codigoRequisicao = null;
    public static CampoTexto nomePaciente = null;
    public static CampoTexto nomeMedico = null;
    public static CampoTexto cboMedico = null;
    public static CampoCombo racaCorPaciente = null;
    public static CampoTexto etniaPaciente = null;
    public static CampoTexto etniaPacienteDesc = null;
    public JButton bBuscaEtnia = new JButton();
    public static CampoTexto nacionalidadePaciente = null;
    public static CampoTexto nacionalidadePacienteDesc = null;
    public JButton bBuscaNacionalidade = new JButton();
    public static CampoCombo lograudouroPaciente = null;
    public static CampoTexto logradouroPacienteCodigo = null;
    public static CampoTexto enderecoPaciente = null;
    public static CampoTexto numeroEndereco = null;
    public static CampoTexto complementoEndereco = null;
    public static CampoTexto bairroEndereco = null;
    public static CampoTexto bairroEnderecoDescricao = null;
    JButton bBuscaBairro = new JButton();
    JCheckBox checkConsolidada = new JCheckBox();
    JCheckBox checkIndividualizada = new JCheckBox();
    public static CampoTexto cidadeEndereco = null;
    public static CampoTexto cidadeEnderecoDesc = null;
    JButton bBuscaCidade = new JButton();
    public static CampoTexto codigoIbge = null;
    public static CampoTexto cepEndereco = null;
    public static CampoTexto codigoCnsPasciente = null;
    public static CampoTexto codigoCid10Paciente = null;
    public static CampoTable procedimentos = null;
    private JPanel panel1 = new JPanel(new GridBagLayout());
    private JPanel panel2 = new JPanel(new GridBagLayout());
    private JPanel panel3 = new JPanel(new GridBagLayout());
    private JPanel panel4 = new JPanel(new GridBagLayout());
    private JPanel panel5 = new JPanel(new GridBagLayout());
    private JPanel panel6 = new JPanel(new GridBagLayout());
    private JPanel panel7 = new JPanel(new GridBagLayout());
    private JPanel panel8 = new JPanel(new GridBagLayout());
    private JPanel panel9 = new JPanel(new GridBagLayout());
    private JPanel panel10 = new JPanel(new GridBagLayout());
    private JPanel panel11 = new JPanel(new GridBagLayout());
    private JPanel panel12 = new JPanel(new GridBagLayout());
    private JPanel panel13 = new JPanel(new GridBagLayout());
    private JPanel panel14 = new JPanel(new GridBagLayout());
    private JPanel panelRodape = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JLabel labelDadosConvenio = new JLabel("Dados do Conv\u00eanio");
    private JLabel labelDadosRequisicao = new JLabel("Dados da Requisi\u00e7\u00e3o");
    private JLabel labelEnderecoPaciente = new JLabel("Endere\u00e7o do Paciente");
    private JLabel labelDadosExame = new JLabel("Exames");
    private JButton buttonOk = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private AbstractFaturamentoEletronico faturamentoEletronico = null;

    public JanelaConfiguracaoFaturamentoBPA(Window owner, AbstractFaturamentoEletronico faturamentoEletronico, boolean acessoAlterarTodosCampos) {
        super(owner);
        this.addWindowListener(this);
        this.faturamentoEletronico = faturamentoEletronico;
        this.acessoAlterarTodosCampos = acessoAlterarTodosCampos;
        Funcoes.montaEnter((JComponent)this.getContentPane());
        codigoConvenio = new CampoTexto("C\u00f3digo", 10, 3, 3.0f);
        descricaoConvenio = new CampoTexto("Descri\u00e7\u00e3o", 50, 3, 12.0f);
        codigoCNES = new CampoTexto("C\u00f3digo CNES", 10, 1, 5.2f);
        cnpjResponsavel = new CampoTexto("CNPJ Respons\u00e1vel", 70, 3, 4.7f);
        nomdeDestino = new CampoTexto("Nome Destino", 70, 3, 10.0f);
        caraterAtendimento = new CampoCombo("Car\u00e1ter do Atendimento", BPA.CARATER_ATENDIMENTO, 6.5f);
        cnsProfissional = new CampoTexto("CNS Profissional", 10, 3, 5.1f);
        codigoCid10Convenio = new CampoTexto("CID-10", 10, 3, 3.2f);
        nomeOrgaoOrigem = new CampoTexto("Nome Org\u00e3o Origem", 70, 3, 10.0f);
        siglaOrgaoOrigem = new CampoTexto("Sigla Org\u00e3o Origem", 30, 3, 5.2f);
        orgaoDestino = new CampoTexto("Org\u00e3o Destino", 20, 3, 5.2f);
        cboExecutante = new CampoTexto("CBO Executante", 30, 3, 4.5f);
        codigoRequisicao = new CampoTexto("C\u00f3digo", 10, 1, 3.0f);
        nomePaciente = new CampoTexto("Nome do Paciente", 50, 3, 9.0f);
        nomeMedico = new CampoTexto("Nome do M\u00e9dico", 50, 3, 8.4f);
        cboMedico = new CampoTexto("CBO do M\u00e9dico", 10, 3, 4.4f);
        racaCorPaciente = new CampoCombo("Ra\u00e7a/cor do Paciente", (Object[])RacaCorPaciente.values(), 7.0f);
        etniaPaciente = new CampoTexto("codigo", 50, 3, 7.0f);
        etniaPacienteDesc = new CampoTexto("Etnia do Paciente", 50, 3, 8.1f);
        nacionalidadePaciente = new CampoTexto("codigo", 50, 3, 7.0f);
        nacionalidadePacienteDesc = new CampoTexto("Nacionalidade do Paciente", 50, 3, 8.1f);
        lograudouroPaciente = new CampoCombo("Logradouro", Tipos.arrayTiposLogradouro, 5.1f);
        enderecoPaciente = new CampoTexto("Endere\u00e7o", 50, 3, 8.4f);
        numeroEndereco = new CampoTexto("N\u00famero", 8, 3, 3.2f);
        complementoEndereco = new CampoTexto("Complemento", 50, 3, 8.2f);
        bairroEndereco = new CampoTexto("codigo", 50, 3, 7.0f);
        bairroEnderecoDescricao = new CampoTexto("Bairro", 50, 3, 7.0f);
        cidadeEndereco = new CampoTexto("codigo", 15, 3, 8.0f);
        cidadeEnderecoDesc = new CampoTexto("Cidade", 80, 3, 8.0f);
        codigoIbge = new CampoTexto("C\u00f3d. IBGE", 7, 1, 3.3f);
        cepEndereco = new CampoTexto("CEP", 15, 9, 4.9f);
        codigoCnsPasciente = new CampoTexto("CNS Paciente", 15, 3, 5.0f);
        procedimentos = new CampoTable(new String[]{"Procedimento", "Descri\u00e7\u00e3o", "Individualizado", "Consolidado", ""}, new int[]{100, 0, 100, 100, 1}, new Class[]{String.class, String.class, Checkbox.class, Checkbox.class, Object.class}, new int[]{2, 3}, 0, 2.0f);
        this.setSize(630, 460);
        this.setTitle("Campos obrigat\u00f3rios para faturamento BPA");
        this.setModal(true);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.setDefaultCloseOperation(0);
        this.montaGuia();
    }

    private void montaGuia() {
        this.setLayout(new GridBagLayout());
        this.panel1.setPreferredSize(new Dimension(620, 33));
        this.panel1.setMinimumSize(new Dimension(620, 33));
        this.panel2.setPreferredSize(new Dimension(620, 33));
        this.panel2.setMinimumSize(new Dimension(620, 33));
        this.panel3.setPreferredSize(new Dimension(620, 33));
        this.panel3.setMinimumSize(new Dimension(620, 33));
        this.panel4.setPreferredSize(new Dimension(620, 33));
        this.panel4.setMinimumSize(new Dimension(620, 33));
        this.panel5.setPreferredSize(new Dimension(620, 33));
        this.panel5.setMinimumSize(new Dimension(620, 33));
        this.panel6.setPreferredSize(new Dimension(620, 33));
        this.panel6.setMinimumSize(new Dimension(620, 33));
        this.panel7.setPreferredSize(new Dimension(620, 33));
        this.panel7.setMinimumSize(new Dimension(620, 33));
        this.panel8.setPreferredSize(new Dimension(620, 33));
        this.panel8.setMinimumSize(new Dimension(620, 33));
        this.panel9.setPreferredSize(new Dimension(620, 33));
        this.panel9.setMinimumSize(new Dimension(620, 33));
        this.panel10.setPreferredSize(new Dimension(620, 33));
        this.panel10.setMinimumSize(new Dimension(620, 33));
        this.panel11.setPreferredSize(new Dimension(620, 33));
        this.panel11.setMinimumSize(new Dimension(620, 33));
        this.panel12.setPreferredSize(new Dimension(620, 33));
        this.panel12.setMinimumSize(new Dimension(620, 33));
        this.panel13.setPreferredSize(new Dimension(620, 33));
        this.panel13.setMinimumSize(new Dimension(620, 33));
        this.panel14.setMinimumSize(new Dimension(620, 33));
        Dimension medidaPadraoBotao = new Dimension(20, 18);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 20, 0, 20);
        this.add((Component)this.labelDadosConvenio, c);
        ++c.gridy;
        c.insets = new Insets(2, 20, 0, 20);
        this.add((Component)this.panel1, c);
        ++c.gridy;
        c.insets = new Insets(0, 20, 0, 20);
        this.add((Component)this.panel2, c);
        ++c.gridy;
        c.insets = new Insets(0, 20, 0, 20);
        this.add((Component)this.panel3, c);
        ++c.gridy;
        c.insets = new Insets(0, 20, 0, 20);
        this.add((Component)this.labelDadosRequisicao, c);
        ++c.gridy;
        this.add((Component)this.panel4, c);
        ++c.gridy;
        this.add((Component)this.panel14, c);
        ++c.gridy;
        this.add((Component)this.labelEnderecoPaciente, c);
        ++c.gridy;
        c.insets = new Insets(0, 20, 0, 20);
        this.add((Component)this.panel5, c);
        ++c.gridy;
        c.insets = new Insets(0, 20, 0, 20);
        this.add((Component)this.panel6, c);
        ++c.gridy;
        this.add((Component)this.panel7, c);
        ++c.gridy;
        this.add((Component)this.labelDadosExame, c);
        ++c.gridy;
        this.add((Component)procedimentos, c);
        ++c.gridy;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.add((Component)this.panelRodape, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 0);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panel1.add((Component)codigoConvenio, c);
        ++c.gridx;
        this.panel1.add((Component)descricaoConvenio, c);
        ++c.gridx;
        this.panel1.add((Component)codigoCNES, c);
        ++c.gridx;
        this.panel1.add((Component)cnpjResponsavel, c);
        c.insets = new Insets(0, 1, 0, 0);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panel2.add((Component)nomdeDestino, c);
        ++c.gridx;
        this.panel2.add((Component)caraterAtendimento, c);
        ++c.gridx;
        this.panel2.add((Component)cnsProfissional, c);
        ++c.gridx;
        this.panel2.add((Component)codigoCid10Convenio, c);
        c.insets = new Insets(0, 1, 0, 0);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panel3.add((Component)nomeOrgaoOrigem, c);
        ++c.gridx;
        this.panel3.add((Component)siglaOrgaoOrigem, c);
        ++c.gridx;
        this.panel3.add((Component)orgaoDestino, c);
        ++c.gridx;
        this.panel3.add((Component)cboExecutante, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 0);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panel4.add((Component)codigoRequisicao, c);
        ++c.gridx;
        this.panel4.add((Component)nomePaciente, c);
        ++c.gridx;
        this.panel4.add((Component)nomeMedico, c);
        ++c.gridx;
        this.panel4.add((Component)cboMedico, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 0);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panel14.add((Component)racaCorPaciente, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.panel14.add((Component)etniaPacienteDesc, c);
        ++c.gridx;
        c.gridheight = 1;
        this.bBuscaEtnia.setMinimumSize(medidaPadraoBotao);
        this.bBuscaEtnia.setPreferredSize(medidaPadraoBotao);
        c.anchor = 15;
        this.panel14.add((Component)this.bBuscaEtnia, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.panel14.add((Component)nacionalidadePacienteDesc, c);
        ++c.gridx;
        this.bBuscaNacionalidade.setMinimumSize(medidaPadraoBotao);
        this.bBuscaNacionalidade.setPreferredSize(medidaPadraoBotao);
        this.panel14.add((Component)this.bBuscaNacionalidade, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 0);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panel5.add((Component)lograudouroPaciente, c);
        ++c.gridx;
        this.panel5.add((Component)enderecoPaciente, c);
        ++c.gridx;
        this.panel5.add((Component)numeroEndereco, c);
        ++c.gridx;
        this.panel5.add((Component)complementoEndereco, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 0);
        c.gridwidth = 1;
        c.gridheight = 2;
        this.panel6.add((Component)bairroEnderecoDescricao, c);
        ++c.gridx;
        c.gridheight = 1;
        this.bBuscaBairro.setMinimumSize(medidaPadraoBotao);
        this.bBuscaBairro.setPreferredSize(medidaPadraoBotao);
        c.anchor = 15;
        this.panel6.add((Component)this.bBuscaBairro, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.panel6.add((Component)cidadeEnderecoDesc, c);
        ++c.gridx;
        this.bBuscaCidade.setMinimumSize(medidaPadraoBotao);
        this.bBuscaCidade.setPreferredSize(medidaPadraoBotao);
        this.panel6.add((Component)this.bBuscaCidade, c);
        ++c.gridx;
        this.panel6.add((Component)codigoIbge, c);
        ++c.gridx;
        this.panel6.add((Component)cepEndereco, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.panel7.add((Component)codigoCnsPasciente, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 0);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panelRodape.add((Component)this.getPanelLegenda(), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelRodape.add((Component)new JLabel(), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelRodape.add((Component)this.panelBotoes, c);
        this.panelBotoes.add(this.buttonOk);
        this.panelBotoes.add(this.buttonCancelar);
        this.buttonOk.setMnemonic('O');
        this.buttonOk.addActionListener(this);
        this.buttonCancelar.setMnemonic('C');
        this.buttonCancelar.addActionListener(this);
        this.inicializaCamposFixos();
        this.adicionarListener();
    }

    private void adicionarListener() {
        racaCorPaciente.addItemStateChanged(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RacaCorPaciente rcp = (RacaCorPaciente)((Object)racaCorPaciente.getValor());
                boolean indigena = rcp.equals((Object)RacaCorPaciente.INDIGENA);
                etniaPaciente.setEnabled(indigena);
                etniaPacienteDesc.setEnabled(indigena);
                JanelaConfiguracaoFaturamentoBPA.this.bBuscaEtnia.setEnabled(indigena);
            }
        });
        this.bBuscaEtnia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaConfiguracaoFaturamentoBPA.this.buscaEtniaPaciente();
            }
        });
        etniaPacienteDesc.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    JanelaConfiguracaoFaturamentoBPA.this.buscaEtniaPaciente();
                }
            }
        });
        this.bBuscaNacionalidade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaConfiguracaoFaturamentoBPA.this.buscaNacionalidadePaciente();
            }
        });
        nacionalidadePacienteDesc.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    JanelaConfiguracaoFaturamentoBPA.this.buscaNacionalidadePaciente();
                }
            }
        });
        this.bBuscaBairro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaConfiguracaoFaturamentoBPA.this.buscaBairro();
            }
        });
        bairroEnderecoDescricao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    JanelaConfiguracaoFaturamentoBPA.this.buscaBairro();
                }
            }
        });
        this.bBuscaCidade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaConfiguracaoFaturamentoBPA.this.buscaCidade();
            }
        });
        cidadeEnderecoDesc.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    JanelaConfiguracaoFaturamentoBPA.this.buscaCidade();
                }
            }
        });
        this.buttonOk.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    JanelaConfiguracaoFaturamentoBPA.this.buttonOk.doClick();
                }
            }
        });
        this.buttonCancelar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    JanelaConfiguracaoFaturamentoBPA.this.buttonCancelar.doClick();
                }
            }
        });
        codigoCnsPasciente.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        codigoCnsPasciente.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    JanelaConfiguracaoFaturamentoBPA.this.buttonOk.requestFocus();
                    JanelaConfiguracaoFaturamentoBPA.this.buttonOk.grabFocus();
                }
            }
        });
        cepEndereco.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    codigoCnsPasciente.requestFocus();
                    codigoCnsPasciente.grabFocus();
                }
            }
        });
    }

    private boolean validaCartaoSUS() {
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
            return true;
        }
        boolean isValido = true;
        String mensagem = "O cart\u00e3o nacional de sa\u00fade (Cart\u00e3o SUS) informado \u00e9 inv\u00e1lido.";
        if (codigoCnsPasciente.getValor() != null) {
            isValido = ValidaDoc.checkDoc(codigoCnsPasciente.getValor().toString().trim(), 3);
        }
        if (!isValido) {
            Funcoes.mensagem(Laboratorio.getInstancia(), mensagem, 2);
            ScreenUtil.requisitarFoco(codigoCnsPasciente);
        }
        return isValido;
    }

    private void buscaBairro() {
        Hashtable resultado = Pesquisas.bairro(Laboratorio.getInstancia(), true);
        if (resultado != null) {
            bairroEndereco.setValor(resultado.get("bai_codigo").toString());
            bairroEnderecoDescricao.setValor(resultado.get("bai_descricao").toString());
        }
        bairroEnderecoDescricao.alinhamentoHorizontal();
        bairroEnderecoDescricao.requestFocus();
    }

    private void buscaCidade() {
        Hashtable resultado = Pesquisas.cidade(Laboratorio.getInstancia(), true);
        if (resultado != null) {
            cidadeEnderecoDesc.setValor(resultado.get("cid_nome").toString());
            cidadeEndereco.setValor(resultado.get("cid_codigo").toString());
            codigoIbge.setValor(resultado.get("cid_codigoibge").toString());
        }
        cidadeEnderecoDesc.alinhamentoHorizontal();
        cidadeEnderecoDesc.requestFocus();
    }

    private void buscaEtniaPaciente() {
        Hashtable resultado = Pesquisas.etnias(Laboratorio.getInstancia(), true);
        if (resultado != null) {
            etniaPacienteDesc.setValor(resultado.get("ein_descricao").toString());
            etniaPaciente.setValor(resultado.get("ein_codigo").toString());
        }
        etniaPacienteDesc.alinhamentoHorizontal();
        etniaPacienteDesc.requestFocus();
    }

    private void buscaNacionalidadePaciente() {
        Hashtable resultado = Pesquisas.nacionalidades(Laboratorio.getInstancia(), true);
        if (resultado != null) {
            nacionalidadePacienteDesc.setValor(resultado.get("nli_descricao").toString());
            nacionalidadePaciente.setValor(resultado.get("nli_codigo").toString());
        }
        nacionalidadePacienteDesc.alinhamentoHorizontal();
        nacionalidadePacienteDesc.requestFocus();
    }

    private void inicializaCamposFixos() {
        this.labelDadosConvenio.setFont(this.labelDadosConvenio.getFont().deriveFont(11.0f));
        this.labelDadosRequisicao.setFont(this.labelDadosRequisicao.getFont().deriveFont(11.0f));
        this.labelEnderecoPaciente.setFont(this.labelEnderecoPaciente.getFont().deriveFont(11.0f));
        this.labelDadosExame.setFont(this.labelDadosExame.getFont().deriveFont(11.0f));
    }

    public void controlaCampos() {
        codigoConvenio.setEnabled(false);
        descricaoConvenio.setEnabled(false);
        codigoCNES.setEnabled(false);
        cnpjResponsavel.setEnabled(false);
        nomdeDestino.setEnabled(false);
        caraterAtendimento.setEnabled(false);
        cnsProfissional.setEnabled(false);
        codigoCid10Convenio.setEnabled(false);
        nomeOrgaoOrigem.setEnabled(false);
        siglaOrgaoOrigem.setEnabled(false);
        orgaoDestino.setEnabled(false);
        cboExecutante.setEnabled(false);
        codigoRequisicao.setEnabled(false);
        nomePaciente.setEnabled(false);
        nomeMedico.setEnabled(false);
        cboMedico.setEnabled(false);
        lograudouroPaciente.setEnabled(true);
        enderecoPaciente.setEnabled(true);
        numeroEndereco.setEnabled(true);
        complementoEndereco.setEnabled(true);
        bairroEnderecoDescricao.setEditable(false);
        cidadeEnderecoDesc.setEditable(false);
        bairroEndereco.setVisible(false);
        cidadeEndereco.setVisible(false);
        etniaPacienteDesc.setEditable(false);
        nacionalidadePacienteDesc.setEditable(false);
        RacaCorPaciente rcp = (RacaCorPaciente)((Object)racaCorPaciente.getValor());
        this.bBuscaEtnia.setEnabled(rcp.equals((Object)RacaCorPaciente.INDIGENA));
        if (nacionalidadePacienteDesc.getValor() != null) {
            this.bBuscaNacionalidade.setEnabled(Funcoes.textoVazio(nacionalidadePaciente.getValor().toString()));
        }
        Funcoes.imagemPesquisa(this.bBuscaBairro);
        Funcoes.imagemPesquisa(this.bBuscaCidade);
        Funcoes.imagemPesquisa(this.bBuscaEtnia);
        Funcoes.imagemPesquisa(this.bBuscaNacionalidade);
    }

    public void setCamposObrigatorios(ArrayList<CampoBPA> campos, int[] colunasObrigatoriasSolicitados, int[] colunasObrigatoriasExecutados) {
        if (campos != null) {
            for (int i = 0; i < campos.size(); ++i) {
                CampoBPA campo = campos.get(i);
                if (campo == null) continue;
                campo.setObrigatorio(true);
            }
        }
    }

    public void preencheValores(DadosFaturamento requisicao, Registro configuracaoEletronico, String guia) {
        this.requisicaoAux = requisicao;
        this.guiaAux = guia;
        this.configuracaoAux = configuracaoEletronico;
        this.faturamentoEletronico.preencheValoresCampos(this.requisicaoAux, configuracaoEletronico, guia);
        this.faturamentoEletronico.preencheValoresTabelas(this.requisicaoAux, guia);
        this.alinhamentoCampos();
    }

    public void alinhamentoCampos() {
        cidadeEnderecoDesc.alinhamentoHorizontal();
        bairroEnderecoDescricao.alinhamentoHorizontal();
        complementoEndereco.alinhamentoHorizontal();
        enderecoPaciente.alinhamentoHorizontal();
    }

    public void setCamposIncorretosBPA(ArrayList<AbstractFaturamentoEletronico.ErroCampoBPA> campos, ArrayList<AbstractFaturamentoEletronico.ErroExame> colunasSolicitados, ArrayList<AbstractFaturamentoEletronico.ErroExame> colunasExecutados) {
        this.limpaCamposIncorretos(this.getContentPane());
        if (campos != null) {
            for (int i = 0; i < campos.size(); ++i) {
                CampoBPA comp = campos.get(i).getCampo();
                if (!comp.isObrigatorio) continue;
                comp.setIncorreto(true);
                DetalhamentoErroFaturamento erro = campos.get((int)i).erro;
                if (erro != null) {
                    comp.setToolTipText(erro.toString());
                }
                if (this.primeiroCampoIncorreto != null) {
                    if (comp.getLocation().y < this.primeiroCampoIncorreto.getLocation().y && comp.getLocation().x < this.primeiroCampoIncorreto.getLocation().x) {
                        this.primeiroCampoIncorreto = comp;
                    }
                } else {
                    this.primeiroCampoIncorreto = comp;
                }
                if (this.acessoAlterarTodosCampos) continue;
                comp.setEnabled(true);
            }
        }
    }

    private void limpaCamposIncorretos(Container container) {
        Component[] componentes = container.getComponents();
        if (componentes != null) {
            for (int i = 0; i < componentes.length; ++i) {
                Component aux = componentes[i];
                if (aux instanceof CampoBPA) {
                    CampoBPA comp = (CampoBPA)aux;
                    if (!comp.isObrigatorio) continue;
                    comp.setIncorreto(false);
                    continue;
                }
                if (!(aux instanceof Container)) continue;
                this.limpaCamposIncorretos((Container)aux);
            }
        }
    }

    public boolean isOk() {
        return this.isOk;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOk) {
            if (!this.validarCampos()) {
                return;
            }
            this.faturamentoEletronico.getValoresPreenchidos(this.requisicaoAux, procedimentos.getListaExames(), this.configuracaoAux);
            this.isOk = true;
            this.setVisible(false);
        } else if (e.getSource() == this.buttonCancelar) {
            this.isOk = false;
            this.setVisible(false);
        }
    }

    public boolean validarCampos() {
        if (lograudouroPaciente.getValor() == null || Funcoes.textoVazio(lograudouroPaciente.getValor().toString())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Campo logradouro obrigat\u00f3rio.", 2);
            ScreenUtil.requisitarFoco(lograudouroPaciente);
            return false;
        }
        if (enderecoPaciente.getValor() == null || Funcoes.textoVazio(enderecoPaciente.getValor().toString())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Campo endere\u00e7o obrigat\u00f3rio.", 2);
            ScreenUtil.requisitarFoco(enderecoPaciente);
            return false;
        }
        if (numeroEndereco.getValor() == null || Funcoes.textoVazio(numeroEndereco.getValor().toString())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Campo N\u00famero obrigat\u00f3rio.", 2);
            ScreenUtil.requisitarFoco(numeroEndereco);
            return false;
        }
        if (bairroEndereco.getValor() == null || Funcoes.textoVazio(bairroEndereco.getValor().toString())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Campo bairro obrigat\u00f3rio.", 2);
            ScreenUtil.requisitarFoco(bairroEndereco);
            return false;
        }
        if (cidadeEndereco.getValor() == null || Funcoes.textoVazio(cidadeEndereco.getValor().toString())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Campo cidade obrigat\u00f3rio.", 2);
            ScreenUtil.requisitarFoco(cidadeEndereco);
            return false;
        }
        if (codigoIbge.getValor() == null || Funcoes.textoVazio(codigoIbge.getValor().toString())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Campo c\u00f3digo ibge obrigat\u00f3rio.", 2);
            ScreenUtil.requisitarFoco(codigoIbge);
            return false;
        }
        if (cepEndereco.getValor() == null || Funcoes.textoVazio(cepEndereco.getValor().toString())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Campo cep obrigat\u00f3rio.", 2);
            ScreenUtil.requisitarFoco(cepEndereco);
            return false;
        }
        if (cepEndereco.getValor() != null && cepEndereco.getValor().toString().length() != 9) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "CEP inv\u00e1lido.", 2);
            ScreenUtil.requisitarFoco(cepEndereco);
            return false;
        }
        RacaCorPaciente rcp = (RacaCorPaciente)((Object)racaCorPaciente.getValor());
        if (rcp.equals((Object)RacaCorPaciente.OUTRO) || rcp.equals((Object)RacaCorPaciente.NAO_INFORMADO)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Ra\u00e7a/cor do Paciente inv\u00e1lida.", 2);
            ScreenUtil.requisitarFoco(racaCorPaciente);
            return false;
        }
        if (rcp.equals((Object)RacaCorPaciente.INDIGENA) && (etniaPaciente.getValor() == null || Funcoes.textoVazio(etniaPaciente.getValor().toString()))) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Campo Etnia do Paciente obrigat\u00f3rio.", 2);
            ScreenUtil.requisitarFoco(etniaPacienteDesc);
            return false;
        }
        if (nacionalidadePaciente.getValor() != null && Funcoes.textoVazio(nacionalidadePaciente.getValor().toString())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Nacionalidade do Paciente inv\u00e1lida.", 2);
            ScreenUtil.requisitarFoco(nacionalidadePaciente);
            return false;
        }
        return this.validaCartaoSUS();
    }

    private JPanel getPanelLegenda() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel panelLegenda = new JPanel();
        panelLegenda.setPreferredSize(new Dimension(10, 10));
        panelLegenda.setBackground(this.COR_OBRIGATORIOS);
        panelLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        panel.add((Component)panelLegenda, c);
        JLabel labelLegenda = new JLabel("Campo obrigat\u00f3rio");
        Font font = new Font(labelLegenda.getFont().getName(), 0, 10);
        labelLegenda.setFont(font);
        ++c.gridx;
        panel.add((Component)labelLegenda, c);
        ++c.gridx;
        c.insets = new Insets(1, 10, 1, 1);
        panelLegenda = new JPanel();
        panelLegenda.setPreferredSize(new Dimension(10, 10));
        panelLegenda.setBackground(this.COR_INCORRETOS);
        panelLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        panel.add((Component)panelLegenda, c);
        labelLegenda = new JLabel("Campo incorreto");
        font = new Font(labelLegenda.getFont().getName(), 0, 10);
        labelLegenda.setFont(font);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 1);
        panel.add((Component)labelLegenda, c);
        return panel;
    }

    public DadosFaturamento getRequisicao() {
        return this.requisicaoAux;
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.primeiroCampoIncorreto != null) {
            ScreenUtil.requisitarFoco(this.primeiroCampoIncorreto);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    class CampoTable
    extends JPanel {
        private ModeloGridTable modelo = null;
        private JTable table = null;
        private JScrollPane scroll = null;
        private float proporcaoLargura = 0.0f;
        private int[] colunasObrigatorias = null;
        private int[] colunasEditaveis = null;
        private ArrayList<AbstractFaturamentoEletronico.ErroExame> colunasIncorretas = null;
        private Border bordaOriginal = new JLabel().getBorder();
        private int tipoTabela = -1;
        private Boolean isConsolidado;

        public CampoTable(String[] colunas, int[] tamanhoColunas, Class[] tipoColunas, int[] colunasEditaveis, int tipoTabela, float proporcaoLargura) {
            this.proporcaoLargura = proporcaoLargura;
            this.tipoTabela = tipoTabela;
            this.colunasEditaveis = colunasEditaveis;
            this.modelo = new ModeloGridTable(colunas){

                public Class getColumnClass(int i) {
                    if (i >= 2 && i <= 3) {
                        return Boolean.class;
                    }
                    return Object.class;
                }
            };
            this.table = new JTable(this.modelo);
            this.table.getTableHeader().setReorderingAllowed(false);
            this.table.setRowHeight(15);
            this.table.getSelectionModel().setSelectionMode(0);
            this.table.setRowSelectionAllowed(false);
            this.table.setCellSelectionEnabled(true);
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    CampoTable.this.selecionaColunaExame();
                }
            });
            this.table.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        return;
                    }
                    if (e.getKeyCode() == 32) {
                        CampoTable.this.selecionaColunaExame();
                    }
                    super.keyPressed(e);
                }
            });
            this.scroll = new JScrollPane(this.table);
            this.table.getTableHeader().setFont(this.table.getTableHeader().getFont().deriveFont(11.0f));
            this.modelo.setColumnSize(tamanhoColunas, this.table);
            this.montaCampo();
        }

        public void clear() {
            if (this.modelo != null) {
                this.modelo.clear();
            }
        }

        private void selecionaColunaExame() {
            int rowIndex = this.table.getSelectedRow();
            int columnIndex = this.table.getSelectedColumn();
            if (this.colunasEditaveis != null) {
                for (int i = 0; i < this.colunasEditaveis.length; ++i) {
                    if (this.colunasEditaveis[i] != columnIndex) continue;
                    this.isConsolidado = (Boolean)this.modelo.getValueAt(rowIndex, 3);
                    this.modelo.setValueAt(this.isConsolidado, rowIndex, 2);
                    this.modelo.fireTableCellUpdated(rowIndex, 2);
                    this.modelo.setValueAt(this.isConsolidado == false, rowIndex, 3);
                    this.modelo.fireTableCellUpdated(rowIndex, 3);
                    DadosExameFaturamento dadosExameFaturamento = (DadosExameFaturamento)this.modelo.getValueAt(rowIndex, 4);
                    dadosExameFaturamento.setTipoBPA(this.isConsolidado != false ? "C" : "I");
                    this.modelo.setValueAt(dadosExameFaturamento, rowIndex, 4);
                }
            }
        }

        private void setColunasObrigatorias(int[] colunasObrigatorias) {
            if (colunasObrigatorias != null) {
                for (int i = 0; i < colunasObrigatorias.length; ++i) {
                    this.table.getColumnModel().getColumn(colunasObrigatorias[i]).setHeaderRenderer(new RendererObrigatorio());
                }
            }
        }

        public int[] getColunasObrigatorias() {
            return this.colunasObrigatorias;
        }

        private void montaCampo() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.scroll, "Center");
            this.setPreferredSize(new Dimension((int)(this.proporcaoLargura * 620.0f / 25.0f), 66));
            this.setMinimumSize(new Dimension((int)(this.proporcaoLargura * 620.0f / 25.0f), 66));
        }

        public void addLinha(Object[] linha) {
            this.modelo.addLine(linha);
        }

        public int getRowCount() {
            return this.modelo.getRowCount();
        }

        public HashMap<String, Object> getLineAt(int line) {
            return this.modelo.getLine(line);
        }

        public void setColunasIncorretas(ArrayList<AbstractFaturamentoEletronico.ErroExame> colunasIncorretas) {
            this.colunasIncorretas = colunasIncorretas;
        }

        public Boolean getIsConsolidado() {
            return this.isConsolidado;
        }

        public void setIsConsolidado(Boolean isConsolidado) {
            this.isConsolidado = isConsolidado;
        }

        public ArrayList<DadosExameFaturamento> getListaExames() {
            int coluna;
            int n = coluna = this.tipoTabela == 0 ? 4 : 0;
            if (this.modelo != null) {
                ArrayList<DadosExameFaturamento> listaExames = new ArrayList<DadosExameFaturamento>();
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    DadosExameFaturamento exames = (DadosExameFaturamento)this.modelo.getValueAt(i, coluna);
                    if (exames == null) continue;
                    listaExames.add(exames);
                }
                if (listaExames.size() > 0) {
                    return listaExames;
                }
                return null;
            }
            return null;
        }

        class RendererObrigatorio
        extends DefaultTableCellRenderer {
            RendererObrigatorio() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                comp.setForeground(JanelaConfiguracaoFaturamentoBPA.this.COR_OBRIGATORIOS);
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                this.setBackground(UIManager.getColor("TableHeader.cellBackground"));
                this.setFont(UIManager.getFont("TableHeader.font").deriveFont(11.0f));
                this.setHorizontalAlignment(0);
                return comp;
            }
        }
    }

    class CampoCombo
    extends CampoBPA {
        private JComboBox comboValor;

        public CampoCombo(String rotulo, Object[] valores, float proporcaoLargura) {
            super(rotulo, proporcaoLargura);
            this.comboValor = null;
            this.comboValor = new JComboBox<Object>(valores);
            this.comboValor.setFont(this.comboValor.getFont().deriveFont(10.0f));
            this.comboValor.addFocusListener(new CampoBPA.ListenerFocoCampo());
            this.montaCampo();
        }

        private void montaCampo() {
            ((CampoBPA)this).montaCampo();
            this.add((Component)this.comboValor, "Center");
        }

        public void setValor(Object valor) {
            for (int i = 0; i < this.comboValor.getItemCount(); ++i) {
                if (!this.comboValor.getItemAt(i).toString().equalsIgnoreCase(valor.toString())) continue;
                this.comboValor.setSelectedIndex(i);
                break;
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.comboValor.setEnabled(isEnabled);
            this.comboValor.setFocusable(isEnabled);
        }

        @Override
        public Object getValor() {
            return this.comboValor.getSelectedItem();
        }

        @Override
        public void setIncorreto(boolean isIncorreto) {
            this.isIncorreto = isIncorreto;
            if (isIncorreto) {
                if (this.bordaOriginal == null) {
                    this.bordaOriginal = this.comboValor.getBorder();
                }
                this.comboValor.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 1, 0), new LineBorder(Color.RED, 1, false)));
                this.comboValor.repaint();
            } else if (this.bordaOriginal != null) {
                this.comboValor.setBorder(this.bordaOriginal);
                this.comboValor.repaint();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            ScreenUtil.requisitarFoco(this.comboValor);
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void setToolTipText(String toollTip) {
            this.comboValor.setToolTipText(toollTip);
            this.labelRotulo.setToolTipText(toollTip);
        }

        public void addItemStateChanged(ItemListener itemListener) {
            this.comboValor.addItemListener(itemListener);
        }
    }

    class CampoTexto
    extends CampoBPA
    implements FocusListener {
        private TTextField textValor;
        private int tipoDado;

        public CampoTexto(String rotulo, int qtdeCaracteres, int tipoDado, float proporcaoLargura) {
            super(rotulo, proporcaoLargura);
            this.textValor = null;
            this.tipoDado = -1;
            this.tipoDado = tipoDado;
            this.textValor = new TTextField(qtdeCaracteres, tipoDado);
            this.textValor.setFont(this.textValor.getFont().deriveFont(10.0f));
            this.textValor.addFocusListener(new CampoBPA.ListenerFocoCampo());
            this.montaCampo();
        }

        public void alinhamentoHorizontal() {
            this.textValor.setHorizontalAlignment(2);
            this.textValor.updateUI();
        }

        public CampoTexto(String rotulo, float proporcaoLargura) {
            super(rotulo, proporcaoLargura);
            this.textValor = null;
            this.tipoDado = -1;
            this.tipoDado = 3;
            this.textValor = new TTextField(20, "[a-zA-Z0-9./-]+");
            this.textValor.setFont(this.textValor.getFont().deriveFont(10.0f));
            this.textValor.addFocusListener(new CampoBPA.ListenerFocoCampo());
            this.montaCampo();
        }

        private void montaCampo() {
            ((CampoBPA)this).montaCampo();
            this.add((Component)this.textValor, "Center");
        }

        public void setValor(String valor) {
            if (this.tipoDado == 2 && valor != null && !Funcoes.textoVazio(valor) && Funcoes.isNumeric(valor)) {
                this.textValor.setText(Funcoes.formataDecimal(Double.parseDouble(Funcoes.limpaDecimal(valor))));
            } else {
                this.textValor.setText(valor);
                if (!Funcoes.textoVazio(valor)) {
                    this.setIncorreto(false);
                }
            }
        }

        public void setEditable(boolean isEditable) {
            this.textValor.setEditable(isEditable);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.textValor.setEnabled(isEnabled);
            this.textValor.setFocusable(isEnabled);
        }

        @Override
        public Object getValor() {
            return Funcoes.textoVazio(this.textValor) ? null : this.textValor.getText();
        }

        @Override
        public void setIncorreto(boolean isIncorreto) {
            this.isIncorreto = isIncorreto;
            if (isIncorreto) {
                if (this.bordaOriginal == null) {
                    this.bordaOriginal = this.textValor.getBorder();
                }
                this.textValor.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 1, 0), new LineBorder(Color.RED, 1, false)));
                this.textValor.repaint();
            } else if (this.bordaOriginal != null) {
                this.textValor.setBorder(this.bordaOriginal);
                this.textValor.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void setToolTipText(String toolTip) {
            this.textValor.setToolTipText(toolTip);
            this.labelRotulo.setToolTipText(toolTip);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public synchronized void addKeyListener(KeyListener l) {
            this.textValor.addKeyListener(l);
        }

        public synchronized void addFocusListenerText(FocusListener l) {
            this.textValor.addFocusListener(l);
        }
    }

    abstract class CampoBPA
    extends JPanel
    implements FocusListener {
        protected JLabel labelRotulo = null;
        protected float proporcaoLargura = 0.0f;
        protected boolean isObrigatorio = false;
        protected boolean isIncorreto = false;
        protected Border bordaOriginal = null;
        protected String valorAnterior = "";

        public CampoBPA(String rotulo, float proporcaoLargura) {
            this.proporcaoLargura = proporcaoLargura;
            if (rotulo != null && !Funcoes.textoVazio(rotulo)) {
                this.labelRotulo = new JLabel(rotulo);
                this.labelRotulo.setFont(this.labelRotulo.getFont().deriveFont(11.0f));
                if (this.isObrigatorio) {
                    this.labelRotulo.setForeground(JanelaConfiguracaoFaturamentoBPA.this.COR_OBRIGATORIOS);
                }
            }
            this.addFocusListener(this);
        }

        private void setObrigatorio(boolean isObrigatorio) {
            this.isObrigatorio = isObrigatorio;
            this.labelRotulo.repaint();
        }

        private boolean getObrigatorio() {
            return this.isObrigatorio;
        }

        private void montaCampo() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.labelRotulo, "North");
            int largura = (int)(this.proporcaoLargura * 620.0f / 25.0f);
            this.setPreferredSize(new Dimension(largura, 33));
            this.setMinimumSize(new Dimension(largura, 33));
            this.setMaximumSize(new Dimension(largura, 33));
        }

        public abstract Object getValor();

        public abstract void setIncorreto(boolean var1);

        @Override
        public abstract void setEnabled(boolean var1);

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.isObrigatorio) {
                this.labelRotulo.setForeground(JanelaConfiguracaoFaturamentoBPA.this.COR_OBRIGATORIOS);
            }
        }

        @Override
        public abstract void setToolTipText(String var1);

        class ListenerFocoCampo
        implements FocusListener {
            ListenerFocoCampo() {
            }

            @Override
            public void focusGained(FocusEvent e) {
                CampoBPA.this.valorAnterior = CampoBPA.this.getValor() == null ? "" : CampoBPA.this.getValor().toString();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && CampoBPA.this.isObrigatorio) {
                    JanelaConfiguracaoFaturamentoBPA.this.faturamentoEletronico.getValoresPreenchidos(JanelaConfiguracaoFaturamentoBPA.this.requisicaoAux, procedimentos.getListaExames(), JanelaConfiguracaoFaturamentoBPA.this.configuracaoAux);
                    ArrayList<DadosFaturamento> lista = new ArrayList<DadosFaturamento>();
                    lista.add(JanelaConfiguracaoFaturamentoBPA.this.requisicaoAux);
                    JanelaConfiguracaoFaturamentoBPA.this.faturamentoEletronico.verificaErrosFatura(lista, JanelaConfiguracaoFaturamentoBPA.this.configuracaoAux);
                    JanelaConfiguracaoFaturamentoBPA.this.setCamposIncorretosBPA(JanelaConfiguracaoFaturamentoBPA.this.faturamentoEletronico.getCamposIncorretosBPA(JanelaConfiguracaoFaturamentoBPA.this.requisicaoAux, JanelaConfiguracaoFaturamentoBPA.this.guiaAux), JanelaConfiguracaoFaturamentoBPA.this.faturamentoEletronico.getColunasIncorretasSolicitados(JanelaConfiguracaoFaturamentoBPA.this.requisicaoAux, JanelaConfiguracaoFaturamentoBPA.this.guiaAux), JanelaConfiguracaoFaturamentoBPA.this.faturamentoEletronico.getColunasIncorretasExecutados(JanelaConfiguracaoFaturamentoBPA.this.requisicaoAux, JanelaConfiguracaoFaturamentoBPA.this.guiaAux));
                }
            }
        }
    }
}

