/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ArquivoFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ConfigurarIbcm;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.GuiaVirtual;
import jalis.laboratorio.util.faturamento.eletronico.JanelaConfiguracaoFaturamentoBPA;
import jalis.util.ConvenioUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class Ibcm
extends AbstractFaturamentoEletronico
implements FaturamentoEletronico {
    Registro config = null;
    StringBuilder conteudo = new StringBuilder();
    private static final String[] CARACTERES_PROIBIDOS = new String[]{",", ".", "/", "-"};
    private static final String[] CARACTERES_PROIBIDOS_ESPACAMENTO = new String[]{",", ".", "/", "-", " "};
    private int casasDecimais = 2;
    private RoundingMode arredondamento = ParametrosGerais.getArredondamentoPrecoExame();
    private final Campos CABECALHO_TIPO_REGISTRO = new Campos(1, 1, "N");
    private final Campos CABECALHO_CODIGO_CONVENIO = new Campos(2, 7, "N");
    private final Campos CABECALHO_COMPETENCIA = new Campos(8, 13, "R");
    private final Campos CABECALHO_VALOR_TOTAL_FATURA = new Campos(14, 25, "E");
    private final Campos DETALHE_TIPO_REGISTRO = new Campos(1, 1, "N");
    private final Campos DETALHE_DATA_ATENDIMENTO = new Campos(2, 9, "D");
    private final Campos DETALHE_MATRICULA_IBCM = new Campos(10, 19, "S");
    private final Campos DETALHE_MATRICULA_IPE_PACIENTE = new Campos(20, 32, "N");
    private final Campos DETALHE_CATEGORIA_IPE_PACIENTE = new Campos(33, 34, "N");
    private final Campos DETALHE_TIPO_PROCEDIMENTO = new Campos(35, 36, "N");
    private final Campos DETALHE_CODIGO_PROCEDIMENTO = new Campos(37, 48, "S");
    private final Campos DETALHE_NOME_PACIENTE = new Campos(49, 88, "S");
    private final Campos DETALHE_VALOR_SESSAO = new Campos(89, 98, "N");
    private final Campos DETALHE_NRO_CREMERS = new Campos(99, 106, "N");
    private final Campos DETALHE_NUMERO_PARCELAS = new Campos(107, 108, "N");
    private PreparedStatement psFatura = null;
    private PreparedStatement psRequisicao = null;
    private PreparedStatement psExame = null;

    public Ibcm() {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fat.fat_dtvenc as dataFatura ");
        buf.append("       ,(");
        buf.append("              select sum(fer.fer_totalmateriais) + sum(fer.fer_total) ");
        buf.append("              from fatura                fat ");
        buf.append("              join faturarequisicao      fre on fat.fil_codigo = fre.fil_codigo and fat.fat_codigo = fre.fat_codigo ");
        buf.append("              join faturaexamerequisicao fer on fre.fil_codigo = fer.fil_codigo and fre.fat_codigo = fer.fat_codigo and fre.req_codigo = fer.req_codigo and fre.fil_kodigo = fer.fil_kodigo ");
        buf.append("              join requisicao            req on fre.fil_kodigo = req.fil_codigo and fre.req_codigo = req.req_codigo ");
        buf.append("              where fat.fil_codigo = ? ");
        buf.append("              and fat.fat_codigo = ? ");
        buf.append("              and fat.fat_datacancelamento is null ");
        buf.append("              and not req.req_excluida ");
        buf.append("       ) as valorFatura");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.con_codrepasse IS NOT NULL as isRepasse ");
        buf.append("       ,req.req_matricularepasse as matriculaRepasse ");
        buf.append("       ,req.req_matricula as matricula ");
        buf.append("       ,req.req_nomeplanorepasse as categoriaRepasse ");
        buf.append("       ,req.med_crm as crmMedico ");
        buf.append("       ,emc.emc_codigoamb as ambExame ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,req.req_codigo ");
        buf.append("   from fatura                fat ");
        buf.append("   join faturarequisicao      fre on fat.fil_codigo = fre.fil_codigo and fat.fat_codigo = fre.fat_codigo ");
        buf.append("   join faturaexamerequisicao fer on fre.fil_codigo = fer.fil_codigo and fre.fat_codigo = fer.fat_codigo and fre.req_codigo = fer.req_codigo and fre.fil_kodigo = fer.fil_kodigo ");
        buf.append("   join requisicao            req on fre.fil_kodigo = req.fil_codigo and fre.req_codigo = req.req_codigo ");
        buf.append("   join paciente              pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join examerequisicao       exr on fer.fil_kodigo = exr.fil_codigo and fer.req_codigo = exr.req_codigo and fer.exa_codigo = exr.exa_codigo and fer.mco_codigo = exr.mco_codigo ");
        buf.append("   join examematcoleta        emc on exr.fil_codigo = emc.fil_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
        buf.append("  where fat.fil_codigo = ? ");
        buf.append("    and fat.fat_codigo = ? ");
        buf.append("    and fat.fat_datacancelamento is null ");
        buf.append("    and not req.req_excluida ");
        this.psFatura = Conexao.getPreparedStatement(buf.toString());
    }

    private String substring(String str, int tamanho) {
        return str.substring(0, str.length() > tamanho ? tamanho : str.length());
    }

    private String getValor(Campos campo, Object valor) throws Exception {
        if (campo == null) {
            throw new Exception("Campo n\u00e3o informado.");
        }
        if (valor == null) {
            if (campo.tipo.equalsIgnoreCase("N")) {
                return Funcoes.preencheZero(0, campo.tamanho);
            }
            return Funcoes.preencheVazio(" ", campo.tamanho, 1);
        }
        if (campo.tipo.equalsIgnoreCase("E")) {
            if (valor instanceof BigDecimal) {
                valor = ((BigDecimal)valor).setScale(this.casasDecimais, this.arredondamento);
                String aux = StringUtil.limpaString(valor.toString(), CARACTERES_PROIBIDOS);
                return this.substring(Funcoes.preencheZero(aux, campo.tamanho), campo.tamanho);
            }
            throw new Exception("Valor decimal incorreto. Tipo = " + valor.getClass() + ".");
        }
        if (campo.tipo.equalsIgnoreCase("N")) {
            if (valor instanceof Integer || valor instanceof Double || valor instanceof BigDecimal) {
                String aux = StringUtil.limpaString(valor.toString(), CARACTERES_PROIBIDOS);
                return this.substring(Funcoes.preencheZero(aux, campo.tamanho), campo.tamanho);
            }
            throw new Exception("Valor inteiro incorreto");
        }
        if (campo.tipo.equalsIgnoreCase("S")) {
            if (valor instanceof String) {
                valor = StringUtil.limpaString(valor.toString(), CARACTERES_PROIBIDOS);
                return this.substring(Funcoes.preencheVazio(valor.toString(), campo.tamanho, 2), campo.tamanho);
            }
            throw new Exception("Valor 'string' incorreto");
        }
        if (campo.tipo.equalsIgnoreCase("R")) {
            if (valor instanceof Date) {
                return this.substring(Funcoes.formataData("yyyyMM", (Date)valor), campo.tamanho);
            }
            throw new Exception("Valor de data incorreto");
        }
        if (campo.tipo.equalsIgnoreCase("D")) {
            if (valor instanceof Date) {
                return this.substring(Funcoes.formataData("ddMMyyyy", (Date)valor), campo.tamanho);
            }
            throw new Exception("Valor de data incorreto");
        }
        throw new Exception("Tipo de dados desconhecido");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<ArquivoFaturamentoEletronico> criarArquivo(Object owner, int codigoFatura, String codigoConvenio, String diretorioArquivos) {
        ArrayList<ArquivoFaturamentoEletronico> retorno;
        Statement st;
        block7: {
            StringBuilder buf = new StringBuilder();
            st = Conexao.getStatement();
            retorno = new ArrayList<ArquivoFaturamentoEletronico>();
            try {
                buf.append(" select con.con_codigo  ");
                buf.append("       ,con.con_faturaeletronica ");
                buf.append("   from fatura    fat ");
                buf.append("   join convenios con on fat.fil_codigo = con.fil_codigo and fat.con_codigo = con.con_codigo ");
                buf.append("  where fat.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and fat.fat_codigo = ").append(codigoFatura);
                buf.append("    and fat.fat_datacancelamento is null ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) {
                    throw new Exception("Fatura n\u00e3o localizada.");
                }
                this.config = this.parseXMLConfiguracao(rs.getString("con_faturaeletronica"));
                this.config.setValor("con_codigo", rs.getString("con_codigo"));
                if (this.config == null) break block7;
                retorno = this.gerarArquivo(codigoFatura, codigoConvenio);
                buf.delete(0, buf.length());
                buf.append(" update convenios ");
                buf.append("    set con_faturaeletronica = '").append(StringUtil.textoDB(this.registroToXML(this.config))).append("' ");
                buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and con_codigo = ").append(this.config.getValor("con_codigo"));
                Conexao.execute(Variaveis.filialPadrao, st, buf);
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private ArrayList<ArquivoFaturamentoEletronico> gerarArquivo(int codigoFatura, String codigoConvenio) throws Exception {
        if (this.config == null) {
            throw new Exception("XML de configura\u00e7\u00e3o n\u00e3o informado");
        }
        this.psFatura.setInt(1, Integer.parseInt(Variaveis.filialPadrao));
        this.psFatura.setInt(2, codigoFatura);
        this.psFatura.setInt(3, Integer.parseInt(Variaveis.filialPadrao));
        this.psFatura.setInt(4, codigoFatura);
        ResultSet rsFatura = this.psFatura.executeQuery();
        Date dataCompetencia = null;
        if (rsFatura.next()) {
            this.casasDecimais = ParametrosGerais.getCasasPrecoExame();
            this.arredondamento = ParametrosGerais.getArredondamentoPrecoExame();
            DadosConvenios dadosConvenios = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, Integer.parseInt(codigoConvenio));
            if (!Funcoes.objectIsNull(dadosConvenios) && dadosConvenios.getConvenioUtilizarCasasDecimais()) {
                this.casasDecimais = dadosConvenios.getConvenioCasasPrecoExame();
                this.arredondamento = dadosConvenios.getConvenioTipoArredondamentoPrecoRoundingMode();
            }
            dataCompetencia = rsFatura.getDate("dataFatura");
            this.escreveCabecalho(rsFatura);
            do {
                if (this.escreveDetalhe(rsFatura)) continue;
                Funcoes.mensagem(Laboratorio.getInstancia(), "O arquivo eletr\u00f4nico n\u00e3o pode ser gerado.", 1);
                return null;
            } while (rsFatura.next());
        }
        StringBuilder nomeArquivo = new StringBuilder();
        nomeArquivo.append(this.config.getValor("codigoConvenio"));
        nomeArquivo.append("-");
        nomeArquivo.append(Funcoes.formataData("MM", dataCompetencia));
        ArrayList<ArquivoFaturamentoEletronico> retorno = new ArrayList<ArquivoFaturamentoEletronico>();
        retorno.add(new ArquivoFaturamentoEletronico(nomeArquivo.toString(), this.conteudo.toString()));
        return retorno;
    }

    private void escreveCabecalho(ResultSet rs) throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es do faturamento eletr\u00f4nico n\u00e3o foram carregadas.", 2);
            return;
        }
        if (((String)this.config.getValor("versaoLayout")).equalsIgnoreCase(String.valueOf(ConfigurarIbcm.VersaoLayout.VERSAO_LAYOUT_1.codigo))) {
            StringBuilder aux = new StringBuilder();
            aux.append(this.getValor(this.CABECALHO_TIPO_REGISTRO, TipoRegistro.CABECALHO.codigo));
            aux.append(this.getValor(this.CABECALHO_CODIGO_CONVENIO, Integer.parseInt(this.config.getValor("codigoConvenio").toString())));
            aux.append(this.getValor(this.CABECALHO_COMPETENCIA, rs.getDate("dataFatura")));
            aux.append(this.getValor(this.CABECALHO_VALOR_TOTAL_FATURA, rs.getBigDecimal("valorFatura")));
            this.conteudo.append((CharSequence)aux);
        }
        this.conteudo.append("\n");
    }

    private boolean escreveDetalhe(ResultSet rs) throws Exception {
        if (((String)this.config.getValor("versaoLayout")).equalsIgnoreCase(String.valueOf(ConfigurarIbcm.VersaoLayout.VERSAO_LAYOUT_1.codigo))) {
            String categoria;
            String string = categoria = rs.getBoolean("isRepasse") && rs.getString("categoriaRepasse") != null && !Funcoes.textoVazio(rs.getString("categoriaRepasse")) ? StringUtil.limpaString(rs.getString("categoriaRepasse"), CARACTERES_PROIBIDOS_ESPACAMENTO) : "1";
            if (!Funcoes.isNumeric(categoria)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "O valor informado na categoria da requisi\u00e7\u00e3o " + rs.getString("req_codigo") + " n\u00e3o \u00e9 v\u00e1lido.", 1);
                return false;
            }
            StringBuilder aux = new StringBuilder();
            aux.append(this.getValor(this.DETALHE_TIPO_REGISTRO, TipoRegistro.DETALHE.codigo));
            aux.append(this.getValor(this.DETALHE_DATA_ATENDIMENTO, rs.getDate("dataRequisicao")));
            aux.append(this.getValor(this.DETALHE_MATRICULA_IBCM, rs.getBoolean("isRepasse") ? rs.getString("matriculaRepasse") : rs.getString("matricula")));
            aux.append(this.getValor(this.DETALHE_MATRICULA_IPE_PACIENTE, rs.getBoolean("isRepasse") && rs.getString("matricula") != null && !Funcoes.textoVazio(rs.getString("matricula")) ? new BigDecimal(StringUtil.limpaString(rs.getString("matricula"), CARACTERES_PROIBIDOS_ESPACAMENTO)) : null));
            aux.append(this.getValor(this.DETALHE_CATEGORIA_IPE_PACIENTE, rs.getBoolean("isRepasse") && rs.getString("categoriaRepasse") != null && !Funcoes.textoVazio(rs.getString("categoriaRepasse")) ? new Integer(StringUtil.limpaString(rs.getString("categoriaRepasse"), CARACTERES_PROIBIDOS_ESPACAMENTO)) : null));
            aux.append(this.getValor(this.DETALHE_TIPO_PROCEDIMENTO, rs.getBoolean("isRepasse") ? TipoProcedimento.EXAME_COM_COBERTURA_IPE.codigo : TipoProcedimento.EXAME_SEM_COBERTURA_IPE.codigo));
            aux.append(this.getValor(this.DETALHE_CODIGO_PROCEDIMENTO, rs.getString("ambExame")));
            aux.append(this.getValor(this.DETALHE_NOME_PACIENTE, rs.getString("nomePaciente")));
            aux.append(this.getValor(this.DETALHE_VALOR_SESSAO, null));
            aux.append(this.getValor(this.DETALHE_NRO_CREMERS, rs.getInt("crmMedico")));
            aux.append(this.getValor(this.DETALHE_NUMERO_PARCELAS, 1));
            this.conteudo.append((CharSequence)aux);
        }
        this.conteudo.append("\n");
        return true;
    }

    @Override
    public Registro parseXMLConfiguracao(String xml) {
        Registro r = new Registro();
        r.setValor("codigoConvenio", StringUtil.getValor(xml, "codigoConvenio"));
        r.setValor("versaoLayout", StringUtil.getValor(xml, "versaoLayout"));
        return r;
    }

    private String registroToXML(Registro r) {
        StringBuilder buf = new StringBuilder("<faturamentoEletronico>");
        buf.append("<protocolo>").append(Ibcm.getNomeProtocolo()).append("</protocolo>");
        buf.append(StringUtil.getTag("codigoConvenio", r.getValor("codigoConvenio").toString()));
        buf.append(StringUtil.getTag("versaoLayout", r.getValor("versaoLayout").toString()));
        buf.append("</faturamentoEletronico>");
        return buf.toString();
    }

    public String configurar(JDialog parent, String xml) {
        String retorno = xml;
        ConfigurarIbcm conf = new ConfigurarIbcm(parent);
        conf.setXML(xml);
        conf.setVisible(true);
        if (conf.ok()) {
            retorno = conf.getXML();
            this.config = this.parseXMLConfiguracao(retorno);
        }
        return retorno;
    }

    @Override
    public String configurar(JFrame parent, String xml) {
        String retorno = xml;
        ConfigurarIbcm conf = new ConfigurarIbcm(parent);
        if (xml != null && !Funcoes.textoVazio(xml)) {
            conf.setXML(xml);
        }
        conf.setVisible(true);
        if (conf.ok()) {
            retorno = conf.getXML();
            this.config = this.parseXMLConfiguracao(retorno);
        }
        return retorno;
    }

    @Override
    public boolean solicitarDiretorioNoInicio() {
        return true;
    }

    @Override
    public String[] situacoesPermitidasExame(String xml) {
        return null;
    }

    @Override
    public boolean validarCasasDecimais() {
        return true;
    }

    public static String getNomeProtocolo() {
        return "Ibcm";
    }

    public static String getExtensaoArquivo() {
        return "txt";
    }

    @Override
    public String getCodificacaoArquivo() {
        return FaturamentoEletronico.CODIFICACAO.ISO_8859_1.codificacao;
    }

    @Override
    public void verificaErrosFatura(ArrayList<DadosFaturamento> requisicoes, Registro configuracaoConvenio0) {
    }

    @Override
    public ArrayList<GuiaVirtual.Campo> getCamposObrigatorios(String versao) {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasSolicitados() {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasExecutados() {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampo> getCamposIncorretos(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasSolicitados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasExecutados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public boolean gravaAlteracoes(DadosFaturamento requisicao, String guia, Registro configuracao) {
        return false;
    }

    @Override
    public void preencheValoresCampos(DadosFaturamento requisicao, Registro configuracaoEletronico, String guia) {
    }

    @Override
    public void preencheValoresTabelas(DadosFaturamento requisicao, String guia) {
    }

    @Override
    public void getValoresPreenchidos(DadosFaturamento requisicao, ArrayList<DadosExameFaturamento> exames, Registro configuracaoEletronico) {
    }

    @Override
    public void aplicarModificacoesGerais(ArrayList<DadosFaturamento> requisicoes, DadosFaturamento requisicao, DadosFaturamento requisicaoModificada, Registro configuracaoEletronico, Registro configuracaoEletronicoModificada) {
    }

    @Override
    public Object[] getListaDadosAdicionais() {
        return null;
    }

    @Override
    public void setListaDadosAdicionais(Object[] listaDadosAdicionais) {
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampoBPA> getCamposIncorretosBPA(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<JanelaConfiguracaoFaturamentoBPA.CampoBPA> getCamposObrigatoriosBPA() {
        return null;
    }

    class Campos {
        public static final String TIPO_STRING = "S";
        public static final String TIPO_NUMERO = "N";
        public static final String TIPO_DATA_REDUZIDA = "R";
        public static final String TIPO_DATA = "D";
        public static final String TIPO_DECIMAL = "E";
        int posIni = -1;
        int posFim = -1;
        int tamanho = -1;
        String tipo = "S";

        public Campos(int posicaoInicial, int posicaoFinal, String tipo) {
            this.posIni = posicaoInicial;
            this.posFim = posicaoFinal;
            this.tamanho = posicaoFinal - posicaoInicial + 1;
            this.tipo = tipo;
        }
    }

    private static enum TipoProcedimento {
        EXAME_COM_COBERTURA_IPE(2),
        EXAME_SEM_COBERTURA_IPE(4);

        public final Integer codigo;

        private TipoProcedimento(Integer codigo) {
            this.codigo = codigo;
        }
    }

    private static enum TipoRegistro {
        CABECALHO(0),
        DETALHE(1);

        public final int codigo;

        private TipoRegistro(int codigo) {
            this.codigo = codigo;
        }
    }
}

