/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import br.com.thread.openpdf.text.Image;
import br.com.thread.openpdf.text.PageSize;
import br.com.thread.openpdf.text.Rectangle;
import br.com.thread.openpdf.text.pdf.PdfContentByte;
import br.com.thread.openpdf.text.pdf.PdfImage;
import br.com.thread.openpdf.text.pdf.PdfIndirectObject;
import br.com.thread.openpdf.text.pdf.PdfName;
import br.com.thread.openpdf.text.pdf.PdfObject;
import br.com.thread.openpdf.text.pdf.PdfReader;
import br.com.thread.openpdf.text.pdf.PdfStamper;
import br.com.thread.pdfbox.multipdf.PDFMergerUtility;
import br.com.thread.pdfbox.pdmodel.PDDocument;
import br.com.thread.pdfbox.pdmodel.PDPage;
import br.com.thread.pdfbox.pdmodel.PDPageContentStream;
import br.com.thread.pdfbox.pdmodel.common.PDRectangle;
import br.com.thread.pdfbox.pdmodel.graphics.image.JPEGFactory;
import br.com.thread.pdfbox.pdmodel.graphics.image.PDImageXObject;
import br.com.thread.pdfbox.rendering.ImageType;
import br.com.thread.pdfbox.rendering.PDFRenderer;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configurador.DialogoConfigurador;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ArquivoFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.GuiaVirtual;
import jalis.laboratorio.util.faturamento.eletronico.JanelaConfiguracaoFaturamentoBPA;
import jalis.laboratorio.util.faturamento.eletronico.RetornoExamesMateriais;
import jalis.service.recepcao.selecionarimagem.SelecionarImagemService;
import jalis.util.ArraysUtil;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ValidaDoc;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.codec.binary.Base64;

public class IPERGS
extends AbstractFaturamentoEletronico
implements FaturamentoEletronico {
    public static final String TAG_PROTOCOLO = "protocolo";
    public static final String TAG_NUMERO_PRESTADOR = "numeroPrestador";
    public static final String TAG_NOME_PRESTADOR = "nomePrestador";
    public static final String TAG_CODIGO_PRESTADOR = "codigoPrestador";
    public static final String TAG_TIPO_PRESTADOR = "tipoPrestador";
    public static final String TAG_CONTADOR_NOTA = "contadorNota";
    public static final String TAG_PASTA_PDF = "pastaPDF";
    public static final String TAG_IGNORAR_SITUACAO_EXAME = "ignorarSituacaoExame";
    public static final String TAG_MSG_SITUACAO_EXAME = "mensagemSituacaoExame";
    public static final String TAG_ENVIAR_DATA_FATURA = "enviarDataFatura";
    public static final String TAG_CNPJ_FILIAL = "cnpjFilial";
    public static final String TAG_QUALIDADE_PDF = "qualidadePDF";
    private char EOF = (char)26;
    private int TIPO_NOTA = 35;
    private String QUEBRA_LINHA = "\r\n";
    private Registro regFilial;
    private Registro regConvenio;
    private Registro regFatura;
    private Registro regXML;
    private int qtdeNota = 0;
    private int contadorNotasArquivo = 0;
    private int qtdeTotalLancamentos = 0;
    private int qtdeLancamentos = 0;
    private BigDecimal valorNota = new BigDecimal(0);
    private BigDecimal valorMedicamento = new BigDecimal(0);
    StringBuilder notas = new StringBuilder();
    StringBuilder tempNota = new StringBuilder();
    StringBuilder tempLancamentos = new StringBuilder();
    String dirPDF = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<ArquivoFaturamentoEletronico> criarArquivo(Object owner, int codigoFatura, String codigoConvenio, String diretorioArquivos) {
        ResultSet rs;
        Statement st2;
        Statement st;
        StringBuilder retorno;
        StringBuilder sql;
        block12: {
            sql = new StringBuilder();
            retorno = new StringBuilder();
            st = null;
            st2 = null;
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            sql.append("select fil_razaosocial, fil_cnpj from filiais_postocoleta where fil_codigo = ");
            sql.append(Variaveis.filialPadrao);
            rs = Conexao.executeQuery(st, sql);
            if (rs.next()) {
                this.regFilial = new Registro(rs);
            }
            sql.setLength(0);
            sql.append("select a.con_codigo, b.con_razao, b.tpe_codigo, b.con_faturaeletronica from fatura a ");
            sql.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
            sql.append("where a.fil_codigo = ");
            sql.append(Variaveis.filialPadrao);
            sql.append(" and a.fat_codigo = ");
            sql.append(codigoFatura);
            sql.append(" and a.fat_datacancelamento is null ");
            rs = Conexao.executeQuery(st, sql);
            if (rs.next()) {
                this.regConvenio = new Registro(rs);
            }
            this.regXML = this.parseDadosXML(this.regConvenio.getString("con_faturaeletronica"));
            if (Funcoes.isNumeric(this.regXML.getString(TAG_CONTADOR_NOTA))) {
                this.qtdeNota = Integer.parseInt(this.regXML.getString(TAG_CONTADOR_NOTA));
            }
            this.dirPDF = diretorioArquivos;
            File dPDF = new File(this.dirPDF);
            if (dPDF.exists() || dPDF.mkdir()) break block12;
            Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel criar diret\u00f3rio PDF da fatura!", 2);
            ArrayList<ArquivoFaturamentoEletronico> arrayList = null;
            Conexao.fecharStatement(st);
            Conexao.fecharStatement(st2);
            return arrayList;
        }
        try {
            sql.setLength(0);
            sql.append("select fat_dtemis, fat_dtvenc, fat_dtinicio, fat_dtfim, fat_nota, ");
            sql.append("fat_adicional, fat_despcobranca, fat_percdesconto, fat_totalmateriais, ");
            sql.append("fat_totalexamesch, fat_totalexames, fat_qtdeexames, fat_qtderequisicao, ");
            sql.append("fat_dtconferencia ");
            sql.append("from fatura ");
            sql.append("where fil_codigo = ");
            sql.append(Variaveis.filialPadrao);
            sql.append(" and fat_codigo = ");
            sql.append(codigoFatura);
            sql.append(" and fat_datacancelamento is null ");
            rs = Conexao.executeQuery(st, sql);
            if (rs.next()) {
                this.regFatura = new Registro(rs);
            }
            this.criaNota35(st, st2, codigoFatura, null, null, null);
            retorno.append(this.criarHeader(this.contadorNotasArquivo, this.qtdeTotalLancamentos, this.TIPO_NOTA));
            retorno.append(this.notas.toString());
            String ret = retorno.toString();
            if (ret.endsWith(this.QUEBRA_LINHA)) {
                ret = ret.substring(0, ret.length() - 1);
            }
            retorno.setLength(0);
            retorno.append(ret);
            StringBuilder buf = new StringBuilder();
            buf.append("update convenios set con_faturaeletronica = '");
            buf.append(StringUtil.textoDB(this.criaXML(this.regXML)));
            buf.append("' where fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and con_codigo = ");
            buf.append(this.regConvenio.getString("con_codigo"));
            Conexao.execute(Variaveis.filialPadrao, st2, buf);
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception dPDF) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "IPERGS (200)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(st2);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            Conexao.fecharStatement(st2);
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        StringBuilder nomeArquivo = new StringBuilder();
        nomeArquivo.append("SMH");
        nomeArquivo.append(Funcoes.preencheVazio(this.regXML.getString(TAG_NUMERO_PRESTADOR), "0", 5, 1));
        ArrayList<ArquivoFaturamentoEletronico> arquivo = new ArrayList<ArquivoFaturamentoEletronico>();
        arquivo.add(new ArquivoFaturamentoEletronico(nomeArquivo.toString(), retorno.toString()));
        return arquivo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ArquivoFaturamentoEletronico> criarArquivoNota(String codigoFilial, String codigoNotaIpergs, String codigoFilialRequisicao, String codigoRequisicao, String diretorioArquivos) {
        ResultSet rs;
        Statement st2;
        Statement st;
        StringBuilder retorno;
        block11: {
            StringBuilder sql = new StringBuilder();
            retorno = new StringBuilder();
            st = null;
            st2 = null;
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            sql.append(" select fil_razaosocial ");
            sql.append("       ,fil_cnpj ");
            sql.append("   from filiais_postocoleta ");
            sql.append("  where fil_codigo = ").append(codigoFilial);
            rs = Conexao.executeQuery(st, sql);
            if (rs.next()) {
                this.regFilial = new Registro(rs);
            }
            sql.setLength(0);
            sql.append(" select distinct con.con_razao ");
            sql.append(" ,con.tpe_codigo ");
            sql.append(" ,con.con_faturaeletronica ");
            sql.append(" ,fat.fat_codigo ");
            sql.append(" ,fat.fat_dtinicio ");
            sql.append(" from faturaexamerequisicao fer ");
            sql.append(" join fatura fat on fer.fil_codigo = fat.fil_codigo and fer.fat_codigo = fat.fat_codigo ");
            sql.append(" join convenios con on fat.fil_codigo = con.fil_codigo and fat.con_codigo = con.con_codigo ");
            sql.append(" where fer.fil_codigo = ").append(codigoFilial);
            sql.append(" and fer.fer_notaipergs = ").append(codigoNotaIpergs);
            if (codigoRequisicao != null) {
                sql.append(" and fer.req_codigo = ").append(codigoRequisicao);
            }
            sql.append(" and fat.fat_datacancelamento is null ");
            rs = Conexao.executeQuery(st, sql);
            if (rs.next()) {
                this.regConvenio = new Registro(rs);
            }
            this.regXML = this.parseDadosXML(this.regConvenio.getString("con_faturaeletronica"));
            this.dirPDF = diretorioArquivos;
            File dPDF = new File(this.dirPDF);
            if (dPDF.exists() || dPDF.mkdir()) break block11;
            Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel criar diret\u00f3rio PDF da fatura.", 2);
            ArrayList<ArquivoFaturamentoEletronico> arrayList = null;
            Conexao.fecharStatement(st);
            Conexao.fecharStatement(st2);
            return arrayList;
        }
        try {
            this.criaNota35(st, st2, rs.getInt("fat_codigo"), codigoFilialRequisicao, codigoRequisicao, codigoNotaIpergs);
            retorno.append(this.criarHeader(this.contadorNotasArquivo, this.qtdeTotalLancamentos, this.TIPO_NOTA));
            retorno.append(this.notas.toString());
            String ret = retorno.toString();
            if (ret.endsWith(this.QUEBRA_LINHA)) {
                ret = ret.substring(0, ret.length() - 1);
            }
            retorno.setLength(0);
            retorno.append(ret);
        }
        catch (Exception ex) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception dPDF) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(st2);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            Conexao.fecharStatement(st2);
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        StringBuilder nomeArquivo = new StringBuilder();
        nomeArquivo.append("SMH");
        nomeArquivo.append(Funcoes.preencheVazio(this.regXML.getString(TAG_NUMERO_PRESTADOR), "0", 5, 1));
        ArrayList<ArquivoFaturamentoEletronico> arquivo = new ArrayList<ArquivoFaturamentoEletronico>();
        arquivo.add(new ArquivoFaturamentoEletronico(nomeArquivo.toString(), retorno.toString()));
        return arquivo;
    }

    private String criarHeader(int contadorNota, int qtdeLancamentos, int tipoNota) {
        StringBuilder header = new StringBuilder();
        header.append("SMH");
        String cnpj = !Funcoes.textoVazio(this.regXML.getString(TAG_CNPJ_FILIAL)) ? this.regXML.getString(TAG_CNPJ_FILIAL) : this.regFilial.getString("fil_cnpj");
        header.append(Funcoes.preencheZero(Funcoes.limpaCampos(cnpj, "\\.", ",", "/", "-"), 14));
        header.append(Funcoes.preencheZero(contadorNota, 4));
        header.append(Funcoes.preencheZero(qtdeLancamentos, 5));
        header.append(Funcoes.preencheVazio(this.regXML.getString(TAG_TIPO_PRESTADOR), "0", 2, 1));
        header.append(Funcoes.preencheVazio(this.regXML.getString(TAG_NUMERO_PRESTADOR), "0", 6, 1));
        header.append(Funcoes.preencheVazio(this.regXML.getString(TAG_NOME_PRESTADOR), 45, 2));
        if (tipoNota == 35) {
            header.append(Funcoes.preencheVazio("", 2, 1));
        } else if (tipoNota == 55) {
            header.append(Funcoes.preencheVazio("", 20, 1));
        } else if (tipoNota == 75 || tipoNota == 76 || tipoNota == 77 || tipoNota == 85 || tipoNota == 86 || tipoNota == 87) {
            header.append(Funcoes.preencheVazio("", 81, 1));
        }
        header.append(this.QUEBRA_LINHA);
        return header.toString();
    }

    private String criaLancamento35(Statement st, String filial, String requisicao, String exame, String material, String matricula, String conselhoSolicitante, String codigoSolicitante, String diaLancamento, String codigoHonorario, String qtde, String nome, String pdf, String codigoNotaIpergs) throws SQLException {
        this.tempLancamentos = new StringBuilder();
        this.tempLancamentos.append(Funcoes.preencheZero(this.qtdeLancamentos, 2));
        this.tempLancamentos.append(matricula);
        this.tempLancamentos.append(conselhoSolicitante.equalsIgnoreCase("CRO") ? "02" : "00");
        this.tempLancamentos.append(Funcoes.preencheVazio(codigoSolicitante, "0", 6, 1));
        this.tempLancamentos.append(Funcoes.preencheVazio(diaLancamento, "0", 2, 1));
        this.tempLancamentos.append(Funcoes.preencheVazio(codigoHonorario.trim(), "0", 8, 1));
        this.tempLancamentos.append(Funcoes.preencheVazio(qtde, "0", 5, 1));
        this.tempLancamentos.append(Funcoes.preencheVazio(nome.length() > 43 ? nome.substring(0, 43) : nome, 43, 2));
        this.tempLancamentos.append(Funcoes.preencheVazio(pdf, 50, 2));
        this.tempLancamentos.append(this.QUEBRA_LINHA);
        if (codigoNotaIpergs == null) {
            StringBuilder sql = new StringBuilder();
            sql.setLength(0);
            sql.append("update faturaexamerequisicao set fer_notaipergs = ").append(this.qtdeNota);
            sql.append("where fil_codigo = ").append(Variaveis.filialPadrao);
            sql.append(" and fil_kodigo = ").append(filial);
            sql.append(" and req_codigo = ").append(requisicao);
            sql.append(" and exa_codfilho = '").append(StringUtil.textoDB(exame)).append("'");
            sql.append(" and mco_codfilho = ").append(material);
            Conexao.execute(Variaveis.filialPadrao, st, sql.toString());
        }
        ++this.qtdeTotalLancamentos;
        return this.tempLancamentos.toString();
    }

    private String criaHeader35(String codigoNota, int casasDecimais, RoundingMode arredondamentoPreco) throws ParseException {
        this.tempNota = new StringBuilder();
        this.tempNota.append("00");
        this.tempNota.append("35");
        this.tempNota.append(Funcoes.preencheZero(this.qtdeLancamentos, 2));
        String cnpj = !Funcoes.textoVazio(this.regXML.getString(TAG_CNPJ_FILIAL)) ? this.regXML.getString(TAG_CNPJ_FILIAL) : this.regFilial.getString("fil_cnpj");
        this.tempNota.append(Funcoes.preencheZero(Funcoes.limpaCampos(cnpj, "\\.", ",", "/", "-"), 14));
        String valor = this.valorNota.setScale(casasDecimais, arredondamentoPreco).toString();
        valor = StringUtil.limpaString(valor, new String[]{",", "."});
        valor = Funcoes.preencheVazio(valor, "0", 13, 1);
        this.tempNota.append(valor);
        valor = this.valorMedicamento.setScale(casasDecimais, arredondamentoPreco).toString();
        valor = StringUtil.limpaString(valor, new String[]{",", "."});
        valor = Funcoes.preencheVazio(valor, "0", 9, 1);
        this.tempNota.append(valor);
        this.tempNota.append(this.regXML.getString(TAG_TIPO_PRESTADOR));
        String dt = Funcoes.formataData("MMyy", this.regFatura != null ? this.regFatura.getDate("fat_dtinicio") : this.regConvenio.getDate("fat_dtinicio"));
        this.tempNota.append(dt);
        this.tempNota.append(Funcoes.preencheZero(codigoNota == null ? this.qtdeNota : Integer.parseInt(codigoNota), 5));
        this.tempNota.append("                            ");
        this.tempNota.append(this.QUEBRA_LINHA);
        this.qtdeLancamentos = 0;
        this.valorNota = new BigDecimal(0);
        this.valorMedicamento = new BigDecimal(0);
        return this.tempNota.toString();
    }

    private RetornoExamesMateriais pegaExamesMateriaisRequisicao(Statement st, int codigoFatura, String codigoFilialRequisicao, String codigoRequisicao) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select e.exa_codigo ");
        sql.append("       ,e.mco_codigo ");
        sql.append("   from faturarequisicao a ");
        sql.append("   left join faturaexamerequisicao e on a.fil_codigo = e.fil_codigo and a.fil_kodigo = e.fil_kodigo and a.fat_codigo = e.fat_codigo and a.req_codigo = e.req_codigo ");
        sql.append("   left join requisicao b on a.fil_kodigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        sql.append("   left join paciente c on b.fil_codigo = c.fil_codigo and b.pac_codigo = c.pac_codigo ");
        sql.append("   left join examerequisicao d on a.fil_kodigo = d.fil_codigo and a.req_codigo = d.req_codigo and e.exa_codigo = d.exa_codigo and e.mco_codigo = d.mco_codigo ");
        sql.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and a.fat_codigo = ").append(codigoFatura);
        sql.append(" and b.req_excluida = false ");
        if (codigoFilialRequisicao != null) {
            sql.append(" and b.fil_codigo = ").append(codigoFilialRequisicao);
        }
        if (codigoRequisicao != null) {
            sql.append(" and b.req_codigo = ").append(codigoRequisicao);
        }
        sql.append(" order by a.req_codigo, a.fil_kodigo ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        ArrayList<String> exames = new ArrayList<String>();
        ArrayList<String> materiais = new ArrayList<String>();
        while (rs.next()) {
            exames.add(rs.getString("exa_codigo"));
            materiais.add(rs.getString("mco_codigo"));
        }
        RetornoExamesMateriais ret = new RetornoExamesMateriais();
        ret.exames = exames.toArray(new String[exames.size()]);
        ret.materiais = materiais.toArray(new String[materiais.size()]);
        return ret;
    }

    private void criaNota35(Statement st, Statement st2, int codigoFatura, String codigoFilialRequisicao, String codigoRequisicao, String codigoNota) throws Exception {
        StringBuilder lancamentos = new StringBuilder();
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append(" select a.fil_kodigo ");
        sql.append("       ,a.req_codigo ");
        sql.append("       ,e.exa_codfilho ");
        sql.append("       ,c.pac_nome ");
        sql.append("       ,b.med_conselho ");
        sql.append("       ,b.med_crm ");
        sql.append("       ,b.req_matricula ");
        sql.append("       ,b.req_data ");
        sql.append("       ,b.req_dtfatura ");
        sql.append("       ,e.mco_codfilho ");
        sql.append("       ,e.exa_codigo ");
        sql.append("       ,e.mco_codigo ");
        sql.append("       ,a.con_codigo ");
        sql.append("   from faturarequisicao a ");
        sql.append("   left join faturaexamerequisicao e on a.fil_codigo = e.fil_codigo and a.fil_kodigo = e.fil_kodigo and a.fat_codigo = e.fat_codigo and a.req_codigo = e.req_codigo ");
        sql.append("   left join requisicao b on a.fil_kodigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        sql.append("   left join paciente c on b.fil_codigo = c.fil_codigo and b.pac_codigo = c.pac_codigo ");
        sql.append("   left join examerequisicao d on a.fil_kodigo = d.fil_codigo and a.req_codigo = d.req_codigo and e.exa_codigo = d.exa_codigo and e.mco_codigo = d.mco_codigo ");
        sql.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and a.fat_codigo = ").append(codigoFatura);
        sql.append(" and b.req_excluida = false ");
        if (codigoFilialRequisicao != null) {
            sql.append(" and b.fil_codigo = ").append(codigoFilialRequisicao);
        }
        if (codigoRequisicao != null) {
            sql.append(" and b.req_codigo = ").append(codigoRequisicao);
        }
        sql.append(" order by a.req_codigo, a.fil_kodigo ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        int ultimaRequisicao = -1;
        int ultimaFilial = -1;
        boolean registrarNota = true;
        String arquivoPDF = "";
        int casasDecimais = ParametrosGerais.getCasasPrecoExame();
        RoundingMode arredondamentoPreco = ParametrosGerais.getArredondamentoPrecoExame();
        while (rs.next()) {
            casasDecimais = ParametrosGerais.getCasasPrecoExame();
            arredondamentoPreco = ParametrosGerais.getArredondamentoPrecoExame();
            DadosConvenios dadosConvenios = ConvenioUtil.getDadosConvenios(rs.getString("fil_kodigo"), rs.getInt("con_codigo"));
            if (!Funcoes.objectIsNull(dadosConvenios) && dadosConvenios.getConvenioUtilizarCasasDecimais()) {
                casasDecimais = dadosConvenios.getConvenioCasasPrecoExame();
                arredondamentoPreco = dadosConvenios.getConvenioTipoArredondamentoPrecoRoundingMode();
            }
            String nomePDF = Funcoes.preencheZero(rs.getString("fil_kodigo"), 2) + Funcoes.preencheZero(codigoFatura, 4) + Funcoes.preencheVazio(rs.getString("req_codigo"), "0", 8, 1);
            String pdf = nomePDF + ".pdf";
            arquivoPDF = this.dirPDF + "/" + pdf;
            File arqPDF = new File(arquivoPDF);
            if (!arqPDF.exists()) {
                String resultadoMensagem = "";
                if (this.regXML.getBoolean(TAG_IGNORAR_SITUACAO_EXAME)) {
                    resultadoMensagem = new Resultado(this.regXML.getString(TAG_MSG_SITUACAO_EXAME)).getResultado();
                }
                if (ultimaRequisicao != rs.getInt("req_codigo")) {
                    RetornoExamesMateriais ret = this.pegaExamesMateriaisRequisicao(st2, codigoFatura, rs.getString("fil_kodigo"), rs.getString("req_codigo"));
                    ImpressaoResultados.imprimirExamesPdf(rs.getString("fil_kodigo"), rs.getString("req_codigo"), ret.exames, ret.materiais, arquivoPDF, this.regXML.getBoolean(TAG_IGNORAR_SITUACAO_EXAME), resultadoMensagem, false);
                    this.pdfCompactado(arqPDF);
                    double tamanhoMaximoPDF = 3.0;
                    SelecionarImagemService selecionarImagemService = new SelecionarImagemService();
                    String[] imagens = selecionarImagemService.retornaImagens(rs.getString("fil_kodigo"), rs.getString("req_codigo"), new String[]{"A", "P"});
                    try {
                        if (imagens.length != 0) {
                            String arquivoPDFTemporario = arquivoPDF.replace(".pdf", "_temp.pdf");
                            PdfReader reader = new PdfReader(arquivoPDF);
                            PdfStamper stamper = new PdfStamper(reader, (OutputStream)new FileOutputStream(arquivoPDFTemporario));
                            stamper.setFullCompression();
                            int pageNumber = 1;
                            for (String imagem : imagens) {
                                Base64 decoder = new Base64();
                                byte[] imageByte = decoder.decode(imagem);
                                Image image = Image.getInstance((byte[])imageByte);
                                image.setCompressionLevel(9);
                                Rectangle layoutPagina = PageSize.A4;
                                if (image.getWidth() > image.getHeight() && image.getWidth() > layoutPagina.getWidth()) {
                                    image.setRotationDegrees(90.0f);
                                }
                                if (image.getWidth() > layoutPagina.getWidth() || image.getHeight() > layoutPagina.getHeight()) {
                                    image.scaleToFit(layoutPagina.getWidth(), layoutPagina.getHeight());
                                }
                                stamper.insertPage(pageNumber, layoutPagina);
                                PdfImage stream = new PdfImage(image, "", null);
                                stream.put(new PdfName("ITXT_SpecialId"), (PdfObject)new PdfName(nomePDF));
                                PdfIndirectObject ref = stamper.getWriter().addToBody((PdfObject)stream);
                                image.setDirectReference(ref.getIndirectReference());
                                image.setAbsolutePosition((layoutPagina.getWidth() - image.getScaledWidth()) / 2.0f, layoutPagina.getHeight() - image.getScaledHeight());
                                PdfContentByte over = stamper.getOverContent(1);
                                over.addImage(image);
                            }
                            stamper.close();
                            reader.close();
                            Files.delete(Paths.get(arquivoPDF, new String[0]));
                            Files.move(new File(arquivoPDFTemporario).toPath(), new File(arquivoPDF).toPath(), new CopyOption[0]);
                        }
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel anexar as imagens no pdf. \n" + e.getMessage(), e.getStackTrace());
                    }
                    String[] anexos = selecionarImagemService.retornaPdf(rs.getString("fil_kodigo"), rs.getString("req_codigo"), new String[]{"A", "P"});
                    if (anexos.length > 0) {
                        ArrayList<String> arquivoPdfMerge = new ArrayList<String>();
                        for (int i = 0; i < anexos.length; ++i) {
                            arquivoPdfMerge.add(arquivoPDF.replace(".pdf", "-" + i + ".pdf"));
                            Base64 decoder = new Base64();
                            byte[] anexoByte = decoder.decode(anexos[i]);
                            FileOutputStream out = new FileOutputStream((String)arquivoPdfMerge.get(arquivoPdfMerge.size() - 1));
                            ((OutputStream)out).write(anexoByte);
                            ((OutputStream)out).close();
                            if (anexos.length <= 0 || ((String)arquivoPdfMerge.get(0)).equals(arquivoPdfMerge.get(arquivoPdfMerge.size() - 1))) continue;
                            this.mergePdf((String)arquivoPdfMerge.get(0), (String)arquivoPdfMerge.get(arquivoPdfMerge.size() - 1));
                        }
                        this.mergePdf(arquivoPDF, (String)arquivoPdfMerge.get(0));
                    }
                    BigDecimal divisor = new BigDecimal(1024);
                    String textoArquivo = this.lerPDF(arquivoPDF);
                    BigDecimal tamanhoPDF = new BigDecimal(textoArquivo.getBytes().length).divide(divisor).divide(divisor);
                    if (tamanhoPDF.doubleValue() > tamanhoMaximoPDF) {
                        registrarNota = false;
                    }
                }
            } else {
                this.pdfCompactado(arqPDF);
            }
            if (!registrarNota) continue;
            Registro r = this.pegaDadosLancamento(st2, rs.getInt("fil_kodigo"), codigoFatura, rs.getInt("req_codigo"), rs.getString("exa_codfilho"), rs.getInt("mco_codfilho"));
            String amb = r != null && !Funcoes.textoVazio(r.getString("dtp_codamb")) && !DBUtil.campoNull(r.getString("dtp_codamb")) ? r.getString("dtp_codamb") : "";
            amb = StringUtil.limpaString(amb, new String[]{",", "-", "/", ",", "."});
            if (ultimaFilial != rs.getInt("fil_kodigo") && ultimaRequisicao == rs.getInt("req_codigo") || ultimaRequisicao != rs.getInt("req_codigo") || this.qtdeLancamentos == 20) {
                if (lancamentos.length() > 0) {
                    this.notas.append(this.criaHeader35(codigoNota, casasDecimais, arredondamentoPreco));
                    this.notas.append(lancamentos.toString());
                    lancamentos.setLength(0);
                }
                ++this.qtdeNota;
                ++this.contadorNotasArquivo;
                this.regXML.setValor(TAG_CONTADOR_NOTA, this.qtdeNota);
                ultimaRequisicao = rs.getInt("req_codigo");
                ultimaFilial = rs.getInt("fil_kodigo");
            }
            ++this.qtdeLancamentos;
            this.valorNota = this.valorNota.add(new BigDecimal(r != null ? r.getString("valortotal") : "0").setScale(casasDecimais, arredondamentoPreco));
            String v = DBUtil.campoNull(r != null ? r.getString("valortotalmaterial") : "0") ? "0" : (r != null ? r.getString("valortotalmaterial") : "0");
            this.valorMedicamento = this.valorMedicamento.add(new BigDecimal(v).setScale(casasDecimais, arredondamentoPreco));
            lancamentos.append(this.criaLancamento35(st2, rs.getString("fil_kodigo"), rs.getString("req_codigo"), rs.getString("exa_codfilho"), rs.getString("mco_codfilho"), rs.getString("req_matricula"), rs.getString("med_conselho"), rs.getString("med_crm"), Funcoes.formataData("dd", this.regXML.getBoolean(TAG_ENVIAR_DATA_FATURA) ? rs.getDate("req_dtfatura") : rs.getDate("req_data")), amb, r != null ? r.getString("qtdeexecutada") : "0", rs.getString("pac_nome"), pdf, codigoNota));
        }
        if (!registrarNota) {
            new File(arquivoPDF).delete();
            StringBuilder mensagem = new StringBuilder();
            mensagem.append("O pdf da fatura ").append(codigoNota);
            mensagem.append(" ultrapassou o limite de tamanho.");
            Funcoes.mensagem(Laboratorio.getInstancia(), mensagem.toString(), 2);
        }
        if (this.qtdeLancamentos > 0) {
            this.notas.append(this.criaHeader35(codigoNota, casasDecimais, arredondamentoPreco));
            this.notas.append(lancamentos.toString());
            lancamentos.setLength(0);
        }
    }

    private void mergePdf(String arquivoPDF, String arquivoPDFMerge) throws FileNotFoundException, IOException {
        PDFMergerUtility pdfMerge = new PDFMergerUtility();
        pdfMerge.setDestinationFileName(arquivoPDF);
        pdfMerge.addSource(arquivoPDFMerge);
        pdfMerge.addSource(arquivoPDF);
        pdfMerge.mergeDocuments(null);
        boolean deletado = new File(arquivoPDFMerge).delete();
    }

    private boolean pdfCompactado(File arquivoPDF) throws Exception {
        boolean compactado = false;
        long tamanhoMaximoArquivoIPERGS = 500000L;
        if (arquivoPDF.length() <= tamanhoMaximoArquivoIPERGS) {
            compactado = true;
        } else {
            List<Integer> qualidades = Arrays.asList(144, 108, 72, 36, 24, 18, 9, 1);
            for (Integer qualidade : qualidades) {
                ByteArrayOutputStream bytesArquivo = this.compactarPDF(arquivoPDF.getAbsolutePath(), qualidade);
                if ((long)bytesArquivo.size() > tamanhoMaximoArquivoIPERGS) continue;
                Path pathArquivo = Paths.get(arquivoPDF.getAbsolutePath(), new String[0]);
                Files.delete(pathArquivo);
                Files.write(pathArquivo, bytesArquivo.toByteArray(), new OpenOption[0]);
                bytesArquivo.close();
                compactado = true;
                break;
            }
        }
        return compactado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayOutputStream compactarPDF(String pathArquivo, int qualidade) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PDDocument pdfOriginal = PDDocument.load((File)new File(pathArquivo));
             PDDocument pdfCompactado = new PDDocument();){
            PDFRenderer pdfRenderer = new PDFRenderer(pdfOriginal);
            PDPage pagina = null;
            for (int i = 0; i < pdfOriginal.getNumberOfPages(); ++i) {
                pagina = new PDPage(PDRectangle.A4);
                BufferedImage imagemPaginaCompactada = pdfRenderer.renderImageWithDPI(i, (float)qualidade, ImageType.RGB);
                PDImageXObject pdImage = JPEGFactory.createFromImage((PDDocument)pdfCompactado, (BufferedImage)imagemPaginaCompactada);
                PDPageContentStream contentStream = new PDPageContentStream(pdfCompactado, pagina);
                float altura = PDRectangle.A4.getHeight();
                float largura = PDRectangle.A4.getWidth();
                contentStream.drawImage(pdImage, 0.0f, 0.0f, largura, altura);
                contentStream.close();
                pdfCompactado.addPage(pagina);
            }
            pdfCompactado.save((OutputStream)baos);
        }
        return baos;
    }

    private String lerPDF(String arquivo) {
        String retorno = "";
        try {
            retorno = StringUtil.lerArquivoTexto(arquivo);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel localizar o arquivo " + arquivo, e.getStackTrace());
        }
        return retorno;
    }

    private Registro pegaDadosLancamento(Statement st, int filial, int codigoFatura, int requisicao, String exame, int material) throws SQLException {
        StringBuilder sql = new StringBuilder();
        if (ParametrosGerais.getPrecoMetodologia()) {
            sql.append(" select a.exa_codigo ");
            sql.append("       ,b.exa_descricao ");
            sql.append("       ,c.dtm_codamb as dtp_codamb ");
            sql.append("       ,count(a.exa_codigo) as qtdeExecutada ");
            sql.append("       ,sum(coalesce(a.fer_total, 0)) as valorTotal ");
            sql.append("       ,sum(coalesce(a.fer_totalmateriais, 0)) as valorTotalMaterial ");
            sql.append("   from faturaexamerequisicao a ");
            sql.append("   left join fatura fat on a.fil_codigo = fat.fil_codigo and a.fat_codigo = fat.fat_codigo ");
            sql.append("   left join exames b on a.fil_kodigo = b.fil_codigo and a.exa_codfilho = b.exa_codigo ");
            sql.append("   left join examerequisicao d on a.fil_kodigo = d.fil_codigo and a.req_codigo = d.req_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
            sql.append("   left join detalhetabelaprecometodologia c on a.fil_kodigo = c.fil_codigo and a.exa_codfilho = c.exa_codigo and a.mco_codfilho = c.mco_codigo and d.met_codigo = c.met_codigo ");
            sql.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
            sql.append("    and a.fil_kodigo = ").append(filial);
            sql.append("    and a.fat_codigo = ").append(codigoFatura);
            sql.append("    and a.req_codigo = ").append(requisicao);
            sql.append("    and a.exa_codfilho = '").append(exame).append("' ");
            sql.append("    and a.mco_codfilho = ").append(material);
            sql.append("    and fat.fat_datacancelamento is null ");
            sql.append("    and d.exr_excluido = false ");
            sql.append("    and c.tpe_codigo = ").append(this.regConvenio.getString("tpe_codigo"));
            sql.append("  group by a.exa_codigo ");
            sql.append("          ,b.exa_descricao ");
            sql.append("          ,c.dtm_codamb ");
            sql.append("  order by b.exa_descricao ");
        } else {
            sql.append(" select a.exa_codigo ");
            sql.append("       ,b.exa_descricao ");
            sql.append("       ,c.dtp_codamb ");
            sql.append("       ,count(a.exa_codigo) as qtdeExecutada ");
            sql.append("       ,sum(coalesce(a.fer_total, 0)) as valorTotal ");
            sql.append("       ,sum(coalesce(a.fer_totalmateriais, 0)) as valorTotalMaterial ");
            sql.append("   from faturaexamerequisicao a ");
            sql.append("   left join fatura fat on a.fil_codigo = fat.fil_codigo and a.fat_codigo = fat.fat_codigo ");
            sql.append("   left join exames b on a.fil_kodigo = b.fil_codigo and a.exa_codfilho = b.exa_codigo ");
            sql.append("   left join detalhetabelapreco c on a.fil_kodigo = c.fil_codigo and a.exa_codfilho = c.exa_codigo and a.mco_codfilho = c.mco_codigo ");
            sql.append("   left join examerequisicao d on a.fil_kodigo = d.fil_codigo and a.req_codigo = d.req_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
            sql.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
            sql.append("    and a.fil_kodigo = ").append(filial);
            sql.append("    and a.fat_codigo = ").append(codigoFatura);
            sql.append("    and a.req_codigo = ").append(requisicao);
            sql.append("    and a.exa_codfilho = '").append(exame).append("' ");
            sql.append("    and a.mco_codfilho = ").append(material);
            sql.append("    and fat.fat_datacancelamento is null ");
            sql.append("    and d.exr_excluido = false ");
            sql.append("    and c.tpe_codigo = ").append(this.regConvenio.getString("tpe_codigo"));
            sql.append("  group by a.exa_codigo ");
            sql.append("          ,b.exa_descricao ");
            sql.append("          ,c.dtp_codamb ");
            sql.append("  order by b.exa_descricao ");
        }
        ResultSet rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            return new Registro(rs);
        }
        return null;
    }

    public static String getNomeProtocolo() {
        return "IPERGS";
    }

    @Override
    public String configurar(JFrame parent, String xml) {
        String retorno = xml;
        Configurar conf = new Configurar(parent);
        conf.setXML(this.parseDadosXML(xml));
        conf.setVisible(true);
        if (conf.ok()) {
            Registro r = new Registro();
            r.setValor(TAG_NUMERO_PRESTADOR, conf.getNumeroPrestador());
            r.setValor(TAG_NOME_PRESTADOR, conf.getNomePrestador());
            r.setValor(TAG_CODIGO_PRESTADOR, conf.getCodigoPrestador());
            r.setValor(TAG_TIPO_PRESTADOR, conf.getTipoPrestador());
            r.setValor(TAG_CONTADOR_NOTA, conf.getContadorNota());
            r.setValor(TAG_IGNORAR_SITUACAO_EXAME, conf.isIgnorarSituacaoExame());
            r.setValor(TAG_MSG_SITUACAO_EXAME, conf.getMensagemSituacaoExame());
            r.setValor(TAG_ENVIAR_DATA_FATURA, conf.isEnviarDataFatura());
            r.setValor(TAG_CNPJ_FILIAL, conf.getCNPJ());
            r.setValor(TAG_QUALIDADE_PDF, conf.getQualidadePDF().toString());
            retorno = this.criaXML(r);
        }
        return retorno;
    }

    private Registro parseDadosXML(String xml) {
        if (Funcoes.textoVazio(xml)) {
            return null;
        }
        Registro reg = new Registro();
        reg.setValor(TAG_PROTOCOLO, IPERGS.getNomeProtocolo());
        reg.setValor(TAG_NUMERO_PRESTADOR, StringUtil.getValor(xml, TAG_NUMERO_PRESTADOR));
        reg.setValor(TAG_NOME_PRESTADOR, StringUtil.getValor(xml, TAG_NOME_PRESTADOR));
        reg.setValor(TAG_CODIGO_PRESTADOR, StringUtil.getValor(xml, TAG_CODIGO_PRESTADOR));
        reg.setValor(TAG_TIPO_PRESTADOR, StringUtil.getValor(xml, TAG_TIPO_PRESTADOR));
        reg.setValor(TAG_CONTADOR_NOTA, !Funcoes.textoVazio(StringUtil.getValor(xml, TAG_CONTADOR_NOTA)) ? StringUtil.getValor(xml, TAG_CONTADOR_NOTA) : "0");
        reg.setValor(TAG_IGNORAR_SITUACAO_EXAME, StringUtil.getBoolean(xml, TAG_IGNORAR_SITUACAO_EXAME));
        reg.setValor(TAG_MSG_SITUACAO_EXAME, StringUtil.getValor(xml, TAG_MSG_SITUACAO_EXAME));
        reg.setValor(TAG_ENVIAR_DATA_FATURA, StringUtil.getBoolean(xml, TAG_ENVIAR_DATA_FATURA));
        reg.setValor(TAG_CNPJ_FILIAL, StringUtil.getValor(xml, TAG_CNPJ_FILIAL));
        String qualidadePDF = StringUtil.getValor(xml, TAG_QUALIDADE_PDF);
        reg.setValor(TAG_QUALIDADE_PDF, Funcoes.textoVazio(qualidadePDF) ? Integer.valueOf(120) : qualidadePDF);
        return reg;
    }

    private String criaXML(Registro r) {
        if (r == null) {
            return "";
        }
        XMLStringBuilder buf = new XMLStringBuilder();
        buf.abrir("faturamentoEletronico");
        buf.escrever(TAG_PROTOCOLO, IPERGS.getNomeProtocolo());
        buf.escrever(TAG_NUMERO_PRESTADOR, r.getString(TAG_NUMERO_PRESTADOR));
        buf.escrever(TAG_NOME_PRESTADOR, r.getString(TAG_NOME_PRESTADOR));
        buf.escrever(TAG_CODIGO_PRESTADOR, r.getString(TAG_CODIGO_PRESTADOR));
        buf.escrever(TAG_TIPO_PRESTADOR, r.getString(TAG_TIPO_PRESTADOR));
        buf.escrever(TAG_CONTADOR_NOTA, r.getString(TAG_CONTADOR_NOTA));
        buf.escrever(TAG_PASTA_PDF, r.getString(TAG_PASTA_PDF));
        buf.escrever(TAG_IGNORAR_SITUACAO_EXAME, r.getString(TAG_IGNORAR_SITUACAO_EXAME));
        buf.escrever(TAG_MSG_SITUACAO_EXAME, r.getString(TAG_MSG_SITUACAO_EXAME));
        buf.escrever(TAG_ENVIAR_DATA_FATURA, r.getString(TAG_ENVIAR_DATA_FATURA));
        buf.escrever(TAG_CNPJ_FILIAL, r.getString(TAG_CNPJ_FILIAL));
        buf.escrever(TAG_QUALIDADE_PDF, r.getString(TAG_QUALIDADE_PDF));
        try {
            buf.fechar("faturamentoEletronico");
        }
        catch (XMLStringBuilderException xMLStringBuilderException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static String getExtensaoArquivo() {
        return "035";
    }

    @Override
    public boolean solicitarDiretorioNoInicio() {
        return true;
    }

    @Override
    public String[] situacoesPermitidasExame(String xml) {
        String[] retorno = new String[]{"C", "E", "I"};
        if (!ParametrosGerais.getConferencia()) {
            retorno = ArraysUtil.concatenar(new String[]{"L"}, retorno);
        }
        return xml != null && StringUtil.getBoolean(xml, TAG_IGNORAR_SITUACAO_EXAME) ? null : retorno;
    }

    @Override
    public boolean validarCasasDecimais() {
        return true;
    }

    @Override
    public String getCodificacaoArquivo() {
        return FaturamentoEletronico.CODIFICACAO.ISO_8859_1.codificacao;
    }

    @Override
    public void verificaErrosFatura(ArrayList<DadosFaturamento> requisicoes, Registro configuracaoConvenio0) {
    }

    @Override
    public ArrayList<GuiaVirtual.Campo> getCamposObrigatorios(String versao) {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasSolicitados() {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasExecutados() {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampo> getCamposIncorretos(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasSolicitados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasExecutados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public Registro parseXMLConfiguracao(String xml) {
        return null;
    }

    @Override
    public boolean gravaAlteracoes(DadosFaturamento requisicao, String guia, Registro configuracao) {
        return false;
    }

    @Override
    public void preencheValoresCampos(DadosFaturamento requisicao, Registro configuracaoEletronico, String guia) {
    }

    @Override
    public void preencheValoresTabelas(DadosFaturamento requisicao, String guia) {
    }

    @Override
    public void getValoresPreenchidos(DadosFaturamento requisicao, ArrayList<DadosExameFaturamento> exames, Registro configuracaoEletronico) {
    }

    @Override
    public void aplicarModificacoesGerais(ArrayList<DadosFaturamento> requisicoes, DadosFaturamento requisicao, DadosFaturamento requisicaoModificada, Registro configuracaoEletronico, Registro configuracaoEletronicoModificada) {
    }

    @Override
    public Object[] getListaDadosAdicionais() {
        return null;
    }

    @Override
    public void setListaDadosAdicionais(Object[] listaDadosAdicionais) {
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampoBPA> getCamposIncorretosBPA(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<JanelaConfiguracaoFaturamentoBPA.CampoBPA> getCamposObrigatoriosBPA() {
        return null;
    }

    class Configurar
    extends JDialog
    implements ActionListener {
        TTextField txtNumeroPrestador;
        TTextField txtNomePrestador;
        TTextField txtCodigoPrestador;
        TTextField txtTipoPrestador;
        TTextField textContadorNota;
        TTextField textCNPJ;
        JComboBox<Integer> comboQualidadePDF;
        JLabel labelNumeroPrestador;
        JLabel labelNomePrestador;
        JLabel labelCodigoPrestador;
        JLabel labelTipoPrestador;
        JLabel labelCNPJ;
        JLabel labelQualidadePDF;
        JButton buttonSalvar;
        JButton buttonCancelar;
        JCheckBox checkIgnorarSituacaoExame;
        JCheckBox checkEnviarDataFatura;
        JButton buttonConfigurarTexto;
        private String mensagemSituacaoExame;
        private boolean ok;

        public Configurar(JFrame owner) {
            super((Frame)owner, "Configurando IPERGS");
            this.txtNumeroPrestador = new TTextField(5, 1);
            this.txtNomePrestador = new TTextField(45, 3);
            this.txtCodigoPrestador = new TTextField(8, 1);
            this.txtTipoPrestador = new TTextField(2, 1);
            this.textContadorNota = new TTextField(5, 1);
            this.textCNPJ = new TTextField(18, 7);
            this.comboQualidadePDF = new JComboBox<Integer>(new Integer[]{10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120});
            this.labelNumeroPrestador = ComponenteFactory.novoJLabel("N\u00famero do Prestador:", 'N', null, this.txtNumeroPrestador);
            this.labelNomePrestador = ComponenteFactory.novoJLabel("Nome do Prestador:", 'P', null, this.txtNomePrestador);
            this.labelCodigoPrestador = ComponenteFactory.novoJLabel("C\u00f3digo Prestador:", 'C', null, this.txtCodigoPrestador);
            this.labelTipoPrestador = ComponenteFactory.novoJLabel("Tipo Prestador:", 'T', null, this.txtTipoPrestador);
            this.labelCNPJ = ComponenteFactory.novoJLabel("CNPJ", 'J', null, this.textCNPJ);
            this.labelQualidadePDF = ComponenteFactory.novoJLabel("Qualidade PDF", 'Q', null, this.comboQualidadePDF);
            this.buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this, null, null);
            this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
            this.checkIgnorarSituacaoExame = ComponenteFactory.novoJCheckBox("Ignorar situa\u00e7\u00e3o do exame para gerar PDF", this);
            this.checkEnviarDataFatura = ComponenteFactory.novoJCheckBox("Enviar data de fatura", null);
            this.buttonConfigurarTexto = ComponenteFactory.novoJButton("Mensagem situa\u00e7\u00e3o do exame", this);
            this.mensagemSituacaoExame = "";
            this.ok = false;
            this.setSize(new Dimension(390, 405));
            this.setResizable(false);
            this.setLocationRelativeTo(owner);
            this.setModal(true);
            JPanel panelCentro = new JPanel(new GridBagLayout());
            this.setLayout(new BorderLayout());
            this.add((Component)panelCentro, "Center");
            this.buttonConfigurarTexto.setToolTipText("<html>Permite configurar a mensagem que ser\u00e1 apresentada caso o exame<br>n\u00e3o tenha o resultado digitado.</html>");
            this.buttonConfigurarTexto.setEnabled(false);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 2;
            c.weightx = 1.0;
            c.insets = new Insets(0, 5, 0, 5);
            panelCentro.add((Component)this.labelNumeroPrestador, c);
            c.gridy = 1;
            this.txtNomePrestador.setPreferredSize(new Dimension(100, 20));
            panelCentro.add((Component)this.txtNumeroPrestador, c);
            c.gridy = 2;
            panelCentro.add((Component)this.labelNomePrestador, c);
            c.gridy = 3;
            this.txtNomePrestador.setPreferredSize(new Dimension(350, 20));
            panelCentro.add((Component)this.txtNomePrestador, c);
            c.gridy = 4;
            panelCentro.add((Component)this.labelCodigoPrestador, c);
            c.gridy = 5;
            this.txtCodigoPrestador.setPreferredSize(new Dimension(100, 20));
            panelCentro.add((Component)this.txtCodigoPrestador, c);
            c.gridy = 6;
            panelCentro.add((Component)this.labelTipoPrestador, c);
            c.gridy = 7;
            this.txtTipoPrestador.setPreferredSize(new Dimension(100, 20));
            panelCentro.add((Component)this.txtTipoPrestador, c);
            ++c.gridy;
            panelCentro.add((Component)new JLabel("Contador Nota:"), c);
            ++c.gridy;
            this.textContadorNota.setPreferredSize(new Dimension(100, 20));
            panelCentro.add((Component)this.textContadorNota, c);
            ++c.gridy;
            panelCentro.add((Component)this.labelCNPJ, c);
            ++c.gridy;
            this.textContadorNota.setPreferredSize(new Dimension(100, 20));
            panelCentro.add((Component)this.textCNPJ, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.insets = new Insets(0, 3, 0, 5);
            this.checkIgnorarSituacaoExame.setPreferredSize(new Dimension(100, 20));
            panelCentro.add((Component)this.checkIgnorarSituacaoExame, c);
            ++c.gridy;
            this.checkEnviarDataFatura.setPreferredSize(new Dimension(100, 20));
            panelCentro.add((Component)this.checkEnviarDataFatura, c);
            JPanel panelAux = new JPanel();
            JPanel panelQualidade = new JPanel(new FlowLayout(0));
            panelQualidade.add(this.labelQualidadePDF);
            panelQualidade.add(this.comboQualidadePDF);
            JPanel panelMensagem = ComponenteFactory.novoJPanelFlowLayout(2, this.buttonConfigurarTexto);
            panelAux.add(panelQualidade);
            panelAux.add(panelMensagem);
            ++c.gridy;
            c.insets = new Insets(0, 0, 0, 0);
            panelCentro.add((Component)panelAux, c);
            JPanel panelBotoes = new JPanel(new FlowLayout(2));
            panelBotoes.add(this.buttonSalvar);
            panelBotoes.add(this.buttonCancelar);
            ++c.gridy;
            panelCentro.add((Component)panelBotoes, c);
            Funcoes.montaEnter((JComponent)panelCentro);
            Funcoes.montaEnter((JComponent)panelBotoes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.checkIgnorarSituacaoExame) {
                this.buttonConfigurarTexto.setEnabled(this.checkIgnorarSituacaoExame.isSelected());
            } else if (e.getSource() == this.buttonConfigurarTexto) {
                this.configurarMensagem();
            } else if (e.getSource() == this.buttonSalvar) {
                if (this.validaCNPJ()) {
                    this.setVisible(false);
                    this.ok = e.getSource() == this.buttonSalvar;
                } else {
                    this.textCNPJ.requestFocus();
                }
            } else {
                this.setVisible(false);
                this.ok = e.getSource() == this.buttonSalvar;
            }
        }

        public boolean validaCNPJ() {
            if (!Funcoes.textoVazio(this.textCNPJ) && !ValidaDoc.checkDoc(this.textCNPJ.getText(), 7)) {
                Funcoes.mensagem(this, "CNPJ inv\u00e1lido!", 1);
                return false;
            }
            return true;
        }

        private void configurarMensagem() {
            DialogoConfigurador conf = new DialogoConfigurador((Dialog)this, "Configurando mensagem de situa\u00e7\u00e3o do exame", true, false);
            if (conf != null) {
                conf.setTipoConfiguracao(0);
                conf.setAtributos(this.mensagemSituacaoExame);
                conf.setVisible(true);
                if (conf.ok()) {
                    this.mensagemSituacaoExame = conf.getAtributos();
                }
                conf.dispose();
            }
        }

        public boolean ok() {
            return this.ok;
        }

        public void setXML(Registro r) {
            this.comboQualidadePDF.setSelectedItem(120);
            if (r != null) {
                this.txtNumeroPrestador.setText(r.getString(IPERGS.TAG_NUMERO_PRESTADOR));
                this.txtNomePrestador.setText(r.getString(IPERGS.TAG_NOME_PRESTADOR));
                this.txtCodigoPrestador.setText(r.getString(IPERGS.TAG_CODIGO_PRESTADOR));
                this.txtTipoPrestador.setText(r.getString(IPERGS.TAG_TIPO_PRESTADOR));
                this.checkIgnorarSituacaoExame.setSelected(r.getBoolean(IPERGS.TAG_IGNORAR_SITUACAO_EXAME));
                this.checkEnviarDataFatura.setSelected(r.getBoolean(IPERGS.TAG_ENVIAR_DATA_FATURA));
                this.mensagemSituacaoExame = r.getString(IPERGS.TAG_MSG_SITUACAO_EXAME);
                this.buttonConfigurarTexto.setEnabled(this.checkIgnorarSituacaoExame.isSelected());
                this.textContadorNota.setText(r.possuiCampo(IPERGS.TAG_CONTADOR_NOTA) ? r.getString(IPERGS.TAG_CONTADOR_NOTA) : "1");
                this.textCNPJ.setText(r.getString(IPERGS.TAG_CNPJ_FILIAL));
                this.comboQualidadePDF.setSelectedItem(r.getInt(IPERGS.TAG_QUALIDADE_PDF));
            }
        }

        public String getCNPJ() {
            return this.textCNPJ.getText();
        }

        public String getNumeroPrestador() {
            return this.txtNumeroPrestador.getText();
        }

        public String getNomePrestador() {
            return this.txtNomePrestador.getText();
        }

        public String getCodigoPrestador() {
            return this.txtCodigoPrestador.getText();
        }

        public String getTipoPrestador() {
            return this.txtTipoPrestador.getText();
        }

        public String getContadorNota() {
            return this.textContadorNota.getText();
        }

        public boolean isIgnorarSituacaoExame() {
            return this.checkIgnorarSituacaoExame.isSelected();
        }

        public boolean isEnviarDataFatura() {
            return this.checkEnviarDataFatura.isSelected();
        }

        public String getMensagemSituacaoExame() {
            return this.mensagemSituacaoExame;
        }

        public Integer getQualidadePDF() {
            return (Integer)this.comboQualidadePDF.getSelectedItem();
        }
    }
}

