/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ArquivoFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ConfiguradorICS;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.GuiaVirtual;
import jalis.laboratorio.util.faturamento.eletronico.JanelaConfiguracaoFaturamentoBPA;
import jalis.util.ConvenioUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class ICS
extends AbstractFaturamentoEletronico
implements FaturamentoEletronico {
    private Registro config = null;
    private StringBuilder conteudo = new StringBuilder();
    private int contador = 1;
    private static final String[] CARACTERES_PROIBIDOS = new String[]{",", ".", "/", "-"};
    private static final String[] CARACTERES_PROIBIDOS_ESPACAMENTO = new String[]{",", ".", "/", "-", " "};
    private String QUEBRA_LINHA = System.getProperty("line.separator");
    private final int ESPECIALIDADE = 0;
    private final Campos HEADER_TIPO_REGISTRO = new Campos(1, 1, "I");
    private final Campos HEADER_CODIGO_CONTRATADO = new Campos(2, 7, "I");
    private final Campos HEADER_RAZAO_SOCIAL_CONTRATADO = new Campos(8, 47, "S");
    private final Campos HEADER_SEQUENCIA_ENVIO = new Campos(48, 53, "I");
    private final Campos HEADER_FIXO = new Campos(54, 55, "S");
    private final Campos HEADER_SEQUENCIAL_REGISTROS = new Campos(56, 61, "I");
    private final Campos USUARIO_TIPO_REGISTRO = new Campos(1, 1, "I");
    private final Campos USUARIO_NUMERO_SENHA = new Campos(2, 8, "I");
    private final Campos USUARIO_NUMERO_CARTEIRA = new Campos(9, 14, "I");
    private final Campos USUARIO_TIPO_ATENDIMENTO = new Campos(15, 15, "I");
    private final Campos USUARIO_CAUSA = new Campos(16, 16, "I");
    private final Campos USUARIO_PACIENTE_INTERNADO = new Campos(17, 17, "B");
    private final Campos USUARIO_BRANCO = new Campos(18, 25, "S");
    private final Campos USUARIO_NOME_PACIENTE = new Campos(26, 55, "S");
    private final Campos USUARIO_SEQUENCIAL_REGISTROS = new Campos(56, 61, "I");
    private final Campos SERVICO_TIPO_REGISTRO = new Campos(1, 1, "I");
    private final Campos SERVICO_NUMERO_SENHA = new Campos(2, 8, "I");
    private final Campos SERVICO_CODIGO_SERVICO = new Campos(9, 16, "I");
    private final Campos SERVICO_VALOR_SERVICO = new Campos(17, 27, "E");
    private final Campos SERVICO_DATA_SERVICO = new Campos(28, 33, "D");
    private final Campos SERVICO_CODIGO_DENTE = new Campos(34, 35, "S");
    private final Campos SERVICO_FACES_DENTE = new Campos(36, 40, "S");
    private final Campos SERVICO_QUANTIDADE_SERVICOS = new Campos(41, 45, "E");
    private final Campos SERVICO_HORA_ATENDIMENTO = new Campos(46, 50, "H");
    private final Campos SERVICO_ESPECIALIDADE = new Campos(51, 53, "I");
    private final Campos SERVICO_LOCAL_ATENDIMENTO = new Campos(54, 54, "I");
    private final Campos SERVICO_BRANCO = new Campos(55, 55, "S");
    private final Campos SERVICO_SEQUENCIAL_REGISTROS = new Campos(56, 61, "I");
    private final Campos CID_TIPO_REGISTRO = new Campos(1, 1, "I");
    private final Campos CID_NUMERO_SENHA = new Campos(2, 8, "I");
    private final Campos CID_CODIGO_CID = new Campos(9, 12, "S");
    private final Campos CID_BRANCOS = new Campos(13, 55, "S");
    private final Campos CID_SEQUENCIAL_REGISTROS = new Campos(56, 61, "I");
    private final Campos MEDICO_TIPO_REGISTRO = new Campos(1, 1, "I");
    private final Campos MEDICO_NUMERO_SENHA = new Campos(2, 8, "I");
    private final Campos MEDICO_CONSELHO = new Campos(9, 9, "S");
    private final Campos MEDICO_NUMERO_CONSELHO = new Campos(10, 14, "I");
    private final Campos MEDICO_COMPLEMENTO_NUMERO = new Campos(15, 19, "S");
    private final Campos MEDICO_NOME_PROFISSIONAL = new Campos(20, 46, "S");
    private final Campos MEDICO_INDICADOR_PROFISSIONAL = new Campos(47, 47, "S");
    private final Campos MEDICO_CODIGO_PROCEDIMENTO_PARTICIPACAO = new Campos(48, 55, "I");
    private final Campos MEDICO_SEQUENCIAL_REGISTROS = new Campos(56, 61, "I");
    private final Campos FINALIZACAO_TIPO_REGISTRO = new Campos(1, 1, "I");
    private final Campos FINALIZACAO_BRANCOS = new Campos(2, 55, "S");
    private final Campos FINALIZACAO_SEQUENCIAL_REGISTROS = new Campos(56, 61, "I");
    private PreparedStatement psFatura = null;
    private PreparedStatement psCid10 = null;

    public ICS() {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fre.req_codigo as requisicao ");
        buf.append("       ,fre.fil_kodigo as filial ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append(" ,dtm.dtm_codamb as ambExame ");
        } else {
            buf.append(" ,det.dtp_codamb as ambExame ");
        }
        buf.append("       ,fer.fer_total as valorExame ");
        buf.append("       ,COALESCE(exr.exr_guia, req.req_guia, req.req_guiaprincipal, '') as guia ");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.req_hora as horaRequisicao ");
        buf.append("       ,req.med_conselho as conselhoMedico ");
        buf.append("       ,req.med_crm as crmMedico ");
        buf.append("       ,req.med_uf as ufMedico ");
        buf.append("       ,med.med_nome as nomeMedico ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,COALESCE(req.req_matricula, '') as matriculaPaciente ");
        buf.append("       ,req.req_urgente as urgenteRequisicao ");
        buf.append("   from faturarequisicao fre ");
        buf.append("   join fatura fat on fre.fil_codigo = fat.fil_codigo and fre.fat_codigo = fat.fat_codigo ");
        buf.append("   join faturaexamerequisicao fer on fre.fil_codigo = fer.fil_codigo and fre.fat_codigo = fer.fat_codigo and fre.req_codigo = fer.req_codigo and fre.fil_kodigo = fer.fil_kodigo ");
        buf.append("   join requisicao req on fre.fil_kodigo = req.fil_codigo and fre.req_codigo = req.req_codigo ");
        buf.append("   join examerequisicao exr on fer.fil_kodigo = exr.fil_codigo and fer.req_codigo = exr.req_codigo and fer.exa_codigo = exr.exa_codigo and fer.mco_codigo = exr.mco_codigo ");
        buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join medico med on req.fil_codigo = med.fil_codigo and req.med_crm = med.med_crm and req.med_conselho = med.med_conselho and req.med_uf = med.med_uf ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("   join detalhetabelaprecometodologia dtm on req.fil_codigo = dtm.fil_codigo and con.tpe_codigo = dtm.tpe_codigo and fer.exa_codfilho = dtm.exa_codigo and fer.mco_codfilho = dtm.mco_codigo and exr.met_codigo = dtm.met_codigo ");
        } else {
            buf.append("   join detalhetabelapreco det on req.fil_codigo = det.fil_codigo and con.tpe_codigo = det.tpe_codigo and fer.exa_codfilho = det.exa_codigo and fer.mco_codfilho = det.mco_codigo ");
        }
        buf.append("   join exames exa on fre.fil_kodigo = exa.fil_codigo and fer.exa_codfilho = exa.exa_codigo ");
        buf.append("  where fre.fil_codigo = ? ");
        buf.append("    and fre.fat_codigo = ? ");
        buf.append("    and exr.exr_excluido = false ");
        buf.append("    and fat.fat_datacancelamento is null ");
        buf.append("    and not req.req_excluida ");
        buf.append("  order by req.fil_codigo ");
        buf.append("          ,req.req_codigo ");
        buf.append("          ,COALESCE(exr.exr_guia, req.req_guia, req.req_guiaprincipal, '') ");
        this.psFatura = Conexao.getPreparedStatement(buf.toString());
        buf.setLength(0);
        buf.append(" select c10_codigo as cid10 ");
        buf.append("   from requisicaocid10 ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and req_codigo = ? ");
        this.psCid10 = Conexao.getPreparedStatement(buf.toString());
    }

    private String substring(String str, int tamanho) {
        return str.substring(0, str.length() > tamanho ? tamanho : str.length());
    }

    private String getValor(Campos campo, Object valor) throws Exception {
        return this.getValor(campo, valor, 2, RoundingMode.HALF_UP);
    }

    private String getValor(Campos campo, Object valor, int casasDecimais, RoundingMode arredondamentoPreco) throws Exception {
        if (campo == null) {
            throw new Exception("Campo n\u00e3o informado.");
        }
        if (valor == null) {
            if (campo.tipo.equalsIgnoreCase("I") || campo.tipo.equalsIgnoreCase("E")) {
                return Funcoes.preencheZero(0, campo.tamanho);
            }
            if (campo.tipo.equalsIgnoreCase("B")) {
                return SimNao.NAO.codigo;
            }
            return Funcoes.preencheVazio(" ", campo.tamanho, 1);
        }
        if (campo.tipo.equalsIgnoreCase("E")) {
            if (valor instanceof BigDecimal) {
                valor = ((BigDecimal)valor).setScale(casasDecimais, arredondamentoPreco);
                String aux = StringUtil.limpaString(valor.toString(), CARACTERES_PROIBIDOS);
                return this.substring(Funcoes.preencheZero(aux, campo.tamanho), campo.tamanho);
            }
            throw new Exception("Valor decimal incorreto. Tipo = " + valor.getClass() + ".");
        }
        if (campo.tipo.equalsIgnoreCase("I")) {
            if (valor instanceof Integer) {
                String aux = StringUtil.limpaString(valor.toString(), CARACTERES_PROIBIDOS);
                return this.substring(Funcoes.preencheZero(aux, campo.tamanho), campo.tamanho);
            }
            throw new Exception("Valor inteiro incorreto. Tipo = " + valor.getClass() + ".");
        }
        if (campo.tipo.equalsIgnoreCase("S")) {
            if (valor instanceof String) {
                valor = StringUtil.limpaString(valor.toString(), CARACTERES_PROIBIDOS);
                return this.substring(Funcoes.preencheVazio(valor.toString(), campo.tamanho, 2), campo.tamanho);
            }
            throw new Exception("Valor 'string' incorreto. Tipo = " + valor.getClass() + ".");
        }
        if (campo.tipo.equalsIgnoreCase("D")) {
            if (valor instanceof Date) {
                return this.substring(Funcoes.formataData("ddMMyy", (Date)valor), campo.tamanho);
            }
            throw new Exception("Valor data incorreto. Tipo = " + valor.getClass() + ".");
        }
        if (campo.tipo.equalsIgnoreCase("H")) {
            if (valor instanceof Timestamp) {
                return this.substring(Funcoes.formataData("HH:mm", (Timestamp)valor), campo.tamanho);
            }
            throw new Exception("Valor data incorreto. Tipo = " + valor.getClass() + ".");
        }
        if (campo.tipo.equalsIgnoreCase("B")) {
            if (valor instanceof Boolean) {
                return this.substring((Boolean)valor != false ? SimNao.SIM.codigo : SimNao.NAO.codigo, campo.tamanho);
            }
            throw new Exception("Valor 'SIM/N\u00c3O' incorreto. Tipo = " + valor.getClass() + ".");
        }
        throw new Exception("Tipo de dado desconhecido.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<ArquivoFaturamentoEletronico> criarArquivo(Object owner, int codigoFatura, String codigoConvenio, String diretorioArquivos) {
        ArrayList<ArquivoFaturamentoEletronico> retorno;
        Statement st;
        block7: {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            retorno = new ArrayList<ArquivoFaturamentoEletronico>();
            try {
                buf.append(" select fat.con_codigo  ");
                buf.append("       ,con.con_faturaeletronica ");
                buf.append("   from fatura fat ");
                buf.append("   join convenios con on fat.fil_codigo = con.fil_codigo and fat.con_codigo = con.con_codigo ");
                buf.append("  where fat.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and fat.fat_codigo = ").append(codigoFatura);
                buf.append("    and fat.fat_datacancelamento is null ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (rs.next()) {
                    this.config = this.parseXMLConfiguracao(rs.getString("con_faturaeletronica"));
                    this.config.setValor("con_codigo", rs.getString("con_codigo"));
                }
                if (this.config == null) break block7;
                retorno = this.gerarArquivo(codigoFatura, codigoConvenio);
                buf.delete(0, buf.length());
                buf.append(" update convenios ");
                buf.append("    set con_faturaeletronica = '").append(StringUtil.textoDB(this.registroToXML(this.config))).append("' ");
                buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and con_codigo = ").append(this.config.getValor("con_codigo"));
                Conexao.execute(Variaveis.filialPadrao, st, buf);
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ArquivoFaturamentoEletronico> gerarArquivo(int codigoFatura, String codigoConvenio) throws Exception {
        if (this.config == null) {
            throw new Exception("XML de configura\u00e7\u00e3o n\u00e3o informado.");
        }
        this.escreveHeader(this.config.getString("codigoContratado"), this.config.getString("razaoSocialContratado"), this.config.getString("sequencialArquivo"));
        this.psFatura.setInt(1, Integer.parseInt(Variaveis.filialPadrao));
        this.psFatura.setInt(2, codigoFatura);
        ResultSet rsFatura = this.psFatura.executeQuery();
        boolean hasMore = false;
        while (rsFatura.next()) {
            Integer filial = rsFatura.getInt("filial");
            Integer requisicao = rsFatura.getInt("requisicao");
            String guia = rsFatura.getString("guia");
            String numeroGuiaAux = StringUtil.limpaString(rsFatura.getString("guia"), CARACTERES_PROIBIDOS_ESPACAMENTO);
            numeroGuiaAux = this.substring(numeroGuiaAux, this.USUARIO_NUMERO_SENHA.tamanho);
            Integer numeroGuia = null;
            if (Funcoes.isNumeric(numeroGuiaAux)) {
                numeroGuia = Integer.parseInt(numeroGuiaAux);
            }
            this.escreveUsuario(rsFatura, numeroGuia);
            int casasDecimais = ParametrosGerais.getCasasPrecoExame();
            RoundingMode arredondamentoPreco = ParametrosGerais.getArredondamentoPrecoExame();
            DadosConvenios dadosConvenios = ConvenioUtil.getDadosConvenios(rsFatura.getString("filial"), Integer.parseInt(codigoConvenio));
            if (!Funcoes.objectIsNull(dadosConvenios) && dadosConvenios.getConvenioUtilizarCasasDecimais()) {
                casasDecimais = dadosConvenios.getConvenioCasasPrecoExame();
                arredondamentoPreco = dadosConvenios.getConvenioTipoArredondamentoPrecoRoundingMode();
            }
            do {
                String guiaAux = rsFatura.getString("guia");
                Integer filialAux = rsFatura.getInt("filial");
                Integer requisicaoAux = rsFatura.getInt("requisicao");
                if (!(filial.equals(filialAux) && requisicao.equals(requisicaoAux) && guia.equalsIgnoreCase(guiaAux))) {
                    guia = guiaAux;
                    rsFatura.previous();
                    break;
                }
                this.escreveServico(rsFatura, numeroGuia, casasDecimais, arredondamentoPreco);
            } while (hasMore = rsFatura.next());
            if (!hasMore) {
                rsFatura.previous();
            }
            this.psCid10.setInt(1, rsFatura.getInt("filial"));
            this.psCid10.setInt(2, rsFatura.getInt("requisicao"));
            try (ResultSet rsCid10 = null;){
                rsCid10 = this.psCid10.executeQuery();
                while (rsCid10.next()) {
                    this.escreveCid10(rsCid10, numeroGuia);
                }
            }
            this.escreveMedico(rsFatura, numeroGuia);
            if (hasMore) continue;
            break;
        }
        this.escreveFinalizacao();
        int aux = (Integer)this.config.getValor("sequencialArquivo");
        aux = aux <= 0 ? 1 : aux;
        StringBuilder nomeArquivo = new StringBuilder();
        nomeArquivo.append("IC");
        nomeArquivo.append(this.config.getValor("codigoContratado"));
        nomeArquivo.append(".");
        nomeArquivo.append(Funcoes.preencheZero(aux, 3));
        ArrayList<ArquivoFaturamentoEletronico> retorno = new ArrayList<ArquivoFaturamentoEletronico>();
        retorno.add(new ArquivoFaturamentoEletronico(nomeArquivo.toString(), this.conteudo.toString()));
        this.config.setValor("sequencialArquivo", ++aux);
        return retorno;
    }

    private void escreveHeader(String codigoContratado, String razaoSocialContratado, String sequencialArquivo) throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es do faturamento eletr\u00f4nico n\u00e3o foram carregadas.", 2);
            return;
        }
        StringBuilder aux = new StringBuilder();
        aux.append(this.getValor(this.HEADER_TIPO_REGISTRO, TipoRegistro.HEADER.codigo));
        aux.append(this.getValor(this.HEADER_CODIGO_CONTRATADO, Integer.parseInt(codigoContratado)));
        aux.append(this.getValor(this.HEADER_RAZAO_SOCIAL_CONTRATADO, razaoSocialContratado));
        aux.append(this.getValor(this.HEADER_SEQUENCIA_ENVIO, Integer.parseInt(sequencialArquivo)));
        aux.append(this.getValor(this.HEADER_FIXO, "NV"));
        aux.append(this.getValor(this.HEADER_SEQUENCIAL_REGISTROS, this.contador++));
        this.conteudo.append((CharSequence)aux);
        this.conteudo.append(this.QUEBRA_LINHA);
    }

    private void escreveUsuario(ResultSet rs, Integer numeroGuia) throws Exception {
        String numeroCarteirinhaAux = StringUtil.limpaString(rs.getString("matriculaPaciente"), CARACTERES_PROIBIDOS_ESPACAMENTO);
        numeroCarteirinhaAux = this.substring(numeroCarteirinhaAux, this.USUARIO_NUMERO_CARTEIRA.tamanho);
        Integer numeroCarteirinha = null;
        if (Funcoes.isNumeric(numeroCarteirinhaAux)) {
            numeroCarteirinha = Integer.parseInt(numeroCarteirinhaAux);
        }
        StringBuilder aux = new StringBuilder();
        aux.append(this.getValor(this.USUARIO_TIPO_REGISTRO, TipoRegistro.USUARIO.codigo));
        aux.append(this.getValor(this.USUARIO_NUMERO_SENHA, numeroGuia));
        aux.append(this.getValor(this.USUARIO_NUMERO_CARTEIRA, numeroCarteirinha));
        aux.append(this.getValor(this.USUARIO_TIPO_ATENDIMENTO, rs.getBoolean("urgenteRequisicao") ? TipoAtendimento.URGENCIA_EMERGENCIA.codigo : TipoAtendimento.ELETIVO.codigo));
        aux.append(this.getValor(this.USUARIO_CAUSA, Causa.OUTROS.codigo));
        aux.append(this.getValor(this.USUARIO_PACIENTE_INTERNADO, false));
        aux.append(this.getValor(this.USUARIO_BRANCO, null));
        aux.append(this.getValor(this.USUARIO_NOME_PACIENTE, rs.getString("nomePaciente")));
        aux.append(this.getValor(this.USUARIO_SEQUENCIAL_REGISTROS, this.contador++));
        this.conteudo.append((CharSequence)aux);
        this.conteudo.append(this.QUEBRA_LINHA);
    }

    private void escreveServico(ResultSet rsExameRequisicao, Integer numeroGuia, int casasDecimais, RoundingMode arredondamentoPreco) throws Exception {
        String ambAux = StringUtil.limpaString(rsExameRequisicao.getString("ambExame"), CARACTERES_PROIBIDOS).trim();
        Integer amb = null;
        if (Funcoes.isNumeric(ambAux)) {
            amb = Integer.parseInt(ambAux);
        }
        StringBuilder aux = new StringBuilder();
        aux.append(this.getValor(this.SERVICO_TIPO_REGISTRO, TipoRegistro.SERVICO.codigo));
        aux.append(this.getValor(this.SERVICO_NUMERO_SENHA, numeroGuia));
        aux.append(this.getValor(this.SERVICO_CODIGO_SERVICO, amb));
        aux.append(this.getValor(this.SERVICO_VALOR_SERVICO, rsExameRequisicao.getBigDecimal("valorExame"), casasDecimais, arredondamentoPreco));
        aux.append(this.getValor(this.SERVICO_DATA_SERVICO, rsExameRequisicao.getDate("dataRequisicao")));
        aux.append(this.getValor(this.SERVICO_CODIGO_DENTE, null));
        aux.append(this.getValor(this.SERVICO_FACES_DENTE, null));
        aux.append(this.getValor(this.SERVICO_QUANTIDADE_SERVICOS, new BigDecimal("1")));
        aux.append(this.getValor(this.SERVICO_HORA_ATENDIMENTO, rsExameRequisicao.getTimestamp("horaRequisicao")));
        aux.append(this.getValor(this.SERVICO_ESPECIALIDADE, 0));
        aux.append(this.getValor(this.SERVICO_LOCAL_ATENDIMENTO, LocalAtendimento.CONSULTORIO.codigo));
        aux.append(this.getValor(this.SERVICO_BRANCO, null));
        aux.append(this.getValor(this.SERVICO_SEQUENCIAL_REGISTROS, this.contador++));
        this.conteudo.append((CharSequence)aux);
        this.conteudo.append(this.QUEBRA_LINHA);
    }

    private void escreveCid10(ResultSet rs, Integer numeroGuia) throws Exception {
        StringBuilder aux = new StringBuilder();
        aux.append(this.getValor(this.CID_TIPO_REGISTRO, TipoRegistro.CID.codigo));
        aux.append(this.getValor(this.CID_NUMERO_SENHA, numeroGuia));
        aux.append(this.getValor(this.CID_CODIGO_CID, rs.getString("cid10")));
        aux.append(this.getValor(this.CID_BRANCOS, null));
        aux.append(this.getValor(this.CID_SEQUENCIAL_REGISTROS, this.contador++));
        this.conteudo.append((CharSequence)aux);
        this.conteudo.append(this.QUEBRA_LINHA);
    }

    private void escreveMedico(ResultSet rs, Integer numeroGuia) throws Exception {
        StringBuilder aux = new StringBuilder();
        aux.append(this.getValor(this.MEDICO_TIPO_REGISTRO, TipoRegistro.MEDICO.codigo));
        aux.append(this.getValor(this.MEDICO_NUMERO_SENHA, numeroGuia));
        aux.append(this.getValor(this.MEDICO_CONSELHO, Conselho.getCodigo(rs.getString("conselhoMedico"))));
        aux.append(this.getValor(this.MEDICO_NUMERO_CONSELHO, rs.getInt("crmMedico")));
        aux.append(this.getValor(this.MEDICO_COMPLEMENTO_NUMERO, rs.getString("ufMedico")));
        aux.append(this.getValor(this.MEDICO_NOME_PROFISSIONAL, rs.getString("nomeMedico")));
        aux.append(this.getValor(this.MEDICO_INDICADOR_PROFISSIONAL, IndicadorProfissional.SOLICITANTE.codigo));
        aux.append(this.getValor(this.MEDICO_CODIGO_PROCEDIMENTO_PARTICIPACAO, null));
        aux.append(this.getValor(this.MEDICO_SEQUENCIAL_REGISTROS, this.contador++));
        this.conteudo.append((CharSequence)aux);
        this.conteudo.append(this.QUEBRA_LINHA);
    }

    private void escreveFinalizacao() throws Exception {
        StringBuilder aux = new StringBuilder();
        aux.append(this.getValor(this.FINALIZACAO_TIPO_REGISTRO, TipoRegistro.FINALIZACAO.codigo));
        aux.append(this.getValor(this.FINALIZACAO_BRANCOS, null));
        aux.append(this.getValor(this.FINALIZACAO_SEQUENCIAL_REGISTROS, this.contador++));
        this.conteudo.append((CharSequence)aux);
    }

    @Override
    public Registro parseXMLConfiguracao(String xml) {
        Registro r = new Registro();
        r.setValor("codigoContratado", StringUtil.getValor(xml, "codigoContratado"));
        r.setValor("razaoSocialContratado", StringUtil.getValor(xml, "razaoSocialContratado"));
        String sequencialArquivo = StringUtil.getValor(xml, "sequencialArquivo");
        r.setValor("sequencialArquivo", Funcoes.isNumeric(sequencialArquivo) ? Integer.parseInt(sequencialArquivo) : 0);
        return r;
    }

    private String registroToXML(Registro r) {
        StringBuilder buf = new StringBuilder("<faturamentoEletronico>");
        buf.append("<protocolo>").append(ICS.getNomeProtocolo()).append("</protocolo>");
        buf.append(StringUtil.getTag("codigoContratado", r.getValor("codigoContratado").toString()));
        buf.append(StringUtil.getTag("razaoSocialContratado", r.getValor("razaoSocialContratado").toString()));
        buf.append(StringUtil.getTag("sequencialArquivo", r.getValor("sequencialArquivo").toString()));
        buf.append("</faturamentoEletronico>");
        return buf.toString();
    }

    public String configurar(JDialog parent, String xml) {
        String retorno = xml;
        ConfiguradorICS conf = new ConfiguradorICS(parent);
        conf.setXML(xml);
        conf.setVisible(true);
        if (conf.ok()) {
            retorno = conf.getXML();
            this.config = this.parseXMLConfiguracao(retorno);
        }
        return retorno;
    }

    @Override
    public String configurar(JFrame parent, String xml) {
        String retorno = xml;
        ConfiguradorICS conf = new ConfiguradorICS(parent);
        conf.setXML(xml);
        conf.setVisible(true);
        if (conf.ok()) {
            retorno = conf.getXML();
            this.config = this.parseXMLConfiguracao(retorno);
        }
        return retorno;
    }

    @Override
    public boolean solicitarDiretorioNoInicio() {
        return true;
    }

    @Override
    public String[] situacoesPermitidasExame(String xml) {
        return null;
    }

    @Override
    public boolean validarCasasDecimais() {
        return true;
    }

    public static String getNomeProtocolo() {
        return "ICS";
    }

    public static String getExtensaoArquivo() {
        return null;
    }

    @Override
    public String getCodificacaoArquivo() {
        return FaturamentoEletronico.CODIFICACAO.ISO_8859_1.codificacao;
    }

    @Override
    public void verificaErrosFatura(ArrayList<DadosFaturamento> requisicoes, Registro configuracaoConvenio) {
    }

    @Override
    @Deprecated
    public ArrayList<GuiaVirtual.Campo> getCamposObrigatorios(String versao) {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasSolicitados() {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasExecutados() {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampo> getCamposIncorretos(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasSolicitados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasExecutados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public boolean gravaAlteracoes(DadosFaturamento requisicao, String guia, Registro configuracao) {
        return false;
    }

    @Override
    public void preencheValoresCampos(DadosFaturamento requisicao, Registro configuracaoEletronico, String guia) {
    }

    @Override
    public void preencheValoresTabelas(DadosFaturamento requisicao, String guia) {
    }

    @Override
    public void getValoresPreenchidos(DadosFaturamento requisicao, ArrayList<DadosExameFaturamento> exames, Registro configuracaoEletronico) {
    }

    @Override
    public void aplicarModificacoesGerais(ArrayList<DadosFaturamento> requisicoes, DadosFaturamento requisicao, DadosFaturamento requisicaoModificada, Registro configuracaoEletronico, Registro configuracaoEletronicoModificada) {
    }

    @Override
    public Object[] getListaDadosAdicionais() {
        return null;
    }

    @Override
    public void setListaDadosAdicionais(Object[] listaDadosAdicionais) {
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampoBPA> getCamposIncorretosBPA(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<JanelaConfiguracaoFaturamentoBPA.CampoBPA> getCamposObrigatoriosBPA() {
        return null;
    }

    private static enum SimNao {
        SIM("S"),
        NAO("N");

        String codigo = null;

        private SimNao(String codigo) {
            this.codigo = codigo;
        }
    }

    private static enum IndicadorProfissional {
        SOLICITANTE("S"),
        ASSISTENTE("A"),
        ANESTESIA("C"),
        PRIMEIRO_AUXILIAR("1"),
        SEGUNDO_AUXILIAR("2"),
        OUTROS("O");

        String codigo = null;

        private IndicadorProfissional(String codigo) {
            this.codigo = codigo;
        }
    }

    private static enum Conselho {
        MEDICINA("1", "CRM"),
        ODONTOLOGIA("2", "CRO"),
        FISIOTERAPIA("3", "CREFITO"),
        FONOAUDIOLOGIA("4", "CRFA"),
        FARMACIA("5", "CRF"),
        PSICOLOGIA("6", "CRP"),
        NUTRICAO("7", "CRN");

        String codigo = null;
        String conselho = null;

        private Conselho(String codigo, String conselho) {
            this.codigo = codigo;
            this.conselho = conselho;
        }

        public static String getCodigo(String conselho) {
            if (!Funcoes.textoVazio(conselho)) {
                for (Conselho aux : Conselho.values()) {
                    if (!aux.conselho.equalsIgnoreCase(conselho)) continue;
                    return aux.codigo;
                }
            }
            return null;
        }
    }

    private static enum LocalAtendimento {
        CONSULTORIO(1),
        HOSPITAL(2);

        Integer codigo = null;

        private LocalAtendimento(int codigo) {
            this.codigo = codigo;
        }
    }

    private static enum TipoRegistro {
        HEADER(1),
        USUARIO(2),
        SERVICO(3),
        CID(4),
        MEDICO(5),
        MATERIAL_MEDICAMENTO(6),
        FINALIZACAO(9);

        Integer codigo = null;

        private TipoRegistro(int codigo) {
            this.codigo = codigo;
        }
    }

    private static enum Causa {
        OUTROS(0),
        ACIDENTE(1),
        DOENCA(2);

        Integer codigo = null;

        private Causa(int codigo) {
            this.codigo = codigo;
        }
    }

    private static enum TipoAtendimento {
        ELETIVO(1),
        URGENCIA_EMERGENCIA(2);

        Integer codigo = null;

        private TipoAtendimento(int codigo) {
            this.codigo = codigo;
        }
    }

    class Campos {
        public static final String TIPO_STRING = "S";
        public static final String TIPO_INTEIRO = "I";
        public static final String TIPO_DATA = "D";
        public static final String TIPO_HORA = "H";
        public static final String TIPO_BOOLEAN = "B";
        public static final String TIPO_DECIMAL = "E";
        int posIni = -1;
        int posFim = -1;
        int tamanho = -1;
        String tipo = "S";

        public Campos(int posicaoInicial, int posicaoFinal, String tipo) {
            this.posIni = posicaoInicial;
            this.posFim = posicaoFinal;
            this.tamanho = posicaoFinal - posicaoInicial + 1;
            this.tipo = tipo;
        }
    }
}

